﻿using System.Windows.Media;
using Syncfusion.Windows.Shared;

namespace RibbonOfficeSample.ViewModel.Themes
{

    public enum ThemeEnum
    {
        Windows11Light,
        Windows11Dark,
        MaterialLight,
        MaterialDark,
        SystemTheme,

        FluentLight,
        FluentDark,
    }



    public class Theme:NotificationObject
    {
        private ThemeEnum themeEnum;
        /// <summary>
        /// Denotes the name of the theme
        /// </summary>
        public ThemeEnum ThemeEnum
        {
            get { return themeEnum; }
            set
            {
                themeEnum = value;
                RaisePropertyChanged(nameof(ThemeEnum));
            }
        }

        private string themeType;
        /// <summary>
        /// Denotes the Type of the theme
        /// </summary>
        public string ThemeType
        {
            get { return themeType; }
            set
            {
                themeType = value;
                RaisePropertyChanged(nameof(ThemeType));
            }
        }

        private Brush ellipsefill;
        /// <summary>
        /// Denotes the color to be filled in the ellipse
        /// </summary>
        public Brush EllipseFill
        {
            get { return ellipsefill; }
            set
            {
                ellipsefill = value;
                RaisePropertyChanged(nameof(EllipseFill));
            }
        }

        private Brush ellipsestroke;
        /// <summary>
        /// denotes the color to be filled in the stroke of the ellipse
        /// </summary>
        public Brush EllipseStroke
        {
            get { return ellipsestroke; }
            set
            {
                ellipsestroke = value;
                RaisePropertyChanged(nameof(EllipseStroke));
            }
        }
        private Brush pathfill;
        /// <summary>
        /// denotes the color to be applied in the path
        /// </summary>
        public Brush PathFill
        {
            get { return pathfill; }
            set
            {
                pathfill = value;
                RaisePropertyChanged(nameof(PathFill));
            }
        }

        private string displayName;
        /// <summary>
        /// denotes the name to be displayed in the UI
        /// </summary>
        public string DisplayName
        {
            get { return displayName; }
            set
            {
                displayName = value;
                RaisePropertyChanged(nameof(DisplayName));
            }
        }
    }
}