﻿using System.Windows.Media;

namespace RibbonOfficeSample.ViewModel.Themes
{
    public class Palette
    {
        private string name;
        /// <summary>
        /// Denotes the palette name
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        private ThemeEnum theme;
        /// <summary>
        /// Denotes the Theme Name
        /// </summary>
        public ThemeEnum Theme
        {
            get { return theme; }
            set { theme = value; }
        }

        private Brush primaryBackground;
        /// <summary>
        /// Denotes the palette primary background brush
        /// </summary>
        public Brush PrimaryBackground
        {
            get { return primaryBackground; }
            set { primaryBackground = value; }
        }

        private Brush primaryForeground;
        /// <summary>
        /// Denotes the palette primary foreground brush
        /// </summary>
        public Brush PrimaryForeground
        {
            get { return primaryForeground; }
            set { primaryForeground = value; }
        }

        private Brush primaryBackgroundAlt;
        /// <summary>
        /// Denotes the palette primay alternate background brush
        /// </summary>
        public Brush PrimaryBackgroundAlt
        {
            get { return primaryBackgroundAlt; }
            set { primaryBackgroundAlt = value; }
        }

        private string displayName;
        /// <summary>
        /// denotes the name to be displayed in the UI
        /// </summary>
        public string DisplayName
        {
            get { return displayName; }
            set { displayName = value; }
        }

    }
}