﻿using System.Collections.ObjectModel;

namespace RibbonOfficeSample.ViewModel.Ribbons
{
    public class Tab
    {
        public string Header { get; set; }
        public string IconKey { get; set; }

        public ObservableCollection<Group> Groups { get; set; }
    }


    public class HomeTab : Tab
    {
        public HomeTab()
        {
            Header = "Home";
            IconKey = "Ribbon_Home";
            Groups=new ObservableCollection<Group>();
            Groups.Add(new Group()
            {
                Header = "aa",
                IsVisible = true,
                Buttons = new ObservableCollection<IRibbonItem>()
                {
                    new SimpleButton(),
                }
            });
        }
    }

    public class ContextTab : Tab
    {
        public ContextTab()
        {
            Header="Contact";
            IconKey = "Ribbon_Home";
            Groups = new ObservableCollection<Group>();
            Groups.Add(new Group()
            {
                Header = "aa",
                IsVisible = true,
                Buttons = new ObservableCollection<IRibbonItem>()
                {
                    new SimpleButton(),
                }
            });
        }
    }


    public class InsertTab : Tab
    {
        public InsertTab(MainWindowViewModel mainWindow)
        {
            Header = "Insert";
            IconKey = "Ribbon_Insert";
            Groups=new ObservableCollection<Group>();
            Groups.Add(new Group()
            {
                Header = "bb",
                IsVisible = true,
                Buttons = new ObservableCollection<IRibbonItem>()
                {
                    new SimpleButton(),
                    new ThemeButton(mainWindow),
                }
            });
        }
    }
}