﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Windows.Media;

namespace RibbonOfficeSample.ViewModel.Ribbons
{
    public class MainRibbonControl
    {
        public MainWindowViewModel MainWindow { get; }

        public MainRibbonControl(MainWindowViewModel mainWindow)
        {
            MainWindow = mainWindow;
            BackStage = new BackStage.BackStage();
            MenuTabs = new List<Tab>()
            {
                new HomeTab(),
                new InsertTab(mainWindow),
            };
            ContextTabGroups.Add(new ContextTabGroup()
            {
                Color = Colors.BlueViolet,
                IsVisible = true,
                Tabs = new ObservableCollection<Tab>()
                {
                    new ContextTab(),
                }
            });
            Contents = new SomeContent();

        }

        public SomeContent Contents { get; set; }

        public BackStage.BackStage BackStage { get; set; }

        public IEnumerable<Tab> MenuTabs { get; }

       
        public ObservableCollection<ContextTabGroup> ContextTabGroups { get; } = new ObservableCollection<ContextTabGroup>();
        public Tab SelectedTab { get; set; }


    }
}