﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using Syncfusion.Windows.Utils;

namespace RibbonOfficeSample.ViewModel.Ribbons
{
    public class Button:IRibbonItem
    {
        public bool IsEnabled { get; set; }
        public object ToolTip { get; set; }
        public string Label { get; set; }
        public string IconKey { get; set; }
        public Size ButtonSize { get; set; }
        public bool IsSelected { get; set; }

        public ICommand Command { get; set; }

        public bool IsToggle { get; set; }
    }

    public abstract class ToggleButton : Button
    {
        public ToggleButton() 
        {
            IsToggle = true;
        }
    }

    public class ThemeButton : Button
    {
        public ThemeButton(MainWindowViewModel mainWindow)
        {
            IconKey = "Ribbon_Palette";
            Label = "Themes";
            ButtonSize = Size.Large;
            IsEnabled = true;
            Command = new DelegateCommand( oo => mainWindow.ThemePanelVisibility= ! mainWindow.ThemePanelVisibility );

        }
    }





    public class SimpleButton : Button
    {
        public SimpleButton()
        {
            IsEnabled = true;

            Label = "储存";
            IconKey = "BackStage_Save";
            ButtonSize = Size.Large;
            Command = new DelegateCommand(oo => MessageBox.Show("Save click"));
        }
    }
}
