﻿using System.Collections.ObjectModel;
using Syncfusion.Windows.Shared;
using System.Windows;
using System.Windows.Media;
using RibbonOfficeSample.ViewModel.Themes;
using Syncfusion.SfSkinManager;
using System.Reflection;
using System;
using System.Linq;
using Theme = RibbonOfficeSample.ViewModel.Themes.Theme;
using System.Collections.Generic;
using System.IO;
using System.Xml;
using System.Windows.Input;
using RibbonOfficeSample.ViewModel.Ribbons;
using Syncfusion.Windows.Tools.Controls;

namespace RibbonOfficeSample.ViewModel
{
    public class MainWindowViewModel: NotificationObject
    {
      
        public MainWindowViewModel()
        {
            RibbonControl = new MainRibbonControl(this);
            _titleBarBackground = new SolidColorBrush(Colors.Green);
            _titleBarForeground = new SolidColorBrush(Colors.GreenYellow);

            PopulatePaletteList();

            _themes = new ObservableCollection<Theme>()
            {
                new Theme{ThemeEnum=ThemeEnum.Windows11Light, DisplayName="Light" , ThemeType="Windows 11 Themes", EllipseFill=(Brush)new BrushConverter().ConvertFromString("#FFFFFF") , EllipseStroke=(Brush)new BrushConverter().ConvertFromString("#E5E5E5"), PathFill=(Brush)new BrushConverter().ConvertFromString("#005FB8")},
                new Theme{ThemeEnum=ThemeEnum.Windows11Dark ,DisplayName="Dark" , ThemeType="Windows 11 Themes",EllipseFill=(Brush)new BrushConverter().ConvertFromString("#202020") , EllipseStroke=(Brush)new BrushConverter().ConvertFromString("#333333"), PathFill=(Brush)new BrushConverter().ConvertFromString("#60CDFF")},
                new Theme{ThemeEnum=ThemeEnum.MaterialLight,DisplayName="Light", ThemeType="Material Themes",EllipseFill=(Brush)new BrushConverter().ConvertFromString("#FFFFFF") , EllipseStroke=(Brush)new BrushConverter().ConvertFromString("#E9E9E9"), PathFill=(Brush)new BrushConverter().ConvertFromString("#0077FF")},
                new Theme{ThemeEnum=ThemeEnum.MaterialDark, DisplayName="Dark" ,ThemeType="Material Themes",EllipseFill=(Brush)new BrushConverter().ConvertFromString("#848484") , EllipseStroke=(Brush)new BrushConverter().ConvertFromString("#5F5F5F"), PathFill=(Brush)new BrushConverter().ConvertFromString("#0077FF") },

                new Theme{ ThemeEnum=ThemeEnum.FluentLight, DisplayName="Light" , ThemeType="Fluent Themes", EllipseFill=(Brush)new BrushConverter().ConvertFromString("#FFFFFF") , EllipseStroke=(Brush)new BrushConverter().ConvertFromString("#E9E9E9"), PathFill=(Brush)new BrushConverter().ConvertFromString("#0077FF")},
                new Theme{ThemeEnum=ThemeEnum.FluentDark ,DisplayName="Dark" , ThemeType="Fluent Themes",EllipseFill=(Brush)new BrushConverter().ConvertFromString("#313131") , EllipseStroke=(Brush)new BrushConverter().ConvertFromString("#000000"), PathFill=(Brush)new BrushConverter().ConvertFromString("#0077FF")},
            };
            SelectedTheme = _themes.First();
            SelectedPalette = PaletteList.First();
            StatusBarVM = new StatusBarVM();
        }
        private void DoClosing(object parameter)
        {

        }

        private bool CanClose(object parameter)
        {
            return true;
        }
        public ICommand ClosingCommand => new DelegateCommand(DoClosing, CanClose);

        public ICommand ClosedCommand => new DelegateCommand(DoClosing);

        public ICommand CancelClosingCommand => new DelegateCommand(DoClosing);


        public StatusBarVM StatusBarVM { get; set; }
        public MainRibbonControl RibbonControl { get; set; }

        private bool colorpalettevisibility = true;

        /// <summary>
        /// Gets or sets the property value indicating whether the colorpalette combobox should be visible or not
        /// </summary>
        public bool ColorPaletteVisibility
        {
            get { return colorpalettevisibility; }
            set
            {
                colorpalettevisibility = value;
                RaisePropertyChanged(nameof(ColorPaletteVisibility)); // "ColorPaletteVisibility");
            }
        }


        private ObservableCollection<Palette> palettes;

        /// <summary>
        /// Gets or sets the property value indicating the list of colorpalette for the selected Theme.
        /// </summary>
        public ObservableCollection<Palette> Palettes
        {
            get { return palettes; }
            set
            {
                palettes = value;
                RaisePropertyChanged(nameof(Palettes)); // "Palettes");
            }
        }
        private Palette selectedpalette;

        public Palette SelectedPalette
        {
            get { return selectedpalette; }
            set
            {
                selectedpalette = value;
                if (SelectedPalette != null && SelectedPalette.Name != null)
                {
                    OnPaletteChanged(selectedthemename);
                }

                RaisePropertyChanged(nameof(SelectedPalette)); // "SelectedPalette");

            }
        }



        /// <summary>
        /// Method helps to Change the Color palette for the SelectedTheme
        ///
        /// Update the code when Syncfusion #462056 is fixed. todo
        /// </summary>
        /// <param name="themeType">Type of the theme</param>
        /// <param name="theme">Name of the selected theme</param>
        private void changePalette(string themeType, string paletteType, ThemeEnum theme)
        {

            object themeSettings = Activator.CreateInstance(Type.GetType(themeType));
            themeSettings.GetType().GetRuntimeProperty("Palette").SetValue(themeSettings, Enum.Parse(Type.GetType(paletteType), SelectedPalette.Name));
            SfSkinManager.RegisterThemeSettings(theme.ToString(), (IThemeSetting)themeSettings);
        }

        /// <summary>
        /// Method helps to update the selected ColorPalettes
        /// </summary>
        /// <param name="ThemeName">Selected Theme</param>
        private void OnPaletteChanged(ThemeEnum ThemeName)
        {
            switch (ThemeName)
            {
                case ThemeEnum.Windows11Light: // "Windows11Light":
                    {
                        changePalette("Syncfusion.Themes.Windows11Light.WPF.Windows11LightThemeSettings, Syncfusion.Themes.Windows11Light.WPF", "Syncfusion.Themes.Windows11Light.WPF.Windows11Palette, Syncfusion.Themes.Windows11Light.WPF", ThemeName);
                        break;
                    }
                case ThemeEnum.Windows11Dark:
                    {
                        changePalette("Syncfusion.Themes.Windows11Dark.WPF.Windows11DarkThemeSettings, Syncfusion.Themes.Windows11Dark.WPF", "Syncfusion.Themes.Windows11Dark.WPF.Windows11Palette, Syncfusion.Themes.Windows11Dark.WPF", ThemeName);
                        break;
                    }
                case ThemeEnum.FluentLight:
                    {
                        changePalette("Syncfusion.Themes.FluentLight.WPF.FluentLightThemeSettings, Syncfusion.Themes.FluentLight.WPF", "Syncfusion.Themes.FluentLight.WPF.FluentPalette, Syncfusion.Themes.FluentLight.WPF", ThemeName);
                        break;
                    }
                case ThemeEnum.FluentDark:
                    {
                        changePalette("Syncfusion.Themes.FluentDark.WPF.FluentDarkThemeSettings, Syncfusion.Themes.FluentDark.WPF", "Syncfusion.Themes.FluentDark.WPF.FluentPalette, Syncfusion.Themes.FluentDark.WPF", ThemeName);
                        break;
                    }
                //case "MaterialLight":
                //    {
                //        changePalette("Syncfusion.Themes.MaterialLight.WPF.MaterialLightThemeSettings, Syncfusion.Themes.MaterialLight.WPF", "Syncfusion.Themes.MaterialLight.WPF.MaterialPalette, Syncfusion.Themes.MaterialLight.WPF", ThemeName);
                //        break;
                //    }
                //case "MaterialLightBlue":
                //    {
                //        changePalette("Syncfusion.Themes.MaterialLightBlue.WPF.MaterialLightBlueThemeSettings, Syncfusion.Themes.MaterialLightBlue.WPF", "Syncfusion.Themes.MaterialLightBlue.WPF.MaterialPalette, Syncfusion.Themes.MaterialLightBlue.WPF", ThemeName);
                //        break;
                //    }
                //case "MaterialDark":
                //    {
                //        changePalette("Syncfusion.Themes.MaterialDark.WPF.MaterialDarkThemeSettings, Syncfusion.Themes.MaterialDark.WPF", "Syncfusion.Themes.MaterialDark.WPF.MaterialPalette, Syncfusion.Themes.MaterialDark.WPF", ThemeName);
                //        break;
                //    }
                //case "MaterialDarkBlue":
                //    {
                //        changePalette("Syncfusion.Themes.MaterialDarkBlue.WPF.MaterialDarkBlueThemeSettings, Syncfusion.Themes.MaterialDarkBlue.WPF", "Syncfusion.Themes.MaterialDarkBlue.WPF.MaterialPalette, Syncfusion.Themes.MaterialDarkBlue.WPF", ThemeName);
                //        break;
                //    }
                //case "Office2019Colorful":
                //    {
                //        changePalette("Syncfusion.Themes.Office2019Colorful.WPF.Office2019ColorfulThemeSettings, Syncfusion.Themes.Office2019Colorful.WPF", "Syncfusion.Themes.Office2019Colorful.WPF.Office2019Palette, Syncfusion.Themes.Office2019Colorful.WPF", ThemeName);
                //        break;
                //    }
                //case "Office2019Black":
                //    {
                //        changePalette("Syncfusion.Themes.Office2019Black.WPF.Office2019BlackThemeSettings, Syncfusion.Themes.Office2019Black.WPF", "Syncfusion.Themes.Office2019Black.WPF.Office2019Palette, Syncfusion.Themes.Office2019Black.WPF", ThemeName);
                //        break;
                //    }
                //case "Office2019White":
                //    {
                //        changePalette("Syncfusion.Themes.Office2019White.WPF.Office2019WhiteThemeSettings, Syncfusion.Themes.Office2019White.WPF", "Syncfusion.Themes.Office2019White.WPF.Office2019Palette, Syncfusion.Themes.Office2019White.WPF", ThemeName);
                //        break;
                //    }
                //case "Office2019DarkGray":
                //    {
                //        changePalette("Syncfusion.Themes.Office2019DarkGray.WPF.Office2019DarkGrayThemeSettings, Syncfusion.Themes.Office2019DarkGray.WPF", "Syncfusion.Themes.Office2019DarkGray.WPF.Office2019Palette, Syncfusion.Themes.Office2019DarkGray.WPF", ThemeName);
                //        break;

                //    }
                //case "Office2019HighContrast":
                //    {
                //        changePalette("Syncfusion.Themes.Office2019HighContrast.WPF.Office2019HighContrastThemeSettings, Syncfusion.Themes.Office2019HighContrast.WPF", "Syncfusion.Themes.Office2019HighContrast.WPF.HighContrastPalette, Syncfusion.Themes.Office2019HighContrast.WPF", ThemeName);
                //        break;
                //    }
                //case "Office2019HighContrastWhite":
                //    {
                //        changePalette("Syncfusion.Themes.Office2019HighContrastWhite.WPF.Office2019HighContrastWhiteThemeSettings, Syncfusion.Themes.Office2019HighContrastWhite.WPF", "Syncfusion.Themes.Office2019HighContrastWhite.WPF.HighContrastPalette, Syncfusion.Themes.Office2019HighContrastWhite.WPF", ThemeName);
                //        break;
                //    }

            }
            OnThemeChanged(ThemeName);
        }




        private ThemeEnum SelectedThemeName
        {
            get { return selectedthemename; }
            set
            {
                selectedthemename = value;
                if (selectedthemename == ThemeEnum.SystemTheme)
                {
                    ColorPaletteVisibility = false;
                }
                else
                {
                    ColorPaletteVisibility = true;
                    Palettes = new ObservableCollection<Palette>(PaletteList.Where(x => (x.Theme.Equals(selectedthemename))).ToList<Palette>());
                    SelectedPalette = Palettes.Where(x => x.Name.Equals("Default")).ToList<Palette>()[0];
                }
                OnThemeChanged(selectedthemename);
                this.RaisePropertyChanged(nameof(SelectedThemeName));
            }
        }

        /// <summary>
        /// Method helps to populate palette items into Palettelist
        /// </summary>
        void PopulatePaletteList()
        {
            var paletteDetails = new List<Palette>();
            var xml = File.ReadAllText(@"PaletteList.xml");
            XmlDocument Doc = new XmlDocument();
            Doc.LoadXml(xml);
            XmlNodeList xmlnode = Doc.GetElementsByTagName("Palettes");

            for (int i = 0; i <= xmlnode.Count - 1; i++)
            {
                foreach (var node in xmlnode[i].ChildNodes)
                {
                    var element = node as XmlElement;
                    string name = null, theme = null, primaryBackground = null, primaryForeground = null, primaryBackgroundAlt = null, displayname = null;

                    if (element == null || element.Attributes.Count <= 0)
                        continue;

                    name = element.HasAttribute("Name") ? element.Attributes["Name"].Value : string.Empty;
                    theme = element.HasAttribute("Theme") ? element.Attributes["Theme"].Value : string.Empty;

                    primaryBackground = element.HasAttribute("PrimaryBackground") ? element.Attributes["PrimaryBackground"].Value : string.Empty;
                    primaryForeground = element.HasAttribute("PrimaryForeground") ? element.Attributes["PrimaryForeground"].Value : string.Empty;
                    primaryBackgroundAlt = element.HasAttribute("PrimaryBackgroundAlt") ? element.Attributes["PrimaryBackgroundAlt"].Value : string.Empty;
                    displayname = element.HasAttribute("DisplayName") ? element.Attributes["DisplayName"].Value : string.Empty;

                    ThemeEnum themeEnum;
                    var isSuccess = Enum.TryParse(theme, out themeEnum);
                    if (isSuccess)
                    {
                        var palette = new Palette()
                        {
                            Name = name,
                            Theme = themeEnum,
                            DisplayName = displayname,
                            PrimaryBackground = (Brush)new BrushConverter().ConvertFromString(primaryBackground),
                            PrimaryForeground = (Brush)new BrushConverter().ConvertFromString(primaryForeground),
                            PrimaryBackgroundAlt = (Brush)new BrushConverter().ConvertFromString(primaryBackgroundAlt)
                        };
                        paletteDetails.Add(palette);
                    }
                   
                }
            }
            PaletteList = paletteDetails;

        }

        private bool themepanelvisibility = false;

        /// <summary>
        /// Gets or sets the property used to Indicates the visibility of the ThemePanel
        /// </summary>
        public bool ThemePanelVisibility
        {
            get { return themepanelvisibility; }
            set
            {
                themepanelvisibility = value;
                RaisePropertyChanged(nameof(ThemePanelVisibility));
            }
        }


        private bool themebuttonvisibility = true;

        public bool ThemeButtonVisibility
        {
            get { return themebuttonvisibility; }
            set
            {
                themebuttonvisibility = value;
                RaisePropertyChanged(nameof(ThemeButtonVisibility));
            }
        }

        private void ChangeVisibilityofThemepanel(object obj)
        {

            ThemePanelVisibility = false;

        }
        public ICommand ThemePanelVisibilityCommand => new DelegateCommand<object>(ChangeVisibilityofThemepanel);

        private List<Palette> PaletteList = new List<Palette>();
        private void UpdateTitleBarBackgroundandForeground(ThemeEnum selectedTheme)
        {

            if (selectedTheme == ThemeEnum.SystemTheme)
            {
                TitleBarBackground = SystemColors.HighlightBrush;
                TitleBarForeground = SystemColors.HighlightTextBrush;
            }
            else
            {

                TitleBarBackground = SelectedPalette.PrimaryBackground;
                TitleBarForeground = SelectedPalette.PrimaryForeground;
            }
        }
        //dummy command
        public ICommand ButtonCommand => ThemePanelVisibilityCommand;
        public ICommand ReturnToEditorCommand => ThemePanelVisibilityCommand;
        public ICommand OnlineHelpCommand => ThemePanelVisibilityCommand;
        public ICommand GettingStartedHelpCommand => ThemePanelVisibilityCommand;


        public Action ThemeChanged;
        private void OnThemeChanged(ThemeEnum selectedTheme)
        {
            var productDemosWindow = Application.Current.Windows.OfType<MainWindow>();
            
            foreach (var window in productDemosWindow)
            {

                Application.Current.Resources.MergedDictionaries.Add(new ResourceDictionary()
                {

                    Source = new Uri($"/Syncfusion.Themes.{SelectedThemeName}.WPF;component/mscontrol/RadioButton.xaml", UriKind.RelativeOrAbsolute)

                });
                Application.Current.Resources.MergedDictionaries.Add(new ResourceDictionary()
                {

                    Source = new Uri($"/Syncfusion.Themes.{SelectedThemeName}.WPF;component/mscontrol/TextBox.xaml", UriKind.RelativeOrAbsolute)

                });


                SfSkinManager.SetTheme(window, new Syncfusion.SfSkinManager.Theme() { ThemeName = SelectedThemeName.ToString() });
   
            }



            UpdateTitleBarBackgroundandForeground(selectedTheme);

         

            //var navigationService = DemosNavigationService.DemoNavigationService;
            //if (navigationService != null && navigationService.Content != null)
            //{
            //    if (navigationService.Content is DemoLauncherView || navigationService.Content is DemosListView ||
            //        (SelectedSample != null &&
            //         navigationService.Content is DemoControl &&
            //         SelectedSample.ThemeMode == ThemeMode.Inherit))
            //    {
            //        SfSkinManager.SetTheme(navigationService.Content as DependencyObject, new Theme() { ThemeName = SelectedThemeName });
            //    }
            //}

            ThemeChanged?.Invoke();
        }


        private Theme selectedtheme;

        public Theme SelectedTheme
        {
            get { return selectedtheme; }
            set
            {
                selectedtheme = value;
                if (selectedtheme != null)
                {
                    SelectedThemeName = selectedtheme.ThemeEnum;
                }
                RaisePropertyChanged(nameof(SelectedTheme));
            }
        }
        public ObservableCollection<Theme> ThemeList
        {
            get { return _themes; }
            set
            {
                _themes = value;
                RaisePropertyChanged(nameof(ThemeList));

            }
        }


        private Brush _titleBarBackground;
        private Brush _titleBarForeground;

        /// <summary>
        /// Gets or set the title bar background
        /// </summary>
        public Brush TitleBarBackground
        {
            get
            {
                return _titleBarBackground;
            }
            set
            {
                _titleBarBackground = value;
                this.RaisePropertyChanged(nameof(TitleBarBackground));
            }
        }

        /// <summary>
        /// Gets or set the title bar foreground
        /// </summary>
        public Brush TitleBarForeground
        {
            get { return _titleBarForeground; }
            set
            {
                _titleBarForeground = value;
                this.RaisePropertyChanged(nameof(TitleBarForeground));
            }
        }

        private ObservableCollection<Themes.Theme> _themes;
        private ThemeEnum selectedthemename;
    }
}