﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using RibbonOfficeSample.ViewModel.Ribbons;
using RibbonOfficeSample.ViewModel.Themes;
using Syncfusion.Windows.Shared;
using Syncfusion.Windows.Tools.Controls;
using static System.Windows.Forms.VisualStyles.VisualStyleElement;

namespace RibbonOfficeSample
{
    /// <summary>
    /// Interaction logic for MainRibbonGrid.xaml
    /// </summary>
    public partial class MainRibbonGrid : UserControl
    {
        public MainRibbonGrid()
        {
            InitializeComponent();

            Loaded += OnRibbonLoad;
            DataContextChanged += OnDataContextChanged;
            var backStageVisible = myRibbon.IsBackStageVisible;
            myRibbon.BackStage.Loaded += (sender, args) => ShowBackStage(); 


        }

        public void ShowBackStage()
        {
           
            myRibbon.ShowBackStage();
        }

        private void OnDataContextChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            ShowBackStage();
        }

        private void OnRibbonLoad(object sender, RoutedEventArgs e)
        {
            myRibbon.ShowBackStage();
           
        }

        private void ButtonBase_OnClick(object sender, RoutedEventArgs e)
        {
            
            myRibbon.ShowBackStage();
        }


        public static void UpdateTitleBarBackgroundandForeground(ChromelessWindow window, Theme selectedTheme, Palette palette)
        {

            if (selectedTheme.ThemeEnum == ThemeEnum.SystemTheme)
            {

                window.TitleBarBackground = SystemColors.HighlightBrush;
                window.TitleBarForeground = SystemColors.HighlightTextBrush;
            }
            else
            {

                window.TitleBarBackground = palette.PrimaryBackground;
                window.TitleBarForeground = palette.PrimaryForeground;
            }
        }


        /// <summary>
        /// Method helps to Change the Color palette for the SelectedTheme
        ///
        /// Update the code when Syncfusion #462056 is fixed. todo
        /// </summary>
        /// <param name="themeType">Type of the theme</param>
        /// <param name="theme">Name of the selected theme</param>
        private static void ChangePalette(string themeType, string paletteType, Theme theme, Palette selectedPalette)
        {

            object themeSettings = Activator.CreateInstance(Type.GetType(themeType));
            themeSettings.GetType().GetRuntimeProperty("Palette").SetValue(themeSettings, Enum.Parse(Type.GetType(paletteType), selectedPalette.Name));
            Syncfusion.SfSkinManager.SfSkinManager.RegisterThemeSettings(theme.ThemeEnum.ToString(), (Syncfusion.SfSkinManager.IThemeSetting)themeSettings);
        }
        public static void OnPaletteChanged(ChromelessWindow chromelessWindow, Theme theme, Palette palette)
        {
            switch (theme.ThemeEnum)
            {
                case ThemeEnum.Windows11Light: // "Windows11Light":
                    {
                        ChangePalette("Syncfusion.Themes.Windows11Light.WPF.Windows11LightThemeSettings, Syncfusion.Themes.Windows11Light.WPF", "Syncfusion.Themes.Windows11Light.WPF.Windows11Palette, Syncfusion.Themes.Windows11Light.WPF", theme, palette);
                        break;
                    }
                case ThemeEnum.Windows11Dark:
                    {
                        ChangePalette("Syncfusion.Themes.Windows11Dark.WPF.Windows11DarkThemeSettings, Syncfusion.Themes.Windows11Dark.WPF", "Syncfusion.Themes.Windows11Dark.WPF.Windows11Palette, Syncfusion.Themes.Windows11Dark.WPF", theme, palette);
                        break;
                    }
                case ThemeEnum.FluentLight:
                    {
                        ChangePalette("Syncfusion.Themes.FluentLight.WPF.FluentLightThemeSettings, Syncfusion.Themes.FluentLight.WPF", "Syncfusion.Themes.FluentLight.WPF.FluentPalette, Syncfusion.Themes.FluentLight.WPF", theme, palette);
                        break;
                    }
                case ThemeEnum.FluentDark:
                    {
                        ChangePalette("Syncfusion.Themes.FluentDark.WPF.FluentDarkThemeSettings, Syncfusion.Themes.FluentDark.WPF", "Syncfusion.Themes.FluentDark.WPF.FluentPalette, Syncfusion.Themes.FluentDark.WPF", theme, palette);
                        break;
                    }
                    //case "MaterialLight":
                    //    {
                    //        changePalette("Syncfusion.Themes.MaterialLight.WPF.MaterialLightThemeSettings, Syncfusion.Themes.MaterialLight.WPF", "Syncfusion.Themes.MaterialLight.WPF.MaterialPalette, Syncfusion.Themes.MaterialLight.WPF", ThemeName);
                    //        break;
                    //    }
                    //case "MaterialLightBlue":
                    //    {
                    //        changePalette("Syncfusion.Themes.MaterialLightBlue.WPF.MaterialLightBlueThemeSettings, Syncfusion.Themes.MaterialLightBlue.WPF", "Syncfusion.Themes.MaterialLightBlue.WPF.MaterialPalette, Syncfusion.Themes.MaterialLightBlue.WPF", ThemeName);
                    //        break;
                    //    }
                    //case "MaterialDark":
                    //    {
                    //        changePalette("Syncfusion.Themes.MaterialDark.WPF.MaterialDarkThemeSettings, Syncfusion.Themes.MaterialDark.WPF", "Syncfusion.Themes.MaterialDark.WPF.MaterialPalette, Syncfusion.Themes.MaterialDark.WPF", ThemeName);
                    //        break;
                    //    }
                    //case "MaterialDarkBlue":
                    //    {
                    //        changePalette("Syncfusion.Themes.MaterialDarkBlue.WPF.MaterialDarkBlueThemeSettings, Syncfusion.Themes.MaterialDarkBlue.WPF", "Syncfusion.Themes.MaterialDarkBlue.WPF.MaterialPalette, Syncfusion.Themes.MaterialDarkBlue.WPF", ThemeName);
                    //        break;
                    //    }
                    //case "Office2019Colorful":
                    //    {
                    //        changePalette("Syncfusion.Themes.Office2019Colorful.WPF.Office2019ColorfulThemeSettings, Syncfusion.Themes.Office2019Colorful.WPF", "Syncfusion.Themes.Office2019Colorful.WPF.Office2019Palette, Syncfusion.Themes.Office2019Colorful.WPF", ThemeName);
                    //        break;
                    //    }
                    //case "Office2019Black":
                    //    {
                    //        changePalette("Syncfusion.Themes.Office2019Black.WPF.Office2019BlackThemeSettings, Syncfusion.Themes.Office2019Black.WPF", "Syncfusion.Themes.Office2019Black.WPF.Office2019Palette, Syncfusion.Themes.Office2019Black.WPF", ThemeName);
                    //        break;
                    //    }
                    //case "Office2019White":
                    //    {
                    //        changePalette("Syncfusion.Themes.Office2019White.WPF.Office2019WhiteThemeSettings, Syncfusion.Themes.Office2019White.WPF", "Syncfusion.Themes.Office2019White.WPF.Office2019Palette, Syncfusion.Themes.Office2019White.WPF", ThemeName);
                    //        break;
                    //    }
                    //case "Office2019DarkGray":
                    //    {
                    //        changePalette("Syncfusion.Themes.Office2019DarkGray.WPF.Office2019DarkGrayThemeSettings, Syncfusion.Themes.Office2019DarkGray.WPF", "Syncfusion.Themes.Office2019DarkGray.WPF.Office2019Palette, Syncfusion.Themes.Office2019DarkGray.WPF", ThemeName);
                    //        break;

                    //    }
                    //case "Office2019HighContrast":
                    //    {
                    //        changePalette("Syncfusion.Themes.Office2019HighContrast.WPF.Office2019HighContrastThemeSettings, Syncfusion.Themes.Office2019HighContrast.WPF", "Syncfusion.Themes.Office2019HighContrast.WPF.HighContrastPalette, Syncfusion.Themes.Office2019HighContrast.WPF", ThemeName);
                    //        break;
                    //    }
                    //case "Office2019HighContrastWhite":
                    //    {
                    //        changePalette("Syncfusion.Themes.Office2019HighContrastWhite.WPF.Office2019HighContrastWhiteThemeSettings, Syncfusion.Themes.Office2019HighContrastWhite.WPF", "Syncfusion.Themes.Office2019HighContrastWhite.WPF.HighContrastPalette, Syncfusion.Themes.Office2019HighContrastWhite.WPF", ThemeName);
                    //        break;
                    //    }

            }
            OnThemeChanged(chromelessWindow, theme, palette);
        }
        private static void OnThemeChanged(ChromelessWindow chromelessWindow, Theme selectedTheme, Palette palette)
        {
            Syncfusion.SfSkinManager.SfSkinManager.SetTheme(chromelessWindow, new Syncfusion.SfSkinManager.Theme() { ThemeName = selectedTheme.ThemeEnum.ToString() });

            UpdateTitleBarBackgroundandForeground(chromelessWindow, selectedTheme, palette);







            //ThemeChanged?.Invoke();
        }
        private void SaveButtonClick(object sender, RoutedEventArgs e)
        {

            var mainWindowVM = (DataContext as MainRibbonControl).MainWindow;
            var dialog = new ChromelessWindow();
            UpdateTitleBarBackgroundandForeground(dialog, mainWindowVM.SelectedTheme, mainWindowVM.SelectedPalette);
            OnPaletteChanged(dialog, mainWindowVM.SelectedTheme, mainWindowVM.SelectedPalette);
            dialog.ShowDialog();
        }
    }
}
