﻿using System;
using System.Windows.Media.Imaging;

namespace RibbonOfficeSample
{
    public interface IThemeSettings
    {
        object Palette { get; set; }
    }

    public interface IPalette
    {
    }

    public class BluePalette : IPalette
    {

    }

    public class RedPalette : IPalette
    {

    }

    public class Windows11ThemeSettings : IThemeSettings
    {
        public BluePalette Palette { get; set; }

        object IThemeSettings.Palette
        {
            get => Palette;
            set => Palette = (BluePalette)value;

        }
    }

    public class Windows10ThemeSettings : IThemeSettings
    {
        public RedPalette Palette { get; set; }

        object IThemeSettings.Palette
        {
            get => Palette;
            set => Palette = (RedPalette)value;

        }
    }

    public static class CheckPalette
    {
        public static void Run()
        {
            var win11 = new Windows11ThemeSettings();
            BluePalette palette = win11.Palette;
            object paletteObj = ((IThemeSettings)win11).Palette;
            SetPalette(win11); //this works fine
            var win10 = new Windows10ThemeSettings();
            SetPalette(win10); //this throws exception
        }

        public static void SetPalette(IThemeSettings themeSettings)
        {
            themeSettings.Palette = new BluePalette(); // If we rename Palette property, at least Resharper can pick it up and rename correctly.
                                                       // But if we use reflection then we won't know that the reflection code is broken by renaming
        }
    }

}