import { createApp } from 'vue'
import { createPinia } from 'pinia'
import { createRouter, createWebHistory } from 'vue-router'
import View from './View.vue'
import App from './App.vue'
import Etc from './Etc.vue'

const app = createApp(View)

app.use(createPinia())

app.use(createRouter({
  history: createWebHistory(),
  routes: [
    {
      path: '/',
      component: View,
      children: [
        { path: '/', name: 'home', component: App },
        { path: '/etc', name: 'etc', component: Etc },
      ]
    }
  ]
}))

app.mount('#app')
