class SplitterClass
{
    constructor(matrix)
    {
        this.matrix = matrix;
        this.ignoreScrollEvents = false;
        this.createHTMLStructure();
        this.createSplitter();
    }

    randomID(name)
    {
        var S4 = function() {
            return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
         };
         var randomID = S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+name;
         while(document.getElementById(randomID))
         {
            randomID = S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4()+name;
         }
         return randomID;     
    }

    // zusätzliche DOM-Elemente generieren für die Integration des Splitters
    //
    createHTMLStructure()
    {
        var container = document.getElementById(this.matrix.matrixCtrl);
        container.style.display = "flex";
        container.style.height = screen.availHeight;

        var divSplitter = document.createElement("div");
        divSplitter.id = this.randomID("splitter");
        container.appendChild(divSplitter);
        this.splitterId = divSplitter.id;

        var divResourceTreeGrid = document.createElement("div");
        divResourceTreeGrid.className = "content";
        divResourceTreeGrid.id = this.randomID("resourceTreeGrid");
        divSplitter.appendChild(divResourceTreeGrid);
        

        var pitContainer = document.getElementById(this.matrix.pitDiv);
        pitContainer.style.width = "auto";
        pitContainer.style.height = "200px";
        pitContainer.style.overflow = "hidden";
        divResourceTreeGrid.appendChild(pitContainer);

        var resourceMatrix = document.getElementById(this.matrix.resourceMatrix);
        divResourceTreeGrid.appendChild(resourceMatrix);

        var divAppointmentTreeGrid = document.createElement("div");
        divAppointmentTreeGrid.className = "content";
        divAppointmentTreeGrid.id = this.randomID("appointmentTreeGrid");
        divSplitter.appendChild(divAppointmentTreeGrid);

        var appointmentMatrix = document.getElementById(this.matrix.appointmentMatrix);
        divAppointmentTreeGrid.appendChild(appointmentMatrix);

        this.syncScroll(divResourceTreeGrid, divAppointmentTreeGrid);
        this.syncScroll(divAppointmentTreeGrid, divResourceTreeGrid);       
    }

    //ohne Virtualization dennoch synchrones Scrollen ermöglichen
    //
    syncScroll(element1, element2) {
        element1.addEventListener("scroll", () =>  {
            var ignore = this.ignoreScrollEvents;
            this.ignoreScrollEvents = false;
            if (ignore) 
            {
                return
            }
            this.ignoreScrollEvents = true;
            element2.scrollTop = element1.scrollTop;
        })
    }

    // Splitter-Objekt erstellen
    //
    createSplitter()
    {
        this.splitObject = new ej.layouts.Splitter({
            separatorSize: 3
        });
        this.splitObject.appendTo("#"+this.splitterId);
    }
}
