class PitMatrixClass {
    constructor(matrixCtrl, entityMatrixData, wt) {
        this.wt = wt;
        this.pitDiv = entityMatrixData.pitCtrl;
        this.matrixCtrl = matrixCtrl.children[0].id;
        this.resourceMatrix = document.getElementById(matrixCtrl.children[0].children[0].id).children[0].id;
        this.appointmentMatrix = document.getElementById(matrixCtrl.children[0].children[0].id).children[1].id;
        this.colorObj = {
            backgroundColor: '#FFFFFF', //--main-bg-color
            color: '#000000', //--main-fg-color
            borderColor: '#DDDDDD', //--main-border-color
            activeColor: '#5a5a5a', //--main-selected-text-color
            activeBackgroundColor: '#DDDDDD', //--main-selected-bg-color
        };
        this.entityMatrixData = entityMatrixData;
        this.setDefaultValues();
        this.columnDescriptionsResource = this.adjustColumnDescriptions(entityMatrixData.ressourceColumnDescription);
        this.columnDescriptionsAppointment = this.adjustColumnDescriptions(entityMatrixData.appointmentColumnDescription);

        // weitere appointmentspezifische Anpassungen
        this.columnDescriptionsAppointment[0].visible = false;
        for (let iColumn = 0; iColumn < this.columnDescriptionsAppointment.length; iColumn++) {
            this.columnDescriptionsAppointment[iColumn].customAttributes = { class: 'orientationCSS' };
            this.columnDescriptionsAppointment[iColumn].width = 25;
        }
        let valueObj = {
            ressourceValues: entityMatrixData.ressourceValues,
            appointmentValues: entityMatrixData.appointmentValues
        };
        this.splitter = new SplitterClass(this);
        this.ignoreScrollEvents = false;

        this.setInitialData(valueObj);
    }

    dataFromWt(command, content) {
        var jsonObj = content;
    
        switch (parseInt(command)) {
            case 0:
                //Values setzen und initialiesieren der Entitymatrix
                this.setInitialData(jsonObj);
                break;
    
            case 1:
                //ändern der Values im linken Treegrid
                this.changeResourceValues(jsonObj);
                break;
    
            case 2:
                //ändern der Values im rechten Treegrid
                this.changeAppointmentValues(jsonObj);
                break;
    
            case 3:
                //aktuell nur Sprache
                this.changeMetadata(jsonObj);
                break;
    
            case 4:
                //Abfrage vom Backend sämtlicher Values im linken Treegrid
                this.onSendResourceValues();
                break;
    
            case 5:
                //Abfrage vom Backend sämtlicher Values im rechten Treegrid
                this.onSendAppointmentValues();
                break;
            
            case 6:
                // Abfrage vom Backend für aktuell selektierte Zelle (Spalte, Zeile)
                this.onSendSelectPosition();
                break;
    
            case 7:
                // Ersetzen der Spalten und Values der einzelnen Zellen im linken Treegrid
                this.updateAppointmentGrid(jsonObj);
                break;
    
            default:
                break;
        }
    }

    setDefaultValues() {
        if(this.entityMatrixData.height == null) {
            this.entityMatrixData.height = 380;
        }
        if(this.entityMatrixData.page == null) {
            this.entityMatrixData.page = 1;
        }
        if(this.entityMatrixData.locale == null) {
            this.entityMatrixData.locale = "de";
        }
        if(this.entityMatrixData.readOnly == null) {
            this.entityMatrixData.readOnly = true;
        }
    }

    setInitialData(jsonObj) {
        this.dataResource = jsonObj.ressourceValues;
        this.dataAppointment = jsonObj.appointmentValues;
        this.createTreeGrids();
        this.setSyncfusionEventValues();
        this.setColor();
    }

    changeResourceValues(resourceData) {
        for (let iResource = 0; iResource < resourceData.length; iResource++) {
            var resourceIndex = this.treeGridResourceObj.dataSource.findIndex((ele) => ele._0 === resourceData[iResource]._0);
            for (let iResourceValue = 1; iResourceValue < Object.keys(resourceData[iResource]).length; iResourceValue++) {
                var keyName = Object.keys(resourceData[iResource])[iResourceValue];
                this.treeGridResourceObj.dataSource[resourceIndex][keyName] = resourceData[iResource][keyName];
            }
        }
        this.treeGridResourceObj.refresh();
        this.treeGridResourceObj.hideSpinner();
    }

    changeAppointmentValues(appointmentData) {
        for (let iAppointment = 0; iAppointment < appointmentData.length; iAppointment++) {
            var appointmentIndex = this.treeGridAppointmentObj.dataSource.findIndex((ele) => ele._0 === appointmentData[iAppointment]._0);
            if(appointmentIndex != -1) {
                this.treeGridAppointmentObj.dataSource[appointmentIndex] = appointmentData[iAppointment];
            }
        }
        this.treeGridAppointmentObj.refresh();
        this.treeGridAppointmentObj.hideSpinner();
    }

    changeMetadata(metaData) {
        if (metaData.locale != null) {
            this.entityMatrixData.locale = metaData.locale;
            this.setLocale();
        }
    }

    onSendResourceValues() {
        // this.wt.dataToWt(1, JSON.stringify(this.treeGridResourceObj.dataSource));
    }

    onSendAppointmentValues() {
        // this.wt.dataToWt(2, JSON.stringify(this.treeGridAppointmentObj.dataSource));
    }

    onSendSelectPosition() {
        let selectedRecords = this.treeGridAppointmentObj.getSelectedRecords();
        var cellObj = {
            row: -1,
            column: -1
        };
        // Überprüfung ob Element selektiert ist
        //
        if(selectedRecords.length > 0) {
            cellObj.row = selectedRecords[0]._0;
            // Überprüfung ob Selektion in Resourcen- oder Appointmentgrid erfolgte
            //
            if(this.appointmentCurrentCellIndex != null){
                if(this.pagingClass) {
                    cellObj.column = this.pagingClass.currentSelectedPage - this.pagingClass.amountPerPage + this.appointmentCurrentCellIndex;
                }
                else {
                    cellObj.column = this.appointmentCurrentCellIndex;
                }
            }
        }
        // this.wt.dataToWt(4, JSON.stringify(cellObj));
    }

    updateAppointmentGrid(jsonObj) {
        if(jsonObj.appointmentColumnDescription) {
            this.columnDescriptionsAppointment = this.adjustColumnDescriptions(jsonObj.appointmentColumnDescription);

            // appointmentspezifische Anpassungen
            this.columnDescriptionsAppointment[0].visible = false;
            for (let iColumn = 0; iColumn < this.columnDescriptionsAppointment.length; iColumn++) {
                this.columnDescriptionsAppointment[iColumn].customAttributes = { class: 'orientationCSS' };
                this.columnDescriptionsAppointment[iColumn].width = 40;
            }

            if(this.pagingClass) {
                let pagingEle = document.getElementById(this.pagingClass.pagingId);
                pagingEle.remove();
                this.pagingClass = null;
            }
            if (this.columnDescriptionsAppointment.length > 50) {
                this.pagingClass = new PagingClass(this);
            }
            else {
                this.treeGridAppointmentObj.columns = this.columnDescriptionsAppointment;
            }
        }
        if(jsonObj.appointmentValues) {
            this.treeGridAppointmentObj.dataSource = jsonObj.appointmentValues;
        }
    }

    // anpassen der JSON-Daten für Syncfusion
    //
    adjustColumnDescriptions(columnDescriptions) {
        for (let iColumnRecord = 0; iColumnRecord < columnDescriptions.length; iColumnRecord++) {
            if (columnDescriptions[iColumnRecord].columnType != null) {
                var clmEditType = columnDescriptions[iColumnRecord].columnType;
                if (clmEditType === "TEXT") {
                    columnDescriptions[iColumnRecord].type = "string";
                }
                if (clmEditType === "DOUBLE") {
                    columnDescriptions[iColumnRecord].editType = "numericEdit";
                    columnDescriptions[iColumnRecord].type = "number";
                }
                if (clmEditType === "INTEGER") {
                    columnDescriptions[iColumnRecord].editType = "numericEdit";
                    columnDescriptions[iColumnRecord].type = "number";
                    columnDescriptions[iColumnRecord].edit = {
                        params:
                        {
                            validateDecimalOnType: true,
                            decimals: 0,
                            format: "N"
                        }
                    }
                }
                if (clmEditType === "BOOL") {
                    columnDescriptions[iColumnRecord].editType = "booleanedit";
                    columnDescriptions[iColumnRecord].type = "boolean";
                    columnDescriptions[iColumnRecord].displayAsCheckBox = true;
                    columnDescriptions[iColumnRecord].clipMode = 'Clip';
                }
                columnDescriptions[iColumnRecord].textAlign = "Center";

                if (columnDescriptions[iColumnRecord].orientation === 1) {
                    columnDescriptions[iColumnRecord].customAttributes = { class: 'orientationCSS' };
                }

                if (iColumnRecord === 0) {
                    columnDescriptions[iColumnRecord].isPrimaryKey = true;
                    columnDescriptions[iColumnRecord].textAlign = "Left";
                }
                // delete  this.columnDescriptions[iColumnRecord].columnType;
                // delete  this.columnDescriptions[iColumnRecord].orientation;
            }
        }
        return columnDescriptions;
    }

    // die Klasse erweitern um die jeweiligen CSS-Propeties zu setzen (aktuell nur Farben)
    //
    setColor() {
        document.documentElement.style.setProperty('--main-bg-color-matrix', this.colorObj.backgroundColor);
        document.documentElement.style.setProperty('--main-color-matrix', this.colorObj.color);
        document.documentElement.style.setProperty('--active-color-matrix', this.colorObj.activeColor);
        document.documentElement.style.setProperty('--active-bg-color-matrix', this.colorObj.activeBackgroundColor);
    }

    // notwendige globale Variablen für die synchrone Selektion zwischen beiden TreeGrids
    //
    setSyncfusionEventValues() {
        this.appointmentSelect = true;
        this.resourceSelect = true;
        this.appointmentDeselect = true;
        this.resourceDeselect = true;
        this.appointmentEdit = false;
    }

    onAppointmentActionBegin(args) {
        if (args.requestType === 'beginEdit') {
            this.appointmentEdit = true;
        }
        if (args.requestType === 'save') {
            this.appointmentEdit = false;
        }
    }

    // bei virtual Scrolling muss bei bereits ausgewählter Zeile, die neuen Datensätze (spezifisch die selektierte Spalte) nachgefärbt werden
    //
    onResourceDataBound(args) {
        if (this.resourceCurrentCellIndex != null) {
            this.allRowCells = [];
            var allRowCells = document.querySelectorAll("#" + this.resourceMatrix + " td.e-rowcell");
            for (let i = 0; i < allRowCells.length; i++) {
                if (allRowCells[i].cellIndex === this.resourceCurrentCellIndex) {
                    this.allRowCells[i] = allRowCells[i].style.backgroundColor;
                    allRowCells[i].style.backgroundColor = this.colorObj.activeBackgroundColor;
                }
            }
        }
    }
    onAppointmentDataBound(args) {
        if (this.appointmentCurrentCellIndex != null) {
            this.allRowCells = [];
            var allRowCells = document.querySelectorAll("#" + this.appointmentMatrix + " td.e-rowcell");
            for (let i = 0; i < allRowCells.length; i++) {
                if (allRowCells[i].cellIndex === this.appointmentCurrentCellIndex) {
                    this.allRowCells[i] = allRowCells[i].style.backgroundColor;
                    allRowCells[i].style.backgroundColor = this.colorObj.activeBackgroundColor;
                }
            }
        }
    }

    // wenn Kontextmenü aktiviert (nur für rechtes TreeGrid), können die einzelnen Stati selektiert werden und bei Selektierung wird der dazugeörige DS aktualisiert
    //
    onAppointmentContextMenuClick(args) {
        if (args.rowInfo.cell.innerHTML !== args.element.innerHTML.charAt(0)) {
            for (let iData = 0; iData < this.dataAppointment.length; iData++) {
                if (this.dataAppointment[iData]._0 === args.rowInfo.rowData._0) {
                    var changeAppointment = JSON.parse(JSON.stringify(this.dataAppointment[iData]));
                    changeAppointment[args.rowInfo.column.field] = args.element.innerHTML.charAt(0);
                    var changeAppointmentArr = [];
                    // this.treeGridAppointmentObj.showSpinner();
                    changeAppointmentArr.push(changeAppointment);
                    // this.wt.dataToWt(3, JSON.stringify(changeAppointmentArr));
                    //this.dataAppointment[iData][args.rowInfo.column.field] = args.rowInfo.cell.innerHTML;
                    return;
                }
            }
        }
    }

    // wird über Rechtsklick auf eine Zelle ausgelöst (Mobile -> über Touch gedrückt halten)
    //
    onAppointmentContextMenuOpen(args) {
        if (args.column != null && args.rowInfo.cell != null) {
            // Kreuzselektierung über Rechtsklick
            this.appointmentCurrentCellIndex = args.rowInfo.cell.cellIndex;
            this.allRowCells = [];
            var allRowCells = document.querySelectorAll("#" + this.appointmentMatrix + " td.e-rowcell");
            for (let i = 0; i < allRowCells.length; i++) {
                if (allRowCells[i].cellIndex === this.appointmentCurrentCellIndex) {
                    this.allRowCells[i] = allRowCells[i].style.backgroundColor;
                    allRowCells[i].style.backgroundColor = this.colorObj.activeBackgroundColor;
                    allRowCells[i].style.color = this.colorObj.activeColor;
                }
            }
            if (args.rowInfo.rowData) {
                if (args.rowInfo.rowData.hasChildRecords == null) {
                    // Bearbeitung deaktivieren wenn Zeilen leer sind
                    // var columnField = args.column.field;
                    // if(args.rowInfo.rowData[columnField])
                    // {
                    for (let iStatusData = 0; iStatusData < this.entityMatrixData.statusData.length; iStatusData++) {
                        if (iStatusData === 0) {
                            args.element.children[iStatusData].style.borderTop = "1px solid";
                            args.element.children[iStatusData].style.borderTopColor = "black";
                        }
                        args.element.children[iStatusData].style.borderBottom = "1px solid";
                        args.element.children[iStatusData].style.borderBottomColor = "black";
                    }
                    // }
                    // else
                    // {
                    //     args.cancel = true;
                    // }
                }
                else {
                    args.cancel = true;
                }
            }
            else {
                args.cancel = true;
            }
        }
        else {
            args.cancel = true;
        }
    }

    // in einem TreeGrid Zeile Deselektieren, dann auch zugehörigen rowIndex des anderen TreeGrids
    //
    onResourceRowDeselecting(args) {
        if (this.resourceDeselect === true || (this.appointmentCurrentCellIndex == null && this.resourceCurrentCellIndex != null)) {
            var rowIndexes = [args.rowIndex];
            this.appointmentDeselect = false;
            this.treeGridAppointmentObj.clearSelection(rowIndexes);
            this.appointmentDeselect = true;

            var allRowCells = document.querySelectorAll("#" + this.resourceMatrix + " td.e-rowcell");
            for (let i = 0; i < allRowCells.length; i++) {
                if (allRowCells[i].cellIndex === this.resourceCurrentCellIndex) {
                    allRowCells[i].style.backgroundColor = this.allRowCells[i];
                }
            }
            this.resourceCurrentCellIndex = null;

            if(this.resourceDeselect && this.appointmentCurrentCellIndex == null)
            {
                var cellObj = {
                    row: -1,
                    column: -1
                };
                // this.wt.dataToWt(5, JSON.stringify(cellObj));
            }
        }
    }
    onAppointmentRowDeselecting(args) {
        if (this.appointmentDeselect === true || (this.appointmentCurrentCellIndex != null && this.resourceCurrentCellIndex == null)) {
            var rowIndexes = [args.rowIndex];
            this.resourceDeselect = false;
            this.treeGridResourceObj.clearSelection(rowIndexes);
            this.resourceDeselect = true;

            // var this.appointmentCurrentCellIndex = args.target.cellIndex;
            var allRowCells = document.querySelectorAll("#" + this.appointmentMatrix + " td.e-rowcell");
            for (let i = 0; i < allRowCells.length; i++) {
                if (allRowCells[i].cellIndex === this.appointmentCurrentCellIndex) {
                    allRowCells[i].style.backgroundColor = this.allRowCells[i];
                }
            }
            this.appointmentCurrentCellIndex = null;

            if(this.appointmentDeselect && this.resourceCurrentCellIndex == null)
            {
                var cellObj = {
                    row: -1,
                    column: -1
                };
                // this.wt.dataToWt(5, JSON.stringify(cellObj));
            }
        }
    }

    // in einem TreeGrid Zeile Selektieren, dann auch zugehörigen rowIndex des anderen TreeGrids
    //
    onResourceRowSelecting(args) {
        if (this.appointmentEdit === true) {
            args.cancel = true;
            return;
        }
        if (this.resourceSelect === true) {
            var rowIndexes = [args.rowIndex];
            this.appointmentSelect = false;
            this.treeGridAppointmentObj.selectRows(rowIndexes);
            this.appointmentSelect = true;

            if (this.resourceCurrentCellIndex != null) {
                var allRowCells = document.querySelectorAll("#" + this.resourceMatrix + " td.e-rowcell");
                for (let i = 0; i < allRowCells.length; i++) {
                    if (allRowCells[i].cellIndex === this.resourceCurrentCellIndex) {
                        allRowCells[i].style.backgroundColor = this.allRowCells[i];
                    }
                }
                this.resourceCurrentCellIndex = null;
            }

            if (args.target != null) {
                // if notwendig, denn wenn vorher keine Zeile (außer aus der ersten Spalte) selektiert wurde wird das child-Element als target selektiert
                if (args.target.className === "e-treecolumn-container") {
                    this.resourceCurrentCellIndex = args.target.parentElement.cellIndex;
                }
                else {
                    this.resourceCurrentCellIndex = args.target.cellIndex;
                }
                // vorherige Farben zwischenspeichern und Spalten umfärben
                this.allRowCells = [];
                var allRowCells = document.querySelectorAll("#" + this.resourceMatrix + " td.e-rowcell");
                for (let i = 0; i < allRowCells.length; i++) {
                    if (allRowCells[i].cellIndex === this.resourceCurrentCellIndex) {
                        this.allRowCells[i] = allRowCells[i].style.backgroundColor;
                        allRowCells[i].style.backgroundColor = this.colorObj.activeBackgroundColor;
                    }
                }

                var cellObj = {
                    row: rowIndexes[0] + 1,
                    column: -1
                };
                // this.wt.dataToWt(5, JSON.stringify(cellObj));
            }
        }
    }
    onAppointmentRowSelecting(args) {
        if (this.appointmentSelect === true) {
            var rowIndexes = [args.rowIndex];
            this.resourceSelect = false;
            this.treeGridResourceObj.selectRows(rowIndexes);
            this.resourceSelect = true;

            if (this.appointmentCurrentCellIndex != null) {
                var allRowCells = document.querySelectorAll("#" + this.appointmentMatrix + " td.e-rowcell");
                for (let i = 0; i < allRowCells.length; i++) {
                    if (allRowCells[i].cellIndex === this.appointmentCurrentCellIndex) {
                        allRowCells[i].style.backgroundColor = this.allRowCells[i];
                    }
                }
                this.appointmentCurrentCellIndex = null;
            }

            if (args.target != null) {
                // if notwendig, denn wenn vorher keine Zeile (außer aus der ersten Spalte) selektiert wurde wird das child-Element als target selektiert
                if (args.target.className === "e-treecolumn-container") {
                    this.appointmentCurrentCellIndex = args.target.parentElement.cellIndex;
                }
                else {
                    this.appointmentCurrentCellIndex = args.target.cellIndex;
                }
                // vorherige Farben zwischenspeichern und Spalten umfärben
                this.allRowCells = [];
                var allRowCells = document.querySelectorAll("#" + this.appointmentMatrix + " td.e-rowcell");
                for (let i = 0; i < allRowCells.length; i++) {
                    if (allRowCells[i].cellIndex === this.appointmentCurrentCellIndex) {
                        this.allRowCells[i] = allRowCells[i].style.backgroundColor;
                        allRowCells[i].style.backgroundColor = this.colorObj.activeBackgroundColor;
                    }
                }

                var cellObj = {
                    row: rowIndexes[0] + 1,
                    column: this.appointmentCurrentCellIndex
                };
                if(this.pagingClass) {
                    cellObj.column = this.pagingClass.currentSelectedPage - this.pagingClass.amountPerPage + this.appointmentCurrentCellIndex;
                }
                // this.wt.dataToWt(5, JSON.stringify(cellObj));
            }
        }
    }

    setLocale() {
        if (this.entityMatrixData.locale === "de") {
            ej.base.L10n.load({
                'de': {
                    'grid':
                    {
                        'Columnchooser': "Spaltenauswahl",
                        'OKButton': "Bestätigen",
                        'CancelButton': "Abbrechen",
                        "ChooseColumns": "Wählen Sie Spalten",
                        "Matchs": "Keine Treffer gefunden",
                        "Search": "",
                        "SelectAll": "Alle auswählen",
                    }
                }
            });
        }
        if (this.entityMatrixData.locale === "en-us") {
            ej.base.L10n.load({
                'en-us': {
                    'grid':
                    {
                        'Columnchooser': "Columns",
                        'OKButton': "Bestätigen",
                        'CancelButton': "Cancel",
                        "ChooseColumns": "Choose Column",
                        "Matchs": "No Matches Found",
                        "Search": "",
                        "SelectAll": "Select All",
                    }
                }
            });
        }
        this.treeGridResourceObj.locale = this.entityMatrixData.locale;
        this.treeGridAppointmentObj.locale = this.entityMatrixData.locale;
    }

    // TreeGrid-Objekte erstellen
    //
    createTreeGrids() {

        this.treeGridResourceObj = new ej.treegrid.TreeGrid({
            dataSource: this.dataResource, // Datensätze
            idMapping: '_0',
            //hasChildMapping: 'isParent',
            parentIdMapping: 'ParentItem',
            gridLines: 'Both',
            pageSettings: { pageSize: 50 },
            //enableVirtualization: true, // virtual Scrolling aktivieren
            height: this.entityMatrixData.height,
            showColumnChooser: true,
            toolbar: ['ColumnChooser'],
            //editSettings: { allowEditing: true, allowAdding: true, allowDeleting: true, mode: 'Row' },
            columns: this.columnDescriptionsResource, // Spaltenbeschreibung
            dataBound: (args) => {
                this.onResourceDataBound(args);
            },
            rowDeselecting: (args) => {
                this.onResourceRowDeselecting(args);
            },
            rowSelecting: (args) => {
                this.onResourceRowSelecting(args);
            }
        });

        // wenn Anzahl der DS > 150 dann Virtualscrolling aktivieren
        //
        if (this.dataResource.length > 150) {
            this.treeGridResourceObj.enableVirtualization = true;
        }

        this.treeGridAppointmentObj = new ej.treegrid.TreeGrid({
            dataSource: this.dataAppointment,
            idMapping: '_0',
            //hasChildMapping: 'isParent',
            parentIdMapping: 'ParentItem',
            gridLines: 'Both',
            pageSettings: { pageSize: 50 },
            //enableVirtualization: true,
            height: this.entityMatrixData.height,
            columns: [],
            contextMenuClick: (args) => {
                this.onAppointmentContextMenuClick(args);
            },
            contextMenuOpen: (args) => {
                this.onAppointmentContextMenuOpen(args);
            },
            dataBound: (args) => {
                this.onAppointmentDataBound(args);
            },
            rowDeselecting: (args) => {
                this.onAppointmentRowDeselecting(args);
            },
            rowSelecting: (args) => {
                this.onAppointmentRowSelecting(args);
            }
        });

        this.setLocale();
        this.treeGridResourceObj.appendTo("#" + this.resourceMatrix);

        // wenn Anzahl der DS > 150 dann Virtualscrolling aktivieren
        //
        if (this.dataAppointment.length > 150) {
            this.treeGridAppointmentObj.enableVirtualization = true;
        }

        this.generateContextMenuItems();

        this.treeGridAppointmentObj.appendTo("#" + this.appointmentMatrix);

        if (this.columnDescriptionsAppointment.length > 50) {
            this.pagingClass = new PagingClass(this);
        }
        else {
            this.treeGridAppointmentObj.columns = this.columnDescriptionsAppointment;
        }

        var appointmentScroll = document.getElementById(this.appointmentMatrix).getElementsByClassName("e-gridcontent")[0].getElementsByClassName("e-content")[0];
        var resourceScroll = document.getElementById(this.resourceMatrix).getElementsByClassName("e-gridcontent")[0].getElementsByClassName("e-content")[0];
        this.syncScroll(resourceScroll, appointmentScroll);
        this.syncScroll(appointmentScroll, resourceScroll);
    }

    // synchrones Scrollen beider TreeGrids
    //
    syncScroll(element1, element2) {
        element1.addEventListener("scroll", () => {
            var ignore = this.ignoreScrollEvents;
            this.ignoreScrollEvents = false;
            if (ignore) {
                return
            }
            this.ignoreScrollEvents = true;
            element2.scrollTop = element1.scrollTop;
        })
    }

    // Erstellung des Kontextmenüs, wenn flag true
    // Editierung ermöglichen wenn flag false -> noch nicht implementiert
    //
    generateContextMenuItems() {
        if (this.entityMatrixData.readOnly === true) {
            var contextMenuItems = [];
            if(this.entityMatrixData.statusData == null) {
                this.entityMatrixData.statusData = [];
            }
            for (let iStatus = 0; iStatus < this.entityMatrixData.statusData.length; iStatus++) {
                contextMenuItems[iStatus] = { text: this.entityMatrixData.statusData[iStatus].shortValue + " - " + this.entityMatrixData.statusData[iStatus].longValue, target: '.e-content', id: (this.entityMatrixData.statusData[iStatus].id).toString() }
            }
            this.treeGridAppointmentObj.contextMenuItems = contextMenuItems;
        }
        if (this.entityMatrixData.readOnly === false) {
            this.treeGridAppointmentObj.editSettings = { allowEditing: true, mode: 'Both' };
        }
    }
}