class PagingClass {
    constructor(keyMatrix) {
        this.keyMatrix = keyMatrix;
        this.amountPerPage = 50; // dieser Wert bestimmt die Anzahl je Page
        this.pagingId = this.randomID("paging");
        this.divideDataByAmount();
        this.create();
        this.currentSelectedPage = this.setSelectedPage();
    }

    randomID(name) {
        var S4 = function () {
            return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
        };
        var randomID = S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + name;
        while (document.getElementById(randomID)) {
            randomID = S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4() + name;
        }
        return randomID;
    }

    // aufsplitten der Daten
    //
    divideDataByAmount() {
        var columnAppointmentData = this.keyMatrix.columnDescriptionsAppointment;
        var pagingCounter = 0;
        this.appointmentPagingData = [];
        for (let iDataColumn = 0; iDataColumn < columnAppointmentData.length; iDataColumn++) {
            if (!this.appointmentPagingData[pagingCounter]) {
                this.appointmentPagingData[pagingCounter] = [];
            }
            if (columnAppointmentData[iDataColumn].field.includes("_0")) {
                this.primaryKey = columnAppointmentData[iDataColumn];
            }
            else {
                this.appointmentPagingData[pagingCounter].push(columnAppointmentData[iDataColumn]);
                if (iDataColumn % this.amountPerPage === 0) {
                    pagingCounter++;
                }
            }
        }

        // primaryKey muss für alle Pages gesetzt werden
        for (let iPaging = 0; iPaging < this.appointmentPagingData.length; iPaging++) {
            this.appointmentPagingData[iPaging].unshift(this.primaryKey);
        }
    }

    setSelectedPage() {
        if (this.keyMatrix.entityMatrixData.page) {
            this.changePageData(this.keyMatrix.entityMatrixData.page * this.amountPerPage)
            return this.keyMatrix.entityMatrixData.page * this.amountPerPage;
        }
        else {
            this.changePageData(this.amountPerPage)
            return this.amountPerPage;
        }
    }

    // DOM-Elemente generieren für Paging-Leiste
    //
    create() {
        var nav = document.createElement("div");
        nav.className = "paging";
        nav.id = this.pagingId;
        nav.addEventListener("mousemove", function (Events) {
            const x = Events.pageX - Events.target.offsetLeft;
            const y = Events.pageY - Events.target.offsetTop;

            Events.target.style.setProperty('--x', `${x}px`);
            Events.target.style.setProperty('--y', `${y}px`);
        });
        var matrixCtrl = document.getElementById(this.keyMatrix.matrixCtrl).parentElement;
        matrixCtrl.appendChild(nav);

        var ulPagination = document.createElement("ul");
        ulPagination.className = "pagination";
        nav.appendChild(ulPagination);

        var listPageItemPrevious = document.createElement("li");
        listPageItemPrevious.className = "page-item";
        ulPagination.appendChild(listPageItemPrevious);

        var buttonPageItemPrevious = document.createElement("button");
        buttonPageItemPrevious.className = "btn btn-light";
        buttonPageItemPrevious.type = "button";
        buttonPageItemPrevious.addEventListener("click", () => this.changePageDataPN("Previous"));
        listPageItemPrevious.appendChild(buttonPageItemPrevious);

        var spanIconPrevious = document.createElement("span");
        spanIconPrevious.setAttribute("aria-hidden", true);
        spanIconPrevious.innerHTML = "&laquo";
        buttonPageItemPrevious.appendChild(spanIconPrevious);

        var spanNoIconPrevious = document.createElement("span");
        spanNoIconPrevious.className = "sr-only";
        buttonPageItemPrevious.appendChild(spanNoIconPrevious);

        for (let iPaging = 0; iPaging < this.appointmentPagingData.length; iPaging++) {
            var listPageItem = document.createElement("li");
            listPageItem.className = "page-item";
            ulPagination.appendChild(listPageItem);

            var buttonPageItem = document.createElement("button");
            buttonPageItem.className = "btn btn-light";
            buttonPageItem.id = "matrix-page-btn-" + (this.appointmentPagingData[iPaging].length - 1 + 50 * iPaging);
            buttonPageItem.type = "button";
            buttonPageItem.innerHTML = this.appointmentPagingData[iPaging].length - 1 + 50 * iPaging;
            buttonPageItem.addEventListener("click", () => this.changePageData((iPaging + 1) * this.amountPerPage));
            listPageItem.appendChild(buttonPageItem);
        }

        var listPageItemNext = document.createElement("li");
        listPageItemNext.className = "page-item";
        ulPagination.appendChild(listPageItemNext);

        var buttonPageItemNext = document.createElement("button");
        buttonPageItemNext.className = "btn btn-light";
        buttonPageItemNext.type = "button";
        buttonPageItemNext.addEventListener("click", () => this.changePageDataPN("Next"));
        listPageItemNext.appendChild(buttonPageItemNext);

        var spanIconNext = document.createElement("span");
        spanIconNext.setAttribute("aria-hidden", true);
        spanIconNext.innerHTML = "&raquo";
        buttonPageItemNext.appendChild(spanIconNext);

        var spanNoIconNext = document.createElement("span");
        spanNoIconNext.className = "sr-only";
        buttonPageItemNext.appendChild(spanNoIconNext);
    }

    // ändern der Pagingdaten wenn eine andere Page, als die bereits selektierte, ausgewählt wird
    //
    changePageData(selectedPage) {
        if (this.currentSelectedPage == selectedPage) {
            return;
        }

        let index = selectedPage / this.amountPerPage - 1;

        if (this.currentSelectedPage) {
            let currentIndex = this.currentSelectedPage / this.amountPerPage - 1;
            let currentPageBtn = document.getElementById("matrix-page-btn-" + (this.appointmentPagingData[currentIndex].length - 1 + 50 * currentIndex));
            currentPageBtn.className = "btn btn-light";
        }

        let pageBtn = document.getElementById("matrix-page-btn-" + (this.appointmentPagingData[index].length - 1 + 50 * index));
        pageBtn.className = "btn btn-secondary";

        while (this.keyMatrix.treeGridAppointmentObj.columns.length > 0) {
            this.keyMatrix.treeGridAppointmentObj.columns.pop();
        }

        for (let iColumn = 0; iColumn < this.appointmentPagingData[index].length; iColumn++) {
            this.keyMatrix.treeGridAppointmentObj.columns.push(this.appointmentPagingData[index][iColumn]);
        }
        this.currentSelectedPage = selectedPage;
        this.keyMatrix.treeGridAppointmentObj.refreshColumns();
    }

    // ändern der Daten wenn der vorher oder nachher Button ausgelöst wird
    // es passiert nichts wenn es keine vorherige oder nachfolgende Page gibt
    //
    changePageDataPN(pn) {
        if (pn === 'Previous') {
            var currentSelectedPage = this.currentSelectedPage - this.amountPerPage;
        }
        if (pn === 'Next') {
            var currentSelectedPage = this.currentSelectedPage + this.amountPerPage;
        }
        if (currentSelectedPage < this.amountPerPage || currentSelectedPage > this.appointmentPagingData.length * this.amountPerPage) {
            return;
        }
        else {
            this.changePageData(currentSelectedPage);
        }
    }
}