class PitBackend {
    constructor(matrixCtrl, pitCtrl) {
        this.matrixCtrl = matrixCtrl;
        // mit Kontextmenü
        this.entityMatrix = {
            pitCtrl: pitCtrl,
            readOnly: true,
            locale: "de",
            statusData: [
                { shortValue: 'Z', longValue: 'erledigt', id: 0, default: true },
                { shortValue: 'I', longValue: 'in bearbeitung', id: 1, default: true }
            ],
            ressourceColumnDescription:
                [
                    { field: '_0', width: 120, headerText: 'Zeile', columnType: 'TEXT' },
                    { field: '_1', width: 100, headerText: 'Anzeigename', columnType: 'TEXT' },
                    { field: '_2', width: 100, headerText: 'Mitschließung', columnType: 'BOOL' },
                    { field: '_3', width: 100, headerText: 'Zentralschließung', columnType: 'BOOL' },
                    { field: '_4', width: 100, headerText: 'Name', columnType: 'TEXT' },
                    { field: '_5', width: 100, headerText: 'Nr', columnType: 'TEXT' },
                    { field: '_6', width: 100, headerText: 'Werkschließ_Nr', columnType: 'TEXT' },
                    { field: '_7', width: 100, headerText: 'Schließanlage', columnType: 'TEXT' },
                ],
            ressourceValues:
                [
                    { _0: '1', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '2', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '3', _1: '123 - W I', _2: '1', _3: '1', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '4', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '5', _1: '123 - W I', _2: '1', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '6', _1: '123 - W I', _2: '0', _3: '1', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '7', _1: '123 - W I', _2: '1', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '8', _1: '123 - W I', _2: '1', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '9', _1: '123 - W I', _2: '0', _3: '1', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '10', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '11', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '12', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '13', _1: '123 - W I', _2: '0', _3: '1', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '14', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '15', _1: '123 - W I', _2: '1', _3: '1', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '16', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '17', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '18', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '19', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '20', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                    { _0: '21', _1: '123 - W I', _2: '0', _3: '0', _4: 'W I', _5: '123', _6: 'sdsd', },
                ],
            appointmentColumnDescription:
                [
                    { field: '_0', width: 120, headerText: 'Zeile', columnType: 'TEXT' },
                    { field: '_7', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_8', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_9', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_10', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_11', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_12', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_13', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_14', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_15', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_16', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_17', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_18', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_19', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_20', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_21', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_22', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_23', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_24', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_25', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_26', headerText: '123 - W I', columnType: 'TEXT' },
                    { field: '_27', headerText: '123 - W I', columnType: 'TEXT' },
                ],
            appointmentValues:
                [
                    { _0: '1' },
                    { _0: '2' },
                    { _0: '3', _9: 'Z', _21: 'I', },
                    { _0: '4' },
                    { _0: '5', _19: 'I', },
                    { _0: '6', _12: 'Z', },
                    { _0: '7', _12: 'I', },
                    { _0: '8', _12: 'I', _15: 'I', },
                    { _0: '9', _15: 'Z', },
                    { _0: '10' },
                    { _0: '11' },
                    { _0: '12' },
                    { _0: '13', _19: 'Z', },
                    { _0: '14' },
                    { _0: '15', _9: 'I', _21: 'Z', },
                    { _0: '16' },
                    { _0: '17' },
                    { _0: '18' },
                    { _0: '19' },
                    { _0: '20' },
                    { _0: '21' },
                ],
        };
        var amount = 179;
        this.generateAppointmentValues(amount);
        this.generateResourceValues(amount);
        this.MatrixWt = new KeyMatrixWt(this, this.matrixCtrl, this.entityMatrix);
    }

    generateAppointmentValues(amount) {
        for (var iValue = 0; iValue < amount; iValue++) {
            var obj = {};
            obj._0 = 22 + iValue;
            this.entityMatrix.appointmentValues.push(obj);
        }
    }

    generateResourceValues(amount) {
        for (var iValue = 0; iValue < amount; iValue++) {
            var obj = {};
            obj._0 = 22 + iValue;
            obj._1 = "123 - W I";
            obj._2 = "1";
            obj._3 = "0";
            obj._4 = "W I";
            obj._5 = "123";
            obj._6 = "sdsd";
            this.entityMatrix.ressourceValues.push(obj);
        }
    }




    randomBool() {
        var rand = Math.random();
        if (rand <= 0.5) {
            var bool = false;
        }
        else {
            var bool = true;
        }
        return bool;
    }

    randomLetter() {
        var letterArr = ["K", "b", "T", "t", "D", "d"];
        var random = Math.floor(Math.random() * letterArr.length);
        return letterArr[random];
    }

    data1() {
        var dataCount = 10000;
        var dataArray = [];
        for (let i = 0; i < dataCount; i++) {
            var dataObj = {};
            dataObj.taskID = i + 1;
            dataObj.taskName = 'W I ' + (123 + i);
            dataObj.closing = this.randomBool();
            dataObj.centralClosing = this.randomBool();
            dataObj.name = 'W I';
            dataArray.push(dataObj);
        }
        return dataArray;
    }

    data2() {
        var dataCount = 10000;
        var dataArray = [];
        for (let i = 0; i < dataCount; i++) {
            var dataObj = {};
            dataObj.taskID = i + 1;
            dataObj.taskName = this.randomLetter();
            dataObj.closing = this.randomLetter();
            dataObj.centralClosing = this.randomLetter();
            dataObj.name = this.randomLetter();
            dataObj.test1 = this.randomLetter();
            dataObj.test2 = this.randomLetter();
            dataObj.test3 = this.randomLetter();
            dataObj.test4 = this.randomLetter();
            dataObj.test5 = this.randomLetter();
            dataObj.test6 = this.randomLetter();
            dataObj.test7 = this.randomLetter();
            dataObj.test8 = this.randomLetter();
            dataObj.test9 = this.randomLetter();
            dataObj.test10 = this.randomLetter();
            dataObj.test11 = this.randomLetter();
            dataObj.test12 = this.randomLetter();
            dataObj.test13 = this.randomLetter();
            dataObj.test14 = this.randomLetter();
            dataObj.test15 = this.randomLetter();
            dataObj.test16 = this.randomLetter();
            dataObj.test17 = this.randomLetter();
            dataObj.test18 = this.randomLetter();
            dataObj.test19 = this.randomLetter();
            dataObj.test20 = this.randomLetter();
            dataObj.test21 = this.randomLetter();
            dataObj.test22 = this.randomLetter();
            dataObj.test23 = this.randomLetter();
            dataObj.test24 = this.randomLetter();
            dataObj.test25 = this.randomLetter();
            dataObj.test26 = this.randomLetter();
            dataObj.test27 = this.randomLetter();
            dataObj.test28 = this.randomLetter();
            dataObj.test29 = this.randomLetter();
            dataObj.test30 = this.randomLetter();
            dataObj.test31 = this.randomLetter();
            dataObj.test32 = this.randomLetter();
            dataObj.test33 = this.randomLetter();
            dataObj.test34 = this.randomLetter();
            dataObj.test35 = this.randomLetter();
            dataObj.test36 = this.randomLetter();
            dataObj.test37 = this.randomLetter();
            dataObj.test38 = this.randomLetter();
            dataObj.test39 = this.randomLetter();
            dataObj.test40 = this.randomLetter();
            dataArray.push(dataObj);
        }
        return dataArray;
    }
}