﻿using Syncfusion.Blazor;
using Syncfusion.Blazor.Data;

namespace SyncFusionCalendarTest.Pages
{
    public class CustomAdaptor : DataAdaptor
    {
        readonly List<AppointmentData> DataSource = new List<AppointmentData>
        {
            new AppointmentData { Id = 1, Subject = "Paris", StartTime = new DateTime(2020, 2, 13, 10, 0, 0) , EndTime = new DateTime(2020, 2, 13, 12, 0, 0) },
            new AppointmentData { Id = 2, Subject = "Germany", StartTime = new DateTime(2020, 2, 15, 10, 0, 0) , EndTime = new DateTime(2020, 2, 15, 12, 0, 0) }
        };
        public class AppointmentData
        {
            public int Id { get; set; }
            public string Subject { get; set; } = string.Empty;
            public string Location { get; set; } = string.Empty;
            public DateTime StartTime { get; set; }
            public DateTime EndTime { get; set; }
            public string Description { get; set; } = string.Empty;
            public bool IsAllDay { get; set; }
            public string RecurrenceRule { get; set; } = string.Empty;
            public string RecurrenceException { get; set; } = string.Empty;
            public Nullable<int> RecurrenceID { get; set; }
        }

        public override object Read(DataManagerRequest request, string key = null!)
        {
            return request.RequiresCounts ?
                new DataResult() { Result = DataSource, Count = DataSource.Count } :
                (object)DataSource;
        }
    }
}
