﻿using System;
using System.Collections.ObjectModel;

namespace SFGroupedListView
{
	public class MainPageViewModel : BindableObject
	{
		public MainPageViewModel()
		{

            var docs = new List<ItemModel>()
            {
                new ItemModel() { CategoryName = "A", ItemName = "A1" },
                new ItemModel() { CategoryName = "A", ItemName = "A2" },
                new ItemModel() { CategoryName = "A", ItemName = "A3" },
                new ItemModel() { CategoryName = "B", ItemName = "B1" },
                new ItemModel() { CategoryName = "B", ItemName = "B2" },
                new ItemModel() { CategoryName = "B", ItemName = "B3" },
                new ItemModel() { CategoryName = "C", ItemName = "C1" },
                new ItemModel() { CategoryName = "C", ItemName = "C2" },
            };

            DocumentCategories = new ObservableCollection<ItemModel>(docs);
		}

		public class ItemModel
		{
			public string CategoryName { get; set; }

            public string ItemName { get; set; }
        }

        private ObservableCollection<ItemModel> documentCategories = new ObservableCollection<ItemModel>();

        /// <summary>
        /// Gets or sets DocumentCategories collection
        /// </summary>
        public ObservableCollection<ItemModel> DocumentCategories
        {
            get => documentCategories;
            set {

                documentCategories = value;

                OnPropertyChanged(nameof(DocumentCategories)); }
        }
    }
}

