﻿using CommunityToolkit.Mvvm.ComponentModel;
using CommunityToolkit.Mvvm.Input;
using SyncfusionTestingAndFun.Models;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
//using System.Windows.Input;

namespace SyncfusionTestingAndFun.ViewModels
{
    public partial class MainPageViewModel : ObservableObject
    {
        public ObservableCollection<ListItemModel> Items { get; set; } = new ObservableCollection<ListItemModel>();

        [ObservableProperty]
        private bool visible = true;

        public ICommand ListRowTappedCommand { get; set; }

        public MainPageViewModel()
        {
            ListRowTappedCommand = new RelayCommand<object>(RowTapped);
            Items.Add(new ListItemModel() { MainText = "First Row Main", ExtendedText = "First Row Extended" });
            Items.Add(new ListItemModel() { MainText = "Second Row Main", ExtendedText = "Second Row Extended"});
            Items.Add(new ListItemModel() { MainText = "Thrid Row Main", ExtendedText = "Thrid Row Extended" });
        }

        private void RowTapped(object obj)
        {
            var eventArgs = (Syncfusion.Maui.ListView.ItemTappedEventArgs)obj;
            var di = (ListItemModel)eventArgs.DataItem;
            di.Expanded = !di.Expanded;
        }
    }
}
