﻿using Syncfusion.Blazor;

namespace ScheduleWithoutViewsDefined
{
    public class CustomAppointmentAdaptor : DataAdaptor
    {
        List<AppointmentData> data = new List<AppointmentData>()
        {
            new AppointmentData
            {
                 Id = 1,
                Description = "My Description",
                StartTime = DateTime.Now,
                EndTime = DateTime.Now.AddMinutes(45),
                Subject = "Hallo Welt"
            }
        };
        public override Task<object> ReadAsync(DataManagerRequest dataManagerRequest, string key = null)
        {

            var start = (DateTime)dataManagerRequest.Params["StartDate"];
            var end = (DateTime)dataManagerRequest.Params["EndDate"];


            return Task.FromResult((object)data.Where(_ => _.StartTime >= start && _.EndTime <= end));
        }
    }
}
