public partial class Categories : ComponentBase
{
	private bool _isBusy;

	[Inject] IDbContextFactory<ApplicationDbContext> _dbFactory { get; set; }
    private ApplicationDbContext _dbContext;
	
	private int? _selectedCategoryId;

    public SfTreeGrid<Category>? CategoriesGrid { get; set; }

    public ObservableCollection<Category> Categories { get; set; } = new ObservableCollection<Category>();

    private async Task LoadCategories()
    {
        await _dbContext.Categories.Include(x => x.Articles).OrderBy(x => x.Name).LoadAsync();
        Categories = _dbContext.Categories.Local.ToObservableCollection();
    }

    protected override async Task OnInitializedAsync()
    {
		_isBusy = true;
        try
        {
            _dbContext = await _dbFactory.CreateDbContextAsync();
            if (_dbContext is not null)
            {
                await LoadCategories();
            }
        }
        finally
        {
            _isBusy = false;
        }

        await base.OnInitializedAsync();
    }

    public async Task CategoriesActionBeginHandler(ActionEventArgs<Category> Args)
    {
        if (CategoriesGrid == null)
            return;
        // set selected treegrid id before dialog opens
        if (Args.RequestType.IsAdd())
        {
            _selectedCategoryId = (await CategoriesGrid.GetSelectedRecordsAsync())?.FirstOrDefault()?.Id ?? 0;
        }

        
        if (Args.RequestType.IsSave())
        {
            if (Args.Action.IsActionAdd())
            {
                // assign the correct parent id
                Args.Data.ParentId = _selectedCategoryId != 0 ? _selectedCategoryId : null;
            }
        }
    }

    public async Task CategoriesActionCompleteHandler(ActionEventArgs<Category> Args)
    {
        if (Args.RequestType.IsSave() || Args.RequestType.IsDelete() || Args.RequestType.IsRowDragAndDrop())
        {
            await _dbContext.SaveChangesAsync();
        }
    }

}    