using Syncfusion.Pdf.Interactive;
using Syncfusion.Pdf;
using System.Diagnostics;
using Syncfusion.Pdf.Parsing;

namespace WinFormsApp1
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            using (PdfLoadedDocument loadedDocument = new PdfLoadedDocument("TEST.pdf"))
            {
                if (loadedDocument.Form == null)
                {
                    loadedDocument.CreateForm();
                }

                PdfLoadedPage loadedPage = loadedDocument.Pages[0] as PdfLoadedPage;
                PdfTextBoxField textBoxField = new PdfTextBoxField(loadedPage, "FirstName");
                textBoxField.Bounds = new RectangleF(100, 100, 100, 20);
                textBoxField.BackColor = Color.Red;
                textBoxField.ForeColor = Color.Yellow;

                textBoxField.Text = "Hallo!";
                loadedDocument.Form.Fields.Add(textBoxField);

                // Needed otherwise Text is not shown in Acrobat Reader before getting focused! But then the background is only visible when field has focus.
                // Without this call the background color ist visible but not the text without focus
                loadedDocument.Form.SetDefaultAppearance(false);

                loadedDocument.Save("Form1.pdf");
                loadedDocument.Close(true);
            }


            using (PdfLoadedDocument loadedDocument = new PdfLoadedDocument("Form1.pdf"))
            {
                foreach (PdfField field in loadedDocument.Form.Fields)
                {
                    field.Flatten = true;
                }
                // No background color anymore

                loadedDocument.Save("Form2.pdf");
                loadedDocument.Close(true);
            }

            Process.Start(new ProcessStartInfo("Form1.pdf") { UseShellExecute = true });
            Process.Start(new ProcessStartInfo("Form2.pdf") { UseShellExecute = true });
            this.Close();
        }
    }
}