import {
  CollaborativeEditArgs,
  SpreadsheetComponent,
} from "@syncfusion/ej2-react-spreadsheet";
import { isNullOrUndefined } from "@syncfusion/ej2-base";
import * as signalR from "@microsoft/signalr";
import logo from "./logo.svg";
import "./App.css";
import { useEffect, useRef } from "react";

function App() {
  const height = "600px";
  const connection = new signalR.HubConnectionBuilder()
    .withUrl(`https://localhost:7000/SpreadsheetHub`)
    // , {
    //   skipNegotiation: true,
    //   transport: signalR.HttpTransportType.WebSockets,
    // }
    .build();

  const onActionComplete = (args: any): void => {
    if (args.action === "import") {
      // Send the action data to the server from args.response at the time of importing excel file.
      connection.send("BroadcastData", JSON.stringify(args.response.data));
    } else {
      // Send the action data to the server at time of editing on the component.
      connection.send("BroadcastData", JSON.stringify(args));
    }
  };

  const editor = useRef<SpreadsheetComponent>(null);

  useEffect(() => {
    connection.on("dataReceived", (data: string) => {
      const model: CollaborativeEditArgs = JSON.parse(
        data
      ) as CollaborativeEditArgs;
      if (isNullOrUndefined(model["action"])) {
        // To check whether action is import or editing.
        // If its importing then load the imported excel file data as JSON to the connected clients.
        const jsonData: any = { Workbook: model };
        editor.current!.openFromJson({ file: jsonData });
      } else {
        // trigger for actions other than import.
        editor.current!.updateAction(model); // update the action to the connected clients
      }
    });

    connection
      .start()
      .then(() => {
        // to start the server
        console.log("server connected!!!");
      })
      .catch((err) => console.log(err));
  }, []);

  return (
    <SpreadsheetComponent
      ref={editor}
      height={height}
      allowOpen
      allowSave
      openUrl="https://localhost:7000/Open"
      saveUrl="https://localhost:7000/Save"
      actionComplete={onActionComplete}
    />
  );
}

export default App;
