using SyncfusionSpreadsheetApi;

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.

builder.Services.AddCors(c =>
{
    c.AddPolicy(
        "ApiCorsPolicy",
        builder =>
        {
            builder.AllowAnyOrigin()
                .AllowAnyMethod()
                .AllowAnyHeader()
                .AllowCredentials()
                .WithOrigins("http://localhost:3000");
        }
    );
});

builder.Services
    .AddSignalR(e =>
    {
        e.MaximumReceiveMessageSize =
            int.MaxValue; // for Syncfusion Spreadsheet collaborative mode, to enable images sending
    });

builder.Services.AddControllers();
// Learn more about configuring Swagger/OpenAPI at https://aka.ms/aspnetcore/swashbuckle
builder.Services.AddEndpointsApiExplorer();
builder.Services.AddSwaggerGen();

var app = builder.Build();

// Configure the HTTP request pipeline.
if (app.Environment.IsDevelopment())
{
    app.UseSwagger();
    app.UseSwaggerUI();
}


app.MapHub<SpreadsheetHub>("SpreadsheetHub");

app.UseHttpsRedirection();
app.UseCors("ApiCorsPolicy");
app.UseAuthorization();

app.MapControllers();

app.Run();