﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;

namespace FannSoftware.Utilities
{
	public class NotifyModel : INotifyPropertyChanged
	{
		public event PropertyChangedEventHandler PropertyChanged;

		protected bool SetProperty<T>(ref T field, T value, [CallerMemberName] string propertyName = null)
		{
			if(object.Equals(field, value)) { return false; }

			field = value;
			OnPropertyChanged(propertyName);
			return true;
		}

		protected virtual void OnPropertyChanged([CallerMemberName] string propertyName = null)
		{
			try {
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
            } catch(NullReferenceException e1) {
				Debug.WriteLine(e1.ToString());
			}
		}
	}
}
