#region Copyright Syncfusion Inc. 2001-2022.
// Copyright Syncfusion Inc. 2001-2022. All rights reserved.
// Use of this code is subject to the terms of our license.
// A copy of the current license can be obtained at any time by e-mailing
// licensing@syncfusion.com. Any infringement will be prosecuted under
// applicable laws. 
#endregion
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Windows.Data;
using System.Linq;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using Syncfusion.Windows.Shared;
using FannSoftware.Utilities;

namespace TestSfTreeView
{
    public class ProductInfo : NotifyModel
    {
        public ProductInfo()
        {
            models = new ObservableCollection<ProductInfo>();
        }

        private ObservableCollection<ProductInfo> models;
        public ObservableCollection<ProductInfo> Models
        {
            get
            {
                return models;
            }

            set => SetProperty(ref models, value);
        }
       

        #region TreeViewItem Properties

        private string header;
        /// <summary>
        /// Gets or sets a value indicating the Header of the TreeViewItem.
        /// </summary>        
        public string Header
        {
            get
            {
                return header;
            }

            set => SetProperty(ref header, value);
        }

        private string brand;
        /// <summary>
        /// Gets or sets a value indicating the Brand of the TreeViewItem.
        /// </summary>
        public string Brand
        {
            get
            {
                return brand;
            }

            set => SetProperty(ref brand, value);
        }

        private string product;
        /// <summary>
        /// Gets or sets a value indicating the Product of the TreeViewItem.
        /// </summary>
        public string Product
        {
            get
            {
                return product;
            }

            set => SetProperty(ref product, value);
        }

        private string price;
        /// <summary>
        /// Gets or sets a value indicating the Price of the TreeViewItem.
        /// </summary>
        public string Price
        {
            get
            {
                return price;
            }
            set => SetProperty(ref price, value);
        }

        private BitmapImage image;
        /// <summary>
        /// Gets or sets a value indicating the Image of the TreeViewItem.
        /// </summary>
        public BitmapImage Image
        {
            get
            {
                return image;
            }

            set => SetProperty(ref image, value);
        }


        #endregion


        private bool isSelected;

        public bool IsSelected { get => isSelected; set => SetProperty(ref isSelected, value);
        }


        private bool expanded;

        public bool Expanded { get => expanded; set =>SetProperty(ref expanded, value);
        }
        
    }
}
