﻿using Syncfusion.UI.Xaml.TreeView;
using Syncfusion.UI.Xaml.TreeView.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace TestSfTreeView
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            treeView.MouseRightButtonDown += TreeView_MouseRightButtonDown;
        }

        private bool IsMouseOverOnExpander(Syncfusion.UI.Xaml.TreeView.TreeViewItem treeViewItem, Point point)
        {
            if(treeViewItem.TreeViewItemInfo.TreeView.ExpanderPosition == ExpanderPosition.Start)
                return point.X < treeViewItem.IndentationWidth + treeViewItem.ExpanderWidth;
            else
                return point.X > (treeViewItem.ActualWidth - treeViewItem.ExpanderWidth);
        }


        private void TreeView_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            var treeViewNode = this.treeView.GetNodeAt(e.GetPosition(this.treeView));
            var itemInfo = treeView.GetItemInfo(treeViewNode.Content);
            var itemPoint = e.GetPosition(itemInfo.Element);

            if(!this.treeView.FullRowSelect && IsMouseOverOnExpander(itemInfo.Element, itemPoint))
                return;

            this.treeView.SelectedItem = treeViewNode.Content;
        }

        private void treeView_ItemDragOver(object sender, TreeViewItemDragOverEventArgs e)
        {
            if(e.TargetNode.Level == 1) {
                if(e.DropPosition == DropPosition.DropAbove || e.DropPosition == DropPosition.DropBelow)
                    e.DropPosition = DropPosition.None;
            }
        }

        private void treeView_ItemDropping(object sender, TreeViewItemDroppingEventArgs e)
        {
            if(e.TargetNode.Level == 1) {
                if(e.DropPosition == DropPosition.DropAbove || e.DropPosition == DropPosition.DropBelow)
                    e.Handled = true;
            }
        }
    }
}
