﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Timers;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace TestApp
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private readonly Timer AddRecordsTimer = new(200);

        public MainWindow()
        {
            InitializeComponent();

            AddRecordsTimer.Elapsed += AddRecords;
            AddRecordsTimer.AutoReset = true;
            AddRecordsTimer.Enabled = true;
            AddRecordsTimer.Stop();
        }

        private void AddRecords(object? sender, ElapsedEventArgs e)
        {
            System.Windows.Application.Current.Dispatcher.BeginInvoke(() =>
            {
                ViewModel vm = (ViewModel)DataContext;

                for (int i = 0; i < 10; i++)
                {
                    vm.Orders.Add(new(
                        i,
                        "Name " + i.ToString(),
                        "Country " + i.ToString(),
                        "Id " + i.ToString(),
                        "City " + i.ToString()
                    ));
                }
            });
        }

        private void AddButton_Click(object sender, RoutedEventArgs e)
        {
            AddRecordsTimer.Stop();
            AddRecordsTimer.Start();
        }

        private void StopButton_Click(object sender, RoutedEventArgs e)
        {
            AddRecordsTimer.Stop();
        }

        private void DataGridSelectionChanged(object sender, Syncfusion.UI.Xaml.Grid.GridSelectionChangedEventArgs e)
        {
            MessageBox.Show(RecordsDataGrid.SelectedIndex.ToString());
        }
    }
}
