﻿using Data;
using Newtonsoft.Json;
using Resources;
using Syncfusion.JavaScript.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Syncfusion.DocIO;
using Syncfusion.DocIO.DLS;
using System.IO;
using Syncfusion.DocToPDFConverter;
using Syncfusion.Pdf;
using System.Web.Services;
using Syncfusion.JavaScript.Web;
using System.Data;
using System.Threading;
using System.Drawing;
using static Data.MentalViewDataSet;

namespace WebUI
{

    public partial class Appointment : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                Data.MentalViewDataSet ds = null;

                ((Main)this.Master).ServerMessage.ButtonClicked += new ButtonClickedHandler(this.ServerMessageButtonClicked);
                ((Main)this.Master).PageTitle = GetLocalResourceObject("Page.Title").ToString();
                //Καλούμε την javascript Initialization() λόγω του UpdatePanel.
                ScriptManager.RegisterStartupScript(this, this.GetType(), "temp", "<script language='javascript'>Initialization();</script>", false);

                #region  Controls Localization
                //this.startTimeTxtBox.DatePickerButtonText = new ButtonText() { Today = GlobalResources.TodayText, TimeNow = GlobalResources.TimeNowText, Done = GlobalResources.DoneText, TimeTitle = GlobalResources.TimeText };
                this.startDateTxtBox.ButtonText = GlobalResources.TodayText;
                this.startDateTxtBox.DateFormat = System.Threading.Thread.CurrentThread.CurrentUICulture.DateTimeFormat.ShortDatePattern;
                this.startTimeTxtBox.TimeFormat = System.Threading.Thread.CurrentThread.CurrentUICulture.DateTimeFormat.ShortTimePattern;
                this.endTimeTxtBox.TimeFormat = System.Threading.Thread.CurrentThread.CurrentUICulture.DateTimeFormat.ShortTimePattern;

                #endregion


                Dictionary<string, object> userData = JsonConvert.DeserializeObject<Dictionary<string, object>>(CookieHandler.GetAuthCookie(Page).UserData);
                Int64 tenantId = Convert.ToInt64(userData["TenantId"]);
                Int64 userId = Convert.ToInt64(userData["UserId"]);

                #region  Data Bindings
                DropDownListItem ddlItem;

                #region ContactId
                DataTable contactsDT = Data.Business.ContactsBusiness.GetAllContactsList(tenantId);
                DataRow emptyContactsRow = contactsDT.NewRow();
                emptyContactsRow.ItemArray = new object[] { -1, " ", " " };
                contactsDT.Rows.InsertAt(emptyContactsRow, 0);
                this.contactIdCmbBox.DataSource = contactsDT;
                this.contactIdCmbBox.DataBind();
                #endregion

                #region  StateDDL
                if (this.stateDDL.Items.Count == 0)
                {
                    this.stateDDL.Items.Clear();
                    ddlItem = new DropDownListItem();
                    ddlItem.Text = "&nbsp;";
                    ddlItem.Value = "";
                    this.stateDDL.Items.Add(ddlItem);

                    DataTable statesDT = Data.FieldValuesMappings.DataSet.Tables["Appointments-AppointmentStates"];

                    foreach (DataRow statesRow in statesDT.Rows)
                    {
                        ddlItem = new DropDownListItem();
                        ddlItem.Text = statesRow["Text"].ToString();
                        ddlItem.Value = statesRow["Value"].ToString();
                        this.stateDDL.Items.Add(ddlItem);
                    }
                }
                #endregion

                #region  TherapistId
                if (this.therapistIdCmbBox.Items.Count == 0)
                {
                    this.therapistIdCmbBox.Items.Clear();
                    ddlItem = new DropDownListItem();
                    ddlItem.Text = "&nbsp;";
                    ddlItem.Value = "-1";
                    this.therapistIdCmbBox.Items.Add(ddlItem);

                    DataTable doctorsDT = Data.Business.UsersBusiness.GetAllDoctorUsersList(tenantId);
                    foreach (DataRow doctorRow in doctorsDT.Rows)
                    {
                        ddlItem = new DropDownListItem();
                        ddlItem.Text = doctorRow["FullName"].ToString();
                        ddlItem.Value = doctorRow["UserId"].ToString();
                        this.therapistIdCmbBox.Items.Add(ddlItem);
                    }
                }
                #endregion

                #region  AppointmentCategories
                if (this.appointmentCategoryIdDDL.Items.Count == 0)
                {
                    this.appointmentCategoryIdDDL.Items.Clear();
                    ddlItem = new DropDownListItem();
                    ddlItem.Text = "&nbsp;";
                    ddlItem.Value = "-1";
                    this.appointmentCategoryIdDDL.Items.Add(ddlItem);

                    Data.MentalViewDataSet.AppointmentCategoriesDataTable appointmentCategoriesDT = Data.Business.AppointmentCategoriesBusiness.GetAllAppointmentCategories(tenantId);
                    //DataTable appointmentCategoriesDT2 = new DataView(appointmentCategoriesDT, "", "CategoryName", DataViewRowState.CurrentRows).ToTable();

                    foreach (Data.MentalViewDataSet.AppointmentCategoriesRow appointmentCategoriesRow in appointmentCategoriesDT.Rows)
                    {
                        ddlItem = new DropDownListItem();
                        ddlItem.Text = appointmentCategoriesRow.CategoryName;
                        ddlItem.Value = appointmentCategoriesRow.AppointmentCategoryId.ToString();
                        this.appointmentCategoryIdDDL.Items.Add(ddlItem);
                    }
                }
                #endregion

                #region  IntervetionModel
                this.intervetionModelDDL.Items.Clear();
                ddlItem = new DropDownListItem();
                ddlItem.Text = "&nbsp;";
                ddlItem.Value = "-1";
                this.intervetionModelDDL.Items.Add(ddlItem);

                DataTable intervetionModelsDT = Data.FieldValuesMappings.DataSet.Tables["Appointments-IntervetionModels"];

                foreach (DataRow intervetionModelsRow in intervetionModelsDT.Rows)
                {
                    ddlItem = new DropDownListItem();
                    ddlItem.Text = intervetionModelsRow["Text"].ToString();
                    ddlItem.Value = intervetionModelsRow["Value"].ToString();
                    this.intervetionModelDDL.Items.Add(ddlItem);
                }
                #endregion

                //Rooms
                this.roomDDL.Items.Clear();

                DataTable roomsDT = Data.FieldValuesMappings.DataSet.Tables["Appointments-AppointmentRooms"].Copy();
                if (roomsDT.Columns.Contains("HtmlAttr") == false)
                {
                    roomsDT.Columns.Add("HtmlAttr", typeof(string));
                }

                DataRow roomsRow = roomsDT.NewRow();
                roomsRow["RoomName"] = " ";
                roomsRow["RoomId"] = "";
                roomsRow["BackColor"] = "";
                roomsRow["FontColor"] = "";
                roomsDT.Rows.InsertAt(roomsRow, 0);

                foreach (DataRow roomRow in roomsDT.Rows)
                {
                    roomRow["htmlAttr"] = "style='background-color:" + roomRow["BackColor"].ToString() + "'";
                }
                this.roomDDL.DataSource = roomsDT;
                #endregion

                if (!IsPostBack)
                {
                    //Αν δημιουργούμε νέο Appointment
                    if (string.IsNullOrEmpty(this.Request.Params["AppointmentId"]))
                    {
                        ds = new Data.MentalViewDataSet();
                        ds.EnforceConstraints = false;
                        Data.Business.ConfigureDataSet(ref ds);

                        //Δημιουργεί το νεο Appointment
                        MentalViewDataSet.AppointmentsRow appointmentsRow = ds.Appointments.NewAppointmentsRow();
                        appointmentsRow.TenantId = tenantId;
                        appointmentsRow.StartTime = DateTime.Now;
                        appointmentsRow.EndTime = appointmentsRow.StartTime.AddHours(1);
                        ds.Appointments.AddAppointmentsRow(appointmentsRow);

                        ViewState["Appointment"] = ds;
                    }
                    else  //Αν κάνουμε επεξεργασία
                    {
                        int appointmentId = int.Parse(this.Request.Params["AppointmentId"]);

                        ds = (Data.MentalViewDataSet)Data.Business.AppointmentsBusiness.GetAppointmentById(appointmentId);

                        ViewState["Appointment"] = ds;
                    }

                    this.SetDataOnUIControls(ds);

                }
                else  //Αν γίνεται postback
                {
                    ds = (Data.MentalViewDataSet)ViewState["Appointment"];

                    if (Request.Form["__EVENTTARGET"] == this.contactIdCmbBox.ID)
                    {
                        try
                        {
                            this.contactIdCmbBox.Value = Request.Form["ctl00$ctl00$includeFilesBody$mainBody$contactIdCmbBox"];
                            this.GetDataFromUIControls(ref ds);

                            this.SetDataOnUIControls(ds);

                        }
                        catch (Exception exp)
                        {
                            Data.ExceptionLogger.LogException(exp);
                            ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
                        }
                    }
                }

                //this.GetDataFromUIControls(ref ds);

            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }




        private void SetDataOnUIControls(Data.MentalViewDataSet ds)
        {
            this.appointmentIdHiddenField.Value = ds.Appointments[0].AppointmentId.ToString();

            if (ds.Appointments[0].IsContactIdNull())
            {
                this.contactIdCmbBox.Value = "";
            }
            else
            {
                this.contactIdCmbBox.Value = ds.Appointments[0].ContactId.ToString();
            }

            if (ds.Appointments[0].IsUserIdNull())
            {
                this.therapistIdCmbBox.Value = "";
            }
            else
            {
                this.therapistIdCmbBox.Value = ds.Appointments[0].UserId.ToString();
            }

            this.startDateTxtBox.Value = ds.Appointments[0].StartTime;
            this.startTimeTxtBox.Value = ds.Appointments[0].StartTime.ToString("HH:mm:ss");
            this.endTimeTxtBox.Value = ds.Appointments[0].EndTime.ToString("HH:mm:ss");
            if (ds.Appointments[0].IsAppointmentCategoryIdNull() == false)
            {
                this.appointmentCategoryIdDDL.Value = ds.Appointments[0].AppointmentCategoryId.ToString();
            }

            if (ds.Appointments[0].State != "")
            {
                this.stateDDL.Value = ds.Appointments[0].State;
            }
            else
            {
                this.stateDDL.Value = "";
            }

            if (ds.Appointments[0].Room != "")
            {
                this.roomDDL.Value = ds.Appointments[0].Room;
            }
            else
            {
                this.roomDDL.Value = "";
            }

            if (ds.Appointments[0].IsUserIdNull() == false)
            {
                this.therapistIdCmbBox.Value = ds.Appointments[0].UserId.ToString();
            }
            this.requestTxtBox.Text = ds.Appointments[0].Request;
            this.supervisorInstructionsBeforeTxtBox.Text = ds.Appointments[0].SupervisorInstructionsBefore;
            this.supervisorCommentsAfterTxtBox.Text = ds.Appointments[0].SupervisorCommentsAfter;

            if (ds.Appointments[0].IntervetionModel != "")
            {
                this.intervetionModelDDL.Value = ds.Appointments[0].IntervetionModel;
            }
            else
            {
                this.intervetionModelDDL.Value = "";
            }

            this.intervetionTechniquesTxtbox.Text = ds.Appointments[0].IntervetionTechniques;
            this.therapistCommentsTxtBox.Text = ds.Appointments[0].TherapistComments;
            this.supervisionRequestChkBox.Checked = ds.Appointments[0].SupervisionRequest;
            this.notesTxtBox.Text = ds.Appointments[0].Notes;

            this.recurrenceChkBox.Checked = ds.Appointments[0].Recurrence;
            this.recurrenceValueHiddenField.Value = ds.Appointments[0].RecurrenceRule;

            //this.recurrenceEditor.Value= ds.Appointments[0].RecurrenceRule;
        }

        private void GetDataFromUIControls(ref MentalViewDataSet ds)
        {
            try
            {
                if (this.contactIdCmbBox.Value != "-1" && this.contactIdCmbBox.Value != "" && this.contactIdCmbBox.Value != null)
                {
                    ds.Appointments[0].ContactId = Convert.ToInt64(this.contactIdCmbBox.Value);
                }
                else
                {
                    ds.Appointments[0].SetContactIdNull();
                }

                if (this.therapistIdCmbBox.Value != "-1" && this.therapistIdCmbBox.Value != "" && this.therapistIdCmbBox.Value != null)
                {
                    ds.Appointments[0].UserId = Convert.ToInt64(this.therapistIdCmbBox.Value);
                }
                else
                {
                    ds.Appointments[0].SetUserIdNull();
                }

                DateTime startDate = this.startDateTxtBox.Value.Value;
                TimeSpan startTimeSpan = TimeSpan.Parse(this.startTimeTxtBox.Value);
                TimeSpan endTimeSpan = TimeSpan.Parse(this.endTimeTxtBox.Value);
                ds.Appointments[0].StartTime = new DateTime(startDate.Year, startDate.Month, startDate.Day, startTimeSpan.Hours, startTimeSpan.Minutes, 0, 0);
                ds.Appointments[0].EndTime = new DateTime(startDate.Year, startDate.Month, startDate.Day, endTimeSpan.Hours, endTimeSpan.Minutes, 0, 0);

                if (string.IsNullOrEmpty(this.appointmentCategoryIdDDL.Value) == false)
                {
                    if (Convert.ToInt64(this.appointmentCategoryIdDDL.Value) > 0)
                    {
                        ds.Appointments[0].AppointmentCategoryId = Convert.ToInt64(this.appointmentCategoryIdDDL.Value);
                    }
                    else
                    {
                        ds.Appointments[0].SetAppointmentCategoryIdNull();
                    }
                }

                if (this.stateDDL.Value != "" && this.stateDDL.Value != null)
                {
                    ds.Appointments[0].State = this.stateDDL.Value;
                }
                else
                {
                    ds.Appointments[0].State = "";
                }

                if (this.roomDDL.Value != "" && this.roomDDL.Value != null)
                {
                    ds.Appointments[0].Room = this.roomDDL.Value;
                }
                else
                {
                    ds.Appointments[0].Room = "";
                }

                //if (this.therapistIdCmbBox.Value != "")
                //{
                //    ds.Appointments[0].UserId = Convert.ToInt64(this.therapistIdCmbBox.Value);
                //}
                //else
                //{
                //    ds.Appointments[0].SetUserIdNull();
                //}
                ds.Appointments[0].Request = this.requestTxtBox.Text;
                ds.Appointments[0].SupervisorInstructionsBefore = this.supervisorInstructionsBeforeTxtBox.Text;
                ds.Appointments[0].SupervisorCommentsAfter = this.supervisorCommentsAfterTxtBox.Text;

                if (this.intervetionModelDDL.Value != "" && this.intervetionModelDDL.Value != null)
                {
                    ds.Appointments[0].IntervetionModel = this.intervetionModelDDL.Value;
                }
                else
                {
                    ds.Appointments[0].IntervetionModel = "";
                }

                ds.Appointments[0].IntervetionTechniques = this.intervetionTechniquesTxtbox.Text;
                ds.Appointments[0].TherapistComments = this.therapistCommentsTxtBox.Text;
                ds.Appointments[0].SupervisionRequest = this.supervisionRequestChkBox.Checked;
                ds.Appointments[0].Notes = this.notesTxtBox.Text;

                ds.Appointments[0].Recurrence = recurrenceChkBox.Checked;
                if (ds.Appointments[0].Recurrence == true)
                {
                    ds.Appointments[0].RecurrenceRule = this.recurrenceValueHiddenField.Value;
                }
                else
                {
                    ds.Appointments[0].RecurrenceRule = "";
                }
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        protected void saveCloseBtn_Click(object sender, EventArgs e)
        {
            try
            {
                this.Save(true);
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        protected void saveBtn_Click(object sender, EventArgs e)
        {
            try
            {
                this.Save(false);
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        private void Save(bool close)
        {
            try
            {
                Data.MentalViewDataSet ds = (Data.MentalViewDataSet)ViewState["Appointment"];
                ds.EnforceConstraints = false;

                if (this.ValidateControls() == true)
                {
                    this.GetDataFromUIControls(ref ds);

                    //Ελέγχει να μην καταχωρηθεί reccurent appointment με κενό recurrentRule γιατί κολλάει η εφαρμογή.
                    if (ds.Appointments[0].Recurrence == true && ds.Appointments[0].RecurrenceRule == "")
                    {
                        ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("InvalidAppointmentRecurrenceMessage").ToString(), ServerMessageButtons.Ok);
                        ViewState["Appointment"] = ds;
                        return;
                    }

                    //Αν το appointment είναι recurrent τότε ελέγχει να μην διαρκούν όλα τα appointment περισσότερο από ένα έτος.
                    if (ds.Appointments[0].Recurrence == true)
                    {
                        if (this.ValidateRecurrence(ds.Appointments[0].RecurrenceRule) == false)
                        {
                            ViewState["Appointment"] = ds;
                            this.SetDataOnUIControls(ds);
                            ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("ExceedingAppointmentRecurrenceMessage").ToString(), ServerMessageButtons.Ok);
                            return;
                        }
                    }

                    Data.Business.SaveAllData(ds);
                    ViewState["Appointment"] = ds;

                    if (close)
                    {
                        ViewState.Remove("Appointment");
                        Response.Redirect(@"~\Appointments.aspx");
                    }
                    else
                    {
                        this.SetDataOnUIControls(ds);
                    }
                }
                else
                {
                    this.GetDataFromUIControls(ref ds);
                    Data.Business.SaveAllData(ds);
                    ViewState["Appointment"] = ds;
                }
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        private bool ValidateRecurrence(string recurrenceRule)
        {
            //Αν δεν περιέχει καν τη λέξη COUNT, δηλαδή δεν έχει τέλος του recurrence
            if (recurrenceRule.Contains("COUNT") == false)
            {
                return false;
            }
            else
            {
                List<DateTime> dates = new List<DateTime>();
                //Pass the recurrencerule string and the start date of the appointment to this method that returns the dates collection based on the recurrence rule
                dates = Data.RecurrenceHelper.GetRecurrenceDateTimeCollection(recurrenceRule, DateTime.Now.Date).ToList();

                if ((dates[dates.Count - 1] - dates[0]).TotalDays > 365)
                {
                    return false;
                }
                else
                {
                    return true;
                }
            }
        }

        protected void cancelBtn_Click(object sender, EventArgs e)
        {
            ViewState.Remove("Appointment");
            Response.Redirect(@"Appointments.aspx");
        }

        protected void deleteBtn_Click(object sender, EventArgs e)
        {
            try
            {
                Data.MentalViewDataSet ds = (Data.MentalViewDataSet)ViewState["Appointment"];

                ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.DeleteConfirmationMessage, ServerMessageButtons.YesNo, "Delete");

                this.GetDataFromUIControls(ref ds);
                ViewState["Appointment"] = ds;
                this.SetDataOnUIControls(ds);
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        private void Delete()
        {
            Data.MentalViewDataSet ds = (MentalViewDataSet)ViewState["Appointment"];

            ds.Appointments[0].Delete();
            Data.Business.SaveAllData(ds);

            ViewState.Remove("Appointment");
            Response.Redirect(@"Appointments.aspx");
        }

        private void ServerMessageButtonClicked(object sender, ButtonClickedArgs args)
        {
            try
            {
                if (args.Action == "Delete")
                {
                    if (args.ButtonClicked == ButtonClicked.Yes)
                    {
                        this.Delete();
                    }
                }
                else if (args.Action == "SessionExpired")
                {
                    Response.Redirect("Default.aspx");
                }

                Data.MentalViewDataSet ds = (Data.MentalViewDataSet)ViewState["Appointment"];
                this.SetDataOnUIControls(ds);
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        //private bool ValidateData(Data.MentalViewDataSet.AppointmentsRow appointmentsRow)
        //{
        //    try
        //    {
        //        //Αν το πεδίο UserId (
        //        if (appointmentsRow.IsUserIdNull() == true)
        //        {
        //            ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("StartTimeLaterThanEndTimeMessage").ToString(), ServerMessageButtons.Ok, "");
        //            return false;
        //        }

        //        //Αν η ημερομηνία Άφιξη είναι μεταγενέστερη της Αναχώρησης
        //        if (appointmentsRow.StartTime > appointmentsRow.EndTime)
        //        {
        //            ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("StartTimeLaterThanEndTimeMessage").ToString(), ServerMessageButtons.Ok, "");
        //            return false;
        //        }

        //        return true;
        //    }
        //    catch (Exception exp)
        //    {
        //        Data.ExceptionLogger.LogException(exp);
        //        throw;
        //    }
        //}

        private bool ValidateControls()
        {
            try
            {
                //Επαφή
                if (this.contactIdCmbBox.Value == null || this.contactIdCmbBox.Value == "" || this.contactIdCmbBox.Value == "-1")
                {
                    ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("ContactRequiredMessage").ToString(), ServerMessageButtons.Ok, "");
                    return false;
                }

                //Αν το πεδίο UserId (
                if (this.therapistIdCmbBox.Value == null || this.therapistIdCmbBox.Value == "" || this.therapistIdCmbBox.Value == "-1")
                {
                    ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("TherapistRequiredMessage").ToString(), ServerMessageButtons.Ok, "");
                    return false;
                }

                //Αν η ημερομηνία Άφιξη είναι null
                if (this.startTimeTxtBox.Value == null)
                {
                    ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("StartTimeRequiredMessage").ToString(), ServerMessageButtons.Ok, "");
                    return false;
                }

                //Αν η ημερομηνία Αναχώρηση είναι null
                if (this.endTimeTxtBox.Value == null)
                {
                    ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("EndTimeRequiredMessage").ToString(), ServerMessageButtons.Ok, "");
                    return false;
                }

                //Αν η ώρα Έναρξης είναι μεταγενέστερη της Λήξης
                TimeSpan startTimeTimeSpan = TimeSpan.Parse(this.startTimeTxtBox.Value);
                TimeSpan endTimeTimeSpan = TimeSpan.Parse(this.endTimeTxtBox.Value);

                if (startTimeTimeSpan > endTimeTimeSpan)
                {
                    ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("StartTimeLaterThanEndTimeMessage").ToString(), ServerMessageButtons.Ok, "");
                    return false;
                }

                return true;
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                throw;
            }
        }

        protected void sendServiceEmailToContact_Click(object sender, EventArgs e)
        {
            try
            {
                this.SendServiceEmailToContact();
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        private void SendServiceEmailToContact()
        {
            try
            {
                Data.MentalViewDataSet ds = (MentalViewDataSet)ViewState["Appointment"];

                //Ενημερώνει το ds με τα στοιχεία του Contact
                ds.Contacts.Merge(Data.Business.ContactsBusiness.GetContactById(ds.Appointments[0].ContactId).Contacts);

                //Αν το Contact έχει email
                if (ds.Appointments[0].ContactsRow.Email != "")
                {
                    if (ds.Appointments[0].IsUserIdNull() == false)
                    {
                        //Ενημερώνει το ds με τα στοιχεία του User
                        ds.Users.Merge(Data.Business.UsersBusiness.GetUserById(ds.Appointments[0].UserId).Users);
                    }

                    //Ενημερώνει το ds με τα στοιχεία του AppointmentCategories
                    ds.AppointmentCategories.Merge(Data.Business.AppointmentCategoriesBusiness.GetAllAppointmentCategories(ds.Appointments[0].TenantId));

                    //EmailManager.SendReservationEmailToContact(ds.Appointments[0].ContactsRow.Email, ds);

                    this.SetDataOnUIControls(ds);
                }
                else
                {
                    ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ContactHasNoEmailMessage, ServerMessageButtons.Ok, "");
                }
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        protected void sendServiceEmailToUser_Click(object sender, EventArgs e)
        {
            try
            {
                //this.SendServiceEmailToUser();
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        //private void SendServiceEmailToUser()
        //{
        //    try
        //    {
        //        Data.MentalViewDataSet ds = (MentalViewDataSet)ViewState["Appointment"];

        //        this.GetDataFromUIControls(ref ds);

        //        //Διαβάζει το email του χρήστη
        //        Dictionary<string, object> userData = JsonConvert.DeserializeObject<Dictionary<string, object>>(CookieHandler.GetAuthCookie(Page).UserData);
        //        Int64 userId = Convert.ToInt64(userData["UserId"]);
        //        Data.MentalViewDataSet userDS = Data.Business.UsersBusiness.GetUserById(userId);

        //        if (userDS.Users[0].Email != "")
        //        {
        //            //Ενημερώνει το ds με τα στοιχεία του Contact
        //            ds.Contacts.Merge(Data.Business.ContactsBusiness.GetContactById(ds.Appointments[0].ContactId).Contacts);

        //            //Ενημερώνει το ds με τα στοιχεία του Contact
        //            ds.PredefAppointmentItems.Merge(Data.Business.PredAppointmentItemsBusiness.GetAllPredefAppointmentItemsList(ds.Appointments[0].TenantId));

        //            if (ds.Appointments[0].IsUserIdNull() == false)
        //            {
        //                //Ενημερώνει το ds με τα στοιχεία του User
        //                ds.Users.Merge(Data.Business.UsersBusiness.GetUserById(ds.Appointments[0].UserId).Users);
        //            }

        //            //Ενημερώνει το ds με τα στοιχεία του AppointmentCategories
        //            ds.AppointmentCategories.Merge(Data.Business.AppointmentCategoriesBusiness.GetAllAppointmentCategories(ds.Appointments[0].TenantId));

        //            EmailManager.SendReservationEmailToContact(userDS.Users[0].Email, ds);

        //            this.SetDataOnUIControls(ds);
        //        }
        //        else
        //        {
        //            ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.UserHasNoEmailMessage, ServerMessageButtons.Ok, "");
        //        }
        //    }
        //    catch (Exception exp)
        //    {
        //        Data.ExceptionLogger.LogException(exp);
        //        ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
        //    }
        //}

        //protected void sendServiceEmailToAdmin_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        this.SendServiceEmailToAdmin();
        //    }
        //    catch (Exception exp)
        //    {
        //        Data.ExceptionLogger.LogException(exp);
        //        ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
        //    }
        //}

        //private void SendServiceEmailToAdmin()
        //{
        //    try
        //    {
        //        Data.MentalViewDataSet ds = (MentalViewDataSet)ViewState["Appointment"];
        //        this.GetDataFromUIControls(ref ds);

        //        //Ενημερώνει το ds με τα στοιχεία του Contact
        //        ds.Contacts.Merge(Data.Business.ContactsBusiness.GetContactById(ds.Appointments[0].ContactId).Contacts);

        //        //Ενημερώνει το ds με τα στοιχεία του Contact
        //        ds.PredefAppointmentItems.Merge(Data.Business.PredAppointmentItemsBusiness.GetAllPredefAppointmentItemsList(ds.Appointments[0].TenantId));

        //        if (ds.Appointments[0].IsUserIdNull() == false)
        //        {
        //            //Ενημερώνει το ds με τα στοιχεία του User
        //            ds.Users.Merge(Data.Business.UsersBusiness.GetUserById(ds.Appointments[0].UserId).Users);
        //        }

        //        //Ενημερώνει το ds με τα στοιχεία του AppointmentCategories
        //        ds.AppointmentCategories.Merge(Data.Business.AppointmentCategoriesBusiness.GetAllAppointmentCategories(ds.Appointments[0].TenantId));

        //        EmailManager.SendReservationEmailToContact("petermanesis@hotmail.com", ds);

        //        this.SetDataOnUIControls(ds);
        //    }
        //    catch (Exception exp)
        //    {
        //        Data.ExceptionLogger.LogException(exp);
        //        ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
        //    }
        //}

        #region  Reports
        private WordDocument PrepareAppointmentReport()
        {
            try
            {
                Data.MentalViewDataSet ds = (Data.MentalViewDataSet)ViewState["Appointment"];
                this.GetDataFromUIControls(ref ds);

                //Ενημερώνει το ds με τα στοιχεία του Contact
                ds.Contacts.Merge(Data.Business.ContactsBusiness.GetContactById(ds.Appointments[0].ContactId).Contacts);

                //Ενημερώνει το ds με τα στοιχεία του AppointmentCategory
                if (ds.Appointments[0].IsAppointmentCategoryIdNull() == false)
                {
                    ds.AppointmentCategories.Merge(Data.Business.AppointmentCategoriesBusiness.GetByAppointmentCategoryId(ds.Appointments[0].AppointmentCategoryId).AppointmentCategories);
                }

                //Ενημερώνει το ds με τα στοιχεία του TherapistId
                if (ds.Appointments[0].IsUserIdNull() == false)
                {
                    ds.Users.Merge(Data.Business.UsersBusiness.GetUserById(ds.Appointments[0].UserId).Users);
                }

                WordDocument document = new WordDocument();

                //Loads or opens an existing Word document from stream
                FileStream fileStreamPath = new FileStream(Server.MapPath(@"AppointmentReport.docx"), FileMode.Open, FileAccess.Read, FileShare.ReadWrite);
                //Loads or opens an existing Word document through Open method of WordDocument class 
                document.Open(fileStreamPath, FormatType.Automatic);

                #region  Εισάγει τα πεδία
                //Στοιχεία επαφής
                document.Replace("[ContactFullName]", ds.Appointments[0].ContactFullName, false, true);
                document.Replace("[StartEndDate]", ds.Appointments[0].StartTime.Date.ToShortDateString() + " " + ds.Appointments[0].StartTime.ToShortTimeString() + " - " + ds.Appointments[0].EndTime.ToShortTimeString(), false, true);
                if (ds.Appointments[0].IsAppointmentCategoryIdNull() == false)
                {
                    document.Replace("[Category]", ds.Appointments[0].AppointmentCategoriesRow.CategoryName, false, true);
                }
                else
                {
                    document.Replace("[Category]", "", false, true);
                }

                if (ds.Appointments[0].IsUserIdNull() == false)
                {
                    document.Replace("[TherapistFullName]", ds.Appointments[0].UsersRow.FullName, false, true);
                }
                else
                {
                    document.Replace("[TherapistFullName]", "", false, true);
                }

                document.Replace("[EndTime]", ds.Appointments[0].EndTime.ToString("HH:mm"), false, true);
                document.Replace("[Request]", ds.Appointments[0].Request, false, true);
                if (ds.Appointments[0].State != "" && ds.Appointments[0].State != "-1")
                {
                    document.Replace("[State]", Data.FieldValuesMappings.GetDisplayOfSingleValue("AppointmentStates", ds.Appointments[0].State), false, true);

                }
                else
                {
                    document.Replace("[State]", "", false, true);
                }
                document.Replace("[SupervisorInstructionsBefore]", ds.Appointments[0].SupervisorInstructionsBefore, false, true);
                document.Replace("[IntervetionModel]", ds.Appointments[0].IntervetionModel, false, true);
                document.Replace("[TherapistComments]", ds.Appointments[0].TherapistComments, false, true);
                document.Replace("[IntervetionTechniques]", ds.Appointments[0].IntervetionTechniques, false, true);
                document.Replace("[SupervisionRequest]", ds.Appointments[0].SupervisionRequest ? "Ναι" : "Όχι", false, true);
                document.Replace("[SupervisorCommentsAfter]", ds.Appointments[0].SupervisorCommentsAfter, false, true);
                document.Replace("[Notes]", ds.Appointments[0].Notes, false, true);


                //document.Replace("[TV]", (this.ExistInAppointmentItems(ds, "Τηλεόραση") ? "Χ" : ""), false, true);
                //document.Replace("[Internet]", (this.ExistInAppointmentItems(ds, "Internet") ? "Χ" : ""), false, true);
                //document.Replace("[CCTV]", (this.ExistInAppointmentItems(ds, "CCTV") ? "Χ" : ""), false, true);
                //document.Replace("[Alarm]", (this.ExistInAppointmentItems(ds, "Alarm") ? "Χ" : ""), false, true);
                //document.Replace("[AutoRailingDoor]", (this.ExistInAppointmentItems(ds, "Αυτ/σμός Καγκελόπορτας") ? "Χ" : ""), false, true);
                //document.Replace("[DoorCommunication]", (this.ExistInAppointmentItems(ds, "Θυροτηλεόραση") ? "Χ" : ""), false, true);
                //document.Replace("[General]", (this.ExistInAppointmentItems(ds, "Γενικά") ? "Χ" : ""), false, true);


                #endregion

                return document;

            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                throw;
            }
        }

        protected void previewAppointmentReportBtn_Click(object sender, EventArgs e)
        {
            try
            {
                Data.MentalViewDataSet ds = (Data.MentalViewDataSet)ViewState["Appointment"];
                this.GetDataFromUIControls(ref ds);

                //Αν ΔΕΝ είναι συμπληρωμένο το πεδίο του Πελάτη
                if (this.contactIdCmbBox.Value == "")
                {
                    ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("ContactRequiredMessage").ToString(), ServerMessageButtons.Ok, "");
                }
                else
                {
                    ViewState["Appointment"] = ds;

                    if (this.ValidateControls())
                    {
                        //Loads an existing Word document
                        WordDocument wordDocument = this.PrepareAppointmentReport();

                        Session["Report"] = wordDocument;
                        Session["ReportName"] = Resources.GlobalResources.AppointmentReportText + " " + ds.Appointments[0].AppointmentId.ToString() + ".pdf";

                        ClientScript.RegisterStartupScript(this.GetType(), "OpenWin", @"window.open('/Reporting/ExportWordReport.aspx?Inline=true','_blank');", true);
                    }
                }

                this.SetDataOnUIControls(ds);
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        protected void exportAppointmentReportToPdfBtn_Click(object sender, EventArgs e)
        {
            try
            {
                Data.MentalViewDataSet ds = (Data.MentalViewDataSet)ViewState["Appointment"];
                this.GetDataFromUIControls(ref ds);

                //Αν ΔΕΝ είναι συμπληρωμένο το πεδίο του Πελάτη
                if (this.contactIdCmbBox.Value == "")
                {
                    ((Main)this.Master).ServerMessage.ShowModal(Resources.GlobalResources.ApplicationTitle, GetLocalResourceObject("ContactRequiredMessage").ToString(), ServerMessageButtons.Ok, "");
                }
                else
                {
                    ViewState["Appointment"] = ds;

                    if (this.ValidateControls())
                    {
                        //Loads an existing Word document
                        WordDocument wordDocument = this.PrepareAppointmentReport();
                        //Initializes the ChartToImageConverter for converting charts during Word to pdf conversion
                        //wordDocument.ChartToImageConverter =  new ChartToImageConverter();
                        //Creates an instance of the DocToPDFConverter
                        DocToPDFConverter converter = new DocToPDFConverter();
                        //Converts Word document into PDF document
                        PdfDocument pdfDocument = converter.ConvertToPDF(wordDocument);
                        //Saves the PDF file 
                        //pdfDocument.Save("WordtoPDF.pdf");
                        MemoryStream stream = new MemoryStream();
                        //Saves the document to t
                        pdfDocument.Save(Resources.GlobalResources.AppointmentReportText + " " + ds.Appointments[0].AppointmentId.ToString() + ".pdf", Response, HttpReadType.Save);
                        //Closes the instance of document objects
                        pdfDocument.Close(true);
                        wordDocument.Close();
                    }
                }
                this.SetDataOnUIControls(ds);
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }

        #endregion



        protected void showContactBtn_Click(object sender, EventArgs e)
        {
            try
            {
                Data.MentalViewDataSet ds = (MentalViewDataSet)ViewState["Appointment"];
                this.GetDataFromUIControls(ref ds);

                if (ds.Appointments[0].ContactId >= 0)
                {
                    Response.Redirect(@"Contact.aspx?ContactId=" + ds.Appointments[0].ContactId.ToString());

                }
            }
            catch (Exception exp)
            {
                Data.ExceptionLogger.LogException(exp);
                ((Main)this.Master).ServerMessage.Show(Resources.GlobalResources.ApplicationTitle, Resources.GlobalResources.ExceptionOccuredMessage, ServerMessageButtons.Ok);
            }
        }





    }
}