﻿<%@ Page Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true" CodeBehind="Appointment.aspx.cs" Inherits="WebUI.Appointment" meta:resourcekey="Page" %>

<%@ Register Assembly="Syncfusion.EJ.Web" Namespace="Syncfusion.JavaScript.Web" TagPrefix="ej" %>
<%@ Register Assembly="Syncfusion.EJ" Namespace="Syncfusion.JavaScript.Models" TagPrefix="ej" %>

<asp:Content ID="mainHeadContent" ContentPlaceHolderID="mainHead" runat="server">
    <script type="text/javascript">
        var initialized = false;

        $(document).ready(function () {
            try {
                var recObj = $("#recurrenceEditor").ejRecurrenceEditor('instance');
                recObj._recRule = $("#recurrenceValueHiddenField").val();
                recObj.recurrenceRuleSplit(recObj._recRule, ''); //splitting the recurrence rule. Κανανονικά στη 2η παράμετρο πρέπει να μπει το πεδίο appointment.recurrenceExDate που είναι οι ημερομηνίες που εξαιρούνται από το recurrence.
                //Αν το AppointmentId είναι >0 (δηλαδή το Appointment δεν είναι καινούριο) αλλιώς βγάζει σφάλμα.
                if ($("#appointmentIdHiddenField").val() > 0) {
                    if ($("#recurrenceValueHiddenField").val().length > 0) {
                        recObj.showRecurrenceSummary($("#appointmentIdHiddenField").val()); // updating the recurrence rule in Recurrence editor
                    }
                }
                
                initialized = true;

                updateRecurrenceEditorVisibility();
            }
            catch (exp) {
                alert('exception:' + exp);
                throw exp;
            }
        });

        function Initialization() {
            SetLocalization();

            //Σετάρει τα Currency TextBoxes
            $(document).on('keydown', 'input[pattern]', function (e) {
                var input = $(this);
                var oldVal = input.val();
                var regex = new RegExp(input.attr('pattern'), 'g');

                setTimeout(function () {
                    var newVal = input.val();
                    if (!regex.test(newVal)) {
                        input.val(oldVal);
                    }
                }, 0);
            });

            $("input[pattern]").change(function () {
                this.value = parseFloat(this.value).toFixed(2);
                if (this.value == 'NaN') {
                    this.value = 0;
                }
            });

            $("#supervisionRequestChkBox").bootstrapSwitch('onText', "<%= GetGlobalResourceObject("GlobalResources", "YesText").ToString() %>").bootstrapSwitch('offText', "<%= GetGlobalResourceObject("GlobalResources", "NoText").ToString() %>");
            $("#recurrenceChkBox").bootstrapSwitch('onText', "<%= GetGlobalResourceObject("GlobalResources", "YesText").ToString() %>").bootstrapSwitch('offText', "<%= GetGlobalResourceObject("GlobalResources", "NoText").ToString() %>");
        }

        function SearchContacts() {
            try {
                __doPostBack('contactIdCmbBox', $("#contactIdCmbBox").val());
            }
            catch (e) { return true; }
        }

        function NotFound() {
            var $not_found = "Δεν βρέθηκαν αποτελέσματα";
            return $not_found;
        }

        function onRecurrenceEditorChange(args) {
            if (initialized) {
                var obj = $("#recurrenceEditor").data("ejRecurrenceEditor");
                $("#recurrenceValueHiddenField").val(obj.getRecurrenceRule());
                console.log('onRecurrenceEditorChange' + obj.getRecurrenceRule());
            }
        }

        function recurrenceCheckClicked() {
            updateRecurrenceEditorVisibility();
        }

        function updateRecurrenceEditorVisibility() {
            var checked = $('#recurrenceChkBox').is(':checked');
            if (checked == true) {
                $("#recurrenceEditorWrapper").css("display", "");
            }
            else {
                $("#recurrenceEditorWrapper").css("display", "none");
            }
        }

        //Εκτελείται όταν ο χρήστης πατήσει Save πριν το server-side event.
        function onClientSaveClose() {
            if (initialized) {
                //Διαβάζει το recurrenceRule που έφτιαξε ο χρήστης, για να αποθηκευτεί στο server side.
                var obj = $("#recurrenceEditor").data("ejRecurrenceEditor");
                obj.closeRecurPublic();
                $("#recurrenceValueHiddenField").val(obj.getRecurrenceRule());
                console.log('clientSaveClose' + obj.getRecurrenceRule());
            }
        }
    </script>
</asp:Content>
<asp:Content ID="mainBodyContent" ContentPlaceHolderID="mainBody" runat="server">
    <div class="row margin-bottom">
        <div class="col-xs-8">
            <div class="btn-group margin-r-5">
                <asp:LinkButton ID="saveCloseBtn" runat="server" CssClass="btn btn-primary btn-flat" OnClientClick="onClientSaveClose()" OnClick="saveCloseBtn_Click"><span class="hidden-md hidden-lg"><i class="fa fa-save "></i></span><asp:Label Text="<%$ Resources:GlobalResources, SaveClose %>" CssClass="hidden-sm hidden-xs" runat="server"></asp:Label></asp:LinkButton>
                <button type="button" class="btn btn-primary btn-flat dropdown-toggle" data-toggle="dropdown">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                </button>
                <ul class="dropdown-menu" role="menu">
                    <li>
                        <asp:LinkButton ID="saveBtn" runat="server" Text="<%$ Resources:GlobalResources, Save %>" OnClientClick="onClientSaveClose()" OnClick="saveBtn_Click"></asp:LinkButton>
                    </li>
                </ul>
            </div>
            <asp:LinkButton ID="deleteBtn" runat="server" DisableValidation="True" CssClass="btn btn-danger btn-flat margin-bottom margin-r-5" OnClick="deleteBtn_Click" CausesValidation="False"><span class="hidden-md hidden-lg"><i class="fa fa-trash"></i></span><asp:Label Text="<%$ Resources:GlobalResources, Delete %>" CssClass="hidden-sm hidden-xs" runat="server"></asp:Label></asp:LinkButton>
            <asp:LinkButton ID="cancelBtn" runat="server" DisableValidation="True" CssClass="btn btn-default btn-flat margin-bottom margin-r-5" OnClick="cancelBtn_Click" CausesValidation="False" PostBackUrl="~/Appointments.aspx"><span class="hidden-md hidden-lg"><i class="fa fa-remove"></i></span><asp:Label Text="<%$ Resources:GlobalResources, Cancel %>" CssClass="hidden-sm hidden-xs" runat="server"></asp:Label></asp:LinkButton>
        </div>
        <div class="col-cs-4">
            <div class="btn-group margin-bottom margin-r-5 pull-right">
                <button type="button" id="appointmentReportBtn" runat="server" class="btn btn-default btn-flat dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
                    <asp:Label runat="server" meta:resourcekey="appointmentReportLbl"></asp:Label>
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu" role="menu">
                    <li>
                        <asp:LinkButton ID="previewAppointmentReportBtn" runat="server" Text="<%$ Resources:GlobalResources, Preview %>" OnClick="previewAppointmentReportBtn_Click"></asp:LinkButton>
                    </li>
                    <li>
                        <asp:LinkButton ID="exportAppointmentReportToPdfBtn" runat="server" Text="<%$ Resources:GlobalResources, ExportToPdf %>" OnClick="exportAppointmentReportToPdfBtn_Click"></asp:LinkButton>
                    </li>
                </ul>
            </div>
            <div class="btn-group margin-bottom margin-r-5 pull-right">
                <%--<button type="button" id="serviceEmailBtn" runat="server" class="btn btn-default btn-flat dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
                    <asp:Label runat="server" meta:resourcekey="serviceEmailLbl"></asp:Label>
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu" role="menu">
                    <li>
                        <asp:LinkButton ID="sendServiceEmailToUser" runat="server" meta:resourceKey="sendServiceEmailToUser" OnClick="sendServiceEmailToUser_Click"></asp:LinkButton>
                    </li>
                    <li>
                        <asp:LinkButton ID="sendServiceEmailToContact" runat="server" meta:resourceKey="sendServiceEmailToContact" OnClick="sendServiceEmailToContact_Click"></asp:LinkButton>
                    </li>
                      <li>
                        <asp:LinkButton ID="sendServiceEmailToAdmin" runat="server" meta:resourceKey="sendServiceEmailToAdmin" OnClick="sendServiceEmailToAdmin_Click"></asp:LinkButton>
                    </li>
                </ul>--%>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="row">
                <div class="col-xs-12">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="contactIdCmbBox" runat="server" class="col-sm-2 control-label" meta:resourcekey="contactIdLbl"></asp:Label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <%--<select runat="server" style="width: 100%;" datavaluefield="ContactId" datatextfield="FullName" id="contactIdCmbBox" class="form-control"></select>--%>
                                    <ej:DropDownList ID="contactIdCmbBox" DataValueField="ContactId" DataTextField="FullName" runat="server" FilterType="Contains" EnableFilterSearch="true" WatermarkText="" Width="100%">
                                    </ej:DropDownList>
                                    <span class="input-group-addon borderless required-mark"><i class="fa fa-asterisk margin-r-5"></i></span>
                                    <asp:LinkButton ID="showContactBtn" runat="server" DisableValidation="True" CssClass="btn btn-default btn-flat margin-r-5" OnClick="showContactBtn_Click" OnClientClick="document.forms[0].target = '_blank';" CausesValidation="False"><span class="hidden-md hidden-lg"><i class="fa fa-user"></i></span><asp:Label meta:resourceKey="showContactLbl" CssClass="hidden-sm hidden-xs" runat="server"></asp:Label></asp:LinkButton>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="startDateTxtBox" runat="server" class="col-sm-2 control-label" meta:resourcekey="startDateLbl"></asp:Label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <ej:DatePicker ID="startDateTxtBox" Width="100%" Locale="el-GR" runat="server"></ej:DatePicker>
                                    <span class="input-group-addon borderless required-mark"><i class="fa fa-asterisk"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="startTimeTxtBox" runat="server" class="col-sm-4 control-label" meta:resourcekey="startTimeLbl"></asp:Label>
                            <div class="col-sm-8">
                                <div class="input-group">
                                    <ej:TimePicker ID="startTimeTxtBox" Width="100%" Locale="el-GR" runat="server"></ej:TimePicker>
                                    <span class="input-group-addon borderless required-mark"><i class="fa fa-asterisk"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="endTimeTxtBox" runat="server" class="col-sm-4 control-label" meta:resourcekey="endTimeLbl"></asp:Label>
                            <div class="col-sm-8">
                                <div class="input-group">
                                    <ej:TimePicker ID="endTimeTxtBox" Width="100%" Locale="el-GR" runat="server">
                                        <ValidationRules>
                                            <ej:KeyValue Key="required" Value="true" />
                                        </ValidationRules>
                                        <ValidationMessages>
                                            <ej:KeyValue Key="required" Value="* απαιτείται" />
                                        </ValidationMessages>
                                    </ej:TimePicker>
                                    <span class="input-group-addon borderless required-mark"><i class="fa fa-asterisk"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="appointmentCategoryIdDDL" runat="server" class="col-sm-4 control-label" meta:resourcekey="appointmentCategoryIdLbl"></asp:Label>
                            <div class="col-sm-8">
                                <ej:DropDownList ID="appointmentCategoryIdDDL" runat="server" WatermarkText="" Width="100%">
                                </ej:DropDownList>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="therapistIdCmbBox" runat="server" class="col-sm-4 control-label" meta:resourcekey="therapistIdLbl"></asp:Label>
                            <div class="col-sm-8">
                                <div class="input-group">
                                    <%--<select runat="server" style="width: 100%;" datavaluefield="UserId" datatextfield="FullName" id="therapistIdCmbBox" class="form-control"></select>--%>
                                    <ej:DropDownList ID="therapistIdCmbBox" DataTextField="FullName" DataValueField="UserId" runat="server" WatermarkText="" Width="100%">
                                    </ej:DropDownList>
                                    <span class="input-group-addon borderless required-mark"><i class="fa fa-asterisk"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="stateDDL" runat="server" class="col-sm-4 control-label" meta:resourcekey="stateLbl"></asp:Label>
                            <div class="col-sm-8">
                                <ej:DropDownList ID="stateDDL" runat="server" WatermarkText="" Width="100%">
                                </ej:DropDownList>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="roomDDL" runat="server" class="col-sm-4 control-label" meta:resourcekey="roomLbl"></asp:Label>
                            <div class="col-sm-8">
                                <ej:DropDownList ID="roomDDL" runat="server" DataTextField="RoomName" DataValueField="RoomId" DataHtmlAttributesField="HtmlAttr" WatermarkText="" Width="100%">
                                </ej:DropDownList>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="requestTxtBox" runat="server" class="col-sm-2 control-label" meta:resourcekey="requestLbl"></asp:Label>
                            <div class="col-sm-10">
                                <asp:TextBox runat="server" ID="requestTxtBox" class="form-control" TextMode="MultiLine" Rows="3" MaxLength="1000" Style="resize: none;"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="supervisorInstructionsBeforeTxtBox" runat="server" class="col-sm-2 control-label" meta:resourcekey="supervisorInstructionsBeforeLbl"></asp:Label>
                            <div class="col-sm-10">
                                <asp:TextBox runat="server" ID="supervisorInstructionsBeforeTxtBox" class="form-control" TextMode="MultiLine" Rows="3" MaxLength="1000" Style="resize: none;"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="intervetionModelDDL" runat="server" class="col-sm-4 control-label" meta:resourcekey="intervetionModelLbl"></asp:Label>
                            <div class="col-sm-8">
                                <ej:DropDownList ID="intervetionModelDDL" runat="server" WatermarkText="" Width="100%" FilterType="Contains" EnableFilterSearch="true">
                                </ej:DropDownList>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="intervetionTechniquesTxtbox" runat="server" class="col-sm-4 control-label" meta:resourcekey="intervetionTechniquesLbl"></asp:Label>
                            <div class="col-sm-8">
                                <asp:TextBox runat="server" ID="intervetionTechniquesTxtbox" class="form-control" TextMode="SingleLine" MaxLength="200"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="therapistCommentsTxtBox" runat="server" class="col-sm-2 control-label" meta:resourcekey="therapistCommentsLbl"></asp:Label>
                            <div class="col-sm-10">
                                <asp:TextBox runat="server" ID="therapistCommentsTxtBox" class="form-control" TextMode="MultiLine" Rows="3" MaxLength="1000" Style="resize: none;"></asp:TextBox>
                                <p>
                                    <asp:Label runat="server" class="control-label" meta:resourcekey="therapistCommentsInfoLbl"></asp:Label>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label runat="server" for="supervisionRequestChkBox" CssClass="col-sm-4 control-label" meta:resourcekey="supervisionRequestLbl"></asp:Label>
                            <div class="col-sm-3 switch">
                                <input runat="server" type="checkbox" id="supervisionRequestChkBox" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-6">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="supervisorCommentsAfterTxtBox" runat="server" class="col-sm-4 control-label" meta:resourcekey="supervisorCommentsAfterLbl"></asp:Label>
                            <div class="col-sm-8">
                                <asp:TextBox runat="server" ID="supervisorCommentsAfterTxtBox" class="form-control" TextMode="MultiLine" Rows="3" MaxLength="1000" Style="resize: none;"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <asp:Label for="notesTxtBox" runat="server" class="col-sm-2 control-label" meta:resourcekey="notesLbl"></asp:Label>
                            <div class="col-sm-10">
                                <asp:TextBox runat="server" ID="notesTxtBox" class="form-control" TextMode="MultiLine" Rows="3" MaxLength="1000" Style="resize: none;"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <div class="row">
                        <div class="col-xs-2">
                        </div>
                        <div class="col-sm-10">
                            <div class="box box-default">
                                <div class="box-header">
                                    <h3 class="box-title">Επανάληψη</h3>
                                </div>
                                <div class="box-body">
                                    <input type="checkbox" id="recurrenceChkBox" onchange="recurrenceCheckClicked()" runat="server" />
                                    <br />
                                    <br />
                                    <div id="recurrenceEditorWrapper" style="display: none;">
                                        <div class="callout callout-warning">
                                            <%--<h4>I am a warning callout!</h4>--%>
                                            <i class="icon fa fa-warning margin-r-5" style="float: left;"></i>
                                            <p>
                                                <asp:Label runat="server" class="control-label" meta:resourcekey="recurrentAppointmentWarningMessageLbl"></asp:Label></p>
                                        </div>
                                        <ej:RecurrenceEditor ID="recurrenceEditor" Locale="el-GR" runat="server" EnableViewState="true" Frequencies="daily,weekly,monthly,everyweekday" Change="onRecurrenceEditorChange">
                                        </ej:RecurrenceEditor>
                                    </div>
                                    <asp:HiddenField ID="recurrenceValueHiddenField" runat="server" />
                                    <asp:HiddenField ID="appointmentIdHiddenField" runat="server" />
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
