import { Injectable } from '@angular/core';
import { Subject, Observable } from 'rxjs';
import { DataStateChangeEventArgs } from '@syncfusion/ej2-angular-treegrid';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { DataSourceChangedEventArgs, IEditCell } from '@syncfusion/ej2-grids';
import { TaskModel } from './task-model';
import { map } from 'rxjs/operators';
const httpOptions = {
  headers: new HttpHeaders({ 'Content-Type': 'application/json' }),
};
@Injectable({
  providedIn: 'root',
})
export class TaskStoreService extends Subject<DataStateChangeEventArgs> {
  private apiUrl = 'api/tasks';
  constructor(private http: HttpClient) {
    super();
  }

  public execute(state: any): void {
    if (state.requestType === 'expand') {
      state.childDataBind();
    } else {
      this.getTasks(state).subscribe((x) =>
        super.next(x as DataStateChangeEventArgs)
      );
    }
  }

  getTasks(state?: any): Observable<any> {
    //  const skipquery = state.skip ? `$skip=${state.skip}` : null;

    //  let pageQuery = '';
    // const takeQuery = state.take ? `$top=${state.take}` : null;
    // if (skipquery) {
    //   pageQuery = `${skipquery}&`;
    //  }
    // if (takeQuery) {
    //  pageQuery = `${pageQuery}${takeQuery}`;
    //}
    return this.http.get<any>(`${this.apiUrl}`).pipe(
      map(
        (response: any) =>
          <any>{
            result: response,
            count: response.length,
          }
      )
    );
  }
}
