import { Injectable } from '@angular/core';
import { Http } from '@angular/http';
import 'rxjs/add/operator/map';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import {
  DataStateChangeEventArgs,
  Sorts,
  DataResult,
} from '@syncfusion/ej2-grids';
import { Observable } from 'rxjs/Observable';
import { Subject } from 'rxjs/Subject';
import { TaskModel } from './task-model';
import { map } from 'rxjs/operators/map';
import { Query, DataManager, ODataV4Adaptor } from '@syncfusion/ej2-data';
const httpOptions = {
  headers: new HttpHeaders({ 'Content-Type': 'application/json' }),
};
@Injectable({
  providedIn: 'root',
})
export class OrdersService extends Subject<DataStateChangeEventArgs> {
  private BASE_URL = 'api/tasks';
  constructor(private http: HttpClient) {
    super();
  }

  public execute(state: any): void {
    this.getData(state).subscribe((x) => super.next(x));
  }

  protected getData(state: any): Observable<any> {
    const pageQuery = `$skip=${state.skip}&$top=${state.take}`;
    let sortQuery: string = '';

    return this.http.get<{ [key: string]: object }[]>(this.BASE_URL).pipe(
      map((results: { [key: string]: object }[]) => {
        return results;
      })
    );
  }
}
