import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { AppComponent } from './app.component';
import {
  TreeGridModule,
  EditService,
  FilterService,
  PageService,
  VirtualScrollService,
  ToolbarService,
  ContextMenuService,
} from '@syncfusion/ej2-angular-treegrid';


import { InMemoryWebApiModule } from 'angular-in-memory-web-api';
import { TaskDataService } from '../task-data.service';
import { HttpClientModule } from '@angular/common/http';
import { OrdersService } from '../order.service';

@NgModule({
  declarations: [AppComponent],
  imports: [
    BrowserModule,
   
    TreeGridModule,
    InMemoryWebApiModule.forRoot(TaskDataService),
    HttpClientModule,
  ],
  providers: [
    EditService,
    ToolbarService,
    PageService,
    VirtualScrollService,
    ContextMenuService,
    FilterService,
    TaskDataService,
  ],
  bootstrap: [AppComponent],
})
export class AppModule {}
