import { Component, OnInit, ViewChild } from '@angular/core';
import {
  TreeGridComponent,
  EditSettingsModel,
  FilterService,
  PageService,
  DataStateChangeEventArgs,
  VirtualScrollService,
} from '@syncfusion/ej2-angular-treegrid';
import { enableRipple, isNullOrUndefined } from '@syncfusion/ej2-base';
import { Observable } from 'rxjs';
import { TaskStoreService} from '../task-store.service'
import { OrdersService } from '../order.service';
import { DataSourceChangedEventArgs, IEditCell } from '@syncfusion/ej2-grids';
import { DropDownList } from '@syncfusion/ej2-dropdowns';
import { childdata1, childdata2 } from '../childdata';
import { ToolbarItems } from '@syncfusion/ej2-angular-grids';
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css'],
  providers: [FilterService, PageService, VirtualScrollService],
})
export class AppComponent implements OnInit {
  @ViewChild('treegrid', null)
  public treegrid: TreeGridComponent;
  public tasks: Observable<DataStateChangeEventArgs>;

  public data: Observable<DataStateChangeEventArgs>;
  public pageSettings = { pageSize: 15, pageSizeMode: 'Root' };
  constructor(
    private TaskService: TaskStoreService,
    private service: OrdersService
  ) {
    this.tasks = TaskService;
    this.data = service;
	
  }

  public dataStateChange(state: DataStateChangeEventArgs): void {
    if (!isNullOrUndefined(state.action) && state.action.requestType == 'virtualscroll') {
      this.TaskService.getTasks(state).subscribe(
        function (data) {
          this.treegrid.dataSource = {
            result: data.result.slice(state.skip, state.skip + state.take),
            count: data.count,
          };
          console.log(this.treegrid.dataSource.result);
        }.bind(this)
      );
    }
    else if (state.requestType === 'expand') {
      /////    assigning the child data for the expanded record.
	  debugger
	  state.childData = [];
      for (let i = 0; i < 1000; i++) {
        state.childData.push(<any>{ id: i, TaskName: 'VINER', ParentID: 1, isParent: false,Duration: 40+i })
      }
		  
      state.childDataBind();
    } else {
      this.TaskService.execute(state);
    }
  }

  ngOnInit(): void {
    let state = {
      skip:
        (this.treegrid.pageSettings.currentPage - 1) *
        this.treegrid.pageSettings.pageSize,
      take:
        (this.treegrid.pageSettings.currentPage - 1) *
          this.treegrid.pageSettings.pageSize +
        this.treegrid.pageSettings.pageSize,
    };
    var data;
    this.TaskService.execute(state);
    var resultdata = [];
    this.TaskService.getTasks(state).subscribe(
      function (data) {
        this.treegrid.dataSource = {
          result: data.result.slice(state.skip, state.take),
          count: data.count,
        };
      }.bind(this)
    );
  }
}
