﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.ComponentModel;

namespace TestSfMaskedEditRegex
{
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            string mask = @"\d*";
            this.DataContext = new ViewModel
            {
                ValueText = "80",
                Mask = mask
            };

            this.MaskedBox.MaskType = Syncfusion.Windows.Controls.Input.MaskType.RegEx;
            this.MaskedBox.Mask = mask;
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            this.MaskedBox.MaskType = Syncfusion.Windows.Controls.Input.MaskType.Simple;
            this.MaskedBox.Mask = "0000";
            //Simple
        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            this.MaskedBox.MaskType = Syncfusion.Windows.Controls.Input.MaskType.RegEx;
            this.MaskedBox.Mask = @"\d+";
        }
    }

    public class ViewModel : INotifyPropertyChanged
    {
        private string valueText { get; set; }
        private string textText { get; set; }
        private string mask { get; set; }

        public string ValueText { get { return valueText; } set { valueText = value; OnPropertyChanged("ValueText"); } }
        public string TextText { get { return textText; } set { textText = value; OnPropertyChanged("TextText"); } }
        public string Mask { get { return mask; } set { mask = value; OnPropertyChanged("Mask"); } }



        public event PropertyChangedEventHandler PropertyChanged;

        //make it protected, so it is accessible from Child classes
        protected void OnPropertyChanged(String info)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(info));
        }
    }
}
