﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Web;

namespace SyncfusionBug.Models
{
    public static class Repository
    {
        

        static List<SiteRoleManageItem> Items;

        public static List<SiteRoleManageItem> items = new List<SiteRoleManageItem>();
        static SiteRoleManageItem container;
        public static void Startup()
        {
            //item = JsonConvert.DeserializeObject<Root>(File.ReadAllText(path));
            container = JsonConvert.DeserializeObject<SiteRoleManageItem>(JsonString);
        }

        //public static List<SiteRoleManageItem> SiteRoleManageModel(Guid siteId)
        //{
        //    if (siteId == Guid.Empty)
        //        return container.Items;

        //    SiteRoleManageItem model = null;

        //    model = SearchItem(container, siteId);

        //    if (model != null)
        //        return model.Items;
        //    else
        //        return new List<SiteRoleManageItem>();
        //}
        public static List<SiteRoleManageItem> SiteRoleManageModel(Guid siteId)
        {

            if (siteId == Guid.Empty)
                return container.Items;

            List<SiteRoleManageItem> results = new List<SiteRoleManageItem>();

            var siteRoles = ReturnChildren(container);
            var siteRole = siteRoles.FirstOrDefault(x => x.SiteId == siteId);
            return siteRole.Items;
        }
        static List<SiteRoleManageItem> ReturnChildren(SiteRoleManageItem item)
        {
            List<SiteRoleManageItem> results = new List<SiteRoleManageItem>();
            results.AddRange(item.Items);
            foreach (var fe in item.Items)
            {
                results.AddRange(ReturnChildren(fe));
            }
            return results;

        }
        static SiteRoleManageItem SearchItem(SiteRoleManageItem item, Guid siteId)
        {
            SiteRoleManageItem result = null;
            if (item.SiteId == siteId)
                return item;
            foreach (var item2 in item.Items)
            {
                result = SearchItem(item2, siteId);
            }

            return result;
        }

        public static void UpdateSiteRole(SiteRoleManageItem item)
        {
            var siteRoles = ReturnChildren(container);
            var siteRole = siteRoles.FirstOrDefault(x=>x.SiteId == item.SiteId);
            siteRole.Write = item.Write;
            siteRole.Read = siteRole.Write ? true : item.Read;
        }

        static string JsonString = "{\"SiteId\":\"00000000-0000-0000-0000-000000000000\",\"RoleId\":\"00000000-0000-0000-0000-000000000000\",\"ParentId\":\"00000000-0000-0000-0000-000000000000\",\"SiteName\":\"Container\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":0,\"HasChildren\":false,\"Items\":[{\"SiteId\":\"cd6d743b-e292-40de-a3ad-04558ee92e1f\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"00000000-0000-0000-0000-000000000000\",\"SiteName\":\"Kunden\",\"Read\":true,\"Write\":true,\"EnableReadWrite\":false,\"OrderNumber\":119,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"7bc07a5c-d4fe-4e53-95b5-0ae832ea124c\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"cd6d743b-e292-40de-a3ad-04558ee92e1f\",\"SiteName\":\"TourenplanVersandstatus\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":121,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"dd074200-ce24-4722-955f-c7c7e386fbd8\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"7bc07a5c-d4fe-4e53-95b5-0ae832ea124c\",\"SiteName\":\"TourenplanVersandstatus\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":9,\"HasChildren\":false,\"Items\":[]}]},{\"SiteId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"cd6d743b-e292-40de-a3ad-04558ee92e1f\",\"SiteName\":\"EinstellungenüberalleFirmen\",\"Read\":true,\"Write\":true,\"EnableReadWrite\":false,\"OrderNumber\":120,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"122a274a-ff06-4cab-8f91-4f2e6d997514\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"SiteName\":\"ErforderlicheInventareigenschaftendefinieren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":5,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"bf310d2e-27ca-4c3d-8a24-574799644881\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"SiteName\":\"ErforderlicheInventargegenständedefinieren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":4,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"82ef67b1-831c-4581-9390-783745c02d60\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"SiteName\":\"VersanddesgeändertenTourenplans:Massenänderung\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":7,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"ead91f49-c9cb-4163-902c-880adfe29a4c\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"SiteName\":\"Tourenplanversand:Massenänderung\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":6,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"d7a84094-babb-496f-a986-aba8809d539a\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"SiteName\":\"Protokoll-E-Mailversandanpassen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":1,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"0427dbc3-e62b-4894-b3a6-d198c5498bc0\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"SiteName\":\"Massentickets\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":2,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"753143b4-86bf-482f-8d25-f8d26b293fbe\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"SiteName\":\"Servicepaketebearbeiten:alleFirmen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":3,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"58533cbc-2920-4661-87d4-f96ac1fde2fe\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"25705bdc-f206-4bda-80f3-3bf6fc7f51c7\",\"SiteName\":\"Protokollsichtbarkeitbearbeiten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":8,\"HasChildren\":false,\"Items\":[]}]},{\"SiteId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"cd6d743b-e292-40de-a3ad-04558ee92e1f\",\"SiteName\":\"Filialportal\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":124,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"2d22829a-3a45-42fa-839d-025b1f998e3e\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Stammdaten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":35,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"a52ee6ff-5d2f-4fa7-8eb0-1041504ccc68\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"ErforderlicheInventareigenschaftendefinieren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":46,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"651d9597-3805-4ba0-8044-1ef95c2d692b\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Fotos\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":38,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"b724031b-6498-4913-afa6-435afbdadc3a\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Ansprechpartner\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":37,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"5eae6d87-c688-4dbb-b2f7-7a78e67c0de2\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Anlagenbücher\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":42,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"2ef23c49-e595-4304-afd8-84f4231e50a8\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Filialinformation\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":44,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"ae8765d3-3c03-432b-9964-86fa10d8d9db\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Tickets\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":40,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"ea43bf43-9fc1-4e7a-9d7c-880ad2a44666\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Öffnungs-undZugangszeiten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":36,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"f4f7d236-241c-4297-aa77-b066c767df0f\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Protokolle\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":41,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"b2ed127c-7ba4-49b2-b8a8-de10a16c1776\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"ErforderlicheInventargegenständedefinieren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":45,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"67748382-eace-4ff9-9ae9-e41992eb993a\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Inventar\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":39,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"f02579d5-bcbd-46ab-932c-e9082fc7ef36\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Sprachqualifikationen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":47,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"040ed8e3-a1aa-4fcb-bd0a-ea63ce7fdc65\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Besuche\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":34,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"cb8193a6-372e-4851-8c10-fb3b6b53863b\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"76f124e3-e999-427c-be38-d17b120698ac\",\"SiteName\":\"Materialverbrauch\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":43,\"HasChildren\":false,\"Items\":[]}]},{\"SiteId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"cd6d743b-e292-40de-a3ad-04558ee92e1f\",\"SiteName\":\"Firmenportal\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":122,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"604f7d51-e878-4729-8c7c-11bf7a5b4f9b\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"Massentickets\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":12,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"4ad74ed9-1fc6-4db5-b5a5-1beac44081e8\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"Protokoll-E-Mailversandanpassen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":10,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"4170ebbe-94a1-4133-be76-2d95c8ac935e\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"VoreinstellungTourenplanversand-Änderungen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":18,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"75b0ab96-2318-48a0-9bd4-38f5c271c114\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"Tourenplanversand:Massenänderung\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":15,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"463eb914-dd90-458a-ab6b-39878b3c7353\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"ErforderlicheInventareigenschaftendefinieren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":14,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"67377bec-43ba-49c0-9eac-66e4330ba2e2\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"VoreinstellungTourenplanversand\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":17,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"13fbcce1-589d-43b1-8a3d-7372fc027f30\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"ErforderlicheInventargegenständedefinieren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":13,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"84585e99-9667-49ba-b905-83c0e5187364\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"Reparaturbedarfbericht\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":11,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"d8cdbc2e-7012-4fd6-a56f-d91e66b217c9\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"VersanddesgeändertenTourenplans:Massenänderung\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":16,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"fb551dda-6912-4aa5-b518-e1a15d368d3f\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5240df30-9bf8-43ff-b7f6-df58eb0eba05\",\"SiteName\":\"Protokollsichtbarkeitbearbeiten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":19,\"HasChildren\":false,\"Items\":[]}]},{\"SiteId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"cd6d743b-e292-40de-a3ad-04558ee92e1f\",\"SiteName\":\"Kundenportal\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":123,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"096fdb56-292a-4e8a-9e47-14637d9eae5c\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Protokollsichtbarkeitbearbeiten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":31,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"3008eb72-2686-4b0f-a859-16a9427d5caa\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Inventarbericht-Klimaanlage\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":24,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"09d558c7-47e2-4320-820b-368ab095bc76\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Tourenpläne\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":32,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"2af3ff85-82f4-47d7-abf6-64465a398e6d\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Protokoll-E-Mailversandanpassen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":21,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"0e01145c-f4f6-4e1d-a820-6c1901880e3a\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Massentickets\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":28,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"c46d62aa-ad27-459c-b6ec-6de648a07f6a\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"ErforderlicheInventareigenschaftendefinieren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":30,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"af9d8240-d8bb-4426-a75d-9b5a56727be3\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Servicepaketebearbeiten:alleFirmen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":20,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"5724fab0-e9ab-46cd-9bf1-a3531aeace7d\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Sprachqualifikationen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":33,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"ba1e1446-388e-452a-b605-aa02183326a5\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"ErforderlicheInventargegenständedefinieren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":29,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"b856e28b-32a6-4519-91d6-b49abb8ec904\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Inventarbericht-allgemein\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":23,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"23c9f8aa-2239-4041-b327-c335f97655e9\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Stammdaten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":22,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"d5117fe5-d306-4c56-a860-c4a3f9cbf0ab\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Filialinformation\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":26,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"15c7db4c-286a-4d89-88b7-ca055aa3cc8d\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Materialverbrauch\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":27,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"1eba0350-6179-49eb-a2db-f9d12f6c1878\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"212d6571-c3f7-4767-ac66-eab01084ff2a\",\"SiteName\":\"Reparaturbedarfbericht\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":25,\"HasChildren\":false,\"Items\":[]}]}]},{\"SiteId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"00000000-0000-0000-0000-000000000000\",\"SiteName\":\"System\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":127,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"634ce6df-869b-4977-b742-075559a76630\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Whitelist\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":79,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"60d91fdb-7112-4879-a9ef-279932053eab\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Dashboard\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":73,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"5976b029-590d-4788-97bb-2bb72bb9cb62\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Anlagenbucheinträge\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":68,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"40935524-3f77-432d-8624-3c65b7945b5f\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Qualifikation-Funktionsvorlagen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":78,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"3512eb16-58a6-45e9-8a0f-5c0232bde02c\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Materialverwaltung\",\"Read\":true,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":75,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"59d9348a-30b5-4343-a240-6aecc831906b\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"LeeresProtokollerzeugen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":67,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"9aba356c-b018-4915-a9c3-6d52cf8d4f83\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"ManuelleBesuche\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":69,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"6decc5d2-ef49-48a4-9127-7b002db6f442\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Tourenplan-Kanban\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":72,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"5c70e080-8d39-4cf2-82f7-7ba50d9930f0\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Tourenpläne\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":74,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"ce003926-3795-4bf5-84e5-8c8f038fee0a\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Tourenplan-Gantt\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":70,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"916664f1-c765-4902-8ede-9527133a152b\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Benutzerverwaltung\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":76,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"74ad00a9-cb78-48b3-8af2-969bec5d56f7\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Materialverbrauch\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":64,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"2af801bf-7f49-4ccb-ac92-9d40c62b0514\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Benachrichtigungen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":62,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"08a79bf5-4df3-47a7-9011-a5b22e3c0988\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Tickets\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":61,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"b023f9da-341b-460e-8716-b4a7d470402d\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Tourenplan-Kanban\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":71,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"499bc9db-3a59-45b2-b6eb-c760b7b6cc51\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Messgeräte\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":65,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"cf786182-f14e-407d-9203-d05291de8fd2\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"PartnerPortal\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":66,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"5c45103c-ec51-4615-9bf3-d98a62636bfa\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Rollenverwaltung\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":77,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"008a491c-ae29-42a4-a1c3-e1d452cab168\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"eccd5401-ebfe-4bf5-8679-1c29e63a21e0\",\"SiteName\":\"Systemjobs\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":63,\"HasChildren\":false,\"Items\":[]}]},{\"SiteId\":\"1f5117ff-310e-4940-82ad-2c2c3a97d076\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"00000000-0000-0000-0000-000000000000\",\"SiteName\":\"Tourplan-Systemeinstellungen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":131,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"a8f4a818-b74d-4afb-b9a9-9d22bd655978\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"1f5117ff-310e-4940-82ad-2c2c3a97d076\",\"SiteName\":\"Voreinstellungen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":118,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"0b093bee-9cd1-46dd-9797-fd452cc51cc0\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"1f5117ff-310e-4940-82ad-2c2c3a97d076\",\"SiteName\":\"Verspätungszeit\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":117,\"HasChildren\":false,\"Items\":[]}]},{\"SiteId\":\"6bcc4d62-acdf-4563-925e-37e21560804e\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"00000000-0000-0000-0000-000000000000\",\"SiteName\":\"Light-Protokolle\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":130,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"8c49fec3-bd42-4cb4-8001-cb7928629881\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"6bcc4d62-acdf-4563-925e-37e21560804e\",\"SiteName\":\"Partnerberichte\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":116,\"HasChildren\":false,\"Items\":[]}]},{\"SiteId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"00000000-0000-0000-0000-000000000000\",\"SiteName\":\"Berichte\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":129,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"4182c7d9-86c6-4210-8101-0723142ed7d2\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Verkausflächenbericht\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":111,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"2ec08b3a-3217-497d-b9e7-13b4dece9616\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"MitarbeiterMonatsbericht\",\"Read\":true,\"Write\":true,\"EnableReadWrite\":true,\"OrderNumber\":105,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"8d80895b-7654-4c04-95ff-1b35e404a6cf\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Materiallieferung\",\"Read\":true,\"Write\":true,\"EnableReadWrite\":true,\"OrderNumber\":112,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"67fe5bde-dfcc-4c1f-b11e-38aa2aba3714\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"OffeneBesuche\",\"Read\":true,\"Write\":true,\"EnableReadWrite\":true,\"OrderNumber\":103,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"462ea6e4-2f8f-488a-af4c-409e053c1fe3\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Tagesarbeitszeiten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":104,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"62523a88-7e1a-489a-afd3-4f0e7ecdadba\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Tickets\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":102,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"da532e5c-1865-44ea-bdf6-511b58d7b015\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"FahrtzeitenundFahrtstrecken\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":114,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"9430096f-8a43-4fdf-b5da-822bb47a95b0\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"ArbeitszeitundAnfahrtszeit\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":100,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"41518a13-9396-480b-9156-84438bc15c7c\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Besuche\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":99,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"4d3edc0c-30bb-4d61-b67e-9457b326a102\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Inventarbericht\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":113,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"6026bc7b-9359-482f-b79f-94e46ae8a89c\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Malerarbeiten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":115,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"3a34eaad-06d9-4131-be09-af8920bd8883\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"JahresreportF-GasAnlagen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":108,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"7895223f-7c00-4902-85d1-b99c9fa8ab5d\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Materialverbrauch\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":101,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"d00a3ccf-5ffb-4f7e-96aa-bfb4cf0c840d\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Standortbericht\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":106,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"e21c62e5-6de6-4750-8529-d8094fdca84d\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Inventarbericht-Klimaanlage\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":107,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"793a1c2b-e939-4479-9528-eb902c9740e0\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Datensynchronisation\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":110,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"1a785d82-737a-4a60-9a68-f01e0eb6a981\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"9015cd8b-e576-48ea-b736-b1b3d8dcae41\",\"SiteName\":\"Inventuren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":109,\"HasChildren\":false,\"Items\":[]}]},{\"SiteId\":\"ddb40a34-08d0-4d36-b59b-b7211f9cdca2\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"00000000-0000-0000-0000-000000000000\",\"SiteName\":\"Mitarbeiter\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":125,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"1fb94093-cf9f-4808-ae51-1d1b7f867ba1\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"ddb40a34-08d0-4d36-b59b-b7211f9cdca2\",\"SiteName\":\"ÜbersichtZeiteinträgemitÜberlänge\",\"Read\":true,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":60,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"ddb40a34-08d0-4d36-b59b-b7211f9cdca2\",\"SiteName\":\"Mitarbeiterportal\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":126,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"caf9aa89-28e6-4ea5-8845-02adbb3ac26f\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Besuche\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":51,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"74a64a18-e5e7-4bd7-bab1-035065adb27b\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Bestandsverwaltung\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":57,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"6620acae-e9d2-4ed9-a557-12a6bc258469\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Lager/Inventuren\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":50,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"71b3fb4f-7a9c-49a6-835c-2533b663bd68\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Bestellungen\",\"Read\":true,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":55,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"9c56b034-325f-4e68-a3c7-26e1d5c77656\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Datenaustausch\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":56,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"1ce42fab-8599-487d-b3d6-3ec512a23ee1\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Sprachqualifikationen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":59,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"6bac016f-2b7f-4707-820e-50964bcceff1\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Qualifikationen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":58,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"b05ba4b6-7937-471a-aa00-6e32d465c1ad\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Blocker\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":49,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"e8f4925a-26bb-48c7-af7b-7ee7ef5dd9ec\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Zeiteinträge\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":48,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"536f17ba-7f62-4bc1-b45c-b159b06e8cfa\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Lieferadressen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":53,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"7c404697-7b31-4a64-bc2d-c8cbe20b2fff\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Materialverbrauch\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":54,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"ef840b56-5133-4be3-85db-d6e0382f4662\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"5b1c63a3-5dfa-457b-b226-f3b725484cc1\",\"SiteName\":\"Termine\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":52,\"HasChildren\":false,\"Items\":[]}]}]},{\"SiteId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"00000000-0000-0000-0000-000000000000\",\"SiteName\":\"Systemeinstellungen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":false,\"OrderNumber\":128,\"HasChildren\":true,\"Items\":[{\"SiteId\":\"d3713e6c-2ea5-420a-9774-0b82214a8cdf\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Blockerarten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":97,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"34da72ce-b963-4b51-9dab-1eb9365c89f0\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Inventartemplates\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":82,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"3aa0fef7-9b20-4f17-bc3f-24a79182fc6b\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"LänderspezifischeEinstellungen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":88,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"f7465239-9301-4340-9615-3f32bf6765ae\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"ÜbersetzungenPartnerPortal\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":92,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"3e476735-1b6d-42cf-8862-4b89d5965389\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Navision-Pflichtprotokollstandard\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":87,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"c2a1f97c-bf95-43a7-a4d2-6b119890de41\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Inventarkategorien\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":80,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"9319171a-4ba3-45e8-ad10-78a719cb4225\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Protokollvorlagen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":84,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"bc64a052-8370-4d67-acb0-7f0fdf89e81a\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Prioritätsgründe\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":94,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"886d8d66-5b22-4efa-b0c6-8a0457d80e1c\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Hilfeseiten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":98,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"a3ea36be-e6d2-4fff-9b52-8d7b05d7c4fb\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Inventarlöschungbestätigen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":90,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"e4084261-6dc8-405f-ba9c-b0669bb92ce3\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Abbruchbegründungen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":93,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"da82d5be-df96-4c8c-87b3-b5e34d19d876\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Qualifikationen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":95,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"272a3046-cf65-4cae-80d6-bcd8111fb074\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Protokollpositionen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":83,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"0dae7b16-f1cf-4230-a268-c5350d08b85e\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Ländersprachenverwalten\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":96,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"8f858a1a-6bd4-43f5-942e-c694b5880db9\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Ticketpflichtprotokolle\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":86,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"44dab7e3-8312-4e26-85f5-cd77e7ca7b1e\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Callcenters\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":89,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"3e29de97-e2d6-457e-8ccc-cfab1e1b1a25\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"AltesInventarlöschen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":91,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"47ca1c71-1a4c-4a3e-b04f-fa6ad4ee900b\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Inventareigenschaften\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":81,\"HasChildren\":false,\"Items\":[]},{\"SiteId\":\"c56e333d-d0ea-449b-b32f-ff7191608a4c\",\"RoleId\":\"2b3a830d-bfed-48f3-a083-af33006e40e2\",\"ParentId\":\"8886110e-bf36-4e0d-be87-e27d2eb3c47f\",\"SiteName\":\"Protokollgruppen\",\"Read\":false,\"Write\":false,\"EnableReadWrite\":true,\"OrderNumber\":85,\"HasChildren\":false,\"Items\":[]}]}]}";
    }

    public class SiteRoleManageItem
    {
        public Guid SiteId { get; set; }
        public Guid RoleId { get; set; }
        public Guid ParentId { get; set; }
        public string SiteName { get; set; }
        public bool Read { get; set; }
        public bool Write { get; set; }
        public bool EnableReadWrite { get; set; }
        public int OrderNumber { get; set; }
        public bool HasChildren { get; set; }
        public List<SiteRoleManageItem> Items { get; set; }       
    }
    public class Root
    {
        public string SiteId { get; set; }
        public string RoleId { get; set; }
        public string ParentId { get; set; }
        public string SiteName { get; set; }
        public bool Read { get; set; }
        public bool Write { get; set; }
        public bool EnableReadWrite { get; set; }
        public int OrderNumber { get; set; }
        public bool HasChildren { get; set; }
        public List<SiteRoleManageItem> Items { get; set; }
    }
}