﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Security.Policy;
using System.Web;
using System.Web.Http;
using System.Web.Mvc;
using Syncfusion.EJ2.Base;
using SyncfusionBug.Models;

namespace SyncfusionBug.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }

        public ActionResult Contact()
        {
            ViewBag.Message = "Your contact page.";

            return View();
        }

        public ActionResult GetData(DataManagerRequest dm) /*DataManagerRequest dm*/
        {

            string siteIdString = null;
            if (dm.Where.FirstOrDefault(x => x.Field == "ParentId") != null)
                siteIdString = (string)dm.Where.FirstOrDefault(x => x.Field == "ParentId").value;

            Guid siteId = Guid.Empty;
            if (siteIdString != null)
                Guid.TryParse(siteIdString, out siteId);

            List<SiteRoleManageItem> list = Repository.SiteRoleManageModel(siteId);

            DataResult result = new DataResult();
            result.result = list;
            result.count = list.Count;

            //return Json(new { result = dataSource.Items.OrderByDescending(x=>x.SiteName), count = dataSource.Items.Count}); ;
            return Json(result, JsonRequestBehavior.AllowGet);
        }

        public class DataResult
        {
            public IEnumerable result { get; set; }
            public int count { get; set; }
        }

        public ActionResult Update([FromBody] SiteRoleManageItem value)
        {
            Repository.UpdateSiteRole(value);
            return Json(value);
        }

        public ActionResult CrudUpdate([FromBody] Syncfusion.EJ2.Base.CRUDModel<SiteRoleManageItem> value, string action)
        {
            foreach (var item in value.Changed)
            {
                Repository.UpdateSiteRole(item);
            }
            return Json(value.Changed);
        }
    }
}