using Amazon.Lambda.Core;

// Assembly attribute to enable the Lambda function's JSON input to be converted into a .NET class.
[assembly: LambdaSerializer(typeof(Amazon.Lambda.Serialization.SystemTextJson.DefaultLambdaJsonSerializer))]

namespace HtmlToPDFAWSLambdaBlink;
using Syncfusion.Pdf;
using System.IO;
using Syncfusion.HtmlConverter;

public class Function
{
    
    /// <summary>
    /// A simple function that takes a string and does a ToUpper
    /// </summary>
    /// <param name="input"></param>
    /// <param name="context"></param>
    /// <returns></returns>
    public string FunctionHandler(string input, ILambdaContext context)
    {
        Syncfusion.Licensing.SyncfusionLicenseProvider.RegisterLicense("REMOVED DUE TO TICKET");
        //Initialize HTML to PDF converter with Blink rendering engine.
        HtmlToPdfConverter htmlConverter = new HtmlToPdfConverter(HtmlRenderingEngine.Blink);
        htmlConverter.ConverterSettings.EnableHyperLink = true;
        htmlConverter.ConverterSettings.EnableJavaScript = true;
        htmlConverter.ConverterSettings.PdfPageSize = PdfPageSize.A4;
        htmlConverter.ConverterSettings.AdditionalDelay = 20000;
        htmlConverter.ConverterSettings.Margin.All = 0;

        BlinkConverterSettings blinkConverterSettings = new BlinkConverterSettings();
        //Assign Blink converter settings to HTML converter.
        htmlConverter.ConverterSettings = blinkConverterSettings;

        input = input.Replace("PATHTOREPLACETOFILE", PathToFile());

        //Convert URL to PDF.
        PdfDocument document = htmlConverter.Convert(input, "");

        //Save the document into stream.
        MemoryStream memoryStream = new MemoryStream();

        //Save and Close the PDFDocument.
        document.Save(memoryStream);
        document.Close(true);
        document.Dispose();

        LambdaLogger.Log(memoryStream.Length.ToString());

        LambdaLogger.Log(Convert.ToBase64String(memoryStream.ToArray()));

        string base64 = Convert.ToBase64String(memoryStream.ToArray());

        memoryStream.Close();
        memoryStream.Dispose();

        return base64;
    }

    public static string PathToFile()
    {
        string? path = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase);
        if (string.IsNullOrEmpty(path))
        {
            path = Environment.OSVersion.Platform == PlatformID.Unix ? @"/" : @"\";
        }
        LambdaLogger.Log(path);
        return Environment.OSVersion.Platform == PlatformID.Unix ? string.Concat(path.Substring(5), @"/") : string.Concat(path.Substring(6), @"\");
    }
}
