import "./index.css";
import * as React from "react";
import {
  GridComponent,
  ColumnsDirective,
  ColumnDirective,
  Page,
  Group,
  Sort,
  Inject,
} from "@syncfusion/ej2-react-grids";
import { inventoryData } from "./data";
import { updateSampleSection } from "./sample-base";
let refresh;
function Grouping() {
  React.useEffect(() => {
    updateSampleSection();
  }, []);
  const template = (props) => {
    return (
      <span className="groupItems">
        {props.field} - {props.count} Items
      </span>
    );
  };
  const groupOptions = {
    showGroupedColumn: false,
    columns: ["Country"],
    captionTemplate: { template },
  };
  let gridInstance;
  function dataBound() {
    if (refresh) {
      gridInstance.groupColumn("Country");
      refresh = false;
    }
  }
  function load() {
    refresh = this.refreshing;
  }
  const [data, setData] = React.useState([]);
  function loadData() {
    setData(inventoryData);
  }
  return (
    <div className="control-pane">
      <button onClick={loadData}>Load Data</button>
      <div className="control-section">
        <GridComponent
          dataSource={data}
          allowPaging={true}
          ref={(grid) => (gridInstance = grid)}
          pageSettings={{ pageCount: 5 }}
          allowGrouping={true}
          groupSettings={groupOptions}
          allowSorting={true}
          height="320"
          dataBound={dataBound.bind(this)}
          load={load}
        >
          <ColumnsDirective>
            <ColumnDirective
              field="Inventor"
              headerText="Inventor Name"
              width="180"
            ></ColumnDirective>
            <ColumnDirective
              field="NumberofPatentFamilies"
              headerText="Number of Patent Families"
              width="220"
              textAlign="Right"
            ></ColumnDirective>
            <ColumnDirective field="Country" headerText="Country" width="140" />
            <ColumnDirective field="Active" headerText="Active" width="120" />
            <ColumnDirective
              field="Mainfieldsofinvention"
              headerText="Main fields of invention"
              width="200"
            ></ColumnDirective>
          </ColumnsDirective>
          <Inject services={[Page, Group, Sort]} />
        </GridComponent>
        <div className="e-dsalign">
          Source:
          <a
            href="https://en.wikipedia.org/wiki/List_of_prolific_inventors"
            target="_blank"
          >
            Wikipedia: List of Prolific inventors
          </a>
        </div>
      </div>
    </div>
  );
}
export default Grouping;
