﻿using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;
using Portal.Utilities;
using Syncfusion.Blazor;
using Syncfusion.Blazor.Grids;
using Syncfusion.Blazor.Navigations;
using Syncfusion.Blazor.Popups;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Portal.Pages.Artikel
{
    public partial class ArtikelSuchliste : ComponentBase
    {
        //--------------------------------------------------------------------------------------------------
        #region Definition
        [Inject]
        IJSRuntime js { get; set; }
        [Inject]
        NavigationManager NM { get; set; }

        [Inject]
        Person person { get; set; }
        [Inject]
        Bearbeitungsartikel work { get; set; }
        [CascadingParameter(Name = "GefundeneArtikel")]
        private List<ArtikelFahrzeug> Suchliste { get; set; }
        [CascadingParameter(Name = "Artikelliste")]
        private string anzeigen { get; set; }
        private string suchstring { get; set; } = "VW";
        private string Gridliste = "Suche";
        public string[] InitialGrp { get; set; }
        private List<object> Toolbar = new List<object> {"Filter löschen", "PdfExport","ExcelExport","Search"};
        private List<Gridfilter> Filterliste { get; set; }     
        private SfGrid<ArtikelFahrzeug> Suchgrid;
        private Grid G { get; set; }
        public List<PdfHeaderFooterContent> HeaderContent = new List<PdfHeaderFooterContent>
        {
            new PdfHeaderFooterContent() 
            { 
                Type = ContentType.Text,
                Value = "Suchliste", 
                Position = new PdfPosition() { X = 0, Y = 2 }, 
                Style = new PdfContentStyle() 
                {
                    TextBrushColor = "#000000",
                    FontSize = 18 
                }
            }
        };
        public List<PdfHeaderFooterContent> FooterContent = new List<PdfHeaderFooterContent>
        {
            new PdfHeaderFooterContent()
            {
                Type = ContentType.PageNumber,
                PageNumberType = PdfPageNumberType.Arabic,
                Position = new PdfPosition() { X = 490, Y = 0 },
                Style = new PdfContentStyle()
                {
                    TextBrushColor = "#c0c0c0",
                    FontSize = 12,
                    HAlign = PdfHorizontalAlign.Center
                }
            }
        };

        #endregion
        //--------------------------------------------------------------------------------------------------
        #region Events     

        protected override void OnParametersSet()
        {
            if (anzeigen == null) anzeigen = "hidden";
        }
        protected override void OnInitialized()
        {
            work.Workartikel = null;
            G = new Grid(person, Gridliste);
            Filterliste = G.GetFilterliste(Gridliste, person.Anmeldung);
            var grpliste = G.GetOldGrouping(Gridliste,person.Anmeldung);
            if (grpliste.Count > 0)
            {
                var l=new List<string>();
                foreach(var gr in grpliste)
                {
                    l.Add(gr.Feld);
                }
                InitialGrp = l.ToArray();
            }
        }
        public async void ResizeHandler(ResizeArgs args)
        {
            await G.Resized(Suchgrid.Columns,Gridliste);
        }
        //public  void Search(ActionEventArgs<ArtikelFahrzeug> args)
        //{
        //    if (args.RequestType == Syncfusion.Blazor.Grids.Action.Searching)
        //    {
        //        var filtertext = args.SearchString.ToLower();
        //        if(!string.IsNullOrEmpty(filtertext))
        //        {
        //            Suchliste.Select(x => x as object).ToList();
        //            var tmp = new List<object>();
        //            tmp = Suchliste.Select(x => x as object).ToList();
        //            tmp = Tools.Finde(tmp, filtertext);
        //            var filterlist = new List<ArtikelFahrzeug>();
        //            foreach (var item in tmp)
        //            {
        //                var rec = (ArtikelFahrzeug)item;
        //                filterlist.Add(rec);
        //            }

        //            Suchgrid.DataSource = filterlist;
        //        }
        //        //Suchgrid.SearchAsync(filtertext).Wait();
        //    }
        //}
        public async void ActionCompleted(ActionEventArgs<ArtikelFahrzeug> args)
        {
            if (args.RequestType == Syncfusion.Blazor.Grids.Action.Reorder)
            {
                await G.Reordered(Suchgrid.Columns, Gridliste,args.FromColumns);
            }
            if (args.RequestType == Syncfusion.Blazor.Grids.Action.Filtering)
            {
                if (Suchgrid.FilterSettings.Columns.Count > 0) 
                    await G.Filter(Suchgrid.FilterSettings.Columns, Gridliste);
                else await G.DeleteFilter(Gridliste,args.CurrentFilterObject.Field); 

            }
            if (args.RequestType == Syncfusion.Blazor.Grids.Action.Grouping)
            {
                await G.Grouped(Suchgrid.GroupSettings.Columns, Gridliste);
            }
            if (args.RequestType == Syncfusion.Blazor.Grids.Action.UnGrouping)
            {
                await G.Ungroup(args.ColumnName, Gridliste);
            }
            //if (args.RequestType == Syncfusion.Blazor.Grids.Action.Searching)
            //{
            //    await G.Test();
            //}
        }

        public void CellSelected(CellSelectingEventArgs<ArtikelFahrzeug> args)
        {
            var artikelid = args.Data.ArtikelId;
            work.Workartikel = args.Data;
            var index = args.CellIndex;
            if (index == 0) IndenWarenkorb(artikelid);
            else if(index >= 1) ArtikelAnzeigen(artikelid); // Spalte Index =1 Bild
        }

        public async void ToolbarClick(Syncfusion.Blazor.Navigations.ClickEventArgs args)
        {
            switch (args.Item.Text)
            {
                case "Filter löschen":
                    await G.DeleteFilter(Gridliste, "");
                    break;
                case "PDF-Export":
                    await ExportPDF(Gridliste);
                    break;
                case "Excel-Export":
                    await ExportExcel(Gridliste);
                    break;
                case "Suche":
                    await Suchgrid.SearchAsync(suchstring);
                    break;
            }
        }
        private void IndenWarenkorb(Guid? artikelid)
        {
            
        }

        private async void ArtikelAnzeigen(Guid? artikelid)
        {
            var seite = "/pages/artikel/artikelindex/" + artikelid;
            if (person.Rollen.Contains("User"))
            {
                try
                {
                    await js.InvokeAsync<object>("open", seite, "_blank");
                }
                catch (Exception)
                {
             
                }
            }
        }
        #endregion
        //--------------------------------------------------------------------------------------------------
        #region GridFunktionen
        public async Task ExportPDF(string liste)
        {
            var heute = DateTime.Now.ToShortDateString();
            var docname = liste + "_" + heute.Substring(6,4) + heute.Substring(3,2) + heute.Substring(0,2) + ".PDF";

            PdfExportProperties pdfproperties =new PdfExportProperties();
            pdfproperties.FileName = docname;
            pdfproperties.IsRepeatHeader = true;
            pdfproperties.PageOrientation = PageOrientation.Landscape;

            PdfHeader Header = new PdfHeader()
            {
                FromTop = 0,
                Height = 50,
                Contents = HeaderContent
            };
            pdfproperties.Header = Header;
            PdfFooter Footer = new PdfFooter()
            {
                Height = 30,
                FromBottom = 0,
                Contents = FooterContent
            };
            pdfproperties.Footer = Footer;  
            await this.Suchgrid.ExportToPdfAsync(pdfproperties);
        }
        public async Task ExportExcel(string liste)
        {
            var heute = DateTime.Now.ToShortDateString();
            var docname = liste + "_" + heute.Substring(6, 4) + heute.Substring(3, 2) + heute.Substring(0, 2) + ".XLS";
            
            ExcelExportProperties xlsproperties = new ExcelExportProperties();
            xlsproperties.FileName = docname;
            await this.Suchgrid.ExportToExcelAsync(xlsproperties);

        }
        #endregion
        //--------------------------------------------------------------------------------------------------

    }
}
