﻿using Syncfusion.XlsIO;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NumberFormat
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void btnGen_Click(object sender, EventArgs e)
        {
            ExcelEngine excelEngine = new ExcelEngine();
            IApplication application = excelEngine.Excel;
            IWorkbook workbook = application.Workbooks.Create(1);
            IWorksheet sheet = workbook.Worksheets[0];

            sheet.Range["A1"].Number = 100; 
            sheet.Range["A1"].NumberFormat = "[Red]$#,##0";

            sheet.Range["B2"].Number = 123; 
            sheet.Range["B2"].NumberFormat = "[DBNum2][$-zh-CN]G/通用格式";

            sheet.Range["B3"].Number = 123;
            sheet.Range["B3"].NumberFormat = "[DBNum2][$-zh-CN]G/\"通用格式\"";

            var r = new Random();

            string fn = $"Sample_{r.Next(10000,99999)}.xlsx";

            workbook.SaveAs(fn);
            workbook.Close();

            excelEngine.ThrowNotSavedOnDestroy = true;
            excelEngine.Dispose();
        }
    }
}
