using Microsoft.AspNetCore.Mvc;
using BlazorApp3.BoldBI;
using System.Net.Http;
using System;
using System.Security.Cryptography;
using Microsoft.AspNetCore.Hosting;
using Newtonsoft.Json;

namespace IMX.Web.Pages
{
  [Route("api/BoldBIController")]
  [ApiController]
  public class BoldBIController : Controller
  {
    private readonly IWebHostEnvironment hostingEnv;

    public BoldBIController(IWebHostEnvironment env)
    {
      this.hostingEnv = env;
    }

    [HttpPost("[action]")]
    [Route("GetDetails")]
    public string GetEmbedDetails([FromBody] object embedQuerString)
    {
      var embedClass = JsonConvert.DeserializeObject<EmbedClass>(embedQuerString.ToString());
      var embedQuery = embedClass.embedQuerString;
      // User your user-email as embed_user_email
      embedQuery += "&embed_user_email=" + EmbedProperties.UserEmail;
      var embedDetailsUrl = "/embed/authorize?" + embedQuery + "&embed_signature=" + GetSignatureUrl(embedQuery);

      using (var client = new HttpClient())
      {
        client.BaseAddress = new Uri(embedClass.dashboardServerApiUrl);
        client.DefaultRequestHeaders.Accept.Clear();

        var result = client.GetAsync(embedClass.dashboardServerApiUrl + embedDetailsUrl).Result;
        string resultContent = result.Content.ReadAsStringAsync().Result;
        return resultContent;
      }
    }

    public string GetSignatureUrl(string message)
    {
      var encoding = new System.Text.UTF8Encoding();
      var keyBytes = encoding.GetBytes(EmbedProperties.EmbedSecret);
      var messageBytes = encoding.GetBytes(message);
      using (var hmacsha1 = new System.Security.Cryptography.HMACSHA256(keyBytes))
      {
        var hashMessage = hmacsha1.ComputeHash(messageBytes);
        return Convert.ToBase64String(hashMessage);
      }
    }
  }
}
