﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Syncfusion.XlsIO;

namespace Confluence.WorkbooksGateway.Gateway.XlsIO
{
    internal class XlsIOStandardFormater
    {
        internal static string DEFAULT_FONT_NAME = "Calibri";
        internal static double DEFAULT_FONT_SIZE = 11.0;

        internal static void SetConditionalFormatBorders(IConditionalFormat conditionalFormat, Color border)
        {
            conditionalFormat.BottomBorderColorRGB = border;
            conditionalFormat.BottomBorderStyle = ExcelLineStyle.Thin;
            conditionalFormat.TopBorderColorRGB = border;
            conditionalFormat.TopBorderStyle = ExcelLineStyle.Thin;
            conditionalFormat.LeftBorderColorRGB = border;
            conditionalFormat.LeftBorderStyle = ExcelLineStyle.Thin;
            conditionalFormat.RightBorderColorRGB = border;
            conditionalFormat.RightBorderStyle = ExcelLineStyle.Thin;
        }

        internal static void SetStandardBorderForCell(Syncfusion.XlsIO.IRange cell, ExcelBordersIndex border)
        {
            //Only draw top and bottom borders if we didn't inherit any from the fingerprint

            if (cell.CellStyle.Borders[border].LineStyle == ExcelLineStyle.None)
            {
                cell.CellStyle.Borders[border].LineStyle = ExcelLineStyle.Thin;
                cell.CellStyle.Borders[border].ColorRGB = Color.FromArgb(191, 191, 191);
            }
        }

        internal static void SetBordersForCell(Syncfusion.XlsIO.IRange cell, Color color, ExcelLineStyle style)
        {
            cell.CellStyle.Borders[ExcelBordersIndex.EdgeTop].LineStyle = style;
            cell.CellStyle.Borders[ExcelBordersIndex.EdgeTop].ColorRGB = color;
            cell.CellStyle.Borders[ExcelBordersIndex.EdgeLeft].LineStyle = style;
            cell.CellStyle.Borders[ExcelBordersIndex.EdgeLeft].ColorRGB = color;
            cell.CellStyle.Borders[ExcelBordersIndex.EdgeBottom].LineStyle = style;
            cell.CellStyle.Borders[ExcelBordersIndex.EdgeBottom].ColorRGB = color;
            cell.CellStyle.Borders[ExcelBordersIndex.EdgeRight].LineStyle = style;
            cell.CellStyle.Borders[ExcelBordersIndex.EdgeRight].ColorRGB = color;
        }
    }
}
