//Fixed: 4518, 17328,9340
import { Browser, ChildProperty, Complex, Component, Event, EventHandler, Internationalization, L10n, NotifyPropertyChanges, Property, classList, createElement, formatUnit, isNullOrUndefined, select } from '@syncfusion/ej2-base';
import { ContextMenu, Tab, Toolbar } from '@syncfusion/ej2-navigations';
import { Dialog, DialogUtility, Popup, Tooltip, createSpinner, hideSpinner, showSpinner } from '@syncfusion/ej2-popups';
import { Button, CheckBox, RadioButton } from '@syncfusion/ej2-buttons';
import { ListView } from '@syncfusion/ej2-lists';
import { ColorPicker, NumericTextBox, TextBox } from '@syncfusion/ej2-inputs';
import { ComboBox, DropDownList } from '@syncfusion/ej2-dropdowns';
import { DateTimePicker } from '@syncfusion/ej2-calendars';
import { DropDownButton, SplitButton } from '@syncfusion/ej2-splitbuttons';
import { Query } from '@syncfusion/ej2-data';
import { ChartComponent } from '@syncfusion/ej2-office-chart';
import { ZipArchive, ZipArchiveItem } from '@syncfusion/ej2-compression';
import { Save, StreamWriter, XmlWriter } from '@syncfusion/ej2-file-utils';

/* eslint-disable */
/**
 * @private
 */
class Dictionary {
    constructor() {
        this.keysInternal = [];
        this.valuesInternal = [];
    }
    /**
     * @private
     */
    get length() {
        return this.keysInternal.length;
    }
    /**
     * @private
     */
    get keys() {
        return this.keysInternal;
    }
    /**
     * @private
     */
    add(key, value) {
        if (isNullOrUndefined(key)) {
            throw new ReferenceError('Provided key or value is not valid.');
        }
        let index = this.keysInternal.indexOf(key);
        // if (index < 0 || index > this.keysInternal.length - 1) {
        if (index < 0) {
            this.keysInternal.push(key);
            this.valuesInternal.push(value);
        }
        return 1;
        // else {
        //     throw new RangeError('An item with the same key has already been added.');
        // }
    }
    /**
     * @private
     */
    get(key) {
        if (isNullOrUndefined(key)) {
            throw new ReferenceError('Provided key is not valid.');
        }
        let index = this.keysInternal.indexOf(key);
        if (index < 0 || index > this.keysInternal.length - 1) {
            return undefined;
            //throw new RangeError('No item with the specified key has been added.');
        }
        else {
            return this.valuesInternal[index];
        }
    }
    /**
     * @private
     */
    set(key, value) {
        if (isNullOrUndefined(key)) {
            throw new ReferenceError('Provided key is not valid.');
        }
        let index = this.keysInternal.indexOf(key);
        if (index < 0 || index > this.keysInternal.length - 1) {
            throw new RangeError('No item with the specified key has been added.');
        }
        else {
            this.valuesInternal[index] = value;
        }
    }
    /**
     * @private
     */
    remove(key) {
        if (isNullOrUndefined(key)) {
            throw new ReferenceError('Provided key is not valid.');
        }
        let index = this.keysInternal.indexOf(key);
        if (index < 0 || index > this.keysInternal.length - 1) {
            throw new RangeError('No item with the specified key has been added.');
        }
        else {
            this.keysInternal.splice(index, 1);
            this.valuesInternal.splice(index, 1);
            return true;
        }
    }
    /**
     * @private
     */
    containsKey(key) {
        if (isNullOrUndefined(key)) {
            throw new ReferenceError('Provided key is not valid.');
        }
        let index = this.keysInternal.indexOf(key);
        if (index < 0 || index > this.keysInternal.length - 1) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    clear() {
        this.keysInternal = [];
        this.valuesInternal = [];
    }
    /**
     * @private
     */
    destroy() {
        this.clear();
        this.keysInternal = undefined;
        this.valuesInternal = undefined;
    }
}

/* eslint-disable */
/**
 * @private
 */
class WUniqueFormat {
    constructor(type) {
        this.referenceCount = 0;
        this.uniqueFormatType = type;
        this.propertiesHash = new Dictionary();
    }
    /**
     * @private
     */
    isEqual(source, property, modifiedValue) {
        let isEqual = false;
        switch (this.uniqueFormatType) {
            case 1:
                isEqual = this.isBorderEqual(source, property, modifiedValue);
                break;
            case 2:
                isEqual = this.isCharacterFormatEqual(source, property, modifiedValue);
                break;
            case 3:
                isEqual = this.isParagraphFormatEqual(source, property, modifiedValue);
                break;
            case 4:
                isEqual = this.isCellFormatEqual(source, property, modifiedValue);
                break;
            case 5:
                isEqual = this.isShadingEqual(source, property, modifiedValue);
                break;
            case 6:
                isEqual = this.isRowFormatEqual(source, property, modifiedValue);
                break;
            case 7:
                isEqual = this.isListFormatEqual(source, property, modifiedValue);
                break;
            case 8:
                isEqual = this.isTableFormatEqual(source, property, modifiedValue);
                break;
            case 9:
                isEqual = this.isListLevelEqual(source, property, modifiedValue);
                break;
            case 10:
                isEqual = this.isSectionFormatEqual(source, property, modifiedValue);
                break;
            default:
                break;
        }
        return isEqual;
    }
    isNotEqual(property, source, modifiedProperty, modifiedValue, uniqueFormatType) {
        let targetValue = undefined;
        const propertyType = WUniqueFormat.getPropertyType(uniqueFormatType, property);
        if (this.propertiesHash.containsKey(propertyType)) {
            targetValue = this.propertiesHash.get(propertyType);
        }
        let sourceValue = undefined;
        if (property === modifiedProperty) {
            sourceValue = modifiedValue;
        }
        else if (source.containsKey(propertyType)) {
            sourceValue = source.get(propertyType);
        }
        if (!(targetValue === sourceValue || (!isNullOrUndefined(targetValue) && !isNullOrUndefined(sourceValue) && targetValue === sourceValue))) {
            return true;
        }
        return false;
    }
    /**
     * @private
     */
    static getPropertyType(uniqueFormatType, property) {
        let type = 0;
        switch (uniqueFormatType) {
            case 1:
                type = this.getBorderPropertyType(property);
                break;
            case 2:
                type = this.getCharacterFormatPropertyType(property);
                break;
            case 3:
                type = this.getParaFormatPropertyType(property);
                break;
            case 4:
                type = this.getCellFormatPropertyType(property);
                break;
            case 5:
                type = this.getShadingPropertyType(property);
                break;
            case 6:
                type = this.getRowFormatType(property);
                break;
            case 7:
                type = this.getListFormatType(property);
                break;
            case 8:
                type = this.getTableFormatType(property);
                break;
            case 9:
                type = this.getListLevelType(property);
                break;
            case 10:
                type = this.getSectionFormatType(property);
                break;
            default:
                break;
        }
        return type;
    }
    static getRowFormatType(property) {
        if (property === 'allowBreakAcrossPages') {
            return 1;
        }
        if (property === 'isHeader') {
            return 2;
        }
        if (property === 'height') {
            return 3;
        }
        if (property === 'heightType') {
            return 4;
        }
        if (property === 'gridBefore') {
            return 5;
        }
        if (property === 'gridBeforeWidth') {
            return 6;
        }
        if (property === 'gridBeforeWidthType') {
            return 7;
        }
        if (property === 'gridAfter') {
            return 8;
        }
        if (property === 'gridAfterWidth') {
            return 9;
        }
        if (property === 'gridAfterWidthType') {
            return 10;
        }
        if (property === 'leftMargin') {
            return 11;
        }
        if (property === 'topMargin') {
            return 12;
        }
        if (property === 'bottomMargin') {
            return 13;
        }
        if (property === 'rightMargin') {
            return 14;
        }
        if (property === 'leftIndent') {
            return 15;
        }
        return 0;
    }
    static getListFormatType(property) {
        if (property === 'listId') {
            return 1;
        }
        if (property === 'listLevelNumber') {
            return 2;
        }
        return 0;
    }
    static getTableFormatType(property) {
        if (property === 'leftMargin') {
            return 1;
        }
        if (property === 'rightMargin') {
            return 2;
        }
        if (property === 'topMargin') {
            return 3;
        }
        if (property === 'bottomMargin') {
            return 4;
        }
        if (property === 'cellSpacing') {
            return 5;
        }
        if (property === 'leftIndent') {
            return 6;
        }
        if (property === 'tableAlignment') {
            return 7;
        }
        if (property === 'preferredWidth') {
            return 8;
        }
        if (property === 'preferredWidthType') {
            return 9;
        }
        if (property === 'bidi') {
            return 10;
        }
        if (property === 'allowAutoFit') {
            return 11;
        }
        if (property === 'horizontalPositionAbs') {
            return 12;
        }
        if (property === 'horizontalPosition') {
            return 13;
        }
        return 0;
    }
    static getListLevelType(property) {
        if (property === 'listLevelPattern') {
            return 1;
        }
        if (property === 'startAt') {
            return 2;
        }
        if (property === 'followCharacter') {
            return 3;
        }
        if (property === 'numberFormat') {
            return 4;
        }
        if (property === 'restartLevel') {
            return 5;
        }
        return 0;
    }
    static getShadingPropertyType(property) {
        if (property === 'backgroundColor') {
            return 1;
        }
        if (property === 'foregroundColor') {
            return 2;
        }
        if (property === 'textureStyle') {
            return 3;
        }
        return 0;
    }
    static getCellFormatPropertyType(property) {
        if (property === 'leftMargin') {
            return 1;
        }
        if (property === 'rightMargin') {
            return 2;
        }
        if (property === 'topMargin') {
            return 3;
        }
        if (property === 'bottomMargin') {
            return 4;
        }
        if (property === 'columnSpan') {
            return 5;
        }
        if (property === 'rowSpan') {
            return 6;
        }
        if (property === 'verticalAlignment') {
            return 7;
        }
        if (property === 'preferredWidthType') {
            return 8;
        }
        if (property === 'preferredWidth') {
            return 9;
        }
        if (property === 'cellWidth') {
            return 10;
        }
        return 0;
    }
    static getBorderPropertyType(property) {
        if (property === 'color') {
            return 1;
        }
        if (property === 'lineStyle') {
            return 2;
        }
        if (property === 'lineWidth') {
            return 3;
        }
        if (property === 'shadow') {
            return 4;
        }
        if (property === 'space') {
            return 5;
        }
        if (property === 'hasNoneStyle') {
            return 6;
        }
        return 0;
    }
    static getCharacterFormatPropertyType(property) {
        if (property === 'fontColor') {
            return 1;
        }
        if (property === 'fontFamily') {
            return 2;
        }
        if (property === 'fontSize') {
            return 3;
        }
        if (property === 'bold') {
            return 4;
        }
        if (property === 'italic') {
            return 5;
        }
        if (property === 'underline') {
            return 6;
        }
        if (property === 'strikethrough') {
            return 7;
        }
        if (property === 'baselineAlignment') {
            return 8;
        }
        if (property === 'highlightColor') {
            return 9;
        }
        if (property === 'bidi') {
            return 10;
        }
        if (property === 'bdo') {
            return 11;
        }
        if (property === 'boldBidi') {
            return 12;
        }
        if (property === 'italicBidi') {
            return 13;
        }
        if (property === 'fontFamilyBidi') {
            return 14;
        }
        if (property === 'fontSizeBidi') {
            return 15;
        }
        if (property === 'allCaps') {
            return 16;
        }
        return 0;
    }
    static getParaFormatPropertyType(property) {
        if (property === 'leftIndent') {
            return 1;
        }
        if (property === 'rightIndent') {
            return 2;
        }
        if (property === 'firstLineIndent') {
            return 3;
        }
        if (property === 'textAlignment') {
            return 4;
        }
        if (property === 'beforeSpacing') {
            return 5;
        }
        if (property === 'afterSpacing') {
            return 6;
        }
        if (property === 'lineSpacing') {
            return 7;
        }
        if (property === 'lineSpacingType') {
            return 8;
        }
        if (property === 'outlineLevel') {
            return 9;
        }
        if (property === 'bidi') {
            return 10;
        }
        if (property === 'contextualSpacing') {
            return 11;
        }
        if (property === 'keepWithNext') {
            return 12;
        }
        if (property === 'keepLinesTogether') {
            return 13;
        }
        if (property === 'widowControl') {
            return 14;
        }
        if (property === 'spaceBeforeAuto') {
            return 15;
        }
        if (property === 'spaceAfterAuto') {
            return 16;
        }
        return 0;
    }
    static getSectionFormatType(property) {
        if (property === 'headerDistance') {
            return 1;
        }
        if (property === 'footerDistance') {
            return 2;
        }
        if (property === 'differentFirstPage') {
            return 3;
        }
        if (property === 'differentOddAndEvenPages') {
            return 4;
        }
        if (property === 'pageWidth') {
            return 5;
        }
        if (property === 'pageHeight') {
            return 6;
        }
        if (property === 'leftMargin') {
            return 7;
        }
        if (property === 'topMargin') {
            return 8;
        }
        if (property === 'rightMargin') {
            return 9;
        }
        if (property === 'bottomMargin') {
            return 10;
        }
        if (property === 'bidi') {
            return 11;
        }
        if (property === 'restartPageNumbering') {
            return 12;
        }
        if (property === 'pageStartingNumber') {
            return 13;
        }
        if (property === 'endnoteNumberFormat') {
            return 14;
        }
        if (property === 'endnotePosition') {
            return 15;
        }
        if (property === 'footNoteNumberFormat') {
            return 16;
        }
        if (property === 'footnotePosition') {
            return 17;
        }
        if (property === 'restartIndexForEndnotes') {
            return 18;
        }
        if (property === 'restartIndexForFootnotes') {
            return 19;
        }
        if (property === 'initialFootNoteNumber') {
            return 20;
        }
        if (property === 'initialEndNoteNumber') {
            return 21;
        }
        return 0;
    }
    /**
     * @private
     */
    isBorderEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('color', source, modifiedProperty, modifiedValue, 1)) {
            return false;
        }
        if (this.isNotEqual('lineStyle', source, modifiedProperty, modifiedValue, 1)) {
            return false;
        }
        if (this.isNotEqual('lineWidth', source, modifiedProperty, modifiedValue, 1)) {
            return false;
        }
        if (this.isNotEqual('shadow', source, modifiedProperty, modifiedValue, 1)) {
            return false;
        }
        if (this.isNotEqual('space', source, modifiedProperty, modifiedValue, 1)) {
            return false;
        }
        if (this.isNotEqual('hasNoneStyle', source, modifiedProperty, modifiedValue, 1)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    isCharacterFormatEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('fontColor', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('fontFamily', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('fontSize', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('bold', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('italic', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('underline', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('strikethrough', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('baselineAlignment', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('highlightColor', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('bidi', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('bdo', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('fontColor', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('fontFamilyBidi', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('fontSizeBidi', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('boldBidi', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('italicBidi', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        if (this.isNotEqual('allCaps', source, modifiedProperty, modifiedValue, 2)) {
            return false;
        }
        return true;
    }
    isParagraphFormatEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('leftIndent', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('rightIndent', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('firstLineIndent', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('textAlignment', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('beforeSpacing', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('afterSpacing', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('spaceBeforeAuto', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('spaceAfterAuto', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('lineSpacing', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('lineSpacingType', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('outlineLevel', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('bidi', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('contextualSpacing', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('keepWithNext', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('keepLinesTogether', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        if (this.isNotEqual('widowControl', source, modifiedProperty, modifiedValue, 3)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    isCellFormatEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('leftMargin', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('rightMargin', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('topMargin', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('bottomMargin', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('columnSpan', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('rowSpan', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('verticalAlignment', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('preferredWidthType', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('preferredWidth', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        if (this.isNotEqual('cellWidth', source, modifiedProperty, modifiedValue, 4)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    isShadingEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('backgroundColor', source, modifiedProperty, modifiedValue, 5)) {
            return false;
        }
        if (this.isNotEqual('foregroundColor', source, modifiedProperty, modifiedValue, 5)) {
            return false;
        }
        if (this.isNotEqual('textureStyle', source, modifiedProperty, modifiedValue, 5)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    isRowFormatEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('allowBreakAcrossPages', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('isHeader', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('height', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('heightType', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('gridBefore', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('gridBeforeWidth', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('gridBeforeWidthType', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('gridAfter', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('gridAfterWidth', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('gridAfterWidthType', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('leftMargin', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('topMargin', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('bottomMargin', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('rightMargin', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        if (this.isNotEqual('leftIndent', source, modifiedProperty, modifiedValue, 6)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    isListFormatEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('listId', source, modifiedProperty, modifiedValue, 7)) {
            return false;
        }
        if (this.isNotEqual('listLevelNumber', source, modifiedProperty, modifiedValue, 7)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    isTableFormatEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('leftMargin', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('rightMargin', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('topMargin', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('bottomMargin', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('cellSpacing', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('leftIndent', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('tableAlignment', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('preferredWidth', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('preferredWidthType', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('bidi', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('allowAutoFit', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('horizontalPositionAbs', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        if (this.isNotEqual('horizontalPosition', source, modifiedProperty, modifiedValue, 8)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    isListLevelEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('listLevelPattern', source, modifiedProperty, modifiedValue, 9)) {
            return false;
        }
        if (this.isNotEqual('startAt', source, modifiedProperty, modifiedValue, 9)) {
            return false;
        }
        if (this.isNotEqual('followCharacter', source, modifiedProperty, modifiedValue, 9)) {
            return false;
        }
        if (this.isNotEqual('numberFormat', source, modifiedProperty, modifiedValue, 9)) {
            return false;
        }
        if (this.isNotEqual('restartLevel', source, modifiedProperty, modifiedValue, 9)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    isSectionFormatEqual(source, modifiedProperty, modifiedValue) {
        if (this.isNotEqual('headerDistance', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('footerDistance', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('differentFirstPage', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('differentOddAndEvenPages', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('pageWidth', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('pageHeight', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('leftMargin', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('topMargin', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('rightMargin', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('bottomMargin', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('bidi', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('restartPageNumbering', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('pageStartingNumber', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('endnoteNumberFormat', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('endnotePosition', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('footNoteNumberFormat', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('footnotePosition', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('restartIndexForEndnotes', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('restartIndexForFootnotes', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('initialFootNoteNumber', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        if (this.isNotEqual('initialEndNoteNumber', source, modifiedProperty, modifiedValue, 10)) {
            return false;
        }
        return true;
    }
    /**
     * @private
     */
    cloneItems(format, property, value, uniqueFormatType) {
        const propertyType = WUniqueFormat.getPropertyType(uniqueFormatType, property);
        const keys = format.propertiesHash.keys;
        for (let i = 0; i < keys.length; i++) {
            if (keys[i] === propertyType) {
                this.propertiesHash.add(propertyType, value);
            }
            else {
                this.propertiesHash.add(keys[i], format.propertiesHash.get(keys[i]));
            }
        }
        if (!format.propertiesHash.containsKey(propertyType)) {
            this.propertiesHash.add(propertyType, value);
        }
    }
    /**
     * @private
     */
    mergeProperties(format) {
        const hash = format.cloneProperties();
        const keys = this.propertiesHash.keys;
        for (let i = 0; i < keys.length; i++) {
            if (!hash.containsKey(keys[i])) {
                hash.add(keys[i], this.propertiesHash.get(keys[i]));
            }
        }
        return hash;
    }
    /**
     * @private
     */
    cloneProperties() {
        const hash = new Dictionary();
        const keys = this.propertiesHash.keys;
        for (let i = 0; i < keys.length; i++) {
            hash.add(keys[i], this.propertiesHash.get(keys[i]));
        }
        return hash;
    }
    // public cloneItemsInternal(format: WUniqueFormat): void {
    //     let keys: number[] = format.propertiesHash.getItem();
    //     for (let i: number = 0; i < keys.length; i++) {
    //         this.propertiesHash.add(keys[i], format.propertiesHash.get(keys[i]));
    //     }
    //     this.referenceCount = format.referenceCount;
    // }
    /**
     * @private
     */
    destroy() {
        if (!isNullOrUndefined(this.propertiesHash)) {
            this.propertiesHash.destroy();
        }
        this.propertiesHash = undefined;
        this.referenceCount = undefined;
        this.uniqueFormatType = undefined;
    }
}

/* eslint-disable */
/**
 * @private
 */
class WUniqueFormats {
    constructor() {
        this.items = [];
    }
    /**
     * @private
     */
    addUniqueFormat(format, type) {
        let matchedFormat = undefined;
        for (let i = 0; i < this.items.length; i++) {
            if (this.items[i].isEqual(format, undefined, undefined)) {
                matchedFormat = this.items[i];
                break;
            }
        }
        if (isNullOrUndefined(matchedFormat)) {
            matchedFormat = new WUniqueFormat(type);
            matchedFormat.propertiesHash = format;
            matchedFormat.referenceCount = 1;
            this.items.push(matchedFormat);
        }
        else {
            matchedFormat.referenceCount++;
        }
        return matchedFormat;
    }
    /**
     * @private
     */
    updateUniqueFormat(uniqueFormat, property, value) {
        let matchedFormat = undefined;
        for (let i = 0; i < this.items.length; i++) {
            if (this.items[i].isEqual(uniqueFormat.propertiesHash, property, value)) {
                matchedFormat = this.items[i];
                break;
            }
        }
        if (isNullOrUndefined(matchedFormat)) {
            matchedFormat = new WUniqueFormat(uniqueFormat.uniqueFormatType);
            matchedFormat.cloneItems(uniqueFormat, property, value, uniqueFormat.uniqueFormatType);
            matchedFormat.referenceCount = 1;
            this.items.push(matchedFormat);
        }
        else {
            matchedFormat.referenceCount++;
        }
        this.remove(uniqueFormat);
        uniqueFormat = undefined;
        return matchedFormat;
    }
    /**
     * @private
     */
    remove(uniqueFormat) {
        uniqueFormat.referenceCount--;
        if (uniqueFormat.referenceCount <= 0) {
            this.items.splice(this.items.indexOf(uniqueFormat), 1);
            uniqueFormat.destroy();
            uniqueFormat = undefined;
        }
    }
    /**
     * @private
     */
    clear() {
        if (isNullOrUndefined(this.items)) {
            for (let i = 0; i < this.items.length; i++) {
                this.items[i].destroy();
            }
        }
        this.items = [];
    }
    /**
     * @private
     */
    destroy() {
        this.clear();
        this.items = undefined;
    }
}

/* eslint-disable */
/**
 * @private
 */
class XmlHttpRequestHandler {
    constructor() {
        /**
         * A boolean value indicating whether the request should be sent asynchronous or not.
         *
         * @default true
         */
        this.mode = true;
    }
    /**
     * Send the request to server
     *
     * @param  {object} jsonObject - To send to service
     */
    send(jsonObject, httpRequestEventArgs) {
        this.xmlHttpRequest = new XMLHttpRequest();
        let timeout = 0;
        if (!isNullOrUndefined(httpRequestEventArgs)) {
            this.xmlHttpRequest.withCredentials = httpRequestEventArgs.withCredentials;
            timeout = (httpRequestEventArgs.timeout >= 0 ? httpRequestEventArgs.timeout : 0);
            this.customHeaders = httpRequestEventArgs.headers;
        }
        this.xmlHttpRequest.onreadystatechange = () => {
            this.stateChange(this);
        };
        this.xmlHttpRequest.onerror = () => {
            this.error(this);
        };
        if (!this.mode) {
            setTimeout(() => {
                this.sendRequest(jsonObject, timeout);
            });
        }
        else {
            this.sendRequest(jsonObject, timeout);
        }
    }
    sendRequest(jsonObj, timeout) {
        this.xmlHttpRequest.open('POST', this.url, true);
        this.xmlHttpRequest.timeout = timeout;
        if (this.contentType) {
            this.xmlHttpRequest.setRequestHeader('Content-Type', this.contentType);
        }
        this.setCustomAjaxHeaders();
        if (this.responseType) {
            this.xmlHttpRequest.responseType = this.responseType;
        }
        const data = jsonObj instanceof FormData ? jsonObj : JSON.stringify(jsonObj);
        this.xmlHttpRequest.send(data); // jshint ignore:line
    }
    stateChange(proxyReq) {
        if (proxyReq.xmlHttpRequest.readyState === 4 && proxyReq.xmlHttpRequest.status === 200) {
            let data;
            if (this.responseType) {
                data = proxyReq.xmlHttpRequest.response;
            }
            else {
                data = proxyReq.xmlHttpRequest.responseText;
            }
            let result = {
                name: 'onSuccess',
                data: data,
                readyState: proxyReq.xmlHttpRequest.readyState,
                status: proxyReq.xmlHttpRequest.status
            };
            proxyReq.successHandler(result);
        }
        else if (proxyReq.xmlHttpRequest.readyState === 4 && !(proxyReq.xmlHttpRequest.status === 200)) { // jshint ignore:line)
            let result = {
                name: 'onFailure',
                status: proxyReq.xmlHttpRequest.status,
                statusText: proxyReq.xmlHttpRequest.statusText,
                url: proxyReq.url
            };
            proxyReq.failureHandler(result);
        }
    }
    error(proxyReq) {
        let result = {
            name: 'onError',
            status: this.xmlHttpRequest.status,
            statusText: this.xmlHttpRequest.statusText
        };
        proxyReq.errorHandler(result);
    }
    successHandler(response) {
        if (this.onSuccess) {
            this.onSuccess(response);
        }
        return response;
    }
    failureHandler(response) {
        if (this.onFailure) {
            this.onFailure(response);
        }
        return response;
    }
    errorHandler(response) {
        if (this.onError) {
            this.onError(response);
        }
        return response;
    }
    setCustomAjaxHeaders() {
        for (let i = 0; i < this.customHeaders.length; i++) {
            const header = this.customHeaders[i];
            for (const key of Object.keys(header)) {
                this.xmlHttpRequest.setRequestHeader(key, header[key]);
            }
        }
    }
}

/** @hidden */
const internalZoomFactorChange = 'internalZoomFactorChange';
/** @hidden */
const contentChangeEvent = 'contentChange';
/** @hidden */
const documentChangeEvent = 'documentChange';
/** @hidden */
const selectionChangeEvent = 'selectionChange';
/** @hidden */
const zoomFactorChangeEvent = 'zoomFactorChange';
/** @hidden */
const beforeFieldFillEvent = 'beforeFieldFill';
/** @hidden */
const afterFieldFillEvent = 'afterFieldFill';
/** @hidden */
const afterFormFieldFillEvent = 'afterFormFieldFill';
/** @hidden */
const beforeFormFieldFillEvent = 'beforeFormFieldFill';
/** @hidden */
const serviceFailureEvent = 'serviceFailure';
/** @hidden */
const viewChangeEvent = 'viewChange';
/** @hidden */
const customContextMenuSelectEvent = 'customContextMenuSelect';
/** @hidden */
const customContextMenuBeforeOpenEvent = 'customContextMenuBeforeOpen';
/** @hidden */
const contentControlEvent = 'contentControl';
/** @hidden */
const commentBeginEvent = 'commentBegin';
/** @hidden */
const commentEndEvent = 'commentEnd';
/** @hidden */
const beforeCommentActionEvent = 'beforeCommentAction';
/** @hidden */
const commentDeleteEvent = 'commentDelete';
/** @hidden */
const beforePaneSwitchEvent = 'beforePaneSwitch';
/** @hidden */
const requestNavigateEvent = 'requestNavigate';
/** @hidden */
const actionCompleteEvent = 'actionComplete';
/** @hidden */
const trackChangeEvent = 'trackChange';
/** @hidden */
const searchResultsChangeEvent = 'searchResultsChange';
/** @hidden */
const keyDownEvent = 'keyDown';
/** @hidden */
const toolbarClickEvent = 'toolbarClick';
/** @hidden */
const beforeFileOpenEvent = 'beforeFileOpen';
/** @hidden */
const internalviewChangeEvent = 'internalviewChange';
/** @hidden */
const beforeXmlHttpRequestSend = 'beforeXmlHttpRequestSend';

/**
 * Print class
 */
class Print {
    getModuleName() {
        return 'Print';
    }
    /**
     * Prints the current viewer
     *
     * @private
     * @param {DocumentHelper} documentHelper - Specifies the document helper.
     * @param {Window} printWindow - Specifies the print window.
     * @returns {void}
     */
    print(documentHelper, printWindow) {
        this.printWindow(documentHelper, navigator.userAgent, printWindow);
    }
    /**
     * Opens print window and displays current page to print.
     *
     * @private
     * @param {DocumentHelper} documentHelper - Specifies the document helper.
     * @param {string} browserUserAgent - Specifies the browser user agent.
     * @param {Window} printWindow - Specifies the print window.
     * @returns {void}
     */
    printWindow(documentHelper, browserUserAgent, printWindow) {
        const height = this.getPageHeight(documentHelper.pages);
        const width = this.getPageWidth(documentHelper.pages);
        let printElement = document.createElement('div');
        printElement.style.width = '100%';
        printElement.style.height = '100%';
        printElement.style.overflow = 'scroll';
        // Rendering canvas to print
        this.generatePrintContent(documentHelper, printElement);
        if (isNullOrUndefined(printWindow)) {
            printWindow = window.open('', 'print', 'height=452,width=1024,tabbar=no');
        }
        if ((browserUserAgent.indexOf('Chrome') !== -1) || (browserUserAgent.indexOf('Firefox')) !== -1) {
            // Chrome and Firefox
            printWindow.document.write('<!DOCTYPE html>');
            printWindow.document.write('<html moznomarginboxes mozdisallowselectionprint><head><style>html, body { height: 100 %; } img { height: 100 %; width: 100 %; display: block;}img { box-sizing: border-box; }br, button { display: none; }@page{ margin: 0cm; size:' + width.toString() + 'px ' + height.toString() + 'px; }@media print{ body { margin: 0cm; }</style></head> <body><center>');
        }
        else {
            // Internet Explorer and Edge
            printWindow.document.write('<html><head><style>@page{margin:0;size:' + width.toString() + 'px ' + height.toString() + 'px;}</style></head><body><center>');
        }
        printWindow.document.write(printElement.innerHTML + '</center><script> (function() { window.ready = true; })(); </script></body></html>');
        printElement = undefined;
        printWindow.document.close();
        printWindow.focus();
        const interval = setInterval(() => {
            // eslint-disable-next-line
            if (printWindow.ready) {
                printWindow.print();
                printWindow.close();
                clearInterval(interval);
            }
        }, 500);
    }
    /**
     * Generate Document Image.
     *
     * @param documentHelper
     * @param pageNumber
     * @param imageType
     * @private
     */
    exportAsImage(documentHelper, pageNumber, imageType) {
        let image;
        if (!isNullOrUndefined(pageNumber) && pageNumber <= documentHelper.pages.length && pageNumber >= 1) {
            const prntPage = documentHelper.pages[(pageNumber - 1)];
            const pgHeight = prntPage.boundingRectangle.height;
            const pgWidth = prntPage.boundingRectangle.width;
            documentHelper.render.isPrinting = true;
            documentHelper.render.renderWidgets(prntPage, 0, 0, 0, 0);
            //get the image data from the canvas
            const imageData = documentHelper.render.pageCanvas.toDataURL(imageType, 1);
            documentHelper.render.isPrinting = false;
            image = new Image();
            image.src = imageData;
            // tslint:disable-next-line:max-line-length
            image.setAttribute('style', 'margin:0px;display:block;width:' + pgWidth.toString() + 'px;height:' + pgHeight.toString() + 'px;');
        }
        return image;
    }
    /**
     * Generates print content.
     *
     * @private
     * @param {DocumentHelper} documentHelper - Specifies the document helper.
     * @param {HTMLDivElement} element - Specifies the element.
     * @returns {void}
     */
    generatePrintContent(documentHelper, element) {
        // Rendering canvas to print
        let htmlString = '';
        for (let i = 0; i < documentHelper.pages.length; i++) {
            const page = documentHelper.pages[i];
            const pageHeight = page.boundingRectangle.height;
            const pageWidth = page.boundingRectangle.width;
            documentHelper.render.isPrinting = true;
            documentHelper.render.renderWidgets(page, 0, 0, 0, 0);
            const canvasURL = documentHelper.render.pageCanvas.toDataURL();
            documentHelper.render.isPrinting = false;
            htmlString += '<div><img src=' + canvasURL + ' style="margin:0px;display:block;width: ' + pageWidth.toString() + 'px; height:' + pageHeight.toString() + 'px; "/></div><br/>';
        }
        element.innerHTML = htmlString;
    }
    /**
     * Gets page width.
     *
     * @private
     * @param {Page} pages - Specifies the pages.
     * @returns {number} - Returns the page width.
     */
    getPageWidth(pages) {
        let width = 0;
        for (let i = 0; i < pages.length; i++) {
            if (width < pages[i].boundingRectangle.width) {
                width = pages[i].boundingRectangle.width;
            }
        }
        return width;
    }
    /**
     * Gets page height.
     *
     * @private
     * @param {Page} pages - Specifies the pages.
     * @returns {number} - Returns the page height.
     */
    getPageHeight(pages) {
        let height = 0;
        for (let i = 0; i < pages.length; i++) {
            if (height < pages[i].boundingRectangle.height) {
                height = pages[i].boundingRectangle.height;
            }
        }
        return height;
    }
    /**
     * @private
     * @returns {void}
     */
    destroy() {
        return;
    }
}

/* eslint-disable */
/**
 * @private
 */
class WSectionFormat {
    constructor(node) {
        this.uniqueSectionFormat = undefined;
        this.ownerBase = node;
    }
    get headerDistance() {
        return this.getPropertyValue('headerDistance');
    }
    set headerDistance(value) {
        this.setPropertyValue('headerDistance', value);
    }
    get footerDistance() {
        return this.getPropertyValue('footerDistance');
    }
    set footerDistance(value) {
        this.setPropertyValue('footerDistance', value);
    }
    get differentFirstPage() {
        return this.getPropertyValue('differentFirstPage');
    }
    set differentFirstPage(value) {
        this.setPropertyValue('differentFirstPage', value);
    }
    get differentOddAndEvenPages() {
        return this.getPropertyValue('differentOddAndEvenPages');
    }
    set differentOddAndEvenPages(value) {
        this.setPropertyValue('differentOddAndEvenPages', value);
    }
    get pageHeight() {
        return this.getPropertyValue('pageHeight');
    }
    set pageHeight(value) {
        this.setPropertyValue('pageHeight', value);
    }
    get rightMargin() {
        return this.getPropertyValue('rightMargin');
    }
    set rightMargin(value) {
        this.setPropertyValue('rightMargin', value);
    }
    get pageWidth() {
        return this.getPropertyValue('pageWidth');
    }
    set pageWidth(value) {
        this.setPropertyValue('pageWidth', value);
    }
    get leftMargin() {
        return this.getPropertyValue('leftMargin');
    }
    set leftMargin(value) {
        this.setPropertyValue('leftMargin', value);
    }
    get bottomMargin() {
        return this.getPropertyValue('bottomMargin');
    }
    set bottomMargin(value) {
        this.setPropertyValue('bottomMargin', value);
    }
    get topMargin() {
        return this.getPropertyValue('topMargin');
    }
    set topMargin(value) {
        this.setPropertyValue('topMargin', value);
    }
    get bidi() {
        return this.getPropertyValue('bidi');
    }
    set bidi(value) {
        this.setPropertyValue('bidi', value);
    }
    get restartPageNumbering() {
        return this.getPropertyValue('restartPageNumbering');
    }
    set restartPageNumbering(value) {
        this.setPropertyValue('restartPageNumbering', value);
    }
    get pageStartingNumber() {
        return this.getPropertyValue('pageStartingNumber');
    }
    set pageStartingNumber(value) {
        this.setPropertyValue('pageStartingNumber', value);
    }
    get endnoteNumberFormat() {
        return this.getPropertyValue('endnoteNumberFormat');
    }
    set endnoteNumberFormat(value) {
        this.setPropertyValue('endnoteNumberFormat', value);
    }
    get restartIndexForEndnotes() {
        return this.getPropertyValue('restartIndexForEndnotes');
    }
    set restartIndexForEndnotes(value) {
        this.setPropertyValue('restartIndexForEndnotes', value);
    }
    get restartIndexForFootnotes() {
        return this.getPropertyValue('restartIndexForFootnotes');
    }
    set restartIndexForFootnotes(value) {
        this.setPropertyValue('restartIndexForFootnotes', value);
    }
    get footNoteNumberFormat() {
        return this.getPropertyValue('footNoteNumberFormat');
    }
    set footNoteNumberFormat(value) {
        this.setPropertyValue('footNoteNumberFormat', value);
    }
    get initialFootNoteNumber() {
        return this.getPropertyValue('initialFootNoteNumber');
    }
    set initialFootNoteNumber(value) {
        this.setPropertyValue('initialFootNoteNumber', value);
    }
    get initialEndNoteNumber() {
        return this.getPropertyValue('initialEndNoteNumber');
    }
    set initialEndNoteNumber(value) {
        this.setPropertyValue('initialEndNoteNumber', value);
    }
    destroy() {
        if (!isNullOrUndefined(this.uniqueSectionFormat)) {
            WSectionFormat.uniqueSectionFormats.remove(this.uniqueSectionFormat);
        }
        this.uniqueSectionFormat = undefined;
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueSectionFormat)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueSectionFormat.uniqueFormatType, property);
            return this.uniqueSectionFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        switch (property) {
            case 'headerDistance':
                value = 36;
                break;
            case 'footerDistance':
                value = 36;
                break;
            case 'differentFirstPage':
                value = false;
                break;
            case 'differentOddAndEvenPages':
                value = false;
                break;
            case 'pageWidth':
                value = 612;
                break;
            case 'pageHeight':
                value = 792;
                break;
            case 'leftMargin':
                value = 72;
                break;
            case 'topMargin':
                value = 72;
                break;
            case 'rightMargin':
                value = 72;
                break;
            case 'bottomMargin':
                value = 72;
                break;
            case 'bidi':
                value = false;
                break;
            case 'restartPageNumbering':
                value = false;
                break;
            case 'pageStartingNumber':
                value = 1;
                break;
            case 'footnotePosition':
                value = 'PrintAtBottomOfPage';
                break;
            case 'endnoteNumberFormat':
                value = 'LowerCaseRoman';
                break;
            case 'endnotePosition':
                value = 'DisplayEndOfDocument';
                break;
            case 'restartIndexForEndnotes':
                value = 'DoNotRestart';
                break;
            case 'restartIndexForFootnotes':
                value = 'DoNotRestart';
                break;
            case 'footNoteNumberFormat':
                value = 'Arabic';
                break;
            case 'initialFootNoteNumber':
                value = 1;
                break;
            case 'initialEndNoteNumber':
                value = 1;
                break;
        }
        return value;
    }
    getPropertyValue(property) {
        const hasValue = this.hasValue(property);
        if (hasValue) {
            const propertyType = WUniqueFormat.getPropertyType(WSectionFormat.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueSectionFormat) && this.uniqueSectionFormat.propertiesHash.containsKey(propertyType)) {
                return this.uniqueSectionFormat.propertiesHash.get(propertyType);
            }
        }
        return WSectionFormat.getPropertyDefaultValue(property);
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WSectionFormat.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueSectionFormat)) {
            this.initializeUniqueSectionFormat(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueSectionFormat.uniqueFormatType, property);
            if (this.uniqueSectionFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueSectionFormat.propertiesHash.get(propertyType) === value) {
                //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueSectionFormat = WSectionFormat.uniqueSectionFormats.updateUniqueFormat(this.uniqueSectionFormat, property, value);
        }
    }
    initializeUniqueSectionFormat(property, propValue) {
        const uniqueSectionFormatTemp = new Dictionary();
        this.addUniqueSectionFormat('headerDistance', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('footerDistance', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('differentFirstPage', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('differentOddAndEvenPages', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('pageWidth', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('pageHeight', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('leftMargin', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('topMargin', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('rightMargin', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('bottomMargin', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('bidi', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('restartPageNumbering', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('pageStartingNumber', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('endnoteNumberFormat', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('endnotePosition', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('footNoteNumberFormat', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('footnotePosition', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('restartIndexForEndnotes', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('restartIndexForFootnotes', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('initialFootNoteNumber', property, propValue, uniqueSectionFormatTemp);
        this.addUniqueSectionFormat('initialEndNoteNumber', property, propValue, uniqueSectionFormatTemp);
        this.uniqueSectionFormat = WSectionFormat.uniqueSectionFormats.addUniqueFormat(uniqueSectionFormatTemp, WSectionFormat.uniqueFormatType);
    }
    addUniqueSectionFormat(property, modifiedProperty, propValue, uniqueSectionFormatTemp) {
        const propertyType = WUniqueFormat.getPropertyType(WSectionFormat.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueSectionFormatTemp.add(propertyType, propValue);
        }
        else {
            uniqueSectionFormatTemp.add(propertyType, WSectionFormat.getPropertyDefaultValue(property));
        }
    }
    copyFormat(format, history) {
        if (history && (history.isUndoing || history.isRedoing)) {
            this.uniqueSectionFormat = format.uniqueSectionFormat;
        }
        else {
            if (!isNullOrUndefined(format)) {
                if (!isNullOrUndefined(format.uniqueSectionFormat) && format.uniqueSectionFormat.propertiesHash) {
                    this.updateUniqueSectionFormat(format);
                }
            }
        }
    }
    updateUniqueSectionFormat(format) {
        let hash = undefined;
        if (this.uniqueSectionFormat) {
            hash = this.uniqueSectionFormat.mergeProperties(format.uniqueSectionFormat);
            if (this.uniqueSectionFormat.referenceCount === 0) {
                WSectionFormat.uniqueSectionFormats.remove(this.uniqueSectionFormat);
                this.uniqueSectionFormat = undefined;
            }
        }
        this.uniqueSectionFormat = new WUniqueFormat(WSectionFormat.uniqueFormatType);
        if (isNullOrUndefined(hash)) {
            hash = this.uniqueSectionFormat.mergeProperties(format.uniqueSectionFormat);
        }
        this.uniqueSectionFormat = WSectionFormat.uniqueSectionFormats.addUniqueFormat(hash, WSectionFormat.uniqueFormatType);
    }
    cloneFormat() {
        const format = new WSectionFormat();
        format.uniqueSectionFormat = this.uniqueSectionFormat;
        return format;
    }
    static clear() {
        this.uniqueSectionFormats.clear();
    }
}
WSectionFormat.uniqueSectionFormats = new WUniqueFormats();
WSectionFormat.uniqueFormatType = 10;

/**
 * @private
 */
class WLevelOverride {
    destroy() {
        if (!isNullOrUndefined(this.overrideListLevel)) {
            this.overrideListLevel.destroy();
        }
        this.levelNumber = undefined;
        this.startAt = undefined;
        this.overrideListLevel = undefined;
    }
    clone() {
        const levelOverride = new WLevelOverride();
        levelOverride.startAt = this.startAt;
        levelOverride.levelNumber = this.levelNumber;
        if (!isNullOrUndefined(this.overrideListLevel)) {
            levelOverride.overrideListLevel = this.overrideListLevel.clone(levelOverride);
        }
        return levelOverride;
    }
}

/**
 * @private
 */
class WList {
    constructor() {
        this.listId = -1;
        this.sourceListId = -1;
        this.abstractListId = -1;
        this.abstractList = undefined;
        this.levelOverrides = [];
    }
    getListLevel(levelNumber) {
        let listLevel = undefined;
        const levelOverride = this.getLevelOverride(levelNumber);
        if (!isNullOrUndefined(levelOverride) && !isNullOrUndefined(levelOverride.overrideListLevel)) {
            listLevel = levelOverride.overrideListLevel;
        }
        else {
            listLevel = this.abstractList.levels[levelNumber];
        }
        return listLevel;
    }
    getLevelOverride(levelNumber) {
        for (let i = 0; i < this.levelOverrides.length; i++) {
            if (this.levelOverrides[i] instanceof WLevelOverride) {
                const levelOverride = this.levelOverrides[i];
                if (levelOverride.levelNumber === levelNumber) {
                    return levelOverride;
                }
            }
        }
        return undefined;
    }
    destroy() {
        if (!isNullOrUndefined(this.levelOverrides)) {
            this.levelOverrides = [];
        }
        this.abstractListId = undefined;
        this.listId = undefined;
        this.sourceListId = undefined;
        this.levelOverrides = undefined;
    }
    mergeList(list) {
        if (!isNullOrUndefined(this.abstractListId) && this.abstractListId !== -1) {
            this.abstractListId = list.abstractListId;
        }
        if (!isNullOrUndefined(this.listId) && this.listId !== -1) {
            this.listId = list.listId;
        }
        if (!isNullOrUndefined(this.sourceListId) && this.sourceListId !== -1) {
            this.sourceListId = list.sourceListId;
        }
        if (!isNullOrUndefined(this.levelOverrides) && this.levelOverrides.length !== 0) {
            this.levelOverrides = list.levelOverrides;
        }
    }
    clone() {
        const list = new WList();
        for (let i = 0; i < this.levelOverrides.length; i++) {
            list.levelOverrides.push(this.levelOverrides[i].clone());
        }
        return list;
    }
}

/* eslint-disable */
/**
 * @private
 */
class WListFormat {
    constructor(node) {
        this.uniqueListFormat = undefined;
        this.ownerBase = undefined;
        this.baseStyle = undefined;
        this.list = undefined;
        this.ownerBase = node;
    }
    get listId() {
        return this.getPropertyValue('listId');
    }
    set listId(listId) {
        this.setPropertyValue('listId', listId);
    }
    get listLevelNumber() {
        return this.getPropertyValue('listLevelNumber');
    }
    set listLevelNumber(value) {
        this.setPropertyValue('listLevelNumber', value);
    }
    get listLevel() {
        let list = undefined;
        if (!isNullOrUndefined(this.list)) {
            list = this.list;
        }
        else {
            let baseListStyle = this.baseStyle;
            while (!isNullOrUndefined(baseListStyle) && baseListStyle instanceof WParagraphStyle) {
                if (baseListStyle.paragraphFormat.listFormat.list) {
                    list = baseListStyle.paragraphFormat.listFormat.list;
                    break;
                }
                else {
                    baseListStyle = baseListStyle.basedOn;
                }
            }
        }
        if (!isNullOrUndefined(list)) {
            return list.getListLevel(this.listLevelNumber);
        }
        else {
            return undefined;
        }
    }
    getPropertyValue(property) {
        if (!this.hasValue(property)) {
            if (this.baseStyle instanceof WParagraphStyle) {
                let baseStyle = this.baseStyle;
                while (!isNullOrUndefined(baseStyle)) {
                    if (baseStyle.paragraphFormat.listFormat.hasValue(property)) {
                        break;
                    }
                    else {
                        baseStyle = baseStyle.basedOn;
                    }
                }
                if (!isNullOrUndefined(baseStyle)) {
                    const propertyType = WUniqueFormat.getPropertyType(WListFormat.uniqueFormatType, property);
                    return baseStyle.paragraphFormat.listFormat.uniqueListFormat.propertiesHash.get(propertyType);
                }
            }
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(WListFormat.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueListFormat) && this.uniqueListFormat.propertiesHash.containsKey(propertyType)) {
                return this.uniqueListFormat.propertiesHash.get(propertyType);
            }
        }
        return WListFormat.getPropertyDefaultValue(property);
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WListFormat.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueListFormat)) {
            this.initializeUniqueListFormat(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueListFormat.uniqueFormatType, property);
            if (this.uniqueListFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueListFormat.propertiesHash.get(propertyType) === value) {
                //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueListFormat = WListFormat.uniqueListFormats.updateUniqueFormat(this.uniqueListFormat, property, value);
        }
    }
    initializeUniqueListFormat(property, propValue) {
        const uniqueListFormatTemp = new Dictionary();
        this.addUniqueListFormat('listId', property, propValue, uniqueListFormatTemp);
        this.addUniqueListFormat('listLevelNumber', property, propValue, uniqueListFormatTemp);
        this.uniqueListFormat = WListFormat.uniqueListFormats.addUniqueFormat(uniqueListFormatTemp, WListFormat.uniqueFormatType);
    }
    addUniqueListFormat(property, modifiedProperty, propValue, uniqueListFormatTemp) {
        const propertyType = WUniqueFormat.getPropertyType(WListFormat.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueListFormatTemp.add(propertyType, propValue);
        }
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        switch (property) {
            case 'listId':
                value = -1;
                break;
            case 'listLevelNumber':
                value = 0;
                break;
        }
        return value;
    }
    copyFormat(format) {
        if (!isNullOrUndefined(format)) {
            if (!isNullOrUndefined(format.uniqueListFormat)) {
                this.listId = format.listId;
                this.listLevelNumber = format.listLevelNumber;
            }
            if (!isNullOrUndefined(format.baseStyle)) {
                this.baseStyle = format.baseStyle;
            }
            if (!isNullOrUndefined(format.list)) {
                this.list = format.list;
            }
        }
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueListFormat)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueListFormat.uniqueFormatType, property);
            return this.uniqueListFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    clearFormat() {
        if (!isNullOrUndefined(this.uniqueListFormat) && this.uniqueListFormat.referenceCount === 0) {
            WListFormat.uniqueListFormats.remove(this.uniqueListFormat);
        }
        this.uniqueListFormat = undefined;
        this.list = undefined;
    }
    destroy() {
        this.clearFormat();
    }
    static clear() {
        this.uniqueListFormats.clear();
    }
    applyStyle(baseStyle) {
        this.baseStyle = baseStyle;
    }
    getValue(property) {
        return this.hasValue(property) ? this.getPropertyValue(property) : undefined;
    }
    mergeFormat(format) {
        if (isNullOrUndefined(this.getValue('listId'))) {
            this.listId = format.getValue('listId');
        }
        if (isNullOrUndefined(this.getValue('listLevelNumber'))) {
            this.listLevelNumber = format.getValue('listLevelNumber');
        }
        if (!isNullOrUndefined(format.list)) {
            if (isNullOrUndefined(this.list)) {
                this.list = new WList();
            }
            this.list.mergeList(format.list);
        }
    }
    cloneListFormat() {
        const format = new WListFormat(undefined);
        format.list = this.list;
        format.listId = this.listId;
        format.baseStyle = this.baseStyle;
        format.listLevelNumber = this.listLevelNumber;
        format.uniqueListFormat = this.uniqueListFormat;
        return format;
    }
}
WListFormat.uniqueListFormats = new WUniqueFormats();
WListFormat.uniqueFormatType = 7;

/* eslint-disable */
/**
 * @private
 */
class WTabStop {
    get position() {
        return this.positionIn;
    }
    set position(value) {
        this.positionIn = value;
    }
    get deletePosition() {
        return this.deletePositionIn;
    }
    set deletePosition(value) {
        this.deletePositionIn = value;
    }
    get tabJustification() {
        return this.justification;
    }
    set tabJustification(value) {
        this.justification = value;
    }
    get tabLeader() {
        return this.leader;
    }
    set tabLeader(value) {
        this.leader = value;
    }
    destroy() {
        this.position = undefined;
        this.deletePosition = undefined;
        this.tabJustification = undefined;
        this.leader = undefined;
    }
}
/**
 * @private
 */
class WParagraphFormat {
    constructor(node) {
        this.uniqueParagraphFormat = undefined;
        this.ownerBase = undefined;
        this.baseStyle = undefined;
        this.tabs = undefined;
        this.ownerBase = node;
        this.listFormat = new WListFormat(this);
        this.tabs = [];
    }
    getUpdatedTabs() {
        let inTabs = [];
        const tabStops = new Dictionary();
        let tabsInListFormat = this.getTabStopsFromListFormat();
        for (const tabStop of tabsInListFormat) {
            if (!tabStops.containsKey(tabStop.position)) {
                tabStops.add(tabStop.position, tabStop);
            }
        }
        if (!isNullOrUndefined(this.baseStyle) && this.baseStyle instanceof WParagraphStyle) {
            let baseStyle = this.baseStyle;
            while (!isNullOrUndefined(baseStyle)) {
                for (const tab of baseStyle.paragraphFormat.tabs) {
                    if (!tabStops.containsKey(tab.position)) {
                        tabStops.add(tab.position, tab);
                    }
                }
                baseStyle = baseStyle.basedOn;
            }
            for (const key of tabStops.keys) {
                if (!this.hasTabStop(parseFloat(key.toFixed(4)))) {
                    inTabs.push(tabStops.get(key));
                }
            }
            inTabs = inTabs.concat(this.tabs.filter((a) => (a.position !== 0 && a.deletePosition === 0)));
            inTabs = inTabs.sort((a, b) => a.position - b.position);
        }
        return inTabs;
    }
    getTabStopsFromListFormat() {
        if (this.listFormat.listId > -1 && this.listFormat.listLevelNumber > -1) {
            const level = this.listFormat.listLevel;
            if (level && level.paragraphFormat) {
                return level.paragraphFormat.tabs;
            }
        }
        return [];
    }
    hasTabStop(position) {
        for (let i = 0; i < this.tabs.length; i++) {
            if (parseFloat(this.tabs[i].position.toFixed(4)) === position ||
                parseFloat(this.tabs[i].deletePosition.toFixed(4)) === position) {
                return true;
            }
        }
        return false;
    }
    get leftIndent() {
        return this.getPropertyValue('leftIndent');
    }
    set leftIndent(value) {
        this.setPropertyValue('leftIndent', value);
    }
    get rightIndent() {
        return this.getPropertyValue('rightIndent');
    }
    set rightIndent(value) {
        this.setPropertyValue('rightIndent', value);
    }
    get firstLineIndent() {
        return this.getPropertyValue('firstLineIndent');
    }
    set firstLineIndent(value) {
        this.setPropertyValue('firstLineIndent', value);
    }
    get beforeSpacing() {
        return this.getPropertyValue('beforeSpacing');
    }
    set beforeSpacing(value) {
        this.setPropertyValue('beforeSpacing', value);
    }
    get afterSpacing() {
        return this.getPropertyValue('afterSpacing');
    }
    set afterSpacing(value) {
        this.setPropertyValue('afterSpacing', value);
    }
    get spaceBeforeAuto() {
        return this.getPropertyValue('spaceBeforeAuto');
    }
    set spaceBeforeAuto(value) {
        this.setPropertyValue('spaceBeforeAuto', value);
    }
    get spaceAfterAuto() {
        return this.getPropertyValue('spaceAfterAuto');
    }
    set spaceAfterAuto(value) {
        this.setPropertyValue('spaceAfterAuto', value);
    }
    get lineSpacing() {
        return this.getPropertyValue('lineSpacing');
    }
    set lineSpacing(value) {
        this.setPropertyValue('lineSpacing', value);
    }
    get lineSpacingType() {
        return this.getPropertyValue('lineSpacingType');
    }
    set lineSpacingType(value) {
        this.setPropertyValue('lineSpacingType', value);
    }
    get textAlignment() {
        return this.getPropertyValue('textAlignment');
    }
    set textAlignment(value) {
        this.setPropertyValue('textAlignment', value);
    }
    get keepWithNext() {
        return this.getPropertyValue('keepWithNext');
    }
    set keepWithNext(value) {
        this.setPropertyValue('keepWithNext', value);
    }
    get keepLinesTogether() {
        return this.getPropertyValue('keepLinesTogether');
    }
    set keepLinesTogether(value) {
        this.setPropertyValue('keepLinesTogether', value);
    }
    get widowControl() {
        return this.getPropertyValue('widowControl');
    }
    set widowControl(value) {
        this.setPropertyValue('widowControl', value);
    }
    get outlineLevel() {
        return this.getPropertyValue('outlineLevel');
    }
    set outlineLevel(value) {
        this.setPropertyValue('outlineLevel', value);
    }
    get bidi() {
        return this.getPropertyValue('bidi');
    }
    set bidi(value) {
        if (this.bidi !== value) {
            if (this.textAlignment === 'Left') {
                this.textAlignment = 'Right';
            }
            else if (this.textAlignment === 'Right') {
                this.textAlignment = 'Left';
            }
        }
        this.setPropertyValue('bidi', value);
    }
    get contextualSpacing() {
        return this.getPropertyValue('contextualSpacing');
    }
    set contextualSpacing(value) {
        this.setPropertyValue('contextualSpacing', value);
    }
    getListFormatParagraphFormat(property) {
        const paragraphFormat = this.getListPargaraphFormat(property);
        if (!isNullOrUndefined(paragraphFormat)) {
            return paragraphFormat.uniqueParagraphFormat.propertiesHash.get(WUniqueFormat.getPropertyType(WParagraphFormat.uniqueFormatType, property));
        }
        return undefined;
    }
    getListPargaraphFormat(property) {
        if (this.listFormat.listId > -1 && this.listFormat.listLevelNumber > -1) {
            const level = this.listFormat.listLevel;
            const propertyType = WUniqueFormat.getPropertyType(WParagraphFormat.uniqueFormatType, property);
            if (!isNullOrUndefined(level) && !isNullOrUndefined(level.paragraphFormat.uniqueParagraphFormat) &&
                level.paragraphFormat.uniqueParagraphFormat.propertiesHash.containsKey(propertyType)) {
                return level.paragraphFormat;
            }
            else {
                return undefined;
            }
        }
        return undefined;
    }
    getPropertyValue(property) {
        if (!this.hasValue(property)) {
            const formatInList = this.getListFormatParagraphFormat(property);
            if (this.baseStyle instanceof WParagraphStyle) {
                let currentFormat = this;
                let baseStyle = this.baseStyle;
                while (!isNullOrUndefined(baseStyle)) {
                    let listParaFormat;
                    if (!this.listFormat.hasValue('listId')) {
                        listParaFormat = baseStyle.paragraphFormat.getListPargaraphFormat(property);
                    }
                    if (baseStyle.paragraphFormat.hasValue(property)) {
                        currentFormat = baseStyle.paragraphFormat;
                        break;
                    }
                    else if (!isNullOrUndefined(listParaFormat) && listParaFormat.hasValue(property)) {
                        currentFormat = listParaFormat;
                        break;
                    }
                    else {
                        baseStyle = baseStyle.basedOn;
                    }
                }
                if (!isNullOrUndefined(baseStyle)) {
                    if (!isNullOrUndefined(formatInList) && this.listFormat.listId !== -1
                        && currentFormat.listFormat.listId === -1
                        || !isNullOrUndefined(formatInList) && this.listFormat.listId !== currentFormat.listFormat.listId) {
                        return formatInList;
                    }
                    const propertyType = WUniqueFormat.getPropertyType(WParagraphFormat.uniqueFormatType, property);
                    return currentFormat.uniqueParagraphFormat.propertiesHash.get(propertyType);
                }
            }
            if (!isNullOrUndefined(formatInList)) {
                return formatInList;
            }
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(WParagraphFormat.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueParagraphFormat) && this.uniqueParagraphFormat.propertiesHash.containsKey(propertyType)) {
                return this.uniqueParagraphFormat.propertiesHash.get(propertyType);
            }
        }
        return this.getDefaultValue(property);
    }
    getDefaultValue(property) {
        const propertyType = WUniqueFormat.getPropertyType(WParagraphFormat.uniqueFormatType, property);
        const docParagraphFormat = this.documentParagraphFormat();
        let isInsideBodyWidget = true;
        if (this.ownerBase && this.ownerBase instanceof ParagraphWidget) {
            isInsideBodyWidget = this.ownerBase.containerWidget instanceof BodyWidget ||
                this.ownerBase.containerWidget instanceof TableCellWidget;
        }
        let isPaste = !isNullOrUndefined(this.ownerBase) && !isNullOrUndefined(this.ownerBase.bodyWidget)
            && this.ownerBase.bodyWidget.page && this.ownerBase.bodyWidget.page.documentHelper.owner.editor
            && this.ownerBase.bodyWidget.page.documentHelper.owner.editor.isPaste;
        if (isInsideBodyWidget && !isPaste
            && !isNullOrUndefined(docParagraphFormat) && !isNullOrUndefined(docParagraphFormat.uniqueParagraphFormat)) {
            const propValue = docParagraphFormat.uniqueParagraphFormat.propertiesHash.get(propertyType);
            if (!isNullOrUndefined(propValue)) {
                return propValue;
            }
        }
        return WParagraphFormat.getPropertyDefaultValue(property);
    }
    documentParagraphFormat() {
        let docParagraphFormat;
        if (!isNullOrUndefined(this.ownerBase)) {
            const bodyWidget = this.ownerBase.bodyWidget;
            if (!isNullOrUndefined(bodyWidget) && !isNullOrUndefined(bodyWidget.page)) {
                docParagraphFormat = bodyWidget.page.documentHelper.paragraphFormat;
            }
        }
        return docParagraphFormat;
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WParagraphFormat.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueParagraphFormat)) {
            this.initializeUniqueParagraphFormat(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueParagraphFormat.uniqueFormatType, property);
            if (this.uniqueParagraphFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueParagraphFormat.propertiesHash.get(propertyType) === value) {
                //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueParagraphFormat = WParagraphFormat.uniqueParagraphFormats.updateUniqueFormat(this.uniqueParagraphFormat, property, value);
        }
    }
    initializeUniqueParagraphFormat(property, propValue) {
        const uniqueParaFormatTemp = new Dictionary();
        this.addUniqueParaFormat('leftIndent', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('rightIndent', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('firstLineIndent', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('textAlignment', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('beforeSpacing', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('afterSpacing', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('spaceBeforeAuto', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('spaceAfterAuto', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('lineSpacing', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('lineSpacingType', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('outlineLevel', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('bidi', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('contextualSpacing', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('keepWithNext', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('keepLinesTogether', property, propValue, uniqueParaFormatTemp);
        this.addUniqueParaFormat('widowControl', property, propValue, uniqueParaFormatTemp);
        this.uniqueParagraphFormat = WParagraphFormat.uniqueParagraphFormats.addUniqueFormat(uniqueParaFormatTemp, WParagraphFormat.uniqueFormatType);
    }
    addUniqueParaFormat(property, modifiedProperty, propValue, uniqueParaFormatTemp) {
        let propertyType = WUniqueFormat.getPropertyType(WParagraphFormat.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueParaFormatTemp.add(propertyType, propValue);
        }
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        switch (property) {
            case 'leftIndent':
                value = 0;
                break;
            case 'rightIndent':
                value = 0;
                break;
            case 'firstLineIndent':
                value = 0;
                break;
            case 'textAlignment':
                value = 'Left';
                break;
            case 'beforeSpacing':
                value = 0;
                break;
            case 'afterSpacing':
                value = 0;
                break;
            case 'spaceBeforeAuto':
                value = false;
                break;
            case 'spaceAfterAuto':
                value = false;
                break;
            case 'lineSpacing':
                value = 1;
                break;
            case 'lineSpacingType':
                value = 'Multiple';
                break;
            case 'styleName':
                value = 'Normal';
                break;
            case 'outlineLevel':
                value = 'BodyText';
                break;
            case 'bidi':
                value = false;
                break;
            case 'contextualSpacing':
                value = false;
                break;
            case 'keepWithNext':
                value = false;
                break;
            case 'keepLinesTogether':
                value = false;
                break;
            case 'widowControl':
                value = true;
                break;
        }
        return value;
    }
    clearFormat() {
        if (!isNullOrUndefined(this.listFormat)) {
            this.listFormat.clearFormat();
        }
        if (!isNullOrUndefined(this.uniqueParagraphFormat) && this.uniqueParagraphFormat.referenceCount === 0) {
            WParagraphFormat.uniqueParagraphFormats.remove(this.uniqueParagraphFormat);
        }
        this.uniqueParagraphFormat = undefined;
        this.baseStyle = undefined;
    }
    destroy() {
        this.clearFormat();
        if (!isNullOrUndefined(this.listFormat)) {
            this.listFormat.destroy();
        }
        this.listFormat = undefined;
        if (this.tabs !== undefined) {
            for (let i = 0; i < this.tabs.length; i++) {
                this.tabs[i].destroy();
            }
            this.tabs = undefined;
        }
    }
    copyFormat(format) {
        if (!isNullOrUndefined(format)) {
            if (!isNullOrUndefined(format.uniqueParagraphFormat)) {
                this.updateUniqueParagraphFormat(format);
            }
            if (!isNullOrUndefined(format.listFormat)) {
                this.listFormat.copyFormat(format.listFormat);
            }
            if (!isNullOrUndefined(format.baseStyle)) {
                this.baseStyle = format.baseStyle;
            }
            if (!isNullOrUndefined(format.tabs)) {
                for (let i = 0; i < format.tabs.length; i++) {
                    this.tabs[i] = format.tabs[i];
                }
            }
        }
    }
    updateUniqueParagraphFormat(format) {
        let hash = undefined;
        if (this.uniqueParagraphFormat) {
            hash = this.uniqueParagraphFormat.mergeProperties(format.uniqueParagraphFormat);
            if (this.uniqueParagraphFormat.referenceCount === 0) {
                WParagraphFormat.uniqueParagraphFormats.remove(this.uniqueParagraphFormat);
                this.uniqueParagraphFormat = undefined;
            }
        }
        this.uniqueParagraphFormat = new WUniqueFormat(WParagraphFormat.uniqueFormatType);
        if (isNullOrUndefined(hash)) {
            hash = this.uniqueParagraphFormat.mergeProperties(format.uniqueParagraphFormat);
        }
        this.uniqueParagraphFormat = WParagraphFormat.uniqueParagraphFormats.addUniqueFormat(hash, WParagraphFormat.uniqueFormatType);
    }
    cloneFormat() {
        const format = new WParagraphFormat(undefined);
        format.uniqueParagraphFormat = this.uniqueParagraphFormat;
        format.baseStyle = this.baseStyle;
        if (isNullOrUndefined(this.listFormat)) {
            format.listFormat = undefined;
        }
        else {
            format.listFormat = this.listFormat.cloneListFormat();
        }
        return format;
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueParagraphFormat) && !isNullOrUndefined(this.uniqueParagraphFormat.propertiesHash)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueParagraphFormat.uniqueFormatType, property);
            return this.uniqueParagraphFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    static clear() {
        this.uniqueParagraphFormats.clear();
    }
    applyStyle(baseStyle) {
        this.baseStyle = baseStyle;
        this.listFormat.applyStyle(this.baseStyle);
    }
    getValue(property) {
        return this.hasValue(property) ? this.getPropertyValue(property) : undefined;
    }
    mergeFormat(format, isStyle) {
        isStyle = isNullOrUndefined(isStyle) ? false : isStyle;
        if (isNullOrUndefined(this.getValue('leftIndent'))) {
            this.leftIndent = format.getValue('leftIndent');
        }
        if (isNullOrUndefined(this.getValue('rightIndent'))) {
            this.rightIndent = format.getValue('rightIndent');
        }
        if (isNullOrUndefined(this.getValue('firstLineIndent'))) {
            this.firstLineIndent = format.getValue('firstLineIndent');
        }
        if (isNullOrUndefined(this.getValue('beforeSpacing'))) {
            this.beforeSpacing = format.getValue('beforeSpacing');
        }
        if (isNullOrUndefined(this.getValue('afterSpacing'))) {
            this.afterSpacing = format.getValue('afterSpacing');
        }
        if (isNullOrUndefined(this.getValue('spaceBeforeAuto'))) {
            this.spaceBeforeAuto = format.getValue('spaceBeforeAuto');
        }
        if (isNullOrUndefined(this.getValue('spaceAfterAuto'))) {
            this.spaceAfterAuto = format.getValue('spaceAfterAuto');
        }
        if (isNullOrUndefined(this.getValue('lineSpacing'))) {
            this.lineSpacing = format.getValue('lineSpacing');
        }
        if (isNullOrUndefined(this.getValue('lineSpacingType'))) {
            this.lineSpacingType = format.getValue('lineSpacingType');
        }
        if (isNullOrUndefined(this.getValue('textAlignment'))) {
            this.textAlignment = format.getValue('textAlignment');
        }
        if (isNullOrUndefined(this.getValue('outlineLevel'))) {
            this.outlineLevel = format.getValue('outlineLevel');
        }
        if (!isStyle && isNullOrUndefined(this.getValue('bidi'))) {
            this.bidi = format.getValue('bidi');
        }
        if (isNullOrUndefined(this.getValue('contextualSpacing'))) {
            this.contextualSpacing = format.getValue('contextualSpacing');
        }
        if (isNullOrUndefined(this.getValue('keepWithNext'))) {
            this.keepWithNext = format.getValue('keepWithNext');
        }
        if (isNullOrUndefined(this.getValue('keepLinesTogether'))) {
            this.keepLinesTogether = format.getValue('keepLinesTogether');
        }
        if (isNullOrUndefined(this.getValue('widowControl'))) {
            this.widowControl = format.getValue('widowControl');
        }
        if (isNullOrUndefined(this.listFormat)) {
            this.listFormat.mergeFormat(format.listFormat);
        }
    }
}
WParagraphFormat.uniqueParagraphFormats = new WUniqueFormats();
WParagraphFormat.uniqueFormatType = 3;

/**
 * @private
 */
class WBorder {
    constructor(node) {
        this.uniqueBorderFormat = undefined;
        this.ownerBase = undefined;
        this.ownerBase = node;
    }
    get color() {
        return this.getPropertyValue('color');
    }
    set color(value) {
        this.setPropertyValue('color', value);
    }
    get lineStyle() {
        return this.getPropertyValue('lineStyle');
    }
    set lineStyle(value) {
        this.setPropertyValue('lineStyle', value);
    }
    get lineWidth() {
        return this.getPropertyValue('lineWidth');
    }
    set lineWidth(value) {
        this.setPropertyValue('lineWidth', value);
    }
    get shadow() {
        return this.getPropertyValue('shadow');
    }
    set shadow(value) {
        this.setPropertyValue('shadow', value);
    }
    get space() {
        return this.getPropertyValue('space');
    }
    set space(value) {
        this.setPropertyValue('space', value);
    }
    get hasNoneStyle() {
        return this.getPropertyValue('hasNoneStyle');
    }
    set hasNoneStyle(value) {
        this.setPropertyValue('hasNoneStyle', value);
    }
    get isBorderDefined() {
        return (this.lineStyle !== 'None' ||
            (this.hasNoneStyle && this.hasValue('hasNoneStyle')));
    }
    /* eslint-disable */
    getPropertyValue(property) {
        const hasValue = this.hasValue(property);
        if (hasValue) {
            const propertyType = WUniqueFormat.getPropertyType(WBorder.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueBorderFormat)) {
                const propValue = this.uniqueBorderFormat.propertiesHash.get(propertyType);
                if (!isNullOrUndefined(propValue)) {
                    return propValue;
                }
            }
        }
        return WBorder.getPropertyDefaultValue(property);
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WBorder.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueBorderFormat)) {
            this.initializeUniqueBorder(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueBorderFormat.uniqueFormatType, property);
            if (this.uniqueBorderFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueBorderFormat.propertiesHash.get(propertyType) === value) {
                //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueBorderFormat = WBorder.uniqueBorderFormats.updateUniqueFormat(this.uniqueBorderFormat, property, value);
        }
    }
    initializeUniqueBorder(property, propValue) {
        const uniqueBorderFormatTemp = new Dictionary();
        this.addUniqueBorderFormat('color', property, propValue, uniqueBorderFormatTemp);
        this.addUniqueBorderFormat('lineStyle', property, propValue, uniqueBorderFormatTemp);
        this.addUniqueBorderFormat('lineWidth', property, propValue, uniqueBorderFormatTemp);
        this.addUniqueBorderFormat('shadow', property, propValue, uniqueBorderFormatTemp);
        this.addUniqueBorderFormat('space', property, propValue, uniqueBorderFormatTemp);
        this.addUniqueBorderFormat('hasNoneStyle', property, propValue, uniqueBorderFormatTemp);
        this.uniqueBorderFormat = WBorder.uniqueBorderFormats.addUniqueFormat(uniqueBorderFormatTemp, WBorder.uniqueFormatType);
    }
    addUniqueBorderFormat(property, modifiedProperty, propValue, uniqueBorderFormatTemp) {
        const propertyType = WUniqueFormat.getPropertyType(WBorder.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueBorderFormatTemp.add(propertyType, propValue);
        }
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        /* eslint-enable */
        switch (property) {
            case 'color':
                value = '#000000';
                break;
            case 'lineStyle':
                value = 'None';
                break;
            case 'lineWidth':
                value = 0;
                break;
            case 'shadow':
                value = false;
                break;
            case 'space':
                value = 0;
                break;
            case 'hasNoneStyle':
                value = false;
                break;
        }
        return value;
    }
    getLineWidth() {
        /* eslint-disable */
        switch (this.lineStyle) {
            case 'None':
            case 'Cleared':
                return 0;
            case 'Triple':
            case 'Double':
            case 'ThinThickSmallGap':
            case 'ThickThinSmallGap':
            case 'ThinThickThinSmallGap':
            case 'ThinThickMediumGap':
            case 'ThickThinMediumGap':
            case 'ThinThickThinMediumGap':
            case 'ThinThickLargeGap':
            case 'ThickThinLargeGap':
            case 'ThinThickThinLargeGap':
            case 'Emboss3D':
            case 'Engrave3D':
                {
                    let lineArray = this.getBorderLineWidthArray(this.lineStyle, this.lineWidth);
                    let width = 0;
                    for (let i = 0; i < lineArray.length; i++) {
                        width += lineArray[i];
                    }
                    return width;
                }
            case 'Single':
            case 'DashLargeGap':
            case 'DashSmallGap':
            case 'Dot':
            case 'DashDot':
            case 'DashDotDot':
            case 'Thick':
                return this.lineWidth;
            case 'SingleWavy':
                return (this.lineWidth === 1.5 ? 3 : 2.5); //Double wave border only draw with the fixed width
            case 'DoubleWavy':
                return (6.75); //Double wave border only draw with the fixed width
            case 'DashDotStroked':
            case 'Outset':
                return this.lineWidth;
        }
        return this.lineWidth;
        /* eslint-enable */
    }
    getBorderLineWidthArray(lineStyle, lineWidth) {
        let borderLineArray = [lineWidth];
        switch (lineStyle) {
            case 'Double':
                borderLineArray = [1, 1, 1];
                break;
            case 'ThinThickSmallGap':
                borderLineArray = [1, -0.75, -0.75];
                break;
            case 'ThickThinSmallGap':
                borderLineArray = [-0.75, -0.75, 1];
                break;
            case 'ThinThickMediumGap':
                borderLineArray = [1, 0.5, 0.5];
                break;
            case 'ThickThinMediumGap':
                borderLineArray = [0.5, 0.5, 1];
                break;
            case 'ThinThickLargeGap':
                borderLineArray = [-1.5, 1, -0.75];
                break;
            case 'ThickThinLargeGap':
                borderLineArray = [-0.75, 1, -1.5];
                break;
            case 'Triple':
                borderLineArray = [1, 1, 1, 1, 1];
                break;
            case 'ThinThickThinSmallGap':
                borderLineArray = [-0.75, -0.75, 1, -0.75, -0.75];
                break;
            case 'ThinThickThinMediumGap':
                borderLineArray = [0.5, 0.5, 1, 0.5, 0.5];
                break;
            case 'ThinThickThinLargeGap':
                borderLineArray = [-0.75, 1, -1.5, 1, -0.75];
                break;
            case 'Emboss3D':
            case 'Engrave3D':
                borderLineArray = [0.25, 0, 1, 0, 0.25];
                break;
        }
        if (borderLineArray.length === 1) {
            return [lineWidth];
        }
        for (let i = 0; i < borderLineArray.length; i++) {
            if (borderLineArray[i] >= 0) {
                borderLineArray[i] = borderLineArray[i] * lineWidth;
            }
            else {
                borderLineArray[i] = Math.abs(borderLineArray[i]);
            }
        }
        return borderLineArray;
    }
    getBorderWeight() {
        let weight = 0;
        const numberOfLines = this.getNumberOfLines();
        const borderNumber = this.getBorderNumber();
        switch (this.lineStyle) {
            case 'Single':
            case 'DashSmallGap':
            case 'DashDot':
            case 'DashDotDot':
            case 'Double':
            case 'Triple':
            case 'ThinThickSmallGap':
            case 'ThickThinSmallGap':
            case 'ThinThickThinSmallGap':
            case 'ThinThickMediumGap':
            case 'ThickThinMediumGap':
            case 'ThinThickThinMediumGap':
            case 'ThinThickLargeGap':
            case 'ThickThinLargeGap':
            case 'ThinThickThinLargeGap':
            case 'SingleWavy':
            case 'DoubleWavy':
            case 'DashDotStroked':
            case 'Emboss3D':
            case 'Engrave3D':
            case 'Outset':
            case 'Inset':
            case 'Thick':
                weight = numberOfLines * borderNumber;
                break;
            case 'Dot':
            case 'DashLargeGap':
                weight = 1;
                break;
        }
        return weight;
    }
    getBorderNumber() {
        let borderNumber = 0;
        switch (this.lineStyle) {
            case 'Single':
                borderNumber = 1;
                break;
            case 'Thick':
                borderNumber = 2;
                break;
            case 'Double':
                borderNumber = 3;
                break;
            case 'Dot':
                borderNumber = 4;
                break;
            case 'DashLargeGap': //dashed.
                borderNumber = 5;
                break;
            case 'DashDot':
                borderNumber = 6;
                break;
            case 'DashDotDot':
                borderNumber = 7;
                break;
            case 'Triple':
                borderNumber = 8;
                break;
            case 'ThinThickSmallGap':
                borderNumber = 9;
                break;
            case 'ThickThinSmallGap':
                borderNumber = 10;
                break;
            case 'ThinThickThinSmallGap':
                borderNumber = 11;
                break;
            case 'ThinThickMediumGap':
                borderNumber = 12;
                break;
            case 'ThickThinMediumGap':
                borderNumber = 13;
                break;
            case 'ThinThickThinMediumGap':
                borderNumber = 14;
                break;
            case 'ThinThickLargeGap':
                borderNumber = 15;
                break;
            case 'ThickThinLargeGap':
                borderNumber = 16;
                break;
            case 'ThinThickThinLargeGap':
                borderNumber = 17;
                break;
            case 'SingleWavy': //wave.
                borderNumber = 18;
                break;
            case 'DoubleWavy':
                borderNumber = 19;
                break;
            case 'DashSmallGap':
                borderNumber = 20;
                break;
            case 'DashDotStroked':
                borderNumber = 21;
                break;
            case 'Emboss3D':
                borderNumber = 22;
                break;
            case 'Engrave3D':
                borderNumber = 23;
                break;
            case 'Outset':
                borderNumber = 24;
                break;
            case 'Inset':
                borderNumber = 25;
                break;
        }
        return borderNumber;
    }
    getNumberOfLines() {
        //ToDo: Need to analyze more on this.
        let value = 0;
        switch (this.lineStyle) {
            case 'Single':
            case 'Dot':
            case 'DashSmallGap':
            case 'DashLargeGap':
            case 'DashDot':
            case 'DashDotDot':
                value = 1;
                break;
            case 'Double':
                value = 3;
                break;
            case 'Triple':
                value = 5;
                break;
            case 'ThinThickSmallGap':
                value = 3;
                break;
            case 'ThickThinSmallGap':
                value = 3;
                break;
            case 'ThinThickThinSmallGap':
                value = 5;
                break;
            case 'ThinThickMediumGap':
                value = 3;
                break;
            case 'ThickThinMediumGap':
                value = 3;
                break;
            case 'ThinThickThinMediumGap':
                value = 5;
                break;
            case 'ThinThickLargeGap':
                value = 3;
                break;
            case 'ThickThinLargeGap':
                value = 3;
                break;
            case 'ThinThickThinLargeGap':
                value = 5;
                break;
            case 'SingleWavy':
                value = 1;
                break;
            case 'DoubleWavy':
                value = 2;
                break;
            case 'DashDotStroked':
                value = 1;
                break;
            case 'Emboss3D':
            case 'Engrave3D':
                value = 3;
                break;
            case 'Outset':
            case 'Inset':
            case 'Thick':
                value = 1;
                break;
        }
        return value;
    }
    getPrecedence() {
        let value = 0;
        switch (this.lineStyle) {
            case 'Single':
                value = 1;
                break;
            case 'Thick':
                value = 2;
                break;
            case 'Double':
                value = 3;
                break;
            case 'Dot':
                value = 4;
                break;
            case 'DashLargeGap': //dashed.
                value = 5;
                break;
            case 'DashDot':
                value = 6;
                break;
            case 'DashDotDot':
                value = 7;
                break;
            case 'Triple':
                value = 8;
                break;
            case 'ThinThickSmallGap':
                value = 9;
                break;
            case 'ThickThinSmallGap':
                value = 10;
                break;
            case 'ThinThickThinSmallGap':
                value = 11;
                break;
            case 'ThinThickMediumGap':
                value = 12;
                break;
            case 'ThickThinMediumGap':
                value = 13;
                break;
            case 'ThinThickThinMediumGap':
                value = 14;
                break;
            case 'ThinThickLargeGap':
                value = 15;
                break;
            case 'ThickThinLargeGap':
                value = 16;
                break;
            case 'ThinThickThinLargeGap':
                value = 17;
                break;
            case 'SingleWavy': //wave.
                value = 18;
                break;
            case 'DoubleWavy':
                value = 19;
                break;
            case 'DashSmallGap':
                value = 20;
                break;
            case 'DashDotStroked':
                value = 21;
                break;
            case 'Emboss3D':
                value = 22;
                break;
            case 'Engrave3D':
                value = 23;
                break;
            case 'Outset':
                value = 24;
                break;
            case 'Inset':
                value = 25;
                break;
        }
        return value;
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueBorderFormat)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueBorderFormat.uniqueFormatType, property);
            return this.uniqueBorderFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    cloneFormat() {
        const border = new WBorder(undefined);
        border.color = this.color;
        border.lineStyle = this.lineStyle;
        border.lineWidth = this.lineWidth;
        border.shadow = this.shadow;
        border.space = this.space;
        return border;
    }
    destroy() {
        if (!isNullOrUndefined(this.uniqueBorderFormat)) {
            WBorder.uniqueBorderFormats.remove(this.uniqueBorderFormat);
        }
        this.uniqueBorderFormat = undefined;
    }
    copyFormat(border) {
        if (!isNullOrUndefined(border) && !isNullOrUndefined(border.uniqueBorderFormat)) {
            if (border.hasValue('color')) {
                this.color = border.color;
            }
            if (border.hasValue('lineStyle')) {
                this.lineStyle = border.lineStyle;
            }
            if (border.hasValue('lineWidth')) {
                this.lineWidth = border.lineWidth;
            }
            if (border.hasValue('shadow')) {
                this.shadow = border.shadow;
            }
            if (border.hasValue('space')) {
                this.space = border.space;
            }
            if (border.hasValue('hasNoneStyle')) {
                this.hasNoneStyle = border.hasNoneStyle;
            }
        }
    }
    static clear() {
        this.uniqueBorderFormats.clear();
    }
}
WBorder.uniqueBorderFormats = new WUniqueFormats();
WBorder.uniqueFormatType = 1;

/**
 * @private
 */
class WBorders {
    constructor(node) {
        this.leftIn = new WBorder(this);
        this.rightIn = new WBorder(this);
        this.topIn = new WBorder(this);
        this.bottomIn = new WBorder(this);
        this.horizontalIn = new WBorder(this);
        this.verticalIn = new WBorder(this);
        this.diagonalUpIn = new WBorder(this);
        this.diagonalDownIn = new WBorder(this);
        this.lineWidthIn = 0;
        this.ownerBase = node;
    }
    get left() {
        return this.leftIn;
    }
    set left(value) {
        this.leftIn = value;
    }
    get right() {
        return this.rightIn;
    }
    set right(value) {
        this.rightIn = value;
    }
    get top() {
        return this.topIn;
    }
    set top(value) {
        this.topIn = value;
    }
    get bottom() {
        return this.bottomIn;
    }
    set bottom(value) {
        this.bottomIn = value;
    }
    get horizontal() {
        return this.horizontalIn;
    }
    set horizontal(value) {
        this.horizontalIn = value;
    }
    get vertical() {
        return this.verticalIn;
    }
    set vertical(value) {
        this.verticalIn = value;
    }
    get diagonalUp() {
        return this.diagonalUpIn;
    }
    set diagonalUp(value) {
        this.diagonalUpIn = value;
    }
    get diagonalDown() {
        return this.diagonalDownIn;
    }
    set diagonalDown(value) {
        this.diagonalDownIn = value;
    }
    /* eslint-enable */
    destroy() {
        if (!isNullOrUndefined(this.left)) {
            this.left.destroy();
        }
        if (!isNullOrUndefined(this.top)) {
            this.top.destroy();
        }
        if (!isNullOrUndefined(this.bottom)) {
            this.bottom.destroy();
        }
        if (!isNullOrUndefined(this.right)) {
            this.right.destroy();
        }
        if (!isNullOrUndefined(this.horizontal)) {
            this.horizontal.destroy();
        }
        if (!isNullOrUndefined(this.vertical)) {
            this.vertical.destroy();
        }
        if (!isNullOrUndefined(this.diagonalDown)) {
            this.diagonalDown.destroy();
        }
        if (!isNullOrUndefined(this.diagonalUp)) {
            this.diagonalUp.destroy();
        }
        this.topIn = undefined;
        this.bottomIn = undefined;
        this.leftIn = undefined;
        this.rightIn = undefined;
        this.horizontalIn = undefined;
        this.verticalIn = undefined;
        this.diagonalDownIn = undefined;
        this.diagonalUpIn = undefined;
        this.lineWidthIn = undefined;
        this.valueIn = undefined;
    }
    cloneFormat() {
        const borders = new WBorders(undefined);
        borders.top = isNullOrUndefined(this.top) ? undefined : this.top.cloneFormat();
        borders.bottom = isNullOrUndefined(this.bottom) ? undefined : this.bottom.cloneFormat();
        borders.left = isNullOrUndefined(this.left) ? undefined : this.left.cloneFormat();
        borders.right = isNullOrUndefined(this.right) ? undefined : this.right.cloneFormat();
        borders.horizontal = isNullOrUndefined(this.horizontal) ? undefined : this.horizontal.cloneFormat();
        borders.vertical = isNullOrUndefined(this.vertical) ? undefined : this.vertical.cloneFormat();
        borders.diagonalUp = isNullOrUndefined(this.diagonalUp) ? undefined : this.diagonalUp.cloneFormat();
        borders.diagonalDown = isNullOrUndefined(this.diagonalDown) ? undefined : this.diagonalDown.cloneFormat();
        return borders;
    }
    copyFormat(borders) {
        if (!isNullOrUndefined(borders.left) && borders.left instanceof WBorder) {
            this.left = new WBorder(this);
            this.left.copyFormat(borders.left);
        }
        if (!isNullOrUndefined(borders.right) && borders.right instanceof WBorder) {
            this.right = new WBorder(this);
            this.right.copyFormat(borders.right);
        }
        if (!isNullOrUndefined(borders.top) && borders.top instanceof WBorder) {
            this.top = new WBorder(this);
            this.top.copyFormat(borders.top);
        }
        if (!isNullOrUndefined(borders.bottom) && borders.bottom instanceof WBorder) {
            this.bottom = new WBorder(this);
            this.bottom.copyFormat(borders.bottom);
        }
        if (!isNullOrUndefined(borders.horizontal) && borders.horizontal instanceof WBorder) {
            this.horizontal = new WBorder(this);
            this.horizontal.copyFormat(borders.horizontal);
        }
        if (!isNullOrUndefined(borders.vertical) && borders.vertical instanceof WBorder) {
            this.vertical = new WBorder(this);
            this.vertical.copyFormat(borders.vertical);
        }
        if (!isNullOrUndefined(borders.diagonalDown) && borders.diagonalDown instanceof WBorder) {
            this.diagonalDown = new WBorder(this);
            this.diagonalDown.copyFormat(borders.diagonalDown);
        }
        if (!isNullOrUndefined(borders.diagonalUp) && borders.diagonalUp instanceof WBorder) {
            this.diagonalUp = new WBorder(this);
            this.diagonalUp.copyFormat(borders.diagonalUp);
        }
    }
}

/* eslint-disable */
/**
 * @private
 */
class WRowFormat {
    constructor(node) {
        this.uniqueRowFormat = undefined;
        /**
         * @private
         */
        this.borders = new WBorders(this);
        /**
         * @private
         */
        this.ownerBase = undefined;
        /**
         * @private
         */
        this.beforeWidth = 0;
        /**
         * @private
         */
        this.afterWidth = 0;
        /**
         * @private
         */
        this.revisions = [];
        /**
         * @private
         */
        this.removedIds = [];
        this.ownerBase = node;
    }
    get gridBefore() {
        return this.getPropertyValue('gridBefore');
    }
    set gridBefore(value) {
        this.setPropertyValue('gridBefore', value);
    }
    get gridBeforeWidth() {
        return this.getPropertyValue('gridBeforeWidth');
    }
    set gridBeforeWidth(value) {
        this.setPropertyValue('gridBeforeWidth', value);
    }
    get gridBeforeWidthType() {
        return this.getPropertyValue('gridBeforeWidthType');
    }
    set gridBeforeWidthType(value) {
        this.setPropertyValue('gridBeforeWidthType', value);
    }
    get gridAfter() {
        return this.getPropertyValue('gridAfter');
    }
    set gridAfter(value) {
        this.setPropertyValue('gridAfter', value);
    }
    get gridAfterWidth() {
        return this.getPropertyValue('gridAfterWidth');
    }
    set gridAfterWidth(value) {
        this.setPropertyValue('gridAfterWidth', value);
    }
    get gridAfterWidthType() {
        return this.getPropertyValue('gridAfterWidthType');
    }
    set gridAfterWidthType(value) {
        this.setPropertyValue('gridAfterWidthType', value);
    }
    get allowBreakAcrossPages() {
        return this.getPropertyValue('allowBreakAcrossPages');
    }
    set allowBreakAcrossPages(value) {
        this.setPropertyValue('allowBreakAcrossPages', value);
    }
    get isHeader() {
        return this.getPropertyValue('isHeader');
    }
    set isHeader(value) {
        this.setPropertyValue('isHeader', value);
    }
    get rightMargin() {
        return this.getPropertyValue('rightMargin');
    }
    set rightMargin(value) {
        this.setPropertyValue('rightMargin', value);
    }
    get height() {
        return this.getPropertyValue('height');
    }
    set height(value) {
        if (value === 0 && (this.heightType === 'AtLeast' || this.heightType === 'Exactly')) {
            value = 1;
        }
        else if (this.heightType === 'Auto') {
            value = 0;
        }
        this.setPropertyValue('height', value);
    }
    get heightType() {
        return this.getPropertyValue('heightType');
    }
    set heightType(value) {
        if (value === 'AtLeast' || value === 'Exactly') {
            this.height = 1;
        }
        else {
            this.height = 0;
        }
        this.setPropertyValue('heightType', value);
    }
    get bottomMargin() {
        return this.getPropertyValue('bottomMargin');
    }
    set bottomMargin(value) {
        this.setPropertyValue('bottomMargin', value);
    }
    get leftIndent() {
        return this.getPropertyValue('leftIndent');
    }
    set leftIndent(value) {
        this.setPropertyValue('leftIndent', value);
    }
    get topMargin() {
        return this.getPropertyValue('topMargin');
    }
    set topMargin(value) {
        this.setPropertyValue('topMargin', value);
    }
    get leftMargin() {
        return this.getPropertyValue('leftMargin');
    }
    set leftMargin(value) {
        this.setPropertyValue('leftMargin', value);
    }
    getPropertyValue(property) {
        const hasValue = this.hasValue(property);
        if (hasValue) {
            const propertyType = WUniqueFormat.getPropertyType(WRowFormat.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueRowFormat) && this.uniqueRowFormat.propertiesHash.containsKey(propertyType)) {
                return this.uniqueRowFormat.propertiesHash.get(propertyType);
            }
        }
        return WRowFormat.getPropertyDefaultValue(property);
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WRowFormat.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueRowFormat)) {
            this.initializeUniqueRowFormat(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueRowFormat.uniqueFormatType, property);
            if (this.uniqueRowFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueRowFormat.propertiesHash.get(propertyType) === value) {
                //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueRowFormat = WRowFormat.uniqueRowFormats.updateUniqueFormat(this.uniqueRowFormat, property, value);
        }
    }
    initializeUniqueRowFormat(property, propValue) {
        const uniqueRowFormatTemp = new Dictionary();
        this.addUniqueRowFormat('allowBreakAcrossPages', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('isHeader', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('height', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('heightType', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('gridBefore', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('gridBeforeWidth', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('gridBeforeWidthType', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('gridAfter', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('gridAfterWidth', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('gridgridAfterWidth', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('gridBeforeWidthType', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('leftMargin', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('rightMargin', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('topMargin', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('bottomMargin', property, propValue, uniqueRowFormatTemp);
        this.addUniqueRowFormat('leftIndent', property, propValue, uniqueRowFormatTemp);
        this.uniqueRowFormat = WRowFormat.uniqueRowFormats.addUniqueFormat(uniqueRowFormatTemp, WRowFormat.uniqueFormatType);
    }
    addUniqueRowFormat(property, modifiedProperty, propValue, uniqueRowFormatTemp) {
        const propertyType = WUniqueFormat.getPropertyType(WRowFormat.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueRowFormatTemp.add(propertyType, propValue);
        }
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        switch (property) {
            case 'allowBreakAcrossPages':
                value = true;
                break;
            case 'isHeader':
                value = false;
                break;
            case 'height':
                value = 0;
                break;
            case 'heightType':
                value = 'Auto';
                break;
            case 'gridBefore':
                value = 0;
                break;
            case 'gridBeforeWidth':
                value = 0;
                break;
            case 'gridBeforeWidthType':
                value = 'Point';
                break;
            case 'gridAfter':
                value = 0;
                break;
            case 'gridAfterWidth':
                value = 0;
                break;
            case 'gridAfterWidthType':
                value = 'Point';
                break;
            case 'leftMargin':
                value = undefined;
                break;
            case 'topMargin':
                value = undefined;
                break;
            case 'bottomMargin':
                value = undefined;
                break;
            case 'rightMargin':
                value = undefined;
                break;
            case 'leftIndent':
                value = 0;
                break;
        }
        return value;
    }
    containsMargins() {
        return (!isNullOrUndefined(this.leftMargin)
            || !isNullOrUndefined(this.rightMargin)
            || !isNullOrUndefined(this.bottomMargin)
            || !isNullOrUndefined(this.topMargin));
    }
    cloneFormat() {
        const format = new WRowFormat();
        format.allowBreakAcrossPages = this.allowBreakAcrossPages;
        format.heightType = this.heightType;
        format.height = this.height;
        format.isHeader = this.isHeader;
        format.gridBefore = this.gridBefore;
        format.gridBeforeWidth = this.gridBeforeWidth;
        format.gridBeforeWidthType = this.gridBeforeWidthType;
        format.gridAfter = this.gridAfter;
        format.gridAfterWidth = this.gridAfterWidth;
        format.gridAfterWidthType = this.gridAfterWidthType;
        format.leftMargin = this.leftMargin;
        format.rightMargin = this.rightMargin;
        format.topMargin = this.topMargin;
        format.bottomMargin = this.bottomMargin;
        format.leftIndent = this.leftIndent;
        if (this.revisions.length > 0) {
            format.removedIds = Revision.cloneRevisions(this.revisions);
        }
        else {
            format.removedIds = this.removedIds.slice();
        }
        return format;
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueRowFormat)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueRowFormat.uniqueFormatType, property);
            return this.uniqueRowFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    copyFormat(format) {
        if (!isNullOrUndefined(format)) {
            if (!isNullOrUndefined(format.uniqueRowFormat)) {
                this.allowBreakAcrossPages = format.allowBreakAcrossPages;
                this.isHeader = format.isHeader;
                this.heightType = format.heightType;
                this.height = format.height;
                this.gridBefore = format.gridBefore;
                this.gridBeforeWidth = format.gridBeforeWidth;
                this.gridBeforeWidthType = format.gridBeforeWidthType;
                this.gridAfter = format.gridAfter;
                this.gridAfterWidth = format.gridAfterWidth;
                this.gridAfterWidthType = format.gridAfterWidthType;
                this.leftMargin = format.leftMargin;
                this.topMargin = format.topMargin;
                this.rightMargin = format.rightMargin;
                this.bottomMargin = format.bottomMargin;
                this.leftIndent = format.leftIndent;
            }
            if (!isNullOrUndefined(format.borders)) {
                this.borders = new WBorders(this);
                this.borders.ownerBase = format;
                this.borders.copyFormat(format.borders);
            }
            if (format.revisions.length > 0) {
                this.removedIds = Revision.cloneRevisions(format.revisions);
            }
            else {
                this.removedIds = format.removedIds.slice();
            }
        }
    }
    destroy() {
        if (!isNullOrUndefined(this.borders)) {
            this.borders.destroy();
        }
        if (!isNullOrUndefined(this.uniqueRowFormat)) {
            WRowFormat.uniqueRowFormats.remove(this.uniqueRowFormat);
        }
        this.beforeWidth = undefined;
        this.afterWidth = undefined;
        this.borders = undefined;
        this.uniqueRowFormat = undefined;
    }
    static clear() {
        this.uniqueRowFormats.clear();
    }
}
WRowFormat.uniqueRowFormats = new WUniqueFormats();
WRowFormat.uniqueFormatType = 6;

/**
 * The revision class which holds the information related to changes made in the document
 */
class Revision {
    constructor(documentHelper, author, date) {
        /**
         * Gets or sets the author name who made the change
         *
         * @private
         */
        this.author = null;
        /**
         * Indicates when the track changes made
         *
         * @private
         */
        this.date = null;
        /**
         * Holds the reference of the items which are under this revision.
         *
         * @private
         */
        this.range = [];
        /**
         * @private
         */
        this.revisionID = '';
        /**
         * Used to update cursor position by ensuring items were removed or not
         */
        this.isContentRemoved = false;
        this.isTableRevision = false;
        /**
         * Indicates whether to skip unlinking ranges for table elements.
         */
        this.canSkipTableItems = false;
        this.skipUnLinkElement = false;
        this.author = author;
        this.date = date;
        this.owner = documentHelper;
    }
    handleAcceptReject(isFromAccept) {
        this.owner.selection.selectRevision(this);
        const selection = this.owner.selection;
        let startPos = selection.start;
        let endPos = selection.end;
        if (!selection.start.isExistBefore(selection.end)) {
            startPos = selection.end;
            endPos = selection.start;
        }
        let blockInfo = selection.getParagraphInfo(startPos);
        this.owner.editor.initHistory(isFromAccept ? 'Accept Change' : 'Reject Change');
        if (this.revisionType === 'Deletion') {
            blockInfo = selection.getParagraphInfo(this.owner.selection.start);
            selection.editPosition = this.owner.selection.getHierarchicalIndex(blockInfo.paragraph, blockInfo.offset.toString());
        }
        else {
            selection.editPosition = this.owner.selection.getHierarchicalIndex(blockInfo.paragraph, blockInfo.offset.toString());
        }
        this.owner.editor.updateInsertPosition();
        this.isContentRemoved = false;
        this.canSkipTableItems = false;
        this.skipUnLinkElement = false;
        // Implement to accept/reject the revision
        if (this.revisionType === 'Insertion' || this.revisionType === 'Deletion' || this.revisionType === 'MoveFrom' || this.revisionType === 'MoveTo') {
            let rangeIndex = 0;
            while (this.range.length > 0) {
                if (this.range[rangeIndex] instanceof ElementBox || this.range[rangeIndex] instanceof WCharacterFormat || this.range[rangeIndex] instanceof WRowFormat) {
                    const moveToNextItem = this.unlinkRangeItem(this.range[rangeIndex], this, isFromAccept);
                    if (moveToNextItem) {
                        rangeIndex++;
                    }
                    else {
                        rangeIndex = 0;
                    }
                }
                else {
                    break;
                }
            }
        }
        this.isTableRevision = false;
        if (this.isContentRemoved) {
            const textPosition = selection.getTextPosBasedOnLogicalIndex(selection.editPosition);
            this.owner.selection.selectContent(textPosition, true);
            this.owner.editor.updateEndPosition();
        }
        else {
            selection.selectRange(startPos, endPos);
            this.owner.editor.updateHistoryPosition(endPos, false);
        }
        if (this.owner.editorHistory && this.owner.editorHistory.currentBaseHistoryInfo.action !== 'BackSpace') {
            this.owner.editorHistory.currentBaseHistoryInfo.removedNodes.reverse();
        }
        if (this.owner.editorHistory) {
            if (this.owner.trackChangesPane.isTrackingPageBreak) {
                this.owner.editorHistory.currentBaseHistoryInfo.action = 'TrackingPageBreak';
            }
            let editorHistory = this.owner.editorHistory;
            if (editorHistory.currentHistoryInfo && (editorHistory.currentHistoryInfo.action === 'Accept All' || editorHistory.currentHistoryInfo.action === 'Reject All')) {
                if (this.owner.documentHelper.blockToShift) {
                    this.owner.documentHelper.layout.shiftLayoutedItems(false);
                }
            }
            editorHistory.updateHistory();
        }
        this.owner.editor.reLayout(this.owner.selection);
        if (blockInfo.paragraph.isInHeaderFooter) {
            this.owner.editor.updateHeaderFooterWidget();
        }
    }
    /**
     * Method which accepts the selected revision, revision marks will be removed and changes will be included in the viewer.
     *
     * @returns {void}
     */
    accept() {
        this.handleAcceptReject(true);
    }
    /**
     * Method which rejects the selected revision, revision marks will be removed leaving the original content.
     */
    reject() {
        this.handleAcceptReject(false);
    }
    /**
     * Unlinks revision and its assosiated range
     * @private
     * @param item
     * @param revision
     * @param isFromAccept
     */
    /* eslint-disable  */
    unlinkRangeItem(item, revision, isFromAccept) {
        if (this.isTableRevision) {
            this.removeRangeRevisionForItem(item);
            if (revision.range.length === 0) {
                this.owner.revisions.remove(revision);
            }
            return false;
        }
        let removeChanges = (!isNullOrUndefined(isFromAccept)) && ((revision.revisionType === 'MoveFrom' || revision.revisionType === 'Deletion') && isFromAccept) || ((revision.revisionType === 'Insertion' || revision.revisionType === 'MoveTo') && !isFromAccept);
        if (this.owner.selection.isTOC()) {
            if (removeChanges) {
                this.owner.editor.deleteSelectedContents(this.owner.selection, true);
                if (revision.range.length === 0) {
                    this.owner.revisions.remove(revision);
                }
                this.isContentRemoved = true;
                this.owner.editorHistory.currentBaseHistoryInfo.action = 'BackSpace';
            }
            else {
                while (this.range.length > 0) {
                    let currentElement = this.range[0];
                    this.removeRangeRevisionForItem(currentElement);
                    if (revision.range.length === 0) {
                        this.owner.revisions.remove(revision);
                    }
                }
                this.owner.editor.addRemovedNodes(this.revisionID);
                this.owner.editorHistory.currentBaseHistoryInfo.action = 'AcceptTOC';
            }
            return false;
        }
        if (item instanceof ElementBox && !this.canSkipTableItems) {
            if (removeChanges) {
                if (!this.skipeElementRemoval(item)) {
                    this.owner.editor.addRemovedNodes(item.clone());
                }
                else {
                    this.skipUnLinkElement = true;
                    return true;
                }
            }
            else {
                this.owner.editorHistory.currentBaseHistoryInfo.action = 'ClearRevisions';
                this.updateRevisionID();
            }
        }
        else if (!this.canSkipTableItems && (item instanceof WCharacterFormat) && (!removeChanges)) {
            this.owner.editorHistory.currentBaseHistoryInfo.action = 'ClearRevisions';
            this.updateRevisionID();
        }
        else if (item instanceof WRowFormat && !removeChanges) {
            this.isTableRevision = true;
            let tableWidget = item.ownerBase.ownerTable;
            let currentRow = item.ownerBase;
            this.owner.editorHistory.currentBaseHistoryInfo.action = 'RemoveRowTrack';
            this.owner.editor.cloneTableToHistoryInfo(tableWidget);
        }
        removeChanges = removeChanges && !this.canSkipTableItems;
        if (item instanceof ElementBox && removeChanges) {
            let currentPara = item.line.paragraph;
            this.removeRevisionItemsFromRange(item);
            this.removeItem(item);
            this.isContentRemoved = true;
            this.owner.documentHelper.layout.reLayoutParagraph(currentPara, 0, 0);
        }
        else if (item instanceof WCharacterFormat && removeChanges) {
            this.isContentRemoved = true;
            this.skipUnLinkElement = false;
            this.removeRevisionItemsFromRange(item);
            if (revision.range.length === 1) {
                this.owner.editor.deleteSelectedContents(this.owner.selection, true);
            }
            else {
                this.owner.editor.deleteSelectedContents(this.owner.selection, true);
                let rangeIndex = revision.range.indexOf(item);
                revision.range.splice(rangeIndex, 1);
                while (this.range.length > 0) {
                    this.removeRangeRevisionForItem(this.range[0]);
                }
            }
            this.owner.editorHistory.currentBaseHistoryInfo.action = 'BackSpace';
        }
        else if (item instanceof WRowFormat && removeChanges) {
            let tableWidget = item.ownerBase.ownerTable;
            let currentRow = item.ownerBase;
            this.removeRevisionItemsFromRange(item);
            this.owner.editorHistory.currentBaseHistoryInfo.action = 'DeleteCells';
            this.owner.editor.cloneTableToHistoryInfo(tableWidget);
            this.owner.editor.removeDeletedCellRevision(currentRow);
            this.isContentRemoved = true;
            tableWidget.removeChild(tableWidget.childWidgets.indexOf(currentRow));
            this.canSkipTableItems = true;
            currentRow.destroy();
            if (tableWidget.childWidgets.length === 0) {
                this.owner.selection.editPosition = this.owner.selection.getHierarchicalIndex(tableWidget, '0');
                this.owner.editor.removeBlock(tableWidget);
                tableWidget.destroy();
            }
            else {
                this.owner.editor.updateTable(tableWidget);
            }
        }
        // if the range is of row format, we will remove the row and for history preservation we use whole table to be cloned, hence skipping this part
        if (!(item instanceof WRowFormat) || !removeChanges) {
            if (!this.skipUnLinkElement) {
                this.removeRangeRevisionForItem(item);
            }
        }
        if (revision.range.length === 0) {
            this.owner.revisions.remove(revision);
        }
        return false;
    }
    updateRevisionID() {
        this.owner.editor.addRemovedNodes(this.revisionID);
        while (this.range.length > 0) {
            this.removeRangeRevisionForItem(this.range[0]);
        }
    }
    /* eslint-disable @typescript-eslint/no-explicit-any */
    removeRevisionItemsFromRange(item) {
        if (item.revisions.length > 0) {
            for (let revisionIndex = 0; revisionIndex < item.revisions.length; revisionIndex++) {
                let currentRevision = item.revisions[revisionIndex];
                if (this.revisionID !== currentRevision.revisionID) {
                    let rangeIndex = currentRevision.range.indexOf(item);
                    item.revisions[revisionIndex].range.splice(rangeIndex, 1);
                }
                if (currentRevision.range.length === 0) {
                    this.owner.revisions.remove(currentRevision);
                }
            }
        }
    }
    /**
     * Method to clear linked ranges in revision
     *
     * @private
     * @param {any} item - Specifies the item
     * @returns {void}
     */
    /* eslint-disable @typescript-eslint/no-explicit-any */
    removeRangeRevisionForItem(item) {
        let revisionIndex = item.revisions.indexOf(this);
        if (revisionIndex >= 0) {
            item.revisions.splice(revisionIndex, 1);
            let rangeIndex = this.range.indexOf(item);
            this.range.splice(rangeIndex, 1);
        }
    }
    /**
     * @private
     * @param {Element} element - Specifies the element.
     * @returns {boolean} Resturs skip element removal
     */
    skipeElementRemoval(element) {
        let elementPara = element.paragraph;
        if (elementPara.characterFormat.revisions.length > 0) {
            for (let i = 0; i < elementPara.characterFormat.revisions.length; i++) {
                let currentRevision = elementPara.characterFormat.revisions[i];
                let rangeIndex = currentRevision.range.indexOf(element);
                if (rangeIndex >= 0) {
                    return true;
                }
            }
        }
        return false;
    }
    removeRevisionFromRow(row) {
        this.owner.editor.unlinkRangeFromRevision(row.rowFormat);
        //this.owner.editor.addRemovedRevisionInfo(row.rowFormat, undefined);
        for (let i = 0; i < row.childWidgets.length; i++) {
            let cellWidget = row.childWidgets[i];
            this.owner.editor.removeRevisionForCell(cellWidget, false);
        }
    }
    removeItem(element) {
        let paraWidget = element.line.paragraph;
        this.owner.editor.unLinkFieldCharacter(element);
        let elementIndex = element.line.children.indexOf(element);
        element.line.children.splice(elementIndex, 1);
        this.owner.editor.removeEmptyLine(paraWidget);
    }
    canSkipCloning() {
        if (!isNullOrUndefined(this.owner) && this.owner.editorHistory && this.owner.editorHistory.currentBaseHistoryInfo) {
            let baseHistoryInfo = this.owner.editorHistory.currentBaseHistoryInfo;
            if (baseHistoryInfo.action === 'DeleteCells') {
                return true;
            }
        }
        return false;
    }
    /**
     * @private
     * @returns {Revision} - Returns revision
     */
    clone() {
        if (this.canSkipCloning()) {
            return this;
        }
        let revision = new Revision(undefined, this.author, this.date);
        revision.revisionID = this.revisionID;
        revision.revisionType = this.revisionType;
        return revision;
    }
    /**
     * Method to clone the revisions for the element
     *
     * @param {Revision[]} revisions - revision array.
     * @returns {string[]} - returns clones revisions.
     */
    static cloneRevisions(revisions) {
        let clonedRevisions = [];
        for (let i = 0; i < revisions.length; i++) {
            clonedRevisions.push(revisions[i].revisionID);
        }
        return clonedRevisions;
    }
}
/**
 * Represents the revision collections in the document.
 */
class RevisionCollection {
    constructor(owner) {
        /**
         * @private
         */
        this.changes = [];
        this.owner = owner;
    }
    /**
     * @private
     */
    get(index) {
        if (index >= this.changes.length || index < 0) {
            throw new ReferenceError('Provided index is not within the range');
        }
        return this.changes[index];
    }
    get length() {
        return this.changes.length;
    }
    remove(revision) {
        if (isNullOrUndefined(revision) || this.changes.indexOf(revision) < 0) {
            return;
        }
        this.changes.splice(this.changes.indexOf(revision), 1);
    }
    /**
     * Method which accepts all the revision in the revision collection
     *
     * @returns {void}
     */
    acceptAll() {
        if (!this.owner.isReadOnly) {
            this.handleRevisionCollection(true);
        }
    }
    /**
     * Method which rejects all the revision in the revision collection
     *
     * @returns {void}
     */
    rejectAll() {
        if (!this.owner.isReadOnly) {
            this.handleRevisionCollection(false);
        }
    }
    /**
     * @private
     * @param {boolean} isfromAcceptAll - Specifies the is accept all.
     * @param {Revision[]} changes - Specifies the revisions.
     * @returns {void}
     */
    handleRevisionCollection(isfromAcceptAll, changes) {
        let selection = this.owner.selection;
        let startPos = selection.start;
        let endPos = selection.end;
        if (!selection.start.isExistBefore(selection.end)) {
            startPos = selection.end;
            endPos = selection.start;
        }
        startPos = startPos.clone();
        endPos = endPos.clone();
        if (isfromAcceptAll) {
            this.owner.editor.initComplexHistory('Accept All');
        }
        else {
            this.owner.editor.initComplexHistory('Reject All');
        }
        let revisionCollec = changes ? changes : this.changes;
        while (revisionCollec.length > 0) {
            if (isfromAcceptAll) {
                revisionCollec[0].accept();
            }
            else {
                revisionCollec[0].reject();
            }
            if (changes) {
                revisionCollec.splice(0, 1);
            }
            if (this.owner.enableHeaderAndFooter) {
                this.owner.editor.updateHeaderFooterWidget();
            }
        }
        let textPosition = selection.getTextPosBasedOnLogicalIndex(selection.editPosition);
        this.owner.selection.selectContent(textPosition, true);
        if (this.owner.editorHistory) {
            this.owner.editorHistory.updateComplexHistory();
        }
        this.owner.editor.reLayout(this.owner.selection, false);
    }
    destroy() {
        this.changes = [];
    }
}

/* eslint-disable */
/**
 * @private
 */
class WCharacterFormat {
    constructor(node) {
        this.uniqueCharacterFormat = undefined;
        this.ownerBase = undefined;
        this.baseCharStyle = undefined;
        /**
         * @private
         */
        this.removedIds = [];
        /**
         * @private
         */
        this.revisions = [];
        this.ownerBase = node;
    }
    get bold() {
        return this.getPropertyValue('bold');
    }
    set bold(value) {
        this.setPropertyValue('bold', value);
    }
    get italic() {
        return this.getPropertyValue('italic');
    }
    set italic(value) {
        this.setPropertyValue('italic', value);
    }
    get fontSize() {
        return this.getPropertyValue('fontSize');
    }
    set fontSize(value) {
        this.setPropertyValue('fontSize', value);
    }
    get fontFamily() {
        return this.getPropertyValue('fontFamily');
    }
    set fontFamily(value) {
        this.setPropertyValue('fontFamily', value);
    }
    get underline() {
        return this.getPropertyValue('underline');
    }
    set underline(value) {
        this.setPropertyValue('underline', value);
    }
    get strikethrough() {
        return this.getPropertyValue('strikethrough');
    }
    set strikethrough(value) {
        this.setPropertyValue('strikethrough', value);
    }
    get baselineAlignment() {
        return this.getPropertyValue('baselineAlignment');
    }
    set baselineAlignment(value) {
        this.setPropertyValue('baselineAlignment', value);
    }
    get highlightColor() {
        return this.getPropertyValue('highlightColor');
    }
    set highlightColor(value) {
        this.setPropertyValue('highlightColor', value);
    }
    get fontColor() {
        return this.getPropertyValue('fontColor');
    }
    set fontColor(value) {
        this.setPropertyValue('fontColor', value);
    }
    get bidi() {
        return this.getPropertyValue('bidi');
    }
    set bidi(value) {
        this.setPropertyValue('bidi', value);
    }
    get bdo() {
        return this.getPropertyValue('bdo');
    }
    set bdo(value) {
        this.setPropertyValue('bdo', value);
    }
    get boldBidi() {
        return this.getPropertyValue('boldBidi');
    }
    set boldBidi(value) {
        this.setPropertyValue('boldBidi', value);
    }
    get italicBidi() {
        return this.getPropertyValue('italicBidi');
    }
    set italicBidi(value) {
        this.setPropertyValue('italicBidi', value);
    }
    get fontSizeBidi() {
        return this.getPropertyValue('fontSizeBidi');
    }
    set fontSizeBidi(value) {
        this.setPropertyValue('fontSizeBidi', value);
    }
    get fontFamilyBidi() {
        return this.getPropertyValue('fontFamilyBidi');
    }
    set fontFamilyBidi(value) {
        this.setPropertyValue('fontFamilyBidi', value);
    }
    get allCaps() {
        return this.getPropertyValue('allCaps');
    }
    set allCaps(value) {
        this.setPropertyValue('allCaps', value);
    }
    getPropertyValue(property) {
        if (!this.hasValue(property)) {
            const charStyleValue = this.checkCharacterStyle(property);
            if (!isNullOrUndefined(charStyleValue)) {
                return charStyleValue;
            }
            else {
                if (!isNullOrUndefined(this.baseCharStyle)) {
                    const paragraph = this.ownerBase.paragraph;
                    const line = this.ownerBase.line;
                    if (!isNullOrUndefined(paragraph) && !isNullOrUndefined(line)) {
                        const length = line.children.length;
                        for (let i = 0; i < length; i++) {
                            const element = this.ownerBase.line.children[i];
                            if (element instanceof TextElementBox) {
                                const text = element.text;
                                if (text.startsWith('HYPERLINK')) {
                                    const index = text.indexOf('_Toc');
                                    if (index !== -1) {
                                        this.baseCharStyle = this.ownerBase.paragraph.paragraphFormat.baseStyle;
                                    }
                                }
                            }
                        }
                    }
                }
                const baseStyleValue = this.checkBaseStyle(property);
                if (!isNullOrUndefined(baseStyleValue)) {
                    return baseStyleValue;
                }
            }
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(WCharacterFormat.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueCharacterFormat) && this.uniqueCharacterFormat.propertiesHash.containsKey(propertyType)) {
                return this.uniqueCharacterFormat.propertiesHash.get(propertyType);
            }
        }
        return this.getDefaultValue(property);
    }
    getDefaultValue(property) {
        const propertyType = WUniqueFormat.getPropertyType(WCharacterFormat.uniqueFormatType, property);
        const docCharacterFormat = this.documentCharacterFormat();
        if (!isNullOrUndefined(docCharacterFormat) && !isNullOrUndefined(docCharacterFormat.uniqueCharacterFormat) && docCharacterFormat.uniqueCharacterFormat.propertiesHash.containsKey(propertyType)) {
            return docCharacterFormat.uniqueCharacterFormat.propertiesHash.get(propertyType);
        }
        else {
            return WCharacterFormat.getPropertyDefaultValue(property);
        }
    }
    documentCharacterFormat() {
        let docCharacterFormat;
        if (!isNullOrUndefined(this.ownerBase)) {
            if (!isNullOrUndefined(this.ownerBase.paragraph) && !isNullOrUndefined(this.ownerBase.paragraph.bodyWidget)) {
                docCharacterFormat = this.ownerBase.paragraph.bodyWidget.page.documentHelper.characterFormat;
            }
            else {
                if (!isNullOrUndefined(this.ownerBase.bodyWidget)) {
                    docCharacterFormat = this.ownerBase.bodyWidget.page.documentHelper.characterFormat;
                }
            }
        }
        return docCharacterFormat;
    }
    checkBaseStyle(property) {
        let baseStyle;
        if (!isNullOrUndefined(this.ownerBase)) {
            if (!isNullOrUndefined(this.ownerBase.paragraph)) {
                baseStyle = this.ownerBase.paragraph.paragraphFormat.baseStyle;
            }
            else {
                if ((this.ownerBase instanceof ParagraphWidget) && !isNullOrUndefined(this.ownerBase.paragraphFormat)) {
                    baseStyle = this.ownerBase.paragraphFormat.baseStyle;
                }
                else {
                    if (!isNullOrUndefined(this.ownerBase instanceof WParagraphStyle)) {
                        baseStyle = this.ownerBase.basedOn;
                    }
                }
            }
        }
        while (!isNullOrUndefined(baseStyle)) {
            if (baseStyle.characterFormat.hasValue(property)) {
                break;
            }
            else {
                baseStyle = baseStyle.basedOn;
            }
        }
        if (!isNullOrUndefined(baseStyle)) {
            const propertyType = WUniqueFormat.getPropertyType(WCharacterFormat.uniqueFormatType, property);
            return baseStyle.characterFormat.uniqueCharacterFormat.propertiesHash.get(propertyType);
        }
        return undefined;
    }
    checkCharacterStyle(property) {
        let baseStyle = this.baseCharStyle;
        if (!isNullOrUndefined(baseStyle)) {
            while (!isNullOrUndefined(baseStyle) && baseStyle.name !== 'Default Paragraph Font') {
                const hasKey = baseStyle.characterFormat.hasValue(property);
                if (hasKey) {
                    const returnPropertyType = WUniqueFormat.getPropertyType(WCharacterFormat.uniqueFormatType, property);
                    return baseStyle.characterFormat.uniqueCharacterFormat.propertiesHash.get(returnPropertyType);
                }
                else {
                    baseStyle = baseStyle.basedOn;
                }
            }
        }
        return undefined;
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WCharacterFormat.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueCharacterFormat)) {
            this.initializeUniqueCharacterFormat(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueCharacterFormat.uniqueFormatType, property);
            if (this.uniqueCharacterFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueCharacterFormat.propertiesHash.get(propertyType) === value) { //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueCharacterFormat = WCharacterFormat.uniqueCharacterFormats.updateUniqueFormat(this.uniqueCharacterFormat, property, value);
        }
    }
    initializeUniqueCharacterFormat(property, propValue) {
        const uniqueCharFormatTemp = new Dictionary();
        this.addUniqueCharacterFormat('fontColor', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('fontFamily', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('fontSize', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('bold', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('italic', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('underline', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('strikethrough', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('baselineAlignment', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('highlightColor', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('styleName', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('bidi', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('bdo', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('fontFamilyBidi', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('fontSizeBidi', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('boldBidi', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('italicBidi', property, propValue, uniqueCharFormatTemp);
        this.addUniqueCharacterFormat('allCaps', property, propValue, uniqueCharFormatTemp);
        this.uniqueCharacterFormat = WCharacterFormat.uniqueCharacterFormats.addUniqueFormat(uniqueCharFormatTemp, WCharacterFormat.uniqueFormatType);
    }
    addUniqueCharacterFormat(property, modifiedProperty, propValue, uniqueCharFormatTemp) {
        let propertyType = WUniqueFormat.getPropertyType(WCharacterFormat.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueCharFormatTemp.add(propertyType, propValue);
        }
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        switch (property) {
            case 'bold':
                value = false;
                break;
            case 'italic':
                value = false;
                break;
            case 'fontSize':
                value = 11;
                break;
            case 'underline':
                value = 'None';
                break;
            case 'strikethrough':
                value = 'None';
                break;
            case 'baselineAlignment':
                value = 'Normal';
                break;
            case 'highlightColor':
                value = 'NoColor';
                break;
            case 'fontColor':
                value = '#00000000';
                break;
            case 'fontFamily':
                value = 'Calibri';
                break;
            case 'styleName':
                value = 'Default Paragraph Font';
                break;
            case 'bidi':
                value = false;
                break;
            case 'bdo':
                value = 'None';
                break;
            case 'boldBidi':
                value = false;
                break;
            case 'italicBidi':
                value = false;
                break;
            case 'fontSizeBidi':
                value = 11;
                break;
            case 'fontFamilyBidi':
                value = 'Calibri';
                break;
            case 'allCaps':
                value = false;
                break;
        }
        return value;
    }
    isEqualFormat(format) {
        return (this.fontSize === format.fontSize
            && this.fontFamily === format.fontFamily
            && this.bold === format.bold
            && this.italic === format.italic
            && this.baselineAlignment === format.baselineAlignment
            && this.underline === format.underline
            && this.fontColor === format.fontColor
            && this.strikethrough === format.strikethrough
            && this.highlightColor === format.highlightColor && this.bidi === format.bidi
            && this.bdo === format.bdo)
            && this.allCaps === format.allCaps;
    }
    isSameFormat(format) {
        return this.baseCharStyle === format.baseCharStyle &&
            this.uniqueCharacterFormat === format.uniqueCharacterFormat;
    }
    cloneFormat() {
        const format = new WCharacterFormat(undefined);
        format.uniqueCharacterFormat = this.uniqueCharacterFormat;
        format.baseCharStyle = this.baseCharStyle;
        if (this.revisions.length > 0) {
            format.removedIds = Revision.cloneRevisions(this.revisions);
        }
        else {
            format.removedIds = this.removedIds.slice();
        }
        return format;
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueCharacterFormat) && !isNullOrUndefined(this.uniqueCharacterFormat.propertiesHash)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueCharacterFormat.uniqueFormatType, property);
            return this.uniqueCharacterFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    clearFormat() {
        if (!isNullOrUndefined(this.uniqueCharacterFormat) && this.uniqueCharacterFormat.referenceCount === 0) {
            WCharacterFormat.uniqueCharacterFormats.remove(this.uniqueCharacterFormat);
        }
        this.uniqueCharacterFormat = undefined;
        this.baseCharStyle = undefined;
    }
    destroy() {
        this.clearFormat();
    }
    copyFormat(format) {
        if (!isNullOrUndefined(format)) {
            if (!isNullOrUndefined(format.uniqueCharacterFormat) && format.uniqueCharacterFormat.propertiesHash) {
                this.updateUniqueCharacterFormat(format);
            }
            if (!isNullOrUndefined(format.baseCharStyle)) {
                this.baseCharStyle = format.baseCharStyle;
            }
            if (format.revisions.length > 0) {
                this.removedIds = Revision.cloneRevisions(format.revisions);
            }
            else {
                this.removedIds = format.removedIds.slice();
            }
        }
    }
    updateUniqueCharacterFormat(format) {
        let hash = undefined;
        if (this.uniqueCharacterFormat) {
            hash = this.uniqueCharacterFormat.mergeProperties(format.uniqueCharacterFormat);
            if (this.uniqueCharacterFormat.referenceCount === 0) {
                WCharacterFormat.uniqueCharacterFormats.remove(this.uniqueCharacterFormat);
                this.uniqueCharacterFormat = undefined;
            }
        }
        this.uniqueCharacterFormat = new WUniqueFormat(WCharacterFormat.uniqueFormatType);
        if (isNullOrUndefined(hash)) {
            hash = this.uniqueCharacterFormat.mergeProperties(format.uniqueCharacterFormat);
        }
        this.uniqueCharacterFormat = WCharacterFormat.uniqueCharacterFormats.addUniqueFormat(hash, WCharacterFormat.uniqueFormatType);
    }
    static clear() {
        this.uniqueCharacterFormats.clear();
    }
    applyStyle(baseCharStyle) {
        this.baseCharStyle = baseCharStyle;
    }
    getValue(property) {
        return this.hasValue(property) ? this.getPropertyValue(property) : undefined;
    }
    mergeFormat(format) {
        if (isNullOrUndefined(this.getValue('bold'))) {
            this.bold = format.getValue('bold');
        }
        if (isNullOrUndefined(this.getValue('italic'))) {
            this.italic = format.getValue('italic');
        }
        if (isNullOrUndefined(this.getValue('fontSize'))) {
            this.fontSize = format.getValue('fontSize');
        }
        if (isNullOrUndefined(this.getValue('fontFamily'))) {
            this.fontFamily = format.getValue('fontFamily');
        }
        if (isNullOrUndefined(this.getValue('underline'))) {
            this.underline = format.getValue('underline');
        }
        if (isNullOrUndefined(this.getValue('strikethrough'))) {
            this.strikethrough = format.getValue('strikethrough');
        }
        if (isNullOrUndefined(this.getValue('baselineAlignment'))) {
            this.baselineAlignment = format.getValue('baselineAlignment');
        }
        if (isNullOrUndefined(this.getValue('highlightColor'))) {
            this.highlightColor = format.getValue('highlightColor');
        }
        if (isNullOrUndefined(this.getValue('fontColor'))) {
            this.fontColor = format.getValue('fontColor');
        }
        if (isNullOrUndefined(this.getValue('bidi'))) {
            this.bidi = format.getValue('bidi');
        }
        if (isNullOrUndefined(this.getValue('bdo'))) {
            this.bdo = format.getValue('bdo');
        }
        if (isNullOrUndefined(this.getValue('allCaps'))) {
            this.allCaps = format.getValue('allCaps');
        }
    }
}
WCharacterFormat.uniqueCharacterFormats = new WUniqueFormats();
WCharacterFormat.uniqueFormatType = 2;

/**
 * @private
 */
class HelperMethods {
    /**
     * Inserts text at specified index in string.
     *
     * @private
     * @param {string} spanText - Specifies the span text.
     * @param {number} index - Specifies the index
     * @param {string} text - Specifies the text
     * @returns {string} - Returns modified string
     */
    static insert(spanText, index, text) {
        if (index >= 0) {
            return [spanText.slice(0, index) + text + spanText.slice(index)].join('');
        }
        else {
            return text + this;
        }
    }
    /**
     * Removes text from specified index in string.
     *
     * @private
     * @param {string} text - Specifies the text
     * @param {number} index - Specifies the index
     * @returns {string} - Returns modified string
     */
    static remove(text, index) {
        if (index === 0) {
            return text.substring(index + 1, text.length);
        }
        else {
            return text.substring(0, index) + text.substring(index + 1, text.length);
        }
    }
    /* eslint-disable @typescript-eslint/no-explicit-any */
    static indexOfAny(text, wordSplitCharacter) {
        let index = undefined;
        if(isNullOrUndefined(text)){
            for (let j = 0; j < wordSplitCharacter.length; j++) {
                const temp = text.indexOf(wordSplitCharacter[j]);
                if (temp !== -1 && isNullOrUndefined(index)) {
                    index = temp;
                }
                else if (temp !== -1 && temp < index) {
                    index = temp;
                }
            }
        }
        return isNullOrUndefined(index) ? -1 : index;
    }
    /**
     * Convert ARGB to RGB
     * @private
     * @param {string} color
     * @returns {string}
     */
    static convertArgbToRgb(color) {
        if (color.length >= 8) {
            return color.substr(0, 6);
        }
        return color;
    }
    static lastIndexOfAny(text, wordSplitCharacter) {
        for (let i = text.length - 1; i >= 0; i--) {
            for (let j = 0; j <= wordSplitCharacter.length - 1; j++) {
                if (text[i] === wordSplitCharacter[j]) {
                    return i;
                }
            }
        }
        return -1;
    }
    static convertRgbToHex(val) {
        let hex = Number(val).toString(16);
        if (hex.length < 2) {
            hex = '0' + hex;
        }
        return hex;
    }
    static convertHexToRgb(colorCode) {
        if (colorCode) {
            colorCode = colorCode.replace(/[^0-9A-â€Œâ€‹F]/gi, ''); // To remove # from color code string.
            const colCodeNo = parseInt(colorCode, 16);
            const r = (colCodeNo >> 16) & 255;
            const g = (colCodeNo >> 8) & 255;
            const b = colCodeNo & 255;
            return { 'r': r, 'g': g, 'b': b };
        }
        return undefined;
    }
    static addCssStyle(css) {
        const style = document.createElement('style');
        if (style.style.cssText) {
            style.style.cssText = css;
        }
        else {
            style.appendChild(document.createTextNode(css));
        }
        document.getElementsByTagName('head')[0].appendChild(style);
    }
    static getHighlightColorCode(highlightColor) {
        let color = '#ffffff';
        switch (highlightColor) {
            case 'Yellow':
                color = '#ffff00';
                break;
            case 'BrightGreen':
                color = '#00ff00';
                break;
            case 'Turquoise':
                color = '#00ffff';
                break;
            case 'Pink':
                color = '#ff00ff';
                break;
            case 'Blue':
                color = '#0000ff';
                break;
            case 'Red':
                color = '#ff0000';
                break;
            case 'DarkBlue':
                color = '#000080';
                break;
            case 'Teal':
                color = '#008080';
                break;
            case 'Green':
                color = '#008000';
                break;
            case 'Violet':
                color = '#800080';
                break;
            case 'DarkRed':
                color = '#800000';
                break;
            case 'DarkYellow':
                color = '#808000';
                break;
            case 'Gray50':
                color = '#808080';
                break;
            case 'Gray25':
                color = '#c0c0c0';
                break;
            case 'Black':
                color = '#000000';
                break;
        }
        return color;
    }
    static isVeryDark(backColor) {
        const backgroundColor = backColor.substring(1);
        const r = parseInt(backgroundColor.substr(0, 2), 16);
        const g = parseInt(backgroundColor.substr(2, 2), 16);
        const b = parseInt(backgroundColor.substr(4, 2), 16);
        const contrast = ((r * 299) + (g * 587) + (b * 114)) / 1000;
        return contrast <= 60;
    }
    static getColor(color) {
        if (color.length > 0) {
            if (color[0] === '#') {
                if (color.length > 7) {
                    return color.substr(0, 7);
                }
            }
        }
        return color;
    }
    static convertPointToPixel(point) {
        const pixel = HelperMethods.round((point * 96 / 72), 5);
        return pixel;
    }
    static convertPixelToPoint(pixel) {
        const point = HelperMethods.round((pixel * 72 / 96), 5);
        return point;
    }
    static isLinkedFieldCharacter(inline) {
        if (inline instanceof FieldElementBox && inline.fieldType === 0) {
            return !isNullOrUndefined(inline.fieldEnd);
        }
        else if (inline instanceof FieldElementBox && inline.fieldType === 2) {
            return !isNullOrUndefined(inline.fieldBegin) && !isNullOrUndefined(inline.fieldEnd);
        }
        else {
            return !isNullOrUndefined(inline.fieldBegin);
        }
    }
    /**
     * Removes white space in a string.
     *
     * @private
     * @param {string} text - Specifies text to trim.
     * @returns {string} - Returns modified text.
     */
    static removeSpace(text) {
        if (!isNullOrUndefined(text) && text.length !== 0) {
            for (let i = 0; i < text.length; i++) {
                if (text.charAt(i) === ' ') {
                    //replace the space by empty string in string
                    text = text.replace(' ', '');
                }
            }
        }
        return text;
    }
    /**
     * Trims white space at start of the string.
     *
     * @private
     * @param {string} text - Specifies text to trim.
     * @returns {string} - Returns modified text.
     */
    static trimStart(text) {
        let i = 0;
        for (i; i < text.length; i++) {
            if (text[i] !== ' ') {
                break;
            }
        }
        return text.substring(i, text.length);
    }
    /**
     * Trims white space at end of the string.
     *
     * @private
     * @param {string} text - Specifies text to trim.
     * @returns {string} - Returns modified text.
     */
    static trimEnd(text) {
        let i = text.length - 1;
        for (i; i >= 0; i--) {
            if (text[i] !== ' ') {
                break;
            }
        }
        return text.substring(0, i + 1);
    }
    /**
     * Checks whether string ends with whitespace.
     *
     * @private
     * @param {string} text - Specifies the text.
     * @returns {boolean} - Returns true if text ends with specified text.
     */
    static endsWith(text) {
        if (!isNullOrUndefined(text) && text.length !== 0) {
            return text[text.length - 1] === ' ';
        }
        return false;
    }
    static addSpace(length) {
        let str = '';
        if (length > 0) {
            for (let i = 0; i < length; i++) {
                str += ' ';
            }
        }
        return str;
    }
    /* eslint-disable */
    static writeCharacterFormat(characterFormat, isInline, format) {
        characterFormat.bold = isInline ? format.bold : format.getValue('bold');
        characterFormat.italic = isInline ? format.italic : format.getValue('italic');
        characterFormat.fontSize = isInline ? this.toWriteInline(format, 'fontSize') : format.getValue('fontSize');
        characterFormat.fontFamily = isInline ? this.toWriteInline(format, 'fontFamily') : format.getValue('fontFamily');
        characterFormat.underline = isInline ? format.underline : format.getValue('underline');
        characterFormat.strikethrough = isInline ? format.strikethrough : format.getValue('strikethrough');
        characterFormat.baselineAlignment = isInline ? format.baselineAlignment : format.getValue('baselineAlignment');
        characterFormat.highlightColor = isInline ? format.highlightColor : format.getValue('highlightColor');
        characterFormat.fontColor = isInline ? this.toWriteInline(format, 'fontColor') : format.getValue('fontColor');
        characterFormat.styleName = !isNullOrUndefined(format.baseCharStyle) ? format.baseCharStyle.name : undefined;
        characterFormat.bidi = isInline ? format.bidi : format.getValue('bidi');
        characterFormat.bdo = isInline ? format.bdo : format.getValue('bdo');
        characterFormat.boldBidi = isInline ? format.boldBidi : format.getValue('boldBidi');
        characterFormat.italicBidi = isInline ? format.italicBidi : format.getValue('italicBidi');
        characterFormat.fontSizeBidi = isInline ? format.fontSizeBidi : format.getValue('fontSizeBidi');
        characterFormat.fontFamilyBidi = isInline ? format.fontFamilyBidi : format.getValue('fontFamilyBidi');
        characterFormat.allCaps = isInline ? format.allCaps : format.getValue('allCaps');
    }
    static toWriteInline(format, propertyName) {
        if (!isNullOrUndefined(format.ownerBase) && (format.ownerBase instanceof ElementBox)) {
            return format.hasValue(propertyName) ? format[propertyName] : format.getValue(propertyName);
        }
        else {
            return format[propertyName];
        }
    }
    /* eslint-enable */
    static round(value, decimalDigits) {
        let temp = value;
        for (let i = 0; i < decimalDigits; i++) {
            temp = temp * 10;
        }
        temp = Math.round(temp);
        for (let i = 0; i < decimalDigits; i++) {
            temp = temp / 10;
        }
        return temp;
    }
    static reverseString(text) {
        if (!isNullOrUndefined(text) && text !== '') {
            // return a new array
            const splitString = text.split('');
            // reverse the new created array
            const reverseString = splitString.reverse();
            // join all elements of the array into a string
            text = reverseString.join('');
        }
        return text;
    }
    static formatClippedString(base64ImageString) {
        let extension = '';
        let formatClippedString = '';
        if (this.startsWith(base64ImageString, 'data:image/svg+xml;base64,')) {
            extension = '.svg';
            formatClippedString = base64ImageString.replace('data:image/svg+xml;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/bmp;base64,')) {
            extension = '.bmp';
            formatClippedString = base64ImageString.replace('data:image/bmp;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/x-emf;base64,')) {
            extension = '.emf';
            formatClippedString = base64ImageString.replace('data:image/x-emf;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/exif;base64,')) {
            extension = '.exif';
            formatClippedString = base64ImageString.replace('data:image/exif;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/gif;base64,')) {
            extension = '.gif';
            formatClippedString = base64ImageString.replace('data:image/gif;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/icon;base64,')) {
            extension = '.ico';
            formatClippedString = base64ImageString.replace('data:image/icon;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/jpeg;base64,')) {
            extension = '.jpeg';
            formatClippedString = base64ImageString.replace('data:image/jpeg;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/jpg;base64,')) {
            extension = '.jpg';
            formatClippedString = base64ImageString.replace('data:image/jpg;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/png;base64,')) {
            extension = '.png';
            formatClippedString = base64ImageString.replace('data:image/png;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/tiff;base64,')) {
            extension = '.tif';
            formatClippedString = base64ImageString.replace('data:image/tiff;base64,', '');
        }
        else if (this.startsWith(base64ImageString, 'data:image/x-wmf;base64,')) {
            extension = '.wmf';
            formatClippedString = base64ImageString.replace('data:image/x-wmf;base64,', '');
        }
        else {
            extension = '.jpeg';
        }
        return { 'extension': extension, 'formatClippedString': formatClippedString };
    }
    static startsWith(sourceString, startString) {
        return startString.length > 0 && sourceString.substring(0, startString.length) === startString;
    }
    static formatText(format, value) {
        let text = value;
        switch (format.toLowerCase()) {
            case 'uppercase':
                text = value.toUpperCase();
                break;
            case 'lowercase':
                text = value.toLowerCase();
                break;
            case 'firstlower':
                text = this.lowerFirstChar(value);
                break;
            case 'firstcapital':
                text = this.capitaliseFirst(value, 'FirstCapital');
                break;
            case 'titlecase':
                text = this.capitaliseFirst(value, 'Titlecase');
                break;
        }
        return text;
    }
    static formatNumber(format, value) {
        const intl = new Internationalization();
        const dotData = value.split('.');
        value = dotData[0];
        const numberValue = intl.parseNumber(value);
        if (value.toString() === 'NaN') {
            return '';
        }
        if (format === '') {
            format = '0';
        }
        const numberFormat = { format: format };
        return intl.formatNumber(numberValue, numberFormat);
    }
    static formatDate(format, value) {
        const intl = new Internationalization();
        const date = new Date(value);
        if (isNaN(date.getDate())) {
            return '';
        }
        if (format === '') {
            return value;
        }
        if (format.indexOf('am/pm') !== -1) {
            format = format.replace(/am\/pm/gi, 'a');
        }
        const dateFormat = { 'format': format };
        return intl.formatDate(date, dateFormat);
    }
    /* eslint-enable @typescript-eslint/no-explicit-any */
    static capitaliseFirst(value, type, splitBy) {
        let text = '';
        if (type === 'Titlecase') {
            const valArry = splitBy ? value.split(splitBy) : value.split(' ');
            for (let i = 0; i < valArry.length; i++) {
                /* eslint-disable-next-line max-len */
                text += splitBy ? valArry[i].charAt(0).toUpperCase() + valArry[i].slice(1, valArry[i].length) : this.capitaliseFirstInternal(valArry[i]);
                if (valArry.length >= 0 && !splitBy) {
                    text += ' ';
                }
            }
            if (!splitBy) {
                text = this.capitaliseFirst(text, 'Titlecase', '\r');
            }
        }
        else if (type === 'FirstCapital') {
            text = this.capitaliseFirstInternal(value);
        }
        return text;
    }
    static lowerFirstChar(value) {
        return (value.charAt(0).toLowerCase() + value.slice(1, value.length));
    }
    static capitaliseFirstInternal(value) {
        return (value.charAt(0).toUpperCase() + value.slice(1, value.length).toLowerCase());
    }
    static getModifiedDate(date) {
        const modifiedDate = HelperMethods.getLocaleDate(date);
        const dateString = modifiedDate.toLocaleDateString([], { year: 'numeric', month: 'long', day: 'numeric' });
        const time = modifiedDate.toLocaleTimeString([], { hour: 'numeric', minute: 'numeric' });
        const dateTime = dateString + ' ' + time;
        return dateTime;
    }
    static getUtcDate() {
        const now = new Date();
        return new Date(now.getTime() - now.getTimezoneOffset() * 60000).toISOString();
    }
    static getLocaleDate(date) {
        const dt = new Date(date);
        return new Date(dt.getTime() + dt.getTimezoneOffset() * 60000);
    }
    static getCompatibilityModeValue(compatibilityMode) {
        let compatValue;
        switch (compatibilityMode) {
            case 'Word2003':
                compatValue = '11';
                break;
            case 'Word2007':
                compatValue = '12';
                break;
            case 'Word2010':
                compatValue = '14';
                break;
            default:
                compatValue = '15';
                break;
        }
        return compatValue;
    }
    /**
     * @private
     * @returns {string} - Returns the unique id for document editor.
     */
    static getUniqueElementId() {
        const documentEditorElementId = 'de_element';
        let index = 1;
        /* eslint-disable-next-line no-constant-condition */
        while (true) {
            const ele = document.getElementById(documentEditorElementId + index);
            if (isNullOrUndefined(ele)) {
                break;
            }
            index++;
        }
        return documentEditorElementId + index;
    }
}
/**
 * @private
 */
HelperMethods.wordBefore = '\\b';
/**
 * @private
 */
HelperMethods.wordAfter = '\\b';
/**
 * @private
 */
HelperMethods.wordSplitCharacters = [' ', ',', '.', ':', ';', '<', '>', '=',
    '+', '-', '_', '{', '}', '[', ']', '`', '~', '!', '@', '#', '$', '%', '^', '&',
    '*', '(', ')', '"', '?', '/', '|', '\\', '”', '　', '،', '؟', '؛', '’', '‘'];
/**
 * @private
 */
class Point {
    constructor(xPosition, yPosition) {
        this.xIn = 0;
        this.yIn = 0;
        this.xIn = xPosition;
        this.yIn = yPosition;
    }
    get x() {
        return this.xIn;
    }
    set x(value) {
        this.xIn = value;
    }
    get y() {
        return this.yIn;
    }
    set y(value) {
        this.yIn = value;
    }
    copy(point) {
        this.xIn = point.xIn;
        this.yIn = point.yIn;
    }
    /**
     * Destroys the internal objects maintained.
     *
     * @returns {void}
     */
    destroy() {
        this.xIn = undefined;
        this.yIn = undefined;
    }
}
/**
 * @private
 */
class Base64 {
    constructor() {
        this.keyStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
    }
    // public method for encoding
    encodeString(input) {
        let output = '';
        let chr1;
        let chr2;
        let chr3;
        let enc1;
        let enc2;
        let enc3;
        let enc4;
        let i = 0;
        input = this.unicodeEncode(input);
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            }
            else if (isNaN(chr3)) {
                enc4 = 64;
            }
            output = output +
                this.keyStr.charAt(enc1) + this.keyStr.charAt(enc2) +
                this.keyStr.charAt(enc3) + this.keyStr.charAt(enc4);
        }
        return output;
    }
    // private method for UTF-8 encoding
    unicodeEncode(input) {
        const tempInput = input.replace(/\r\n/g, '\n');
        let utftext = '';
        for (let n = 0; n < tempInput.length; n++) {
            const c = tempInput.charCodeAt(n);
            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
        return utftext;
    }
    decodeString(input) {
        let chr1;
        let chr2;
        let chr3;
        let enc1;
        let enc2;
        let enc3;
        let enc4;
        let i = 0;
        let resultIndex = 0;
        /*let dataUrlPrefix: string = 'data:';*/
        input = input.replace(/[^A-Za-z0-9+/=]/g, '');
        let totalLength = input.length * 3 / 4;
        if (input.charAt(input.length - 1) === this.keyStr.charAt(64)) {
            totalLength--;
        }
        if (input.charAt(input.length - 2) === this.keyStr.charAt(64)) {
            totalLength--;
        }
        if (totalLength % 1 !== 0) {
            // totalLength is not an integer, the length does not match a valid
            // base64 content. That can happen if:
            // - the input is not a base64 content
            // - the input is *almost* a base64 content, with a extra chars at the
            // beginning or at the end
            // - the input uses a base64 variant (base64url for example)
            throw new Error('Invalid base64 input, bad content length.');
        }
        const output = new Uint8Array(totalLength | 0);
        while (i < input.length) {
            enc1 = this.keyStr.indexOf(input.charAt(i++));
            enc2 = this.keyStr.indexOf(input.charAt(i++));
            enc3 = this.keyStr.indexOf(input.charAt(i++));
            enc4 = this.keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;
            output[resultIndex++] = chr1;
            if (enc3 !== 64) {
                output[resultIndex++] = chr2;
            }
            if (enc4 !== 64) {
                output[resultIndex++] = chr3;
            }
        }
        return output;
    }
}
/**
 * @private
 */
class WrapPosition {
    constructor(x, width) {
        this.x = 0;
        this.width = 0;
        this.x = x;
        this.width = width;
    }
    get right() {
        return this.x + this.width;
    }
}

/**
 * @private
 */
class WStyle {
}
/**
 * @private
 */
class WParagraphStyle extends WStyle {
    constructor(node) {
        super();
        this.ownerBase = node;
        this.paragraphFormat = new WParagraphFormat(this);
        this.characterFormat = new WCharacterFormat(this);
    }
    destroy() {
        this.characterFormat.destroy();
        this.paragraphFormat.destroy();
    }
    copyStyle(paraStyle) {
        this.name = paraStyle.name;
        this.ownerBase = paraStyle.ownerBase;
        this.type = paraStyle.type;
        this.next = paraStyle.next;
        this.basedOn = paraStyle.basedOn;
        this.link = paraStyle.link;
        this.characterFormat.copyFormat(paraStyle.characterFormat);
        this.paragraphFormat.copyFormat(paraStyle.paragraphFormat);
    }
}
/**
 * @private
 */
class WCharacterStyle extends WStyle {
    constructor(node) {
        super();
        this.ownerBase = node;
        this.characterFormat = new WCharacterFormat(this);
    }
    destroy() {
        this.characterFormat.destroy();
    }
    copyStyle(charStyle) {
        this.name = charStyle.name;
        this.ownerBase = charStyle.ownerBase;
        this.type = charStyle.type;
        this.next = charStyle.next;
        this.basedOn = charStyle.basedOn;
        this.characterFormat.copyFormat(charStyle.characterFormat);
    }
}
/**
 * @private
 */
class WStyles {
    constructor() {
        this.collection = [];
        /* eslint-enable @typescript-eslint/no-explicit-any */
    }
    get length() {
        return this.collection.length;
    }
    remove(item) {
        this.collection = this.collection.filter((a) => (a.name !== item.name));
    }
    push(item) {
        if (item != null && item !== undefined) {
            this.collection.push(item);
        }
        return 1;
    }
    getItem(index) {
        if (this.collection.length > index) {
            return this.collection[index];
        }
        return null;
    }
    indexOf(item) {
        return this.collection.indexOf(item);
    }
    contains(item) {
        const index = this.collection.indexOf(item);
        return index > -1 && index < this.collection.length;
    }
    clear() {
        while (this.collection.length > 0) {
            this.collection.pop();
        }
    }
    findByName(name, type) {
        let returnStyle;
        for (const value of this.collection) {
            if (value.name === name) {
                returnStyle = value;
                if (!isNullOrUndefined(type) && value.type === type) {
                    returnStyle = value;
                }
            }
        }
        return returnStyle;
    }
    getStyleNames(type) {
        return this.collection.filter((a) => (a.type === type)).map((a) => {
            return a.name;
        });
    }
    /* eslint-disable @typescript-eslint/no-explicit-any */
    getStyles(type) {
        const styles = this.collection.filter((a) => (a.type === type)).map((a) => {
            return a;
        });
        const styleObjects = [];
        for (const style of styles) {
            const returnStyle = {};
            const returnStyleObject = {};
            returnStyleObject.characterFormat = {};
            HelperMethods.writeCharacterFormat(returnStyleObject.characterFormat, true, style.characterFormat);
            returnStyle.name = style.name;
            returnStyle.style = JSON.stringify(returnStyleObject);
            styleObjects.push(returnStyle);
        }
        return styleObjects;
    }
}

/* eslint-disable */
/**
 * @private
 */
class WShading {
    constructor(node) {
        this.uniqueShadingFormat = undefined;
        this.ownerBase = undefined;
        this.ownerBase = node;
    }
    get backgroundColor() {
        return this.getPropertyValue('backgroundColor');
    }
    set backgroundColor(value) {
        this.setPropertyValue('backgroundColor', value);
    }
    get foregroundColor() {
        return this.getPropertyValue('foregroundColor');
    }
    set foregroundColor(value) {
        this.setPropertyValue('foregroundColor', value);
    }
    get textureStyle() {
        return this.getPropertyValue('textureStyle');
    }
    set textureStyle(value) {
        this.setPropertyValue('textureStyle', value);
    }
    getPropertyValue(property) {
        const hasValue = this.hasValue(property);
        if (hasValue) {
            const propertyType = WUniqueFormat.getPropertyType(WShading.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueShadingFormat) && this.uniqueShadingFormat.propertiesHash.containsKey(propertyType)) {
                return this.uniqueShadingFormat.propertiesHash.get(propertyType);
            }
        }
        return WShading.getPropertyDefaultValue(property);
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WShading.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueShadingFormat)) {
            this.initializeUniqueShading(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueShadingFormat.uniqueFormatType, property);
            if (this.uniqueShadingFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueShadingFormat.propertiesHash.get(propertyType) === value) {
                //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueShadingFormat = WShading.uniqueShadingFormats.updateUniqueFormat(this.uniqueShadingFormat, property, value);
        }
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        switch (property) {
            case 'backgroundColor':
                value = 'empty';
                break;
            case 'foregroundColor':
                value = 'empty';
                break;
            case 'textureStyle':
                value = 'TextureNone';
                break;
        }
        return value;
    }
    initializeUniqueShading(property, propValue) {
        const uniqueShadingTemp = new Dictionary();
        this.addUniqueShading('backgroundColor', property, propValue, uniqueShadingTemp);
        this.addUniqueShading('foregroundColor', property, propValue, uniqueShadingTemp);
        this.addUniqueShading('textureStyle', property, propValue, uniqueShadingTemp);
        this.uniqueShadingFormat = WShading.uniqueShadingFormats.addUniqueFormat(uniqueShadingTemp, WShading.uniqueFormatType);
    }
    addUniqueShading(property, modifiedProperty, propValue, uniqueShadingTemp) {
        const propertyType = WUniqueFormat.getPropertyType(WShading.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueShadingTemp.add(propertyType, propValue);
        }
        else {
            uniqueShadingTemp.add(propertyType, WShading.getPropertyDefaultValue(property));
        }
    }
    destroy() {
        if (!isNullOrUndefined(this.uniqueShadingFormat)) {
            WShading.uniqueShadingFormats.remove(this.uniqueShadingFormat);
        }
        this.uniqueShadingFormat = undefined;
    }
    cloneFormat() {
        const shading = new WShading(undefined);
        shading.backgroundColor = this.backgroundColor;
        shading.foregroundColor = this.foregroundColor;
        shading.textureStyle = this.textureStyle;
        return shading;
    }
    copyFormat(shading) {
        if (!isNullOrUndefined(shading) && !isNullOrUndefined(shading.uniqueShadingFormat)) {
            this.backgroundColor = shading.backgroundColor;
            this.foregroundColor = shading.foregroundColor;
            this.textureStyle = shading.textureStyle;
        }
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueShadingFormat)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueShadingFormat.uniqueFormatType, property);
            return this.uniqueShadingFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    static clear() {
        this.uniqueShadingFormats.clear();
    }
}
WShading.uniqueShadingFormats = new WUniqueFormats();
WShading.uniqueFormatType = 5;

/**
 * @private
 */
class WTableFormat {
    constructor(owner) {
        this.uniqueTableFormat = undefined;
        this.borders = new WBorders(this);
        this.shading = new WShading(this);
        this.ownerBase = undefined;
        this.ownerBase = owner;
        this.assignTableMarginValue(5.4, 0, 5.4, 0);
    }
    get allowAutoFit() {
        return this.getPropertyValue('allowAutoFit');
    }
    set allowAutoFit(value) {
        this.setPropertyValue('allowAutoFit', value);
    }
    get cellSpacing() {
        return this.getPropertyValue('cellSpacing');
    }
    set cellSpacing(value) {
        if (value < 0 || value > 264.6) {
            throw new RangeError('The measurement must be between 0 px and 264.6 px.');
        }
        this.setPropertyValue('cellSpacing', value);
    }
    get leftMargin() {
        return this.getPropertyValue('leftMargin');
    }
    set leftMargin(value) {
        this.setPropertyValue('leftMargin', value);
    }
    get topMargin() {
        return this.getPropertyValue('topMargin');
    }
    set topMargin(value) {
        this.setPropertyValue('topMargin', value);
    }
    get rightMargin() {
        return this.getPropertyValue('rightMargin');
    }
    set rightMargin(value) {
        this.setPropertyValue('rightMargin', value);
    }
    get bottomMargin() {
        return this.getPropertyValue('bottomMargin');
    }
    set bottomMargin(value) {
        this.setPropertyValue('bottomMargin', value);
    }
    get tableAlignment() {
        return this.getPropertyValue('tableAlignment');
    }
    set tableAlignment(value) {
        this.setPropertyValue('tableAlignment', value);
    }
    get leftIndent() {
        return this.getPropertyValue('leftIndent');
    }
    set leftIndent(value) {
        if (value < -1440 || value > 1440) {
            throw new RangeError('The measurement must be between -1440 px and 1440 px.');
        }
        this.setPropertyValue('leftIndent', value);
    }
    get preferredWidth() {
        return this.getPropertyValue('preferredWidth');
    }
    set preferredWidth(value) {
        this.setPropertyValue('preferredWidth', value);
    }
    get preferredWidthType() {
        return this.getPropertyValue('preferredWidthType');
    }
    set preferredWidthType(value) {
        this.setPropertyValue('preferredWidthType', value);
    }
    get bidi() {
        return this.getPropertyValue('bidi');
    }
    set bidi(value) {
        this.setPropertyValue('bidi', value);
    }
    get horizontalPositionAbs() {
        return this.getPropertyValue('horizontalPositionAbs');
    }
    set horizontalPositionAbs(value) {
        this.setPropertyValue('horizontalPositionAbs', value);
    }
    get horizontalPosition() {
        return this.getPropertyValue('horizontalPosition');
    }
    set horizontalPosition(value) {
        this.setPropertyValue('horizontalPosition', value);
    }
    /* eslint-disable */
    getPropertyValue(property) {
        const hasValue = this.hasValue(property);
        if (hasValue) {
            const propertyType = WUniqueFormat.getPropertyType(WTableFormat.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueTableFormat) && this.uniqueTableFormat.propertiesHash.containsKey(propertyType)) {
                return this.uniqueTableFormat.propertiesHash.get(propertyType);
            }
        }
        return WTableFormat.getPropertyDefaultValue(property);
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WTableFormat.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueTableFormat)) {
            this.initializeUniqueTableFormat(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueTableFormat.uniqueFormatType, property);
            if (this.uniqueTableFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueTableFormat.propertiesHash.get(propertyType) === value) {
                //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueTableFormat = WTableFormat.uniqueTableFormats.updateUniqueFormat(this.uniqueTableFormat, property, value);
        }
    }
    initializeUniqueTableFormat(property, propValue) {
        const uniqueTableFormatTemp = new Dictionary();
        this.addUniqueTableFormat('allowAutoFit', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('cellSpacing', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('leftMargin', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('topMargin', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('bottomMargin', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('rightMargin', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('leftIndent', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('tableAlignment', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('preferredWidth', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('preferredWidthType', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('bidi', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('horizontalPositionAbs', property, propValue, uniqueTableFormatTemp);
        this.addUniqueTableFormat('horizontalPosition', property, propValue, uniqueTableFormatTemp);
        this.uniqueTableFormat = WTableFormat.uniqueTableFormats.addUniqueFormat(uniqueTableFormatTemp, WTableFormat.uniqueFormatType);
    }
    addUniqueTableFormat(property, modifiedProperty, propValue, uniqueTableFormatTemp) {
        let propertyType;
        propertyType = WUniqueFormat.getPropertyType(WTableFormat.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueTableFormatTemp.add(propertyType, propValue);
        }
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        switch (property) {
            case 'allowAutoFit':
                value = false;
                break;
            case 'cellSpacing':
                value = 0;
                break;
            case 'leftMargin':
                value = 5.4;
                break;
            case 'topMargin':
                value = 0;
                break;
            case 'bottomMargin':
                value = 0;
                break;
            case 'rightMargin':
                value = 5.4;
                break;
            case 'leftIndent':
                value = 0;
                break;
            case 'tableAlignment':
                value = 'Left';
                break;
            case 'preferredWidth':
                value = 0;
                break;
            case 'preferredWidthType':
                value = 'Point';
                break;
            case 'bidi':
                value = false;
                break;
            case 'horizontalPositionAbs':
                value = null;
                break;
            case 'horizontalPosition':
                value = 0;
                break;
        }
        return value;
    }
    assignTableMarginValue(left, top, right, bottom) {
        this.leftMargin = left;
        this.topMargin = top;
        this.rightMargin = right;
        this.bottomMargin = bottom;
    }
    initializeTableBorders() {
        this.borders.left.lineStyle = 'Single';
        this.borders.left.lineWidth = 0.5;
        this.borders.right.lineStyle = 'Single';
        this.borders.right.lineWidth = 0.5;
        this.borders.top.lineStyle = 'Single';
        this.borders.top.lineWidth = 0.5;
        this.borders.bottom.lineStyle = 'Single';
        this.borders.bottom.lineWidth = 0.5;
        this.borders.horizontal.lineStyle = 'Single';
        this.borders.horizontal.lineWidth = 0.5;
        this.borders.vertical.lineStyle = 'Single';
        this.borders.vertical.lineWidth = 0.5;
    }
    destroy() {
        if (!isNullOrUndefined(this.borders)) {
            this.borders.destroy();
        }
        if (!isNullOrUndefined(this.shading)) {
            this.shading.destroy();
        }
        if (!isNullOrUndefined(this.uniqueTableFormat)) {
            WTableFormat.uniqueTableFormats.remove(this.uniqueTableFormat);
        }
        this.uniqueTableFormat = undefined;
        this.borders = undefined;
        this.shading = undefined;
    }
    cloneFormat() {
        const tableFormat = new WTableFormat(undefined);
        tableFormat.leftIndent = this.leftIndent;
        tableFormat.tableAlignment = this.tableAlignment;
        tableFormat.cellSpacing = this.cellSpacing;
        tableFormat.leftMargin = this.leftMargin;
        tableFormat.rightMargin = this.rightMargin;
        tableFormat.topMargin = this.topMargin;
        tableFormat.bottomMargin = this.bottomMargin;
        tableFormat.preferredWidth = this.preferredWidth;
        tableFormat.preferredWidthType = this.preferredWidthType;
        tableFormat.horizontalPositionAbs = this.horizontalPositionAbs;
        tableFormat.horizontalPosition = this.horizontalPosition;
        tableFormat.borders = isNullOrUndefined(this.borders) ? undefined : this.borders.cloneFormat();
        tableFormat.shading = isNullOrUndefined(this.shading) ? undefined : this.shading.cloneFormat();
        tableFormat.bidi = this.bidi;
        tableFormat.allowAutoFit = this.allowAutoFit;
        return tableFormat;
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueTableFormat)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueTableFormat.uniqueFormatType, property);
            return this.uniqueTableFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    copyFormat(format) {
        if (!isNullOrUndefined(format)) {
            if (!isNullOrUndefined(format.uniqueTableFormat)) {
                this.cellSpacing = format.cellSpacing;
                this.leftMargin = format.leftMargin;
                this.topMargin = format.topMargin;
                this.rightMargin = format.rightMargin;
                this.bottomMargin = format.bottomMargin;
                this.leftIndent = format.leftIndent;
                this.tableAlignment = format.tableAlignment;
                this.preferredWidth = format.preferredWidth;
                this.preferredWidthType = format.preferredWidthType;
                this.bidi = format.bidi;
                this.allowAutoFit = format.allowAutoFit;
                this.horizontalPosition = format.horizontalPosition;
                this.horizontalPositionAbs = format.horizontalPositionAbs;
            }
            if (!isNullOrUndefined(format.borders)) {
                this.borders = new WBorders(this);
                this.borders.copyFormat(format.borders);
            }
            if (!isNullOrUndefined(format.shading)) {
                this.shading = new WShading(this);
                this.shading.copyFormat(format.shading);
            }
        }
    }
    static clear() {
        this.uniqueTableFormats.clear();
    }
}
WTableFormat.uniqueTableFormats = new WUniqueFormats();
WTableFormat.uniqueFormatType = 8;

/* eslint-disable */
/**
 * @private
 */
class WCellFormat {
    constructor(node) {
        this.uniqueCellFormat = undefined;
        this.borders = new WBorders(this);
        this.shading = new WShading(this);
        this.ownerBase = node;
        this.borders = new WBorders(this);
        this.shading = new WShading(this);
    }
    get leftMargin() {
        return this.getPropertyValue('leftMargin');
    }
    set leftMargin(value) {
        this.setPropertyValue('leftMargin', value);
    }
    get rightMargin() {
        return this.getPropertyValue('rightMargin');
    }
    set rightMargin(value) {
        this.setPropertyValue('rightMargin', value);
    }
    get topMargin() {
        return this.getPropertyValue('topMargin');
    }
    set topMargin(value) {
        this.setPropertyValue('topMargin', value);
    }
    get bottomMargin() {
        return this.getPropertyValue('bottomMargin');
    }
    set bottomMargin(value) {
        this.setPropertyValue('bottomMargin', value);
    }
    get cellWidth() {
        return this.getPropertyValue('cellWidth');
    }
    set cellWidth(value) {
        this.setPropertyValue('cellWidth', value);
    }
    get columnSpan() {
        return this.getPropertyValue('columnSpan');
    }
    set columnSpan(value) {
        this.setPropertyValue('columnSpan', value);
    }
    get rowSpan() {
        return this.getPropertyValue('rowSpan');
    }
    set rowSpan(value) {
        this.setPropertyValue('rowSpan', value);
    }
    get preferredWidth() {
        return this.getPropertyValue('preferredWidth');
    }
    set preferredWidth(value) {
        this.setPropertyValue('preferredWidth', value);
    }
    get verticalAlignment() {
        return this.getPropertyValue('verticalAlignment');
    }
    set verticalAlignment(value) {
        this.setPropertyValue('verticalAlignment', value);
    }
    get preferredWidthType() {
        return this.getPropertyValue('preferredWidthType');
    }
    set preferredWidthType(value) {
        this.setPropertyValue('preferredWidthType', value);
    }
    getPropertyValue(property) {
        const hasValue = this.hasValue(property);
        if (hasValue) {
            const propertyType = WUniqueFormat.getPropertyType(WCellFormat.uniqueFormatType, property);
            if (!isNullOrUndefined(this.uniqueCellFormat) && this.uniqueCellFormat.propertiesHash.containsKey(propertyType)) {
                return this.uniqueCellFormat.propertiesHash.get(propertyType);
            }
        }
        return WCellFormat.getPropertyDefaultValue(property);
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WCellFormat.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueCellFormat)) {
            this.initializeUniqueCellFormat(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueCellFormat.uniqueFormatType, property);
            if (this.uniqueCellFormat.propertiesHash.containsKey(propertyType) &&
                this.uniqueCellFormat.propertiesHash.get(propertyType) === value) {
                //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueCellFormat = WCellFormat.uniqueCellFormats.updateUniqueFormat(this.uniqueCellFormat, property, value);
        }
    }
    initializeUniqueCellFormat(property, propValue) {
        const uniqueCellFormatTemp = new Dictionary();
        this.addUniqueCellFormat('leftMargin', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('topMargin', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('bottomMargin', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('rightMargin', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('cellWidth', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('columnSpan', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('rowSpan', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('preferredWidth', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('verticalAlignment', property, propValue, uniqueCellFormatTemp);
        this.addUniqueCellFormat('preferredWidthType', property, propValue, uniqueCellFormatTemp);
        this.uniqueCellFormat = WCellFormat.uniqueCellFormats.addUniqueFormat(uniqueCellFormatTemp, WCellFormat.uniqueFormatType);
    }
    addUniqueCellFormat(property, modifiedProperty, propValue, uniqueCellFormatTemp) {
        const propertyType = WUniqueFormat.getPropertyType(WCellFormat.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueCellFormatTemp.add(propertyType, propValue);
        }
    }
    static getPropertyDefaultValue(property) {
        let value = undefined;
        switch (property) {
            case 'leftMargin':
                value = undefined;
                break;
            case 'topMargin':
                value = undefined;
                break;
            case 'bottomMargin':
                value = undefined;
                break;
            case 'rightMargin':
                value = undefined;
                break;
            case 'cellWidth':
                value = 0;
                break;
            case 'columnSpan':
                value = 1;
                break;
            case 'rowSpan':
                value = 1;
                break;
            case 'preferredWidth':
                value = 0;
                break;
            case 'verticalAlignment':
                value = 'Top';
                break;
            case 'preferredWidthType':
                value = 'Point';
                break;
        }
        return value;
    }
    containsMargins() {
        return (!isNullOrUndefined(this.leftMargin)
            || !isNullOrUndefined(this.rightMargin)
            || !isNullOrUndefined(this.bottomMargin)
            || !isNullOrUndefined(this.topMargin));
    }
    destroy() {
        if (!isNullOrUndefined(this.borders)) {
            this.borders.destroy();
        }
        if (!isNullOrUndefined(this.shading)) {
            this.shading.destroy();
        }
        if (!isNullOrUndefined(this.uniqueCellFormat)) {
            WCellFormat.uniqueCellFormats.remove(this.uniqueCellFormat);
        }
        this.uniqueCellFormat = undefined;
        this.borders = undefined;
        this.shading = undefined;
    }
    cloneFormat() {
        const format = new WCellFormat(undefined);
        format.verticalAlignment = this.verticalAlignment;
        format.leftMargin = this.leftMargin;
        format.rightMargin = this.rightMargin;
        format.topMargin = this.topMargin;
        format.bottomMargin = this.bottomMargin;
        format.preferredWidth = this.preferredWidth;
        format.preferredWidthType = this.preferredWidthType;
        format.cellWidth = this.cellWidth;
        format.borders = isNullOrUndefined(this.borders) ? undefined : this.borders.cloneFormat();
        format.shading = isNullOrUndefined(this.shading) ? undefined : this.shading.cloneFormat();
        return format;
    }
    hasValue(property) {
        if (!isNullOrUndefined(this.uniqueCellFormat)) {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueCellFormat.uniqueFormatType, property);
            return this.uniqueCellFormat.propertiesHash.containsKey(propertyType);
        }
        return false;
    }
    copyFormat(format) {
        if (!isNullOrUndefined(format)) {
            if (!isNullOrUndefined(format.uniqueCellFormat)) {
                this.cellWidth = format.cellWidth;
                this.leftMargin = format.leftMargin;
                this.topMargin = format.topMargin;
                this.rightMargin = format.rightMargin;
                this.bottomMargin = format.bottomMargin;
                this.preferredWidth = format.preferredWidth;
                this.columnSpan = format.columnSpan;
                this.rowSpan = format.rowSpan;
                this.preferredWidthType = format.preferredWidthType;
                this.verticalAlignment = format.verticalAlignment;
            }
            if (!isNullOrUndefined(format.shading)) {
                this.shading = new WShading(this);
                this.shading.copyFormat(format.shading);
            }
            if (!isNullOrUndefined(format.borders)) {
                this.borders = new WBorders(this);
                this.borders.copyFormat(format.borders);
            }
        }
    }
    static clear() {
        this.uniqueCellFormats.clear();
    }
}
WCellFormat.uniqueCellFormats = new WUniqueFormats();
WCellFormat.uniqueFormatType = 4;

/**
 * Formats Modules
 */

/**
 * @private
 */
class WAbstractList {
    constructor() {
        this.abstractListIdIn = -1;
        this.levels = [];
    }
    get abstractListId() {
        return this.abstractListIdIn;
    }
    set abstractListId(abstractListId) {
        this.abstractListIdIn = abstractListId;
    }
    destroy() {
        if (!isNullOrUndefined(this.levels)) {
            for (let i = 0; i < this.levels.length; i++) {
                const listLevel = this.levels[i];
                listLevel.destroy();
                this.levels.splice(this.levels.indexOf(listLevel), 1);
                i--;
            }
            this.levels = [];
        }
        this.levels = undefined;
    }
    clone() {
        const absList = new WAbstractList();
        for (let i = 0; i < this.levels.length; i++) {
            absList.levels.push(this.levels[i].clone(absList));
        }
        return absList;
    }
}

/**
 * @private
 */
class WListLevel {
    constructor(node) {
        this.uniqueListLevel = undefined;
        this.paragraphFormat = undefined;
        this.characterFormat = undefined;
        if (node instanceof WAbstractList) {
            this.ownerBase = node;
        }
        else {
            this.ownerBase = node;
        }
        this.characterFormat = new WCharacterFormat(undefined);
        this.paragraphFormat = new WParagraphFormat(undefined);
    }
    get listLevelPattern() {
        return this.getPropertyValue('listLevelPattern');
    }
    set listLevelPattern(listLevelPattern) {
        this.setPropertyValue('listLevelPattern', listLevelPattern);
    }
    get followCharacter() {
        return this.getPropertyValue('followCharacter');
    }
    set followCharacter(followCharacter) {
        this.setPropertyValue('followCharacter', followCharacter);
    }
    get startAt() {
        return this.getPropertyValue('startAt');
    }
    set startAt(startAt) {
        this.setPropertyValue('startAt', startAt);
    }
    get numberFormat() {
        return this.getPropertyValue('numberFormat');
    }
    set numberFormat(numberFormat) {
        this.setPropertyValue('numberFormat', numberFormat);
    }
    get restartLevel() {
        return this.getPropertyValue('restartLevel');
    }
    set restartLevel(restartLevel) {
        this.setPropertyValue('restartLevel', restartLevel);
    }
    /* eslint-disable */
    getPropertyValue(property) {
        const propertyType = WUniqueFormat.getPropertyType(WListLevel.uniqueFormatType, property);
        if (!isNullOrUndefined(this.uniqueListLevel) && this.uniqueListLevel.propertiesHash.containsKey(propertyType)) {
            return this.uniqueListLevel.propertiesHash.get(propertyType);
        }
        return WListLevel.getPropertyDefaultValue(property);
    }
    setPropertyValue(property, value) {
        if (isNullOrUndefined(value) || value === '') {
            value = WListLevel.getPropertyDefaultValue(property);
        }
        if (isNullOrUndefined(this.uniqueListLevel)) {
            this.initializeUniqueWListLevel(property, value);
        }
        else {
            const propertyType = WUniqueFormat.getPropertyType(this.uniqueListLevel.uniqueFormatType, property);
            if (this.uniqueListLevel.propertiesHash.containsKey(propertyType) &&
                this.uniqueListLevel.propertiesHash.get(propertyType) === value) { //Do nothing, since no change in property value and return
                return;
            }
            this.uniqueListLevel = WListLevel.uniqueListLevels.updateUniqueFormat(this.uniqueListLevel, property, value);
        }
    }
    initializeUniqueWListLevel(property, propValue) {
        const uniqueListLevelTemp = new Dictionary();
        this.addUniqueWListLevel('listLevelPattern', property, propValue, uniqueListLevelTemp);
        this.addUniqueWListLevel('startAt', property, propValue, uniqueListLevelTemp);
        this.addUniqueWListLevel('followCharacter', property, propValue, uniqueListLevelTemp);
        this.addUniqueWListLevel('numberFormat', property, propValue, uniqueListLevelTemp);
        this.addUniqueWListLevel('restartLevel', property, propValue, uniqueListLevelTemp);
        this.uniqueListLevel = WListLevel.uniqueListLevels.addUniqueFormat(uniqueListLevelTemp, WListLevel.uniqueFormatType);
    }
    addUniqueWListLevel(property, modifiedProperty, propValue, uniqueCharFormatTemp) {
        let propertyType;
        propertyType = WUniqueFormat.getPropertyType(WListLevel.uniqueFormatType, property);
        if (property === modifiedProperty) {
            uniqueCharFormatTemp.add(propertyType, propValue);
        }
        else {
            uniqueCharFormatTemp.add(propertyType, WListLevel.getPropertyDefaultValue(property));
        }
    }
    static getPropertyDefaultValue(property) {
        /* eslint-disable */
        let value = undefined;
        switch (property) {
            case 'listLevelPattern':
                value = 'Arabic';
                break;
            case 'startAt':
                value = 0;
                break;
            case 'followCharacter':
                value = 'Tab';
                break;
            case 'numberFormat':
                value = '';
                break;
            case 'restartLevel':
                value = 0;
                break;
        }
        return value;
        /* eslint-enable */
    }
    destroy() {
        if (!isNullOrUndefined(this.characterFormat)) {
            this.characterFormat.destroy();
        }
        if (!isNullOrUndefined(this.paragraphFormat)) {
            this.paragraphFormat.destroy();
        }
        if (!isNullOrUndefined(this.uniqueListLevel)) {
            WListLevel.uniqueListLevels.remove(this.uniqueListLevel);
        }
        this.uniqueListLevel = undefined;
        this.characterFormat = undefined;
        this.paragraphFormat = undefined;
    }
    static clear() {
        this.uniqueListLevels.clear();
    }
    clone(node) {
        const listLevel = new WListLevel(node);
        listLevel.paragraphFormat = this.paragraphFormat.cloneFormat();
        listLevel.characterFormat = this.characterFormat.cloneFormat();
        if (this.uniqueListLevel) {
            listLevel.uniqueListLevel = this.uniqueListLevel;
            listLevel.uniqueListLevel.referenceCount++;
        }
        return listLevel;
    }
}
WListLevel.dotBullet = String.fromCharCode(61623);
WListLevel.squareBullet = String.fromCharCode(61607); //Symbol font \u25aa.
WListLevel.arrowBullet = String.fromCharCode(10148);
WListLevel.circleBullet = String.fromCharCode(61551) + String.fromCharCode(32);
WListLevel.uniqueListLevels = new WUniqueFormats();
WListLevel.uniqueFormatType = 9;

/* eslint-disable */
// Check box character is rendered smaller when compared to MS Word
// So, mutiplied the font side by below factor to render check box character large.
const CHECK_BOX_FACTOR = 1.4;
/**
 * @private
 */
class Layout {
    constructor(documentHelper) {
        /**
         * @private
         */
        this.islayoutFootnote = false;
        /**
         * @private
         */
        this.allowLayout = true;
        /**
         * @private
         */
        this.footHeight = 0;
        /**
         * @private
         */
        this.isfootMove = false;
        /**
         * @private
         */
        this.footnoteHeight = 0;
        /**
         * @private
         */
        this.isTableFootNote = false;
        /**
         * @private
         */
        this.isRelayout = false;
        /**
         * @private
         */
        this.isRelayoutneed = false;
        /**
         * @private
         */
        this.isOverlapFloatTable = false;
        this.isInitialLoad = true;
        this.fieldBegin = undefined;
        this.maxTextHeight = 0;
        this.maxBaseline = 0;
        this.maxTextBaseline = 0;
        this.isFieldCode = false;
        this.isRtlFieldCode = false;
        this.isRTLLayout = false;
        this.currentCell = undefined;
        this.isFootnoteContentChanged = false;
        this.isEndnoteContentChanged = false;
        this.keepWithNext = false;
        this.is2013Justification = false;
        this.nextElementToLayout = undefined;
        this.isLayoutWhole = false;
        /**
         * @private
         */
        this.isBidiReLayout = false;
        /**
         * @private
         */
        this.defaultTabWidthPixel = 48;
        /**
         * @private
         */
        this.isRelayoutFootnote = false;
        this.isRelayoutOverlap = false;
        this.isWrapText = false;
        this.isYPositionUpdated = false;
        this.isXPositionUpdated = false;
        this.hasFloatingElement = false;
        this.isFootNoteLayoutStart = false;
        this.wrapPosition = [];
        this.shiftedFloatingItemsFromTable = [];
        this.documentHelper = documentHelper;
    }
    isSameStyle(currentParagraph, isAfterSpacing) {
        let nextOrPrevSibling = undefined;
        if (isAfterSpacing) {
            if (currentParagraph.nextWidget instanceof ParagraphWidget) {
                nextOrPrevSibling = currentParagraph.nextWidget;
            }
        }
        else {
            if (currentParagraph.previousWidget instanceof ParagraphWidget) {
                nextOrPrevSibling = currentParagraph.previousWidget;
            }
        }
        if (isNullOrUndefined(nextOrPrevSibling)) {
            return false;
        }
        if (currentParagraph.paragraphFormat.baseStyle === nextOrPrevSibling.paragraphFormat.baseStyle) {
            if (currentParagraph.paragraphFormat.listFormat.listId >= 0 && nextOrPrevSibling.paragraphFormat.listFormat.listId >= 0) {
                if (!currentParagraph.paragraphFormat.contextualSpacing) {
                    if (isAfterSpacing && currentParagraph.paragraphFormat.spaceAfterAuto) {
                        return true;
                    }
                    else if (!isAfterSpacing && currentParagraph.paragraphFormat.spaceBeforeAuto) {
                        return true;
                    }
                }
            }
            return currentParagraph.paragraphFormat.contextualSpacing;
        }
        return false;
    }
    get viewer() {
        return this.documentHelper.owner.viewer;
    }
    layout() {
        // Todo: Need to handle complete document layout(relayout).
        //const page: Page = this.documentHelper.pages[0];
        //const body: BodyWidget = page.bodyWidgets[0];
    }
    /**
     * Releases un-managed and - optionally - managed resources.
     *
     * @returns {void}
     */
    destroy() {
        this.documentHelper = undefined;
        this.value = undefined;
        this.allowLayout = undefined;
        this.isInitialLoad = undefined;
        this.fieldBegin = undefined;
        this.maxTextHeight = undefined;
        this.maxBaseline = undefined;
        this.maxTextBaseline = undefined;
        this.isFieldCode = undefined;
        this.footnoteHeight = undefined;
    }
    layoutItems(sections, isReLayout) {
        let page;
        for (let i = 0; i < sections.length; i++) {
            const section = sections[i];
            const lastpage = this.documentHelper.pages[this.documentHelper.pages.length - 1];
            /* eslint-disable-next-line max-len */
            if (i > 0 && sections[i - 1].lastChild.isEndsWithPageBreak && lastpage.bodyWidgets[0].childWidgets.length === 0) {
                this.documentHelper.pages.splice(this.documentHelper.pages.length - 1, 1);
            }
            page = this.viewer.createNewPage(section);
            this.addBodyWidget(this.viewer.clientActiveArea, section);
            if (this.documentHelper.pages.length > 1) {
                let pageIndex = 0;
                for (let i = 0; i < this.documentHelper.pages.length; i++) {
                    const prevPage = this.documentHelper.pages[i];
                    const prevSectionIndex = prevPage.sectionIndex;
                    const index = section.index;
                    if (prevSectionIndex > index || prevPage === page) {
                        break;
                    }
                    pageIndex++;
                }
                if (pageIndex < this.documentHelper.pages.length - 1) {
                    this.documentHelper.insertPage(pageIndex, page);
                }
            }
            this.layoutSection(section, 0);
        }
        if (!isReLayout) {
            this.layoutComments(this.documentHelper.comments);
        }
        this.updateFieldElements();
        if (this.documentHelper.owner.layoutType === 'Pages') {
            this.layoutEndNoteElement();
        }
        /* tslint:disable:align */
        setTimeout(() => {
            if (this.documentHelper) {
                this.documentHelper.isScrollHandler = true;
                if (this.documentHelper.owner.isSpellCheck && this.documentHelper.owner.spellChecker.enableOptimizedSpellCheck) {
                    this.documentHelper.triggerElementsOnLoading = true;
                }
                this.documentHelper.clearContent();
                this.viewer.updateScrollBars();
                this.documentHelper.isScrollHandler = false;
                this.isInitialLoad = false;
            }
        }, 50);
    }
    /**
     * @private
     */
    layoutComments(comments) {
        if (!isNullOrUndefined(comments)) {
            this.viewer.owner.commentReviewPane.layoutComments();
        }
    }
    layoutSection(section, index) {
        let block = section.firstChild;
        let nextBlock;
        let prevBlock;
        do {
            if (block instanceof TableWidget && block.tableFormat.preferredWidthType === 'Auto'
                && !block.tableFormat.allowAutoFit) {
                block.calculateGrid();
            }
            this.viewer.updateClientAreaForBlock(block, true);
            nextBlock = this.layoutBlock(block, index);
            index = 0;
            this.viewer.updateClientAreaForBlock(block, false);
            if (prevBlock && isNullOrUndefined(prevBlock.nextWidget) && prevBlock.bodyWidget
                && prevBlock.bodyWidget.page.footnoteWidget) {
                this.layoutfootNote(prevBlock.bodyWidget.page.footnoteWidget);
            }
            prevBlock = block;
            block = nextBlock;
            if (isNullOrUndefined(block) && prevBlock.bodyWidget.page.footnoteWidget) {
                this.layoutfootNote(prevBlock.bodyWidget.page.footnoteWidget);
            }
        } while (block);
    }
    layoutHeaderFooter(section, viewer, page) {
        //Header layout
        let headerFooterWidget = viewer.getCurrentPageHeaderFooter(section, true);
        if (headerFooterWidget) {
            if (headerFooterWidget.page) {
                const parentHeader = headerFooterWidget;
                headerFooterWidget = parentHeader.clone();
                headerFooterWidget.parentHeaderFooter = parentHeader;
            }
            this.clearBlockWidget(headerFooterWidget.childWidgets, true, true, true);
            const header = headerFooterWidget;
            header.page = page;
            header.height = 0;
            this.updateRevisionsToHeaderFooter(header, page);
            viewer.updateHFClientArea(section.sectionFormat, true);
            page.headerWidget = this.layoutHeaderFooterItems(viewer, header);
            //this.updateHeaderFooterToParent(header);
        }
        //Footer Layout
        headerFooterWidget = viewer.getCurrentPageHeaderFooter(section, false);
        if (headerFooterWidget) {
            if (headerFooterWidget.page) {
                const parentHeader = headerFooterWidget;
                headerFooterWidget = parentHeader.clone();
                headerFooterWidget.parentHeaderFooter = parentHeader;
            }
            this.clearBlockWidget(headerFooterWidget.childWidgets, true, true, true);
            const footer = headerFooterWidget;
            footer.page = page;
            footer.height = 0;
            viewer.updateHFClientArea(section.sectionFormat, false);
            this.updateRevisionsToHeaderFooter(footer, page);
            page.footerWidget = this.layoutHeaderFooterItems(viewer, footer);
        }
    }
    updateHeaderFooterToParent(node) {
        const sectionIndex = node.page.sectionIndex;
        const typeIndex = this.viewer.getHeaderFooter(node.headerFooterType);
        const clone = node.clone();
        this.documentHelper.headersFooters[sectionIndex][typeIndex] = clone;
        for (let j = 0; j < clone.childWidgets.length; j++) {
            const child = clone.childWidgets[j];
            if (child instanceof TableWidget) {
                this.clearTableWidget(child, false, true);
            }
        }
        return clone;
    }
    /* eslint-disable @typescript-eslint/no-explicit-any */
    updateRevisionsToHeaderFooter(clone, page) {
        const childWidge = clone.childWidgets;
        if (clone instanceof HeaderFooterWidget && childWidge.length > 0) {
            for (let i = 0; i < childWidge.length; i++) {
                if (childWidge[i].childWidgets.length > 0) {
                    const lineWidge = childWidge[i].childWidgets;
                    for (let j = 0; j < lineWidge.length; j++) {
                        const childrens = lineWidge[j].children;
                        if (childrens) {
                            for (let k = 0; k < childrens.length; k++) {
                                if (childrens[k].removedIds.length > 0) {
                                    const removeId = childrens[k].removedIds;
                                    for (let l = 0; l < removeId.length; l++) {
                                        const revision = this.documentHelper.revisionsInternal.get(removeId[l]);
                                        childrens[k].revisions[l] = revision;
                                        this.updateRevisionRange(revision, page);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    updateRevisionRange(revision, page) {
        for (let i = 0; i < revision.range.length; i++) {
            const inline = revision.range[i];
            if (!inline.line.paragraph.bodyWidget.page) {
                inline.line.paragraph.bodyWidget.page = page;
            }
        }
    }
    linkFieldInHeaderFooter(widget) {
        let firstChild = widget.firstChild;
        do {
            if (firstChild instanceof ParagraphWidget) {
                this.linkFieldInParagraph(firstChild);
            }
            else {
                this.linkFieldInTable(firstChild);
            }
            /* eslint-disable no-cond-assign */
        } while (firstChild = firstChild.nextWidget);
    }
    linkFieldInParagraph(widget) {
        for (let j = 0; j < widget.childWidgets.length; j++) {
            const line = widget.childWidgets[j];
            for (let i = 0; i < line.children.length; i++) {
                const element = line.children[i];
                if (element instanceof FieldElementBox && (element.fieldType !== 0 || (element.fieldType === 0 &&
                    this.documentHelper.fields.indexOf(element) === -1))) {
                    element.linkFieldCharacter(this.documentHelper);
                }
                if (element instanceof FieldTextElementBox &&
                    element.fieldBegin !== element.previousElement.fieldBegin) {
                    element.fieldBegin = element.previousElement.fieldBegin;
                }
                if (element instanceof ShapeElementBox) {
                    let firstBlock = element.textFrame.firstChild;
                    do {
                        if (firstBlock instanceof ParagraphWidget) {
                            this.linkFieldInParagraph(firstBlock);
                        }
                        else {
                            this.linkFieldInTable(firstBlock);
                        }
                        /* eslint-disable no-cond-assign */
                    } while (firstBlock = firstBlock.nextWidget);
                }
                else if (element instanceof CommentCharacterElementBox) {
                    let comment = this.getCommentById(element.commentId);
                    if (!isNullOrUndefined(comment)) {
                        if (element.commentType === 0) {
                            comment.commentStart = element;
                        }
                        else {
                            comment.commentEnd = element;
                        }
                        element.comment = comment;
                    }
                }
            }
        }
    }
    getCommentById(commentId) {
        for (let i = 0; i < this.documentHelper.comments.length; i++) {
            let comment = this.documentHelper.comments[i];
            if (comment.commentId === commentId) {
                return comment;
            }
        }
        return undefined;
    }
    linkFieldInTable(widget) {
        for (let i = 0; i < widget.childWidgets.length; i++) {
            const row = widget.childWidgets[i];
            for (let j = 0; j < row.childWidgets.length; j++) {
                const cell = row.childWidgets[j];
                for (let k = 0; k < cell.childWidgets.length; k++) {
                    const block = cell.childWidgets[k];
                    if (block instanceof ParagraphWidget) {
                        this.linkFieldInParagraph(block);
                    }
                    else {
                        this.linkFieldInTable(block);
                    }
                }
            }
        }
    }
    layoutHeaderFooterItems(viewer, widget) {
        this.viewer.updateClientAreaLocation(widget, viewer.clientActiveArea);
        if (widget.childWidgets.length === 0) {
            const pargaraph = new ParagraphWidget();
            const line = new LineWidget(pargaraph);
            pargaraph.childWidgets.push(line);
            widget.childWidgets.push(pargaraph);
            pargaraph.containerWidget = widget;
        }
        this.linkFieldInHeaderFooter(widget);
        for (let i = 0; i < widget.childWidgets.length; i++) {
            const block = widget.childWidgets[i];
            if (block instanceof TableWidget && block.tableFormat.preferredWidthType === 'Auto'
                && !block.tableFormat.allowAutoFit && !block.isGridUpdated) {
                block.calculateGrid();
            }
            viewer.updateClientAreaForBlock(block, true);
            this.layoutBlock(block, 0);
            viewer.updateClientAreaForBlock(block, false);
        }
        const type = widget.headerFooterType;
        if (type === 'OddFooter' || type === 'EvenFooter' || type === 'FirstPageFooter') {
            this.shiftChildLocation(viewer.clientArea.y - viewer.clientActiveArea.y, widget);
        }
        return widget;
    }
    shiftChildLocation(shiftTop, bodyWidget) {
        let widgetTop = bodyWidget.y + shiftTop;
        const footerMaxHeight = bodyWidget.page.boundingRectangle.height - (bodyWidget.page.boundingRectangle.height / 100) * 40;
        widgetTop = Math.max(widgetTop, footerMaxHeight);
        shiftTop = widgetTop - bodyWidget.y;
        let childTop = bodyWidget.y = widgetTop;
        for (let i = 0; i < bodyWidget.childWidgets.length; i++) {
            const childWidget = bodyWidget.childWidgets[i];
            if (childWidget instanceof ParagraphWidget) {
                const widget = childWidget.childWidgets[0];
                childWidget.x = childWidget.x;
                childWidget.y = i === 0 ? childWidget.y + shiftTop : childTop;
                childTop += childWidget.height;
                for (let j = 0; j < widget.children.length; j++) {
                    const element = widget.children[j];
                    if (element instanceof ShapeElementBox) {
                        element.y = childWidget.y + element.verticalPosition;
                    }
                }
            }
            else {
                this.shiftChildLocationForTableWidget(childWidget, shiftTop);
                childTop += childWidget.height;
            }
        }
    }
    shiftChildLocationForTableWidget(tableWidget, shiftTop) {
        tableWidget.y = tableWidget.y + shiftTop;
        for (let i = 0; i < tableWidget.childWidgets.length; i++) {
            const childWidget = tableWidget.childWidgets[i];
            if (childWidget instanceof TableRowWidget) {
                this.shiftChildLocationForTableRowWidget(childWidget, shiftTop);
            }
        }
    }
    shiftChildLocationForTableRowWidget(rowWidget, shiftTop) {
        rowWidget.y = rowWidget.y + shiftTop;
        for (let i = 0; i < rowWidget.childWidgets.length; i++) {
            this.shiftChildLocationForTableCellWidget(rowWidget.childWidgets[i], shiftTop);
        }
    }
    shiftChildLocationForTableCellWidget(cellWidget, shiftTop) {
        cellWidget.y = cellWidget.y + shiftTop;
        for (let i = 0; i < cellWidget.childWidgets.length; i++) {
            if (cellWidget.childWidgets[i] instanceof ParagraphWidget) {
                cellWidget.childWidgets[i].x = cellWidget.childWidgets[i].x;
                cellWidget.childWidgets[i].y = cellWidget.childWidgets[i].y + shiftTop;
            }
            else {
                this.shiftChildLocationForTableWidget(cellWidget.childWidgets[i], shiftTop);
            }
        }
    }
    layoutBlock(block, index) {
        let nextBlock;
        if (block instanceof ParagraphWidget) {
            nextBlock = this.layoutParagraph(block, index);
            const nextBlockToLayout = this.checkAndRelayoutPreviousOverlappingBlock(block);
            if (nextBlockToLayout) {
                nextBlock = nextBlockToLayout;
            }
        }
        else {
            nextBlock = this.layoutTable(block, index);
            this.checkAndRelayoutPreviousOverlappingBlock(block);
            this.updateTableYPositionBasedonTextWrap(nextBlock);
        }
        return nextBlock.nextRenderedWidget;
    }
    updateTableYPositionBasedonTextWrap(table) {
        if (!isNullOrUndefined(table.bodyWidget)) {
            const tableY = table.y;
            const tableRect = new Rect(table.x, table.y, table.width, table.height);
            table.bodyWidget.floatingElements.forEach((shape) => {
                if (shape instanceof ShapeElementBox && !shape.paragraph.isInsideTable) {
                    const shapeRect = new Rect(shape.x, shape.y, shape.width, shape.height);
                    const considerShape = (shape.textWrappingStyle === 'TopAndBottom' || shape.textWrappingStyle === 'Square');
                    if (considerShape && tableRect.isIntersecting(shapeRect)) {
                        table.y = shape.y + shape.height + shape.distanceBottom;
                        this.updateChildLocationForTable(table.y, table);
                        const height = table.y - tableY;
                        this.viewer.cutFromTop(this.viewer.clientActiveArea.y + height);
                    }
                }
            });
        }
    }
    checkAndRelayoutPreviousOverlappingBlock(block) {
        if (!(block.containerWidget instanceof TextFrame) && !this.isRelayoutOverlap) {
            let preivousBlock = block.previousWidget;
            if (block instanceof ParagraphWidget) {
                if (block.floatingElements.length > 0) {
                    for (let i = 0; i < block.floatingElements.length; i++) {
                        const element = block.floatingElements[i];
                        if (element.textWrappingStyle === 'InFrontOfText' || element.textWrappingStyle === 'Behind') {
                            continue;
                        }
                        const shapeRect = new Rect(element.x, element.y, element.width, element.height);
                        while (preivousBlock) {
                            if (preivousBlock instanceof ParagraphWidget) {
                                /* eslint-disable-next-line max-len */
                                const paraRect = new Rect(preivousBlock.x, preivousBlock.y, preivousBlock.width, preivousBlock.height);
                                if (shapeRect.isIntersecting(paraRect) &&
                                    this.startOverlapWidget !== preivousBlock) {
                                    this.startOverlapWidget = preivousBlock;
                                    this.endOverlapWidget = block;
                                }
                            }
                            preivousBlock = preivousBlock.previousWidget;
                        }
                        preivousBlock = block.previousWidget;
                    }
                }
                else {
                    const widget = block.getSplitWidgets();
                    if (widget) {
                        return widget[widget.length - 1];
                    }
                }
            }
            else {
                const table = block;
                if (!table.wrapTextAround) {
                    return table;
                }
                const tableRect = new Rect(table.x, table.y, table.getTableCellWidth(), table.height);
                while (preivousBlock) {
                    if (preivousBlock instanceof ParagraphWidget) {
                        const blockRect = new Rect(preivousBlock.x, preivousBlock.y, preivousBlock.width, preivousBlock.height);
                        if (tableRect.isIntersecting(blockRect) &&
                            this.startOverlapWidget !== preivousBlock) {
                            this.startOverlapWidget = preivousBlock;
                            this.endOverlapWidget = block;
                        }
                    }
                    preivousBlock = preivousBlock.previousWidget;
                }
                preivousBlock = block.previousWidget;
            }
            if (this.startOverlapWidget) {
                this.isRelayoutOverlap = true;
                this.layoutStartEndBlocks(this.startOverlapWidget, block);
                this.isRelayoutOverlap = false;
            }
            this.startOverlapWidget = undefined;
            this.endOverlapWidget = undefined;
        }
        return block;
    }
    addParagraphWidget(area, paragraphWidget) {
        // const ownerParaWidget: ParagraphWidget = undefined;
        if (paragraphWidget.isEmpty() && !isNullOrUndefined(paragraphWidget.paragraphFormat) &&
            (paragraphWidget.paragraphFormat.textAlignment === 'Center' || paragraphWidget.paragraphFormat.textAlignment === 'Right') &&
            paragraphWidget.paragraphFormat.listFormat.listId === -1) {
            // const top: number = 0;
            // const bottom: number = 0;
            const width = this.documentHelper.textHelper.getParagraphMarkWidth(paragraphWidget.characterFormat);
            let left = area.x;
            if (paragraphWidget.paragraphFormat.textAlignment === 'Center') {
                left += (area.width - width) / 2;
            }
            else {
                left += area.width - width;
            }
            paragraphWidget.width = width;
            paragraphWidget.x = left;
            paragraphWidget.y = area.y;
        }
        else {
            paragraphWidget.width = area.width;
            paragraphWidget.x = area.x;
            paragraphWidget.y = area.y;
        }
        return paragraphWidget;
    }
    addLineWidget(paragraphWidget) {
        let line = undefined;
        line = new LineWidget(paragraphWidget);
        line.width = paragraphWidget.width;
        paragraphWidget.childWidgets.push(line);
        line.paragraph = paragraphWidget;
        return line;
    }
    isFirstElementWithPageBreak(paragraphWidget) {
        let isPageBreak = false;
        if (this.viewer instanceof PageLayoutViewer) {
            const lineWidget = paragraphWidget.childWidgets[0];
            if (lineWidget) {
                let element = lineWidget.children[0];
                while (element) {
                    if (element instanceof BookmarkElementBox && element.name.indexOf('_') >= 0) {
                        element = element.nextElement;
                        continue;
                    }
                    if (element instanceof TextElementBox && element.text === '\f') {
                        isPageBreak = true;
                    }
                    break;
                }
            }
        }
        return isPageBreak;
    }
    /**
     * Layouts specified paragraph.
     *
     * @private
     * @param footnote
     */
    layoutfootNote(footnote) {
        if (this.documentHelper.owner.layoutType === 'Pages') {
            if (footnote.footNoteType === 'Endnote') {
                let page = footnote.page;
                while (page.previousPage && page.previousPage.endnoteWidget) {
                    page = page.previousPage;
                }
                footnote = page.endnoteWidget;
                return this.layoutEndNote(footnote);
            }
            const clientActiveArea = this.viewer.clientActiveArea.clone();
            const clientArea = this.viewer.clientArea.clone();
            if (footnote.footNoteType === 'Footnote') {
                this.viewer.updateFootnoteClientArea(footnote.sectionFormat, footnote);
            }
            footnote.height = 0;
            let block;
            let height = 0;
            this.isRelayoutFootnote = false;
            let index = 0;
            //        this.isfoot = true;
            /* eslint-disable-next-line max-len */
            for (let i = 0; i < footnote.bodyWidgets.length; i++) {
                if (i === 0) {
                    let newPara = new ParagraphWidget();
                    newPara.characterFormat = new WCharacterFormat();
                    newPara.paragraphFormat = new WParagraphFormat();
                    newPara.index = 0;
                    let lineWidget = new LineWidget(newPara);
                    newPara.childWidgets.push(lineWidget);
                    // let body: BlockContainer= new BodyWidget();
                    // body.childWidgets.push(newParagraph);
                    // footnote.bodyWidgets.push(body);
                    height = this.documentHelper.textHelper.getParagraphMarkSize(newPara.characterFormat).Height;
                    footnote.height += height;
                    footnote.y = this.viewer.clientActiveArea.y;
                    this.viewer.cutFromTop(this.viewer.clientActiveArea.y + height);
                    footnote.margin = new Margin(0, height, 0, 0);
                }
                for (let j = 0; j < footnote.bodyWidgets[i].childWidgets.length; j++) {
                    block = footnote.bodyWidgets[i].childWidgets[j];
                    block.index = index;
                    index++;
                    block.containerWidget = footnote.bodyWidgets[i];
                    block.containerWidget.page = footnote.page;
                    block.containerWidget.containerWidget = footnote;
                    // paragraph.index = i > 1 ? i - 1 : 0;
                    this.viewer.updateClientAreaForBlock(block, true);
                    if (block instanceof TableWidget) {
                        this.clearTableWidget(block, true, true, true);
                        this.isRelayoutFootnote = true;
                        this.viewer.clientArea.height = Number.POSITIVE_INFINITY;
                        this.viewer.clientActiveArea.height = Number.POSITIVE_INFINITY;
                    }
                    this.layoutBlock(block, 0);
                    if (footnote.footNoteType === 'Footnote') {
                        footnote.height += block.height;
                    }
                    this.viewer.updateClientAreaForBlock(block, false);
                }
            }
            if (footnote.footNoteType === 'Footnote') {
                this.shiftChildWidgetInFootnote(footnote);
            }
            this.viewer.clientActiveArea = clientActiveArea;
            this.viewer.clientArea = clientArea;
            /* eslint-disable-next-line max-len */
            if (footnote.page.bodyWidgets[0].lastChild instanceof TableWidget && ((footnote.page.bodyWidgets[0].lastChild.y + footnote.page.bodyWidgets[0].lastChild.height) > footnote.y)) {
                this.reLayoutTable(footnote.page.bodyWidgets[0].lastChild, true);
            }
            if (!this.islayoutFootnote) {
                if (this.viewer.clientActiveArea.y + this.viewer.clientActiveArea.height > footnote.y) {
                    this.viewer.clientActiveArea.height -= footnote.height;
                    let sub = (this.viewer.clientActiveArea.y + this.viewer.clientActiveArea.height - footnote.y);
                    this.viewer.clientActiveArea.height -= sub;
                }
            }
        }
        this.footnoteHeight = 0;
        return footnote;
    }
    layoutEndNote(endNote) {
        if (this.documentHelper.owner.layoutType === 'Pages') {
            this.combineEndNoteWidgets(endNote);
            let page = endNote.page;
            while (page && this.isRelayout && page.bodyWidgets[0].childWidgets.length === 0) {
                if (!(page.previousPage && page.previousPage.bodyWidgets[0].childWidgets.length === 0)) {
                    page.previousPage.endnoteWidget = endNote;
                    endNote.page = page.previousPage;
                    this.updateContainerWidgetEndNote(endNote);
                    page.endnoteWidget = undefined;
                    break;
                }
                page.endnoteWidget = undefined;
                page = page.previousPage;
            }
            const clientActiveArea = this.viewer.clientActiveArea.clone();
            const clientArea = this.viewer.clientArea.clone();
            endNote.height = 0;
            let block;
            let height = 0;
            this.isRelayoutFootnote = false;
            let index = 0;
            /* eslint-disable-next-line max-len */
            let body = endNote.bodyWidgets.length > 0 ? endNote.bodyWidgets[0] : undefined;
            block = body.firstChild;
            let nextBlock;
            let isFirst = true;
            if (!this.isInitialLoad) {
                this.viewer.updateClientArea(endNote.page.bodyWidgets[0].sectionFormat, endNote.page);
                this.viewer.updateClientAreaForEndNote(endNote.page);
            }
            do {
                endNote = isNullOrUndefined(block.containerWidget.page) ? endNote : block.containerWidget.page.endnoteWidget;
                if (isFirst) {
                    isFirst = false;
                    let newParagraph = new ParagraphWidget();
                    newParagraph.characterFormat = new WCharacterFormat();
                    newParagraph.paragraphFormat = new WParagraphFormat();
                    newParagraph.index = 0;
                    let lineWidget = new LineWidget(newParagraph);
                    newParagraph.childWidgets.push(lineWidget);
                    height = this.documentHelper.textHelper.getParagraphMarkSize(newParagraph.characterFormat).Height;
                    endNote.height += height;
                    endNote.margin = new Margin(0, height, 0, 0);
                    endNote.y = this.viewer.clientActiveArea.y;
                    this.viewer.cutFromTop(this.viewer.clientActiveArea.y + height);
                }
                if (block instanceof TableWidget && block.tableFormat.preferredWidthType === 'Auto'
                    && !block.tableFormat.allowAutoFit) {
                    block.calculateGrid();
                }
                if (!block.containerWidget) {
                    block.containerWidget = body;
                }
                if (!block.containerWidget.page) {
                    block.containerWidget.page = endNote.page;
                }
                if (!block.containerWidget.containerWidget) {
                    block.containerWidget.containerWidget = endNote;
                }
                this.viewer.updateClientAreaForBlock(block, true);
                if (block instanceof TableWidget) {
                    this.clearTableWidget(block, true, true, true);
                    this.isRelayoutFootnote = true;
                    this.viewer.clientArea.height = Number.POSITIVE_INFINITY;
                    this.viewer.clientActiveArea.height = Number.POSITIVE_INFINITY;
                }
                nextBlock = this.layoutBlock(block, index);
                index = 0;
                this.viewer.updateClientAreaForBlock(block, false);
                block = nextBlock;
            } while (block);
            this.viewer.clientActiveArea = clientActiveArea;
            this.viewer.clientArea = clientArea;
            /* eslint-disable-next-line max-len */
            if (endNote.page.bodyWidgets[0].lastChild instanceof TableWidget && ((endNote.page.bodyWidgets[0].lastChild.y + endNote.page.bodyWidgets[0].lastChild.height) > endNote.y)) {
                this.reLayoutTable(endNote.page.bodyWidgets[0].lastChild, true);
            }
        }
        this.footnoteHeight = 0;
        return endNote;
    }
    combineEndNoteWidgets(endNote) {
        if (endNote.bodyWidgets.length > 0 && endNote.page.nextPage && endNote.page.nextPage.endnoteWidget) {
            let page = endNote.page.nextPage;
            while (page && page.endnoteWidget) {
                for (let i = 0; i < page.endnoteWidget.bodyWidgets.length; i++) {
                    let body = page.endnoteWidget.bodyWidgets[i];
                    if (body.firstChild && body.firstChild.index !== 0) {
                        for (let j = 0; j < body.childWidgets.length; j++) {
                            let block = body.childWidgets[j];
                            if (block.getPreviousSplitWidgets().length > 0) {
                                endNote.bodyWidgets[endNote.bodyWidgets.length - 1].childWidgets[endNote.bodyWidgets[endNote.bodyWidgets.length - 1].childWidgets.length - 1].combineWidget(this.viewer);
                                j -= 1;
                                continue;
                            }
                            endNote.bodyWidgets[endNote.bodyWidgets.length - 1].childWidgets.push(block);
                        }
                    }
                    else {
                        endNote.bodyWidgets.push(body);
                    }
                }
                page = page.nextPage;
            }
            if (endNote.page.nextPage) {
                let page = this.documentHelper.pages[this.documentHelper.pages.length - 1];
                while (endNote.page !== page) {
                    this.documentHelper.removePage(page);
                    page = this.documentHelper.pages[this.documentHelper.pages.length - 1];
                }
            }
            this.updateContainerWidgetEndNote(endNote);
        }
    }
    updateContainerWidgetEndNote(endNote) {
        endNote.y = endNote.height = 0;
        for (let i = 0; i < endNote.bodyWidgets.length; i++) {
            let body = endNote.bodyWidgets[i];
            body.containerWidget = endNote;
            body.page = endNote.page;
            for (let j = 0; j < body.childWidgets.length; j++) {
                let block = body.childWidgets[j];
                block.containerWidget = body;
            }
        }
    }
    shiftChildWidgetInFootnote(footnote) {
        let yPosition = footnote.y - footnote.height;
        footnote.y = yPosition;
        yPosition += footnote.margin.top;
        for (let i = 0; i < footnote.bodyWidgets.length; i++) {
            for (let j = 0; j < footnote.bodyWidgets[i].childWidgets.length; j++) {
                let childWidget = footnote.bodyWidgets[i].childWidgets[j];
                if (childWidget instanceof ParagraphWidget) {
                    childWidget.y = yPosition;
                    yPosition += childWidget.height;
                }
                else {
                    this.shiftChildLocationForTableWidget(childWidget, yPosition - childWidget.y);
                    yPosition += childWidget.height;
                }
            }
        }
    }
    layoutParagraph(paragraph, lineIndex) {
        this.addParagraphWidget(this.viewer.clientActiveArea, paragraph);
        let isListLayout = true;
        const isFirstElmIsparagraph = this.isFirstElementWithPageBreak(paragraph);
        if (!isFirstElmIsparagraph) {
            this.layoutListItems(paragraph);
            isListLayout = false;
        }
        if (paragraph.isEmpty()) {
            this.layoutEmptyLineWidget(paragraph, true);
        }
        else {
            let line = lineIndex < paragraph.childWidgets.length ?
                paragraph.childWidgets[lineIndex] : undefined;
            if (!this.isRelayoutOverlap && !(paragraph.containerWidget instanceof TextFrame)) {
                this.layoutFloatElements(paragraph);
            }
            while (line instanceof LineWidget) {
                if (paragraph !== line.paragraph && line.indexInOwner === 0 && isListLayout) {
                    this.layoutListItems(line.paragraph);
                }
                if (line.isFirstLine() && isNullOrUndefined(this.fieldBegin)) {
                    if (!isNullOrUndefined(paragraph.paragraphFormat)) {
                        const firstLineIndent = -HelperMethods.convertPointToPixel(paragraph.paragraphFormat.firstLineIndent);
                        this.viewer.updateClientWidth(firstLineIndent);
                    }
                }
                line.marginTop = 0;
                if (!this.isInitialLoad && !this.isBidiReLayout && this.isContainsRtl(line)) {
                    this.reArrangeElementsForRtl(line, paragraph.paragraphFormat.bidi);
                }
                line = this.layoutLine(line, 0);
                paragraph = line.paragraph;
                line = line.nextLine;
            }
        }
        this.updateWidgetToPage(this.viewer, paragraph);
        paragraph.isLayouted = true;
        return paragraph;
    }
    clearLineMeasures() {
        this.maxBaseline = 0;
        this.maxTextBaseline = 0;
        this.maxTextHeight = 0;
    }
    layoutFloatElements(paragraph) {
        paragraph.floatingElements.forEach((shape) => {
            if (shape instanceof ShapeBase) {
                if (!this.isRelayoutOverlap) {
                    this.layoutShape(shape);
                }
            }
        });
    }
    layoutShape(element) {
        if (element.textWrappingStyle !== 'Inline') {
            const position = this.getFloatingItemPoints(element);
            element.x = position.x;
            element.y = position.y;
            const bodyWidget = element.paragraph.bodyWidget;
            if (bodyWidget.floatingElements.indexOf(element) === -1) {
                bodyWidget.floatingElements.push(element);
                /* eslint:disable */
                bodyWidget.floatingElements.sort(function (a, b) { return a.y - b.y; });
            }
            if (element.paragraph.floatingElements.indexOf(element) === -1) {
                element.paragraph.floatingElements.push(element);
            }
        }
        else {
            if (element.width === 0 && element.widthScale !== 0) {
                let containerWidth = HelperMethods.convertPointToPixel(element.line.paragraph.getContainerWidth());
                element.width = (containerWidth / 100) * element.widthScale;
            }
        }
        const clientArea = this.viewer.clientArea;
        const clientActiveArea = this.viewer.clientActiveArea;
        if (element instanceof ShapeElementBox) {
            const blocks = element.textFrame.childWidgets;
            this.viewer.updateClientAreaForTextBoxShape(element, true);
            for (let i = 0; i < blocks.length; i++) {
                const block = blocks[i];
                this.viewer.updateClientAreaForBlock(block, true);
                if (block instanceof TableWidget) {
                    this.clearTableWidget(block, true, true);
                }
                this.layoutBlock(block, 0);
                this.viewer.updateClientAreaForBlock(block, false);
            }
        }
        this.viewer.clientActiveArea = clientActiveArea;
        this.viewer.clientArea = clientArea;
    }
    moveElementFromNextLine(line) {
        let nextLine = line.nextLine;
        while (nextLine instanceof LineWidget) {
            if (nextLine.children.length > 0) {
                const element = nextLine.children.splice(0, 1)[0];
                line.children.push(element);
                element.line = line;
                break;
            }
            else {
                if (nextLine.paragraph.childWidgets.length === 1) {
                    nextLine.paragraph.destroy();
                }
                else {
                    nextLine.paragraph.childWidgets.splice(nextLine.paragraph.childWidgets.indexOf(nextLine), 1);
                }
                nextLine = line.nextLine;
            }
        }
    }
    layoutLine(line, count) {
        const paragraph = line.paragraph;
        if (line.children.length === 0) {
            this.moveElementFromNextLine(line);
        }
        let element = line.children[count];
        this.clearLineMeasures();
        line.marginTop = 0;
        while (element instanceof ElementBox) {
            element.padding.left = 0;
            this.layoutElement(element, paragraph);
            line = element.line;
            if (element instanceof TextElementBox) {
                const textElement = element;
                if (!isNullOrUndefined(textElement.errorCollection) && textElement.errorCollection.length > 0) {
                    textElement.ischangeDetected = true;
                }
            }
            if (!this.isRTLLayout) {
                if (this.hasFloatingElement) {
                    this.hasFloatingElement = false;
                    const lineIndex = paragraph.childWidgets.indexOf(element.line);
                    if (lineIndex > 0 && paragraph.bodyWidget.floatingElements.length > 0 && element instanceof TextElementBox && !(paragraph.containerWidget instanceof TableCellWidget)) {
                        element = paragraph.childWidgets[lineIndex].children[0];
                    }
                }
                else {
                    if (this.is2013Justification && !isNullOrUndefined(this.nextElementToLayout)) {
                        element = this.nextElementToLayout;
                    }
                    else {
                        element = element.nextElement;
                    }
                    this.nextElementToLayout = undefined;
                }
            }
            else {
                element = undefined;
                this.isRTLLayout = false;
            }
        }
        return line;
    }
    /* eslint-disable  */
    layoutElement(element, paragraph) {
        let line = element.line;
        let text = '';
        let index = element.indexInOwner;
        if (element instanceof FieldElementBox) {
            if (element.fieldType === 0) {
                if (this.documentHelper.fields.indexOf(element) === -1) {
                    this.documentHelper.fields.push(element);
                }
                if (!isNullOrUndefined(element.formFieldData) &&
                    this.documentHelper.formFields.indexOf(element) === -1) {
                    this.documentHelper.formFields.push(element);
                }
            }
            this.layoutFieldCharacters(element);
            if (element.line.isLastLine() && isNullOrUndefined(element.nextNode) && !this.isFieldCode) {
                if (element.fieldType !== 2 && isNullOrUndefined(element.fieldSeparator)) {
                    this.layoutEmptyLineWidget(paragraph, false, element.line);
                }
                this.moveToNextLine(line);
            }
            else if (isNullOrUndefined(element.nextElement) && this.viewer.clientActiveArea.width > 0 && !element.line.isLastLine()) {
                this.moveElementFromNextLine(line);
                if (element.line.isLastLine() && isNullOrUndefined(element.nextNode) && !this.isFieldCode) {
                    if (element.fieldType !== 2 && isNullOrUndefined(element.fieldSeparator)) {
                        this.layoutEmptyLineWidget(paragraph, false, element.line);
                    }
                    this.moveToNextLine(line);
                }
            }
            else if (isNullOrUndefined(element.nextElement) && this.viewer.clientActiveArea.width === 0) {
                this.moveToNextLine(line);
                if (line.paragraph.lastChild === line && !isNullOrUndefined(line.nextLine) &&
                    this.viewer.clientActiveArea.height >= 0) {
                    this.moveFromNextPage(line);
                }
            }
            return;
        }
        if (element instanceof ListTextElementBox || this.isFieldCode || element instanceof BookmarkElementBox ||
            element instanceof EditRangeEndElementBox || element instanceof EditRangeStartElementBox
            || element instanceof ContentControl ||
            (element instanceof ShapeBase && element.textWrappingStyle !== 'Inline')) {
            if (element instanceof BookmarkElementBox) {
                if (element.bookmarkType === 0 && !this.documentHelper.bookmarks.containsKey(element.name)) {
                    this.documentHelper.bookmarks.add(element.name, element);
                }
                else if (element.bookmarkType === 1 && this.documentHelper.bookmarks.containsKey(element.name)) {
                    let bookmrkElement = this.documentHelper.bookmarks.get(element.name);
                    if (isNullOrUndefined(bookmrkElement.reference) || isNullOrUndefined(bookmrkElement.reference.paragraph.bodyWidget)) {
                        bookmrkElement.reference = element;
                        element.reference = bookmrkElement;
                    }
                }
                else if (element.bookmarkType === 0 && this.documentHelper.bookmarks.containsKey(element.name)) {
                    if (isNullOrUndefined(element.reference)) {
                        this.documentHelper.bookmarks.remove(element.name);
                    }
                }
            }
            if (element instanceof ContentControl && this.documentHelper.contentControlCollection.indexOf(element) === -1) {
                if (element.type === 0) {
                    this.documentHelper.contentControlCollection.push(element);
                }
                else if (element.type === 1) {
                    let endPage = element.paragraph.bodyWidget.page;
                    for (let i = 0; i < this.documentHelper.contentControlCollection.length; i++) {
                        let cCStart = this.documentHelper.contentControlCollection[i];
                        let isInHeaderFooter = cCStart.line.paragraph.isInHeaderFooter;
                        // Link content control present in same header.
                        if (isInHeaderFooter && element.contentControlProperties === cCStart.contentControlProperties
                            && endPage === cCStart.line.paragraph.bodyWidget.page) {
                            element.reference = cCStart;
                            cCStart.reference = element;
                        }
                        else if (!isInHeaderFooter && element.contentControlProperties === cCStart.contentControlProperties) {
                            element.reference = cCStart;
                            cCStart.reference = element;
                        }
                    }
                }
            }
            if (isNullOrUndefined(element.nextElement) && this.viewer.clientActiveArea.width > 0 && !element.line.isLastLine()) {
                this.moveElementFromNextLine(line);
            }
            if (element.line.isLastLine() && isNullOrUndefined(element.nextElement)) {
                if (this.hasValidElement(line.paragraph) && !paragraph.isContainsShapeAlone()) {
                    this.moveToNextLine(line);
                }
                else if (!this.isInitialLoad && !this.hasValidElement(line.paragraph) && line.paragraph.paragraphFormat.bidi && line.paragraph.paragraphFormat.listFormat.listId !== -1) {
                    this.moveToNextLine(line);
                }
                else {
                    this.layoutEmptyLineWidget(line.paragraph, false, line, false);
                }
            }
            return;
        }
        let width = element.width;
        if (element instanceof FieldTextElementBox && !this.isTocField(element.fieldBegin)) {
            text = this.documentHelper.getFieldResult(element.fieldBegin, element.paragraph.bodyWidget.page);
            if (text !== '') {
                element.text = text;
            }
            else {
                text = element.text;
            }
        }
        else if (element instanceof FootnoteElementBox) {
            text = this.startAt(element, text);
            if (text !== '') {
                element.text = text;
            }
        }
        else if (element instanceof TextElementBox) {
            this.checkAndSplitTabOrLineBreakCharacter(element.text, element);
            if (element.text.length > 1 && element.line.paragraph.bidi) {
                let splittedText = this.splitTextByConsecutiveLtrAndRtl(element);
                this.updateSplittedText(element, splittedText);
            }
            text = element.text;
        }
        // Here field code width and height update need to skipped based on the hidden property.
        if (element instanceof TextElementBox) {
            // if (this.isRelayout) {
            width = this.documentHelper.textHelper.getTextSize(element, element.characterFormat);
            /*} else {
                width = element.trimEndWidth;
            }*/
            if (element.text === '\t') {
                width = this.getTabWidth(paragraph, this.viewer, index, line, element);
                element.width = width;
            }
        }
        if (!isNullOrUndefined(paragraph.containerWidget) && paragraph.bodyWidget.floatingElements.length > 0 &&
            !(element instanceof ShapeElementBox) && !(paragraph.containerWidget instanceof TextFrame)) {
            this.adjustPosition(element, element.line.paragraph.bodyWidget);
        }
        if (this.viewer instanceof PageLayoutViewer &&
            ((element instanceof ShapeElementBox && element.textWrappingStyle === 'Inline') || !(element instanceof ShapeElementBox))
            && this.viewer.clientActiveArea.height < element.height && this.viewer.clientActiveArea.y !== this.viewer.clientArea.y) {
            if ((element instanceof TextElementBox && element.text !== '\f') || !(element instanceof TextElementBox)) {
                this.moveToNextPage(this.viewer, line);
            }
            if (element instanceof FieldTextElementBox) {
                this.updateFieldText(element);
            }
            if (element.previousElement &&
                ((element.previousElement instanceof ShapeElementBox && element.previousElement.textWrappingStyle === 'Inline') ||
                    !(element.previousElement instanceof ShapeElementBox))) {
                this.cutClientWidth(element.previousElement);
            }
        }
        if (element instanceof ShapeElementBox && element.textWrappingStyle === 'Inline') {
            this.layoutShape(element);
        }
        // tslint:disable-next-line:max-line-length
        if (element instanceof FootnoteElementBox && (!element.isLayout || this.isLayoutWhole) && this.documentHelper.owner.layoutType === 'Pages') {
            this.layoutFootEndNoteElement(element);
        }
        if (element instanceof FootnoteElementBox) {
            if (this.isfootMove) {
                this.moveToNextPage(this.viewer, element.line);
                if (element.previousElement &&
                    ((element.previousElement instanceof ShapeElementBox && element.previousElement.textWrappingStyle === 'Inline') ||
                        !(element.previousElement instanceof ShapeElementBox))) {
                    this.cutClientWidth(element.previousElement);
                }
                this.isfootMove = false;
            }
            if (paragraph.paragraphFormat.keepWithNext && paragraph.paragraphFormat.keepLinesTogether && !(!element.isLayout || this.isLayoutWhole)) {
                if (paragraph.bodyWidget.page.footnoteWidget.y !== 0 && paragraph.bodyWidget.page.footnoteWidget.y < this.viewer.clientActiveArea.y + this.viewer.clientActiveArea.height) {
                    let findDiff = this.viewer.clientActiveArea.y + this.viewer.clientActiveArea.height - paragraph.bodyWidget.page.footnoteWidget.y;
                    this.viewer.clientActiveArea.height -= findDiff;
                }
            }
        }
        if (parseFloat(width.toFixed(4)) <= parseFloat(this.viewer.clientActiveArea.width.toFixed(4)) || !this.viewer.textWrap) {
            //Fits the text in current line.
            this.addElementToLine(paragraph, element);
            if (isNullOrUndefined(element.nextElement) && this.viewer.clientActiveArea.width > 0 && !element.line.isLastLine()) {
                this.moveElementFromNextLine(line);
            }
            else if (!element.line.isLastLine() && isNullOrUndefined(element.nextElement) && this.viewer.clientActiveArea.width === 0) {
                this.moveToNextLine(line);
                if (line.paragraph.lastChild === line && this.viewer.clientActiveArea.height >= 0) {
                    this.moveFromNextPage(line);
                }
            }
        }
        else if (element instanceof TextElementBox) {
            if (element.text === '\t') {
                let currentLine = element.line;
                this.addSplittedLineWidget(currentLine, currentLine.children.indexOf(element) - 1);
                this.moveToNextLine(currentLine);
                // Recalculates tab width based on new client active area X position
                element.width = this.getTabWidth(paragraph, this.viewer, index, element.line, element);
                this.addElementToLine(paragraph, element);
                if (isNullOrUndefined(element.nextElement) && this.viewer.clientActiveArea.width > 0
                    && !element.line.isLastLine()) {
                    this.moveElementFromNextLine(element.line);
                }
            }
            else {
                //Splits the text and arrange line by line, till end of text.
                do {
                    line = element.line;
                    this.splitTextForClientArea(line, element, element.text, element.width, element.characterFormat);
                    this.checkLineWidgetWithClientArea(line, element);
                    if (element instanceof FieldTextElementBox) {
                        this.updateFieldText(element);
                    }
                    if (element.line !== line && !isNullOrUndefined(this.nextElementToLayout) && this.is2013Justification) {
                        return;
                    }
                } while (element.line !== line && this.cutClientWidth(element));
            }
        }
        else {
            do {
                line = element.line;
                this.splitElementForClientArea(paragraph, element);
                this.checkLineWidgetWithClientArea(line, element);
                if (element instanceof FieldTextElementBox) {
                    this.updateFieldText(element);
                }
            } while (element.line !== line && this.cutClientWidth(element));
        }
        if (text === '\v' || text === '\f') {
            let elementIndex = line.children.indexOf(element);
            if (elementIndex > -1) {
                this.addSplittedLineWidget(line, elementIndex);
            }
        }
        if (element.line.isLastLine() && isNullOrUndefined(element.nextElement) || text === '\v' || text === '\f') {
            if (this.isXPositionUpdated) {
                this.isXPositionUpdated = false;
                return;
            }
            this.moveToNextLine(element.line);
            if (text === '\v' && isNullOrUndefined(element.nextNode)) {
                this.layoutEmptyLineWidget(paragraph, true, line, true);
            }
            else if (text === '\f' && this.viewer instanceof PageLayoutViewer) {
                if (isNullOrUndefined(element.nextNode)) {
                    this.moveToNextPage(this.viewer, element.line, true);
                }
                else if (!isNullOrUndefined(element.line.nextLine)) {
                    this.moveToNextPage(this.viewer, element.line.nextLine, false);
                }
            }
        }
        this.isXPositionUpdated = false;
    }
    /**
    * @private
    */
    adjustPosition(element, bodyWidget) {
        let clientArea = this.viewer.clientActiveArea;
        const previousLeft = this.viewer.clientActiveArea.x;
        const previousTop = this.viewer.clientActiveArea.y;
        const previousWidth = this.viewer.clientActiveArea.width;
        let adjustedRect = this.adjustClientAreaBasedOnTextWrap(element, new Rect(clientArea.x, clientArea.y, clientArea.width, clientArea.height));
        this.viewer.clientActiveArea.width = adjustedRect.width;
        //Updated element padding for wrapping.
        // if (this.isWrapText) {
        let wrapDiff = this.viewer.clientActiveArea.x - previousLeft;
        // if (element.indexInOwner === 0 && element.line.isFirstLine()) {
        //     wrapDiff -= HelperMethods.convertPointToPixel(element.line.paragraph.paragraphFormat.firstLineIndent);
        // }
        element.padding.left = wrapDiff;
        if (previousWidth !== this.viewer.clientActiveArea.width) {
            let wrapPos = new WrapPosition(this.viewer.clientActiveArea.x, this.viewer.clientActiveArea.width);
            this.updateWrapPosition(wrapPos);
        }
        //this.isWrapText = false;
        // }
        if (this.viewer.clientActiveArea.width === 0) {
            this.isWrapText = false;
        }
        if (this.isYPositionUpdated) {
            if (element.line.isFirstLine()) {
                element.line.paragraph.y += (this.viewer.clientActiveArea.y - previousTop);
            }
            else {
                element.line.marginTop += (this.viewer.clientActiveArea.y - previousTop);
            }
            if (element.line.paragraph.containerWidget instanceof HeaderFooterWidget) {
                element.line.paragraph.containerWidget.height += (this.viewer.clientActiveArea.y - previousTop);
            }
            this.isYPositionUpdated = false;
        }
    }
    updateWrapPosition(wrapPos) {
        for (let i = 0; i < this.wrapPosition.length; i++) {
            let previousWrapPos = this.wrapPosition[i];
            if (Math.abs(previousWrapPos.right - wrapPos.right) > 1) {
                continue;
            }
            else {
                return;
            }
        }
        this.wrapPosition.push(wrapPos);
    }
    isFirstitemInPage(element, yposition) {
        if (!element.line.paragraph.isInHeaderFooter && Math.round(yposition) === this.viewer.clientArea.y) {
            return true;
        }
        return false;
    }
    isTextFitBelow(rect, top, element) {
        //TODO: After shape implementation.
        return false;
    }
    isNeedToWrapForSquareTightAndThrough(bodyWidget, elementBox, wrapOwnerIndex, wrapItemIndex, textWrappingStyle, textWrappingBounds, allowOverlap, wrapCollectionIndex, floatingEntity, isTextRangeInTextBox, rect, width, height) {
        return (bodyWidget.floatingElements.length > 0
            && wrapOwnerIndex !== wrapCollectionIndex
            && wrapItemIndex !== wrapCollectionIndex
            && textWrappingStyle !== 'Inline'
            && textWrappingStyle !== 'Behind'
            && textWrappingStyle !== 'TopAndBottom'
            && textWrappingStyle !== 'InFrontOfText'
            && (Math.round((rect.y + height)) > Math.round(textWrappingBounds.y) ||
                this.isTextFitBelow(textWrappingBounds, rect.y + height, floatingEntity))
            && Math.round(rect.y) < Math.round((textWrappingBounds.y + textWrappingBounds.height))
            && !(allowOverlap && (isTextRangeInTextBox || ((elementBox instanceof ImageElementBox)
                && elementBox.textWrappingStyle !== 'Inline' && elementBox.allowOverlap))));
    }
    isNeedToWrapForSquareTightAndThroughForTable(container, table, wrapIndex, wrapItemIndex, wrappingStyle, textWrappingBounds, allowOverlap, wrapCollectionIndex, floatingElemnt, isInTextBox, rect, width, height) {
        return (container.floatingElements.length > 0 && wrapIndex !== wrapCollectionIndex
            && wrapItemIndex !== wrapCollectionIndex && wrappingStyle !== 'Inline'
            && wrappingStyle !== 'Behind' && wrappingStyle !== 'TopAndBottom'
            && wrappingStyle !== 'InFrontOfText' && (Math.round((rect.y + height)) >= Math.round(textWrappingBounds.y))
            && Math.round(rect.y) < Math.round((textWrappingBounds.y + textWrappingBounds.height))
            && !(allowOverlap && (isInTextBox)));
    }
    isNeedToWrapLeafWidget(pargaraph, elementBox) {
        let IsNeedToWrap = true;
        return (pargaraph.bodyWidget.floatingElements.length > 0
            && (IsNeedToWrap || pargaraph.associatedCell)
            && !(elementBox instanceof ImageElementBox));
    }
    getMinWidth(currTextRange, width, height, rect) {
        let text = currTextRange.text;
        let split = text.split(' ');
        // Gets the minimum width from the text when it contains only empty space.
        if (text !== '' && text.trim() === ''
            && currTextRange && currTextRange.line.paragraph
            && currTextRange.previousNode && currTextRange.nextNode
            && currTextRange.line.paragraph.isEmpty) {
            split = [''];
        }
        // Initialized the text with additional empty string.
        // It avoids the minimum width calculation from next sibling (GetNextTextRangeWidth).
        let minwidth = this.documentHelper.textHelper.measureText(split[0], currTextRange.characterFormat).Width;
        //Need to layout the unicode characters (chinese) character by character.
        // if (DrawingContext.IsUnicodeText(text)) {
        //     minwidth = DrawingContext.MeasureTextRange(currTextRange, text[0].ToString()).Width;
        // }
        let nextSibling = this.getNextSibling(currTextRange);
        if (split.length === 1 && nextSibling) {
            let nextSiblingText = nextSibling.text;
            minwidth += this.getNextTextRangeWidth(nextSibling, nextSiblingText, width, height, rect);
        } // Add the minimum character width of that paragraph, if this text range is para mark
        return minwidth;
    }
    getNextTextRangeWidth(nextSiblingTextRange, nextSiblingText, width, height, rect) {
        let nextsibling = nextSiblingTextRange;
        // if (nextSiblingTextRange instanceof WFootnote)
        //     nextsibling = ((nextSiblingTextRange as IWidget).LayoutInfo as LayoutFootnoteInfoImpl).TextRange;
        let sizeNext = new Rect(0, 0, 0, 0);
        let isNextSiblingSizeNeedToBeMeasure = this.isNextSibligSizeNeedToBeMeasure(sizeNext, nextSiblingTextRange, rect, width, height);
        while (isNextSiblingSizeNeedToBeMeasure
            && this.isLeafWidgetNextSiblingIsTextRange(nextsibling)
            && width + sizeNext.width < rect.width) {
            nextsibling = this.getNextSibling(nextsibling);
            if (!this.isNextSibligSizeNeedToBeMeasure(sizeNext, nextsibling, rect, width, height)) {
                break;
            }
            nextSiblingText += nextsibling.text;
        }
        return sizeNext.width;
    }
    isLeafWidgetNextSiblingIsTextRange(textRange) {
        let nextSiblingTextRange = this.getNextSibling(textRange);
        if (nextSiblingTextRange && nextSiblingTextRange instanceof TextElementBox) {
            return true;
        }
        return false;
    }
    isNextSibligSizeNeedToBeMeasure(sizeNext, nextSiblingwidget, rect, width, height) {
        let text = null;
        let nextSiblingTextRange = nextSiblingwidget;
        if (nextSiblingTextRange) {
            text = nextSiblingTextRange.text;
            if (text.indexOf(' ') !== -1 || (text.indexOf('-') !== -1 || (text.indexOf('_') !== -1)
                && ((width + sizeNext.width + (this.documentHelper.textHelper.measureText(text.split('-')[0], nextSiblingTextRange.characterFormat)).Width) < rect.width))
                || ((nextSiblingTextRange).text === '\t')) {
                let elementWidth = nextSiblingTextRange.width;
                if (text !== text.split(' ')[0]) {
                    elementWidth = this.documentHelper.textHelper.measureText(text.split(' ')[0], nextSiblingTextRange.characterFormat).Width;
                }
                if ((width + sizeNext.width + elementWidth) > rect.width && text.indexOf('-')) {
                    if (text !== text.split('-')[0] + '-') {
                        elementWidth = this.documentHelper.textHelper.measureText(text.split('-')[0] + '-', nextSiblingTextRange.characterFormat).Width;
                    }
                }
                sizeNext.width += elementWidth;
                return false;
            }
            else {
                if (nextSiblingTextRange.text.length > 0) {
                    let textInfo = this.documentHelper.textHelper.measureText(nextSiblingTextRange.text, nextSiblingTextRange.characterFormat);
                    sizeNext.height += textInfo.Height;
                    sizeNext.width += textInfo.Width;
                }
            }
        }
        return true;
    }
    isNeedDoIntermediateWrapping(remainingClientWidth, textWrappingStyle, rect, width, paragraph, textWrappingBounds, leafWidget, minwidth, minimumWidthRequired) {
        return (((remainingClientWidth > minimumWidthRequired)
            && (((Math.round(rect.width) <= Math.round(minwidth)
                || (rect.width < width && leafWidget.paragraph.isInsideTable))
                && textWrappingStyle !== 'Left' // Skip to update width when the wrap type as left
                && textWrappingStyle !== 'Largest')
                || textWrappingStyle === 'Right' //To layout right side when the wrap type as right
                || (rect.width < remainingClientWidth && textWrappingStyle === 'Largest'))) // Check whether the right side width is greater than the left side when the wrap type as largest
            || ((Math.round(textWrappingBounds.x - paragraph.x + paragraph.leftIndent) < minimumWidthRequired // Check whether the left side of text wrap object is have minimum width to layout or not
                || (leafWidget instanceof TextElementBox && this.isFloatingItemOnLeft(rect, minwidth, textWrappingBounds)))
                && (textWrappingStyle !== 'Left' || remainingClientWidth < minimumWidthRequired)));
    }
    isFloatingItemOnLeft(rect, minWidth, bounds) {
        return false;
    }
    getNextSibling(currentElementBox) {
        let nextSibling = currentElementBox.nextNode;
        let isFieldCode = false;
        while (nextSibling) {
            if ((nextSibling instanceof FieldElementBox) || (nextSibling instanceof BookmarkElementBox) || isFieldCode || nextSibling instanceof ListTextElementBox) {
                if (nextSibling instanceof FieldElementBox) {
                    if (nextSibling.fieldType === 0) {
                        isFieldCode = true;
                    }
                    else if (nextSibling.fieldType === 2) {
                        isFieldCode = false;
                    }
                }
            }
            else if (nextSibling instanceof TextElementBox) {
                break;
            }
            nextSibling = nextSibling.nextNode;
        }
        return nextSibling;
    }
    adjustClientAreaBasedOnTextWrap(elementBox, rect) {
        let ownerPara = elementBox.line.paragraph;
        let bodyWidget = ownerPara.bodyWidget;
        let layouter = this.viewer;
        let yposition = rect.y;
        let isFirstItem = this.isFirstitemInPage(elementBox, yposition);
        isFirstItem = isNullOrUndefined(ownerPara.previousWidget);
        if (this.isNeedToWrapLeafWidget(ownerPara, elementBox)) {
            let clientLayoutArea = layouter.clientArea;
            //Need to handle sorting floating items.
            // Sort based on Y position
            bodyWidget.floatingElements.sort(function (a, b) { return a.y - b.y; });
            // Sort based on X position
            bodyWidget.floatingElements.sort(function (a, b) { return a.x - b.x; });
            for (let i = 0; i < bodyWidget.floatingElements.length; i++) {
                let floatingItem = bodyWidget.floatingElements[i];
                let allowOverlap = false;
                if (floatingItem instanceof ShapeBase) {
                    allowOverlap = floatingItem.allowOverlap;
                }
                else {
                    allowOverlap = floatingItem.positioning.allowOverlap;
                }
                if (ownerPara.isInsideTable) {
                    if (floatingItem instanceof TableWidget && !floatingItem.isInsideTable) {
                        continue;
                    }
                }
                if (this.isRelayout && !this.isRelayoutOverlap &&
                    this.viewer.documentHelper.selection.isExistAfter(floatingItem instanceof TableWidget ? floatingItem : floatingItem.line.paragraph, elementBox.line.paragraph)
                    || this.isRelayout && this.isRelayoutOverlap && this.viewer.documentHelper.selection.isExistAfter(floatingItem instanceof TableWidget ? floatingItem : floatingItem.line.paragraph, this.endOverlapWidget)) {
                    continue;
                }
                // if (ownerPara.isInsideTable && allowOverlap
                //     && (ownerPara.associatedCell.ownerTable.positioning.allowOverlap))
                // {
                //     WParagraph ownerParagraph = (m_lcOperator as Layouter).FloatingItems[i].OwnerParagraph;
                //     if (!(ownerParagraph !== null
                //         && ownerParagraph.IsInCell
                //         && ownerPara.GetOwnerEntity() === ownerParagraph.GetOwnerEntity()))
                //     {
                //         continue;
                //     }
                // }
                let xPosition = floatingItem.x;
                let distanceLeft = 0;
                let distanceTop = 0;
                let distanceRight = 0;
                let distanceBottom = 0;
                let width = 0;
                if (floatingItem instanceof ShapeBase) {
                    distanceLeft = floatingItem.distanceLeft;
                    distanceTop = floatingItem.distanceTop;
                    distanceRight = floatingItem.distanceRight;
                    distanceBottom = floatingItem.distanceBottom;
                    width = floatingItem.width;
                }
                else {
                    width = floatingItem.getTableCellWidth();
                }
                let textWrappingBounds = new Rect(floatingItem.x - distanceLeft, floatingItem.y - distanceTop, width + distanceLeft + distanceRight, floatingItem.height + distanceTop + distanceBottom);
                let textWrappingStyle = floatingItem instanceof TableWidget ? 'Square' : floatingItem.textWrappingStyle;
                let textWrappingType = floatingItem instanceof TableWidget ? 'Both' : floatingItem.textWrappingType;
                //  //Need to skip the wrapping for line break when it is first item of corresponding paragraph and that paragraph contains First line indent as per Word 2010 and its lower version behavior.
                //  if (IsLineBreakIntersectOnFloatingItem(leafWidget, textWrappingStyle, textWrappingBounds, rect, size, ownerPara))
                //  continue;
                let minimumWidthRequired = 18;
                let bottom = layouter.clientArea.y + floatingItem.height;
                // if (this.isNeedToWrapParaMarkToRightSide(elementBox, ownerPara, textWrappingBounds, bottom, layouter, this.viewer.clientArea, textWrappingType, minimumWidthRequired)) {
                //     if (lineBreakPosition !== 0) {
                //         this.viewer.clientArea.y = lineBreakPosition;
                //         //m_layoutArea.UpdateBoundsBasedOnTextWrap(lineBreakPosition);
                //     }
                //     this.viewer.clientArea.x += textWrappingBounds.width;
                //     //(LeafWidget as IWidget).LayoutInfo.IsLineBreak = false;
                //     elementBox.height = 0;
                //     elementBox.width = textWrappingBounds.width;
                //     return;
                // }
                if (!(clientLayoutArea.x > (textWrappingBounds.right + minimumWidthRequired) || clientLayoutArea.right < textWrappingBounds.x - minimumWidthRequired)) {
                    if (this.isNeedToWrapForSquareTightAndThrough(bodyWidget, elementBox, -1, -1, textWrappingStyle, textWrappingBounds, allowOverlap, 1, floatingItem, false, rect, elementBox.width, elementBox.height)) {
                        let rightIndent = 0;
                        let leftIndent = 0;
                        let listLeftIndent = 0;
                        let firstLineIndent = HelperMethods.convertPointToPixel(elementBox.paragraph.paragraphFormat.firstLineIndent);
                        let paragraphLeftIndent = HelperMethods.convertPointToPixel(ownerPara.paragraphFormat.leftIndent);
                        firstLineIndent = ((elementBox.indexInOwner === 0 && elementBox.line.isFirstLine()) && firstLineIndent > 0) ? firstLineIndent : 0;
                        let currTextRange = elementBox;
                        let containerWidget = floatingItem instanceof TableWidget ? floatingItem.containerWidget : floatingItem.line.paragraph.containerWidget;
                        let isnewline = false;
                        if (elementBox.line.paragraph) {
                            //Right indent is considered only if the rect.X greater than the floating item's X position and
                            //Text wrapping style should not be left
                            if (rect.x >= textWrappingBounds.x && textWrappingType !== 'Left') {
                                rightIndent = ownerPara.paragraphFormat.rightIndent;
                            }
                            //Left indent is considered only if the rect.X less than the floating item's X position and
                            //Text wrapping style should not be right
                            if (rect.x < textWrappingBounds.x && textWrappingType !== 'Right') {
                                leftIndent = paragraphLeftIndent;
                            }
                            let listFormat = ownerPara.paragraphFormat.listFormat;
                            let listLevel = this.getListLevel(listFormat.list, listFormat.listLevelNumber);
                            if (rect.x === (clientLayoutArea.x + paragraphLeftIndent)
                                && listFormat && listFormat.baseStyle
                                && listLevel && listLevel.paragraphFormat.leftIndent !== 0) {
                                listLeftIndent = paragraphLeftIndent;
                                isnewline = true; // to denote the current line is new line of the paragraph
                            }
                        }
                        // if (this.isXPositionUpdated && textWrappingType === 'Both' && this.layoutState === 'Splitted') {
                        //     rect.width = bodyWidget.width - this.viewer.clientActiveArea.x;
                        //     rect.x = textWrappingBounds.right;
                        //     this.viewer.updateClientAreaForTextWrap(rect);
                        //     return rect;
                        // }
                        // Skip to update when the wrap type as left
                        if (rect.x >= textWrappingBounds.x && rect.x < textWrappingBounds.right && textWrappingType !== 'Left') // Skip to update when the wrap type as left
                         {
                            rect.width = rect.width - (textWrappingBounds.right - rect.x) - rightIndent;
                            this.isWrapText = true;
                            let isEntityFitInCurrentLine = true;
                            if (!isEntityFitInCurrentLine || Math.round(rect.width) < minimumWidthRequired || (rect.width < elementBox.width && elementBox.text === '\t')
                                || (textWrappingBounds.x < ownerPara.x + paragraphLeftIndent)) // check whether the TextWrap X position is less than the paragraph X position
                             {
                                //TODO
                                rect.width = this.viewer.clientArea.right - textWrappingBounds.right - (isnewline ? listLeftIndent : 0);
                                let minwidth = 0;
                                if (currTextRange) {
                                    minwidth = this.getMinWidth(elementBox, elementBox.width, elementBox.height, rect);
                                }
                                else {
                                    minwidth = elementBox.width;
                                }
                                if (Math.round(rect.width) < minimumWidthRequired || rect.width < minwidth) {
                                    if (isEntityFitInCurrentLine && (textWrappingBounds.x - (ownerPara.x + ownerPara.leftIndent)) > minimumWidthRequired
                                        && (this.viewer.clientArea.right - textWrappingBounds.right) > minimumWidthRequired) {
                                        rect.width = 0;
                                    }
                                    else {
                                        let topMarginValue = 0;
                                        //topMarginValue = GetTopMarginValueForFloatingTable(ownerPara,
                                        //layouter.FloatingItems[i].FloatingEntity, rect.Y);
                                        let isPositionsUpdated = false;
                                        //Check whether left side of current floating item has enoush place to fit current widget.
                                        //If it has, need to fit left side of the floating item, instead of moving to bottom.
                                        // if (layouter.clientArea.x + elementBox.width < floatingItem.x) {
                                        //     //Current item should preserve below to the floating item,which preserved left side of the floating item.
                                        //     //If left side has multiple items or none of items this may fail, need to handle this cases.
                                        //     let tempBounds: Rect = GetIntersectingItemBounds(floatingItem, yposition);
                                        //     if (tempBounds.bottom !== 0 && tempBounds.bottom <= textWrappingBounds.bottom) {
                                        //         rect.x = clientLayoutArea.x;
                                        //         rect.width = clientLayoutArea.width;
                                        //         rect.y = tempBounds.bottom + topMarginValue;
                                        //         rect.height = clientLayoutArea.bottom - tempBounds.bottom;
                                        //         this.isYPositionUpdated = true;
                                        //         isPositionsUpdated = true;
                                        //     }
                                        // }
                                        if (!isPositionsUpdated) {
                                            this.isYPositionUpdated = true;
                                            rect.width = this.viewer.clientArea.width;
                                            rect.height -= (textWrappingBounds.bottom + topMarginValue - rect.y);
                                            rect.y = textWrappingBounds.bottom + topMarginValue;
                                        }
                                    }
                                    this.viewer.updateClientAreaForTextWrap(rect);
                                    this.isWrapText = false;
                                }
                                else {
                                    let xposition = rect.x;
                                    //TabsLayoutInfo tabsInfo = null;
                                    rect.x = textWrappingBounds.right + (isnewline ? listLeftIndent : 0) + firstLineIndent;
                                    rect.width -= firstLineIndent;
                                    //When there is no space to fit the content in right, then update the y position.
                                    if (textWrappingStyle === 'Square' && rect.width < 0 && elementBox.width > 0) {
                                        // let topMarginValue = GetTopMarginValueForFloatingTable(ownerPara, layouter.FloatingItems[i].FloatingEntity, rect.Y);
                                        let topMarginValue = 0;
                                        this.isYPositionUpdated = true;
                                        rect.width = this.viewer.clientArea.width;
                                        rect.height -= (textWrappingBounds.bottom + topMarginValue - rect.y);
                                        rect.y = textWrappingBounds.bottom + topMarginValue;
                                        rect.x = xposition;
                                    }
                                    else {
                                        // this.isXPositionUpdated = true;
                                    }
                                    this.viewer.updateClientAreaForTextWrap(rect); //
                                    // if (!(leafWidget is Break))
                                    // AdjustClientAreaBasedOnExceededTab(leafWidget, size, ref rect, ownerPara);
                                    // if (leafWidget != null)
                                    //     tabsInfo = (leafWidget as ILeafWidget).LayoutInfo as TabsLayoutInfo;
                                    //if (tabsInfo == null) {
                                    //this.isWrapText = true;
                                    //this.viewer.updateClientAreaForTextWrap(rect);//
                                    // if (layouter.FloatingItems[i].FloatingEntity is WTable)
                                    // layouter.FloatingTableBottom = textWrappingBounds.Bottom;
                                    //}
                                }
                            }
                            else {
                                //Check whether the RightPositionOfTabStopInterSectingFloattingItems have the value or not.
                                //if contains value means continue the layouting even x position exceeds the page right position.
                                let xposition = rect.x;
                                rect.x = textWrappingBounds.right + (isnewline ? listLeftIndent : 0) + firstLineIndent;
                                rect.width = this.viewer.clientArea.right - textWrappingBounds.right - (isnewline ? listLeftIndent : 0) - firstLineIndent;
                                //When there is no space to fit the content in right, then update the y position.
                                if (textWrappingStyle === 'Square' && rect.width < 0 && elementBox.width > 0) {
                                    // float topMarginValue = GetTopMarginValueForFloatingTable(ownerPara,
                                    //     layouter.FloatingItems[i].FloatingEntity, rect.Y);
                                    let topMarginValue = 0;
                                    this.isYPositionUpdated = true;
                                    rect.width = this.viewer.clientArea.width;
                                    rect.height -= (textWrappingBounds.bottom + topMarginValue - rect.y);
                                    rect.y = textWrappingBounds.bottom + topMarginValue;
                                    rect.x = xposition;
                                }
                                //else
                                // this.isXPositionUpdated = true;
                                // if (!(leafWidget is Break))
                                //     AdjustClientAreaBasedOnExceededTab(leafWidget, size, ref rect, ownerPara);
                                // //Microsoft Word 2013 doesn't split text character by character, when current line has floating item.
                                // if (ownerPara != null && ownerPara.Document.Settings.CompatibilityMode == CompatibilityMode.Word2013)
                                //     layouter.m_canSplitbyCharacter = false;
                                this.isWrapText = true;
                                this.viewer.updateClientAreaForTextWrap(rect); //
                            }
                        }
                        else if (textWrappingBounds.x >= rect.x && rect.right > textWrappingBounds.x) {
                            rect.width = textWrappingBounds.x - rect.x - rightIndent;
                            //Remaining right side width
                            let remainingClientWidth = this.viewer.clientArea.right - textWrappingBounds.right;
                            remainingClientWidth = remainingClientWidth > 0 ? remainingClientWidth : 0;
                            this.isWrapText = true;
                            let minwidth = 0;
                            if (currTextRange) {
                                minwidth = this.getMinWidth(currTextRange, elementBox.width, elementBox.height, rect);
                            }
                            else {
                                minwidth = elementBox.width;
                            }
                            if (this.isNeedDoIntermediateWrapping(remainingClientWidth, textWrappingType, rect, elementBox.width, elementBox.paragraph, textWrappingBounds, elementBox, minwidth, minimumWidthRequired)) {
                                rect.width = remainingClientWidth;
                                this.isWrapText = true;
                                if (rect.x + minwidth > textWrappingBounds.x || textWrappingType === 'Right') //Update X position when the wrap type as largest or right or the minimum width + rect.X > wrap x position
                                 {
                                    rect.x = textWrappingBounds.right;
                                    // let listFormat: WListFormat = null;
                                    // let listLevel: WListLevel = null;
                                    // if (elementBox.line.isFirstLine
                                    //    && (listFormat = ownerPara.GetListFormatValue()) != null
                                    //    && listFormat.CurrentListStyle != null
                                    //    && (listLevel = ownerPara.GetListLevel(listFormat)) != null
                                    //    && listLevel.ParagraphFormat.LeftIndent != 0)
                                    // {
                                    //     float x = 0;
                                    //     float width = rect.Width;
                                    //     //Updates the paragraph firstline horizontal positions, such as first line indent and listtab value
                                    //     UpdateParaFirstLineHorizontalPositions(paragraphLayoutInfo, ownerPara, ref x, ref width);
                                    //     rect.X += (x + (float)paragraphLayoutInfo.Margins.Left);
                                    //     rect.Width -= (x + (float)paragraphLayoutInfo.Margins.Left);
                                    // }
                                    // this.isXPositionUpdated = true;
                                    // if (textWrappingStyle == TextWrappingStyle.Through
                                    //     && layouter.FloatingItems[i].IsDoesNotDenotesRectangle) {
                                    //     UpdateXposition(textWrappingBounds, i, ref rect, size, minwidth);
                                    // }
                                    if (rect.width > minwidth || textWrappingType === 'Right') {
                                        this.viewer.updateClientAreaForTextWrap(rect);
                                    }
                                }
                                if ((rect.width < minimumWidthRequired && !(minwidth < remainingClientWidth && ('Tight' === textWrappingStyle)))
                                    || (rect.width < minwidth && Math.round(rect.right) === Math.round(this.viewer.clientArea.right)
                                        && textWrappingType === 'Both')) {
                                    let rect1 = textWrappingBounds;
                                    if (Math.round(rect.x) === Math.round(bodyWidget.sectionFormat.leftMargin + ownerPara.paragraphFormat.leftIndent)) {
                                        //Updates top margin of the paragraph when paragraph mark not wrap based on the floating table.
                                        let topMarginValue = 0;
                                        //topMarginValue = GetTopMarginValueForFloatingTable(ownerPara, floatingItem, rect.y);
                                        rect.y = rect1.bottom + topMarginValue;
                                        this.isYPositionUpdated = true;
                                        rect.width = this.viewer.clientArea.width;
                                        rect.height = rect.height - (rect1.height + topMarginValue);
                                        this.viewer.updateClientAreaForTextWrap(rect);
                                        this.isWrapText = false;
                                    }
                                    // Reset the rectangle position when the rectangle right position is equialent to layout area right position
                                    else if (Math.round(rect.right) >= Math.round(this.viewer.clientArea.right) && textWrappingType === 'Both') {
                                        //Updates top margin of the paragraph when paragraph mark not wrap based on the floating table.
                                        let topMarginValue = 0;
                                        // topMarginValue = GetTopMarginValueForFloatingTable(ownerPara, floatingItem, rect.y);
                                        rect.y = rect1.bottom + topMarginValue;
                                        rect.width = this.viewer.clientArea.width;
                                        rect.height = rect.height - (rect1.height + topMarginValue);
                                        rect.x = this.viewer.clientArea.x + leftIndent;
                                        this.viewer.updateClientAreaForTextWrap(rect);
                                        // this.isXPositionUpdated = true;
                                        this.isYPositionUpdated = true;
                                        this.isWrapText = false;
                                    }
                                    else {
                                        rect.width = 0;
                                        this.viewer.updateClientAreaForTextWrap(rect);
                                    }
                                }
                            }
                            else {
                                //While text intersecting with SQUARE type floating item and there is no space
                                //available to fit this text in current line then move the text to bottom
                                //of the floating item and this behavior is applicable only for Word 2013.
                                //Lower versions split the text character by character.
                                if ((elementBox.line.isFirstLine() && elementBox.indexInOwner === 0) && textWrappingStyle === 'Square'
                                    && Math.round(rect.width) <= Math.round(minwidth)
                                    && ownerPara.containerWidget === containerWidget) {
                                    rect.x = clientLayoutArea.x;
                                    rect.y = textWrappingBounds.bottom;
                                    rect.width = clientLayoutArea.width;
                                    rect.height -= (textWrappingBounds.bottom - rect.y);
                                    this.isYPositionUpdated = true;
                                }
                                else if (Math.round(rect.width) <= Math.round(minwidth) && Math.round(rect.x - leftIndent) !== Math.round(this.viewer.clientArea.x)) {
                                    rect.width = 0;
                                }
                                this.viewer.updateClientAreaForTextWrap(rect); //
                            }
                        }
                        if (textWrappingType !== 'Both') {
                            this.isWrapText = false;
                        }
                    }
                }
            }
        }
        return rect;
    }
    adjustClientAreaBasedOnTextWrapForTable(table, rect) {
        //let ownerPara: ParagraphWidget = elementBox.line.paragraph;
        if (isNullOrUndefined(table.containerWidget) || isNullOrUndefined(table.bodyWidget)) {
            return rect;
        }
        let bodyWidget = table.bodyWidget;
        let layouter = this.viewer;
        let yposition = rect.y;
        let isFirstItem = isNullOrUndefined(table.previousWidget);
        if (bodyWidget.floatingElements.length > 0) {
            let clientLayoutArea = layouter.clientActiveArea;
            bodyWidget.floatingElements.sort(function (a, b) { return a.y - b.y; });
            bodyWidget.floatingElements.sort(function (a, b) { return a.x - b.x; });
            for (let i = 0; i < bodyWidget.floatingElements.length; i++) {
                let floatingElement = bodyWidget.floatingElements[i];
                let allowOverlap = false;
                if (floatingElement instanceof ShapeBase) {
                    allowOverlap = floatingElement.allowOverlap;
                }
                else {
                    allowOverlap = floatingElement.positioning.allowOverlap;
                }
                if (table.isInsideTable) {
                    if (floatingElement instanceof TableWidget && !floatingElement.isInsideTable) {
                        continue;
                    }
                }
                let tableWidth = table.getTableCellWidth();
                let isShape = floatingElement instanceof ShapeBase;
                let distanceLeft = isShape ? floatingElement.distanceLeft : floatingElement.positioning.distanceLeft;
                let distanceTop = isShape ? floatingElement.distanceTop : floatingElement.positioning.distanceTop;
                let distanceRight = isShape ? floatingElement.distanceRight : floatingElement.positioning.distanceRight;
                let distanceBottom = isShape ? floatingElement.distanceBottom : floatingElement.positioning.distanceBottom;
                let width = isShape ? floatingElement.width : floatingElement.getTableCellWidth();
                let wrappingBounds = new Rect(floatingElement.x - distanceLeft, floatingElement.y - distanceTop, width + distanceLeft + distanceRight, floatingElement.height + distanceTop + distanceBottom);
                let textWrappingStyle = floatingElement instanceof TableWidget ? 'Square' : floatingElement.textWrappingStyle;
                let textWrappingType = floatingElement instanceof TableWidget ? 'Both' : floatingElement.textWrappingType;
                let minimumWidthRequired = 18;
                if (!(clientLayoutArea.x > (wrappingBounds.right + minimumWidthRequired) || clientLayoutArea.right < wrappingBounds.x - minimumWidthRequired)) {
                    if (this.isNeedToWrapForSquareTightAndThroughForTable(bodyWidget, table, -1, -1, textWrappingStyle, wrappingBounds, allowOverlap, 1, floatingElement, false, rect, tableWidth, table.height)) {
                        // Skip to update when the wrap type as left
                        if (rect.x >= wrappingBounds.x && rect.x < wrappingBounds.right && textWrappingType !== 'Left') // Skip to update when the wrap type as left
                         {
                            rect.width = rect.width - (wrappingBounds.right - rect.x);
                            this.isWrapText = true;
                            let isEntityFitInCurrentLine = true;
                            if (!isEntityFitInCurrentLine || Math.round(rect.width) < minimumWidthRequired || (rect.width < tableWidth)
                                || (wrappingBounds.x < table.x)) // check whether the TextWrap X position is less than the paragraph X position
                             {
                                rect.width = this.viewer.clientArea.right - wrappingBounds.right;
                                let minwidth = tableWidth;
                                if (Math.round(rect.width) < minimumWidthRequired || rect.width < minwidth) {
                                    if (isEntityFitInCurrentLine && (wrappingBounds.x - (table.x)) > minimumWidthRequired
                                        && (this.viewer.clientArea.right - wrappingBounds.right) > minimumWidthRequired) {
                                        rect.width = 0;
                                    }
                                    else {
                                        let topMarginValue = 0;
                                        let isPositionsUpdated = false;
                                        if (!isPositionsUpdated) {
                                            this.isYPositionUpdated = true;
                                            rect.width = this.viewer.clientArea.width;
                                            rect.height -= (wrappingBounds.bottom + topMarginValue - rect.y);
                                            rect.y = wrappingBounds.bottom + topMarginValue;
                                        }
                                    }
                                    this.viewer.updateClientAreaForTextWrap(rect);
                                    this.isWrapText = false;
                                }
                                else {
                                    let xposition = rect.x;
                                    //TabsLayoutInfo tabsInfo = null;
                                    rect.x = wrappingBounds.right;
                                    //When there is no space to fit the content in right, then update the y position.
                                    if (textWrappingStyle === 'Square' && rect.width < 0 && tableWidth > 0) {
                                        // let topMarginValue = GetTopMarginValueForFloatingTable(ownerPara, layouter.FloatingItems[i].FloatingEntity, rect.Y);
                                        let marginTop = 0;
                                        this.isYPositionUpdated = true;
                                        rect.height -= (wrappingBounds.bottom + marginTop - rect.y);
                                        rect.width = this.viewer.clientArea.width;
                                        rect.y = wrappingBounds.bottom + marginTop;
                                        rect.x = xposition;
                                    }
                                    this.viewer.updateClientAreaForTextWrap(rect); //
                                }
                            }
                            else {
                                let xposition = rect.x;
                                rect.x = wrappingBounds.right + table.firstChild.firstChild.leftMargin;
                                rect.width = this.viewer.clientArea.right - wrappingBounds.right;
                                //When there is no space to fit the content in right, then update the y position.
                                if (textWrappingStyle === 'Square' && rect.width < 0 && tableWidth > 0) {
                                    // float topMarginValue = GetTopMarginValueForFloatingTable(ownerPara,
                                    //     layouter.FloatingItems[i].FloatingEntity, rect.Y);
                                    let topMarginValue = 0;
                                    this.isYPositionUpdated = true;
                                    rect.width = this.viewer.clientArea.width;
                                    rect.height -= (wrappingBounds.bottom + topMarginValue - rect.y);
                                    rect.y = wrappingBounds.bottom + topMarginValue;
                                    rect.x = xposition;
                                }
                                this.viewer.updateClientAreaForTextWrap(rect); //
                            }
                        }
                    }
                }
            }
        }
        return rect;
    }
    startAt(element, text) {
        if (element.footnoteType === 'Footnote') {
            this.startat = element.paragraph.bodyWidget.sectionFormat.initialFootNoteNumber;
            text = this.getFootEndNote(element.paragraph.bodyWidget.sectionFormat.footNoteNumberFormat, this.documentHelper.footnoteCollection.indexOf(element) + this.startat);
        }
        else {
            this.startat = element.paragraph.bodyWidget.sectionFormat.initialEndNoteNumber;
            text = this.getFootEndNote(element.paragraph.bodyWidget.sectionFormat.endnoteNumberFormat, this.documentHelper.endnoteCollection.indexOf(element) + this.startat);
        }
        return text;
    }
    layoutFootEndNoteElement(element) {
        this.isFootnoteContentChanged = true;
        let footnote;
        let positionchanged = false;
        let footIndex = this.documentHelper.footnoteCollection.indexOf(element);
        let insertIndex = 1;
        this.islayoutFootnote = true;
        let isFitted;
        let clientArea = new Rect(this.viewer.clientArea.x, this.viewer.clientArea.y, this.viewer.clientArea.width, this.viewer.clientArea.height);
        let clientActiveArea = new Rect(this.viewer.clientActiveArea.x, this.viewer.clientActiveArea.y, this.viewer.clientActiveArea.width, this.viewer.clientActiveArea.height);
        let bodyWidget = element.paragraph.bodyWidget;
        let isCreated = false;
        let height = 0;
        if (bodyWidget.page.footnoteWidget) {
            for (let j = 0; j < bodyWidget.page.footnoteWidget.bodyWidgets.length; j++) {
                insertIndex = bodyWidget.page.footnoteWidget.bodyWidgets.length;
                let currentIndex = this.documentHelper.footnoteCollection.indexOf((bodyWidget.page.footnoteWidget.bodyWidgets[j]).footNoteReference);
                if (currentIndex > footIndex) {
                    if (currentIndex - footIndex === 1) {
                        insertIndex = j;
                        positionchanged = true;
                        break;
                    }
                }
            }
        }
        element.isLayout = true;
        if (element.footnoteType === 'Footnote') {
            if (bodyWidget.page.footnoteWidget && bodyWidget.page.footnoteWidget instanceof FootNoteWidget) {
                footnote = bodyWidget.page.footnoteWidget;
            }
            else {
                isCreated = true;
                footnote = new FootNoteWidget();
                footnote.footNoteType = 'Footnote';
                footnote.page = bodyWidget.page;
                let newParagraph = new ParagraphWidget();
                newParagraph.characterFormat = new WCharacterFormat();
                newParagraph.paragraphFormat = new WParagraphFormat();
                newParagraph.index = 0;
                let lineWidget = new LineWidget(newParagraph);
                newParagraph.childWidgets.push(lineWidget);
                height = this.documentHelper.textHelper.getParagraphMarkSize(newParagraph.characterFormat).Height;
                footnote.margin = new Margin(0, height, 0, 0);
            }
            this.isFootNoteLayoutStart = true;
            if (isCreated) {
                bodyWidget.page.footnoteWidget = footnote;
            }
            let body = element.bodyWidget;
            for (let i = 0; i < element.bodyWidget.childWidgets.length; i++) {
                let block = element.bodyWidget.childWidgets[i];
                //TODO: Ensure this case.
                if (this.isLayoutWhole) {
                    block.containerWidget = undefined;
                }
                else {
                    block.containerWidget = body;
                    body.page = bodyWidget.page;
                    body.sectionFormat = footnote.sectionFormat;
                    block.containerWidget.containerWidget = footnote;
                }
                this.viewer.updateClientAreaForBlock(block, true);
                if (block instanceof TableWidget) {
                    this.clearTableWidget(block, true, true);
                }
                this.layoutBlock(block, 0);
                height += block.height;
                block.y = 0;
                this.viewer.updateClientAreaForBlock(block, false);
                body.height += block.height;
            }
            this.isFootNoteLayoutStart = false;
            isFitted = false;
            if (footnote.height + height >= clientActiveArea.height) {
                this.isfootMove = true;
            }
            if (positionchanged) {
                footnote.bodyWidgets.splice(insertIndex, 0, body);
            }
            else {
                footnote.bodyWidgets.push(body);
            }
            footnote.height += height;
            isFitted = true;
            this.viewer.clientActiveArea = clientActiveArea;
            this.viewer.clientActiveArea.height -= height;
            this.footnoteHeight += height;
            this.viewer.clientArea = clientArea;
        }
        return isFitted;
    }
    layoutEndNoteElement() {
        let lastpage = this.documentHelper.pages.length;
        if (this.documentHelper.endnoteCollection.length > 0) {
            let foot;
            let endNote;
            let isCreated;
            let bodyWidget = this.documentHelper.pages[lastpage - 1].bodyWidgets[0];
            for (let i = 0; i < this.documentHelper.endnoteCollection.length; i++) {
                foot = this.documentHelper.endnoteCollection[i];
                if (bodyWidget.page.endnoteWidget instanceof FootNoteWidget && bodyWidget.page.endnoteWidget.footNoteType === 'Endnote') {
                    endNote = bodyWidget.page.endnoteWidget;
                }
                else {
                    isCreated = true;
                    endNote = new FootNoteWidget();
                    endNote.footNoteType = 'Endnote';
                    endNote.page = bodyWidget.page;
                }
                let body = foot.bodyWidget;
                for (let j = 0; j < foot.bodyWidget.childWidgets.length; j++) {
                    let block = foot.bodyWidget.childWidgets[j];
                    block.containerWidget = body;
                }
                if (endNote.bodyWidgets.indexOf(body) === -1) {
                    endNote.bodyWidgets.push(body);
                    body.sectionFormat = endNote.sectionFormat;
                }
                if (isCreated) {
                    bodyWidget.page.endnoteWidget = endNote;
                }
            }
            this.layoutfootNote(endNote);
        }
    }
    hasValidElement(paragraph) {
        let line = paragraph.firstChild;
        if (line && !isNullOrUndefined(this.documentHelper.selection)) {
            let elementBox = line.children[0];
            while (elementBox) {
                if (elementBox instanceof FieldElementBox) {
                    elementBox = this.documentHelper.selection.getNextValidElementForField(elementBox);
                    if (!isNullOrUndefined(elementBox) && !elementBox.line.paragraph.equals(paragraph)) {
                        return false;
                    }
                }
                if (elementBox instanceof TextElementBox || elementBox instanceof ImageElementBox) {
                    return true;
                }
                if (!isNullOrUndefined(elementBox)) {
                    elementBox = elementBox.nextNode;
                }
            }
        }
        return false;
    }
    updateFieldText(element) {
        let text = this.documentHelper.getFieldResult(element.fieldBegin, element.paragraph.bodyWidget.page);
        if (text !== '') {
            element.text = text;
            this.documentHelper.textHelper.getTextSize(element, element.characterFormat);
        }
    }
    checkLineWidgetWithClientArea(line, element) {
        if (line !== element.line || element.line === line && isNullOrUndefined(element.nextElement)
            && !element.line.isLastLine()) {
            this.moveToNextLine(line);
            if (this.documentHelper.compatibilityMode !== 'Word2013' && this.isOverlapFloatTable) {
                let table;
                if (element.line.paragraph.previousRenderedWidget instanceof TableWidget && element.line.paragraph.previousRenderedWidget.wrapTextAround) {
                    table = element.line.paragraph.previousRenderedWidget;
                    this.viewer.clientActiveArea.x = this.viewer.clientActiveArea.x -
                        HelperMethods.convertPointToPixel(table.firstChild.firstChild.leftMargin);
                }
                this.viewer.clientActiveArea.x += line.paragraph.leftIndent;
                this.isOverlapFloatTable = false;
            }
            if (line !== element.line) {
                this.isRTLLayout = false;
            }
        }
        if (element.line !== line && this.viewer instanceof PageLayoutViewer
            && this.viewer.clientActiveArea.height < element.height &&
            this.viewer.clientActiveArea.y !== this.viewer.clientArea.y) {
            this.moveToNextPage(this.viewer, element.line);
        }
        else if (element.line === line && isNullOrUndefined(element.nextElement)
            && line.paragraph.lastChild === line && !line.isLastLine() && this.viewer.clientActiveArea.height >= 0) {
            this.moveFromNextPage(line);
        }
    }
    checkAndSplitTabOrLineBreakCharacter(text, element) {
        let char = ['\t', '\v', '\f'];
        let index = HelperMethods.indexOfAny(text, char);
        if (index > -1) {
            let character = text[index];
            if ((character === '\t' && text !== '\t') || (character === '\v' && text !== '\v')
                || (character === '\f' && text !== '\f')) {
                this.splitByLineBreakOrTab(this.viewer, element, index, character);
            }
        }
    }
    splitTextByConsecutiveLtrAndRtl(element) {
        let text = element.text;
        let charTypeIndex = 0;
        let splittedText = [];
        let hasRTLCharacter = false;
        let characterRangeTypes = [];
        let lastLtrIndex = -1;
        let ltrText = '';
        let rtlText = '';
        let wordSplitChars = '';
        let numberText = '';
        let isTextBidi = element.characterFormat.bidi;
        for (let i = 0; i < text.length; i++) {
            let currentCharacterType = 0;
            let separateEachWordSplitChars = false;
            // if ((isPrevLTRText.HasValue ? !isPrevLTRText.Value : isTextBidi) && char.IsNumber(text[i]))
            if (isTextBidi && /^[0-9]+$/.test(text[i])) {
                numberText += text[i];
                currentCharacterType = 4;
            }
            else if (this.documentHelper.textHelper.containsSpecialCharAlone(text.charAt(i))) {
                currentCharacterType = 2;
                if (separateEachWordSplitChars = (isTextBidi || (text.charAt(i) === ' ' && wordSplitChars === ''))) {
                    wordSplitChars += text[i];
                }
            }
            else if (this.documentHelper.textHelper.isRTLText(text.charAt(i))) {
                hasRTLCharacter = true;
                rtlText += text[i];
                currentCharacterType = 1;
            }
            else {
                ltrText += text[i];
            }
            if (numberText !== '' && currentCharacterType !== 4) {
                splittedText.push(numberText);
                characterRangeTypes.push('Number');
                numberText = '';
            }
            if (rtlText !== '' && currentCharacterType !== 1) {
                splittedText.push(rtlText);
                characterRangeTypes.push('RTL');
                rtlText = '';
            }
            if (ltrText !== '' && currentCharacterType !== 0) {
                splittedText.push(ltrText);
                lastLtrIndex = splittedText.length - 1;
                characterRangeTypes.push('LTR');
                ltrText = '';
            }
            if (wordSplitChars !== '' && (currentCharacterType !== 2 || separateEachWordSplitChars)) {
                splittedText.push(wordSplitChars);
                characterRangeTypes.push('WordSplit');
                wordSplitChars = '';
            }
        }
        if (numberText !== '') {
            splittedText.push(numberText);
            characterRangeTypes.push('Number');
        }
        else if (rtlText !== '') {
            splittedText.push(rtlText);
            characterRangeTypes.push('RTL');
        }
        else if (ltrText !== '') {
            splittedText.push(ltrText);
            lastLtrIndex = splittedText.length - 1;
            characterRangeTypes.push('LTR');
        }
        else if (wordSplitChars !== '') {
            splittedText.push(wordSplitChars);
            characterRangeTypes.push('WordSplit');
        }
        if (hasRTLCharacter) {
            for (let i = 1; i < splittedText.length; i++) {
                //Combines the consecutive LTR,RTL,and Number(Number get combined only if it's splitted by non reversing characters (.,:)) 
                //along with single in-between word split character.
                let charType = characterRangeTypes[i + charTypeIndex];
                if (charType === 'WordSplit' && splittedText[i].length === 1 && i + charTypeIndex + 1 < characterRangeTypes.length
                    && characterRangeTypes[i + charTypeIndex - 1] !== 'WordSplit' && (characterRangeTypes[i + charTypeIndex - 1] !== 'Number'
                    //Else handled to combine consecutive number 
                    //when text bidi is false and middle word split character is not white space.
                    || this.isNumberNonReversingCharacter(splittedText[i], isTextBidi))
                    && characterRangeTypes[i + charTypeIndex - 1] === characterRangeTypes[i + charTypeIndex + 1]) {
                    splittedText[i - 1] = splittedText[i - 1] + splittedText[i] + splittedText[i + 1];
                    splittedText.splice(i, 1);
                    splittedText.splice(i, 1);
                    characterRangeTypes.splice(i + charTypeIndex, 1);
                    characterRangeTypes.splice(i + charTypeIndex, 1);
                    i--;
                }
            }
        }
        else if (lastLtrIndex !== -1) {
            if (isTextBidi) {
                for (let i = 1; i < lastLtrIndex; i++) {
                    //Combines the first and last LTR along with all in-between splited text's.
                    const charType = characterRangeTypes[i + charTypeIndex];
                    if (charType === 'WordSplit' && i < lastLtrIndex
                        && characterRangeTypes[i + charTypeIndex - 1] === 'LTR') {
                        ltrText = '';
                        for (let j = i + 1; j <= lastLtrIndex; j++) {
                            ltrText += splittedText[j];
                            splittedText.splice(j, 1);
                            characterRangeTypes.splice(j + charTypeIndex);
                            j--;
                            lastLtrIndex--;
                        }
                        splittedText[i - 1] = splittedText[i - 1] + splittedText[i] + ltrText;
                        splittedText.splice(i, 1);
                        characterRangeTypes.splice(i + charTypeIndex);
                        i--;
                        lastLtrIndex--;
                    }
                }
            }
            else {
                //Return the input text if text bidi is false.
                splittedText = [];
                splittedText.push(text);
            }
        }
        else if (!isTextBidi) {
            //Return the input text if text bidi is false.
            splittedText = [];
            splittedText.push(text);
        }
        if (isTextBidi) {
            for (let j = 1; j < splittedText.length; j++) {
                //Combines the consecutive LTR, RTL, and Number(Number get combined only if it's splitted by non reversing characters (.,:)
                //or if it's lang attribute is represent a RTL language)
                //along with single in-between number non reversing word split character.
                const characterType = characterRangeTypes[j + charTypeIndex];
                if (characterType === 'WordSplit' && splittedText[j].length === 1
                    && j + charTypeIndex + 1 < characterRangeTypes.length && characterRangeTypes[j + charTypeIndex - 1] !== 'WordSplit'
                    && (characterRangeTypes[j + charTypeIndex - 1] !== 'Number' || this.isNumberNonReversingCharacter(splittedText[j], isTextBidi))
                    && characterRangeTypes[j + charTypeIndex - 1] === characterRangeTypes[j + charTypeIndex + 1]) {
                    splittedText[j - 1] = splittedText[j - 1] + splittedText[j] + splittedText[j + 1];
                    splittedText.splice(j, 1);
                    splittedText.splice(j, 1);
                    characterRangeTypes.splice(j + charTypeIndex, 1);
                    characterRangeTypes.splice(j + charTypeIndex);
                    j--;
                    // //Combines the Number along with single non-word split characters (% $ #).
                    // else if (charType=='WordSplit'
                    //     && characterRangeTypes[i + charTypeIndex - 1]=='Number') {
                    //     splittedText[i - 1] = splittedText[i - 1] + splittedText[i];
                    //     splittedText.splice(i, 1);
                    //     characterRangeTypes.splice(i + charTypeIndex, 1);
                    //     i--;
                    // }
                    //Combines the consecutive LTR and Number
                }
                else if (characterType === 'LTR' && (characterRangeTypes[j + charTypeIndex - 1] === 'Number'
                    || characterRangeTypes[j + charTypeIndex - 1] === 'LTR')) {
                    splittedText[j - 1] = splittedText[j - 1] + splittedText[j];
                    characterRangeTypes[j + charTypeIndex - 1] = 'LTR';
                    splittedText.splice(j, 1);
                    characterRangeTypes.splice(j + charTypeIndex, 1);
                    j--;
                }
            }
        }
        return splittedText;
    }
    isNumberNonReversingCharacter(character, isTextBidi) {
        const numberNonReversingCharacters = ',.:';
        //(.,:) are the number non-reversing characters.
        if (numberNonReversingCharacters.indexOf(character[0]) !== -1) {
            if (character[0] === '.' ? !isTextBidi : true) {
                return true;
            }
        }
        return false;
    }
    updateSplittedText(span, splittedText) {
        let text = '';
        const inlineIndex = span.line.children.indexOf(span);
        if (splittedText.length > 1) {
            for (let j = 0; j < splittedText.length; j++) {
                text = splittedText[j];
                if (j > 0) {
                    const newSpan2 = new TextElementBox();
                    newSpan2.line = span.line;
                    newSpan2.characterFormat.copyFormat(span.characterFormat);
                    span.line.children.splice(inlineIndex + j, 0, newSpan2);
                    if (span.revisions.length > 0) {
                        this.updateRevisionForSplittedElement(span, newSpan2, true);
                        newSpan2.isMarkedForRevision = span.isMarkedForRevision;
                    }
                    newSpan2.text = text;
                }
                else {
                    //Replace the source text range with splitted text.
                    span.text = text;
                }
            }
        }
    }
    moveFromNextPage(line) {
        const nextLine = line.nextLine;
        if (nextLine && line.paragraph.childWidgets.indexOf(nextLine) === -1) {
            let splittedParagraph = nextLine.paragraph;
            nextLine.paragraph.childWidgets.splice(nextLine.indexInOwner, 1);
            line.paragraph.childWidgets.push(nextLine);
            nextLine.paragraph = line.paragraph;
            if (splittedParagraph.childWidgets.length === 0) {
                splittedParagraph.destroy();
            }
        }
    }
    cutClientWidth(currentElement) {
        if (this.is2013Justification) {
            return false;
        }
        this.clearLineMeasures();
        const line = currentElement.line;
        line.marginTop = 0;
        let width = 0;
        for (let i = 0; i < line.children.length; i++) {
            const element = line.children[i];
            width += element.width;
            if (currentElement === element) {
                break;
            }
        }
        const splitCurrentWidget = this.viewer.clientActiveArea.width - width < 0;
        const paragarph = currentElement.line.paragraph;
        const bodyWidget = paragarph.bodyWidget;
        if (bodyWidget && bodyWidget.floatingElements.length > 0) {
            this.hasFloatingElement = true;
            this.isXPositionUpdated = true;
            return false;
        }
        if (!splitCurrentWidget) {
            this.viewer.cutFromLeft(this.viewer.clientActiveArea.x + width);
            if (currentElement.line.paragraph.paragraphFormat.textAlignment === 'Justify' &&
                currentElement instanceof TextElementBox) {
                this.splitTextElementWordByWord(currentElement);
            }
            if (isNullOrUndefined(currentElement.nextElement) && this.viewer.clientActiveArea.width > 0
                && !currentElement.line.isLastLine()) {
                this.moveElementFromNextLine(line);
            }
        }
        else if (currentElement.previousElement) {
            this.cutClientWidth(currentElement.previousElement);
        }
        return splitCurrentWidget;
    }
    layoutFieldCharacters(element) {
        if (element.fieldType === 0) {
            if (!isNullOrUndefined(element.formFieldData) && this.isInitialLoad) {
                this.checkAndUpdateFieldData(element);
            }
            if (!this.isFieldCode && (!isNullOrUndefined(element.fieldEnd) || element.hasFieldEnd)) {
                if (this.documentHelper.fieldStacks.indexOf(element) === -1) {
                    this.documentHelper.fieldStacks.push(element);
                }
                this.isFieldCode = true;
                element.hasFieldEnd = true;
            }
        }
        else if (this.documentHelper.fieldStacks.length > 0) {
            if (element.fieldType === 2) {
                const field = this.documentHelper.fieldStacks[this.documentHelper.fieldStacks.length - 1];
                if (field.fieldSeparator === element && (!isNullOrUndefined(field.fieldEnd) || field.hasFieldEnd)) {
                    this.isFieldCode = false;
                }
            }
            else {
                const field = this.documentHelper.fieldStacks[this.documentHelper.fieldStacks.length - 1];
                if (element === field.fieldEnd) {
                    this.documentHelper.fieldStacks.pop();
                    this.isFieldCode = false;
                }
            }
        }
    }
    checkAndUpdateFieldData(fieldBegin) {
        if (fieldBegin.hasFieldEnd && !isNullOrUndefined(fieldBegin.fieldEnd)) {
            if (isNullOrUndefined(fieldBegin.fieldSeparator)) {
                const seperator = new FieldElementBox(2);
                seperator.fieldBegin = fieldBegin;
                seperator.fieldEnd = fieldBegin.fieldEnd;
                seperator.line = fieldBegin.line;
                fieldBegin.line.children.splice(fieldBegin.fieldEnd.indexInOwner, 0, seperator);
                fieldBegin.fieldSeparator = seperator;
                fieldBegin.fieldEnd.fieldSeparator = seperator;
            }
            const previousNode = fieldBegin.fieldEnd.previousNode;
            if (previousNode instanceof FieldElementBox && previousNode.fieldType === 2) {
                const formFieldData = fieldBegin.formFieldData;
                if (formFieldData instanceof CheckBoxFormField) {
                    const checkBoxTextElement = new TextElementBox();
                    checkBoxTextElement.line = fieldBegin.line;
                    const index = fieldBegin.line.children.indexOf(fieldBegin.fieldEnd);
                    fieldBegin.line.children.splice(index, 0, checkBoxTextElement);
                    checkBoxTextElement.characterFormat.copyFormat(fieldBegin.characterFormat);
                    if (formFieldData.checked) {
                        checkBoxTextElement.text = String.fromCharCode(9745);
                    }
                    else {
                        checkBoxTextElement.text = String.fromCharCode(9744);
                    }
                    if (formFieldData.sizeType !== 'Auto') {
                        checkBoxTextElement.characterFormat.fontSize = formFieldData.size * CHECK_BOX_FACTOR;
                    }
                    else {
                        checkBoxTextElement.characterFormat.fontSize = checkBoxTextElement.characterFormat.fontSize * CHECK_BOX_FACTOR;
                    }
                }
                else if (formFieldData instanceof DropDownFormField) {
                    const dropDownTextElement = new TextElementBox();
                    dropDownTextElement.characterFormat.copyFormat(fieldBegin.characterFormat);
                    dropDownTextElement.line = fieldBegin.line;
                    if (formFieldData.dropdownItems.length > 0) {
                        dropDownTextElement.text = formFieldData.dropdownItems[formFieldData.selectedIndex];
                    }
                    else {
                        dropDownTextElement.text = this.documentHelper.textHelper.repeatChar(this.documentHelper.textHelper.getEnSpaceCharacter(), 5);
                    }
                    const index = fieldBegin.line.children.indexOf(fieldBegin.fieldEnd);
                    fieldBegin.line.children.splice(index, 0, dropDownTextElement);
                }
            }
        }
    }
    layoutEmptyLineWidget(paragraph, isEmptyLine, line, isShiftEnter) {
        const paraFormat = paragraph.paragraphFormat;
        let subWidth = 0;
        let whiteSpaceCount = 0;
        isShiftEnter = isNullOrUndefined(isShiftEnter) ? false : isShiftEnter;
        //Calculate line height and descent based on formatting defined in paragraph.
        const paragraphMarkSize = this.documentHelper.textHelper.getParagraphMarkSize(paragraph.characterFormat);
        let maxHeight = paragraphMarkSize.Height;
        let beforeSpacing = this.getBeforeSpacing(paragraph);
        let lineWidget;
        if (paragraph.childWidgets.length > 0 && !isShiftEnter) {
            lineWidget = paragraph.childWidgets[0];
            if (lineWidget.children.length > 0) {
                if (!this.isBidiReLayout && (paraFormat.bidi || this.isContainsRtl(lineWidget))) {
                    this.reArrangeElementsForRtl(lineWidget, paraFormat.bidi);
                    this.isRTLLayout = true;
                }
                const isParagraphStart = lineWidget.isFirstLine();
                const isParagraphEnd = lineWidget.isLastLine();
                let firstLineIndent = 0;
                if (isParagraphStart) {
                    beforeSpacing = this.getBeforeSpacing(paragraph);
                    firstLineIndent = HelperMethods.convertPointToPixel(paraFormat.firstLineIndent);
                }
                const textAlignment = paraFormat.textAlignment;
                if (textAlignment !== 'Left' && this.viewer.textWrap
                    && (!(textAlignment === 'Justify' && isParagraphEnd)
                        || (textAlignment === 'Justify' && paraFormat.bidi))) {
                    const getWidthAndSpace = this.getSubWidth(lineWidget, textAlignment === 'Justify', whiteSpaceCount, firstLineIndent, isParagraphEnd);
                    subWidth = getWidthAndSpace[0].subWidth;
                    whiteSpaceCount = getWidthAndSpace[0].spaceCount;
                }
            }
        }
        else {
            lineWidget = isEmptyLine ? this.addLineWidget(paragraph) : line;
        }
        if (!isNullOrUndefined(paragraph.containerWidget) && paragraph.bodyWidget.floatingElements.length > 0 &&
            !(paragraph.containerWidget instanceof TextFrame)) {
            let elementBox = new TextElementBox();
            elementBox.line = lineWidget;
            lineWidget.children.push(elementBox);
            elementBox.text = '¶';
            elementBox.characterFormat = paragraph.characterFormat;
            elementBox.width = this.documentHelper.textHelper.getTextSize(elementBox, elementBox.characterFormat);
            this.adjustPosition(elementBox, paragraph.bodyWidget);
            paragraph.x += elementBox.padding.left;
            if (isEmptyLine) {
                this.checkInbetweenShapeOverlap(lineWidget);
            }
            lineWidget.children.splice(elementBox.indexInOwner, 1);
        }
        //isNullOrUndefined(this.viewer.currentHeaderFooter) &&
        if (this.viewer instanceof PageLayoutViewer
            && this.viewer.clientActiveArea.height < beforeSpacing + maxHeight
            && this.viewer.clientActiveArea.y !== this.viewer.clientArea.y
            && !(lineWidget.isFirstLine() && isNullOrUndefined(lineWidget.paragraph.previousWidget))) {
            this.moveToNextPage(this.viewer, lineWidget);
        }
        //Gets line spacing.
        const lineSpacing = this.getLineSpacing(paragraph, maxHeight);
        //let maxDescent: number = maxHeight - paragraphMarkSize.BaselineOffset;
        //Calculate the bottom position of current line - max height + line spacing.
        if (!isNaN(this.maxTextHeight)
            && maxHeight < this.maxTextHeight) {
            maxHeight = this.maxTextHeight;
            //maxDescent = maxHeight - this.maxTextBaseline;
        }
        let topMargin = 0;
        let bottomMargin = 0;
        let leftMargin = 0;
        const height = maxHeight;
        const lineSpacingType = paragraph.paragraphFormat.lineSpacingType;
        if (lineSpacingType === 'Multiple') {
            if (lineSpacing > maxHeight) {
                bottomMargin += lineSpacing - maxHeight;
            }
            else {
                topMargin += lineSpacing - maxHeight;
            }
        }
        else if (lineSpacingType === 'Exactly') {
            topMargin += lineSpacing - (topMargin + height + bottomMargin);
        }
        else if (lineSpacing > topMargin + height + bottomMargin) {
            topMargin += lineSpacing - (topMargin + height + bottomMargin);
        }
        topMargin += beforeSpacing;
        bottomMargin += HelperMethods.convertPointToPixel(this.getAfterSpacing(paragraph));
        for (let i = 0; i < lineWidget.children.length; i++) {
            const element = lineWidget.children[i];
            if (i === 0 && element instanceof ListTextElementBox) {
                const textAlignment = paragraph.paragraphFormat.textAlignment;
                if (textAlignment === 'Right') { //Aligns the text as right justified.
                    leftMargin = subWidth;
                }
                else if (textAlignment === 'Center') { //Aligns the text as center justified.
                    leftMargin = subWidth / 2;
                }
                element.margin = new Margin(leftMargin, topMargin, 0, bottomMargin);
                element.line = lineWidget;
                lineWidget.height = topMargin + height + bottomMargin;
            }
        }
        lineWidget.height = topMargin + height + bottomMargin;
        if (isNullOrUndefined(paragraph.nextRenderedWidget) && paragraph.isInsideTable
            && paragraph.previousRenderedWidget instanceof TableWidget && paragraph.isEmpty()
            && (!(paragraph.childWidgets[0].children.length > 0
                && paragraph.childWidgets[0].children[0] instanceof ListTextElementBox)
                || paragraph.childWidgets[0].children.length === 0)) {
            //Special behavior for empty cell mark after nested table, preserved with zero height by default.
            //Empty line is displayed in cell for the last empty paragraph (Cell mark - last paragraph in cell) after a nested table.
            lineWidget.height = 0;
        }
        this.viewer.cutFromTop(this.viewer.clientActiveArea.y + lineWidget.height);
        //Clears the previous line elements from collection.
    }
    layoutListItems(paragraph) {
        if (!this.isFieldCode) {
            if (!isNullOrUndefined(paragraph.paragraphFormat)
                && !isNullOrUndefined(paragraph.paragraphFormat.listFormat)
                && !isNullOrUndefined(this.documentHelper.getListById(paragraph.paragraphFormat.listFormat.listId)) &&
                paragraph.paragraphFormat.listFormat.listLevelNumber >= 0
                && paragraph.paragraphFormat.listFormat.listLevelNumber < 9) {
                this.clearListElementBox(paragraph);
                this.layoutList(paragraph, this.documentHelper);
            }
            else if (paragraph.paragraphFormat.listFormat && paragraph.paragraphFormat.listFormat.listId === -1) {
                this.clearListElementBox(paragraph);
            }
        }
    }
    layoutList(paragraph, documentHelper) {
        const list = documentHelper.getListById(paragraph.paragraphFormat.listFormat.listId);
        this.viewer.updateClientWidth(-HelperMethods.convertPointToPixel(paragraph.paragraphFormat.firstLineIndent));
        const currentListLevel = this.getListLevel(list, paragraph.paragraphFormat.listFormat.listLevelNumber);
        // if (isNullOrUndefined(currentListLevel)) {
        //     return;
        // }
        let lineWidget = paragraph.childWidgets[0];
        if (isNullOrUndefined(lineWidget)) {
            lineWidget = new LineWidget(paragraph);
            paragraph.childWidgets.push(lineWidget);
        }
        let element = new ListTextElementBox(currentListLevel, false);
        element.line = lineWidget;
        if (currentListLevel.listLevelPattern === 'Bullet') {
            element.text = currentListLevel.numberFormat;
        }
        else {
            element.text = this.getListNumber(paragraph.paragraphFormat.listFormat);
        }
        if (this.documentHelper.isIosDevice) {
            let text = element.text;
            text = text === String.fromCharCode(61623) ? String.fromCharCode(9679) : text === String.fromCharCode(61551) + String.fromCharCode(32) ? String.fromCharCode(9675) : text;
            if (text !== element.text) {
                element.text = text;
            }
        }
        documentHelper.textHelper.updateTextSize(element, paragraph);
        let moveToNextPage;
        if (this.viewer instanceof PageLayoutViewer
            && this.viewer.clientActiveArea.height < element.height && this.viewer.clientActiveArea.y !== this.viewer.clientArea.y) {
            moveToNextPage = true;
        }
        this.viewer.cutFromLeft(this.viewer.clientActiveArea.x + element.width);
        //Adds the text element to the line
        lineWidget.children.splice(0, 0, element);
        if (currentListLevel.followCharacter !== 'None') {
            element = new ListTextElementBox(currentListLevel, true);
            if (currentListLevel.followCharacter === 'Tab') {
                element.text = '\t';
                const index = lineWidget.children.indexOf(element);
                let tabWidth = this.getTabWidth(paragraph, this.viewer, index, lineWidget, element);
                documentHelper.textHelper.updateTextSize(element, paragraph);
                element.width = tabWidth;
            }
            else {
                element.text = ' ';
                documentHelper.textHelper.updateTextSize(element, paragraph);
            }
            this.viewer.cutFromLeft(this.viewer.clientActiveArea.x + element.width);
            //Adds the tabSpace to the line
            lineWidget.children.splice(1, 0, element);
            element.line = lineWidget;
        }
        if (moveToNextPage) {
            this.moveToNextPage(this.viewer, lineWidget);
            this.cutClientWidth(element);
            this.hasFloatingElement = false;
            this.isXPositionUpdated = false;
            return;
        }
        if (currentListLevel.followCharacter !== 'None') {
            this.viewer.updateClientWidth(HelperMethods.convertPointToPixel(paragraph.paragraphFormat.firstLineIndent));
        }
    }
    addBodyWidget(area, widget) {
        let bodyWidget;
        if (widget) {
            bodyWidget = widget;
        }
        else {
            bodyWidget = new BodyWidget();
        }
        bodyWidget.width = area.width;
        bodyWidget.x = area.x;
        bodyWidget.y = area.y;
        // this.addSectionInDictionary(this.viewer, section, bodyWidget);
        return bodyWidget;
    }
    /**
     * @private
     */
    addListLevels(abstractList) {
        for (let i = abstractList.levels.length; i < 9; i++) {
            const listLevel = new WListLevel(abstractList);
            const val = i % 3;
            if (abstractList.levels[0].listLevelPattern === 'Bullet') {
                listLevel.listLevelPattern = 'Bullet';
                listLevel.numberFormat = val === 0 ? String.fromCharCode(61623) : val === 1 ? String.fromCharCode(61551) + String.fromCharCode(32) : String.fromCharCode(61607);
                listLevel.characterFormat.fontFamily = listLevel.numberFormat === String.fromCharCode(61607) ? 'Wingdings' : 'Symbol';
            }
            else {
                listLevel.listLevelPattern = this.getListLevelPattern(val);
                listLevel.numberFormat = '%' + (i + 1).toString() + '.';
                listLevel.startAt = 1;
                listLevel.restartLevel = i;
            }
            listLevel.paragraphFormat = new WParagraphFormat(undefined);
            listLevel.paragraphFormat.leftIndent = 48 * (i + 1);
            listLevel.paragraphFormat.firstLineIndent = -24;
            abstractList.levels.push(listLevel);
        }
    }
    addSplittedLineWidget(lineWidget, elementIndex, splittedElementBox) {
        if (this.isWrapText) {
            if (!isNullOrUndefined(splittedElementBox)) {
                lineWidget.children.splice(elementIndex + 1, 0, splittedElementBox);
                splittedElementBox.line = lineWidget;
            }
            return;
        }
        const paragraph = lineWidget.paragraph;
        const movedElementBox = [];
        const lineIndex = paragraph.childWidgets.indexOf(lineWidget);
        if (!isNullOrUndefined(splittedElementBox)) {
            movedElementBox.push(splittedElementBox);
        }
        let newLineWidget = undefined;
        //Move Next element box to temp collection
        for (let i = elementIndex + 1; i < lineWidget.children.length; i++) {
            movedElementBox.push(lineWidget.children[i]);
        }
        if (movedElementBox.length > 0) {
            if (lineIndex === paragraph.childWidgets.length - 1) {
                newLineWidget = new LineWidget(paragraph);
            }
            else {
                newLineWidget = paragraph.childWidgets[lineIndex + 1];
            }
            for (let j = 0; j < movedElementBox.length; j++) {
                movedElementBox[j].line = newLineWidget;
            }
            lineWidget.children.splice(elementIndex + 1, lineWidget.children.length - 1);
            newLineWidget.children = movedElementBox.concat(newLineWidget.children);
            if (paragraph.childWidgets.indexOf(newLineWidget) === -1) {
                paragraph.childWidgets.splice(lineIndex + 1, 0, newLineWidget);
            }
        }
    }
    addElementToLine(paragraph, element) {
        if (!(element instanceof ShapeBase && element.textWrappingStyle !== 'Inline')) {
            if (this.isWrapText) {
                this.isWrapText = false;
                this.viewer.clientActiveArea.width = this.viewer.clientArea.right - this.viewer.clientActiveArea.x;
            }
            this.viewer.cutFromLeft(this.viewer.clientActiveArea.x + element.width);
        }
        if (paragraph.paragraphFormat.textAlignment === 'Justify' && element instanceof TextElementBox) {
            this.splitTextElementWordByWord(element);
        }
    }
    splitElementForClientArea(paragraph, element) {
        //const line: LineWidget = element.line;
        if (element.line.children.length > 0) {
            const previousElement = element.previousElement;
            let index = element.indexInOwner;
            // if line widget contain only single image element box need to skip this from splitting
            // else move element to next line
            if (element.line.children.length > 1) {
                if (previousElement && this.viewer.clientActiveArea.x !== this.viewer.clientArea.x) {
                    index -= 1;
                }
            }
            this.addSplittedLineWidget(element.line, index);
        }
    }
    splitByWord(lineWidget, paragraph, elementBox, text, width, characterFormat) {
        let index = this.getSplitIndexByWord(this.viewer.clientActiveArea.width, text, width, characterFormat);
        if (index > 0 && index < elementBox.length) {
            const indexOf = lineWidget.children.indexOf(elementBox);
            //const lineIndex: number = paragraph.childWidgets.indexOf(lineWidget);
            const splittedElementBox = new TextElementBox();
            text = text.substring(index);
            splittedElementBox.text = text;
            if (text[0] === ' ') {
                const prevLength = text.length;
                text = HelperMethods.trimStart(text); //To trim white space at starting of the text.
                index += prevLength - text.length;
            }
            splittedElementBox.characterFormat.copyFormat(elementBox.characterFormat);
            splittedElementBox.width = this.documentHelper.textHelper.getWidth(splittedElementBox.text, characterFormat);
            splittedElementBox.trimEndWidth = splittedElementBox.width;
            //splittedElementBox.revisions = splittedElementBox.revisions;
            elementBox.text = elementBox.text.substr(0, index);
            elementBox.width -= splittedElementBox.width;
            elementBox.trimEndWidth = elementBox.width;
            if (elementBox.revisions.length > 0) {
                this.updateRevisionForSplittedElement(elementBox, splittedElementBox, true);
                splittedElementBox.isMarkedForRevision = elementBox.isMarkedForRevision;
            }
            splittedElementBox.height = elementBox.height;
            splittedElementBox.baselineOffset = elementBox.baselineOffset;
            this.splitErrorCollection(elementBox, splittedElementBox);
            this.addSplittedLineWidget(lineWidget, indexOf, splittedElementBox);
            this.addElementToLine(paragraph, elementBox);
            if (elementBox.width === 0) {
                lineWidget.children.splice(indexOf, 1);
            }
        }
    }
    splitErrorCollection(elementBox, splittedBox) {
        if (elementBox.errorCollection.length > 0) {
            const errorCollection = [];
            const ignoreItems = elementBox.ignoreOnceItems;
            for (let i = 0; i < elementBox.errorCollection.length; i++) {
                errorCollection.push(elementBox.errorCollection[i]);
            }
            for (let j = 0; j < elementBox.errorCollection.length; j++) {
                const index = elementBox.text.indexOf(elementBox.errorCollection[j].text);
                const textElement = elementBox.errorCollection[j];
                if (index < 0) {
                    errorCollection.splice(0, 1);
                    splittedBox.errorCollection.push(textElement);
                }
                else if (splittedBox.text.indexOf(textElement.text) > 0) {
                    splittedBox.errorCollection.push(textElement);
                }
            }
            splittedBox.ignoreOnceItems = ignoreItems;
            elementBox.ignoreOnceItems = [];
            elementBox.errorCollection = errorCollection;
        }
    }
    splitByCharacter(lineWidget, textElement, text, width, characterFormat) {
        const paragraph = lineWidget.paragraph;
        const index = this.getTextSplitIndexByCharacter(this.viewer.clientArea.width, this.viewer.clientActiveArea.width, text, width, characterFormat);
        let splitWidth = 0;
        if (index < textElement.length) {
            splitWidth = this.documentHelper.textHelper.measureTextExcludingSpaceAtEnd(text.substring(0, index), characterFormat);
            text = text.substring(index);
        }
        if (splitWidth > this.viewer.clientActiveArea.width && textElement.indexInOwner > 0) {
            this.addSplittedLineWidget(lineWidget, textElement.indexInOwner - 1);
            return;
        }
        const indexOf = lineWidget.children.indexOf(textElement);
        if (index < textElement.length) {
            //const lineIndex: number = paragraph.childWidgets.indexOf(lineWidget);
            const splittedElement = new TextElementBox();
            splittedElement.text = text;
            splittedElement.errorCollection = textElement.errorCollection;
            textElement.text = textElement.text.substr(0, index);
            splittedElement.characterFormat.copyFormat(textElement.characterFormat);
            splittedElement.width = this.documentHelper.textHelper.getWidth(splittedElement.text, characterFormat);
            splittedElement.trimEndWidth = splittedElement.width;
            textElement.width -= splittedElement.width;
            textElement.trimEndWidth = textElement.width;
            splittedElement.height = textElement.height;
            splittedElement.baselineOffset = textElement.baselineOffset;
            lineWidget.children.splice(textElement.indexInOwner + 1, 0, splittedElement);
            if (textElement.revisions.length > 0) {
                this.updateRevisionForSplittedElement(textElement, splittedElement, index > 0);
                splittedElement.isMarkedForRevision = textElement.isMarkedForRevision;
            }
            this.addElementToLine(paragraph, textElement);
            this.addSplittedLineWidget(lineWidget, indexOf);
            if (textElement.width === 0) {
                lineWidget.children.splice(indexOf, 1);
            }
        }
        else {
            //Adds the last text element on inline to line elements collection
            this.addSplittedLineWidget(lineWidget, indexOf);
            this.addElementToLine(paragraph, textElement);
        }
    }
    updateRevisionForSplittedElement(item, splittedElement, isSplitted, isJustify) {
        if (item.revisions.length > 0) {
            for (let i = 0; i < item.revisions.length; i++) {
                const currentRevision = item.revisions[i];
                if (isSplitted) {
                    splittedElement.revisions.push(currentRevision);
                    let rangeIndex = currentRevision.range.length - 1;
                    if (currentRevision.range[rangeIndex] instanceof WCharacterFormat) {
                        currentRevision.range.push(splittedElement);
                    }
                    else {
                        rangeIndex = currentRevision.range.indexOf(item);
                        if (rangeIndex < 0) {
                            currentRevision.range.push(splittedElement);
                        }
                        else {
                            if (isJustify) {
                                currentRevision.range.splice(rangeIndex, 0, splittedElement);
                            }
                            else {
                                currentRevision.range.splice(rangeIndex + 1, 0, splittedElement);
                            }
                        }
                    }
                }
                else {
                    currentRevision.range.splice(currentRevision.range.length - 1, 1);
                    currentRevision.range.push(splittedElement);
                    splittedElement.revisions.push(currentRevision);
                }
            }
        }
    }
    splitTextElementWordByWord(textElement) {
        const lineWidget = textElement.line;
        let indexOf = lineWidget.children.indexOf(textElement);
        let startIndex = indexOf;
        let paddingLeft = textElement.padding.left;
        textElement.padding.left = 0;
        let text = textElement.text;
        let format;
        const characterUptoWs = text.trim().indexOf(' ');
        if (characterUptoWs >= 0) {
            lineWidget.children.splice(indexOf, 1);
            format = textElement.characterFormat;
            //const fontSize: number = format.fontSize;
            let index = textElement.length - HelperMethods.trimStart(text).length; //Trim start
            while (index < textElement.length) {
                index = this.getTextIndexAfterSpace(text, index);
                if (index === 0 || index === textElement.length) {
                    break;
                }
                if (index < textElement.length) {
                    const splittedElement = new TextElementBox();
                    const splittedText = text.substring(0, index);
                    text = text.substring(index);
                    if (text.substring(0, 1) === ' ') {
                        // start of the text is trimmed and its length is reduced from text length.
                        index += text.length - HelperMethods.trimStart(text).length;
                    }
                    splittedElement.text = splittedText;
                    splittedElement.characterFormat.copyFormat(textElement.characterFormat);
                    splittedElement.line = lineWidget;
                    splittedElement.width = this.documentHelper.textHelper.getWidth(splittedElement.text, format);
                    splittedElement.trimEndWidth = splittedElement.width;
                    splittedElement.height = textElement.height;
                    splittedElement.baselineOffset = textElement.baselineOffset;
                    lineWidget.children.splice(indexOf, 0, splittedElement);
                    if (textElement.revisions.length > 0) {
                        this.updateRevisionForSplittedElement(textElement, splittedElement, index > 0, true);
                        splittedElement.isMarkedForRevision = textElement.isMarkedForRevision;
                    }
                    textElement.text = text;
                    textElement.width -= splittedElement.width;
                    textElement.trimEndWidth = textElement.width;
                    if (textElement.width === 0 && lineWidget.children.indexOf(textElement) !== -1) {
                        lineWidget.children.splice(lineWidget.children.indexOf(textElement), 1);
                    }
                    index = 0;
                    indexOf++;
                }
            }
            textElement.text = text;
            lineWidget.children.splice(indexOf, 0, textElement);
        }
        lineWidget.children[startIndex].padding.left = paddingLeft;
    }
    splitTextForClientArea(lineWidget, element, text, width, characterFormat) {
        const paragraph = lineWidget.paragraph;
        let isSplitByWord = true;
        let isSplitByCharacter = false;
        let index = -1;
        if (!(text.substring(0, 1) === ' ') && !(text.substring(0, 1) === '-')) {
            let textWidth = width;
            let characterUptoWS = 0;
            characterUptoWS = HelperMethods.trimEnd(text).indexOf(' ') + 1;
            if (characterUptoWS == 0) {
                characterUptoWS = HelperMethods.trimEnd(text).indexOf('-') + 1;
                if (characterUptoWS > 0) {
                    isSplitByCharacter = true;
                }
            }
            index = characterUptoWS;
            //Checks whether text not starts with white space. If starts with white space, no need to check previous text blocks.
            if (index > 0) {
                textWidth = this.documentHelper.textHelper.measureTextExcludingSpaceAtEnd(text.slice(0, index), characterFormat);
            }
            if (this.viewer.clientActiveArea.width < textWidth) {
                //Check and split the previous text elements to next line.
                isSplitByWord = this.checkPreviousElement(lineWidget, lineWidget.children.indexOf(element), characterFormat);
                if (isSplitByWord) {
                    //lineWidget = paragraph.childWidgets[paragraph.childWidgets.indexOf(lineWidget) + 1] as LineWidget;
                    //isSplitByWord = textWidth <= this.viewer.clientActiveArea.width;
                    return;
                }
            }
        }
        else {
            index = 1;
        }
        if (width <= this.viewer.clientActiveArea.width) {
            //Fits the text in current line.
            this.addElementToLine(paragraph, element);
        }
        else if (isSplitByWord && !isSplitByCharacter && (index > 0 || text.indexOf(' ') !== -1 || text.indexOf('-') !== -1)) {
            this.splitByWord(lineWidget, paragraph, element, text, width, characterFormat);
        }
        else {
            this.splitByCharacter(lineWidget, element, text, width, characterFormat);
        }
    }
    splitByLineBreakOrTab(viewer, span, index, spiltBy) {
        // Splits tab character to separate SpanAdv
        const inlineIndex = span.line.children.indexOf(span);
        const value = span.text;
        const remainder = value.substring(index);
        const newSpan = spiltBy === '\t' ? new TabElementBox() : new TextElementBox();
        newSpan.line = span.line;
        this.updateRevisionForSplittedElement(span, newSpan, true);
        newSpan.characterFormat.copyFormat(span.characterFormat);
        span.line.children.splice(inlineIndex + 1, 0, newSpan);
        if (index > 0 && remainder.length === 1) {
            newSpan.text = value.substring(index);
            span.text = value.substring(0, index);
        }
        else if (index > 0) {
            newSpan.text = spiltBy;
            const newText = new TextElementBox();
            newText.line = span.line;
            newText.text = value.substring(index + 1);
            this.updateRevisionForSplittedElement(span, newText, true);
            newText.characterFormat.copyFormat(span.characterFormat);
            span.line.children.splice(inlineIndex + 2, 0, newText);
            span.text = value.substring(0, index);
        }
        else if (remainder !== '') {
            newSpan.text = value.substring(index + 1);
            span.text = spiltBy;
        }
    }
    /* eslint-disable  */
    moveToNextLine(line) {
        let paragraph = line.paragraph;
        let paraFormat = paragraph.paragraphFormat;
        let isParagraphStart = line.isFirstLine();
        let isParagraphEnd = line.isLastLine();
        let height = 0;
        let maxDescent = 0;
        let afterSpacing = 0;
        let beforeSpacing = 0;
        let lineSpacing = 0;
        let firstLineIndent = 0;
        this.updateLineWidget(line);
        height = this.maxTextHeight;
        maxDescent = height - this.maxTextBaseline;
        let pageIndex = 0;
        let skip2013Justification = false;
        if (paragraph.bodyWidget && !(paragraph.bodyWidget instanceof HeaderFooterWidget)) {
            pageIndex = this.documentHelper.pages.indexOf(paragraph.bodyWidget.page);
        }
        //Updates before spacing at the top of Paragraph first line.
        if (isParagraphStart) {
            beforeSpacing = this.getBeforeSpacing(paragraph, pageIndex);
            firstLineIndent = HelperMethods.convertPointToPixel(paraFormat.firstLineIndent);
        }
        //Updates after spacing at the bottom of Paragraph last line.
        if (isParagraphEnd) {
            afterSpacing = HelperMethods.convertPointToPixel(this.getAfterSpacing(paragraph));
        }
        if (!this.isBidiReLayout && (paraFormat.bidi || this.isContainsRtl(line))) {
            this.reArrangeElementsForRtl(line, paraFormat.bidi);
            this.isRTLLayout = true;
        }
        if (isNaN(this.maxTextHeight)) {
            //Calculate line height and descent based on formatting defined in paragraph.
            let measurement = this.documentHelper.textHelper.measureText('a', paragraph.characterFormat);
            height = measurement.Height;
            maxDescent = height - measurement.BaselineOffset;
        }
        else {
            height = this.maxTextHeight;
            maxDescent = height - this.maxTextBaseline;
        }
        // Gets line spacing.
        lineSpacing = this.getLineSpacing(paragraph, height);
        if (paraFormat.lineSpacingType === 'Exactly'
            && lineSpacing < maxDescent + this.maxBaseline) {
            lineSpacing = maxDescent + this.maxBaseline;
        }
        let subWidth = 0;
        let whiteSpaceCount = 0;
        let getWidthAndSpace;
        let textAlignment = paraFormat.textAlignment;
        let totalSpaceCount = 0;
        // calculates the sub width, for text alignments - Center, Right, Justify.
        // if the element is paragraph end and para bidi is true and text alignment is justify
        // we need to calculate subwidth and add it to the left margin of the element.
        if (textAlignment !== 'Left' && this.viewer.textWrap && (!(textAlignment === 'Justify' && isParagraphEnd)
            || (textAlignment === 'Justify' && paraFormat.bidi) || (this.is2013Justification && isParagraphEnd))) {
            getWidthAndSpace = this.getSubWidth(line, textAlignment === 'Justify', whiteSpaceCount, firstLineIndent, isParagraphEnd);
            subWidth = getWidthAndSpace[0].subWidth;
            whiteSpaceCount = getWidthAndSpace[0].spaceCount;
            totalSpaceCount = getWidthAndSpace[0].totalSpaceCount;
            skip2013Justification = line.isEndsWithPageBreak || line.isEndsWithLineBreak || line.paragraph.bidi || this.isRTLLayout;
        }
        if (!skip2013Justification && (getWidthAndSpace && getWidthAndSpace.length === 1) && this.viewer.clientActiveArea.width > 0 &&
            !isParagraphEnd && !this.is2013Justification && textAlignment === 'Justify' && this.documentHelper.compatibilityMode === 'Word2013') {
            let availableWidth = this.viewer.clientActiveArea.width;
            let totalSpaceWidth = this.getTotalSpaceWidth(line);
            let averageWidthOfSpace = totalSpaceWidth / totalSpaceCount;
            let avgAvailableLineWidthForSpace = (availableWidth) / totalSpaceCount;
            let diffFactor = (avgAvailableLineWidthForSpace / averageWidthOfSpace) * 100;
            let widthForAdjustment = 0;
            if (diffFactor <= 33) {
                widthForAdjustment = totalSpaceWidth / 8;
            }
            else {
                widthForAdjustment = totalSpaceWidth / 4;
            }
            this.viewer.clientActiveArea.x -= widthForAdjustment;
            this.viewer.clientActiveArea.width += widthForAdjustment;
            this.is2013Justification = true;
            this.moveElementFromNextLine(line);
            this.nextElementToLayout = line.children[line.children.length - 1];
            return;
        }
        else {
            if (this.is2013Justification && isParagraphEnd) {
                if (subWidth > 0) {
                    subWidth = 0;
                    whiteSpaceCount = 0;
                }
            }
            this.is2013Justification = false;
            this.nextElementToLayout = undefined;
        }
        let addSubWidth = false;
        let wrapIndex = 0;
        let lineSpacingType = paraFormat.lineSpacingType;
        let isStarted = false;
        for (let i = 0; i < line.children.length; i++) {
            let topMargin = 0;
            let bottomMargin = 0;
            let leftMargin = 0;
            let elementBox = line.children[i];
            if (!isNullOrUndefined(getWidthAndSpace) && isStarted && elementBox.padding.left > 0 &&
                (getWidthAndSpace.length > wrapIndex + 1)) {
                let previousWidth = subWidth;
                if (textAlignment === "Justify") {
                    previousWidth = subWidth * getWidthAndSpace[wrapIndex].spaceCount;
                }
                else if (textAlignment === "Center") {
                    previousWidth = subWidth / 2;
                }
                elementBox.padding.left = elementBox.padding.left - previousWidth;
                let subWidthInfo = getWidthAndSpace[++wrapIndex];
                subWidth = subWidthInfo.subWidth;
                whiteSpaceCount = subWidthInfo.spaceCount;
            }
            if (elementBox instanceof ShapeBase && elementBox.textWrappingStyle !== 'Inline') {
                continue;
            }
            isStarted = true;
            let alignElements = this.alignLineElements(elementBox, topMargin, bottomMargin, maxDescent, addSubWidth, subWidth, textAlignment, whiteSpaceCount, i === line.children.length - 1);
            topMargin = alignElements.topMargin;
            bottomMargin = alignElements.bottomMargin;
            addSubWidth = alignElements.addSubWidth;
            whiteSpaceCount = alignElements.whiteSpaceCount;
            //Updates line spacing, paragraph after/ before spacing and aligns the text to base line offset.
            if (lineSpacingType === 'Multiple') {
                if (lineSpacing > height) {
                    bottomMargin += lineSpacing - height;
                }
                else {
                    topMargin += lineSpacing - height;
                }
            }
            else if (lineSpacingType === 'Exactly') {
                topMargin += lineSpacing - (topMargin + elementBox.height + bottomMargin);
            }
            else if (lineSpacing > topMargin + elementBox.height + bottomMargin) {
                topMargin += lineSpacing - (topMargin + elementBox.height + bottomMargin);
            }
            if (pageIndex > 0 && paragraph === paragraph.bodyWidget.childWidgets[0] && this.documentHelper.pages[pageIndex].sectionIndex === this.documentHelper.pages[pageIndex - 1].sectionIndex) {
                topMargin += 0;
            }
            else {
                topMargin += beforeSpacing;
            }
            bottomMargin += afterSpacing;
            if (i === 0 || (!(elementBox instanceof ShapeBase && elementBox.textWrappingStyle !== 'Inline') &&
                elementBox.previousElement instanceof ShapeBase && elementBox.previousElement.textWrappingStyle !== 'Inline')
                || elementBox.padding.left > 0) {
                line.height = topMargin + elementBox.height + bottomMargin;
                if (textAlignment === 'Right' || (textAlignment === 'Justify' && paraFormat.bidi && isParagraphEnd)) {
                    //Aligns the text as right justified and consider subwidth for bidirectional paragrph with justify.
                    leftMargin = subWidth;
                }
                else if (textAlignment === 'Center') {
                    //Aligns the text as center justified.
                    leftMargin = subWidth / 2;
                }
            }
            elementBox.margin = new Margin(leftMargin, topMargin, 0, bottomMargin);
            elementBox.line = line;
        }
        if (!isNullOrUndefined(line.paragraph.bodyWidget) && !isNullOrUndefined(line.paragraph.bodyWidget.page.headerWidget)
            && line.paragraph.bodyWidget.page.headerWidget.floatingElements.length > 0
            && line.paragraph === line.paragraph.bodyWidget.childWidgets[0]
            && line.indexInOwner === 0) {
            //To check whether first para in the page overlaps with shape in Header.
            this.checkInbetweenShapeOverlap(line, line.paragraph.bodyWidget.page.headerWidget.floatingElements);
        }
        this.checkInbetweenShapeOverlap(line);
        if (line.isLastLine() && line.indexInOwner === 0 && line.paragraph.paragraphFormat.widowControl) {
            let previousSplitWidget = line.paragraph.previousSplitWidget;
            if (!isNullOrUndefined(previousSplitWidget) && !previousSplitWidget.isEndsWithPageBreak) {
                let startLineIndex = previousSplitWidget.childWidgets.length - 1;
                if (previousSplitWidget.childWidgets.length === 2) {
                    startLineIndex = 0;
                }
                this.splitParagraph(previousSplitWidget, startLineIndex, line.paragraph);
                this.updateClientAreaForNextBlock(line, line.paragraph);
            }
        }
        this.viewer.cutFromTop(this.viewer.clientActiveArea.y + line.height);
        this.wrapPosition = [];
    }
    //Checks Inbetween Overlap & Updates Line marginTop
    checkInbetweenShapeOverlap(line, floatingElements) {
        if (!(line.paragraph.containerWidget instanceof TextFrame) && line.paragraph.bodyWidget) {
            let overlapShape;
            let lineY = this.getLineY(line);
            let isInsideTable = line.paragraph.isInsideTable;
            if (isNullOrUndefined(floatingElements)) {
                floatingElements = line.paragraph.bodyWidget.floatingElements;
            }
            /* eslint:disable */
            floatingElements.sort(function (a, b) { return a.y - b.y; });
            floatingElements.forEach((shape) => {
                if (isInsideTable && shape.line && !shape.line.paragraph.isInsideTable || isNullOrUndefined(shape.line)) {
                    return;
                }
                let lineRect;
                if (shape.textWrappingStyle === 'TopAndBottom' && shape instanceof ImageElementBox) {
                    lineRect = new Rect(line.paragraph.x, this.viewer.clientActiveArea.y, line.paragraph.width, line.children[0].height);
                }
                else {
                    lineRect = new Rect(line.paragraph.x, this.viewer.clientActiveArea.y, line.paragraph.width, line.height);
                }
                let shapeRect = new Rect(shape.x, shape.y - shape.distanceTop, shape.width, shape.height);
                if (shape.line && this.isRelayout && !this.isRelayoutOverlap && this.viewer.documentHelper.selection.isExistAfter(shape.line.paragraph, line.paragraph)
                    || this.isRelayout && this.isRelayoutOverlap && this.viewer.documentHelper.selection.isExistAfter(shape.line.paragraph, this.endOverlapWidget)) {
                    return;
                }
                let considerShape = (shape.textWrappingStyle === 'TopAndBottom');
                if (overlapShape && considerShape &&
                    overlapShape.y + overlapShape.height + overlapShape.distanceBottom + line.height > shape.y - shape.distanceTop &&
                    overlapShape.y - overlapShape.distanceTop < shape.y - shape.distanceTop &&
                    shape.y + shape.height + shape.distanceBottom > overlapShape.y + overlapShape.height + overlapShape.distanceBottom) {
                    overlapShape = shape;
                    line.marginTop = ((shape.y + shape.height + shape.distanceBottom) - lineY);
                }
                else if (considerShape && !overlapShape && lineRect.isIntersecting(shapeRect)) {
                    overlapShape = shape;
                    line.marginTop = ((shape.y + shape.height + shape.distanceBottom) - lineY);
                }
            });
            if (overlapShape) {
                this.viewer.cutFromTop(overlapShape.y + overlapShape.height + overlapShape.distanceBottom);
            }
            else if (this.isRelayoutOverlap) {
                line.marginTop = 0;
            }
        }
    }
    getLineY(line) {
        let para = line.paragraph;
        let lineY = para.y;
        if (!para.isEmpty()) {
            let lineWidget = para.firstChild;
            while (lineWidget !== line) {
                lineY = lineY + lineWidget.height + lineWidget.marginTop;
                lineWidget = lineWidget.nextLine;
            }
        }
        return lineY;
    }
    updateLineWidget(line) {
        let spaceHeight = 0;
        let spaceBaseline = 0;
        for (let i = 0; i < line.children.length; i++) {
            let element = line.children[i];
            if (element instanceof ShapeBase && element.textWrappingStyle !== 'Inline') {
                continue;
            }
            if (element instanceof TextElementBox && typeof element.text === 'string' && element.text.replace(/\s+/g, '').length === 0) {
                if (spaceHeight < element.height) {
                    spaceHeight = element.height;
                    spaceBaseline = element.baselineOffset;
                }
                continue;
            }
            if (element instanceof TextElementBox || element instanceof ListTextElementBox) {
                let elementHeight = element.height;
                let baselineOffset = element.baselineOffset;
                //We have increased the checkbox form field font size using a constant factor `CHECK_BOX_FACTOR`
                //To match the MS Word check box rendering size.
                //Due to it line height also get increased. So, handled adjusting height while updating line height.
                if (element instanceof TextElementBox && element.isCheckBoxElement) {
                    elementHeight = elementHeight / CHECK_BOX_FACTOR;
                    baselineOffset = baselineOffset / CHECK_BOX_FACTOR;
                }
                if (this.maxTextHeight < elementHeight) {
                    this.maxTextHeight = elementHeight;
                    this.maxTextBaseline = baselineOffset;
                }
                if (this.maxBaseline < this.maxTextBaseline) {
                    this.maxBaseline = this.maxTextBaseline;
                }
            }
            else if (this.maxBaseline < element.height) {
                this.maxBaseline = element.height;
            }
        }
        if (this.maxTextHeight === 0 && spaceHeight !== 0) {
            if (line.isLastLine() && this.documentHelper.selection) {
                let paragraphMarkSize = this.documentHelper.selection.getParagraphMarkSize(line.paragraph, 0, 0);
                this.maxTextHeight = paragraphMarkSize.height;
                this.maxTextBaseline = spaceBaseline;
            }
            else {
                this.maxTextHeight = spaceHeight;
                this.maxTextBaseline = spaceBaseline;
            }
            if (this.maxBaseline < this.maxTextBaseline) {
                this.maxBaseline = this.maxTextBaseline;
            }
        }
    }
    moveToNextPage(viewer, line, isPageBreak) {
        if (this.isFootNoteLayoutStart) {
            return;
        }
        if (this.isRelayoutOverlap && this.endOverlapWidget !== line.paragraph) {
            line = this.endOverlapWidget.childWidgets[0];
        }
        let paragraphWidget = line.paragraph;
        let startBlock;
        let startIndex = 0;
        let keepLinesTogether = false;
        let keepWithNext = false;
        if (paragraphWidget && !(!isNullOrUndefined(paragraphWidget.containerWidget) && !isNullOrUndefined(paragraphWidget.containerWidget.containerWidget) && paragraphWidget.containerWidget.containerWidget instanceof FootNoteWidget
            && paragraphWidget.containerWidget.containerWidget.footNoteType === 'Footnote')) {
            let index = 0;
            if (paragraphWidget instanceof FootNoteWidget) {
                return;
            }
            if (!isNullOrUndefined(line)) {
                index = paragraphWidget.childWidgets.indexOf(line);
                if (index !== 0) {
                    if (paragraphWidget.paragraphFormat.keepLinesTogether && !isNullOrUndefined(paragraphWidget.previousWidget)) {
                        index = 0;
                        keepLinesTogether = true;
                    }
                    else if (index == 1 && !line.previousLine.isEndsWithPageBreak && paragraphWidget.paragraphFormat.widowControl &&
                        !isNullOrUndefined(paragraphWidget.previousWidget)) {
                        index = 0;
                        keepLinesTogether = true;
                    }
                }
                if (index > 0 || isPageBreak) {
                    paragraphWidget.height = viewer.clientActiveArea.y - paragraphWidget.y;
                }
                if (index === 0 && !paragraphWidget.isEndsWithPageBreak) {
                    let blockInfo = this.alignBlockElement(paragraphWidget);
                    if (!isNullOrUndefined(blockInfo.node)) {
                        startBlock = blockInfo.node instanceof TableRowWidget ? this.splitRow(blockInfo.node) : blockInfo.node;
                        startIndex = startBlock instanceof TableWidget ? 0 : parseInt(blockInfo.position.index, 10);
                        paragraphWidget = startBlock;
                        index = startIndex;
                        keepLinesTogether = false;
                        keepWithNext = true;
                    }
                }
            }
            /* eslint-disable-next-line max-len */
            if (!isNullOrUndefined(paragraphWidget.bodyWidget) && !isNullOrUndefined(paragraphWidget.bodyWidget.containerWidget) && !(paragraphWidget.bodyWidget.containerWidget instanceof FootNoteWidget) && paragraphWidget.bodyWidget.page.footnoteWidget !== undefined) {
                // this.viewer.updateClientAreaForBlock(paragraphWidget.bodyWidget.page.footnoteWidget.block, true);
                this.layoutfootNote(paragraphWidget.bodyWidget.page.footnoteWidget);
                // this.viewer.updateClientAreaForBlock(paragraphWidget.bodyWidget.page.footnoteWidget.block, false);
            }
            let isEndNote = paragraphWidget.containerWidget && paragraphWidget.containerWidget.containerWidget instanceof FootNoteWidget
                && paragraphWidget.containerWidget.containerWidget.footNoteType === 'Endnote';
            let nextBody = this.moveBlocksToNextPage(paragraphWidget, index === 0);
            this.viewer.updateClientArea(nextBody.sectionFormat, nextBody.page);
            if (isEndNote && nextBody.page.endnoteWidget) {
                nextBody.page.endnoteWidget.y = this.viewer.clientActiveArea.y;
                this.viewer.cutFromTop(this.viewer.clientActiveArea.y + nextBody.page.endnoteWidget.height);
            }
            this.viewer.updateClientAreaForBlock(paragraphWidget, true);
            if (index > 0 && paragraphWidget.floatingElements.length == 0) {
                if (line.isLastLine() && isPageBreak) {
                    return;
                }
                let nextParagraph;
                if (nextBody.firstChild instanceof ParagraphWidget && nextBody.firstChild.equals(paragraphWidget)) {
                    nextParagraph = nextBody.firstChild;
                }
                else {
                    nextParagraph = new ParagraphWidget();
                }
                nextParagraph = this.addParagraphWidget(this.viewer.clientActiveArea, nextParagraph);
                nextParagraph.index = paragraphWidget.index;
                let insertIndex = 0;
                for (let i = index; i < paragraphWidget.childWidgets.length; i++) {
                    let lineWidget = paragraphWidget.childWidgets[i];
                    lineWidget.paragraph = nextParagraph;
                    nextParagraph.childWidgets.splice(insertIndex, 0, lineWidget);
                    lineWidget.paragraph = nextParagraph;
                    insertIndex++;
                }
                nextParagraph.paragraphFormat = paragraphWidget.paragraphFormat;
                nextParagraph.characterFormat = paragraphWidget.characterFormat;
                paragraphWidget.childWidgets.splice(index);
                if (isEndNote) {
                    if (isNullOrUndefined(nextBody.page.endnoteWidget)) {
                        this.addEmptyFootNoteToBody(nextBody, 'Endnote');
                        nextBody.page.endnoteWidget.y = this.viewer.clientActiveArea.y;
                        this.viewer.cutFromTop(this.viewer.clientActiveArea.y + nextBody.page.endnoteWidget.height);
                    }
                    if (nextBody.page.endnoteWidget.bodyWidgets.length === 0 || (paragraphWidget.bodyWidget.nextRenderedWidget
                        && paragraphWidget.bodyWidget.nextRenderedWidget.firstChild
                        && paragraphWidget.bodyWidget.nextRenderedWidget.firstChild.index === 0)) {
                        nextBody.page.endnoteWidget.bodyWidgets.splice(0, 0, this.createSplitBody(paragraphWidget.bodyWidget));
                    }
                    nextParagraph.containerWidget = paragraphWidget.containerWidget;
                }
                paragraphWidget = nextParagraph;
            }
            else if (paragraphWidget.floatingElements.length > 0 && index > 0) {
                let body = paragraphWidget.containerWidget;
                body.childWidgets.splice(body.childWidgets.indexOf(paragraphWidget), 1);
                nextBody.childWidgets.splice(0, 0, paragraphWidget);
                for (let i = 0; i < paragraphWidget.floatingElements.length; i++) {
                    if (body.floatingElements.indexOf(paragraphWidget.floatingElements[i]) != -1) {
                        body.floatingElements.splice(body.floatingElements.indexOf(paragraphWidget.floatingElements[i]), 1);
                        nextBody.floatingElements.push(paragraphWidget.floatingElements[i]);
                    }
                }
                paragraphWidget.containerWidget = nextBody;
                nextBody.height += paragraphWidget.height;
            }
            else if (!isPageBreak) {
                paragraphWidget.containerWidget.removeChild(paragraphWidget.indexInOwner);
                if (isEndNote && paragraphWidget.containerWidget.childWidgets.length === 0) {
                    let index = paragraphWidget.containerWidget.containerWidget.bodyWidgets.indexOf(paragraphWidget.containerWidget);
                    paragraphWidget.containerWidget.containerWidget.bodyWidgets.splice(index, 1);
                    if (paragraphWidget.containerWidget.page.endnoteWidget.bodyWidgets.length === 0) {
                        paragraphWidget.containerWidget.page.endnoteWidget = undefined;
                    }
                }
                if (paragraphWidget.floatingElements.length > 0) {
                    this.addRemoveFloatElementsFromBody(paragraphWidget, paragraphWidget.containerWidget, false);
                }
            }
            if (!isPageBreak) {
                if (isEndNote) {
                    if (isNullOrUndefined(nextBody.page.endnoteWidget)) {
                        this.addEmptyFootNoteToBody(nextBody, 'Endnote');
                        nextBody.page.endnoteWidget.y = this.viewer.clientActiveArea.y;
                        this.viewer.cutFromTop(this.viewer.clientActiveArea.y + nextBody.page.endnoteWidget.height);
                    }
                    if (paragraphWidget.bodyWidget.nextWidget) {
                        this.moveEndNotesToNextPage(paragraphWidget.bodyWidget.nextWidget, paragraphWidget.bodyWidget.page, nextBody.page);
                    }
                    if (nextBody.page.endnoteWidget.bodyWidgets.length === 0 || (paragraphWidget.bodyWidget.nextRenderedWidget
                        && paragraphWidget.bodyWidget.nextRenderedWidget.firstChild
                        && paragraphWidget.bodyWidget.nextRenderedWidget.firstChild.index === 0)) {
                        let endNoteElement = paragraphWidget.containerWidget.footNoteReference;
                        nextBody.page.endnoteWidget.bodyWidgets.splice(0, 0, this.createSplitBody(paragraphWidget.bodyWidget));
                        if (paragraphWidget.index === 0 && endNoteElement) {
                            paragraphWidget.bodyWidget.footNoteReference.bodyWidget = nextBody.page.endnoteWidget.bodyWidgets[0];
                        }
                    }
                    nextBody.page.endnoteWidget.bodyWidgets[0].footNoteReference = paragraphWidget.bodyWidget.footNoteReference;
                    nextBody.page.endnoteWidget.bodyWidgets[0].childWidgets.splice(0, 0, paragraphWidget);
                    paragraphWidget.containerWidget = nextBody.page.endnoteWidget.bodyWidgets[0];
                    paragraphWidget.containerWidget.containerWidget = nextBody.page.endnoteWidget;
                    nextBody.page.endnoteWidget.bodyWidgets[0].page = nextBody.page;
                }
                else if (nextBody.childWidgets.indexOf(paragraphWidget) === -1) {
                    nextBody.childWidgets.splice(0, 0, paragraphWidget);
                    if (paragraphWidget.floatingElements.length > 0) {
                        this.addRemoveFloatElementsFromBody(paragraphWidget, nextBody, true);
                    }
                    paragraphWidget.containerWidget = nextBody;
                }
                this.viewer.updateClientAreaLocation(paragraphWidget, this.viewer.clientActiveArea);
                if (keepLinesTogether || keepWithNext) {
                    if (paragraphWidget.bodyWidget.page.footnoteWidget) {
                        this.layoutfootNote(paragraphWidget.bodyWidget.page.footnoteWidget);
                    }
                    if (line.paragraph !== paragraphWidget) {
                        if (paragraphWidget instanceof TableWidget) {
                            this.clearTableWidget(paragraphWidget, true, true, false);
                        }
                        this.layoutBlock(paragraphWidget, 0);
                        viewer.updateClientAreaForBlock(paragraphWidget, false);
                    }
                    let lastBlock = line.paragraph;
                    if (keepWithNext) {
                        let nextBlock = paragraphWidget.nextWidget;
                        if (!isNullOrUndefined(nextBlock)) {
                            do {
                                viewer.updateClientAreaForBlock(nextBlock, true);
                                if (nextBlock !== lastBlock) {
                                    if (nextBlock instanceof TableWidget) {
                                        this.clearTableWidget(nextBlock, true, true, false);
                                    }
                                    this.layoutBlock(nextBlock, 0);
                                    viewer.updateClientAreaForBlock(nextBlock, false);
                                }
                                else {
                                    this.viewer.updateClientAreaLocation(nextBlock, this.viewer.clientActiveArea);
                                    break;
                                }
                                nextBlock = nextBlock.nextWidget;
                            } while (nextBlock);
                        }
                    }
                    this.updateClientAreaForNextBlock(line, lastBlock);
                }
                if (line.indexInOwner === 0 && !(line.children[0] instanceof ListTextElementBox)) {
                    let firstLineIndent = -HelperMethods.convertPointToPixel(line.paragraph.paragraphFormat.firstLineIndent);
                    this.viewer.updateClientWidth(firstLineIndent);
                }
            }
        }
        if (paragraphWidget instanceof ParagraphWidget &&
            paragraphWidget.floatingElements.length > 0 && !isPageBreak) {
            for (let m = 0; m < paragraphWidget.floatingElements.length; m++) {
                let shape = paragraphWidget.floatingElements[m];
                let position = this.getFloatingItemPoints(shape);
                shape.y = position.y;
                shape.x = position.x;
                if (shape instanceof ShapeElementBox)
                    this.updateChildLocationForCellOrShape(shape.y, shape);
            }
        }
        if (this.isRelayoutOverlap && this.endOverlapWidget) {
            let block = this.endOverlapWidget.previousRenderedWidget;
            let para = line.paragraph;
            while (para) {
                para.floatingElements.forEach((shape) => {
                    if (block.bodyWidget.floatingElements.indexOf(shape) !== -1) {
                        block.bodyWidget.floatingElements.splice(block.bodyWidget.floatingElements.indexOf(shape), 1);
                        line.paragraph.bodyWidget.floatingElements.push(shape);
                    }
                });
                para = para !== this.endOverlapWidget ? para.nextWidget : undefined;
            }
            this.layoutStartEndBlocks(this.startOverlapWidget, this.endOverlapWidget);
            this.startOverlapWidget = undefined;
            this.viewer.clientActiveArea.height = this.viewer.clientActiveArea.bottom - this.endOverlapWidget.y;
            this.viewer.clientActiveArea.y = this.endOverlapWidget.y;
        }
    }
    /**
     * @param {ParagraphWidget} paragarph - the paragraph
     * @param {BodyWidget} body - the bodyWidget
     * @param {boolean} add - to specify add or remove floating elements from body widget.
     */
    addRemoveFloatElementsFromBody(paragarph, body, add) {
        if (paragarph.floatingElements.length > 0) {
            for (let x = 0; x < paragarph.floatingElements.length; x++) {
                if (add) {
                    if (body.floatingElements.indexOf(paragarph.floatingElements[x]) === -1) {
                        body.floatingElements.push(paragarph.floatingElements[x]);
                    }
                }
                else {
                    if (body.floatingElements.indexOf(paragarph.floatingElements[x]) !== -1) {
                        body.floatingElements.splice(body.floatingElements.indexOf(paragarph.floatingElements[x]), 1);
                    }
                }
            }
        }
    }
    /**
     * Align block based on keep with next and keep lines together property.
     */
    alignBlockElement(block) {
        if (block instanceof ParagraphWidget && block.isEndsWithPageBreak) {
            return { node: undefined, position: { index: '' } };
        }
        let startBlock;
        let startIndex = 0;
        // Check previous block has keep with next property.
        let previousBlock = this.getPreviousBlock(block);
        while (previousBlock) {
            if (previousBlock instanceof ParagraphWidget) {
                if (!previousBlock.paragraphFormat.keepWithNext || previousBlock.isEndsWithPageBreak) {
                    break;
                }
                startBlock = previousBlock;
                if (previousBlock.paragraphFormat.keepLinesTogether) {
                    if (isNullOrUndefined(this.getPreviousBlock(previousBlock))) {
                        startBlock = undefined;
                    }
                    else {
                        startIndex = 0;
                    }
                }
                else {
                    if (isNullOrUndefined(this.getPreviousBlock(previousBlock))
                        && previousBlock.childWidgets.length === 1) {
                        startBlock = undefined;
                    }
                    else {
                        if (!previousBlock.paragraphFormat.widowControl) {
                            startIndex = previousBlock.lastChild.indexInOwner;
                        }
                        else {
                            startIndex = previousBlock.lastChild.indexInOwner - 1;
                            if (startIndex === 1 || startIndex < 0) {
                                // Move entire block to next page based on widow control.
                                startIndex = 0;
                            }
                            if (startIndex !== 0) {
                                break;
                            }
                        }
                    }
                }
            }
            else if (previousBlock instanceof TableRowWidget) {
                let childWidget = previousBlock.childWidgets[0];
                if (childWidget.childWidgets.length > 0) {
                    let firstBlock = this.documentHelper.selection.getFirstParagraphInCell(childWidget);
                    if (!firstBlock.paragraphFormat.keepWithNext) {
                        break;
                    }
                    if (firstBlock.paragraphFormat.keepWithNext) {
                        if (isNullOrUndefined(this.getPreviousBlock(previousBlock))) {
                            startBlock = undefined;
                        }
                        else {
                            startBlock = previousBlock;
                            startIndex = startBlock.indexInOwner;
                        }
                    }
                }
                else {
                    break;
                }
                // TODO: Table row splitting case
            }
            previousBlock = this.getPreviousBlock(previousBlock);
        }
        return { node: startBlock, position: { index: startIndex.toString() } };
    }
    getPreviousBlock(block) {
        let previousBlock;
        if (block instanceof ParagraphWidget) {
            previousBlock = block.previousWidget;
        }
        else if (block instanceof TableRowWidget) {
            previousBlock = block.previousWidget;
            if (isNullOrUndefined(previousBlock)) {
                previousBlock = block.ownerTable.previousWidget;
            }
        }
        if (previousBlock instanceof TableWidget) {
            previousBlock = previousBlock.lastChild;
        }
        return previousBlock;
    }
    splitRow(startRow) {
        let table = startRow.ownerTable;
        if (startRow.indexInOwner === 0) {
            return table;
        }
        let newTable = this.createTableWidget(table);
        for (let i = startRow.indexInOwner; i < table.childWidgets.length;) {
            let rowWidget = table.childWidgets.splice(i, 1)[0];
            newTable.childWidgets.push(rowWidget);
            rowWidget.containerWidget = newTable;
            table.height -= rowWidget.height;
            newTable.height += rowWidget.height;
        }
        table.containerWidget.childWidgets.splice(table.indexInOwner + 1, 0, newTable);
        newTable.containerWidget = table.containerWidget;
        return newTable;
    }
    splitParagraph(paragarph, index, nextParagraph) {
        if (index === 0 && isNullOrUndefined(nextParagraph)) {
            return paragarph;
        }
        let isMoveCurrentBlock = false;
        if (isNullOrUndefined(nextParagraph)) {
            nextParagraph = new ParagraphWidget();
            nextParagraph.containerWidget = paragarph.containerWidget;
            paragarph.containerWidget.childWidgets.splice(paragarph.indexInOwner + 1, 0, nextParagraph);
            nextParagraph.paragraphFormat = paragarph.paragraphFormat;
            nextParagraph.characterFormat = paragarph.characterFormat;
            nextParagraph.index = paragarph.index;
        }
        else if (index === 0) {
            isMoveCurrentBlock = true;
            let temp = paragarph;
            paragarph = nextParagraph;
            nextParagraph = temp;
        }
        let insertIndex = 0;
        for (let i = index; i < paragarph.childWidgets.length; i++) {
            let lineWidget = paragarph.childWidgets[i];
            lineWidget.paragraph = nextParagraph;
            if (isMoveCurrentBlock) {
                nextParagraph.childWidgets.push(lineWidget);
            }
            else {
                nextParagraph.childWidgets.splice(insertIndex, 0, lineWidget);
            }
            nextParagraph.height += lineWidget.height;
            paragarph.height -= lineWidget.height;
            lineWidget.paragraph = nextParagraph;
            insertIndex++;
        }
        if (isMoveCurrentBlock) {
            nextParagraph.containerWidget.childWidgets.splice(nextParagraph.indexInOwner, 1);
            nextParagraph.y = paragarph.y;
            nextParagraph.x = paragarph.x;
            nextParagraph.containerWidget = paragarph.containerWidget;
            paragarph.containerWidget.childWidgets.unshift(nextParagraph);
        }
        else {
            paragarph.childWidgets.splice(index);
        }
        if (paragarph.childWidgets.length === 0 || isMoveCurrentBlock) {
            paragarph.containerWidget.childWidgets.splice(paragarph.indexInOwner, 1);
        }
        return nextParagraph;
    }
    updateClientPositionForBlock(block, currentBlock) {
        let startBlock = (block instanceof TableRowWidget) ? block.ownerTable : block;
        let isClientAreaUpdated = false;
        do {
            this.viewer.updateClientAreaForBlock(startBlock, true);
            if (startBlock instanceof ParagraphWidget) {
                if (currentBlock instanceof ParagraphWidget && currentBlock.equals(startBlock)) {
                    isClientAreaUpdated = true;
                    break;
                }
                this.addParagraphWidget(this.viewer.clientActiveArea, startBlock);
                this.viewer.cutFromTop(this.viewer.clientActiveArea.y + startBlock.height);
                this.viewer.updateClientAreaForBlock(startBlock, false);
            }
            else if (startBlock instanceof TableWidget) {
                this.addTableWidget(this.viewer.clientActiveArea, [startBlock]);
                let nextRow = startBlock.firstChild;
                if (currentBlock instanceof TableRowWidget && startBlock.equals(currentBlock.ownerTable) && !isNullOrUndefined(nextRow)) {
                    do {
                        if (nextRow.equals(currentBlock)) {
                            isClientAreaUpdated = true;
                            break;
                        }
                        this.addTableRowWidget(this.viewer.clientActiveArea, [nextRow]);
                        this.updateChildLocationForRow(this.viewer.clientActiveArea.y, nextRow);
                        this.viewer.cutFromTop(this.viewer.clientActiveArea.y + nextRow.height);
                        startBlock.height += nextRow.height;
                        nextRow = nextRow.nextWidget;
                    } while (nextRow);
                }
                else {
                    this.updateChildLocationForTable(startBlock.y, startBlock);
                    this.viewer.cutFromTop(this.viewer.clientActiveArea.y + startBlock.height);
                    this.viewer.updateClientAreaForBlock(startBlock, false);
                }
            }
            startBlock = startBlock.nextWidget;
        } while (startBlock && !isClientAreaUpdated);
    }
    updateClientAreaForNextBlock(line, paragraphWidget) {
        for (let m = 0; m < paragraphWidget.childWidgets.length; m++) {
            let child = paragraphWidget.childWidgets[m];
            if (line === child) {
                break;
            }
            this.viewer.cutFromTop(this.viewer.clientActiveArea.y + child.height);
        }
    }
    layoutStartEndBlocks(startBlock, endBlock) {
        let block = startBlock;
        this.isOverlapFloatTable = true;
        this.viewer.clientActiveArea.height = this.viewer.clientActiveArea.bottom - startBlock.y;
        this.viewer.clientActiveArea.y = startBlock.y;
        while (block) {
            this.viewer.updateClientAreaForBlock(block, true);
            if (block instanceof ParagraphWidget) {
                this.layoutParagraph(block, 0);
            }
            else {
                this.clearTableWidget(block, true, true, true);
                this.layoutTable(block, 0);
            }
            this.viewer.updateClientAreaForBlock(block, false);
            block = block !== endBlock ? block.nextWidget : undefined;
        }
    }
    /* eslint-disable-next-line max-len */
    alignLineElements(element, topMargin, bottomMargin, maxDescent, addSubWidth, subWidth, textAlignment, whiteSpaceCount, isLastElement) {
        if (element.width > 0 && (element instanceof TextElementBox || element instanceof ListTextElementBox)) {
            let textElement = element instanceof TextElementBox ? element : undefined;
            //Updates the text to base line offset.
            let baselineOffset = element instanceof TextElementBox ? textElement.baselineOffset : element.baselineOffset;
            topMargin += this.maxBaseline - baselineOffset;
            bottomMargin += maxDescent - (element.height - baselineOffset);
            //Updates the text to base line offset.
            if (!isNullOrUndefined(textElement) && textAlignment === 'Justify' && whiteSpaceCount > 0) {
                //Aligns the text as Justified.
                let width = textElement.width;
                let text = textElement.text;
                if (!addSubWidth) {
                    text = HelperMethods.trimStart(text); // trim start
                    addSubWidth = (text.length > 0);
                }
                if (addSubWidth) {
                    let spaceCount = text.length - HelperMethods.removeSpace(text).length;
                    if (isLastElement) {
                        spaceCount -= text.length - HelperMethods.trimEnd(text).length;
                    }
                    if (whiteSpaceCount < spaceCount) {
                        width = this.documentHelper.textHelper.measureTextExcludingSpaceAtEnd(text, textElement.characterFormat);
                        spaceCount = whiteSpaceCount;
                    }
                    if (spaceCount > 0) {
                        textElement.width = width + subWidth * spaceCount;
                        whiteSpaceCount -= spaceCount;
                    }
                }
            }
        }
        else {
            addSubWidth = true;
            //Updates the Image/UIElement to base line offset.
            topMargin += this.maxBaseline - element.height;
            bottomMargin += maxDescent;
        }
        return { 'topMargin': topMargin, 'bottomMargin': bottomMargin, 'addSubWidth': addSubWidth, 'whiteSpaceCount': whiteSpaceCount };
    }
    updateWidgetToPage(viewer, paragraphWidget) {
        if (paragraphWidget.isInsideTable) {
            let cellWidget = paragraphWidget.associatedCell;
            paragraphWidget.height = viewer.clientActiveArea.y - paragraphWidget.y;
            // if (viewer instanceof PageLayoutViewer) {
            if (isNullOrUndefined(paragraphWidget.associatedCell) || isNullOrUndefined(paragraphWidget.associatedCell.ownerRow)
                || isNullOrUndefined(paragraphWidget.associatedCell.ownerRow.rowFormat)) {
                return;
            }
            if (paragraphWidget.associatedCell.ownerRow.rowFormat.heightType === 'Exactly') {
                cellWidget.height = HelperMethods.convertPointToPixel(paragraphWidget.associatedCell.ownerRow.rowFormat.height);
            }
            else {
                if ([cellWidget].length <= 1 && paragraphWidget.associatedCell.ownerRow.rowFormat.heightType === 'AtLeast') {
                    cellWidget.height = Math.max(HelperMethods.convertPointToPixel(paragraphWidget.associatedCell.ownerRow.rowFormat.height), this.getCellContentHeight(cellWidget));
                }
                else {
                    cellWidget.height = cellWidget.height + paragraphWidget.height;
                }
            }
            // } else {
            //     cellWidget.height = cellWidget.height + paragraphWidget.height;
            // }
            // cellWidget.childWidgets.push(paragraphWidget);
            paragraphWidget.containerWidget = cellWidget;
        }
        else {
            if (!paragraphWidget.isEndsWithPageBreak || viewer instanceof WebLayoutViewer) {
                paragraphWidget.height = viewer.clientActiveArea.y - paragraphWidget.y;
            }
            //Adds the paragraph widget to the Header Footer/ Body widget.
            // this.updateWidgetsToBody(paragraphWidget, viewer, paragraphWidget);
            //For canvas no need to render paragraph widget here. In case of div, need to render paragraph here.
            // this.render.renderParagraphWidget((paragraphWidget.containerWidget as BodyWidget).page, paragraphWidget);
        }
        if (this.isRelayoutFootnote && paragraphWidget.bodyWidget instanceof FootNoteWidget) {
            if (!paragraphWidget.isInsideTable) {
                paragraphWidget.containerWidget.height += paragraphWidget.height;
            }
            //this.isRelayoutFootnote = false;
            this.shiftFootnoteChildLocation(paragraphWidget.bodyWidget, this.viewer);
        }
        if (paragraphWidget.bodyWidget instanceof HeaderFooterWidget) {
            if (!paragraphWidget.isInsideTable) {
                paragraphWidget.containerWidget.height += paragraphWidget.height;
            }
            if (this.viewer.owner.enableHeaderAndFooter && paragraphWidget.bodyWidget.headerFooterType.indexOf('Footer') !== -1) {
                this.shiftFooterChildLocation(paragraphWidget.bodyWidget, this.viewer);
            }
        }
        if (viewer instanceof WebLayoutViewer && paragraphWidget.containerWidget instanceof BodyWidget) {
            paragraphWidget.containerWidget.height += paragraphWidget.height;
        }
    }
    shiftFooterChildLocation(widget, viewer) {
        let pageHeight = widget.page.bodyWidgets[0].sectionFormat.pageHeight;
        if (widget.headerFooterType.indexOf('Footer') !== -1) {
            let footerDistance = widget.page.bodyWidgets[0].sectionFormat.footerDistance;
            let height = HelperMethods.convertPointToPixel(pageHeight - footerDistance);
            let top;
            if (widget.y + widget.height > height) {
                top = height - (widget.y + widget.height);
            }
            else if (widget.y + widget.height < height) {
                top = (widget.y + widget.height) - height;
            }
            if (!isNullOrUndefined(top)) {
                top = height - (widget.y + widget.height);
                this.shiftChildLocation(top, widget);
                viewer.clientActiveArea.y += top;
            }
        }
    }
    shiftFootnoteChildLocation(widget, viewer) {
        let pageHeight = widget.page.bodyWidgets[0].sectionFormat.pageHeight;
        let footerDistance = widget.page.bodyWidgets[0].sectionFormat.footerDistance;
        let bottomMargin = widget.page.bodyWidgets[0].sectionFormat.bottomMargin;
        let height = HelperMethods.convertPointToPixel(pageHeight - bottomMargin);
        let top;
        if (widget.y + widget.height > height) {
            top = height - (widget.y + widget.height);
        }
        else if (widget.y + widget.height < height) {
            top = (widget.y + widget.height) - height;
        }
        if (!isNullOrUndefined(top)) {
            top = height - (widget.y + widget.height);
            this.shiftChildLocation(top, widget);
            viewer.clientActiveArea.y += top;
        }
    }
    checkPreviousElement(line, index, characterFormat) {
        let paragraph = line.paragraph;
        let isSplitByWord = false;
        let lastTextElement = 0;
        for (let i = index - 1; i >= 0; i--) {
            let textElement = line.children[i];
            if (textElement instanceof TextElementBox && textElement.width > 0) {
                let text = textElement.text;
                lastTextElement = i;
                if (text.length > 0 && (text[text.length - 1] === ' ' || text[text.length - 1] === '-')) {
                    if (i === index - 1) {
                        this.addSplittedLineWidget(line, index - 1);
                        return true;
                    }
                    isSplitByWord = true;
                    break;
                }
                else if (text === '\t') {
                    return false;
                }
                else if (text.indexOf(' ') >= 0) {
                    isSplitByWord = true;
                    let index = text.lastIndexOf(' ') + 1;
                    //Splits the text element by space.
                    let splittedElement = new TextElementBox();
                    splittedElement.text = text.substr(index);
                    splittedElement.characterFormat.copyFormat(textElement.characterFormat);
                    if (textElement.revisions.length > 0) {
                        this.updateRevisionForSplittedElement(textElement, splittedElement, index > 0);
                        splittedElement.isMarkedForRevision = textElement.isMarkedForRevision;
                    }
                    textElement.text = text.substr(0, index);
                    this.documentHelper.textHelper.getTextSize(splittedElement, characterFormat);
                    textElement.width -= splittedElement.width;
                    textElement.height = splittedElement.height;
                    if (textElement.width === 0) {
                        line.children.splice(i, 1);
                    }
                    //Adds the text element to the line
                    line.children.splice(i + 1, 0, splittedElement);
                    break;
                }
            }
            else if (!(textElement instanceof ListTextElementBox || textElement instanceof FieldElementBox
                // to skip field code
                || textElement instanceof TextElementBox && textElement.width === 0)) {
                //Handled for inline images/UIelements.
                lastTextElement = i;
                isSplitByWord = true;
                break;
            }
        }
        if (isSplitByWord) {
            lastTextElement++;
            if (lastTextElement < line.children.length) {
                let splitWidth = 0;
                for (let i = lastTextElement; i < line.children.length; i++) {
                    splitWidth += line.children[i].width;
                    this.addSplittedLineWidget(line, i - 1);
                    i--;
                }
                let is2013Justification = paragraph.paragraphFormat.textAlignment === 'Justify' &&
                    this.documentHelper.compatibilityMode === 'Word2013';
                if (!is2013Justification) {
                    this.viewer.updateClientWidth(splitWidth);
                }
            }
        }
        return isSplitByWord;
    }
    clearListElementBox(paragraph) {
        if (paragraph.childWidgets.length === 0) {
            return;
        }
        let line = paragraph.childWidgets[0];
        if (isNullOrUndefined(line.children)) {
            return;
        }
        for (let i = line.children.length - 1; i > 0; i--) {
            if (line.children[i] instanceof ListTextElementBox) {
                line.children.splice(i, 1);
            }
            else {
                break;
            }
        }
        for (let i = 0; i < line.children.length; i++) {
            if (line.children[i] instanceof ListTextElementBox) {
                line.children.splice(i, 1);
                i--;
            }
            else {
                break;
            }
        }
    }
    /**
 * @private
 */
    clearInvalidList(list) {
        if (list) {
            if (list.abstractListId === -1 && this.documentHelper.abstractLists.indexOf(list.abstractList) !== -1) {
                this.documentHelper.abstractLists.splice(this.documentHelper.abstractLists.indexOf(list.abstractList), 1);
            }
            if (list.listId === -1 && this.documentHelper.lists.indexOf(list) !== -1) {
                this.documentHelper.lists.splice(this.documentHelper.lists.indexOf(list), 1);
            }
        }
    }
    getListNumber(listFormat, isAutoList) {
        let list = this.documentHelper.getListById(listFormat.listId);
        let levelNumber = listFormat.listLevelNumber;
        let listLevel = this.getListLevel(list, listFormat.listLevelNumber);
        let levelOverride = !isNullOrUndefined(list.levelOverrides) ? list.levelOverrides[levelNumber] : undefined;
        // If LevelOverride exists and have either override list level or StartAtOverride, then only list numbering will be restarted.
        if (!isNullOrUndefined(levelOverride) && this.documentHelper.renderedLevelOverrides.indexOf(levelOverride) === -1 && isNullOrUndefined(levelOverride.overrideListLevel)) {
            //Add List Override style
            this.documentHelper.renderedLevelOverrides.push(levelOverride);
            if (this.documentHelper.renderedLists.containsKey(this.documentHelper.getAbstractListById(list.abstractListId))) {
                let levels = this.documentHelper.renderedLists.get(this.documentHelper.getAbstractListById(list.abstractListId));
                if (levels.containsKey(levelNumber)) {
                    levels.remove(levelNumber);
                }
            }
        }
        if (isNullOrUndefined(isAutoList)) {
            this.updateListValues(list, levelNumber);
        }
        return this.getListText(list, levelNumber, listLevel);
    }
    getListStartValue(listLevelNumber, list) {
        let levelOverride = !isNullOrUndefined(list.levelOverrides) ? list.levelOverrides[listLevelNumber] : undefined;
        if (!isNullOrUndefined(levelOverride) && isNullOrUndefined(levelOverride.overrideListLevel)) {
            return levelOverride.startAt;
        }
        let listLevel = this.getListLevel(list, listLevelNumber);
        if (isNullOrUndefined(listLevel)) {
            return 0;
        }
        else {
            return listLevel.startAt;
        }
    }
    updateListValues(list, listLevelNumber) {
        if (!this.documentHelper.renderedLists.containsKey(this.documentHelper.getAbstractListById(list.abstractListId))) {
            let startVal = new Dictionary();
            this.documentHelper.renderedLists.add(this.documentHelper.getAbstractListById(list.abstractListId), startVal);
            let listLevel = this.getListLevel(list, listLevelNumber);
            for (let i = 0; i <= listLevelNumber; i++) {
                startVal.add(i, this.getListStartValue(i, list));
            }
        }
        else {
            let levels = this.documentHelper.renderedLists.get(this.documentHelper.getAbstractListById(list.abstractListId));
            if (levels.containsKey(listLevelNumber)) {
                let startAt = levels.get(listLevelNumber);
                levels.set(listLevelNumber, startAt + 1);
                let levelNumber = listLevelNumber + 1;
                while (levelNumber < this.documentHelper.getAbstractListById(list.abstractListId).levels.length) {
                    let listLevel = this.getListLevel(list, levelNumber);
                    // if (!isNullOrUndefined(listLevel)) {
                    if (levels.containsKey(levelNumber) && listLevel.restartLevel > listLevelNumber) {
                        levels.remove(levelNumber);
                        // if (document.renderedListLevels.indexOf(listLevel) > -1) {
                        //     document.renderedListLevels.pop();
                        // }
                    }
                    // }
                    levelNumber++;
                }
            }
            else {
                let levelNumber = listLevelNumber;
                while (!levels.containsKey(levelNumber - 1) && levelNumber > 0) {
                    let listLevel = this.getListLevel(list, levelNumber - 1);
                    // if (!isNullOrUndefined(listLevel)) {
                    levels.add(levelNumber - 1, this.getListStartValue(levelNumber - 1, list));
                    // if (document.renderedListLevels.indexOf(listLevel) !== -1) {
                    //     document.renderedListLevels.push(listLevel);
                    // }
                    // }
                    levelNumber--;
                }
                let startAt = this.getListStartValue(listLevelNumber, list);
                levels.add(listLevelNumber, startAt);
            }
        }
    }
    getListText(listAdv, listLevelNumber, currentListLevel) {
        let listText = currentListLevel.numberFormat;
        if (this.documentHelper.renderedLists.containsKey(this.documentHelper.getAbstractListById(listAdv.abstractListId))) {
            let levels = this.documentHelper.renderedLists.get(this.documentHelper.getAbstractListById(listAdv.abstractListId));
            let keys = levels.keys;
            for (let i = 0; i < keys.length; i++) {
                let levelNumber = keys[i];
                let levelKey = '%' + (levelNumber + 1).toString();
                let listLevel = this.getListLevel(listAdv, levelNumber);
                if (listText.match(levelKey) && listText.match((listLevelNumber + 1).toString())) {
                    if (levelNumber > listLevelNumber) {
                        return '';
                    }
                    else if (levels.containsKey(levelNumber) && !isNullOrUndefined(listLevel)) {
                        listText = listText.replace(levelKey, this.getListTextListLevel(listLevel, levels.get(levelNumber)));
                    }
                    else {
                        listText = listText.replace(levelKey, '0');
                    }
                }
                else if (listText.match(levelKey) && listLevelNumber > 0) {
                    listLevel = this.getListLevel(listAdv, keys[listLevelNumber]);
                    return this.getListTextListLevel(listLevel, levels.get(listLevelNumber)) + '.';
                }
            }
        }
        return listText;
    }
    getAsLetter(number) {
        // if (number <= 0) {
        //     return '';
        // }
        let quotient = number / 26;
        let remainder = number % 26;
        if (remainder === 0) {
            //If number denotes the factor of 26, then reduce quotient by 1 and set remainder as 26.
            remainder = 26;
            quotient--;
        }
        //Index of A char in the ASCII table.     
        let letter = String.fromCharCode(65 - 1 + remainder);
        let listValue = '';
        while (quotient >= 0) {
            listValue = listValue + letter.toString();
            quotient--;
        }
        return listValue;
    }
    getListTextListLevel(listLevel, listValue) {
        switch (listLevel.listLevelPattern) {
            case 'UpRoman':
                return this.getAsRoman(listValue).toUpperCase();
            case 'LowRoman':
                return this.getAsRoman(listValue).toLowerCase();
            case 'UpLetter':
                return this.getAsLetter(listValue).toUpperCase();
            case 'LowLetter':
                return this.getAsLetter(listValue).toLowerCase();
            case 'Arabic':
                return (listValue).toString();
            case 'LeadingZero':
                return this.getAsLeadingZero(listValue);
            case 'Number':
                return (listValue).toString();
            case 'OrdinalText':
                return (listValue).toString();
            case 'Ordinal':
                return (listValue).toString();
            case 'FarEast':
                return (listValue).toString();
            case 'Special':
                return (listValue).toString();
            default:
                return '';
        }
    }
    getFootEndNote(numberFormat, value) {
        switch (numberFormat) {
            case 'UpperCaseRoman':
                return this.getAsRoman(value).toUpperCase();
            case 'LowerCaseRoman':
                return this.getAsRoman(value).toLowerCase();
            case 'UpperCaseLetter':
                return this.getAsLetter(value).toUpperCase();
            case 'LowerCaseLetter':
                return this.getAsLetter(value).toLowerCase();
            default:
                return (value).toString();
        }
    }
    generateNumber(number, magnitude, letter) {
        let numberstring = '';
        while (number >= magnitude) {
            number -= magnitude;
            numberstring += letter;
            this.value = number;
        }
        return numberstring.toString();
    }
    getAsLeadingZero(listValue) {
        if (listValue < 10) {
            return '0' + listValue.toString();
        }
        else {
            return listValue.toString();
        }
    }
    getAsRoman(number) {
        let retval = '';
        this.value = number;
        retval += this.generateNumber(this.value, 1000, 'M');
        retval += this.generateNumber(this.value, 900, 'CM');
        retval += this.generateNumber(this.value, 500, 'D');
        retval += this.generateNumber(this.value, 400, 'CD');
        retval += this.generateNumber(this.value, 100, 'C');
        retval += this.generateNumber(this.value, 90, 'XC');
        retval += this.generateNumber(this.value, 50, 'L');
        retval += this.generateNumber(this.value, 40, 'XL');
        retval += this.generateNumber(this.value, 10, 'X');
        retval += this.generateNumber(this.value, 9, 'IX');
        retval += this.generateNumber(this.value, 5, 'V');
        retval += this.generateNumber(this.value, 4, 'IV');
        retval += this.generateNumber(this.value, 1, 'I');
        return retval.toString();
    }
    getListLevel(list, listLevelNumber) {
        if (!isNullOrUndefined(list)) {
            let abstractList = this.documentHelper.getAbstractListById(list.abstractListId);
            if (!isNullOrUndefined(list) && abstractList.levels.length <= listLevelNumber
                && listLevelNumber >= 0 && listLevelNumber < 9) {
                this.addListLevels(abstractList);
            }
            let levelOverrideAdv = undefined;
            let level = false;
            level = (!isNullOrUndefined(list.levelOverrides))
                && !isNullOrUndefined(((levelOverrideAdv = list.levelOverrides[listLevelNumber])))
                && (!isNullOrUndefined(levelOverrideAdv.overrideListLevel));
            if (level) {
                return levelOverrideAdv.overrideListLevel;
            }
            else if (!isNullOrUndefined(abstractList) && listLevelNumber >= 0 && listLevelNumber < abstractList.levels.length) {
                return abstractList.levels[listLevelNumber];
            }
        }
        return undefined;
    }
    getTabWidth(paragraph, viewer, index, lineWidget, element) {
        let fPosition = 0;
        let isCustomTab = false;
        let tabs = paragraph.paragraphFormat.getUpdatedTabs();
        let isList = false;
        let sectionFormat = paragraph.bodyWidget.sectionFormat;
        let leftMargin = HelperMethods.convertPointToPixel(sectionFormat.leftMargin);
        if (!isNullOrUndefined(paragraph.paragraphFormat.listFormat.listLevel) && !isNullOrUndefined(paragraph.paragraphFormat.listFormat.listLevel.paragraphFormat)) {
            let listFormat = paragraph.paragraphFormat.listFormat.listLevel.paragraphFormat;
            if (paragraph.paragraphFormat.leftIndent !== listFormat.leftIndent) {
                isList = true;
            }
        }
        let clientWidth = 0;
        let clientActiveX = viewer.clientActiveArea.x;
        let firstLineIndent = HelperMethods.convertPointToPixel(paragraph.paragraphFormat.firstLineIndent);
        let leftIndent = HelperMethods.convertPointToPixel(paragraph.paragraphFormat.leftIndent);
        if (!isNullOrUndefined(element) && lineWidget.isFirstLine()) {
            clientWidth = this.viewer.clientArea.x + firstLineIndent;
            if (isList) {
                clientActiveX = clientActiveX + firstLineIndent;
            }
        }
        else {
            clientWidth = this.viewer.clientArea.x;
        }
        if (clientActiveX < clientWidth) {
            return viewer.clientArea.x - viewer.clientActiveArea.x;
        }
        if ((element instanceof ListTextElementBox && lineWidget.isFirstLine()
            && leftIndent > 0 && firstLineIndent < 0)) {
            if ((viewer.clientArea.x - viewer.clientActiveArea.x) > 0) {
                return viewer.clientArea.x - viewer.clientActiveArea.x;
            }
            else if (tabs.length === 0 && paragraph.paragraphFormat.listFormat && paragraph.paragraphFormat.listFormat.listLevel) {
                tabs = paragraph.paragraphFormat.listFormat.listLevel.paragraphFormat.tabs;
            }
        }
        // Calculates tabwidth based on pageleftmargin and defaulttabwidth property
        let position = viewer.clientActiveArea.x -
            (viewer.clientArea.x - HelperMethods.convertPointToPixel(paragraph.paragraphFormat.leftIndent));
        let defaultTabWidth = HelperMethods.convertPointToPixel(this.documentHelper.defaultTabWidth);
        if (tabs.length === 0 && (position > 0 && defaultTabWidth > Math.round(position) && isList ||
            defaultTabWidth === this.defaultTabWidthPixel && defaultTabWidth > Math.round(position))) {
            return defaultTabWidth - position;
        }
        else {
            let breaked = false;
            if (tabs.length > 0) {
                for (let i = tabs.length - 1; i > -1; i--) {
                    let tabStop = tabs[i];
                    let tabPosition = HelperMethods.convertPointToPixel(tabStop.position);
                    if (!(parseFloat(tabPosition.toFixed(2)) > parseFloat(position.toFixed(2)))) {
                        if (i > 0 && (HelperMethods.convertPointToPixel(tabs[i - 1].position) > parseFloat(position.toFixed(2)))) {
                            continue;
                        }
                        if (i != tabs.length - 1) {
                            let tabInfo = this.getJustificationTabWidth(tabs[i + 1], element, lineWidget, paragraph, defaultTabWidth, position, fPosition);
                            defaultTabWidth = tabInfo.defaultTabWidth;
                            fPosition = tabInfo.fPosition;
                            position = tabInfo.position;
                            isCustomTab = true;
                        }
                        breaked = true;
                        break;
                    }
                }
                if (!breaked) {
                    let tabJustification = this.getJustificationTabWidth(tabs[0], element, lineWidget, paragraph, defaultTabWidth, position, fPosition);
                    defaultTabWidth = tabJustification.defaultTabWidth;
                    fPosition = tabJustification.fPosition;
                    position = tabJustification.position;
                    isCustomTab = true;
                }
            }
            if (!isCustomTab) {
                let diff = parseFloat(((position * 100) % (defaultTabWidth * 100) / 100).toFixed(2));
                let cnt = (position - diff) / defaultTabWidth;
                fPosition = (cnt + 1) * defaultTabWidth;
            }
            if (parseFloat(fPosition.toFixed(1)) === parseFloat(position.toFixed(1))) {
                return defaultTabWidth;
            }
            return (fPosition - position) > 0 ? fPosition - position : defaultTabWidth;
        }
    }
    getJustificationTabWidth(tab, element, lineWidget, paragraph, defaultTabWidth, position, fPosition) {
        let elementWidth = element ? this.documentHelper.textHelper.getTextSize(element, element.characterFormat) : 0;
        if (tab.tabJustification === 'Left' || tab.tabJustification === 'List') {
            fPosition = HelperMethods.convertPointToPixel(tab.position);
            if (element instanceof TabElementBox) {
                element.tabLeader = tab.tabLeader;
                element.tabText = '';
            }
        }
        else {
            let tabWidth = HelperMethods.convertPointToPixel(tab.position) - position;
            let width = this.getRightTabWidth(element.indexInOwner + 1, lineWidget, paragraph);
            if (width < tabWidth) {
                if (tab.tabJustification === 'Right') {
                    defaultTabWidth = tabWidth - width;
                    let rightIndent = HelperMethods.convertPointToPixel(paragraph.rightIndent);
                    let areaWidth = this.viewer.clientActiveArea.width + rightIndent - defaultTabWidth;
                    this.viewer.clientActiveArea.width += rightIndent;
                    if (areaWidth < 0) {
                        defaultTabWidth += areaWidth - width;
                    }
                    else if (width > areaWidth) {
                        defaultTabWidth -= width - areaWidth;
                    }
                }
                else {
                    defaultTabWidth = tabWidth - width / 2;
                }
            }
            else if (tab.tabJustification === 'Center' && (width / 2) < tabWidth) {
                defaultTabWidth = tabWidth - width / 2;
            }
            else {
                defaultTabWidth = tab.tabJustification === 'Right' ? 0 : elementWidth;
            }
            fPosition = position;
            if (element instanceof TabElementBox) {
                element.tabLeader = tab.tabLeader;
                element.tabText = '';
            }
        }
        return {
            defaultTabWidth: defaultTabWidth,
            fPosition: fPosition,
            position: position
        };
    }
    getRightTabWidth(index, lineWidget, paragraph) {
        let width = 0;
        let isFieldCode = false;
        let elementBox = lineWidget.children[index];
        while (elementBox) {
            if ((elementBox instanceof FieldElementBox) || (elementBox instanceof BookmarkElementBox) || isFieldCode) {
                if (elementBox instanceof FieldElementBox) {
                    if (elementBox.fieldType === 0) {
                        isFieldCode = true;
                    }
                    else if (elementBox.fieldType === 2) {
                        isFieldCode = false;
                    }
                }
                elementBox.width = 0;
            }
            else {
                if (elementBox instanceof FieldTextElementBox && !this.isTocField(elementBox.fieldBegin)) {
                    let text = this.documentHelper.getFieldResult(elementBox.fieldBegin, elementBox.paragraph.bodyWidget.page);
                    if (text !== '') {
                        elementBox.text = text;
                    }
                }
                if (elementBox instanceof TextElementBox) {
                    this.documentHelper.textHelper.getTextSize(elementBox, elementBox.characterFormat);
                }
            }
            if (elementBox instanceof TextElementBox && elementBox.text === '\t') {
                return width;
            }
            else {
                width = width + elementBox.width;
            }
            elementBox = elementBox.nextNode;
        }
        return width;
    }
    getSplitIndexByWord(clientActiveWidth, text, width, characterFormat) {
        let index = 0;
        let length = text.length;
        while (index < length) {
            let nextIndex = this.getTextIndexAfterSpace(text, index);
            if (nextIndex === 0 || nextIndex === length) {
                nextIndex = length - 1;
            }
            let splitWidth = width;
            if ((nextIndex < length - 1 || (nextIndex === length - 1 && text[nextIndex - 1] === ' ')) && index !== nextIndex) {
                splitWidth = this.documentHelper.textHelper.measureTextExcludingSpaceAtEnd(text.slice(0, nextIndex), characterFormat);
            }
            if (splitWidth <= clientActiveWidth) {
                index = nextIndex;
            }
            else {
                if (index === 0 && text[0] === ' ') {
                    index = this.getTextIndexAfterSpace(text, 0);
                }
                break;
            }
        }
        return index;
    }
    getTextSplitIndexByCharacter(totalClientWidth, clientActiveAreaWidth, text, width, characterFormat) {
        let length = text.length;
        for (let i = 0; i < length; i++) {
            let splitWidth = width;
            if (i + 1 < length) {
                splitWidth = this.documentHelper.textHelper.measureTextExcludingSpaceAtEnd(text.substring(0, i + 1), characterFormat);
            }
            if (splitWidth > clientActiveAreaWidth) {
                if (i === 0 && splitWidth > totalClientWidth) {
                    //Handle for cell/section having client width less than a character's width.
                    return (length > 1 && text[1] === ' ') ? this.getTextIndexAfterSpace(text, 1) : 1;
                }
                return i;
            }
        }
        return 0;
    }
    getSubWidth(lineWidget, justify, spaceCount, firstLineIndent, isParagraphEnd) {
        let width = 0;
        let trimSpace = true;
        let lineText = '';
        if (this.wrapPosition.length > 0) {
            let subWidths = this.getSubWidthBasedOnTextWrap(lineWidget, justify, spaceCount, firstLineIndent, isParagraphEnd);
            if (subWidths.length > 0) {
                return subWidths;
            }
        }
        for (let i = lineWidget.children.length - 1; i >= 0; i--) {
            let element = lineWidget.children[i];
            if (element.width > 0 && element instanceof TextElementBox) {
                let elementText = element.text;
                lineText = elementText + lineText;
                if (trimSpace && (elementText.trim() !== '' || elementText === '\t')) {
                    if (HelperMethods.endsWith(elementText)) {
                        width += this.documentHelper.textHelper.measureTextExcludingSpaceAtEnd(elementText, element.characterFormat);
                    }
                    else {
                        width += element.width;
                    }
                    trimSpace = false;
                }
                else if (!trimSpace) {
                    width += element.width;
                }
            }
            else {
                lineText = 'a' + lineText;
                trimSpace = false;
                if (element instanceof ShapeBase && element.textWrappingStyle !== 'Inline') {
                    continue;
                }
                width += element.width;
            }
            if (!justify) {
                width = Math.round(width);
            }
            else {
                width = width;
            }
        }
        let totalSpaceCount = lineText.length - HelperMethods.removeSpace(lineText).length;
        lineText = lineText.trim();
        spaceCount = lineText.length - HelperMethods.removeSpace(lineText).length;
        let subWidth = (this.viewer.clientArea.width - firstLineIndent - width);
        if ((subWidth <= 0 && !this.is2013Justification) || (spaceCount === 0 && justify && !lineWidget.paragraph.paragraphFormat.bidi)) {
            spaceCount = 0;
            subWidth = 0;
        }
        else if (justify) {
            // For justify alignment, element width will be updated based space count value.
            // So when the element is paragraph end, need to set space count to zero.
            if (!isParagraphEnd && spaceCount > 0 || (isParagraphEnd && this.is2013Justification && spaceCount > 0)) {
                subWidth = subWidth / spaceCount;
            }
            else {
                spaceCount = 0;
            }
        }
        // So set sub width to zero to layout the element in left alignment
        // Need to remove is once after implementing subwidth update separatly
        return [{ 'subWidth': subWidth, 'spaceCount': spaceCount, 'totalSpaceCount': totalSpaceCount }];
    }
    getSubWidthBasedOnTextWrap(lineWidget, justify, spaceCount, firstLineIndent, isParagraphEnd) {
        let subWidths = [];
        let width = 0;
        let lineContent = '';
        let wrapIndex = this.wrapPosition.length - 1;
        let trimSpace = true;
        for (let z = lineWidget.children.length - 1; z >= 0; z--) {
            let elementBox = lineWidget.children[z];
            if (elementBox.width > 0 && elementBox instanceof TextElementBox) {
                let elementText = elementBox.text;
                lineContent = elementText + lineContent;
                if (trimSpace && (elementText.trim() !== '' || elementText === '\t')) {
                    if (HelperMethods.endsWith(elementText)) {
                        width += this.documentHelper.textHelper.measureTextExcludingSpaceAtEnd(elementText, elementBox.characterFormat);
                    }
                    else {
                        width += elementBox.width;
                    }
                    trimSpace = false;
                }
                else if (!trimSpace) {
                    width += elementBox.width;
                }
            }
            else {
                lineContent = 'a' + lineContent;
                trimSpace = false;
                if (!(elementBox instanceof ShapeBase && elementBox.textWrappingStyle !== 'Inline')) {
                    width += elementBox.width;
                }
            }
            if ((elementBox.padding.left > 0 || z === 0) && (wrapIndex >= 0)) {
                let wrapPosition = this.wrapPosition[wrapIndex--];
                while (wrapPosition.width <= 0 && (wrapIndex >= 0)) {
                    wrapPosition = this.wrapPosition[wrapIndex--];
                }
                let info = this.getSubWidthInfo(lineWidget, wrapPosition.width, width, lineContent, spaceCount, justify, isParagraphEnd);
                if (!isNullOrUndefined(info)) {
                    width = 0;
                    lineContent = '';
                    subWidths.unshift(info);
                }
            }
        }
        return subWidths;
    }
    /**
     * Returns the total space width in line widget.
     * @param {LineWidget} lineWidget - the line widget
     * @returns {number} the total space width.
     */
    getTotalSpaceWidth(lineWidget) {
        let totalSpaceWidth = 0;
        if (lineWidget) {
            for (let i = 0; i < lineWidget.children.length; i++) {
                let currentWidget = lineWidget.children[i];
                if (currentWidget instanceof TextElementBox) {
                    let spaceCount = currentWidget.text.length - HelperMethods.removeSpace(currentWidget.text).length;
                    if (spaceCount > 0) {
                        let spaceWidth = this.documentHelper.textHelper.getWidth(' ', currentWidget.characterFormat);
                        totalSpaceWidth += spaceCount * spaceWidth;
                    }
                }
            }
        }
        return totalSpaceWidth;
    }
    getSubWidthInfo(lineWidget, lastWrapPositionWidth, width, lineContent, spaceCount, justify, isParagraphEnd) {
        if (lastWrapPositionWidth > 0) {
            let wrappedSubWidth = lastWrapPositionWidth - width;
            lineContent = lineContent.trim();
            spaceCount = lineContent.length - HelperMethods.removeSpace(lineContent).length;
            // TODO: Consider first line indent.
            let totalSubWidth = wrappedSubWidth;
            if (totalSubWidth <= 0 || (spaceCount === 0 && justify && !lineWidget.paragraph.paragraphFormat.bidi)) {
                spaceCount = 0;
                totalSubWidth = 0;
            }
            else if (justify) {
                // For justify alignment, element width will be updated based space count value.
                // So when the element is paragraph end, need to set space count to zero.
                if (!isParagraphEnd && spaceCount > 0) {
                    totalSubWidth = totalSubWidth / spaceCount;
                }
                else {
                    spaceCount = 0;
                }
            }
            return { 'subWidth': totalSubWidth, 'spaceCount': spaceCount, 'totalSpaceCount': spaceCount };
        }
        return undefined;
    }
    getBeforeSpacing(paragraph, pageIndex) {
        let beforeSpacing = 0;
        if (!this.documentHelper.dontUseHtmlParagraphAutoSpacing) {
            let previousBlock = paragraph.previousWidget;
            if (previousBlock instanceof ParagraphWidget) {
                let afterSpacing = this.getAfterSpacing(previousBlock);
                let before = paragraph.paragraphFormat.beforeSpacing;
                if (paragraph.paragraphFormat.spaceBeforeAuto) {
                    before = 14;
                }
                if (afterSpacing < before) {
                    beforeSpacing = before - afterSpacing;
                }
            }
            else if (previousBlock instanceof TableWidget) {
                if (paragraph.paragraphFormat.spaceBeforeAuto) {
                    beforeSpacing = 14;
                }
                else {
                    beforeSpacing = paragraph.paragraphFormat.beforeSpacing;
                }
            }
            else {
                if (pageIndex > 0 && paragraph === paragraph.bodyWidget.childWidgets[0]) {
                    if (this.documentHelper.pages[pageIndex].sectionIndex !== this.documentHelper.pages[pageIndex - 1].sectionIndex) {
                        if (paragraph.paragraphFormat.spaceBeforeAuto) {
                            beforeSpacing = 14;
                        }
                        else {
                            beforeSpacing = paragraph.paragraphFormat.beforeSpacing;
                        }
                    }
                }
                else {
                    if (paragraph.paragraphFormat.spaceBeforeAuto) {
                        beforeSpacing = 0;
                    }
                    else {
                        beforeSpacing = paragraph.paragraphFormat.beforeSpacing;
                    }
                }
            }
        }
        else {
            beforeSpacing = paragraph.paragraphFormat.beforeSpacing;
        }
        if (this.isSameStyle(paragraph, false)) {
            return 0;
        }
        else {
            return HelperMethods.convertPointToPixel(beforeSpacing);
        }
    }
    getAfterSpacing(paragraph) {
        let afterSpacing = paragraph.paragraphFormat.afterSpacing;
        if (!this.documentHelper.dontUseHtmlParagraphAutoSpacing && paragraph.paragraphFormat.spaceAfterAuto) {
            if (isNullOrUndefined(paragraph.nextWidget) && paragraph.isInsideTable) {
                afterSpacing = 0;
            }
            else {
                afterSpacing = 14;
            }
        }
        if (this.isSameStyle(paragraph, true)) {
            return 0;
        }
        else {
            return afterSpacing;
        }
    }
    getLineSpacing(paragraph, maxHeight, alterLineSpacing) {
        if (isNullOrUndefined(paragraph.paragraphFormat)) {
            return 0;
        }
        let lineSpacing = 0;
        switch (paragraph.paragraphFormat.lineSpacingType) {
            case 'AtLeast':
            case 'Exactly':
                lineSpacing = HelperMethods.convertPointToPixel(paragraph.paragraphFormat.lineSpacing);
                break;
            default:
                lineSpacing = paragraph.paragraphFormat.lineSpacing;
                if (alterLineSpacing) {
                    lineSpacing = lineSpacing - 1;
                }
                lineSpacing = lineSpacing * maxHeight;
                break;
        }
        return lineSpacing;
    }
    isParagraphFirstLine(paragraph, line) {
        let widget = paragraph;
        if (isNullOrUndefined(widget.childWidgets) || widget.childWidgets.indexOf(line) === 0) {
            //If the line elements conatins the elements from previous paragraph then need to retun false.
            //Example scenario, Field start and field end in different paragraphs.
            if (line.children.length > 0 && !isNullOrUndefined(paragraph.previousWidget)
                && paragraph.previousWidget instanceof ParagraphWidget) {
                return line.paragraph.index !== paragraph.previousWidget.index;
            }
            return true; //If the line elements count is zero then also need to return true.
        }
        return false;
    }
    isParagraphLastLine(element) {
        let paragraph = element.line.paragraph;
        let lastLineWidget = paragraph.childWidgets[paragraph.childWidgets.length - 1];
        let lastInline = lastLineWidget.children[lastLineWidget.children.length - 1];
        if (element === lastInline) {
            return (lastInline instanceof FieldElementBox) || ((!(lastInline instanceof TextElementBox && lastInline.text === '\v')));
        }
        return false;
    }
    getTextIndexAfterSpace(text, startIndex) {
        let length = text.length;
        let index = 0;
        index = text.indexOf(' ', startIndex) + 1;
        if (index == 0) {
            index = text.indexOf('-', startIndex) + 1;
        }
        let nextIndex = index;
        if (nextIndex === 0 || nextIndex === length) {
            return nextIndex;
        }
        while (text[nextIndex] === ' ') {
            nextIndex++;
            if (nextIndex === length) {
                break;
            }
        }
        return nextIndex;
    }
    //#region Table
    moveNextWidgetsToTable(tableWidget, currentRow, moveFromNext) {
        let rowIndex = currentRow.indexInOwner;
        let currentTable = tableWidget[tableWidget.length - 1];
        if (moveFromNext) {
            rowIndex += 1;
        }
        let nextWidgets = currentRow.containerWidget.childWidgets.splice(rowIndex);
        for (let i = 0; i < nextWidgets.length; i++) {
            currentTable.childWidgets.push(nextWidgets[i]);
            nextWidgets[i].containerWidget = currentTable;
        }
    }
    addTableCellWidget(cell, area, maxCellMarginTop, maxCellMarginBottom) {
        //let tableCellWidget: TableCellWidget = new TableCellWidget(cell);
        let prevColumnIndex = 0;
        let cellspace = 0;
        let left = 0;
        let top = maxCellMarginTop;
        let right = 0;
        let bottom = maxCellMarginBottom;
        if (!isNullOrUndefined(cell.cellFormat)) {
            if (cell.cellFormat.containsMargins()) {
                left = isNullOrUndefined(cell.cellFormat.leftMargin) ? HelperMethods.convertPointToPixel(cell.ownerTable.tableFormat.leftMargin) : HelperMethods.convertPointToPixel(cell.cellFormat.leftMargin);
                right = isNullOrUndefined(cell.cellFormat.rightMargin) ? HelperMethods.convertPointToPixel(cell.ownerTable.tableFormat.rightMargin) : HelperMethods.convertPointToPixel(cell.cellFormat.rightMargin);
            }
            else {
                if (cell.columnIndex === 0 && cell.ownerRow.rowFormat.hasValue('leftMargin')) {
                    left = HelperMethods.convertPointToPixel(cell.ownerRow.rowFormat.leftMargin);
                }
                else {
                    left = HelperMethods.convertPointToPixel(cell.ownerTable.tableFormat.leftMargin);
                }
                if (cell.columnIndex === cell.ownerTable.tableHolder.columns.length - 1 &&
                    cell.ownerRow.rowFormat.hasValue('rightMargin')) {
                    right = HelperMethods.convertPointToPixel(cell.ownerRow.rowFormat.rightMargin);
                }
                else {
                    right = HelperMethods.convertPointToPixel(cell.ownerTable.tableFormat.rightMargin);
                }
            }
        }
        cell.margin = new Margin(left, top, right, bottom);
        let autofit = cell.ownerTable.tableFormat.allowAutoFit;
        let cellWidth = cell.cellFormat.cellWidth;
        if (cell.cellFormat.preferredWidthType === 'Percent' && cell.cellFormat.preferredWidth !== 0 && cellWidth <= 0) {
            let width = HelperMethods.convertPointToPixel(cell.ownerTable.getTableClientWidth(cell.ownerTable.getContainerWidth()));
            cellWidth = cell.ownerTable.getCellWidth(cell.cellFormat.preferredWidth, cell.cellFormat.preferredWidthType, width, cell);
        }
        // if (cellWidth > cell.cellFormat.preferredWidth && cell.cellFormat.preferredWidth !== 0 && cell.cellFormat.preferredWidthType !== 'Percent' && cell.ownerTable.tableFormat.preferredWidthType !== 'Percent' && isNullOrUndefined(cell.ownerTable.positioning) && (!cell.ownerTable.isContainInsideTable) && (!(cell.ownerTable.containerWidget instanceof TableCellWidget))) {
        //     cellWidth = cell.cellFormat.preferredWidth;
        // }
        cell.width = HelperMethods.convertPointToPixel(cellWidth);
        if (!isNullOrUndefined(cell.previousWidget)) {
            prevColumnIndex = cell.previousWidget.columnIndex + cell.previousWidget.cellFormat.columnSpan;
        }
        cellspace = !isNullOrUndefined(cell.ownerTable) && !isNullOrUndefined(cell.ownerTable.tableFormat) ? HelperMethods.convertPointToPixel(cell.ownerTable.tableFormat.cellSpacing) : 0;
        let prevSpannedCellWidth = 0;
        if (prevColumnIndex < cell.columnIndex) {
            prevSpannedCellWidth = HelperMethods.convertPointToPixel(cell.ownerTable.tableHolder.getPreviousSpannedCellWidth(prevColumnIndex, cell.columnIndex));
            if (prevColumnIndex === 0) {
                prevSpannedCellWidth = prevSpannedCellWidth - cellspace / 2;
            }
        }
        cell.x = area.x + prevSpannedCellWidth + cell.margin.left;
        cell.y = area.y + cell.margin.top + cellspace;
        cell.width = cell.width - cell.margin.left - cell.margin.right;
        if (cellspace > 0) {
            cell.x += cellspace;
            if (cell.ownerTable.tableHolder.columns.length === 1) {
                cell.width -= cellspace * 2;
            }
            else if (cell.columnIndex === 0 || cell.columnIndex === cell.ownerTable.tableHolder.columns.length - 1) {
                cell.width -= ((cellspace * 2) - cellspace / 2);
            }
            else {
                cell.width -= cellspace;
            }
        }
        let leftBorderWidth = HelperMethods.convertPointToPixel(TableCellWidget.getCellLeftBorder(cell).getLineWidth());
        let rightBorderWidth = HelperMethods.convertPointToPixel(TableCellWidget.getCellRightBorder(cell).getLineWidth());
        // update the margins values respect to layouting of borders.
        // for normal table cells only left border is rendred. for last cell left and right border is rendred.
        // this border widths are not included in margins.
        let linestyle = false;
        cell.leftBorderWidth = !cell.ownerTable.isBidiTable ? leftBorderWidth : rightBorderWidth;
        let isLeftStyleNone = (cell.cellFormat.borders.left.lineStyle === 'None');
        let isRightStyleNone = (cell.cellFormat.borders.right.lineStyle === 'None');
        cell.x += (!isLeftStyleNone) ? 0 : (cell.leftBorderWidth > 0) ? 0 : cell.leftBorderWidth;
        cell.width -= (!isLeftStyleNone) ? 0 : (cell.leftBorderWidth > 0) ? 0 : cell.leftBorderWidth;
        let lastCell = !cell.ownerTable.isBidiTable ? cell.cellIndex === cell.ownerRow.childWidgets.length - 1
            : cell.cellIndex === 0;
        if (cellspace > 0 || cell.columnIndex === cell.ownerTable.tableHolder.columns.length - 1 ||
            (cell.columnIndex === cell.containerWidget.childWidgets.length - 1 && cell.cellFormat.columnSpan > 1)) {
            cell.rightBorderWidth = !cell.ownerTable.isBidiTable ? rightBorderWidth : leftBorderWidth;
            if (!cell.ownerTable.tableFormat.allowAutoFit) {
                cell.width -= cell.rightBorderWidth;
            }
            if (!this.isInsertTable()) {
                linestyle = this.checkPreviousMargins(cell.ownerTable);
            }
        }
        //Add the border widths to respective margin side.
        //cell.margin.left += (isLeftStyleNone) ? 0 : (cell.leftBorderWidth);
        cell.margin.right += (isRightStyleNone && !linestyle) ? 0 : (cell.rightBorderWidth);
        //cell.ownerWidget = owner;
        return cell;
    }
    checkPreviousMargins(table) {
        for (let i = 0; i < table.childWidgets.length; i++) {
            let row = table.childWidgets[i];
            for (let j = 0; j < row.childWidgets.length; j++) {
                let cell = row.childWidgets[row.childWidgets.length - 1];
                if (cell.cellFormat.borders.right.lineStyle !== 'None') {
                    return true;
                }
            }
        }
        return false;
    }
    addWidgetToTable(viewer, tableCollection, rowCollection, row, endRowWidget, isInitialLayout) {
        //Adds table row widget to owner table widget.
        let tableWidget = tableCollection[0];
        let index = tableWidget.childWidgets.length;
        let prevWidget = undefined;
        let rowWidgetIndex = rowCollection.indexOf(row);
        if (rowWidgetIndex > 0) {
            prevWidget = rowCollection[rowWidgetIndex - 1];
            // Need to update on this further
        }
        else if (row.previousRenderedWidget instanceof TableRowWidget &&
            row.previousRenderedWidget.ownerTable.equals(row.ownerTable)) {
            // Need to update on this further
            prevWidget = row.previousRenderedWidget;
        }
        if (!isNullOrUndefined(prevWidget)) {
            tableWidget = prevWidget.containerWidget;
            // index = tableWidget.childWidgets.length;
            index = tableWidget.childWidgets.indexOf(prevWidget) + 1;
            if (Math.round(row.y) !== Math.round(prevWidget.y + prevWidget.height)) {
                let prevIndex = tableCollection.indexOf(tableWidget);
                if (prevIndex + 1 >= tableCollection.length) {
                    //Creates new table widget for splitted rows.
                    this.addTableWidget(viewer.clientActiveArea, tableCollection, true);
                }
                tableWidget = tableCollection[prevIndex + 1];
                index = tableWidget.childWidgets.length;
            }
            if (rowWidgetIndex > 0) {
                index = 0;
            }
        }
        this.updateRowHeightBySpannedCell(tableWidget, row, index);
        this.updateRowHeightByCellSpacing(tableCollection, row, viewer);
        //Remove widget from previous container after splitteing
        if (row.containerWidget && row.containerWidget !== tableWidget &&
            row.containerWidget.childWidgets.indexOf(row) !== -1) {
            row.containerWidget.childWidgets.splice(row.containerWidget.childWidgets.indexOf(row), 1);
        }
        if (tableWidget.childWidgets.indexOf(row) === -1) {
            tableWidget.childWidgets.splice(index, 0, row);
        }
        row.containerWidget = tableWidget;
        tableWidget.height = tableWidget.height + row.height;
        // Shift the widgets for Right to left directed table.
        if (tableWidget.isBidiTable) {
            row.shiftWidgetForRtlTable(this.viewer.clientArea, tableWidget, row);
        }
        if (this.viewer instanceof PageLayoutViewer) {
            if (!isNullOrUndefined(tableWidget.containerWidget)
                && tableWidget.containerWidget.childWidgets.indexOf(tableWidget) >= 0 &&
                !(tableWidget.containerWidget instanceof HeaderFooterWidget)) {
                tableWidget.containerWidget.height += row.height;
            }
        }
        this.updateHeightForRowWidget(viewer, false, tableCollection, rowCollection, row, false, endRowWidget, isInitialLayout);
        viewer.cutFromTop(row.y + row.height);
    }
    updateRowHeightBySpannedCell(tableWidget, row, insertIndex) {
        let rowSpan = 1;
        if (tableWidget.childWidgets.length === 0 || insertIndex === 0) {
            this.updateRowHeight(row, row);
            return;
        }
        for (let i = 0; i < row.childWidgets.length; i++) {
            let cellWidget = row.childWidgets[i];
            rowSpan = (isNullOrUndefined(cellWidget) || isNullOrUndefined(cellWidget.cellFormat)) ? rowSpan : cellWidget.cellFormat.rowSpan;
            this.updateSpannedRowCollection(rowSpan, row, cellWidget);
        }
        if (!isNullOrUndefined(row.ownerTable)) {
            for (let i = 0; i < row.ownerTable.spannedRowCollection.length; i++) {
                if (row.ownerTable.spannedRowCollection.keys[i] === row.index) {
                    // Back track to previous table row widgets and update it height if vertical merge ends with this row.
                    for (let j = 0; j < insertIndex; j++) {
                        let prevRowWidget = tableWidget.childWidgets[j];
                        this.updateRowHeight(prevRowWidget, row);
                    }
                    row.ownerTable.spannedRowCollection.remove(row.ownerTable.spannedRowCollection.keys[i]);
                    break;
                }
            }
        }
    }
    updateRowHeight(prevRowWidget, row) {
        let rowIndex = row.index;
        let rowSpan = 1;
        for (let i = 0; i < prevRowWidget.childWidgets.length; i++) {
            let cellWidget = prevRowWidget.childWidgets[i];
            rowSpan = (isNullOrUndefined(cellWidget) || isNullOrUndefined(cellWidget.cellFormat)) ? rowSpan : cellWidget.cellFormat.rowSpan;
            //To update Row height- if row has row span value greater than 1, need to add it in spannedRowCollection            
            this.updateSpannedRowCollection(rowSpan, row, cellWidget);
            if (rowIndex - cellWidget.rowIndex === rowSpan - 1) {
                let mergedCellHeight = cellWidget.y + cellWidget.height + cellWidget.margin.bottom - row.y;
                if ((row.rowFormat.heightType !== 'Exactly' || (row.rowFormat.heightType === 'Exactly' && row.rowFormat.height > mergedCellHeight)) && row.height < mergedCellHeight) {
                    row.height = mergedCellHeight;
                }
            }
        }
    }
    //if row has row span value greater than 1, need to add it in spannedRowCollection
    updateSpannedRowCollection(rowSpan, row, cellWidget) {
        if (rowSpan > 1 && !isNullOrUndefined(row.ownerTable)) {
            //Checks the rowspan is already exist in the list
            if (!row.ownerTable.spannedRowCollection.containsKey(row.index + rowSpan - 1)) {
                row.ownerTable.spannedRowCollection.add(row.index + rowSpan - 1, row.index);
            }
        }
    }
    updateRowHeightByCellSpacing(tableCollection, row, viewer) {
        if (row.ownerTable.tableFormat.cellSpacing > 0) {
            // In the Case of tableWidget is greater than one and rowWidget is start at the Top Position of the page. 
            // In such case we have update the row height with half of cell spacing.
            // Remaining cases we have to update the entire hight
            if (tableCollection.length > 1 && row.y === viewer.clientArea.y && viewer instanceof PageLayoutViewer) {
                row.height = row.height - HelperMethods.convertPointToPixel(row.ownerTable.tableFormat.cellSpacing) / 2;
            }
        }
    }
    isRowSpanEnd(row, viewer) {
        let rowIndex = row.index;
        let rowSpan = 1;
        for (let i = 0; i < this.documentHelper.splittedCellWidgets.length; i++) {
            let splittedCell = this.documentHelper.splittedCellWidgets[i];
            rowSpan = (isNullOrUndefined(splittedCell) || isNullOrUndefined(splittedCell.cellFormat)) ? rowSpan : splittedCell.cellFormat.rowSpan;
            if (rowIndex - splittedCell.rowIndex === rowSpan - 1) {
                return true;
            }
        }
        return false;
    }
    isVerticalMergedCellContinue(row) {
        let colIndex = 0;
        for (let i = 0; i < row.childWidgets.length; i++) {
            let cell = row.childWidgets[i];
            if (colIndex < cell.columnIndex) {
                return true;
            }
            colIndex += cell.cellFormat.columnSpan;
        }
        return colIndex < row.ownerTable.tableHolder.columns.length;
    }
    splitWidgets(tableRowWidget, viewer, tableCollection, rowCollection, splittedWidget, isLastRow) {
        if (this.isFirstLineFitForRow(viewer.clientArea.bottom, tableRowWidget) && tableRowWidget.childWidgets.length > 0) {
            splittedWidget = this.getSplittedWidgetForRow(viewer.clientArea.bottom, tableCollection, rowCollection, tableRowWidget);
            if (this.documentHelper.splittedCellWidgets.length > 0 || splittedWidget !== tableRowWidget) {
                if (isLastRow) {
                    for (let i = 0; i < splittedWidget.childWidgets.length; i++) {
                        let cell = splittedWidget.childWidgets[i];
                        if (cell.rowIndex !== splittedWidget.index) {
                            splittedWidget.childWidgets.splice(i, 1);
                            i--;
                        }
                    }
                }
                //Adds the splitted widget of a vertical merged cell, to next row widget in the next page.
                this.insertSplittedCellWidgets(viewer, tableCollection, splittedWidget, tableRowWidget.index - 1);
            }
        }
        else {
            //Adds the splitted widget of a vertical merged cell, to next row widget in the next page.
            this.insertSplittedCellWidgets(viewer, tableCollection, splittedWidget, tableRowWidget.index - 1);
        }
        return splittedWidget;
    }
    getSplittedWidgetForRow(bottom, tableCollection, rowCollection, tableRowWidget) {
        let splittedWidget = undefined;
        let rowIndex = tableRowWidget.index;
        this.isRelayoutneed = false;
        let issplit = false;
        for (let i = 0; i < tableRowWidget.childWidgets.length; i++) {
            let cellWidget = tableRowWidget.childWidgets[i];
            let splittedCell = this.getSplittedWidget(bottom, true, tableCollection, rowCollection, cellWidget);
            if (!isNullOrUndefined(splittedCell)) {
                if (splittedCell === cellWidget) {
                    //Returns if the whole content of the row does not fit in current page.
                    return tableRowWidget;
                }
                if (tableRowWidget.childWidgets.indexOf(splittedCell) !== -1) {
                    tableRowWidget.childWidgets.splice(tableRowWidget.childWidgets.indexOf(splittedCell), 1);
                }
                if (i === 0 || tableRowWidget.height < cellWidget.height + cellWidget.margin.top + cellWidget.margin.bottom) {
                    tableRowWidget.height = cellWidget.height + cellWidget.margin.top + cellWidget.margin.bottom;
                }
                if (isNullOrUndefined(splittedWidget)) {
                    //Creates new widget, to hold the splitted contents.
                    splittedWidget = new TableRowWidget();
                    splittedWidget.containerWidget = tableRowWidget.containerWidget;
                    splittedWidget.index = tableRowWidget.index;
                    splittedWidget.rowFormat = tableRowWidget.rowFormat;
                    this.updateWidgetLocation(tableRowWidget, splittedWidget);
                    // splittedWidget.height = 0;
                    rowCollection.push(splittedWidget);
                }
                let rowSpan = 1;
                rowSpan = (isNullOrUndefined(splittedCell) || isNullOrUndefined(splittedCell.cellFormat)) ? rowSpan : splittedCell.cellFormat.rowSpan;
                if (rowIndex - splittedCell.rowIndex === rowSpan - 1
                    && splittedWidget.height < splittedCell.height + splittedCell.margin.top + splittedCell.margin.bottom) {
                    splittedWidget.height = splittedCell.height + splittedCell.margin.top + splittedCell.margin.bottom;
                }
                else {
                    if (tableRowWidget.rowFormat.heightType === 'Exactly' || (tableRowWidget.rowFormat.heightType === 'AtLeast' &&
                        splittedWidget.height < tableRowWidget.rowFormat.height)) {
                        //Sets the height for row widget if height type is exact or at least.
                        splittedWidget.height = tableRowWidget.rowFormat.height;
                    }
                }
                splittedWidget.childWidgets.push(splittedCell);
                splittedCell.containerWidget = splittedWidget;
                this.isRelayoutneed = true;
                let count = i;
                while (count > 0 && !issplit) {
                    let cellWidget = tableRowWidget.childWidgets[count - 1];
                    splittedCell = this.getSplittedWidget(bottom, true, tableCollection, rowCollection, cellWidget);
                    splittedWidget.childWidgets.splice(0, 0, splittedCell);
                    splittedCell.containerWidget = splittedWidget;
                    count--;
                }
                issplit = true;
            }
        }
        return splittedWidget;
    }
    updateWidgetsToTable(tableWidgets, rowWidgets, row) {
        let rowHeight = this.getRowHeight(row, [row]);
        let viewer = this.viewer;
        //initializing row properties with default values.
        let isHeader = row.rowFormat.isHeader;
        let headerRow = undefined;
        let isAllowBreakAcrossPages = row.rowFormat.allowBreakAcrossPages;
        let heightType = row.rowFormat.heightType;
        let cellSpacing = 0;
        let count = 0;
        let tableRowWidget = row;
        let moveRowToNextTable = false;
        if (this.isTableFootNote) {
            this.footHeight = tableRowWidget.bodyWidget.page.footnoteWidget.height;
            this.isTableFootNote = false;
        }
        else {
            this.footHeight = 0;
        }
        if (row.ownerTable.continueHeader && !isHeader) {
            row.ownerTable.continueHeader = false;
        }
        let isInitialLayout = row.ownerTable.isInsideTable;
        let isLastRow = false;
        cellSpacing = (!isNullOrUndefined(row.ownerTable) && !isNullOrUndefined(row.ownerTable.tableFormat)) ? HelperMethods.convertPointToPixel(row.ownerTable.tableFormat.cellSpacing) : 0;
        while (count < rowWidgets.length) {
            count = rowWidgets.length;
            if (this.isRowSpanEnd(row, viewer) && row.rowFormat.heightType === 'Exactly' && this.documentHelper.splittedCellWidgets.length === 1) {
                this.documentHelper.splittedCellWidgets = [];
            }
            if (row.ownerTable.isInsideTable || (this.documentHelper.splittedCellWidgets.length === 0 && tableRowWidget.y + tableRowWidget.height + cellSpacing + this.footnoteHeight <= viewer.clientArea.bottom)) {
                if (this.isVerticalMergedCellContinue(row) && (tableRowWidget.y === viewer.clientArea.y
                    || tableRowWidget.y === this.viewer.clientArea.y + tableRowWidget.ownerTable.headerHeight)) {
                    this.insertSplittedCellWidgets(viewer, tableWidgets, tableRowWidget, tableRowWidget.index - 1);
                }
                this.addWidgetToTable(viewer, tableWidgets, rowWidgets, tableRowWidget, undefined, isInitialLayout);
                if (this.documentHelper.splittedCellWidgets.length > 0 && isNullOrUndefined(rowWidgets[rowWidgets.length - 1].nextRow)) {
                    count--;
                    isLastRow = true;
                }
                isInitialLayout = false;
            }
            else {
                isInitialLayout = false;
                //Split widget for next page
                if (this.documentHelper.splittedCellWidgets.length > 0 && tableRowWidget.y + tableRowWidget.height + this.footHeight <= viewer.clientArea.bottom) {
                    let isRowSpanEnd = this.isRowSpanEnd(row, viewer);
                    if (!isRowSpanEnd) {
                        if (this.isVerticalMergedCellContinue(row) && (tableRowWidget.y === viewer.clientArea.y
                            || tableRowWidget.y === this.viewer.clientArea.y + tableRowWidget.ownerTable.headerHeight)) {
                            this.insertSplittedCellWidgets(viewer, tableWidgets, tableRowWidget, tableRowWidget.indexInOwner - 1);
                        }
                        this.addWidgetToTable(viewer, tableWidgets, rowWidgets, tableRowWidget);
                        continue;
                    }
                }
                let splittedWidget = tableRowWidget;
                let tableWidget = tableWidgets[tableWidgets.length - 1];
                if (rowHeight + tableRowWidget.y + (this.isInitialLoad ? this.footHeight : 0) > viewer.clientArea.bottom) {
                    if (!isAllowBreakAcrossPages || (isHeader && row.ownerTable.continueHeader) || (heightType === 'AtLeast' && HelperMethods.convertPointToPixel(row.rowFormat.height) < viewer.clientArea.bottom)) {
                        if ((heightType === 'AtLeast' && HelperMethods.convertPointToPixel(row.rowFormat.height) < viewer.clientActiveArea.height && (isAllowBreakAcrossPages || row.indexInOwner === 0)) || (heightType !== 'Exactly' && tableRowWidget.y === viewer.clientArea.y) || (heightType === 'Auto' && isAllowBreakAcrossPages)) {
                            splittedWidget = this.splitWidgets(tableRowWidget, viewer, tableWidgets, rowWidgets, splittedWidget, isLastRow);
                        }
                        // if (heightType === 'AtLeast' && row.ownerTable.spannedRowCollection.keys.length > 0) {
                        //     splittedWidget = this.splitWidgets(tableRowWidget, viewer, tableWidgets, rowWidgets, splittedWidget, isLastRow);
                        // }
                        // if (heightType === 'AtLeast' && HelperMethods.convertPointToPixel(row.rowFormat.height) > viewer.clientActiveArea.height && isAllowBreakAcrossPages && tableRowWidget.ownerTable.tableHolder.columns.length > this.getTotalColumnSpan(tableRowWidget)) {
                        //     tableRowWidget = this.splitWidgets(tableRowWidget, viewer, tableWidgets, rowWidgets, splittedWidget, isLastRow);
                        //     splittedWidget = tableRowWidget;
                        // }
                        if (heightType === 'Exactly' && tableRowWidget.y === viewer.clientArea.y) {
                            this.addWidgetToTable(viewer, tableWidgets, rowWidgets, tableRowWidget);
                            count++;
                        }
                        if (isHeader && row.ownerTable.continueHeader) {
                            row.ownerTable.header = false;
                            row.ownerTable.continueHeader = false;
                            row.ownerTable.headerHeight = 0;
                            let pages = undefined;
                            if (viewer instanceof PageLayoutViewer) {
                                pages = this.documentHelper.pages;
                            }
                            if (!isNullOrUndefined(pages)) {
                                for (let i = 0; i < pages.length; i++) {
                                    if (pages[i].repeatHeaderRowTableWidget) {
                                        pages[i].repeatHeaderRowTableWidget = false;
                                    }
                                }
                            }
                        }
                    }
                    else {
                        if ((heightType === 'Auto' || heightType === 'AtLeast') && isAllowBreakAcrossPages) {
                            if (!(HelperMethods.convertPointToPixel(row.rowFormat.height) > viewer.clientArea.bottom) || tableRowWidget.y === viewer.clientArea.y) {
                                splittedWidget = this.splitWidgets(tableRowWidget, viewer, tableWidgets, rowWidgets, splittedWidget, isLastRow);
                            }
                        }
                        else if (heightType === 'Exactly' && tableRowWidget.y === viewer.clientArea.y) {
                            this.addWidgetToTable(viewer, tableWidgets, rowWidgets, tableRowWidget);
                            count++;
                        }
                    }
                }
                else {
                    let isInsertSplittedWidgets = false;
                    // Splitting handled for the merged cell with allowRowBreakAcross pages. 
                    if (this.isVerticalMergedCellContinue(row) && (isAllowBreakAcrossPages ||
                        (isInsertSplittedWidgets = (tableRowWidget.y === viewer.clientArea.y
                            || tableRowWidget.y === this.viewer.clientArea.y + tableRowWidget.ownerTable.headerHeight)))) {
                        if (isInsertSplittedWidgets) {
                            this.insertSplittedCellWidgets(viewer, tableWidgets, splittedWidget, tableRowWidget.indexInOwner - 1);
                        }
                        else {
                            splittedWidget = this.splitWidgets(tableRowWidget, viewer, tableWidgets, rowWidgets, splittedWidget, isLastRow);
                            if (isNullOrUndefined(splittedWidget)) {
                                isInsertSplittedWidgets = (tableRowWidget.y === viewer.clientArea.y
                                    || tableRowWidget.y === this.viewer.clientArea.y + tableRowWidget.ownerTable.headerHeight);
                                if (isInsertSplittedWidgets) {
                                    this.insertSplittedCellWidgets(viewer, tableWidgets, tableRowWidget, tableRowWidget.indexInOwner - 1);
                                    count--;
                                    continue;
                                }
                            }
                        }
                    }
                    else if (isLastRow && !isAllowBreakAcrossPages) {
                        splittedWidget = this.splitWidgets(tableRowWidget, viewer, tableWidgets, rowWidgets, splittedWidget, isLastRow);
                    }
                }
                //Create New table for splitted widget
                if (!isNullOrUndefined(splittedWidget) && !this.documentHelper.owner.editor.isTableInsert && !(splittedWidget.bodyWidget.containerWidget instanceof FootNoteWidget)) {
                    if (splittedWidget !== tableRowWidget) {
                        this.addWidgetToTable(viewer, tableWidgets, rowWidgets, tableRowWidget, tableRowWidget.nextRow);
                        //Updates the fitted table rows to current page.
                        this.updateWidgetsToPage(tableWidgets, rowWidgets, row.ownerTable, tableRowWidget.nextRow);
                        let index = tableWidgets.indexOf(tableRowWidget.containerWidget);
                        if (index + 1 >= tableWidgets.length) {
                            //Creates new table widget for splitted rows.
                            this.addTableWidget(viewer.clientActiveArea, tableWidgets, true);
                        }
                        tableRowWidget = splittedWidget;
                    }
                    else {
                        if (row.index > 0) {
                            //Updates the fitted table rows to current page.
                            this.updateWidgetsToPage(tableWidgets, rowWidgets, row.ownerTable, row);
                            // Need to update on this further
                            if (row.previousRenderedWidget instanceof TableRowWidget) {
                                // Need to update on this further
                                let prevWidget = row.previousRenderedWidget;
                                if (HelperMethods.round(tableRowWidget.y, 2) === HelperMethods.round(prevWidget.y + prevWidget.height, 2)) {
                                    let prevIndex = tableWidgets.indexOf(prevWidget.containerWidget);
                                    if (prevIndex + 1 >= tableWidgets.length) {
                                        //Creates new table widget for splitted rows.
                                        this.addTableWidget(viewer.clientActiveArea, tableWidgets, true);
                                    }
                                }
                                else {
                                    //Creates new table widget for splitted rows.
                                    this.addTableWidget(viewer.clientActiveArea, tableWidgets, true);
                                }
                            }
                            else {
                                //Creates new table widget for splitted rows.
                                this.addTableWidget(viewer.clientActiveArea, tableWidgets, true);
                            }
                        }
                        moveRowToNextTable = true;
                        count--;
                    }
                    tableWidget = tableWidgets[tableWidgets.length - 1];
                    let prevBodyWidget = undefined;
                    if (tableWidgets.length > 1) {
                        //Get Previous Splitted Widget container
                        prevBodyWidget = tableWidgets[tableWidgets.length - 2].containerWidget;
                    }
                    else {
                        let previousBlock = row.ownerTable.previousRenderedWidget;
                        prevBodyWidget = previousBlock.containerWidget;
                    }
                    let pageIndex = 0;
                    if (!isNullOrUndefined(prevBodyWidget)) {
                        pageIndex = this.documentHelper.pages.indexOf(prevBodyWidget.page);
                    }
                    let rowToMove = row;
                    let keepNext = false;
                    let index = row.ownerTable.containerWidget.index;
                    let bodyWidget;
                    let block;
                    if (moveRowToNextTable && tableWidgets.length === 1) {
                        block = tableWidgets[tableWidgets.length - 1];
                    }
                    else {
                        block = tableWidgets[tableWidgets.length - 2];
                    }
                    let removeTable = true;
                    //Move Next RowWidge to next page
                    if (moveRowToNextTable && rowWidgets.length === 1) {
                        let prev = this.alignBlockElement(row);
                        if (!isNullOrUndefined(prev.node)) {
                            let previousRow = prev.node;
                            if (previousRow instanceof TableRowWidget
                                && previousRow.indexInOwner === 0) {
                                if (tableWidgets.length > 1 && tableWidgets[tableWidgets.length - 1].childWidgets.length === 0) {
                                    tableWidgets.pop();
                                    tableWidget = tableWidgets[tableWidgets.length - 1];
                                    tableWidget.height = 0;
                                }
                            }
                            else if (prev.node instanceof ParagraphWidget) {
                                let previousWidget = this.splitParagraph(prev.node, parseInt(prev.position.index, 10));
                                block = previousWidget;
                                if (tableWidgets.length > 1 && tableWidgets[tableWidgets.length - 1].childWidgets.length === 0) {
                                    tableWidgets.pop();
                                    tableWidget = tableWidgets[tableWidgets.length - 1];
                                }
                                removeTable = false;
                            }
                            if (previousRow instanceof TableRowWidget) {
                                rowToMove = previousRow;
                                if (!rowToMove.ownerTable.equals(row.ownerTable)) {
                                    removeTable = false;
                                }
                            }
                            keepNext = true;
                        }
                    }
                    bodyWidget = this.moveBlocksToNextPage(block instanceof ParagraphWidget ? block.previousWidget : block, false);
                    let curretTable = tableWidgets[tableWidgets.length - 1];
                    //Move Next RowWidge to next page
                    if (moveRowToNextTable && removeTable) {
                        if (rowToMove.index === 0 && curretTable.containerWidget && curretTable.containerWidget.childWidgets.indexOf(curretTable) !== -1) {
                            curretTable.containerWidget.childWidgets.splice(curretTable.containerWidget.childWidgets.indexOf(curretTable), 1);
                        }
                    }
                    if (removeTable) {
                        if (bodyWidget.childWidgets.indexOf(curretTable) !== -1) {
                            bodyWidget.childWidgets.splice(bodyWidget.childWidgets.indexOf(curretTable), 1);
                        }
                        bodyWidget.childWidgets.unshift(curretTable);
                        this.shiftFloatingItemsFromTable(curretTable, bodyWidget);
                    }
                    curretTable.containerWidget = bodyWidget;
                    if (moveRowToNextTable && rowToMove.index > 0 || rowWidgets.length > 1) {
                        let currentRow = !moveRowToNextTable ? rowWidgets[rowWidgets.length - 2] : rowWidgets[rowWidgets.length - 1];
                        if (keepNext) {
                            currentRow = rowToMove;
                        }
                        this.moveNextWidgetsToTable(tableWidgets, currentRow, !moveRowToNextTable);
                        rowToMove = row;
                    }
                    if (keepNext) {
                        this.updateClientPositionForBlock(removeTable ? curretTable : block, row);
                    }
                    moveRowToNextTable = false;
                    if (rowToMove.ownerTable.header && tableRowWidget.height < viewer.clientArea.bottom) {
                        if (viewer instanceof PageLayoutViewer) {
                            viewer.documentHelper.currentRenderingPage.repeatHeaderRowTableWidget = true;
                        }
                        //Updates table widgets location.
                        viewer.updateClientAreaForBlock(rowToMove.ownerTable, true, tableWidgets);
                        //Update splitted row widget location. if header is repeated update the y position of splitted widget to header height.
                        splittedWidget.x = splittedWidget.x;
                        splittedWidget.y = tableWidget.y + rowToMove.ownerTable.headerHeight;
                        // let cellspace: number = viewer instanceof PageLayoutViewer ? cellspacing / 2 : cellspacing;
                        let cellspace = cellSpacing / 2;
                        this.updateChildLocationForRow(tableWidget.y + rowToMove.ownerTable.headerHeight - cellspace, splittedWidget);
                    }
                    else {
                        //Updates table widgets location.
                        viewer.updateClientAreaForBlock(rowToMove.ownerTable, true, tableWidgets);
                        //Update splitted row widget location. if header is repeated update the y position of splitted widget to header height.
                        splittedWidget.x = splittedWidget.x;
                        splittedWidget.y = tableWidget.y;
                        // let cellspace: number = viewer instanceof PageLayoutViewer ? cellspacing / 2 : cellspacing;
                        let cellspace = cellSpacing / 2;
                        this.updateChildLocationForRow(tableWidget.y - cellspace, splittedWidget);
                    }
                    if (removeTable && this.shiftedFloatingItemsFromTable.length > 0) {
                        for (let i = 0; i < this.shiftedFloatingItemsFromTable.length; i++) {
                            let floatingItem = this.shiftedFloatingItemsFromTable[i];
                            let position = this.getFloatingItemPoints(floatingItem);
                            floatingItem.y = position.y;
                            floatingItem.x = position.x;
                            if (floatingItem instanceof ShapeElementBox) {
                                this.updateChildLocationForCellOrShape(floatingItem.y, floatingItem);
                            }
                        }
                        this.shiftedFloatingItemsFromTable = [];
                    }
                }
                isLastRow = false;
            }
            if (isHeader) {
                if (row.ownerTable.continueHeader) {
                    row.ownerTable.header = true;
                    row.ownerTable.headerHeight = rowHeight + row.ownerTable.headerHeight;
                }
                headerRow = this.getHeader(row.ownerTable);
                if (!isNullOrUndefined(headerRow) && row.index === headerRow.index) {
                    let headerHeight = this.getHeaderHeight(row.ownerTable, row, rowWidgets);
                    if (headerHeight > row.ownerTable.headerHeight || headerHeight > row.ownerTable.headerHeight) {
                        row.ownerTable.headerHeight = headerHeight;
                    }
                    if (row.ownerTable.headerHeight > viewer.clientArea.height) {
                        row.ownerTable.header = false;
                        row.ownerTable.continueHeader = false;
                        row.ownerTable.headerHeight = 0;
                        let pages = this.documentHelper.pages;
                        for (let i = 0; i < pages.length; i++) {
                            if (pages[i].repeatHeaderRowTableWidget) {
                                pages[i].repeatHeaderRowTableWidget = false;
                            }
                        }
                    }
                }
            }
            if (tableWidgets.length > 2 && row.ownerTable.header && tableRowWidget.height < viewer.clientActiveArea.bottom &&
                !viewer.documentHelper.currentRenderingPage.repeatHeaderRowTableWidget) {
                viewer.documentHelper.currentRenderingPage.repeatHeaderRowTableWidget = true;
            }
        }
    }
    getHeader(table) {
        let header = undefined;
        let flag = true;
        table = table.getSplitWidgets()[0];
        for (let i = 0; i < table.childWidgets.length; i++) {
            const row = table.childWidgets[i];
            if (row.rowFormat.isHeader) {
                header = row;
            }
            else {
                flag = false;
            }
            if (!flag) {
                break;
            }
        }
        return header;
    }
    getHeaderHeight(ownerTable, row, rowCollection) {
        let height = 0;
        if (row.ownerTable.childWidgets.length > 0 && ownerTable.childWidgets[0].rowFormat.isHeader) {
            for (let i = 0; i < ownerTable.childWidgets.length; i++) {
                const row = ownerTable.childWidgets[i];
                if (row.rowFormat.isHeader) {
                    height = height + row.height;
                }
                else {
                    break;
                }
            }
        }
        return height;
    }
    updateWidgetToRow(cell) {
        //const viewer: LayoutViewer = this.viewer;
        //Adds table cell widget to owner row widget.
        const rowWidget = cell.ownerRow;
        // let cellLeft: number = rowWidget.x;
        // if (rowWidget.childWidgets.length > 0) {
        //     const lastWidget: TableCellWidget = rowWidget.childWidgets[rowWidget.childWidgets.length - 1] as TableCellWidget;
        //     cellLeft = lastWidget.x + lastWidget.width + lastWidget.margin.right;
        // }
        // rowWidget.childWidgets.push(cell);
        cell.containerWidget = rowWidget;
        //If the row height is set as Atleast then height is set to atleast height for the first cell of the row.
        if (!isNullOrUndefined(cell.ownerRow) && cell.ownerRow.rowFormat.heightType !== 'Exactly' && HelperMethods.convertPointToPixel(cell.ownerRow.rowFormat.height) > 0 && cell.cellIndex === 0) {
            rowWidget.height = rowWidget.height + HelperMethods.convertPointToPixel(cell.ownerRow.rowFormat.height);
        }
        //Add condition not cell merged vertically.
        if (cell.cellFormat.rowSpan === 1) {
            let cellHeight;
            if (rowWidget.rowFormat.heightType === 'Exactly') {
                cellHeight = cell.height + cell.margin.bottom;
            }
            else {
                cellHeight = cell.height + cell.margin.top + cell.margin.bottom;
            }
            if (rowWidget.height - HelperMethods.convertPointToPixel(cell.ownerTable.tableFormat.cellSpacing) < cellHeight) {
                rowWidget.height = cellHeight + HelperMethods.convertPointToPixel(cell.ownerTable.tableFormat.cellSpacing);
            }
        }
    }
    /* eslint-disable-next-line max-len */
    updateHeightForRowWidget(viewer, isUpdateVerticalPosition, tableCollection, rowCollection, rowWidget, isLayouted, endRowWidget, isInitialLayout) {
        for (let i = 0; i < rowWidget.childWidgets.length; i++) {
            let cellspacing = 0;
            let cellWidget = undefined;
            const childWidget = rowWidget.childWidgets[i];
            // if (childWidget instanceof TableCellWidget) {
            cellWidget = childWidget;
            // }
            let rowSpan = 1;
            rowSpan = cellWidget.cellFormat.rowSpan;
            cellspacing = HelperMethods.convertPointToPixel(cellWidget.ownerTable.tableFormat.cellSpacing);
            if (rowSpan > 1) {
                const currentRowWidgetIndex = rowWidget.containerWidget.childWidgets.indexOf(rowWidget);
                const rowSpanWidgetEndIndex = currentRowWidgetIndex + rowSpan - 1 - (rowWidget.index - cellWidget.rowIndex);
                if (!isInitialLayout && (viewer.clientArea.bottom < cellWidget.y + cellWidget.height + cellWidget.margin.bottom
                    || rowSpanWidgetEndIndex >= currentRowWidgetIndex + 1) && (rowCollection.length === 1
                    || rowCollection.length >= 1 && rowWidget === rowCollection[rowCollection.length - 1])) {
                    this.splitSpannedCellWidget(cellWidget, tableCollection, rowCollection, viewer);
                }
                let spanEndRowWidget = rowWidget;
                if (rowSpanWidgetEndIndex > 0) {
                    if (rowSpanWidgetEndIndex < rowWidget.containerWidget.childWidgets.length) {
                        const childWidget = rowWidget.containerWidget.childWidgets[rowSpanWidgetEndIndex];
                        if (childWidget instanceof TableRowWidget) {
                            spanEndRowWidget = childWidget;
                            if (spanEndRowWidget === endRowWidget) {
                                spanEndRowWidget = rowWidget;
                            }
                        }
                    }
                    else {
                        /* eslint-disable-next-line max-len */
                        spanEndRowWidget = rowWidget.containerWidget.childWidgets[rowWidget.containerWidget.childWidgets.length - 1];
                    }
                }
                if (cellWidget.y + cellWidget.height + cellWidget.margin.bottom < spanEndRowWidget.y + spanEndRowWidget.height) {
                    cellWidget.height = spanEndRowWidget.y + spanEndRowWidget.height - cellWidget.y - cellWidget.margin.bottom;
                    /* eslint-disable-next-line max-len */
                }
                else if (isLayouted && spanEndRowWidget && (spanEndRowWidget.y !== 0 && spanEndRowWidget.height !== 0) && cellWidget.y + cellWidget.height + cellWidget.margin.bottom > spanEndRowWidget.y + spanEndRowWidget.height) {
                    if (spanEndRowWidget.rowFormat.heightType !== 'Exactly' || (spanEndRowWidget.rowFormat.heightType === 'Exactly' && spanEndRowWidget.rowFormat.height > cellWidget.y + cellWidget.height + cellWidget.margin.bottom - spanEndRowWidget.y)) {
                        spanEndRowWidget.height = cellWidget.y + cellWidget.height + cellWidget.margin.bottom - spanEndRowWidget.y;
                    }
                    else {
                        cellWidget.height = (spanEndRowWidget.y - cellWidget.y) + spanEndRowWidget.height;
                    }
                    //Update the next rowlayout widget location. Reason for the updation is previous row height is updated when cell height is greater. So already layouted next row location has to be updated again.
                    // if (rowWidget === spanEndRowWidget && rowWidget.nextWidget instanceof TableRowWidget) {
                    //     let nextRow: TableRowWidget = rowWidget.nextWidget as TableRowWidget;
                    //     // Need to update on this further
                    //     // if (viewer.renderedElements.containsKey(nextRow)) {
                    //     //     let nextWidget: TableRowWidget[] = viewer.renderedElements.get(nextRow) as TableRowWidget[];
                    //     //     if (nextWidget.length > 0) {
                    //     //         nextWidget[0].x = nextWidget[0].x;
                    //     //         nextWidget[0].y = rowWidget.y + rowWidget.height;
                    //     //     }
                    //     // }
                    // }
                }
            }
            else {
                if (cellspacing > 0) {
                    // In the Case of tableWidget is greater than one and rowWidget is start at the Top Position of the page.
                    // In such case we have update the cell height with half of cell spacing.
                    // Remaining cases we have to update the entire hight
                    if (tableCollection.length > 1 && rowWidget.y === viewer.clientArea.y && viewer instanceof PageLayoutViewer) {
                        cellspacing = cellspacing / 2;
                    }
                }
                cellWidget.height = rowWidget.height - cellWidget.margin.top - cellWidget.margin.bottom - cellspacing;
            }
            this.updateHeightForCellWidget(viewer, tableCollection, rowCollection, cellWidget);
            let widget = rowWidget.containerWidget;
            while (widget.containerWidget instanceof Widget) {
                widget = widget.containerWidget;
            }
            let page = undefined;
            if (widget instanceof BodyWidget) {
                page = widget.page;
            }
            /* eslint-disable-next-line max-len */
            if ((viewer instanceof PageLayoutViewer && viewer.visiblePages.indexOf(page) !== -1) || isUpdateVerticalPosition) {
                this.updateCellVerticalPosition(cellWidget, false, cellWidget.ownerTable.isInsideTable);
            }
            //Renders the current table row contents, after relayout based on editing.
            // if (viewer instanceof PageLayoutViewer && (viewer as PageLayoutViewer).visiblePages.indexOf(page) !== -1) {
            //     //Added proper undefined condition check for Asynchronous operation.
            //     if (!isNullOrUndefined(rowWidget.tableRow) && !isNullOrUndefined(rowWidget.tableRow.rowFormat)) {
            //         this.viewer.updateScrollBars();
            //         //this.render.renderTableCellWidget(page, cellWidget);
            //     }
            // }
        }
    }
    /* eslint-disable-next-line max-len */
    updateHeightForCellWidget(viewer, tableWidget, rowCollection, cellWidget) {
        for (let i = 0; i < cellWidget.childWidgets.length; i++) {
            if (cellWidget.childWidgets[i] instanceof TableWidget) {
                this.updateHeightForTableWidget(tableWidget, rowCollection, cellWidget.childWidgets[i]);
            }
        }
    }
    getRowHeight(row, rowCollection) {
        let height = 0;
        if (row.rowFormat.heightType === 'Exactly') {
            height = row.rowFormat.height;
        }
        else {
            for (let i = 0; i < rowCollection.length; i++) {
                if (rowCollection[i] instanceof TableRowWidget) {
                    height = rowCollection[i].height + height;
                }
            }
            height = Math.max(height, row.rowFormat.height);
        }
        return height;
    }
    /* eslint-disable-next-line max-len */
    splitSpannedCellWidget(cellWidget, tableCollection, rowCollection, viewer) {
        /* eslint-disable-next-line max-len */
        const splittedCell = this.getSplittedWidget(viewer.clientArea.bottom, false, tableCollection, rowCollection, cellWidget);
        if (!isNullOrUndefined(splittedCell)) {
            //Adds the splitted contents of a vertical merged cell, in order preserve in next page.
            this.documentHelper.splittedCellWidgets.push(splittedCell);
        }
    }
    /* eslint-disable-next-line max-len */
    insertSplittedCellWidgets(viewer, tableCollection, rowWidget, previousRowIndex) {
        if (!isNullOrUndefined(rowWidget)) {
            let left = rowWidget.x;
            let tableWidth = 0;
            tableWidth = HelperMethods.convertPointToPixel(rowWidget.ownerTable.tableHolder.tableWidth);
            for (let i = 0; i < rowWidget.childWidgets.length; i++) {
                const cellWidget = rowWidget.childWidgets[i];
                if (Math.round(left) < Math.round(cellWidget.x - cellWidget.margin.left)) {
                    if (this.insertRowSpannedWidget(rowWidget, viewer, left, i)) {
                        i--;
                        continue;
                    }
                    const length = rowWidget.childWidgets.length;
                    this.insertEmptySplittedCellWidget(rowWidget, tableCollection, left, i, previousRowIndex);
                    if (length < rowWidget.childWidgets.length) {
                        if (i === 0) {
                            break;
                        }
                        i--;
                        continue;
                    }
                }
                left += cellWidget.margin.left + cellWidget.width + cellWidget.margin.right;
                if (i === rowWidget.childWidgets.length - 1 && Math.round(left) < Math.round(rowWidget.x + tableWidth)) {
                    if (this.insertRowSpannedWidget(rowWidget, viewer, left, i + 1)) {
                        continue;
                    }
                    this.insertEmptySplittedCellWidget(rowWidget, tableCollection, left, i + 1, previousRowIndex);
                    continue;
                }
            }
            // Special case: when the child widgets of row is equal to 0 then the splitted widgets in the viewer is added in the table row widgets.
            /* eslint-disable-next-line max-len */
            if ((isNullOrUndefined(rowWidget.childWidgets) || rowWidget.childWidgets.length === 0) && this.documentHelper.splittedCellWidgets.length > 0) {
                for (let j = 0; j < this.documentHelper.splittedCellWidgets.length; j++) {
                    const widget = this.documentHelper.splittedCellWidgets[j];
                    if (Math.round(left) <= Math.round(widget.x - widget.margin.left)) {
                        if (this.insertRowSpannedWidget(rowWidget, viewer, left, j)) {
                            j--;
                            continue;
                        }
                        const count = rowWidget.childWidgets.length;
                        this.insertEmptySplittedCellWidget(rowWidget, tableCollection, left, j, previousRowIndex);
                        if (count < rowWidget.childWidgets.length) {
                            j--;
                            continue;
                        }
                    }
                    left += widget.margin.left + widget.width + widget.margin.right;
                    if (j === rowWidget.childWidgets.length - 1 && Math.round(left) <
                        Math.round(rowWidget.x + tableWidth)) {
                        if (this.insertRowSpannedWidget(rowWidget, viewer, left, j + 1)) {
                            continue;
                        }
                        this.insertEmptySplittedCellWidget(rowWidget, tableCollection, left, j + 1, previousRowIndex);
                        continue;
                    }
                }
            }
            if (this.documentHelper.splittedCellWidgets.length > 0) {
                this.documentHelper.splittedCellWidgets = [];
            }
        }
    }
    insertRowSpannedWidget(rowWidget, viewer, left, index) {
        let cellSpacing = 0;
        if (rowWidget.ownerTable.tableFormat.cellSpacing > 0) {
            cellSpacing = HelperMethods.convertPointToPixel(rowWidget.ownerTable.tableFormat.cellSpacing);
        }
        for (let i = 0; i < this.documentHelper.splittedCellWidgets.length; i++) {
            const splittedCell = this.documentHelper.splittedCellWidgets[i];
            if (Math.round(left) === Math.round(splittedCell.x - splittedCell.margin.left)) {
                rowWidget.childWidgets.splice(index, 0, splittedCell);
                splittedCell.containerWidget = rowWidget;
                if (splittedCell.height > rowWidget.height) {
                    rowWidget.height = splittedCell.height;
                }
                //If the splitted cell location differs from expected location update the location of row child widgets.
                if (splittedCell.y !== rowWidget.y + splittedCell.margin.top + cellSpacing) {
                    this.updateChildLocationForRow(rowWidget.y, rowWidget);
                }
                this.documentHelper.splittedCellWidgets.splice(i, 1);
                return true;
            }
        }
        return false;
    }
    /* eslint-disable-next-line max-len */
    insertEmptySplittedCellWidget(currentRow, tableCollection, left, index, previousRowIndex) {
        let tableWidget = tableCollection[tableCollection.length - 1];
        let previousRow;
        for (let j = tableCollection.length - 1; j >= 0; j--) {
            const table = tableCollection[j];
            for (let z = table.childWidgets.length - 1; z >= 0; z--) {
                const row = table.childWidgets[z];
                if (row.index === previousRowIndex) {
                    previousRow = row;
                    break;
                }
            }
        }
        if (previousRow) {
            tableWidget = previousRow.ownerTable;
            previousRowIndex = previousRow.indexInOwner;
        }
        for (let i = previousRowIndex; i >= 0; i--) {
            const rowWidget = tableWidget.childWidgets[i];
            let previousLeft = rowWidget.x;
            for (let j = 0; j < rowWidget.childWidgets.length; j++) {
                let rowSpan = 1;
                const cellWidget = rowWidget.childWidgets[j];
                if (Math.round(left) === Math.round(previousLeft)) {
                    rowSpan = (isNullOrUndefined(cellWidget) || isNullOrUndefined(cellWidget.cellFormat)) ? rowSpan :
                        cellWidget.cellFormat.rowSpan;
                    if (rowSpan > 1) {
                        //if (!isNullOrUndefined(currentRow.childWidgets[index])) {
                        const emptyCellWidget = this.createCellWidget(cellWidget);
                        //if (emptyCellWidget.x < (currentRow.childWidgets[index] as TableCellWidget).x) {
                        currentRow.childWidgets.splice(index, 0, emptyCellWidget);
                        emptyCellWidget.containerWidget = currentRow;
                        this.updateChildLocationForRow(currentRow.y, currentRow);
                        return;
                        //}
                        //}
                    }
                }
                previousLeft += cellWidget.margin.left + cellWidget.width + cellWidget.margin.right;
            }
        }
    }
    /* eslint-disable-next-line max-len */
    getSplittedWidget(bottom, splitMinimalWidget, tableCollection, rowCollection, cellWidget) {
        let splittedWidget = undefined;
        if (cellWidget.y + cellWidget.height > bottom - (this.isInitialLoad ? this.footHeight : 0) - cellWidget.margin.bottom) {
            for (let i = 0; i < cellWidget.childWidgets.length; i++) {
                if (cellWidget.childWidgets[i] instanceof ParagraphWidget) {
                    const paragraphWidget = cellWidget.childWidgets[i];
                    const splittedPara = this.getSplittedWidgetForPara(bottom - cellWidget.margin.bottom, paragraphWidget);
                    if (!isNullOrUndefined(splittedPara)) {
                        if (i === 0 && splittedPara === paragraphWidget) {
                            //Returns if the whole content of the cell does not fit in current page.
                            return cellWidget;
                        }
                        if (cellWidget.childWidgets.indexOf(splittedPara) !== -1) {
                            cellWidget.childWidgets.splice(cellWidget.childWidgets.indexOf(splittedPara), 1);
                            i--;
                        }
                        cellWidget.height -= splittedPara.height;
                        if (isNullOrUndefined(splittedWidget)) {
                            //Creates new widget, to hold the splitted contents.
                            splittedWidget = this.createCellWidget(cellWidget);
                        }
                        splittedWidget.height += splittedPara.height;
                        splittedWidget.childWidgets.push(splittedPara);
                        splittedPara.containerWidget = splittedWidget;
                    }
                }
                else {
                    const tableWidget = cellWidget.childWidgets[i];
                    const tableCol = [tableWidget];
                    //Check for nested table.
                    if (bottom - cellWidget.margin.bottom < tableWidget.y + tableWidget.height) {
                        const tableHeight = tableWidget.height;
                        /* eslint-disable-next-line max-len */
                        let splittedTable = this.getSplittedWidgetForTable(bottom - cellWidget.margin.bottom, tableCol, tableWidget);
                        if (isNullOrUndefined(splittedTable) &&
                            !(tableWidget.childWidgets[0].rowFormat.allowBreakAcrossPages)) {
                            splittedTable = tableWidget;
                        }
                        if (!isNullOrUndefined(splittedTable)) {
                            if (i === 0 && splittedTable === tableWidget) {
                                //Returns if the whole table does not fit in current page.
                                return cellWidget;
                            }
                            if (cellWidget.childWidgets.indexOf(splittedTable) !== -1) {
                                cellWidget.childWidgets.splice(cellWidget.childWidgets.indexOf(splittedTable), 1);
                                i--;
                                cellWidget.height -= splittedTable.height;
                            }
                            else {
                                cellWidget.height -= tableHeight - tableWidget.height;
                            }
                            if (isNullOrUndefined(splittedWidget)) {
                                //Creates new widget, to hold the splitted contents.
                                splittedWidget = this.createCellWidget(cellWidget);
                            }
                            splittedWidget.height += splittedTable.height;
                            splittedWidget.childWidgets.push(splittedTable);
                            splittedTable.containerWidget = splittedWidget;
                        }
                    }
                }
            }
        }
        if (isNullOrUndefined(splittedWidget) && splitMinimalWidget && this.isRelayoutneed) {
            //Creates new widget, to hold the splitted contents.
            splittedWidget = this.createCellWidget(cellWidget);
        }
        return splittedWidget;
    }
    getListLevelPattern(value) {
        switch (value) {
            case 0:
                return 'Arabic';
            case 1:
                return 'LowLetter';
            case 2:
                return 'LowRoman';
            case 3:
                return 'UpLetter';
            case 4:
                return 'UpRoman';
            case 5:
                return 'Ordinal';
            case 6:
                return 'Number';
            case 7:
                return 'OrdinalText';
            case 8:
                return 'LeadingZero';
            case 9:
                return 'Bullet';
            case 10:
                return 'FarEast';
            case 11:
                return 'Special';
            default:
                return 'None';
        }
    }
    createCellWidget(cell) {
        const cellWidget = new TableCellWidget();
        cellWidget.cellFormat = cell.cellFormat;
        cellWidget.index = cell.index;
        cellWidget.rowIndex = cell.rowIndex;
        cellWidget.columnIndex = cell.columnIndex;
        cellWidget.containerWidget = cell.containerWidget;
        this.updateWidgetLocation(cell, cellWidget);
        cellWidget.margin = cell.margin;
        cellWidget.leftBorderWidth = cell.leftBorderWidth;
        cellWidget.rightBorderWidth = cell.rightBorderWidth;
        return cellWidget;
    }
    createTableWidget(table) {
        const newTable = new TableWidget();
        if (table.header) {
            newTable.header = table.header;
            newTable.headerHeight = table.headerHeight;
        }
        newTable.index = table.index;
        newTable.tableFormat = table.tableFormat;
        newTable.tableHolder = table.tableHolder;
        newTable.isGridUpdated = table.isGridUpdated;
        newTable.wrapTextAround = table.wrapTextAround;
        newTable.positioning = table.positioning;
        newTable.isContainInsideTable = table.isContainInsideTable;
        return newTable;
    }
    getSplittedWidgetForPara(bottom, paragraphWidget) {
        let lineBottom = paragraphWidget.y;
        let splittedWidget = undefined;
        let moveEntireBlock = false;
        for (let i = 0; i < paragraphWidget.childWidgets.length; i++) {
            let lineWidget = paragraphWidget.childWidgets[i];
            if (bottom < lineBottom + (this.isInitialLoad ? this.footHeight : 0) + lineWidget.height) {
                if (paragraphWidget.paragraphFormat.keepLinesTogether && (paragraphWidget.index !== 0 ||
                    (paragraphWidget.index === 0 && !isNullOrUndefined(paragraphWidget.associatedCell.ownerRow.previousWidget)))) {
                    moveEntireBlock = true;
                    i = 0;
                    lineWidget = paragraphWidget.childWidgets[0];
                }
                else if (paragraphWidget.paragraphFormat.widowControl) {
                    if (i === 1) {
                        moveEntireBlock = true;
                        i = 0;
                        lineWidget = paragraphWidget.childWidgets[0];
                    }
                }
                if (i === 0) {
                    if (lineWidget.paragraph.containerWidget instanceof TableCellWidget && !moveEntireBlock) {
                        //checks first line of the page is exceed the page height
                        if (lineWidget.paragraph.containerWidget.y === paragraphWidget.y) {
                            lineBottom += lineWidget.height;
                            continue;
                        }
                    }
                    splittedWidget = paragraphWidget;
                    break;
                }
                if (paragraphWidget.childWidgets.indexOf(lineWidget) !== -1) {
                    paragraphWidget.childWidgets.splice(paragraphWidget.childWidgets.indexOf(lineWidget), 1);
                    i--;
                }
                paragraphWidget.height -= lineWidget.height;
                if (isNullOrUndefined(splittedWidget)) {
                    //Creates new widget, to hold the splitted contents.
                    splittedWidget = new ParagraphWidget();
                    splittedWidget.characterFormat = paragraphWidget.characterFormat;
                    splittedWidget.paragraphFormat = paragraphWidget.paragraphFormat;
                    splittedWidget.index = paragraphWidget.index;
                    this.updateWidgetLocation(paragraphWidget, splittedWidget);
                    splittedWidget.height = lineWidget.height;
                }
                else {
                    splittedWidget.height += lineWidget.height;
                }
                splittedWidget.childWidgets.push(lineWidget);
                lineWidget.paragraph = splittedWidget;
            }
            lineBottom += lineWidget.height;
        }
        return splittedWidget;
    }
    getSplittedWidgetForTable(bottom, tableCollection, tableWidget) {
        let rowBottom = tableWidget.y;
        let splittedWidget = undefined;
        for (let i = 0; i < tableWidget.childWidgets.length; i++) {
            let rowWidget = undefined;
            const childWidget = tableWidget.childWidgets[i];
            // if (childWidget instanceof TableRowWidget) {
            rowWidget = childWidget;
            // }
            const rowHeight = rowWidget.height;
            if (bottom < rowBottom + rowHeight || !isNullOrUndefined(splittedWidget)) {
                //ToDo: Check whether row included in vertical merge or AllowRowSplitbyPage is true, if so split row.
                //Checks if atleast first line fits in the client area.
                let splittedRow = undefined;
                let allowRowBreakAcrossPages = true;
                if (!isNullOrUndefined(rowWidget) && !isNullOrUndefined(rowWidget.rowFormat)) {
                    allowRowBreakAcrossPages = rowWidget.rowFormat.allowBreakAcrossPages;
                }
                if (allowRowBreakAcrossPages) {
                    /* eslint-disable-next-line max-len */
                    splittedRow = (isNullOrUndefined(splittedWidget) && this.isFirstLineFitForRow(bottom, rowWidget)) ? this.getSplittedWidgetForRow(bottom, tableCollection, [rowWidget], rowWidget) : rowWidget;
                }
                else {
                    if ((isNullOrUndefined(tableWidget.containerWidget.containerWidget.previousWidget)
                        && this.isFirstLineFitForRow(bottom, rowWidget))
                        || (tableWidget.isInsideTable
                            && !(tableWidget.containerWidget.containerWidget.rowFormat.allowBreakAcrossPages))) {
                        splittedRow = this.getSplittedWidgetForRow(bottom, tableCollection, [rowWidget], rowWidget);
                    }
                    else if (!isNullOrUndefined(tableWidget.containerWidget.containerWidget.previousWidget)) {
                        splittedRow = rowWidget;
                    }
                }
                if (!isNullOrUndefined(splittedRow)) {
                    if (i === 0 && splittedRow === rowWidget) {
                        //Returns if the whole table does not fit in current page.
                        return tableWidget;
                    }
                    if (tableWidget.childWidgets.indexOf(splittedRow) !== -1) {
                        tableWidget.childWidgets.splice(tableWidget.childWidgets.indexOf(splittedRow), 1);
                        i--;
                        tableWidget.height -= splittedRow.height;
                    }
                    else {
                        tableWidget.height -= rowHeight - rowWidget.height;
                    }
                    if (isNullOrUndefined(splittedWidget)) {
                        //Creates new widget, to hold the splitted contents.
                        splittedWidget = this.createTableWidget(tableWidget);
                        this.updateWidgetLocation(tableWidget, splittedWidget);
                        splittedWidget.height = splittedRow.height;
                    }
                    else {
                        splittedWidget.height += splittedRow.height;
                    }
                    splittedWidget.childWidgets.push(splittedRow);
                    splittedRow.containerWidget = splittedWidget;
                }
            }
            rowBottom += rowWidget.height;
        }
        return splittedWidget;
    }
    isFirstLineFitForPara(bottom, paraWidget) {
        const lineWidget = paraWidget.childWidgets[0];
        let lineHeight = lineWidget.height;
        if (paraWidget.paragraphFormat.keepLinesTogether) {
            lineHeight = paraWidget.height;
        }
        const cellwidget = lineWidget.paragraph.containerWidget;
        // let document: WordDocument = undefined;
        // if (!isNullOrUndefined(lineWidget.paragraph.currentNode) && !isNullOrUndefined(cellwidget.containerWidget)) {
        //     document = WordDocument.getDocumentOf(lineWidget.paragraph.currentNode);
        // }
        //checks first line of the page is exceed the page height
        if (this.documentHelper.isFirstLineFitInShiftWidgets) {
            /* eslint-disable-next-line max-len */
            if (this.viewer.clientActiveArea.y === this.viewer.clientArea.y && paraWidget.y + lineHeight + this.footHeight >= bottom) {
                return true;
            }
        }
        else {
            // For nested tables,
            if (cellwidget.ownerTable.isInsideTable) {
                // Gets the container cell widgets, consider it as client area for the cell widget.
                let containerCellWidget = undefined;
                if (cellwidget.containerWidget instanceof TableRowWidget &&
                    cellwidget.containerWidget.containerWidget instanceof TableWidget
                    && cellwidget.containerWidget.containerWidget.containerWidget instanceof TableCellWidget) {
                    containerCellWidget = cellwidget.containerWidget.containerWidget.containerWidget;
                }
                if (!isNullOrUndefined(containerCellWidget) && cellwidget.containerWidget.y === containerCellWidget.y
                    && paraWidget.y + lineHeight + this.footHeight >= bottom) {
                    return true;
                }
                /* eslint-disable-next-line max-len */
            }
            else if (cellwidget.containerWidget.y === this.viewer.clientArea.y && paraWidget.y + lineHeight + this.footHeight >= bottom) {
                return true;
            }
        }
        return (paraWidget.y + lineHeight + this.footHeight <= bottom);
    }
    isFirstLineFitForTable(bottom, tableWidget) {
        let rowWidget = undefined;
        let isFit = false;
        const childWidget = tableWidget.childWidgets[0];
        // if (childWidget instanceof TableRowWidget) {
        rowWidget = childWidget;
        // }
        if (!isNullOrUndefined(rowWidget)) {
            isFit = this.isFirstLineFitForRow(bottom, rowWidget);
        }
        return isFit;
    }
    isFirstLineFitForRow(bottom, rowWidget) {
        for (let i = 0; i < rowWidget.childWidgets.length; i++) {
            const cellWidget = rowWidget.childWidgets[i];
            if (!this.isFirstLineFitForCell(bottom, cellWidget)) {
                return false;
            }
        }
        return true;
    }
    isFirstLineFitForCell(bottom, cellWidget) {
        if (cellWidget.childWidgets.length === 0) {
            return true;
        }
        if (cellWidget.childWidgets[0] instanceof ParagraphWidget) {
            const paraWidget = cellWidget.childWidgets[0];
            return this.isFirstLineFitForPara(bottom - cellWidget.margin.bottom, paraWidget);
        }
        else {
            const tableWidget = cellWidget.childWidgets[0];
            return this.isFirstLineFitForTable(bottom - cellWidget.margin.bottom, tableWidget);
        }
    }
    updateWidgetLocation(widget, table) {
        table.x = widget.x;
        table.y = widget.y;
        table.width = widget.width;
    }
    updateChildLocationForTable(top, tableWidget) {
        for (let i = 0; i < tableWidget.childWidgets.length; i++) {
            const rowWidget = tableWidget.childWidgets[i];
            //rowWidget.x = rowWidget.x;
            rowWidget.y = top;
            this.updateChildLocationForRow(top, rowWidget);
            top += rowWidget.height;
        }
    }
    updateChildLocationForRow(top, rowWidget) {
        let spacing = 0;
        if (rowWidget.ownerTable.tableFormat.cellSpacing > 0) {
            spacing = HelperMethods.convertPointToPixel(rowWidget.ownerTable.tableFormat.cellSpacing);
        }
        for (let i = 0; i < rowWidget.childWidgets.length; i++) {
            const cellWidget = rowWidget.childWidgets[i];
            //cellWidget.x = cellWidget.x;
            cellWidget.index = cellWidget.cellIndex;
            cellWidget.y = top + cellWidget.margin.top + spacing;
            this.updateChildLocationForCellOrShape(cellWidget.y, cellWidget);
        }
    }
    updateChildLocationForCellOrShape(top, widget) {
        let container = widget;
        if (widget instanceof ShapeElementBox) {
            container = widget.textFrame;
        }
        for (let i = 0; i < container.childWidgets.length; i++) {
            let skipHeight = false;
            if (container.childWidgets[i] instanceof TableWidget && container.childWidgets[i].wrapTextAround
                && !isNullOrUndefined(container.childWidgets[i + 1]) && container.childWidgets[i + 1].y > container.childWidgets[i].y
                && container.childWidgets[i + 1].y < (container.childWidgets[i].y + container.childWidgets[i].height)) {
                skipHeight = true;
            }
            container.childWidgets[i].x = container.childWidgets[i].x;
            container.childWidgets[i].y = top;
            if (container.childWidgets[i] instanceof TableWidget) {
                this.updateChildLocationForTable(top, container.childWidgets[i]);
            }
            if (container.childWidgets[i] instanceof ParagraphWidget) {
                const para = container.childWidgets[i];
                for (let i = 0; i < para.childWidgets.length; i++) {
                    const line = para.childWidgets[0];
                    for (let k = 0; k < line.children.length; k++) {
                        const element = line.children[k];
                        if (element instanceof FootnoteElementBox) {
                            if (!isNullOrUndefined(para.bodyWidget.page.footnoteWidget)) {
                                return;
                            }
                            else {
                                const prevWidget = para.bodyWidget.previousRenderedWidget;
                                const prevBodyWidget = para.bodyWidget.previousRenderedWidget;
                                const newBodyWidget = para.bodyWidget;
                                const footWidgets = this.getFootNoteWidgetsOf(para);
                                // this.updateContainerWidget(curretBlock as Widget, newBodyWidget, prevWidget.indexInOwner + 1, false);
                                this.moveFootNotesToPage(footWidgets, prevBodyWidget, newBodyWidget);
                                this.layoutfootNote(para.bodyWidget.page.footnoteWidget);
                            }
                        }
                    }
                }
            }
            if (!skipHeight) {
                top += container.childWidgets[i].height;
            }
        }
    }
    updateCellVerticalPosition(cellWidget, isUpdateToTop, isInsideTable) {
        const containerWidget = cellWidget.ownerTable.containerWidget;
        if (containerWidget instanceof BlockContainer || containerWidget instanceof TextFrame || isInsideTable) {
            const displacement = this.getDisplacement(cellWidget, isUpdateToTop);
            //Update Y position alone for the child widget of cell
            this.updateCellContentVerticalPosition(cellWidget, displacement, isUpdateToTop);
        }
    }
    updateCellContentVerticalPosition(cellWidget, displacement, isUpdateToTop) {
        if (displacement === 0) {
            return;
        }
        let location = cellWidget.y + displacement;
        for (let i = 0; i < cellWidget.childWidgets.length; i++) {
            if (cellWidget.childWidgets[i] instanceof ParagraphWidget) {
                const para = cellWidget.childWidgets[i];
                para.y = location;
                this.updateShapeInsideCell(para, displacement);
            }
            else {
                this.updateTableWidgetLocation(cellWidget.childWidgets[i], location, isUpdateToTop);
            }
            location = location + cellWidget.childWidgets[i].height;
        }
    }
    updateShapeInsideCell(paragraph, displacement) {
        for (let i = 0; i < paragraph.floatingElements.length; i++) {
            const floatElement = paragraph.floatingElements[i];
            floatElement.y += displacement;
            if (floatElement instanceof ShapeElementBox) {
                this.updateChildLocationForCellOrShape(floatElement.y, floatElement);
            }
        }
    }
    updateTableWidgetLocation(tableWidget, location, isUpdateToTop) {
        tableWidget.y = location = location + tableWidget.topBorderWidth;
        const cellSpacing = 0;
        for (let i = 0; i < tableWidget.childWidgets.length; i++) {
            const rowWidget = tableWidget.childWidgets[i];
            rowWidget.y = location;
            for (let j = 0; j < rowWidget.childWidgets.length; j++) {
                const cellWidget = rowWidget.childWidgets[j];
                cellWidget.y = location + cellWidget.margin.top + cellSpacing;
                this.updateCellVerticalPosition(cellWidget, isUpdateToTop, true);
            }
            location = location + rowWidget.height;
        }
        return location;
    }
    getDisplacement(cellWidget, isUpdateToTop) {
        //Gets the height of row
        let rowHeight = 0;
        const rowWidget = cellWidget.containerWidget;
        const padding = cellWidget.margin.top + cellWidget.margin.bottom;
        if (!isNullOrUndefined(cellWidget.cellFormat) && cellWidget.cellFormat.rowSpan > 1) {
            rowHeight = cellWidget.height;
        }
        else {
            rowHeight = ((!isNullOrUndefined(rowWidget) ? rowWidget.height : 0) - padding);
        }
        //Gets the height of content within the cell
        const cellContentHeight = this.getCellContentHeight(cellWidget, true);
        //Displacement field holds the value which has reduced from rowHeight and cellContentHeight
        let displacement = 0;
        if (rowHeight > cellContentHeight) {
            displacement = rowHeight - cellContentHeight;
            if (cellWidget.cellFormat.verticalAlignment === 'Center') {
                displacement = displacement / 2;
            }
            else if ((cellWidget.cellFormat.verticalAlignment === 'Top' || isUpdateToTop)) {
                displacement = 0;
            }
        }
        return displacement;
    }
    getCellContentHeight(cellWidget, isDisplacement) {
        if (isNullOrUndefined(cellWidget.childWidgets)) {
            return 0;
        }
        let contentHeight = 0;
        const cellY = cellWidget.y;
        let withShapeContentHeight = 0;
        let withShapeBottom = 0;
        let considerShapeHeight = false;
        let considerAsTop = false;
        for (let i = 0; i < cellWidget.childWidgets.length; i++) {
            if (cellWidget.childWidgets[i] instanceof ParagraphWidget) {
                const para = cellWidget.childWidgets[i];
                contentHeight += cellWidget.childWidgets[i].height;
                for (let k = 0; k < para.floatingElements.length; k++) {
                    considerShapeHeight = true;
                    const floatElement = para.floatingElements[k];
                    if ((cellWidget.y + cellWidget.containerWidget.height) > (floatElement.y + floatElement.height)
                        && (floatElement.y + floatElement.height) > withShapeBottom) {
                        withShapeContentHeight = Math.abs(cellY - (floatElement.y + floatElement.height));
                        withShapeBottom = floatElement.y + floatElement.height;
                        considerAsTop = false;
                    }
                    else {
                        considerAsTop = true;
                    }
                }
            }
            else {
                if (this.considerPositionTableHeight(cellWidget, cellWidget.childWidgets[i])) {
                    contentHeight += cellWidget.childWidgets[i].height;
                }
            }
        }
        if ((cellY + contentHeight) > withShapeBottom) {
            considerShapeHeight = false;
        }
        return (isDisplacement && considerShapeHeight) ? withShapeContentHeight :
            (isDisplacement && considerAsTop ? cellWidget.ownerRow.height : contentHeight);
    }
    considerPositionTableHeight(cellWidget, nestedWrapTable) {
        if (nestedWrapTable.isLayouted && nestedWrapTable.wrapTextAround) {
            let wrapTableBottom = nestedWrapTable.y + nestedWrapTable.height;
            for (let i = 0; i < cellWidget.childWidgets.length; i++) {
                if ((cellWidget.childWidgets[i].y + cellWidget.childWidgets[i].height) > wrapTableBottom) {
                    return false;
                }
            }
        }
        return true;
    }
    getTableLeftBorder(borders) {
        if (!isNullOrUndefined(borders.left)) {
            return borders.left;
        }
        else {
            const border = new WBorder(borders);
            border.lineStyle = 'Single';
            border.lineWidth = 0.66;
            return border;
        }
    }
    getTableRightBorder(borders) {
        if (!isNullOrUndefined(borders.right)) {
            return borders.right;
        }
        else {
            const border = new WBorder(borders);
            border.lineStyle = 'Single';
            border.lineWidth = 0.66;
            return border;
        }
    }
    getTableTopBorder(borders) {
        if (!isNullOrUndefined(borders.top)) {
            return borders.top;
        }
        else {
            const border = new WBorder(borders);
            border.lineStyle = 'Single';
            border.lineWidth = 0.66;
            return border;
        }
    }
    getTableBottomBorder(borders) {
        if (!isNullOrUndefined(borders.bottom)) {
            return borders.bottom;
        }
        else {
            const border = new WBorder(borders);
            border.lineStyle = 'Single';
            border.lineWidth = 0.66;
            return border;
        }
    }
    getCellDiagonalUpBorder(tableCell) {
        let diagonalUpBorder = undefined;
        let cellBorder = undefined;
        cellBorder = tableCell.cellFormat.borders;
        diagonalUpBorder = cellBorder.diagonalUp;
        return diagonalUpBorder;
    }
    getCellDiagonalDownBorder(tableCell) {
        let diagonalDownBorder = undefined;
        let cellBorder = undefined;
        cellBorder = tableCell.cellFormat.borders;
        diagonalDownBorder = cellBorder.diagonalDown;
        return diagonalDownBorder;
    }
    getTableWidth(table) {
        let width = 0;
        for (let i = 0; i < table.childWidgets.length; i++) {
            const row = table.childWidgets[i];
            let rowWidth = 0;
            for (let j = 0; j < row.childWidgets.length; j++) {
                const cell = row.childWidgets[j];
                rowWidth += HelperMethods.convertPointToPixel(cell.cellFormat.cellWidth);
            }
            if (width < rowWidth) {
                width = rowWidth;
            }
        }
        return width;
    }
    //#region shifting
    layoutNextItemsBlock(blockAdv, viewer, isFootnoteReLayout) {
        const sectionIndex = blockAdv.bodyWidget.sectionIndex;
        let block = blockAdv;
        let splittedWidget = block.getSplitWidgets();
        let nextBlock = splittedWidget[splittedWidget.length - 1].nextRenderedWidget;
        if (isNullOrUndefined(nextBlock) || this.documentHelper.blockToShift === block) {
            this.documentHelper.blockToShift = undefined;
        }
        let updateNextBlockList = true;
        while (nextBlock instanceof BlockWidget && nextBlock.bodyWidget.sectionIndex === sectionIndex) {
            if (!isNullOrUndefined(isFootnoteReLayout) && isFootnoteReLayout && !nextBlock.isLayouted && this.isInitialLoad) {
                break;
            }
            let currentWidget = undefined;
            const blocks = block.getSplitWidgets();
            currentWidget = blocks[blocks.length - 1];
            // if (viewer.fieldEndParagraph === block) {
            //     //Sets field end paragraph to undefined, inorder to hold reLayouting with this paragraph.
            //     viewer.fieldEndParagraph = undefined;
            // }
            block = nextBlock;
            if (this.documentHelper.blockToShift === block) {
                this.documentHelper.blockToShift = undefined;
            }
            updateNextBlockList = false;
            let nextWidget = undefined;
            nextWidget = block.getSplitWidgets()[0];
            /* eslint-disable-next-line max-len */
            if (this.documentHelper.fieldStacks.length === 0 && !isNullOrUndefined(nextWidget) && currentWidget.containerWidget === nextWidget.containerWidget
                && (HelperMethods.round(nextWidget.y, 2) === HelperMethods.round(currentWidget.y + currentWidget.height, 2))) {
                if (!isNullOrUndefined(this.documentHelper.blockToShift)) {
                    this.documentHelper.blockToShift = block;
                }
                else if (nextWidget.bodyWidget) {
                    const floatingElementLength = nextWidget.bodyWidget.floatingElements.length;
                    if (floatingElementLength > 0) {
                        this.documentHelper.blockToShift = block;
                    }
                }
                break;
            }
            updateNextBlockList = true;
            if (viewer.owner.isShiftingEnabled && this.documentHelper.fieldStacks.length === 0) {
                this.documentHelper.blockToShift = block;
                break;
            }
            else if (isNullOrUndefined(this.viewer.owner.editorModule) || !this.viewer.owner.editorModule.isInsertingTOC) {
                block = block.combineWidget(this.viewer);
                //let paragraph: ParagraphWidget;
                if (currentWidget.containerWidget !== block.containerWidget) {
                    if (!(currentWidget instanceof ParagraphWidget) ||
                        (currentWidget instanceof ParagraphWidget) && !currentWidget.isEndsWithPageBreak) {
                        /* eslint-disable-next-line max-len */
                        this.updateContainerWidget(block, currentWidget.containerWidget, currentWidget.indexInOwner + 1, false);
                    }
                }
                if (block instanceof TableWidget) {
                    this.clearTableWidget(block, true, true);
                    block.isGridUpdated = false;
                    //paragraph = this.documentHelper.selection.getFirstParagraphInFirstCell(block as TableWidget);
                }
                else {
                    //paragraph = block as ParagraphWidget;
                }
                //if ((this.viewer.owner.isDocumentLoaded) && this.viewer.owner.editorModule) {
                //    this.viewer.owner.editorModule.updateWholeListItems(paragraph);
                //}
                viewer.updateClientAreaForBlock(block, true);
                if (this.viewer instanceof WebLayoutViewer || block.bodyWidget instanceof HeaderFooterWidget) {
                    block.containerWidget.height -= block.height;
                }
                this.documentHelper.layout.layoutBlock(block, 0);
                viewer.updateClientAreaForBlock(block, false);
            }
            splittedWidget = nextBlock.getSplitWidgets();
            nextBlock = splittedWidget[splittedWidget.length - 1].nextRenderedWidget;
        }
        if (!viewer.owner.isShiftingEnabled || (this.documentHelper.blockToShift !== block)) {
            this.viewer.owner.editorModule.updateListItemsTillEnd(block, updateNextBlockList);
        }
    }
    /**
     * Update the client area for the line widget.
     *
     * @param {LineWidget} startLineWidget LineWidget instance.
     * @private
     */
    updateClientAreaForLine(startLineWidget) {
        startLineWidget.marginTop = 0;
        //Clears the line widget starting from current line.
        const top = this.documentHelper.selection.getTop(startLineWidget);
        const left = this.viewer.clientArea.x;
        this.viewer.cutFromTop(top);
        this.viewer.cutFromLeft(left);
    }
    getParentTable(block) {
        let widget = block;
        while (widget.containerWidget) {
            if (widget.containerWidget instanceof BlockContainer || widget.containerWidget instanceof TextFrame) {
                return widget;
            }
            widget = widget.containerWidget;
        }
        return undefined;
    }
    /* eslint-disable-next-line max-len */
    reLayoutParagraph(paragraphWidget, lineIndex, elementBoxIndex, isBidi, isSkip) {
        this.isRelayout = true;
        if (paragraphWidget.containerWidget instanceof TextFrame
            && paragraphWidget.containerWidget.containerShape.textWrappingStyle === 'Inline') {
            lineIndex = paragraphWidget.containerWidget.containerShape.line.indexInOwner;
            paragraphWidget = paragraphWidget.containerWidget.containerShape.paragraph;
        }
        isBidi = isNullOrUndefined(isBidi) ? false : isBidi;
        this.isRelayout = true;
        if (this.documentHelper.blockToShift === paragraphWidget) {
            this.layoutBodyWidgetCollection(paragraphWidget.index, paragraphWidget.containerWidget, paragraphWidget, false);
            this.isBidiReLayout = true;
        }
        else {
            if (this.isBidiReLayout) {
                this.isBidiReLayout = false;
            }
        }
        // let isElementMoved: boolean = elementBoxIndex > 0;
        if (paragraphWidget.isInsideTable) {
            this.isBidiReLayout = true;
            this.reLayoutTable(paragraphWidget);
            /* eslint-disable-next-line max-len */
            if (this.isFootnoteContentChanged && (!isNullOrUndefined(paragraphWidget.bodyWidget)) && !isNullOrUndefined(paragraphWidget.bodyWidget.page.footnoteWidget)) {
                const foot = paragraphWidget.bodyWidget.page.footnoteWidget;
                this.layoutfootNote(foot);
            }
            this.isBidiReLayout = false;
        }
        else {
            // this.isRelayout = true;
            this.reLayoutLine(paragraphWidget, lineIndex, isBidi, isSkip);
        }
        if (paragraphWidget.bodyWidget instanceof HeaderFooterWidget &&
            paragraphWidget.bodyWidget.headerFooterType.indexOf('Footer') !== -1) {
            this.shiftFooterChildLocation(paragraphWidget.bodyWidget, this.viewer);
        }
    }
    getParentRow(block) {
        let cell = block;
        while (cell.ownerTable !== null && cell.ownerTable.isInsideTable) {
            cell = cell.ownerTable.associatedCell;
        }
        return cell.ownerRow;
    }
    reLayoutRow(block) {
        if (block instanceof ParagraphWidget) {
            block = block.associatedCell;
        }
        const currentRow = this.getParentRow(block).getSplitWidgets()[0];
        if (!isNullOrUndefined(currentRow) && !currentRow.ownerTable.tableFormat.allowAutoFit) {
            const currentTable = currentRow.ownerTable.getSplitWidgets()[0].combineWidget(this.viewer);
            let startRow = currentRow;
            while (this.isVerticalMergedCellContinue(startRow)) {
                const previousRow = startRow.previousWidget;
                if (isNullOrUndefined(previousRow)) {
                    break;
                }
                startRow = previousRow;
            }
            const bodyWidget = currentTable.containerWidget;
            if (this.viewer instanceof WebLayoutViewer) {
                bodyWidget.height -= currentTable.height;
            }
            if ((this.viewer.owner.enableHeaderAndFooter || block.isInHeaderFooter) && !(bodyWidget instanceof TextFrame)) {
                block.bodyWidget.isEmpty = false;
                bodyWidget.height -= currentTable.height;
                /* eslint-disable-next-line max-len */
                this.viewer.updateHeaderFooterClientAreaWithTop(currentTable.bodyWidget.sectionFormat, this.documentHelper.isBlockInHeader(currentTable), bodyWidget.page);
            }
            else if (bodyWidget instanceof TextFrame) {
                this.viewer.updateClientAreaForTextBoxShape(bodyWidget.containerShape, true);
            }
            else {
                this.viewer.updateClientArea(bodyWidget.sectionFormat, bodyWidget.page);
            }
            /* eslint-disable-next-line max-len */
            const area = new Rect(this.viewer.clientArea.x, this.viewer.clientArea.y, this.viewer.clientArea.width, this.viewer.clientArea.height);
            const clientArea = new Rect(area.x, area.y, area.width, area.height);
            if (this.viewer.owner.isDocumentLoaded && this.viewer.owner.editorModule) {
                const block = this.documentHelper.selection.getFirstParagraphInFirstCell(currentTable);
                this.viewer.owner.editorModule.updateWholeListItems(block);
            }
            this.viewer.updateClientAreaForBlock(currentTable, true);
            this.viewer.cutFromTop(startRow.y);
            this.viewer.clientActiveArea.height = Number.POSITIVE_INFINITY;
            //Clear Hieght for all the content
            currentTable.height = 0;
            do {
                this.clearRowWidget(currentRow, true, true, true);
                this.layoutRow([currentTable], currentRow, true);
                if (startRow === currentRow) {
                    break;
                }
                startRow = startRow.nextRow;
            } while (startRow && startRow !== currentRow);
            this.updateChildLocationForTable(currentTable.y, currentTable);
            this.viewer.clientArea = clientArea;
            this.viewer.clientActiveArea = new Rect(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            this.viewer.updateClientAreaForBlock(currentTable, true);
            currentTable.x -= currentTable.leftBorderWidth;
            currentTable.y -= currentTable.topBorderWidth;
            this.viewer.cutFromTop(currentTable.y);
            this.shiftTableWidget(currentTable, this.viewer, true);
            this.layoutNextItemsBlock(currentTable, this.viewer);
        }
        else {
            this.currentCell = block;
            this.reLayoutTable(block);
            this.currentCell = undefined;
        }
    }
    reLayoutTable(block, isFootnoteReLayout) {
        //Get Top level owner of block
        const table = this.getParentTable(block);
        //Combine splitted table in to single table
        const currentTable = table.combineWidget(this.viewer);
        const bodyWidget = currentTable.containerWidget;
        if (this.viewer instanceof WebLayoutViewer) {
            bodyWidget.height -= currentTable.height;
        }
        if ((this.viewer.owner.enableHeaderAndFooter || block.isInHeaderFooter) && !(bodyWidget instanceof TextFrame)) {
            block.bodyWidget.isEmpty = false;
            bodyWidget.height -= currentTable.height;
            /* eslint-disable-next-line max-len */
            this.viewer.updateHeaderFooterClientAreaWithTop(table.bodyWidget.sectionFormat, this.documentHelper.isBlockInHeader(table), bodyWidget.page);
        }
        else if (bodyWidget instanceof TextFrame) {
            this.viewer.updateClientAreaForTextBoxShape(bodyWidget.containerShape, true);
        }
        else {
            this.viewer.updateClientArea(bodyWidget.sectionFormat, bodyWidget.page);
        }
        //Clear Hieght for all the content
        if (this.viewer.owner.isDocumentLoaded && this.viewer.owner.editorModule) {
            const block = this.documentHelper.selection.getFirstParagraphInFirstCell(currentTable);
            this.viewer.owner.editorModule.updateWholeListItems(block);
        }
        this.viewer.updateClientAreaForBlock(currentTable, true);
        //Remove border width
        currentTable.x -= currentTable.leftBorderWidth;
        currentTable.y -= currentTable.topBorderWidth;
        //Update Client area for current position
        let yPos = this.getYPosition(currentTable);
        this.viewer.cutFromTop(yPos);
        this.clearTableWidget(currentTable, true, true, true);
        this.isBidiReLayout = true;
        this.layoutBlock(currentTable, 0);
        this.viewer.updateClientAreaForBlock(currentTable, false);
        this.layoutNextItemsBlock(currentTable, this.viewer, isFootnoteReLayout);
    }
    getYPosition(table) {
        if (table.wrapTextAround) {
            let prevWidget = table.previousWidget;
            while (prevWidget) {
                if (prevWidget instanceof ParagraphWidget) {
                    return prevWidget.y + prevWidget.height;
                }
                else if (prevWidget instanceof TableWidget) {
                    if (prevWidget.wrapTextAround) {
                        prevWidget = prevWidget.previousWidget;
                    }
                    else {
                        return prevWidget.y + prevWidget.height;
                    }
                }
            }
            return this.viewer.clientActiveArea.y;
        }
        return table.y;
    }
    /**
     * @private
     */
    clearTableWidget(table, clearPosition, clearHeight, clearGrid) {
        table.height = 0;
        if (clearGrid) {
            table.isGridUpdated = false;
        }
        if (clearPosition) {
            table.y = 0;
            table.x = 0;
        }
        for (let i = 0; i < table.childWidgets.length; i++) {
            const row = table.childWidgets[i];
            this.clearRowWidget(row, clearPosition, clearHeight, clearGrid);
        }
    }
    /**
     * @private
     */
    clearRowWidget(row, clearPosition, clearHeight, clearGrid) {
        row.height = 0;
        if (clearPosition) {
            row.y = 0;
            row.x = 0;
        }
        for (let i = 0; i < row.childWidgets.length; i++) {
            const cell = row.childWidgets[i];
            this.clearCellWidget(cell, clearPosition, clearHeight, clearGrid);
        }
    }
    /**
     * @private
     */
    clearCellWidget(cell, clearPosition, clearHeight, clearGrid) {
        cell.height = 0;
        if (clearPosition) {
            cell.y = 0;
            cell.x = 0;
        }
        this.clearBlockWidget(cell.childWidgets, clearPosition, clearHeight, clearGrid);
    }
    /**
     * @private
     */
    clearBlockWidget(blocks, clearPosition, clearHeight, clearGrid) {
        for (let i = 0; i < blocks.length; i++) {
            const block = blocks[i];
            if (block instanceof ParagraphWidget) {
                if (clearPosition) {
                    block.y = 0;
                    block.x = 0;
                }
                if (clearHeight) {
                    block.height = 0;
                }
            }
            else {
                this.clearTableWidget(block, clearPosition, clearHeight, clearGrid);
            }
        }
    }
    /* eslint-disable-next-line max-len */
    layoutBodyWidgetCollection(blockIndex, bodyWidget, block, shiftNextWidget, isSkipShifting) {
        if (!isNullOrUndefined(this.documentHelper.owner)
            && this.documentHelper.owner.isLayoutEnabled) {
            if (bodyWidget instanceof BlockContainer || bodyWidget instanceof TextFrame) {
                let curretBlock = this.checkAndGetBlock(bodyWidget, blockIndex);
                if (isNullOrUndefined(curretBlock)) {
                    return;
                }
                if (this.viewer instanceof WebLayoutViewer) {
                    curretBlock.containerWidget.height -= curretBlock.height;
                }
                if (bodyWidget instanceof HeaderFooterWidget) {
                    bodyWidget.isEmpty = false;
                    this.viewer.updateHeaderFooterClientAreaWithTop(bodyWidget.sectionFormat, bodyWidget.headerFooterType.indexOf('Header') !== -1, bodyWidget.page);
                    curretBlock.containerWidget.height -= curretBlock.height;
                }
                else if (bodyWidget instanceof TextFrame) {
                    this.viewer.updateClientAreaForTextBoxShape(bodyWidget.containerShape, true);
                }
                else if (!isNullOrUndefined(bodyWidget.containerWidget) && bodyWidget.containerWidget instanceof FootNoteWidget) {
                    this.viewer.updateClientArea(bodyWidget.sectionFormat, bodyWidget.page, true);
                    if (bodyWidget.containerWidget.footNoteType === 'Footnote') {
                        this.isRelayoutFootnote = true;
                        this.viewer.clientArea.height = Number.POSITIVE_INFINITY;
                        this.viewer.clientActiveArea.height = Number.POSITIVE_INFINITY;
                        //curretBlock.containerWidget.height -= curretBlock.height;
                        this.viewer.clientActiveArea.y = curretBlock.containerWidget.containerWidget.y;
                    }
                    else {
                        this.viewer.cutFromTop(bodyWidget.containerWidget.y);
                        this.layoutfootNote(bodyWidget.containerWidget);
                        return;
                    }
                    // curretBlock.containerWidget.height -= curretBlock.height;
                }
                else {
                    if (!isNullOrUndefined(bodyWidget.page.footnoteWidget)) {
                        if (bodyWidget.page.footnoteWidget.footNoteType === 'Footnote') {
                            this.viewer.updateClientArea(bodyWidget.sectionFormat, bodyWidget.page, true);
                        }
                        else {
                            this.viewer.updateClientArea(bodyWidget.sectionFormat, bodyWidget.page, true);
                        }
                    }
                    else {
                        this.viewer.updateClientArea(bodyWidget.sectionFormat, bodyWidget.page, true);
                    }
                    // if (bodyWidget.page.footnoteWidget) {
                    //     this.viewer.clientActiveArea.height -= bodyWidget.page.footnoteWidget.height;
                    //     this.viewer.clientArea.height -= bodyWidget.page.footnoteWidget.height;
                    // }
                }
                if (blockIndex > 0) {
                    const prevWidget = curretBlock.getSplitWidgets()[0].previousRenderedWidget;
                    if (!(prevWidget instanceof ParagraphWidget) ||
                        (prevWidget instanceof ParagraphWidget) && !prevWidget.isEndsWithPageBreak) {
                        this.viewer.cutFromTop(prevWidget.y + prevWidget.height);
                        if (isNullOrUndefined(isSkipShifting) && curretBlock.containerWidget !== prevWidget.containerWidget) {
                            /* eslint-disable-next-line max-len */
                            const prevBodyWidget = curretBlock.containerWidget;
                            const newBodyWidget = prevWidget.containerWidget;
                            const footWidgets = this.getFootNoteWidgetsOf(curretBlock);
                            this.updateContainerWidget(curretBlock, newBodyWidget, prevWidget.indexInOwner + 1, false);
                            this.moveFootNotesToPage(footWidgets, prevBodyWidget, newBodyWidget);
                        }
                    }
                    else if (prevWidget instanceof ParagraphWidget && prevWidget.isEndsWithPageBreak &&
                        prevWidget.containerWidget === curretBlock.containerWidget) {
                        this.moveBlocksToNextPage(prevWidget, false);
                    }
                }
                let currentParagraph;
                curretBlock = curretBlock.combineWidget(this.viewer);
                if (curretBlock instanceof TableWidget) {
                    this.clearTableWidget(curretBlock, true, true);
                    curretBlock.isGridUpdated = false;
                    currentParagraph = this.documentHelper.selection.getFirstParagraphInFirstCell(curretBlock);
                }
                else {
                    currentParagraph = curretBlock;
                }
                if ((this.viewer.owner.isDocumentLoaded) && this.viewer.owner.editorModule) {
                    this.viewer.owner.editorModule.updateWholeListItems(currentParagraph);
                }
                this.viewer.updateClientAreaForBlock(curretBlock, true);
                this.documentHelper.layout.layoutBlock(curretBlock, 0);
                this.viewer.updateClientAreaForBlock(curretBlock, false);
                if (!isNullOrUndefined(bodyWidget.containerWidget) && bodyWidget.containerWidget instanceof FootNoteWidget) {
                    if (bodyWidget.containerWidget.footNoteType === 'Footnote') {
                        this.layoutfootNote(bodyWidget.containerWidget);
                    }
                }
                if (shiftNextWidget) {
                    this.shiftNextWidgets(curretBlock);
                }
                else {
                    this.layoutNextItemsBlock(curretBlock, this.viewer);
                }
            }
            else if (bodyWidget instanceof TableCellWidget) {
                /* eslint-disable-next-line max-len */
                const table = this.documentHelper.layout.getParentTable(bodyWidget.ownerTable).getSplitWidgets()[0];
                this.reLayoutTable(bodyWidget.ownerTable);
                this.layoutNextItemsBlock(table, this.viewer);
            }
        }
        this.isRelayoutFootnote = false;
    }
    checkAndGetBlock(containerWidget, blockIndex) {
        if (containerWidget instanceof TextFrame) {
            return containerWidget.childWidgets[blockIndex];
        }
        else {
            const sectionIndex = containerWidget.index;
            while (containerWidget && containerWidget.index === sectionIndex) {
                if (containerWidget.childWidgets.length > 0 && containerWidget.firstChild.index <= blockIndex &&
                    containerWidget.lastChild.index >= blockIndex) {
                    for (let i = 0; i < containerWidget.childWidgets.length; i++) {
                        const block = containerWidget.childWidgets[i];
                        if (block.index === blockIndex) {
                            return block;
                        }
                    }
                }
                if (containerWidget instanceof BodyWidget) {
                    containerWidget = containerWidget.nextRenderedWidget;
                }
                else {
                    break;
                }
            }
        }
        return undefined;
    }
    //#endregion
    //#region Table
    layoutTable(table, startIndex) {
        table.isBidiTable = table.bidi;
        if (!table.isGridUpdated) {
            table.buildTableColumns();
            table.isGridUpdated = true;
        }
        if (this.documentHelper.compatibilityMode !== 'Word2013' && !table.isInsideTable) {
            this.viewer.clientActiveArea.x = this.viewer.clientActiveArea.x -
                HelperMethods.convertPointToPixel(table.firstChild.firstChild.leftMargin);
        }
        const tableView = [table];
        this.addTableWidget(this.viewer.clientActiveArea, tableView);
        this.viewer.updateClientAreaTopOrLeft(table, true);
        let clientActiveAreaForTableWrap;
        let clientAreaForTableWrap;
        let wrapDiff = 0;
        if (table.wrapTextAround) {
            clientActiveAreaForTableWrap = this.viewer.clientActiveArea.clone();
            clientAreaForTableWrap = this.viewer.clientArea.clone();
            this.updateClientAreaForWrapTable(tableView, table, true, clientActiveAreaForTableWrap, clientAreaForTableWrap);
        }
        else {
            this.adjustClientAreaBasedOnTextWrapForTable(table, this.viewer.clientActiveArea);
            if (this.isWrapText) {
                wrapDiff = this.viewer.clientActiveArea.x - this.viewer.clientArea.x;
                this.isWrapText = false;
                table.x = this.viewer.clientActiveArea.x;
            }
        }
        const isHeader = table.childWidgets[0].rowFormat.isHeader;
        if (table.childWidgets.length > 0) {
            table.header = isHeader;
            table.continueHeader = isHeader;
            table.headerHeight = 0;
        }
        let row = table.childWidgets[startIndex];
        let index = tableView.length;
        while (row) {
            row = this.layoutRow(tableView, row);
            row = row.nextRow;
        }
        if (index !== tableView.length && tableView.length > 1) {
            if (tableView[0] && !isNullOrUndefined(tableView[0].bodyWidget.page.footnoteWidget)) {
                const foot = this.getFootNoteWidgetsOf(tableView[0]);
                let Index = tableView[0].bodyWidget.page.footnoteWidget.bodyWidgets.indexOf(foot[0]);
                if (Index === -1) {
                    const prevBodyWidget1 = tableView[0].bodyWidget;
                    const newBodyWidget = tableView[1].bodyWidget;
                    // this.updateContainerWidget(curretBlock as Widget, newBodyWidget, prevWidget.indexInOwner + 1, false);
                    this.moveFootNotesToPage(foot, newBodyWidget, prevBodyWidget1);
                }
            }
            if (tableView[tableView.length - 1] !== tableView[tableView.length - 2]) {
                const footNoteWidgets = this.getFootNoteWidgetsOf(tableView[tableView.length - 1]);
                const prevBodyWidget1 = tableView[tableView.length - 1].bodyWidget;
                const newBodyWidget = tableView[tableView.length - 2].bodyWidget;
                // this.updateContainerWidget(curretBlock as Widget, newBodyWidget, prevWidget.indexInOwner + 1, false);
                this.moveFootNotesToPage(footNoteWidgets, newBodyWidget, prevBodyWidget1);
            }
        }
        if (this.documentHelper.viewer instanceof PageLayoutViewer && table.wrapTextAround && (table.positioning.verticalAlignment === 'Bottom' || table.positioning.verticalAlignment === 'Center' || table.positioning.verticalAlignment === 'Outside')) {
            this.updateTableFloatPoints(table);
            this.updateChildLocationForTable(table.y, table);
        }
        this.updateWidgetsToPage(tableView, [], table);
        if (wrapDiff > 0) {
            this.viewer.clientArea.x = this.viewer.clientArea.x - wrapDiff;
        }
        if (table.wrapTextAround && table.bodyWidget) {
            this.updateClientAreaForWrapTable(tableView, table, false, clientActiveAreaForTableWrap, clientAreaForTableWrap);
        }
        tableView[tableView.length - 1].isLayouted = true;
        if (this.documentHelper.compatibilityMode !== 'Word2013' && !table.isInsideTable) {
            this.viewer.clientArea.x = this.viewer.clientArea.x + HelperMethods.convertPointToPixel(table.firstChild.firstChild.leftMargin);
        }
        return tableView[tableView.length - 1];
    }
    updateClientAreaForWrapTable(tables, table, beforeLayout, clientActiveAreaForTableWrap, clientAreaForTableWrap) {
        if (beforeLayout) {
            if (table.wrapTextAround) {
                this.updateTableFloatPoints(table);
                let clienactare = this.viewer.clientActiveArea.clone();
                let rect = this.adjustClientAreaBasedOnTextWrapForTable(table, this.viewer.clientActiveArea);
                if (clienactare.x !== rect.x) {
                    table.x = this.viewer.clientActiveArea.x;
                }
            }
        }
        else {
            if (table.wrapTextAround && table.bodyWidget) {
                if (tables.length == 1) {
                    if (table.bodyWidget.floatingElements.indexOf(table) === -1) {
                        table.bodyWidget.floatingElements.push(table);
                    }
                    if (!isNullOrUndefined(table.previousWidget) || table.isInHeaderFooter || table.isInsideTable) {
                        this.viewer.clientActiveArea = clientActiveAreaForTableWrap.clone();
                        this.viewer.clientArea = clientAreaForTableWrap.clone();
                    }
                    else {
                        this.viewer.updateClientArea(table.bodyWidget.sectionFormat, table.bodyWidget.page);
                    }
                }
                else {
                    this.documentHelper.tableLefts.pop();
                    this.viewer.updateClientArea(table.bodyWidget.sectionFormat, table.bodyWidget.page);
                    for (let z = 0; z < tables.length; z++) {
                        let bodyWidget = tables[z].bodyWidget;
                        if (!isNullOrUndefined(bodyWidget) && bodyWidget.floatingElements.indexOf(tables[z]) === -1) {
                            bodyWidget.floatingElements.push(tables[z]);
                        }
                    }
                }
            }
        }
    }
    addTableWidget(area, table, create) {
        let tableWidget = table[table.length - 1];
        if (create) {
            tableWidget = this.createTableWidget(tableWidget);
            table.push(tableWidget);
        }
        tableWidget.width = area.width;
        tableWidget.x = area.x;
        tableWidget.y = area.y;
        //Update the table height of tableWidget when cell spacing has been defined.
        if (tableWidget.tableFormat.cellSpacing > 0) {
            tableWidget.height = tableWidget.height + HelperMethods.convertPointToPixel(tableWidget.tableFormat.cellSpacing);
            if (!tableWidget.isBidiTable) {
                /* eslint-disable-next-line max-len */
                tableWidget.leftBorderWidth = HelperMethods.convertPointToPixel(this.getTableLeftBorder(tableWidget.tableFormat.borders).getLineWidth());
                /* eslint-disable-next-line max-len */
                tableWidget.rightBorderWidth = HelperMethods.convertPointToPixel(this.getTableRightBorder(tableWidget.tableFormat.borders).getLineWidth());
            }
            else { // Right to left direction table.
                /* eslint-disable-next-line max-len */
                tableWidget.leftBorderWidth = HelperMethods.convertPointToPixel(this.getTableRightBorder(tableWidget.tableFormat.borders).getLineWidth());
                /* eslint-disable-next-line max-len */
                tableWidget.rightBorderWidth = HelperMethods.convertPointToPixel(this.getTableLeftBorder(tableWidget.tableFormat.borders).getLineWidth());
            }
            /* eslint-disable-next-line max-len */
            tableWidget.topBorderWidth = HelperMethods.convertPointToPixel(this.getTableTopBorder(tableWidget.tableFormat.borders).getLineWidth());
            /* eslint-disable-next-line max-len */
            tableWidget.bottomBorderWidth = HelperMethods.convertPointToPixel(this.getTableBottomBorder(tableWidget.tableFormat.borders).getLineWidth());
            tableWidget.x += tableWidget.leftBorderWidth;
            tableWidget.y += tableWidget.topBorderWidth;
            tableWidget.width -= tableWidget.leftBorderWidth;
            tableWidget.width -= tableWidget.rightBorderWidth;
            tableWidget.height += tableWidget.bottomBorderWidth;
        }
        return tableWidget;
    }
    updateWidgetsToPage(tables, rows, table, endRowWidget) {
        const viewer = this.viewer;
        const tableWidget = tables[tables.length - 1];
        if (!table.isInsideTable) {
            for (let i = 0; i < tables.length; i++) {
                this.updateHeightForTableWidget(tables, rows, tables[i], endRowWidget);
            }
            if (tableWidget.childWidgets.length > 0 && tableWidget.y !== tableWidget.childWidgets[0].y) {
                tableWidget.y = tableWidget.childWidgets[0].y;
            }
            // Need to update on this further
            //Adds the table widget to owner cell widget.
            // (viewer.renderedElements.get(table.associatedCell)[viewer.renderedElements.get(table.associatedCell).length - 1] as TableCellWidget).childWidgets.push(tableWidget);
            // tableWidget.containerWidget = viewer.renderedElements.get(table.associatedCell)[viewer.renderedElements.get(table.associatedCell).length - 1] as BodyWidget;
            // (viewer.renderedElements.get(table.associatedCell)[viewer.renderedElements.get(table.associatedCell).length - 1] as TableCellWidget).height = (viewer.renderedElements.get(table.associatedCell)[viewer.renderedElements.get(table.associatedCell).length - 1] as TableCellWidget).height + tableWidget.height;
        }
        if (table.tableFormat.cellSpacing > 0) {
            /* eslint-disable-next-line max-len */
            if (tableWidget.y + tableWidget.height + HelperMethods.convertPointToPixel(table.tableFormat.cellSpacing) > viewer.clientArea.bottom && viewer instanceof WebLayoutViewer) {
                //update the table height when split to next page. Which is equivalent Ms Word Behaviour.
                //In Ms Word if the Table Split to next page the bottom spacing of the table will be half of the current spacing.
                //And the Remaining space will be used in next page top of the table.
                tableWidget.height = tableWidget.height - HelperMethods.convertPointToPixel(table.tableFormat.cellSpacing) / 2;
            }
            //Update the current Y position of current clientactivearea.
            viewer.cutFromTop(tableWidget.y + tableWidget.height);
        }
        if (this.viewer instanceof WebLayoutViewer) {
            table.containerWidget.height += table.height;
        }
        if (table.bodyWidget instanceof HeaderFooterWidget) {
            table.containerWidget.height += table.height;
            if (this.viewer.owner.enableHeaderAndFooter && table.bodyWidget.headerFooterType.indexOf('Footer') !== -1) {
                this.shiftFooterChildLocation(table.bodyWidget, this.viewer);
            }
        }
    }
    /* eslint-disable-next-line max-len */
    updateHeightForTableWidget(tables, rows, tableWidget, endRowWidget) {
        for (let i = 0; i < tableWidget.childWidgets.length; i++) {
            const rowWidget = tableWidget.childWidgets[i];
            if (rowWidget === endRowWidget) {
                break;
            }
            this.updateHeightForRowWidget(this.viewer, true, tables, rows, rowWidget, true, endRowWidget);
        }
    }
    //#endregion
    //#region Row
    layoutRow(tableWidget, row, isRowLayout) {
        const viewer = this.viewer;
        const rowWidgets = [row];
        this.addTableRowWidget(viewer.clientActiveArea, rowWidgets);
        viewer.updateClientAreaForRow(row, true);
        const topMargin = this.getMaxTopCellMargin(row);
        const bottomMargin = this.getMaxBottomCellMargin(row);
        for (let i = 0; i < row.childWidgets.length; i++) {
            const cell = row.childWidgets[i];
            this.layoutCell(cell, topMargin + row.topBorderWidth, bottomMargin + row.bottomBorderWidth);
        }
        viewer.updateClientAreaForRow(row, false);
        const rows = [row];
        if (!isRowLayout) {
            this.updateWidgetsToTable(tableWidget, rows, row);
        }
        return rows[rows.length - 1];
    }
    getAdjacentRowCell(cell, cellStartPos, cellEndPos, rowIndex) {
        const adjCells = [];
        let adjRow = cell.ownerRow.ownerTable.childWidgets[rowIndex];
        let previouRow = false;
        if (adjRow) {
            if (adjRow.childWidgets[0].x > cell.x && rowIndex !== 0) {
                adjRow = cell.ownerRow.ownerTable.childWidgets[rowIndex - 1];
                previouRow = true;
            }
            for (let i = 0; i < adjRow.childWidgets.length; i++) {
                const adjCell = adjRow.childWidgets[i];
                const adjCellStartPos = adjCell.x - adjCell.margin.left;
                const adjCellEndPos = adjCell.x + adjCell.width + adjCell.margin.right;
                /* eslint-disable-next-line max-len */
                if ((HelperMethods.round(adjCellEndPos, 2) > HelperMethods.round(cellStartPos, 2) && HelperMethods.round(adjCellEndPos, 2) <= HelperMethods.round(cellEndPos, 2))
                    /* eslint-disable-next-line max-len */
                    || (HelperMethods.round(adjCellStartPos, 2) >= HelperMethods.round(cellStartPos, 2) && HelperMethods.round(adjCellStartPos, 2) < HelperMethods.round(cellEndPos, 2))
                    /* eslint-disable-next-line max-len */
                    || (HelperMethods.round(adjCellStartPos, 2) <= HelperMethods.round(cellStartPos, 2) && HelperMethods.round(adjCellEndPos, 2) >= HelperMethods.round(cellEndPos, 2))) {
                    //Skipped adding the Horizontal merge start cell multiple times.
                    if (adjCells.indexOf(adjCell) === -1) {
                        adjCells.push(adjCell);
                    }
                }
                if (HelperMethods.round(adjCellEndPos, 2) >= HelperMethods.round(cellEndPos, 2)) {
                    if (previouRow) {
                        adjRow = cell.ownerRow.ownerTable.childWidgets[rowIndex];
                        previouRow = false;
                    }
                    else {
                        break;
                    }
                }
                if (i === adjRow.childWidgets.length - 1 && previouRow) {
                    adjRow = cell.ownerRow.ownerTable.childWidgets[rowIndex];
                    previouRow = false;
                }
            }
        }
        return adjCells;
    }
    addTableRowWidget(area, row) {
        const rowWidget = row[row.length - 1];
        if ((rowWidget.rowFormat.beforeWidth !== 0 || rowWidget.rowFormat.gridBeforeWidth !== 0) && ((this.documentHelper.alignTablesRowByRow) ? rowWidget.ownerTable.tableFormat.tableAlignment === 'Left' : true)) {
            rowWidget.x += (rowWidget.rowFormat.beforeWidth !== 0) ? rowWidget.rowFormat.beforeWidth : rowWidget.rowFormat.gridBeforeWidth;
        }
        else {
            rowWidget.x = area.x;
        }
        rowWidget.y = area.y;
        rowWidget.width = area.width;
        let borderWidth = 0;
        if (!isNullOrUndefined(rowWidget.ownerTable) && !isNullOrUndefined(rowWidget.ownerTable.tableFormat)
            && rowWidget.ownerTable.tableFormat.cellSpacing > 0) {
            rowWidget.height = rowWidget.height + HelperMethods.convertPointToPixel(rowWidget.ownerTable.tableFormat.cellSpacing);
            //Update the table height with the border width to layout the border when the cell spacing is defined..
            for (let j = 0; j < rowWidget.childWidgets.length; j++) {
                if (!isNullOrUndefined(rowWidget.childWidgets[j].cellFormat)
                    && !isNullOrUndefined(rowWidget.childWidgets[j].cellFormat.borders)) {
                    /* eslint-disable-next-line max-len */
                    const width = TableCellWidget.getCellBottomBorder(rowWidget.childWidgets[j]).getLineWidth();
                    if (width > borderWidth) {
                        borderWidth = width;
                    }
                }
            }
            //Maximum border width is calculated and hold it in a variable to add with the padding of the cells.
            rowWidget.bottomBorderWidth = HelperMethods.convertPointToPixel(borderWidth);
            if (rowWidget.index > 0 && !isNullOrUndefined(rowWidget.previousWidget)) {
                const prevRow = rowWidget.previousWidget;
                borderWidth = 0;
                for (let i = 0; i < prevRow.childWidgets.length; i++) {
                    /* eslint-disable-next-line max-len */
                    if (!isNullOrUndefined(prevRow.childWidgets[i].cellFormat) && !isNullOrUndefined(prevRow.childWidgets[i].cellFormat.borders)) {
                        /* eslint-disable-next-line max-len */
                        const value = TableCellWidget.getCellBottomBorder(prevRow.childWidgets[i]).getLineWidth();
                        if (value > borderWidth) {
                            borderWidth = value;
                        }
                    }
                }
                //Maximum border width is calculated and hold it in a variable to add with the padding of the cells.
                rowWidget.topBorderWidth = HelperMethods.convertPointToPixel(borderWidth);
            }
        }
        if (!isNullOrUndefined(rowWidget.childWidgets)) {
            for (let i = 0; i < rowWidget.childWidgets.length; i++) {
                /* eslint-disable-next-line max-len */
                if (!isNullOrUndefined(rowWidget.childWidgets[i].cellFormat) && !isNullOrUndefined(rowWidget.childWidgets[i].cellFormat.borders)) {
                    /* eslint-disable-next-line max-len */
                    const topBorderWidth = TableCellWidget.getCellTopBorder(rowWidget.childWidgets[i]).getLineWidth();
                    if (topBorderWidth > borderWidth) {
                        borderWidth = topBorderWidth;
                    }
                }
            }
        }
        //Maximum border width is calculated and hold it in a variable to add with the padding of the cells.
        rowWidget.topBorderWidth = HelperMethods.convertPointToPixel(borderWidth);
        //Update the table height of tableWidget when cell spacing has been defined.
        /* eslint-disable-next-line max-len */
        if (!isNullOrUndefined(rowWidget.ownerTable) && !isNullOrUndefined(rowWidget.ownerTable.tableFormat) && rowWidget.ownerTable.tableFormat.cellSpacing <= 0 && rowWidget.rowIndex === rowWidget.ownerTable.childWidgets.length - 1) {
            // Update the bottom width for last row .
            for (let i = 0; i < rowWidget.childWidgets.length; i++) {
                /* eslint-disable-next-line max-len */
                if (!isNullOrUndefined(rowWidget.childWidgets[i].cellFormat) && !isNullOrUndefined(rowWidget.childWidgets[i].cellFormat.borders)) {
                    /* eslint-disable-next-line max-len */
                    const bottomBorderWidth = TableCellWidget.getCellBottomBorder(rowWidget.childWidgets[i]).getLineWidth();
                    if (bottomBorderWidth > borderWidth) {
                        borderWidth = bottomBorderWidth;
                    }
                }
            }
            //Maximum border width is calculated and hold it in a variable to add with the padding of the cells.
            rowWidget.bottomBorderWidth = HelperMethods.convertPointToPixel(borderWidth);
        }
        //tableRowWidget.ownerWidget = owner;
        return rowWidget;
    }
    getMaxTopCellMargin(row) {
        if (isNullOrUndefined(row.childWidgets)) {
            return 0;
        }
        let value = 0;
        for (let i = 0; i < row.childWidgets.length; i++) {
            const cell = row.childWidgets[i];
            let topMargin = 0;
            if (cell.cellFormat.hasValue('topMargin')) {
                topMargin = HelperMethods.convertPointToPixel(cell.cellFormat.topMargin);
            }
            else if (row.rowFormat.hasValue('topMargin')) {
                topMargin = HelperMethods.convertPointToPixel(row.rowFormat.topMargin);
            }
            else {
                topMargin = HelperMethods.convertPointToPixel(row.ownerTable.tableFormat.topMargin);
            }
            if (topMargin > value) {
                value = topMargin;
            }
        }
        return value;
    }
    getMaxBottomCellMargin(row) {
        if (isNullOrUndefined(row.childWidgets)) {
            return 0;
        }
        let value = 0;
        for (let i = 0; i < row.childWidgets.length; i++) {
            const cell = row.childWidgets[i];
            let bottomMargin = 0;
            if (cell.cellFormat.hasValue('bottomMargin')) {
                bottomMargin = HelperMethods.convertPointToPixel(cell.cellFormat.bottomMargin);
            }
            else if (row.rowFormat.hasValue('bottomMargin')) {
                bottomMargin = HelperMethods.convertPointToPixel(row.rowFormat.bottomMargin);
            }
            else {
                bottomMargin = HelperMethods.convertPointToPixel(row.ownerTable.tableFormat.bottomMargin);
            }
            if (bottomMargin > value) {
                value = bottomMargin;
            }
        }
        return value;
    }
    //#endregion Row
    //#region cell
    layoutCell(cell, maxCellMarginTop, maxCellMarginBottom) {
        const viewer = this.viewer;
        this.addTableCellWidget(cell, viewer.clientActiveArea, maxCellMarginTop, maxCellMarginBottom);
        this.updateTopBorders(cell);
        viewer.updateClientAreaForCell(cell, true);
        if (cell.childWidgets.length === 0) {
            const paragraphWidget = new ParagraphWidget();
            paragraphWidget.characterFormat = new WCharacterFormat();
            paragraphWidget.paragraphFormat = new WParagraphFormat();
            paragraphWidget.index = 0;
            const lineWidget = new LineWidget(paragraphWidget);
            paragraphWidget.childWidgets.push(lineWidget);
            cell.childWidgets.push(paragraphWidget);
        }
        for (let i = 0; i < cell.childWidgets.length; i++) {
            const block = cell.childWidgets[i];
            viewer.updateClientAreaForBlock(block, true);
            block.containerWidget = cell;
            this.layoutBlock(block, 0);
            viewer.updateClientAreaForBlock(block, false);
            for (let k = 0; k < block.childWidgets.length; k++) {
                if (block.childWidgets[k] instanceof LineWidget) {
                    // eslint-disable-next-line
                    let line = block.childWidgets[k];
                    for (let j = 0; j < line.children.length; j++) {
                        const child = line.children[j];
                        if (child instanceof FootnoteElementBox) {
                            let foot = child.line.paragraph.bodyWidget.page.footnoteWidget;
                            let body = child.line.paragraph.bodyWidget;
                            let findIndex = -1;
                            if (!isNullOrUndefined(foot)) {
                                for (let i = 0; i < foot.bodyWidgets.length; i++) {
                                    if ((foot.bodyWidgets[i]).footNoteReference === child) {
                                        findIndex = i;
                                    }
                                }
                            }
                            if (findIndex === -1) {
                                if (!isNullOrUndefined(body.nextRenderedWidget)) {
                                    const footNoteWidgets = this.getFootNoteWidgetsOf(child.paragraph);
                                    const prevBodyWidget1 = body;
                                    const newBodyWidget = body.nextRenderedWidget;
                                    // this.updateContainerWidget(curretBlock as Widget, newBodyWidget, prevWidget.indexInOwner + 1, false);
                                    this.moveFootNotesToPage(footNoteWidgets, newBodyWidget, prevBodyWidget1);
                                    this.layoutfootNote(body.page.footnoteWidget);
                                    this.viewer.updateClientArea(body.page.footnoteWidget.sectionFormat, body.page, true);
                                }
                            }
                        }
                        if (child instanceof FootnoteElementBox && !isNullOrUndefined(cell.bodyWidget.page.footnoteWidget)) {
                            this.footHeight = cell.bodyWidget.page.footnoteWidget.height;
                            this.isTableFootNote = true;
                            break;
                        }
                        else {
                            this.footHeight = 0;
                        }
                    }
                }
            }
        }
        this.updateWidgetToRow(cell);
        viewer.updateClientAreaForCell(cell, false);
    }
    isInsertTable() {
        if (this.documentHelper.owner.editorHistory && this.documentHelper.owner.editorHistory.currentBaseHistoryInfo && this.documentHelper.owner.editorHistory.currentBaseHistoryInfo.action === 'InsertTable')
            return true;
        else
            return false;
    }
    updateTopBorders(cell) {
        cell.updatedTopBorders = [];
        if (cell.ownerTable.tableFormat.cellSpacing === 0) {
            let cellTopBorder = cell.cellFormat.borders.top;
            if (!cellTopBorder.isBorderDefined || (cellTopBorder.isBorderDefined
                && cellTopBorder.lineStyle === 'None' && cellTopBorder.lineWidth === 0 &&
                cellTopBorder.hasValue('color'))) {
                cellTopBorder = cell.ownerRow.rowFormat.borders.horizontal;
            }
            if (!cellTopBorder.isBorderDefined) {
                cellTopBorder = cell.ownerRow.ownerTable.tableFormat.borders.horizontal;
            }
            const cellStartPos = cell.x - cell.margin.left;
            const cellEndPos = cell.x + cell.width + cell.margin.right;
            const adjCells = this.getAdjacentRowCell(cell, cellStartPos, cellEndPos, cell.ownerRow.indexInOwner - 1);
            for (let j = 0; j < adjCells.length; j++) {
                const adjCell = adjCells[j];
                let prevCellBottomBorder = adjCell.cellFormat.borders.bottom;
                if (!prevCellBottomBorder.isBorderDefined || (prevCellBottomBorder.isBorderDefined
                    && prevCellBottomBorder.lineStyle === 'None' && prevCellBottomBorder.lineWidth === 0 &&
                    prevCellBottomBorder.hasValue('color'))) {
                    prevCellBottomBorder = adjCell.ownerRow.rowFormat.borders.horizontal;
                }
                if (!prevCellBottomBorder.isBorderDefined) {
                    prevCellBottomBorder = adjCell.ownerRow.ownerTable.tableFormat.borders.horizontal;
                }
                let border;
                if (cellTopBorder.lineStyle === 'None' || cellTopBorder.lineStyle === 'Cleared') {
                    border = prevCellBottomBorder;
                }
                else if (prevCellBottomBorder.lineStyle === 'Cleared' || prevCellBottomBorder.lineStyle === 'None') {
                    border = cellTopBorder;
                }
                else {
                    border = cell.getBorderBasedOnPriority(cellTopBorder, prevCellBottomBorder);
                }
                const adjCellStartPos = adjCell.x - adjCell.margin.left;
                const adjCellEndPos = adjCell.x + adjCell.width + adjCell.margin.right;
                if (j === 0 && cellStartPos < adjCellStartPos) {
                    cell.updatedTopBorders.push({ border: cellTopBorder, width: (adjCellStartPos - cellStartPos) });
                }
                if (border) {
                    let width = 0;
                    /* eslint-disable-next-line max-len */
                    if (HelperMethods.round(adjCellEndPos, 2) === HelperMethods.round(cellEndPos, 2) && HelperMethods.round(adjCellStartPos, 2) === HelperMethods.round(cellStartPos, 2)) {
                        width = cellEndPos - cellStartPos;
                        /* eslint-disable-next-line max-len */
                    }
                    else if (HelperMethods.round(adjCellStartPos, 2) >= HelperMethods.round(cellStartPos, 2) && HelperMethods.round(adjCellEndPos, 2) >= HelperMethods.round(cellEndPos, 2)) {
                        width = cellEndPos - adjCellStartPos;
                        /* eslint-disable-next-line max-len */
                    }
                    else if (HelperMethods.round(adjCellStartPos, 2) >= HelperMethods.round(cellStartPos, 2) && HelperMethods.round(adjCellEndPos, 2) <= HelperMethods.round(cellEndPos, 2)) {
                        width = adjCellEndPos - adjCellStartPos;
                        /* eslint-disable-next-line max-len */
                    }
                    else if (HelperMethods.round(adjCellStartPos, 2) <= HelperMethods.round(cellStartPos, 2) && HelperMethods.round(adjCellEndPos, 2) <= HelperMethods.round(cellEndPos, 2)) {
                        width = adjCellEndPos - cellStartPos;
                        /* eslint-disable-next-line max-len */
                    }
                    else if (HelperMethods.round(adjCellStartPos, 2) <= HelperMethods.round(cellStartPos, 2) && HelperMethods.round(adjCellEndPos, 2) >= HelperMethods.round(cellEndPos, 2)) {
                        width = cellEndPos - cellStartPos;
                    }
                    else {
                        width = cellEndPos - cellStartPos;
                    }
                    if (width < 0) {
                        width = 0;
                    }
                    cell.updatedTopBorders.push({ border: border, width: width });
                }
                if (j === (adjCells.length - 1) && cellEndPos > adjCellEndPos) {
                    cell.updatedTopBorders.push({ border: cellTopBorder, width: (cellEndPos - adjCellEndPos) });
                }
            }
        }
    }
    //endregion cell
    //#region Shifting
    shiftLayoutedItems(reLayout) {
        if (isNullOrUndefined(this.documentHelper.blockToShift) || isNullOrUndefined(this.documentHelper.blockToShift.containerWidget)) {
            this.documentHelper.blockToShift = undefined;
            this.checkAndShiftEndnote();
            return;
        }
        let block = this.documentHelper.blockToShift;
        const sectionIndex = block.bodyWidget.index;
        this.reLayoutOrShiftWidgets(block, this.viewer);
        let updateNextBlockList = true;
        // If flow layout, then all sections are in single page. Hence need to update till last block of last section.
        // Todo: For page layout and section break continuous, need to handle the same.
        let splittedWidget = block.getSplitWidgets();
        let nextBlock = splittedWidget[splittedWidget.length - 1].nextRenderedWidget;
        let endNoteWidget;
        while (nextBlock instanceof BlockWidget && nextBlock.bodyWidget.index === sectionIndex) {
            let currentWidget = undefined;
            let blocks = block.getSplitWidgets();
            currentWidget = blocks[blocks.length - 1];
            block = nextBlock;
            updateNextBlockList = false;
            let nextWidget = undefined;
            blocks = block.getSplitWidgets();
            if (block instanceof ParagraphWidget) {
                nextWidget = blocks[0];
            }
            else {
                if (block instanceof TableWidget) {
                    nextWidget = blocks[0];
                }
            }
            if (currentWidget.containerWidget === nextWidget.containerWidget
                && (HelperMethods.round(nextWidget.y, 2) === HelperMethods.round(this.viewer.clientActiveArea.y, 2)) &&
                isNullOrUndefined(nextWidget.nextWidget)) {
                break;
            }
            if (!isNullOrUndefined(currentWidget.floatingElements)) {
                //this.shiftLayoutFloatingItems(currentWidget as ParagraphWidget);
            }
            updateNextBlockList = true;
            if (isNullOrUndefined(block.nextRenderedWidget)
                && block.containerWidget.page.endnoteWidget
                && block.containerWidget.page.endnoteWidget.footNoteType === 'Endnote') {
                endNoteWidget = block.containerWidget.page.endnoteWidget;
            }
            this.reLayoutOrShiftWidgets(block, this.viewer);
            splittedWidget = block.getSplitWidgets();
            nextBlock = splittedWidget[splittedWidget.length - 1].nextRenderedWidget;
        }
        if (endNoteWidget) {
            this.layoutfootNote(endNoteWidget);
        }
        if (this.viewer.owner.editorModule) {
            this.viewer.owner.editorModule.updateListItemsTillEnd(block, updateNextBlockList);
        }
        this.documentHelper.blockToShift = undefined;
        const viewer = this.viewer;
        // if (viewer instanceof PageLayoutViewer) {
        this.documentHelper.removeEmptyPages();
        this.updateFieldElements();
        if (!this.documentHelper.owner.enableLockAndEdit || !reLayout) {
            viewer.updateScrollBars();
        }
        // }
    }
    checkAndShiftEndnote() {
        if (this.documentHelper.owner.selection) {
            let endBlock = this.documentHelper.owner.selection.end.paragraph;
            if (endBlock.isInsideTable) {
                endBlock = this.getParentTable(endBlock);
            }
            if (!endBlock.isInHeaderFooter && !(endBlock.bodyWidget.containerWidget instanceof FootNoteWidget) && isNullOrUndefined(endBlock.nextRenderedWidget)) {
                if (!(endBlock.bodyWidget instanceof FootNoteWidget) && !this.isRelayoutFootnote
                    && endBlock.bodyWidget.page.endnoteWidget) {
                    this.layoutfootNote(endBlock.bodyWidget.page.endnoteWidget);
                }
            }
        }
    }
    updateFieldElements() {
        for (let i = 0; i < this.documentHelper.fields.length; i++) {
            const fieldBegin = this.documentHelper.fields[i];
            if (!isNullOrUndefined(this.documentHelper.selection)) {
                const fieldCode = this.documentHelper.selection.getFieldCode(fieldBegin);
                if (!isNullOrUndefined(fieldCode) && (fieldCode.toLowerCase().match('numpages') || fieldCode.toLowerCase().match('sectionpages')) && !isNullOrUndefined(fieldBegin.fieldSeparator)) {
                    const textElement = fieldBegin.fieldSeparator.nextNode;
                    if (!isNullOrUndefined(textElement)) {
                        const prevPageNum = textElement.text;
                        textElement.text = this.documentHelper.pages.length.toString();
                        const paragraph = fieldBegin.line.paragraph;
                        if (!isNullOrUndefined(paragraph.bodyWidget) && !isNullOrUndefined(paragraph.bodyWidget.page)
                            && prevPageNum !== textElement.text) {
                            const lineIndex = paragraph.childWidgets.indexOf(fieldBegin.line);
                            const elementIndex = fieldBegin.line.children.indexOf(textElement);
                            this.reLayoutParagraph(paragraph, lineIndex, elementIndex);
                        }
                    }
                }
            }
        }
    }
    reLayoutOrShiftWidgets(blockAdv, viewer) {
        let block = blockAdv;
        // if (block instanceof ParagraphWidget) {
        //     reLayoutItems = viewer.renderedElements.get(block as ParagraphWidget).length === 0;
        // } else {
        //     reLayoutItems = viewer.renderedElements.get(block as TableWidget).length === 0;
        // }
        if (this.isNeedToRelayout(blockAdv.bodyWidget)) {
            this.updateContainerForTable(block, viewer);
            //Handle layouting the block.
            if (block instanceof TableWidget) {
                block = block.combineWidget(this.viewer);
                this.clearTableWidget(block, true, true, true);
            }
            viewer.updateClientAreaForBlock(block, true);
            this.layoutBlock(block, 0);
            viewer.updateClientAreaForBlock(block, false);
        }
        else {
            //Handled to check client area and shift layouted widget.
            this.shiftWidgetsBlock(block, viewer);
        }
        let index = this.documentHelper.pages.indexOf(block.bodyWidget.page);
        if (index > 0 && block === block.bodyWidget.childWidgets[0] && block instanceof ParagraphWidget) {
            let val = block.bodyWidget.childWidgets[0].childWidgets[0].children;
            for (let i = 0; i < val.length; i++) {
                let element = val[i];
                if (element.margin.top > 0 && element.margin.top === this.getBeforeSpacing(element.paragraph)) {
                    element.margin.top -= this.getBeforeSpacing(element.paragraph);
                }
            }
        }
        //Updates the list value of the rendered paragraph.
        if (this.viewer.owner.editorModule) {
            this.viewer.owner.editorModule.updateRenderedListItems(block);
        }
        if (!this.isRelayoutFootnote && block.bodyWidget.page.footnoteWidget) {
            this.layoutfootNote(block.bodyWidget.page.footnoteWidget);
        }
        if (!(block.bodyWidget instanceof FootNoteWidget) && !this.isRelayoutFootnote
            && block.bodyWidget.page.endnoteWidget) {
            this.layoutfootNote(block.bodyWidget.page.endnoteWidget);
        }
        // }
    }
    isNeedToRelayout(bodyWidget) {
        for (let i = 0; i < bodyWidget.floatingElements.length; i++) {
            const floatElement = bodyWidget.floatingElements[i];
            if (floatElement instanceof TableWidget || (floatElement instanceof ShapeBase &&
                (floatElement.textWrappingStyle === 'Square' || floatElement.textWrappingStyle === 'TopAndBottom'))) {
                return true;
            }
        }
        return false;
    }
    shiftWidgetsBlock(block, viewer) {
        if (block instanceof ParagraphWidget) {
            this.shiftWidgetsForPara(block, viewer);
        }
        else if (block instanceof TableWidget) {
            this.shiftWidgetsForTable(block, viewer);
        }
    }
    shiftWidgetsForPara(paragraph, viewer) {
        if (paragraph.height > (viewer.clientArea.height + viewer.clientArea.y)) {
            return;
        }
        const bodywid = paragraph.bodyWidget;
        const prevBodyObj = this.getBodyWidgetOfPreviousBlock(paragraph, 0);
        let prevBodyWidget = prevBodyObj.bodyWidget;
        let index = prevBodyObj.index;
        let prevWidget = undefined;
        for (let i = 0; i < paragraph.getSplitWidgets().length; i++) {
            const widget = paragraph.getSplitWidgets()[i];
            if (!isNullOrUndefined(prevWidget)) {
                const isPageBreak = prevWidget.lastChild ? prevWidget.lastChild.isEndsWithPageBreak : false;
                this.shiftToPreviousWidget(widget, viewer, prevWidget, isPageBreak);
                if ((isNullOrUndefined(widget.childWidgets) || widget.childWidgets.length === 0) && !isPageBreak) {
                    i--;
                    continue;
                }
                prevWidget = undefined;
                if (prevBodyWidget !== widget.containerWidget) {
                    prevBodyWidget = widget.containerWidget;
                    if (isPageBreak) {
                        viewer.updateClientAreaByWidget(widget);
                    }
                }
            }
            //let isContainsFootnote: boolean = false;
            const footWidget = this.getFootNoteWidgetsOf(widget);
            if (this.isFitInClientArea(widget, viewer, footWidget)) {
                if (this.keepWithNext) {
                    this.updateClientPositionForBlock(widget.containerWidget.firstChild, widget);
                    this.keepWithNext = false;
                }
                //Check whether this widget is moved to previous container widget.
                prevWidget = widget;
                widget.y = viewer.clientActiveArea.y;
                if (widget.floatingElements.length > 0) {
                    for (let k = 0; k < widget.floatingElements.length; k++) {
                        let shape = widget.floatingElements[k];
                        let position = this.getFloatingItemPoints(shape);
                        shape.y = position.y;
                        shape.x = position.x;
                        if (shape instanceof ShapeElementBox) {
                            this.updateChildLocationForCellOrShape(shape.y, shape);
                        }
                    }
                }
                viewer.cutFromTop(viewer.clientActiveArea.y + widget.height);
                //Moves the paragraph widget to previous body widget.
                if (!isNullOrUndefined(prevBodyWidget) && prevBodyWidget !== widget.containerWidget) {
                    index++;
                    if (!prevBodyWidget.lastChild.isEndsWithPageBreak) {
                        this.updateContainerWidget(widget, prevBodyWidget, index, true, footWidget);
                    }
                    if (footWidget.length > 0) {
                        if (prevBodyWidget.page.footnoteWidget) {
                            for (let k = 0; k < footWidget.length; k++) {
                                if (prevBodyWidget.page.footnoteWidget.bodyWidgets.indexOf(footWidget[k]) === -1) {
                                    prevBodyWidget.page.footnoteWidget.bodyWidgets.push(footWidget[k]);
                                    prevBodyWidget.page.footnoteWidget.height += footWidget[k].height;
                                }
                            }
                        }
                    }
                }
                if (widget.isEndsWithPageBreak && this.viewer instanceof PageLayoutViewer) {
                    let nextBodyWidget = this.createOrGetNextBodyWidget(prevBodyWidget, this.viewer);
                    nextBodyWidget = this.moveBlocksToNextPage(widget, false);
                    viewer.updateClientArea(nextBodyWidget.sectionFormat, nextBodyWidget.page);
                }
            }
            else {
                const previousBlock = widget.previousRenderedWidget;
                let isPageBreak = false;
                if (previousBlock instanceof ParagraphWidget && previousBlock.isEndsWithPageBreak &&
                    this.viewer instanceof PageLayoutViewer) {
                    isPageBreak = true;
                }
                const isSplittedToNewPage = this.splitWidget(widget, viewer, prevBodyWidget, index + 1, isPageBreak, footWidget);
                prevWidget = undefined;
                if (prevBodyWidget !== widget.containerWidget) {
                    prevBodyWidget = widget.containerWidget;
                    i--;
                }
                index = prevBodyWidget.childWidgets.indexOf(widget);
                if (isSplittedToNewPage) {
                    prevBodyWidget = paragraph.getSplitWidgets()[i + 1].containerWidget;
                }
            }
        }
    }
    /**
     * @private
     * Get the footnote of the block widget.
     *
     * @param {BlockWidget} widget BlockWidget instance.
     * @returns
     */
    getFootNotesOfBlock(widget, footnoteElements) {
        if (isNullOrUndefined(footnoteElements)) {
            footnoteElements = [];
        }
        if (widget.childWidgets.length > 0) {
            for (let j = 0; j < this.documentHelper.footnoteCollection.length; j++) {
                if (this.documentHelper.footnoteCollection[j].line.paragraph === widget) {
                    //isContainsFootnote = true;
                    footnoteElements.push(this.documentHelper.footnoteCollection[j]);
                }
            }
        }
        return footnoteElements;
    }
    getFootNotesWidgetsInLine(line) {
        const footnoteElements = [];
        for (let i = 0; i < line.children.length; i++) {
            const element = line.children[i];
            if (element instanceof FootnoteElementBox) {
                footnoteElements.push(element);
            }
        }
        return this.getFootNoteWidgetsBy(line.paragraph, footnoteElements);
    }
    getFootNoteWidgetsBy(widget, footnoteElements) {
        const footWidgets = [];
        if (widget.bodyWidget.page.footnoteWidget) {
            for (let i = 0; i < widget.bodyWidget.page.footnoteWidget.bodyWidgets.length; i++) {
                /* eslint-disable-next-line max-len */
                for (let j = 0; j < footnoteElements.length; j++) {
                    if ((widget.bodyWidget.page.footnoteWidget.bodyWidgets[i]).footNoteReference === footnoteElements[j]) {
                        footWidgets.push(widget.bodyWidget.page.footnoteWidget.bodyWidgets[i]);
                    }
                }
            }
        }
        if (footWidgets.length === 0 && (!isNullOrUndefined(widget.previousRenderedWidget) && widget.previousRenderedWidget.bodyWidget.page.footnoteWidget)) {
            for (let i = 0; i < widget.previousRenderedWidget.bodyWidget.page.footnoteWidget.bodyWidgets.length; i++) {
                /* eslint-disable-next-line */
                for (let j = 0; j < footnoteElements.length; j++) {
                    if ((widget.previousRenderedWidget.bodyWidget.page.footnoteWidget.bodyWidgets[i]).footNoteReference === footnoteElements[j]) {
                        footWidgets.push(widget.previousRenderedWidget.bodyWidget.page.footnoteWidget.bodyWidgets[i]);
                    }
                }
            }
        }
        else if (!isNullOrUndefined(widget.bodyWidget.previousRenderedWidget) && widget.bodyWidget.previousRenderedWidget.page.footnoteWidget) {
            for (let i = 0; i < widget.bodyWidget.previousRenderedWidget.page.footnoteWidget.bodyWidgets.length; i++) {
                /* eslint-disable-next-line max-len */
                for (let j = 0; j < footnoteElements.length; j++) {
                    if ((widget.bodyWidget.previousRenderedWidget.page.footnoteWidget.bodyWidgets[i]).footNoteReference === footnoteElements[j]) {
                        footWidgets.push(widget.bodyWidget.previousRenderedWidget.page.footnoteWidget.bodyWidgets[i]);
                    }
                }
            }
        }
        else if (!isNullOrUndefined(widget.bodyWidget.nextRenderedWidget) && widget.bodyWidget.nextRenderedWidget.page.footnoteWidget) {
            for (let i = 0; i < widget.bodyWidget.nextRenderedWidget.page.footnoteWidget.bodyWidgets.length; i++) {
                /* eslint-disable-next-line max-len */
                for (let j = 0; j < footnoteElements.length; j++) {
                    if ((widget.bodyWidget.nextRenderedWidget.page.footnoteWidget.bodyWidgets[i]).footNoteReference === footnoteElements[j]) {
                        footWidgets.push(widget.bodyWidget.nextRenderedWidget.page.footnoteWidget.bodyWidgets[i]);
                    }
                }
            }
        }
        return footWidgets;
    }
    /**
     * @param widget
     * @private
     */
    getFootNoteWidgetsOf(widget, isShifting) {
        let footnoteWidgets = [];
        let footnoteElements = [];
        if (widget instanceof TableWidget) {
            for (let k = 0; k < widget.childWidgets.length; k++) {
                let row = widget.childWidgets[k];
                for (let i = 0; i < row.childWidgets.length; i++) {
                    let cell = row.childWidgets[i];
                    for (let x = 0; x < cell.childWidgets.length; x++) {
                        let block = cell.childWidgets[x];
                        footnoteElements = this.getFootNotesOfBlock(block, footnoteElements);
                        let blockfootnoteWidgets = this.getFootNoteWidgetsBy(block, footnoteElements);
                        for (let f = 0; f < blockfootnoteWidgets.length; f++) {
                            if (footnoteWidgets.indexOf(blockfootnoteWidgets[f]) === -1) {
                                footnoteWidgets.push(blockfootnoteWidgets[f]);
                            }
                        }
                    }
                }
            }
        }
        else {
            footnoteElements = this.getFootNotesOfBlock(widget);
            if (footnoteElements.length > 0) {
                footnoteWidgets = this.getFootNoteWidgetsBy(widget, footnoteElements);
            }
            if (isShifting && footnoteWidgets.length === 0) {
                for (var k = 0; k < footnoteElements.length; k++) {
                    footnoteWidgets.push(footnoteElements[k].bodyWidget);
                }
            }
        }
        return footnoteWidgets;
    }
    getFootNodeWidgetsToShiftToPage(paragraph) {
        const splittedWidgets = paragraph.getSplitWidgets();
        const footNoteWidgets = [];
        const toBodyWidget = paragraph.containerWidget;
        let fromBodyWidget;
        for (let i = 0; i < splittedWidgets.length; i++) {
            const footWidgets = this.getFootNoteWidgetsOf(splittedWidgets[i]);
            for (let j = 0; j < footWidgets.length; j++) {
                fromBodyWidget = footWidgets[j].containerWidget;
                if (toBodyWidget !== fromBodyWidget) {
                    footNoteWidgets.push(footWidgets[j]);
                }
            }
        }
        return { 'footNoteWidgets': footNoteWidgets, 'fromBodyWidget': fromBodyWidget, 'toBodyWidget': toBodyWidget };
    }
    shiftTableWidget(table, viewer, isClearHeight = false) {
        const tables = [table];
        this.addTableWidget(this.viewer.clientActiveArea, tables);
        this.viewer.updateClientAreaTopOrLeft(table, true);
        let clientActiveAreaForTableWrap;
        let clientAreaForTableWrap;
        if (table.wrapTextAround) {
            clientActiveAreaForTableWrap = this.viewer.clientActiveArea.clone();
            clientAreaForTableWrap = this.viewer.clientArea.clone();
            this.updateClientAreaForWrapTable(tables, table, true, clientActiveAreaForTableWrap, clientAreaForTableWrap);
        }
        let row = table.childWidgets[0];
        while (row) {
            row = this.shiftRowWidget(tables, row, isClearHeight);
            row = row.nextRow;
        }
        this.updateWidgetsToPage(tables, [], table);
        if (table.wrapTextAround && table.bodyWidget) {
            this.updateClientAreaForWrapTable(tables, table, false, clientActiveAreaForTableWrap, clientAreaForTableWrap);
        }
        return tables[tables.length - 1];
    }
    shiftRowWidget(tables, row, isClearHeight = false) {
        const viewer = this.viewer;
        if (isClearHeight) {
            row.height = 0;
        }
        const rows = [row];
        this.addTableRowWidget(viewer.clientActiveArea, rows);
        viewer.updateClientAreaForRow(row, true);
        for (let i = 0; i < row.childWidgets.length; i++) {
            const cell = row.childWidgets[i];
            if (isClearHeight) {
                cell.height = 0;
            }
            /* eslint-disable-next-line max-len */
            this.shiftCellWidget(cell, this.getMaxTopCellMargin(row) + row.topBorderWidth, this.getMaxBottomCellMargin(row) + row.bottomBorderWidth, isClearHeight);
        }
        viewer.updateClientAreaForRow(row, false);
        this.updateWidgetsToTable(tables, rows, row);
        return rows[rows.length - 1];
    }
    shiftCellWidget(cell, maxCellMarginTop, maxCellMarginBottom, isClearHeight) {
        if (isNullOrUndefined(isClearHeight)) {
            isClearHeight = false;
        }
        const viewer = this.viewer;
        this.addTableCellWidget(cell, viewer.clientActiveArea, maxCellMarginTop, maxCellMarginBottom);
        viewer.updateClientAreaForCell(cell, true);
        for (let i = 0; i < cell.childWidgets.length; i++) {
            const block = cell.childWidgets[i];
            viewer.updateClientAreaForBlock(block, true);
            if (block instanceof ParagraphWidget) {
                this.shiftParagraphWidget(block);
            }
            else {
                this.shiftTableWidget(block, viewer, isClearHeight);
            }
            viewer.updateClientAreaForBlock(block, false);
        }
        this.updateWidgetToRow(cell);
        viewer.updateClientAreaForCell(cell, false);
    }
    shiftParagraphWidget(paragraph) {
        this.addParagraphWidget(this.viewer.clientActiveArea, paragraph);
        this.viewer.cutFromTop(this.viewer.clientActiveArea.y + paragraph.height);
        if (!isNullOrUndefined(paragraph.floatingElements)) {
            //this.shiftLayoutFloatingItems(paragraph as ParagraphWidget);
            // for (let i: number = 0; i < paragraph.floatingElements.length; i++) {
            //     let shape: ShapeElementBox = paragraph.floatingElements[i];
            //     this.layoutElement(shape, paragraph);
            // }
        }
        this.updateWidgetToPage(this.viewer, paragraph);
    }
    updateContainerForTable(block, viewer) {
        const prevObj = this.getBodyWidgetOfPreviousBlock(block, 0);
        const prevBodyWidget = prevObj.bodyWidget;
        const index = prevObj.index;
        const isPageBreak = prevBodyWidget.lastChild.lastChild.isEndsWithPageBreak;
        if (prevBodyWidget !== block.containerWidget) {
            if (!isPageBreak) {
                this.updateContainerWidget(block, prevBodyWidget, index + 1, true);
            }
            else {
                viewer.updateClientArea(block.bodyWidget.sectionFormat, block.bodyWidget.page);
            }
        }
        if (block.isInHeaderFooter || this.viewer instanceof WebLayoutViewer) {
            block.containerWidget.height -= block.height;
        }
    }
    shiftWidgetsForTable(table, viewer) {
        this.updateContainerForTable(table, viewer);
        this.viewer.updateClientAreaForBlock(table, true);
        const tempClientAreaX = this.viewer.clientArea.x;
        if (this.documentHelper.compatibilityMode !== 'Word2013' && !table.isInsideTable) {
            this.viewer.clientActiveArea.x = this.viewer.clientActiveArea.x -
                HelperMethods.convertPointToPixel(table.firstChild.firstChild.leftMargin);
        }
        this.updateVerticalPositionToTop(table, true);
        //const isPageLayout: boolean = viewer instanceof PageLayoutViewer;
        const combinedTable = table.combineWidget(this.viewer);
        this.documentHelper.layout.updateChildLocationForTable(combinedTable.y, combinedTable);
        this.clearTableWidget(combinedTable, true, false);
        this.shiftTableWidget(combinedTable, this.viewer);
        this.updateVerticalPositionToTop(table, false);
        if (this.documentHelper.compatibilityMode !== 'Word2013' && !table.isInsideTable) {
            this.viewer.clientArea.x = tempClientAreaX;
        }
        this.viewer.updateClientAreaForBlock(table, false);
    }
    updateVerticalPositionToTop(table, isUpdateTop) {
        //Iterate the tableWidgets counts
        for (let i = 0; i < table.getSplitWidgets().length; i++) {
            const tablewidget = table.getSplitWidgets()[i];
            //Iterate the tableWidget child items
            for (let j = 0; j < tablewidget.childWidgets.length; j++) {
                const rowWidget = tablewidget.childWidgets[j];
                //Iterate the RowWidgets child items
                for (let k = 0; k < rowWidget.childWidgets.length; k++) {
                    const cellWidget = rowWidget.childWidgets[k];
                    //Iterate the RowWidgets child items
                    this.documentHelper.layout.updateCellVerticalPosition(cellWidget, isUpdateTop, false);
                }
            }
        }
    }
    /* eslint-disable-next-line max-len */
    splitWidget(paragraphWidget, viewer, previousBodyWidget, index, isPageBreak, footWidget) {
        const firstLine = paragraphWidget.childWidgets[0];
        const keepLinesTogether = (paragraphWidget.paragraphFormat.keepLinesTogether && (this.viewer.clientActiveArea.y !== this.viewer.clientArea.y));
        let maxElementHeight = keepLinesTogether ? paragraphWidget.height : this.getMaxElementHeight(firstLine);
        const paragraphView = paragraphWidget.getSplitWidgets();
        let nextBodyWidget = paragraphWidget.containerWidget;
        // Get maximun height based on widow/orphan control.
        maxElementHeight = this.getMaximumLineHeightToSplit(paragraphWidget, maxElementHeight, viewer);
        // TODO: Footnote move on move entire paragraph.
        const footNoteInFirstLine = this.getFootNotesWidgetsInLine(firstLine);
        if (isNullOrUndefined(paragraphWidget.previousWidget) && footNoteInFirstLine.length > 0) {
            for (let i = 0; i < footNoteInFirstLine.length; i++) {
                for (let j = 0; j < footNoteInFirstLine[i].childWidgets.length; j++) {
                    maxElementHeight += footNoteInFirstLine[i].childWidgets[j].height;
                }
            }
            //maxElementHeight += (paragraphWidget.bodyWidget.page.footnoteWidget.childWidgets[0] as ParagraphWidget).height;
        }
        if (viewer.clientActiveArea.height >= maxElementHeight && !isPageBreak) {
            let splittedWidget = undefined;
            const widgetIndex = paragraphView.indexOf(paragraphWidget);
            if (widgetIndex < (paragraphView.length - 1)) {
                splittedWidget = paragraphView[widgetIndex + 1];
                nextBodyWidget = splittedWidget.containerWidget;
            }
            else {
                splittedWidget = new ParagraphWidget();
                splittedWidget.index = paragraphWidget.index;
                splittedWidget.characterFormat = paragraphWidget.characterFormat;
                splittedWidget.paragraphFormat = paragraphWidget.paragraphFormat;
                splittedWidget.width = paragraphWidget.width;
                splittedWidget.x = paragraphWidget.x;
                splittedWidget.y = paragraphWidget.y;
                paragraphView.push(splittedWidget);
            }
            if (previousBodyWidget !== paragraphWidget.containerWidget) {
                const fromBodyWidget = paragraphWidget.containerWidget;
                if (paragraphWidget.childWidgets.indexOf(this.documentHelper.selection.start.currentWidget) !== -1 || paragraphWidget.childWidgets.indexOf(this.documentHelper.selection.end.currentWidget) !== -1) {
                    this.updateContainerWidget(paragraphWidget, previousBodyWidget, index, true);
                    this.moveFootNotesToPage(footWidget, fromBodyWidget, previousBodyWidget);
                }
            }
            for (let i = paragraphWidget.childWidgets.length - 1; i > 0; i--) {
                const line = paragraphWidget.childWidgets[i];
                if (this.isFitInClientArea(paragraphWidget, viewer, undefined)) {
                    if (splittedWidget.childWidgets.length === 1) {
                        this.updateParagraphWidgetInternal(line, splittedWidget, 0);
                    }
                    break;
                }
                else {
                    //Moves the line widget to next widget.
                    this.updateParagraphWidgetInternal(line, splittedWidget, 0);
                }
            }
            if (isNullOrUndefined(splittedWidget.containerWidget) && splittedWidget.childWidgets.length > 0) {
                const y = viewer.clientActiveArea.y;
                /* eslint-disable-next-line max-len */
                const clientArea = new Rect(viewer.clientArea.x, viewer.clientArea.y, viewer.clientArea.width, viewer.clientArea.height);
                /* eslint-disable-next-line max-len */
                const activeArea = new Rect(viewer.clientActiveArea.x, viewer.clientActiveArea.y, viewer.clientActiveArea.width, viewer.clientActiveArea.height);
                //Checks whether next node exists, else adds new page.
                nextBodyWidget = this.moveBlocksToNextPage(paragraphWidget, false);
                // nextBodyWidget = this.createOrGetNextBodyWidget(previousBodyWidget, viewer);
                nextBodyWidget.childWidgets.splice(0, 0, splittedWidget);
                nextBodyWidget.height += splittedWidget.height;
                splittedWidget.containerWidget = nextBodyWidget;
                if (nextBodyWidget != previousBodyWidget && previousBodyWidget.page.footnoteWidget) {
                    footWidget = this.getFootNoteWidgetsOf(splittedWidget, true);
                    this.moveFootNotesToPage(footWidget, previousBodyWidget, nextBodyWidget);
                }
                if (nextBodyWidget.childWidgets.length === 1 && nextBodyWidget.firstChild instanceof ParagraphWidget &&
                    nextBodyWidget.firstChild.equals(paragraphWidget)) {
                    //paragraphWidget.x = paragraphWidget.x;
                    paragraphWidget.y = y;
                    return true;
                }
                else {
                    //Resetting Client area
                    viewer.clientArea = clientArea;
                    viewer.clientActiveArea = activeArea;
                }
            }
        }
        else {
            nextBodyWidget = this.createOrGetNextBodyWidget(previousBodyWidget, this.viewer);
            if (paragraphWidget.containerWidget !== nextBodyWidget) {
                let startBlock = paragraphWidget;
                let blockInfo = this.alignBlockElement(paragraphWidget);
                if (!isNullOrUndefined(blockInfo.node)) {
                    startBlock = blockInfo.node instanceof TableRowWidget ? this.splitRow(blockInfo.node) : this.splitParagraph(blockInfo.node, parseInt(blockInfo.position.index, 10));
                    paragraphWidget = startBlock;
                    this.keepWithNext = true;
                }
                nextBodyWidget = this.moveBlocksToNextPage(paragraphWidget, true);
                this.updateContainerWidget(paragraphWidget, nextBodyWidget, 0, true);
                //footWidget = this.getFootNoteWidgetsOf(paragraphWidget);
                if (!isNullOrUndefined(previousBodyWidget.page.footnoteWidget)) {
                    this.moveFootNotesToPage(footWidget, previousBodyWidget, nextBodyWidget);
                }
            }
            else if (!isNullOrUndefined(previousBodyWidget) && isNullOrUndefined(paragraphWidget.previousWidget)) {
                this.updateContainerWidget(paragraphWidget, previousBodyWidget, previousBodyWidget.childWidgets.length, false);
                let startBlock = paragraphWidget;
                let blockInfo = this.alignBlockElement(paragraphWidget);
                if (!isNullOrUndefined(blockInfo.node)) {
                    startBlock = blockInfo.node instanceof TableRowWidget ? this.splitRow(blockInfo.node) : this.splitParagraph(blockInfo.node, parseInt(blockInfo.position.index, 10));
                    this.keepWithNext = true;
                    nextBodyWidget = this.moveBlocksToNextPage(startBlock.previousWidget, true);
                    this.updateClientPositionForBlock(paragraphWidget.previousWidget, paragraphWidget);
                    // TODO: Handle moving footnote widget
                }
                else {
                    this.updateContainerWidget(paragraphWidget, nextBodyWidget, 0, true);
                }
            }
        }
        if (previousBodyWidget === paragraphWidget.containerWidget) {
            paragraphWidget.y = viewer.clientActiveArea.y;
            viewer.cutFromTop(viewer.clientActiveArea.y + paragraphWidget.height);
        }
        else {
            //Updates client area based on next body widget.
            viewer.updateClientArea(nextBodyWidget.sectionFormat, nextBodyWidget.page);
        }
        return false;
    }
    getMaximumLineHeightToSplit(paragraphWidget, maxElementHeight, viewer) {
        if (viewer.clientActiveArea.height >= maxElementHeight && !paragraphWidget.paragraphFormat.keepLinesTogether &&
            paragraphWidget.paragraphFormat.widowControl && !isNullOrUndefined(paragraphWidget.previousWidget) &&
            isNullOrUndefined(paragraphWidget.previousSplitWidget)) {
            let paragraphHeight = paragraphWidget.height;
            for (let m = paragraphWidget.childWidgets.length - 1; m >= 0; m--) {
                let lastLine = paragraphWidget.childWidgets[m];
                let lineHeight = this.getMaxElementHeight(lastLine);
                if (lastLine.height > lineHeight) {
                    paragraphHeight -= lastLine.height - lineHeight;
                }
                if (viewer.clientActiveArea.height >= paragraphHeight) {
                    // Move entire paragraph to next page, If first line alone not fitted in the client area.
                    if (m === 0) {
                        maxElementHeight = paragraphWidget.height;
                    }
                    break;
                }
                paragraphHeight -= (lastLine).height;
            }
        }
        return maxElementHeight;
    }
    /**
     * @private
     * @param footnoteWidgets
     * @param fromBodyWidget
     * @param toBodyWidget
     */
    moveFootNotesToPage(footnoteWidgets, fromBodyWidget, toBodyWidget) {
        if (footnoteWidgets.length > 0 && fromBodyWidget.page.footnoteWidget) {
            let footNoteIndex = -1;
            let footNoteWidget;
            let insertIndex = 0;
            let check = false;
            for (let k = 0; k < footnoteWidgets.length; k++) {
                /* eslint-disable-next-line max-len */
                footNoteWidget = footnoteWidgets[k];
                footNoteIndex = fromBodyWidget.page.footnoteWidget.bodyWidgets.indexOf(footNoteWidget);
                if (footNoteIndex >= 0) {
                    if (toBodyWidget.page.footnoteWidget === undefined) {
                        this.addEmptyFootNoteToBody(toBodyWidget);
                    }
                    for (let i = 0; i < toBodyWidget.page.footnoteWidget.bodyWidgets.length; i++) {
                        let body = (toBodyWidget.page.footnoteWidget.bodyWidgets[i]).footNoteReference;
                        if (body === (footNoteWidget).footNoteReference) {
                            check = true;
                        }
                    }
                    fromBodyWidget.page.footnoteWidget.bodyWidgets.splice(footNoteIndex, 1);
                    if (toBodyWidget.page.footnoteWidget.bodyWidgets.indexOf(footNoteWidget) < 0 && !check) {
                        let childLength = toBodyWidget.page.footnoteWidget.bodyWidgets.length;
                        let fromPage = this.documentHelper.pages.indexOf(fromBodyWidget.page);
                        let toPage = this.documentHelper.pages.indexOf(toBodyWidget.page);
                        footNoteWidget.containerWidget = toBodyWidget.page.footnoteWidget;
                        footNoteWidget.page = toBodyWidget.page;
                        if (fromPage > toPage) {
                            toBodyWidget.page.footnoteWidget.bodyWidgets.push(footNoteWidget);
                            insertIndex++;
                        }
                        else {
                            toBodyWidget.page.footnoteWidget.bodyWidgets.splice(insertIndex++, 0, footNoteWidget);
                        }
                        toBodyWidget.page.footnoteWidget.height += footNoteWidget.height;
                    }
                    fromBodyWidget.page.footnoteWidget.height -= footNoteWidget.height;
                }
            }
            if (fromBodyWidget.page.footnoteWidget && fromBodyWidget.page.footnoteWidget.bodyWidgets.length === 0) {
                fromBodyWidget.page.footnoteWidget = undefined;
            }
            if (fromBodyWidget.page.footnoteWidget !== undefined) {
                this.layoutfootNote(fromBodyWidget.page.footnoteWidget);
            }
            if (toBodyWidget.page.footnoteWidget !== undefined) {
                this.layoutfootNote(toBodyWidget.page.footnoteWidget);
            }
        }
    }
    addEmptyFootNoteToBody(bodyWidget, footNoteType) {
        const footnoteWidget = new FootNoteWidget();
        footnoteWidget.footNoteType = isNullOrUndefined(footNoteType) ? 'Footnote' : footNoteType;
        footnoteWidget.page = bodyWidget.page;
        const newParagraph = new ParagraphWidget();
        newParagraph.characterFormat = new WCharacterFormat();
        newParagraph.paragraphFormat = new WParagraphFormat();
        newParagraph.index = 0;
        const lineWidget = new LineWidget(newParagraph);
        newParagraph.childWidgets.push(lineWidget);
        //  footnoteWidget.childWidgets.push(newParagraph);
        footnoteWidget.height = this.documentHelper.textHelper.getParagraphMarkSize(newParagraph.characterFormat).Height;
        footnoteWidget.margin = new Margin(0, footnoteWidget.height, 0, 0);
        if (isNullOrUndefined(footNoteType) || footNoteType === 'Footnote') {
            bodyWidget.page.footnoteWidget = footnoteWidget;
        }
        else {
            bodyWidget.page.endnoteWidget = footnoteWidget;
        }
    }
    getMaxElementHeight(lineWidget) {
        let height = 0;
        /* eslint-disable-next-line max-len */
        if (lineWidget.children.length === 0 || ((lineWidget.children.length === 1 && lineWidget.children[0] instanceof ListTextElementBox) || (lineWidget.children.length === 2 && lineWidget.children[0] instanceof ListTextElementBox && lineWidget.children[1] instanceof ListTextElementBox))) {
            const topMargin = 0;
            const bottomMargin = 0;
            height = this.documentHelper.selection.getParagraphMarkSize(lineWidget.paragraph, topMargin, bottomMargin).height;
            height += topMargin;
            if (lineWidget.children.length > 0) {
                const element = lineWidget.children[0];
                if (height < element.margin.top + element.height) {
                    height = element.margin.top + element.height;
                }
            }
        }
        else {
            for (let i = 0; i < lineWidget.children.length; i++) {
                const element = lineWidget.children[i];
                if (height < element.margin.top + element.height) {
                    height = element.margin.top + element.height;
                }
            }
        }
        return height;
    }
    createOrGetNextBodyWidget(bodyWidget, viewer) {
        let nextBodyWidget = undefined;
        let pageIndex = 0;
        pageIndex = this.documentHelper.pages.indexOf(bodyWidget.page);
        let page = undefined;
        let index = undefined;
        index = bodyWidget.index;
        if (pageIndex === this.documentHelper.pages.length - 1
            || this.documentHelper.pages[pageIndex + 1].sectionIndex !== index) {
            const currentWidget = new BodyWidget();
            currentWidget.sectionFormat = bodyWidget.sectionFormat;
            currentWidget.index = bodyWidget.index;
            page = viewer.createNewPage(currentWidget);
            if (this.documentHelper.pages[pageIndex + 1].sectionIndex !== index) {
                this.documentHelper.insertPage(pageIndex + 1, page);
            }
            nextBodyWidget = page.bodyWidgets[0];
        }
        else {
            page = this.documentHelper.pages[pageIndex + 1];
            nextBodyWidget = page.bodyWidgets[0];
        }
        return nextBodyWidget;
    }
    isFitInClientArea(paragraphWidget, viewer, blocks) {
        const lastLine = paragraphWidget.childWidgets[paragraphWidget.childWidgets.length - 1];
        let height = paragraphWidget.height;
        const maxElementHeight = this.getMaxElementHeight(lastLine);
        if (lastLine.height > maxElementHeight) {
            height -= lastLine.height - maxElementHeight;
        }
        let footHeight = 0;
        if (!isNullOrUndefined(blocks)) {
            if (blocks.length > 0) {
                if (blocks[0].containerWidget instanceof FootNoteWidget) {
                    footHeight = blocks[0].containerWidget.margin.top;
                }
                for (let k = 0; k < blocks.length; k++) {
                    for (let l = 0; l < blocks[k].childWidgets.length; l++) {
                        footHeight += blocks[k].childWidgets[l].height;
                    }
                }
            }
        }
        return viewer.clientActiveArea.height >= height + footHeight;
    }
    isLineInFootNote(line, footNotes) {
        for (let i = 0; i < footNotes.length; i++) {
            if (footNotes[i].line === line) {
                return true;
            }
        }
        return false;
    }
    /* eslint-disable-next-line max-len */
    shiftToPreviousWidget(paragraphWidget, viewer, previousWidget, isPageBreak) {
        const fromBodyWidget = paragraphWidget.containerWidget;
        let toBodyWidget = previousWidget.containerWidget;
        let footNotes = [];
        let footNoteWidgets = [];
        if (toBodyWidget !== fromBodyWidget) {
            footNotes = this.getFootNotesOfBlock(paragraphWidget);
        }
        for (let i = 0; i < paragraphWidget.childWidgets.length; i++) {
            const line = paragraphWidget.childWidgets[i];
            let maxElementHeight = this.getMaxElementHeight(line);
            if (this.isLineInFootNote(line, footNotes)) {
                let footWidget = this.getFootNoteWidgetsBy(line.paragraph, footNotes);
                let height = 0;
                for (let m = 0; m < footWidget.length; m++) {
                    let footContent = footWidget[m];
                    for (let n = 0; n < footContent.childWidgets.length; n++) {
                        height += footContent.childWidgets[n].height;
                    }
                }
                if (footWidget.length > 0 && footWidget[0].containerWidget) {
                    height += footWidget[0].containerWidget.margin.top;
                }
                maxElementHeight += height;
            }
            if (viewer.clientActiveArea.height >= maxElementHeight && !isPageBreak) {
                if (footNotes.length > 0 && this.isLineInFootNote(line, footNotes)) {
                    footNoteWidgets = footNoteWidgets.concat(this.getFootNoteWidgetsBy(line.paragraph, footNotes));
                }
                //Moves the line widget to previous widget.
                this.updateParagraphWidgetInternal(line, previousWidget, previousWidget.childWidgets.length);
                i--;
                viewer.cutFromTop(viewer.clientActiveArea.y + line.height);
                if (isNullOrUndefined(paragraphWidget.childWidgets)) {
                    break;
                }
            }
            else {
                const bodyWidget = previousWidget.containerWidget;
                let newBodyWidget = this.createOrGetNextBodyWidget(bodyWidget, viewer);
                if (paragraphWidget.containerWidget !== newBodyWidget) {
                    newBodyWidget = this.moveBlocksToNextPage(paragraphWidget, true);
                }
                if (bodyWidget !== newBodyWidget) {
                    footNotes = this.getFootNotesOfBlock(paragraphWidget);
                    if (footNotes.length > 0) {
                        footNoteWidgets = footNoteWidgets.concat(this.getFootNoteWidgetsBy(paragraphWidget, footNotes));
                        toBodyWidget = newBodyWidget;
                    }
                    this.updateContainerWidget(paragraphWidget, newBodyWidget, 0, true);
                }
                //Updates client area based on next page.
                viewer.updateClientArea(fromBodyWidget.sectionFormat, fromBodyWidget.page);
                break;
            }
        }
        if (!isNullOrUndefined(footNoteWidgets) && footNoteWidgets.length > 0 && fromBodyWidget.page.footnoteWidget
            && fromBodyWidget != toBodyWidget) {
            this.moveFootNotesToPage(footNoteWidgets, fromBodyWidget, toBodyWidget);
        }
    }
    updateParagraphWidgetInternal(lineWidget, newParagraphWidget, index) {
        if (!isNullOrUndefined(lineWidget.paragraph)) {
            lineWidget.paragraph.childWidgets.splice(lineWidget.paragraph.childWidgets.indexOf(lineWidget), 1);
            lineWidget.paragraph.height -= lineWidget.height;
            if (!isNullOrUndefined(lineWidget.paragraph.containerWidget)) {
                lineWidget.paragraph.containerWidget.height -= lineWidget.height;
            }
            if (isNullOrUndefined(lineWidget.paragraph.childWidgets) || lineWidget.paragraph.childWidgets.length === 0) {
                lineWidget.paragraph.destroyInternal(this.viewer);
            }
        }
        newParagraphWidget.childWidgets.splice(index, 0, lineWidget);
        lineWidget.paragraph = newParagraphWidget;
        newParagraphWidget.height += lineWidget.height;
        if (!isNullOrUndefined(newParagraphWidget.containerWidget)) {
            newParagraphWidget.containerWidget.height += lineWidget.height;
        }
    }
    shiftNextWidgets(blockAdv) {
        let block = blockAdv;
        while (block.nextWidget instanceof BlockWidget) {
            block = block.nextWidget;
            this.reLayoutOrShiftWidgets(block, this.viewer);
        }
    }
    updateContainerWidget(widget, bodyWidget, index, destroyAndScroll, footWidget) {
        if (widget.containerWidget && widget.containerWidget.containerWidget instanceof FootNoteWidget) {
            return;
        }
        let previousWidget = widget.containerWidget;
        if (!isNullOrUndefined(widget.containerWidget)) {
            widget.containerWidget.childWidgets.splice(widget.containerWidget.childWidgets.indexOf(widget), 1);
            widget.containerWidget.height -= bodyWidget.height;
            if ((isNullOrUndefined(widget.containerWidget.childWidgets) || widget.containerWidget.childWidgets.length === 0)
                && widget.containerWidget instanceof BodyWidget && widget.containerWidget !== bodyWidget && destroyAndScroll) {
                const page = widget.containerWidget.page;
                if (this.documentHelper.pages[this.documentHelper.pages.length - 1] === page &&
                    this.viewer.visiblePages.indexOf(page) !== -1) {
                    this.documentHelper.scrollToBottom();
                }
                if (isNullOrUndefined(page.nextPage) || page.nextPage.bodyWidgets[0].index !== widget.containerWidget.index) {
                    widget.containerWidget.destroyInternal(this.viewer);
                }
            }
        }
        bodyWidget.childWidgets.splice(index, 0, widget);
        if (widget instanceof ParagraphWidget && !isNullOrUndefined(widget.floatingElements)) {
            for (let i = 0; i < widget.floatingElements.length; i++) {
                const shape = widget.floatingElements[i];
                if (shape.textWrappingStyle !== 'Inline') {
                    bodyWidget.floatingElements.push(shape);
                    widget.bodyWidget.floatingElements.splice(widget.bodyWidget.floatingElements.indexOf(shape), 1);
                    /* eslint:disable */
                    bodyWidget.floatingElements.sort(function (a, b) { return a.y - b.y; });
                }
            }
        }
        if (widget instanceof TableWidget && widget.wrapTextAround
            && widget.bodyWidget.floatingElements.indexOf(widget) !== -1) {
            widget.bodyWidget.floatingElements.splice(widget.bodyWidget.floatingElements.indexOf(widget), 1);
        }
        bodyWidget.height += bodyWidget.height;
        widget.containerWidget = bodyWidget;
        if (previousWidget && previousWidget.page && previousWidget.page.footnoteWidget && footWidget && footWidget.length > 0) {
            this.moveFootNotesToPage(footWidget, previousWidget, bodyWidget);
        }
    }
    getBodyWidgetOfPreviousBlock(block, index) {
        index = 0;
        let prevBodyWidget = undefined;
        const previousBlock = block.previousRenderedWidget;
        prevBodyWidget = (previousBlock && previousBlock.containerWidget.equals(block.containerWidget)) ?
            previousBlock.containerWidget : block.containerWidget;
        index = previousBlock && previousBlock.containerWidget.equals(block.containerWidget) ?
            prevBodyWidget.childWidgets.indexOf(previousBlock) : block.containerWidget.childWidgets.indexOf(block);
        return { bodyWidget: prevBodyWidget, index: index };
    }
    moveBlocksToNextPage(block, moveFootnoteFromLastBlock) {
        const body = block.bodyWidget;
        const page = body.page;
        const pageIndex = page.index + 1;
        let nextPage = undefined;
        let nextBody = undefined;
        let insertPage = false;
        let isEndNoteFootNoteMove = body.containerWidget instanceof FootNoteWidget;
        let endFooteNoteType = isEndNoteFootNoteMove ? body.containerWidget.footNoteType : undefined;
        if (this.documentHelper.pages.length > pageIndex) {
            nextPage = this.documentHelper.pages[pageIndex];
            if (nextPage.bodyWidgets.length === 0 || !body.equals(nextPage.bodyWidgets[0])) {
                nextPage = undefined;
                insertPage = true;
            }
            else {
                nextBody = nextPage.bodyWidgets[0];
                this.viewer.updateClientArea(nextBody.sectionFormat, nextBody.page);
            }
        }
        if (isNullOrUndefined(nextPage)) {
            nextBody = this.createSplitBody(body);
            nextPage = this.viewer.createNewPage(nextBody, pageIndex);
            if (insertPage) {
                this.documentHelper.insertPage(pageIndex, nextPage);
            }
            this.clearLineMeasures();
        }
        let bodyCreatedForEndnote;
        // eslint-disable  no-constant-condition
        do {
            let lastBlock;
            if (body.lastChild instanceof FootNoteWidget) {
                lastBlock = body.lastChild.previousWidget;
            }
            else {
                lastBlock = body.lastChild;
            }
            if (moveFootnoteFromLastBlock) {
                const footWidget = this.getFootNoteWidgetsOf(lastBlock);
                this.moveFootNotesToPage(footWidget, body, nextBody);
            }
            if (block === lastBlock) {
                break;
            }
            if (isEndNoteFootNoteMove && endFooteNoteType === 'Endnote') {
                if (body.nextWidget) {
                    this.moveEndNotesToNextPage(body.nextWidget, body.page, nextBody.page);
                }
                body.childWidgets.splice(body.childWidgets.indexOf(lastBlock), 1);
                if (isNullOrUndefined(nextBody.page.endnoteWidget)) {
                    this.addEmptyFootNoteToBody(nextBody, 'Endnote');
                }
                if (!bodyCreatedForEndnote) {
                    bodyCreatedForEndnote = true;
                    nextBody.page.endnoteWidget.bodyWidgets.splice(0, 0, this.createSplitBody(body));
                    nextBody.page.endnoteWidget.bodyWidgets[0].footNoteReference = lastBlock.containerWidget.footNoteReference;
                }
                nextBody.page.endnoteWidget.bodyWidgets[0].childWidgets.splice(0, 0, lastBlock);
            }
            else {
                body.childWidgets.splice(body.childWidgets.indexOf(lastBlock), 1);
                nextBody.childWidgets.splice(0, 0, lastBlock);
            }
            if (lastBlock instanceof TableWidget && (body.floatingElements.indexOf(lastBlock) !== -1)) {
                body.floatingElements.splice(body.floatingElements.indexOf(lastBlock), 1);
                //nextBody.floatingElements.push(lastBlock);
            }
            if (lastBlock instanceof ParagraphWidget && lastBlock.floatingElements.length > 0) {
                for (let m = 0; m < lastBlock.floatingElements.length; m++) {
                    if (body.floatingElements.indexOf(lastBlock.floatingElements[m]) !== -1) {
                        body.floatingElements.splice(body.floatingElements.indexOf(lastBlock.floatingElements[m]), 1);
                        nextBody.floatingElements.push(lastBlock.floatingElements[m]);
                    }
                }
            }
            if (isEndNoteFootNoteMove && endFooteNoteType === 'Endnote') {
                lastBlock.containerWidget = nextBody.page.endnoteWidget.bodyWidgets[0];
                nextBody.page.endnoteWidget.bodyWidgets[0].containerWidget = nextBody.page.endnoteWidget;
                nextBody.page.endnoteWidget.page = nextBody.page;
            }
            else {
                lastBlock.containerWidget = nextBody;
            }
            nextBody.height += lastBlock.height;
            // eslint-disable-next-line no-constant-condition
        } while (true);
        return nextBody;
    }
    moveEndNotesToNextPage(startBody, page, newPage) {
        let body = page.endnoteWidget.bodyWidgets[page.endnoteWidget.bodyWidgets.length - 1];
        while (body) {
            page.endnoteWidget.bodyWidgets.splice(page.endnoteWidget.bodyWidgets.length - 1, 1);
            if (isNullOrUndefined(newPage.endnoteWidget)) {
                this.addEmptyFootNoteToBody(newPage.bodyWidgets[0], 'Endnote');
            }
            newPage.endnoteWidget.bodyWidgets.splice(0, 0, body);
            body.containerWidget = newPage.endnoteWidget;
            body.page = newPage;
            newPage.endnoteWidget.page = newPage;
            for (let i = 0; i < body.childWidgets.length; i++) {
                let block = body.childWidgets[i];
                block.containerWidget = body;
            }
            if (body === startBody) {
                break;
            }
            body = page.endnoteWidget.bodyWidgets[page.endnoteWidget.bodyWidgets.length - 1];
        }
    }
    createSplitBody(body) {
        const newBody = this.addBodyWidget(this.viewer.clientActiveArea);
        newBody.sectionFormat = body.sectionFormat;
        newBody.index = body.index;
        return newBody;
    }
    //endregion
    //#region Relayout Parargaph
    /* eslint-disable  */
    reLayoutLine(paragraph, lineIndex, isBidi, isSkip) {
        this.isFootnoteContentChanged = false;
        if (this.viewer.owner.isDocumentLoaded && this.viewer.owner.editorModule) {
            this.viewer.owner.editorModule.updateWholeListItems(paragraph);
        }
        let lineWidget;
        if (paragraph.paragraphFormat.listFormat && paragraph.paragraphFormat.listFormat.listId !== -1) {
            lineWidget = paragraph.getSplitWidgets()[0].firstChild;
        }
        else {
            lineWidget = paragraph.childWidgets[lineIndex];
        }
        if (!this.isBidiReLayout && (paragraph.paragraphFormat.bidi || this.isContainsRtl(lineWidget))) {
            let newLineIndex = lineIndex <= 0 ? 0 : lineIndex - 1;
            for (let i = newLineIndex; i < paragraph.childWidgets.length; i++) {
                if (isBidi || !(paragraph.paragraphFormat.bidi && this.isContainsRtl(lineWidget)) && !isSkip) {
                    if (i === lineIndex) {
                        if (this.viewer.owner.editor.isPaste) {
                            this.reArrangeElementsForRtl(paragraph.childWidgets[i], paragraph.paragraphFormat.bidi);
                        }
                        continue;
                    }
                }
                this.reArrangeElementsForRtl(paragraph.childWidgets[i], paragraph.paragraphFormat.bidi);
            }
        }
        let lineToLayout = lineWidget.previousLine;
        if (isNullOrUndefined(lineToLayout)) {
            lineToLayout = lineWidget;
        }
        let currentParagraph = lineToLayout.paragraph;
        let bodyWidget = paragraph.containerWidget;
        bodyWidget.height -= paragraph.height;
        if ((this.viewer.owner.enableHeaderAndFooter || paragraph.isInHeaderFooter) && !(bodyWidget instanceof TextFrame)) {
            paragraph.bodyWidget.isEmpty = false;
            this.viewer.updateHeaderFooterClientAreaWithTop(paragraph.bodyWidget.sectionFormat, this.documentHelper.isBlockInHeader(paragraph), bodyWidget.page);
        }
        else if (bodyWidget instanceof TextFrame) {
            this.viewer.updateClientAreaForTextBoxShape(bodyWidget.containerShape, true);
            // } else if (bodyWidget instanceof FootNoteWidget) {
            //     this.isRelayoutFootnote = true;
            //     this.viewer.updateClientArea(bodyWidget.sectionFormat, bodyWidget.page);
            //     this.viewer.clientArea.height = Number.POSITIVE_INFINITY;
            //     this.viewer.clientActiveArea.height = Number.POSITIVE_INFINITY;
            //     // curretBlock.containerWidget.height -= curretBlock.height;
            //     this.viewer.clientActiveArea.y = paragraph.containerWidget.y;
        }
        else {
            this.viewer.updateClientArea(bodyWidget.sectionFormat, bodyWidget.page, true);
        }
        this.viewer.updateClientAreaForBlock(paragraph, true);
        if (!isNullOrUndefined(paragraph.containerWidget) && !isNullOrUndefined(paragraph.containerWidget.containerWidget) && paragraph.containerWidget.containerWidget instanceof FootNoteWidget) {
            let y = paragraph.bodyWidget.containerWidget.y;
            this.viewer.cutFromTop(y);
            this.documentHelper.owner.editor.isFootNoteInsert = true;
            this.layoutfootNote(paragraph.containerWidget.containerWidget);
            return;
        }
        else if (lineToLayout.paragraph.isEmpty()) {
            this.viewer.cutFromTop(paragraph.y);
            this.layoutParagraph(paragraph, 0);
        }
        else {
            this.updateClientAreaForLine(lineToLayout);
            this.layoutListItems(lineToLayout.paragraph);
            if (lineToLayout.isFirstLine() && !isNullOrUndefined(paragraph.paragraphFormat)) {
                let firstLineIndent = -HelperMethods.convertPointToPixel(paragraph.paragraphFormat.firstLineIndent);
                this.viewer.updateClientWidth(firstLineIndent);
            }
            do {
                lineToLayout = this.layoutLine(lineToLayout, 0);
                paragraph = lineToLayout.paragraph;
                lineToLayout = lineToLayout.nextLine;
            } while (lineToLayout);
            this.updateWidgetToPage(this.viewer, paragraph);
            this.viewer.updateClientAreaForBlock(paragraph, false);
        }
        this.layoutNextItemsBlock(paragraph, this.viewer);
        const prevWidget = paragraph.getSplitWidgets()[0].previousRenderedWidget;
        if (!isNullOrUndefined(prevWidget) && (!(prevWidget instanceof ParagraphWidget) ||
            (prevWidget instanceof ParagraphWidget) && !prevWidget.isEndsWithPageBreak)) {
            this.viewer.cutFromTop(paragraph.y + paragraph.height);
            if (paragraph.containerWidget !== prevWidget.containerWidget && !isNullOrUndefined(prevWidget.containerWidget)) {
                /* eslint-disable-next-line max-len */
                let prevBodyWidget = paragraph.containerWidget;
                let newBodyWidget = prevWidget.containerWidget;
                const footWidgets = this.getFootNoteWidgetsOf(paragraph);
                //this.updateContainerWidget(paragraph as Widget, newBodyWidget, prevWidget.indexInOwner + 1, false);
                if (!isNullOrUndefined(newBodyWidget.page.footnoteWidget)) {
                    this.moveFootNotesToPage(footWidgets, newBodyWidget, prevBodyWidget);
                }
            }
        }
        let page = this.documentHelper.pages.length;
        let foot;
        let newBodyWidget = this.documentHelper.pages[page - 1].bodyWidgets[0];
        if (this.isFootnoteContentChanged && !isNullOrUndefined(paragraph.bodyWidget.page.footnoteWidget)) {
            foot = paragraph.bodyWidget.page.footnoteWidget;
            this.layoutfootNote(foot);
        }
        if (this.isEndnoteContentChanged && !isNullOrUndefined(newBodyWidget.page.endnoteWidget)) {
            foot = newBodyWidget.page.endnoteWidget;
            let clientArea = this.viewer.clientArea.clone();
            let clientActiveArea = this.viewer.clientActiveArea.clone();
            this.viewer.cutFromTop(newBodyWidget.childWidgets[newBodyWidget.childWidgets.length - 1].y
                + newBodyWidget.childWidgets[newBodyWidget.childWidgets.length - 1].height);
            this.layoutfootNote(foot);
            this.viewer.clientArea = clientArea;
            this.viewer.clientActiveArea = clientActiveArea;
            //this.viewer.updateClientAreaForBlock(foot.block, false);
        }
    }
    //#endregion
    //RTL Feature layout start
    isContainsRtl(lineWidget) {
        let isContainsRTL = false;
        for (let i = 0; i < lineWidget.children.length; i++) {
            if (lineWidget.children[i] instanceof TextElementBox) {
                isContainsRTL = lineWidget.children[i].characterFormat.bidi || lineWidget.children[i].characterFormat.bdo === 'RTL'
                    || this.documentHelper.textHelper.isRTLText(lineWidget.children[i].text);
                if (isContainsRTL) {
                    break;
                }
            }
        }
        return isContainsRTL;
    }
    // Re arranges the elements for Right to left layotuing.
    /* eslint-disable  */
    reArrangeElementsForRtl(line, isParaBidi) {
        if (line.children.length === 0) {
            return;
        }
        let lastAddedElementIsRtl = false;
        let lastAddedRtlElementIndex = -1;
        let tempElements = [];
        for (let i = 0; i < line.children.length; i++) {
            let element = line.children[i];
            let elementCharacterFormat = undefined;
            if (element.characterFormat) {
                elementCharacterFormat = element.characterFormat;
            }
            let isRtl = false;
            let text = '';
            let containsSpecchrs = false;
            if (element instanceof BookmarkElementBox) {
                if (isParaBidi) {
                    if (lastAddedElementIsRtl || element.bookmarkType === 0 && element.nextElement
                        && element.nextElement.nextElement instanceof TextElementBox
                        && this.documentHelper.textHelper.isRTLText(element.nextElement.nextElement.text)
                        || element.bookmarkType === 1 && element.nextElement instanceof TextElementBox
                            && this.documentHelper.textHelper.isRTLText(element.nextElement.text)) {
                        tempElements.splice(0, 0, element);
                    }
                    else {
                        tempElements.splice(lastAddedElementIsRtl ? lastAddedRtlElementIndex : lastAddedRtlElementIndex + 1, 0, element);
                    }
                    lastAddedRtlElementIndex = tempElements.indexOf(element);
                }
                else {
                    tempElements.push(element);
                }
                continue;
            }
            if (element instanceof TextElementBox) {
                text = element.text;
                containsSpecchrs = this.documentHelper.textHelper.containsSpecialCharAlone(text.trim());
                if (containsSpecchrs) {
                    if (elementCharacterFormat.bidi && isParaBidi) {
                        text = HelperMethods.reverseString(text);
                        for (let k = 0; k < text.length; k++) {
                            let ch = this.documentHelper.textHelper.inverseCharacter(text.charAt(k));
                            text = text.replace(text.charAt(k), ch);
                        }
                        element.text = text;
                    }
                }
                let textElement = element.nextElement;
                if (element instanceof TextElementBox && this.documentHelper.textHelper.containsNumberAlone(element.text.trim())) {
                    while (textElement instanceof TextElementBox && textElement.text.trim() !== '' && (this.documentHelper.textHelper.containsNumberAlone(textElement.text.trim()) || this.documentHelper.textHelper.containsSpecialCharAlone(textElement.text.trim()))) {
                        element.text = element.text + textElement.text;
                        element.line.children.splice(element.line.children.indexOf(textElement), 1);
                        textElement = element.nextElement;
                    }
                    element.width = this.documentHelper.textHelper.getTextSize(element, element.characterFormat);
                }
            }
            let isRTLText = false;
            // let isNumber: boolean = false;
            // The list element box shold be added in the last position in line widget for the RTL paragraph 
            // and first in the line widget for LTR paragrph.
            if (element instanceof ListTextElementBox) {
                isRtl = isParaBidi;
            }
            else { // For Text element box we need to check the character format and unicode of text to detect the RTL text. 
                isRTLText = this.documentHelper.textHelper.isRTLText(text);
                isRtl = isRTLText || elementCharacterFormat.bidi
                    || elementCharacterFormat.bdo === 'RTL';
            }
            if (element instanceof FieldElementBox || this.isRtlFieldCode) {
                if (element.fieldType === 0) {
                    this.isRtlFieldCode = true;
                }
                else if (element.fieldType === 1) {
                    this.isRtlFieldCode = false;
                }
                isRtl = false;
            }
            // If the text element box contains only whitespaces, then need to check the previous and next elements.
            if (!isRtl && !isNullOrUndefined(text) && text !== '' && ((text !== '' && text.trim() === '') || containsSpecchrs)) {
                let elements = line.children;
                //Checks whether the langugae is RTL.
                if (elementCharacterFormat.bidi) {
                    // If the last added element is rtl then current text element box also considered as RTL for WhiteSpaces.
                    if (lastAddedElementIsRtl) {
                        isRtl = true;
                        // Else, Check for next element.
                    }
                    else if (i + 1 < line.children.length && line.children[i + 1] instanceof TextElementBox) {
                        text = elements[i + 1].text;
                        isRtl = this.documentHelper.textHelper.isRTLText(text) || elements[i + 1].characterFormat.bidi
                            || elements[i + 1].characterFormat.bdo === 'RTL';
                    } // If the last added element is rtl then current text element box also considered as RTL for WhiteSpaces.
                }
                else if (lastAddedElementIsRtl) {
                    isRtl = true;
                }
            }
            // Preserve the isRTL value, to reuse it for navigation and selection.
            element.isRightToLeft = isRtl;
            //Adds the text element to the line
            if (isRtl && elementCharacterFormat.bdo !== 'LTR') {
                if (lastAddedElementIsRtl) {
                    tempElements.splice(lastAddedRtlElementIndex, 0, element);
                }
                else {
                    if (!isParaBidi) {
                        tempElements.push(element);
                    }
                    else {
                        tempElements.splice(0, 0, element);
                    }
                    lastAddedElementIsRtl = true;
                    lastAddedRtlElementIndex = tempElements.indexOf(element);
                }
            }
            else {
                if (lastAddedElementIsRtl && element instanceof ImageElementBox) {
                    if (elementCharacterFormat.bidi) {
                        tempElements.splice(lastAddedRtlElementIndex + 1, 0, element);
                    }
                    else {
                        tempElements.splice(lastAddedRtlElementIndex, 0, element);
                    }
                }
                else {
                    if (!isParaBidi) {
                        tempElements.push(element);
                    }
                    else {
                        if (lastAddedElementIsRtl) {
                            tempElements.splice(0, 0, element);
                        }
                        else {
                            tempElements.splice(lastAddedRtlElementIndex + 1, 0, element);
                        }
                        lastAddedRtlElementIndex = tempElements.indexOf(element);
                    }
                    lastAddedElementIsRtl = false;
                }
            }
        }
        // Clear the elemnts and reassign the arranged elements.
        line.children = [];
        line.children = tempElements;
    }
    shiftLayoutFloatingItems(paragraph) {
        for (let i = 0; i < paragraph.floatingElements.length; i++) {
            let element = paragraph.floatingElements[i];
            let position = this.getFloatingItemPoints(element);
            let height = position.y - element.y;
            element.x = position.x;
            element.y = position.y;
            if (element instanceof ShapeElementBox) {
                for (let j = 0; j < element.textFrame.childWidgets.length; j++) {
                    let block = element.textFrame.childWidgets[j];
                    if (block instanceof ParagraphWidget) {
                        block.y = block.y + height;
                    }
                    else if (block instanceof TableWidget) {
                        this.shiftChildLocationForTableWidget(block, height);
                    }
                }
            }
        }
    }
    //RTL feature layout end
    getFloatingItemPoints(floatElement) {
        let paragraph = floatElement.line.paragraph;
        let sectionFormat = paragraph.bodyWidget.sectionFormat;
        let indentX = 0;
        let indentY = 0;
        if (paragraph) {
            let leftMargin = HelperMethods.convertPointToPixel(sectionFormat.leftMargin);
            let rightMargin = HelperMethods.convertPointToPixel(sectionFormat.rightMargin);
            let topMargin = HelperMethods.convertPointToPixel(sectionFormat.topMargin);
            let bottomMargin = sectionFormat.bottomMargin > 0 ? HelperMethods.convertPointToPixel(sectionFormat.bottomMargin) : 48;
            let headerDistance = HelperMethods.convertPointToPixel(sectionFormat.headerDistance);
            let footerDistance = HelperMethods.convertPointToPixel(sectionFormat.footerDistance);
            let pageWidth = HelperMethods.convertPointToPixel(sectionFormat.pageWidth);
            let pageHeight = HelperMethods.convertPointToPixel(sectionFormat.pageHeight);
            let pageClientWidth = pageWidth - (leftMargin + rightMargin);
            let pageClientHeight = pageHeight - topMargin - bottomMargin;
            //Need to consider RTL layout.
            if (paragraph.isInHeaderFooter && sectionFormat.topMargin <= 0) {
                topMargin = Math.abs(topMargin) > 0 ? Math.abs(topMargin)
                    : HelperMethods.convertPointToPixel(sectionFormat.headerDistance) + (paragraph.height);
            }
            else {
                topMargin = topMargin > 0 ? topMargin : 48;
            }
            //Update the top margin as text body y position when text body y position exceeds the top margin. 
            if (!paragraph.isInHeaderFooter && topMargin < this.viewer.clientArea.y) {
                topMargin = this.viewer.clientArea.y;
            }
            let mIsYPositionUpdated = false;
            let textWrapStyle = 'InFrontOfText';
            //if (textWrapStyle !== 'Inline') {
            let isLayoutInCell = false;
            let vertOrigin = floatElement.verticalOrigin;
            let horzOrigin = floatElement.horizontalOrigin;
            let horzAlignment = floatElement.horizontalAlignment;
            let vertAlignment = floatElement.verticalAlignment;
            let verticalPercent = floatElement.verticalRelativePercent;
            let horizontalPercent = floatElement.horizontalRelativePercent;
            let shapeHeight = floatElement.height;
            //Need to update size width for Horizontal Line when width exceeds client width.
            // if(shape !== null && shape.IsHorizontalRule && size.Width > m_layoutArea.ClientActiveArea.Width)
            //     size.Width = m_layoutArea.ClientActiveArea.Width;
            let shapeWidth = floatElement.width;
            let vertPosition = floatElement.verticalPosition;
            let horzPosition = floatElement.horizontalPosition;
            let layoutInCell = floatElement.layoutInCell;
            let autoShape;
            if (floatElement instanceof ShapeElementBox) {
                autoShape = floatElement.autoShapeType;
            }
            //Word 2013 Layout picture in table cell even layoutInCell property was False.
            if (paragraph.isInsideTable && layoutInCell) {
                isLayoutInCell = true;
                indentY = this.getVerticalPosition(floatElement, vertPosition, vertOrigin, textWrapStyle);
                indentX = this.getHorizontalPosition(floatElement.width, floatElement, horzAlignment, horzOrigin, horzPosition, textWrapStyle, paragraph.associatedCell.cellFormat.cellWidth);
            }
            else {
                if (this.documentHelper.viewer instanceof WebLayoutViewer) {
                    switch (vertOrigin) {
                        case 'Line':
                            indentY = this.documentHelper.selection.getTop(floatElement.line);
                            break;
                        default:
                            indentY = this.viewer.clientActiveArea.y;
                            break;
                    }
                    switch (horzOrigin) {
                        case 'Character':
                            indentX = this.viewer.clientActiveArea.x;
                            break;
                        default:
                            switch (horzAlignment) {
                                case 'Center':
                                    indentX = (this.viewer.clientArea.width / 2) - (floatElement.width / 2);
                                    break;
                                default:
                                    indentX = this.viewer.clientArea.x;
                                    break;
                            }
                            break;
                    }
                }
                else {
                    if (mIsYPositionUpdated) { /* Upadte the Y Coordinate of floating image when floating image postion is changed based on the wrapping style. */
                        indentY = this.viewer.clientArea.y;
                    }
                    else {
                        switch (vertOrigin) {
                            case 'Page':
                            case 'TopMargin':
                                indentY = vertPosition;
                                switch (vertAlignment) {
                                    case 'Top':
                                        indentY = vertPosition;
                                        break;
                                    case 'Center':
                                        if (vertOrigin === 'TopMargin') {
                                            indentY = (topMargin - shapeHeight) / 2;
                                        }
                                        else {
                                            indentY = (pageHeight - shapeHeight) / 2;
                                        }
                                        break;
                                    case 'Outside':
                                    case 'Bottom':
                                        if (vertOrigin === 'Page' && vertAlignment === 'Bottom') {
                                            indentY = pageHeight - shapeHeight;
                                        }
                                        else {
                                            if (vertOrigin === 'TopMargin') {
                                                indentY = (topMargin - shapeHeight);
                                            }
                                            else if ((paragraph.bodyWidget.page.index + 1) % 2 !== 0) {
                                                indentY = pageHeight - shapeHeight - footerDistance / 2;
                                            }
                                            else {
                                                indentY = headerDistance / 2;
                                            }
                                        }
                                        break;
                                    case 'Inside':
                                        if (vertOrigin === 'Page') {
                                            if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                                indentY = pageHeight - shapeHeight - footerDistance / 2;
                                            }
                                            else {
                                                indentY = headerDistance / 2;
                                            }
                                        }
                                        else {
                                            //Need to ensure this behaviour.
                                            if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                                indentY = ((topMargin - shapeHeight) / 2 - headerDistance);
                                            }
                                        }
                                        break;
                                    case 'None':
                                        if (Math.abs(verticalPercent) <= 1000) {
                                            indentY = pageHeight * (verticalPercent / 100);
                                        }
                                        else {
                                            indentY = vertPosition;
                                        }
                                        break;
                                }
                                break;
                            case 'Line':
                                indentY = vertPosition;
                                switch (vertAlignment) {
                                    case 'Inside':
                                    case 'Top':
                                        //Need to update line widget height instead of client active area.
                                        indentY = this.viewer.clientActiveArea.y;
                                        break;
                                    case 'Center':
                                        indentY = this.viewer.clientActiveArea.y - shapeHeight / 2;
                                        break;
                                    case 'Outside':
                                    case 'Bottom':
                                        indentY = this.viewer.clientActiveArea.y - shapeHeight;
                                        break;
                                    case 'None':
                                        indentY = Math.round(paragraph.y) + vertPosition;
                                        break;
                                }
                                break;
                            case 'BottomMargin':
                                indentY = vertPosition;
                                switch (vertAlignment) {
                                    case 'Inside':
                                    case 'Top':
                                        indentY = (pageHeight - bottomMargin);
                                        break;
                                    case 'Center':
                                        indentY = pageHeight - bottomMargin + ((bottomMargin - shapeHeight) / 2);
                                        break;
                                    case 'Outside':
                                    case 'Bottom':
                                        if (paragraph.bodyWidget.page.index + 1 % 2 !== 0 && vertAlignment === 'Outside') {
                                            indentY = pageHeight - bottomMargin;
                                        }
                                        else {
                                            indentY = pageHeight - shapeHeight;
                                        }
                                        break;
                                    case 'None':
                                        indentY = pageHeight - bottomMargin + vertPosition;
                                        break;
                                }
                                break;
                            case 'InsideMargin':
                            case 'OutsideMargin':
                                indentY = vertPosition;
                                switch (vertAlignment) {
                                    case 'Inside':
                                        if (vertOrigin === 'InsideMargin') {
                                            if (vertOrigin === 'InsideMargin' && paragraph.bodyWidget.page.index + 1 % 2 === 0) {
                                                indentY = pageHeight - shapeHeight;
                                            }
                                            else {
                                                indentY = 0;
                                            }
                                        }
                                        else {
                                            indentY = (paragraph.bodyWidget.page.index + 1) % 2 !== 0 ? pageHeight - bottomMargin : topMargin - shapeHeight;
                                        }
                                        break;
                                    case 'Top':
                                        if (vertOrigin === 'InsideMargin') {
                                            if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                                indentY = pageHeight - bottomMargin;
                                            }
                                            else {
                                                indentY = 0;
                                            }
                                        }
                                        else {
                                            indentY = (paragraph.bodyWidget.page.index + 1) % 2 !== 0 ? pageHeight - bottomMargin : 0;
                                        }
                                        break;
                                    case 'Center':
                                        if (vertOrigin === 'OutsideMargin') {
                                            //Need to ensure this.
                                            indentY = (paragraph.bodyWidget.page.index + 1) % 2 !== 0 ? pageHeight - bottomMargin + (bottomMargin - shapeHeight) / 2 : (topMargin - shapeHeight) / 2;
                                        }
                                        else {
                                            if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                                indentY = pageHeight - bottomMargin + (bottomMargin - shapeHeight) / 2;
                                            }
                                            else {
                                                indentY = (topMargin - shapeHeight) / 2;
                                            }
                                        }
                                        break;
                                    case 'Outside':
                                        if (vertOrigin === 'InsideMargin') {
                                            if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                                indentY = (pageHeight - bottomMargin);
                                            }
                                            else {
                                                indentY = (topMargin - shapeHeight);
                                            }
                                        }
                                        else {
                                            indentY = (paragraph.bodyWidget.page.index + 1) % 2 !== 0 ? topMargin - shapeHeight : pageHeight - bottomMargin;
                                        }
                                        break;
                                    case 'Bottom':
                                        if (vertOrigin === 'OutsideMargin') {
                                            indentY = (paragraph.bodyWidget.page.index + 1) !== 0 ? pageHeight - shapeHeight : topMargin - shapeHeight;
                                        }
                                        else {
                                            if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                                indentY = pageHeight - shapeHeight;
                                            }
                                            else {
                                                indentY = topMargin - shapeHeight;
                                            }
                                        }
                                        break;
                                    case 'None':
                                        break;
                                }
                                break;
                            case 'Paragraph':
                                const space = 0;
                                //let prevsibling: BlockWidget = paragraph.previousWidget as BlockWidget;
                                // if (floatElement) {
                                //     //Need to handle DocIO Implementation.
                                //     if (Math.round(paragraph.y) !== Math.round(topMargin) && (prevsibling instanceof ParagraphWidget)
                                //         && ((paragraph.paragraphFormat.beforeSpacing > prevsibling.paragraphFormat.afterSpacing)
                                //             || (prevsibling.paragraphFormat.afterSpacing < 14)
                                //             && !paragraph.paragraphFormat.contextualSpacing)) {
                                //         space = prevsibling.paragraphFormat.afterSpacing;
                                //     }
                                // }
                                // eslint-disable-next-line max-len
                                //Floating item Y position is calculated from paragraph original Y position not from wrapped paragraph Y(ParagraphLayoutInfo.YPosition) position.
                                indentY = Math.round(paragraph.y) + space + vertPosition;
                                break;
                            case 'Margin':
                                //If header distance is more than top margin, then calculate the position of item based on header distance.
                                //As per Microsoft Word behavior, it is need to consider paragraph height along with the distance.
                                if (paragraph.isInHeaderFooter && headerDistance > topMargin) {
                                    //Need to udpate.
                                    indentY = (headerDistance + (paragraph.height)) + vertPosition;
                                }
                                else {
                                    indentY = topMargin + vertPosition;
                                }
                                switch (vertAlignment) {
                                    case 'Top':
                                        indentY = topMargin;
                                        break;
                                    case 'Center':
                                        indentY = topMargin + (pageClientHeight - shapeHeight) / 2;
                                        break;
                                    case 'Outside':
                                    case 'Bottom':
                                        if ((paragraph.bodyWidget.page.index + 1) % 2 !== 0) {
                                            indentY = topMargin + pageClientHeight - shapeHeight;
                                        }
                                        else {
                                            indentY = topMargin;
                                        }
                                        break;
                                    case 'Inside':
                                        if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                            indentY = topMargin + pageClientHeight - shapeHeight;
                                        }
                                        else {
                                            indentY = topMargin;
                                        }
                                        break;
                                    case 'None':
                                        break;
                                }
                                break;
                            default:
                                //Need to analyze further.
                                indentY = this.viewer.clientArea.y - vertPosition;
                                break;
                        }
                    }
                    // if (horzOrigin !== 'Column' && horzAlignment !== 'None') {
                    //     indentX = this.viewer.clientArea.x;
                    //     //Update the floating item x position to zero when floating item’s width
                    //     //exceeds the page width when floating item and it wrapping style is not equal to  
                    //     // infront of text and behind text and also vertical origin is not equal to paragraph.
                    // } else 
                    if (paragraph && textWrapStyle !== 'InFrontOfText' && textWrapStyle !== 'Behind' &&
                        vertOrigin === 'Paragraph' && shapeWidth >= pageWidth) {
                        indentX = 0;
                    }
                    else {
                        switch (horzOrigin) {
                            case 'Page':
                                indentX = horzPosition;
                                switch (horzAlignment) {
                                    case 'Center':
                                        if (isLayoutInCell) {
                                            indentX = (paragraph.associatedCell.cellFormat.cellWidth - shapeWidth) / 2;
                                        }
                                        else {
                                            indentX = (pageWidth - shapeWidth) / 2;
                                        }
                                        break;
                                    case 'Left':
                                        indentX = 0;
                                        break;
                                    case 'Outside':
                                    case 'Right':
                                        if (isLayoutInCell) {
                                            indentX = paragraph.associatedCell.cellFormat.cellWidth - shapeWidth;
                                        }
                                        else {
                                            indentX = pageWidth - shapeWidth;
                                        }
                                        break;
                                    case 'None':
                                        if (isLayoutInCell) {
                                            indentX = paragraph.associatedCell.x + horzPosition;
                                        }
                                        else if (floatElement instanceof ShapeElementBox) {
                                            indentX = horzPosition;
                                            // Shape pItemShape = paraItem as Shape;
                                            // float horRelPercent = pItemShape !== null ? pItemShape.TextFrame.HorizontalRelativePercent
                                            //                       : (paraItem as WTextBox).TextBoxFormat.HorizontalRelativePercent;
                                            // if (Math.Abs(horRelPercent) <= 1000)
                                            //     indentX = pageWidth * (horRelPercent / 100);
                                            // else
                                            //     indentX = pItemShape !== null ? pItemShape.HorizontalPosition
                                            //         : (paraItem as WTextBox).TextBoxFormat.HorizontalPosition;
                                        }
                                        else {
                                            indentX = horzPosition;
                                        }
                                        break;
                                }
                                if (indentX < 0 && isLayoutInCell) {
                                    indentX = paragraph.associatedCell.x;
                                }
                                break;
                            case 'Column':
                                //Update the Xposition while wrapping element exsit in the paragraph
                                if (this.viewer.clientActiveArea.x < paragraph.x) {
                                    // let cellPadings = 0;
                                    // if (paragraph.isInsideTable) {
                                    //     CellLayoutInfo cellLayoutInfo = (ownerPara.GetOwnerEntity() as IWidget).LayoutInfo as CellLayoutInfo;
                                    //     cellPadings = cellLayoutInfo.Paddings.Left + cellLayoutInfo.Paddings.Right;
                                    // }
                                    // float minimumWidthRequired = DEF_MIN_WIDTH_SQUARE;
                                    // if (textWrapStyle === TextWrappingStyle.Tight || textWrapStyle === TextWrappingStyle.Through)
                                    //     minimumWidthRequired = ownerPara.Document.Settings.CompatibilityMode === CompatibilityMode.Word2013 ?
                                    //         DEF_MIN_WIDTH_2013_TIGHTANDTHROW : DEF_MIN_WIDTH_TIGHTANDTHROW;
                                    // minimumWidthRequired -= cellPadings;
                                    // //Re Update the x position to the page left when paragraph starting position not equal to the 
                                    // //column starting and current inline item is x position equal to the column left position.
                                    // if ((ownerPara.IsXpositionUpated && ownerPara.Document.Settings.CompatibilityMode === CompatibilityMode.Word2013)
                                    //     || paragraphLayoutInfo.XPosition > (pageWidth - minimumWidthRequired - rightMargin)
                                    //     || paragraphLayoutInfo.IsXPositionReUpdate)
                                    //     indentX = layouter.ClientLayoutArea.Left + horzPosition;
                                    // else
                                    indentX = paragraph.x + horzPosition;
                                }
                                else {
                                    //Re Update the x position to the page left when word version not equal to 2013 
                                    //and wrapping style not equal to infront of text and behind text. 
                                    if ((textWrapStyle === 'InFrontOfText' || textWrapStyle === 'Behind')) {
                                        if (!(floatElement.paragraph.isInsideTable) && (autoShape === 'StraightConnector' || autoShape === 'Rectangle')) {
                                            indentX = horzPosition + HelperMethods.convertPointToPixel(sectionFormat.leftMargin);
                                        }
                                        else {
                                            indentX = paragraph.x + horzPosition;
                                        }
                                    }
                                    else {
                                        indentX = this.viewer.clientActiveArea.x + horzPosition;
                                    }
                                }
                                //Update the Wrapping element right position as page right when 
                                //wrapping element right position  exceeds the page right except position 
                                //InFrontOfText and behindText wrapping style.
                                if (textWrapStyle !== 'InFrontOfText' && textWrapStyle !== 'Behind'
                                    && Math.round(indentX + shapeWidth) > Math.round(pageWidth) && shapeWidth < pageWidth) {
                                    indentX = (pageWidth - shapeWidth);
                                }
                                if (paragraph.paragraphFormat.leftIndent && paragraph.isInHeaderFooter) {
                                    let leftIndent = HelperMethods.convertPointToPixel(paragraph.leftIndent);
                                    indentX -= leftIndent;
                                }
                                switch (horzAlignment) {
                                    case 'Center':
                                        indentX = this.viewer.clientActiveArea.x + (this.viewer.clientActiveArea.width - shapeWidth) / 2;
                                        break;
                                    case 'Left':
                                        indentX = this.viewer.clientActiveArea.x;
                                        break;
                                    case 'Right':
                                        indentX = this.viewer.clientActiveArea.x + this.viewer.clientActiveArea.width - shapeWidth; //- TextBoxFormat.InternalMargin.Right;
                                        break;
                                    case 'None':
                                        break;
                                }
                                break;
                            case 'Margin':
                                if (paragraph.bodyWidget) {
                                    indentX = leftMargin + horzPosition;
                                    switch (horzAlignment) {
                                        case 'Center':
                                            indentX = leftMargin + (pageClientWidth - shapeWidth) / 2;
                                            break;
                                        case 'Left':
                                            indentX = leftMargin;
                                            break;
                                        case 'Outside':
                                            if ((paragraph.bodyWidget.page.index + 1) % 2 !== 0) {
                                                indentX = leftMargin + pageClientWidth - shapeWidth;
                                            }
                                            break;
                                        case 'Right':
                                            indentX = leftMargin + pageClientWidth - shapeWidth;
                                            break;
                                        case 'Inside':
                                            if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                                indentX = leftMargin + pageClientWidth - shapeWidth;
                                            }
                                            break;
                                        case 'None':
                                            break;
                                    }
                                }
                                else {
                                    indentX = this.viewer.clientArea.x + horzPosition;
                                }
                                break;
                            case 'Character':
                                if (horzAlignment === 'Right' || horzAlignment === 'Center') {
                                    indentX = this.getLeftMarginHorizPosition(leftMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle);
                                }
                                else {
                                    //Need to update this while layouting.**
                                    indentX = this.viewer.clientArea.x + horzPosition;
                                }
                                break;
                            case 'LeftMargin':
                                indentX = this.getLeftMarginHorizPosition(leftMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle);
                                break;
                            case 'RightMargin':
                                indentX = this.getRightMarginHorizPosition(pageWidth, rightMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle);
                                break;
                            case 'InsideMargin':
                                if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                    indentX = this.getRightMarginHorizPosition(pageWidth, rightMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle);
                                }
                                else {
                                    indentX = this.getLeftMarginHorizPosition(leftMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle);
                                }
                                break;
                            case 'OutsideMargin':
                                if ((paragraph.bodyWidget.page.index + 1) % 2 === 0) {
                                    indentX = this.getLeftMarginHorizPosition(leftMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle);
                                }
                                else {
                                    indentX = this.getRightMarginHorizPosition(pageWidth, rightMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle);
                                }
                                break;
                            default:
                                indentX = this.viewer.clientArea.x + horzPosition;
                                break;
                        }
                    }
                    //Update the floating item right position to the page right when floating item 
                    //right position exceeds the page width and it wrapping style is not equal to  
                    // InFrontOfText and behind text and also vertical origin is not equal to paragraph.
                    if (paragraph && textWrapStyle !== 'InFrontOfText'
                        && textWrapStyle !== 'Behind' && vertOrigin === 'Paragraph' && pageWidth < indentX + shapeWidth) {
                        indentX = pageWidth - shapeWidth;
                    }
                }
            }
        }
        //}
        return new Point(indentX, indentY);
    }
    getLeftMarginHorizPosition(leftMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle) {
        let indentX = horzPosition;
        switch (horzAlignment) {
            case 'Center':
                indentX = (leftMargin - shapeWidth) / 2;
                break;
            case 'Left':
                indentX = 0;
                break;
            case 'Right':
                indentX = leftMargin - shapeWidth;
                break;
            case 'None':
                break;
        }
        if (indentX < 0 && textWrapStyle !== 'InFrontOfText' && textWrapStyle !== 'Behind') {
            indentX = 0;
        }
        return indentX;
    }
    getRightMarginHorizPosition(pageWidth, rightMargin, horzAlignment, horzPosition, shapeWidth, textWrapStyle) {
        let xPosition = pageWidth - rightMargin;
        let indentX = xPosition + horzPosition;
        switch (horzAlignment) {
            case 'Center':
                indentX = xPosition + (rightMargin - shapeWidth) / 2;
                break;
            case 'Left':
                indentX = xPosition;
                break;
            case 'Right':
                indentX = pageWidth - shapeWidth;
                break;
            case 'None':
                break;
        }
        if ((indentX < 0 || indentX + shapeWidth > pageWidth) && textWrapStyle !== 'InFrontOfText' && textWrapStyle !== 'Behind') {
            indentX = pageWidth - shapeWidth;
        }
        return indentX;
    }
    getVerticalPosition(paraItem, vertPosition, vertOrigin, textWrapStyle) {
        let paragraph = paraItem.line.paragraph;
        //ParagraphLayoutInfo paragraphLayoutInfo = (paragraph as IWidget).LayoutInfo as ParagraphLayoutInfo;
        let indentY = 0;
        let topMargin = paragraph.associatedCell.y;
        switch (vertOrigin) {
            case 'Page':
            case 'Margin':
            case 'TopMargin':
            case 'InsideMargin':
            case 'BottomMargin':
            case 'OutsideMargin':
                indentY = topMargin + vertPosition;
                break;
            case 'Line':
            case 'Paragraph':
                let space = 0;
                // if (shape) {
                //     space = paragraph.paragraphFormat.afterSpacing;
                // }
                indentY = paragraph.y + vertPosition + space;
                break;
            default:
                indentY = this.viewer.clientActiveArea.y + vertPosition;
                break;
        }
        return indentY;
    }
    getHorizontalPosition(width, paraItem, horzAlignment, horzOrigin, horzPosition, textWrapStyle, cellWid) {
        let indentX = 0;
        let paragraph = paraItem.line.paragraph;
        // CellLayoutInfo cellLayoutInfo = (paragraph.OwnerTextBody as IWidget).LayoutInfo as CellLayoutInfo;
        // ILayoutSpacingsInfo spacings = cellLayoutInfo as ILayoutSpacingsInfo;
        let cell = paragraph.associatedCell;
        let cellWidth = cellWid - cell.leftMargin - cell.rightMargin;
        let cellInnerWidth = cell.cellFormat.cellWidth;
        let marginLeft = cell.x;
        let pageLeft = marginLeft - cell.leftMargin;
        switch (horzOrigin) {
            case 'Page':
                {
                    indentX = horzPosition;
                    switch (horzAlignment) {
                        case 'Center':
                            indentX = pageLeft + (cellWidth - width) / 2;
                            break;
                        case 'Left':
                            indentX = pageLeft;
                            break;
                        case 'Right':
                            indentX = pageLeft + (cellWidth - width);
                            break;
                        case 'None':
                            indentX = pageLeft + horzPosition;
                            break;
                    }
                }
                break;
            case 'Column':
            case 'Margin':
                {
                    switch (horzAlignment) {
                        case 'Center':
                            indentX = marginLeft + (cellInnerWidth - width) / 2;
                            break;
                        case 'Left':
                            indentX = marginLeft;
                            break;
                        case 'Right':
                            indentX = marginLeft + (cellInnerWidth - width);
                            break;
                        case 'None':
                            indentX = marginLeft + horzPosition;
                            break;
                    }
                }
                break;
            default:
                {
                    indentX = marginLeft + horzPosition;
                }
                break;
        }
        return indentX;
    }
    updateTableFloatPoints(table) {
        if (table.wrapTextAround) {
            let tableTotalWidth = table.getTableCellWidth();
            let position = table.positioning;
            let sectionFormat = table.bodyWidget.sectionFormat;
            if (this.documentHelper.viewer instanceof WebLayoutViewer) {
                if (position.horizontalOrigin === 'Margin' || position.horizontalOrigin === 'Page' || position.horizontalOrigin === 'Column') {
                    if (position.horizontalAlignment === 'Right' || position.horizontalAlignment === 'Outside') {
                        this.viewer.clientActiveArea.x = this.viewer.clientArea.width - tableTotalWidth;
                    }
                    else {
                        this.viewer.clientActiveArea.x = this.viewer.clientArea.x;
                    }
                }
            }
            else {
                if (!(table.containerWidget instanceof TextFrame) && !table.isInsideTable) {
                    // Vertical position
                    if (position.verticalOrigin === 'Page') {
                        if (position.verticalAlignment === 'Top') {
                            this.viewer.clientActiveArea.y = 0;
                        }
                        else if (position.verticalAlignment === 'Inside') {
                            this.viewer.clientActiveArea.y = 0;
                        }
                        else if (isNullOrUndefined(position.verticalAlignment) || position.verticalAlignment === 'None') {
                            this.viewer.clientActiveArea.y = HelperMethods.convertPointToPixel(position.verticalPosition);
                        }
                    }
                    else if (position.verticalOrigin === 'Margin') {
                        if (position.verticalAlignment === 'Top') {
                            this.viewer.clientActiveArea.y = HelperMethods.convertPointToPixel(sectionFormat.topMargin);
                        }
                        else if (position.verticalAlignment === 'Inside') {
                            this.viewer.clientActiveArea.y = HelperMethods.convertPointToPixel(sectionFormat.topMargin);
                        }
                        else if (isNullOrUndefined(position.verticalAlignment)) {
                            this.viewer.clientActiveArea.y = (HelperMethods.convertPointToPixel(sectionFormat.topMargin) + HelperMethods.convertPointToPixel(position.verticalPosition));
                        }
                    }
                    else if (position.verticalOrigin === 'Paragraph') {
                        if (isNullOrUndefined(position.verticalAlignment)) {
                            this.viewer.clientActiveArea.y += HelperMethods.convertPointToPixel(position.verticalPosition);
                        }
                    }
                    if (position.horizontalOrigin === 'Page') {
                        if (position.horizontalAlignment === 'Left') {
                            this.viewer.clientActiveArea.x = 0;
                        }
                        else if (position.horizontalAlignment === 'Inside') {
                            // TODO
                            this.viewer.clientActiveArea.x = 0;
                        }
                        else if (position.horizontalAlignment === 'Right') {
                            this.viewer.clientActiveArea.x = HelperMethods.convertPointToPixel(sectionFormat.pageWidth) - tableTotalWidth;
                        }
                        else if (position.horizontalAlignment === 'Outside') {
                            // TODO
                            this.viewer.clientActiveArea.x = HelperMethods.convertPointToPixel(sectionFormat.pageWidth) - tableTotalWidth;
                        }
                    }
                    else if (position.horizontalOrigin === 'Margin' || position.horizontalOrigin === 'Column') {
                        if (position.horizontalAlignment === 'Left') {
                            this.viewer.clientActiveArea.x = HelperMethods.convertPointToPixel(sectionFormat.leftMargin);
                        }
                        else if (position.horizontalAlignment === 'Inside') {
                            // TODO
                            this.viewer.clientActiveArea.x = HelperMethods.convertPointToPixel(sectionFormat.leftMargin);
                        }
                        else if (position.horizontalAlignment === 'Right') {
                            this.viewer.clientActiveArea.x = HelperMethods.convertPointToPixel(sectionFormat.pageWidth)
                                - (HelperMethods.convertPointToPixel(sectionFormat.rightMargin) + tableTotalWidth);
                        }
                        else if (position.horizontalAlignment === 'Outside') {
                            // TODO
                            this.viewer.clientActiveArea.x = HelperMethods.convertPointToPixel(sectionFormat.pageWidth)
                                - (HelperMethods.convertPointToPixel(sectionFormat.rightMargin) + tableTotalWidth);
                        }
                    }
                    if (Math.round(position.horizontalPosition) > 0) {
                        this.viewer.clientActiveArea.x += HelperMethods.convertPointToPixel(position.horizontalPosition);
                    }
                    if (position.horizontalAlignment === 'Center') {
                        this.viewer.clientActiveArea.x = (HelperMethods.convertPointToPixel(sectionFormat.pageWidth) / 2) - (tableTotalWidth / 2);
                    }
                }
                else if (table.isInsideTable) {
                    let ownerCell = table.containerWidget;
                    let cellFormat = ownerCell.cellFormat;
                    if (position.verticalOrigin === 'Page') {
                        this.viewer.clientActiveArea.y = ownerCell.y;
                        this.viewer.clientActiveArea.y += HelperMethods.convertPointToPixel(position.verticalPosition);
                    }
                    else if (position.verticalOrigin === 'Margin') {
                        this.viewer.clientActiveArea.y = ownerCell.y;
                        this.viewer.clientActiveArea.y += ownerCell.topMargin;
                        this.viewer.clientActiveArea.y += HelperMethods.convertPointToPixel(position.verticalPosition);
                    }
                    else {
                        if (this.viewer.clientActiveArea.y + HelperMethods.convertPointToPixel(position.verticalPosition) < ownerCell.y) {
                            this.viewer.clientActiveArea.y = ownerCell.y;
                        }
                        else {
                            this.viewer.clientActiveArea.y += HelperMethods.convertPointToPixel(position.verticalPosition);
                        }
                    }
                    if (position.horizontalOrigin === 'Page') {
                        if (position.horizontalAlignment === 'Left' || position.horizontalAlignment === 'Inside') {
                            this.viewer.clientActiveArea.x = ownerCell.x;
                        }
                        else if (position.horizontalAlignment === 'Right' || position.horizontalAlignment === 'Outside') {
                            this.viewer.clientActiveArea.x = ((ownerCell.x + cellFormat.preferredWidth) - tableTotalWidth);
                        }
                    }
                    else if (position.horizontalOrigin === 'Margin' || position.horizontalOrigin === 'Column') {
                        if (position.horizontalAlignment === 'Left' || position.horizontalAlignment === 'Inside') {
                            this.viewer.clientActiveArea.x = (ownerCell.x + ownerCell.leftMargin);
                        }
                        else if (position.horizontalAlignment === 'Right' || position.horizontalAlignment === 'Outside') {
                            this.viewer.clientActiveArea.x = ((ownerCell.x + cellFormat.preferredWidth)
                                - (tableTotalWidth + ownerCell.rightMargin));
                        }
                    }
                    if (Math.round(position.horizontalPosition) > 0) {
                        this.viewer.clientActiveArea.x = ownerCell.x;
                        if (position.horizontalOrigin === 'Margin') {
                            this.viewer.clientActiveArea.x += ownerCell.leftMargin;
                        }
                        this.viewer.clientActiveArea.x += HelperMethods.convertPointToPixel(position.horizontalPosition);
                    }
                    if (position.horizontalAlignment === 'Center') {
                        this.viewer.clientActiveArea.x = (cellFormat.preferredWidth / 2) - (tableTotalWidth / 2);
                    }
                }
            }
        }
        table.x = this.viewer.clientActiveArea.x;
        table.y = this.viewer.clientActiveArea.y;
    }
    isTocField(element) {
        if (element instanceof FieldElementBox) {
            let nextElement = element.nextNode;
            if (element instanceof FieldElementBox && element.fieldType === 0 && nextElement instanceof TextElementBox
                && nextElement.text.trim().toLowerCase().indexOf('toc') !== -1) {
                return true;
            }
        }
        return false;
    }
    getTotalColumnSpan(row) {
        let tableRow = row;
        let totalColumnSpan = 0;
        for (let i = 0; i < tableRow.childWidgets.length; i++) {
            totalColumnSpan += tableRow.childWidgets[i].cellFormat.columnSpan;
        }
        return totalColumnSpan;
    }
    shiftFloatingItemsFromTable(table, bodyWidget) {
        if (table.containerWidget instanceof BodyWidget) {
            for (let i = 0; i < table.containerWidget.floatingElements.length; i++) {
                let shape = table.containerWidget.floatingElements[i];
                if (!(shape instanceof TableWidget) && shape.paragraph.containerWidget instanceof TableCellWidget
                    && shape.paragraph.containerWidget.ownerTable.containerWidget.ownerTable == table) {
                    bodyWidget.floatingElements.push(table.containerWidget.floatingElements[i]);
                    table.containerWidget.floatingElements.splice(table.containerWidget.floatingElements.indexOf(table.containerWidget.floatingElements[i]), 1);
                    this.shiftedFloatingItemsFromTable.push(shape);
                    i--;
                }
            }
        }
    }
}

/**
 * @private
 */
class Renderer {
    constructor(documentHelper) {
        this.isPrinting = false;
        this.pageLeft = 0;
        this.pageTop = 0;
        this.pageIndex = -1;
        this.isFieldCode = false;
        this.leftPosition = 0;
        this.topPosition = 0;
        this.height = 0;
        this.documentHelper = documentHelper;
    }
    get pageCanvas() {
        if (this.isPrinting) {
            if (isNullOrUndefined(this.pageCanvasIn)) {
                this.pageCanvasIn = document.createElement('canvas');
                this.pageCanvasIn.getContext('2d').save();
            }
            return this.pageCanvasIn;
        }
        return isNullOrUndefined(this.viewer) ? undefined : this.documentHelper.containerCanvas;
    }
    get spellChecker() {
        return this.documentHelper.owner.spellChecker;
    }
    get selectionCanvas() {
        return isNullOrUndefined(this.viewer) ? undefined : this.documentHelper.selectionCanvas;
    }
    get pageContext() {
        return this.pageCanvas.getContext('2d');
    }
    get selectionContext() {
        return this.selectionCanvas.getContext('2d');
    }
    get viewer() {
        return this.documentHelper.owner.viewer;
    }
    renderWidgets(page, left, top, width, height) {
        if (isNullOrUndefined(this.pageCanvas) || isNullOrUndefined(page)) {
            return;
        }
        this.pageContext.fillStyle = HelperMethods.getColor(this.documentHelper.backgroundColor);
        this.pageContext.beginPath();
        if (this.viewer instanceof WebLayoutViewer) {
            height = height > this.documentHelper.visibleBounds.height ? height : this.documentHelper.visibleBounds.height;
            let marginTop = top;
            if (page.index === 0) {
                marginTop = top - this.viewer.padding.top;
            }
            /* eslint-disable-next-line max-len */
            this.pageContext.fillRect(left - this.viewer.padding.left, marginTop, width + this.viewer.padding.left, height + this.viewer.padding.top);
        }
        else {
            this.pageContext.fillRect(left, top, width, height);
        }
        this.pageContext.closePath();
        if (this.viewer instanceof PageLayoutViewer) {
            this.pageContext.strokeStyle = this.documentHelper.owner.pageOutline;
            this.pageContext.strokeRect(left, top, width, height);
        }
        this.pageLeft = left;
        this.pageTop = top;
        this.pageIndex = page.index;
        if (this.isPrinting) {
            this.setPageSize(page);
        }
        else {
            this.pageContext.beginPath();
            this.pageContext.save();
            this.pageContext.rect(left, top, width, height);
            this.pageContext.clip();
        }
        this.height = height;
        if (page.headerWidget) {
            this.renderHFWidgets(page, page.headerWidgetIn, width, true);
        }
        if (page.footerWidget) {
            this.renderHFWidgets(page, page.footerWidgetIn, width, false);
        }
        for (let i = 0; i < page.bodyWidgets.length; i++) {
            this.render(page, page.bodyWidgets[i]);
            if (page.footnoteWidget && this.documentHelper.owner.layoutType === 'Pages') {
                this.renderfootNoteWidget(page, page.footnoteWidget);
            }
        }
        if (page.endnoteWidget && this.documentHelper.owner.layoutType === 'Pages') {
            this.renderfootNoteWidget(page, page.endnoteWidget);
        }
        if (this.documentHelper.owner.enableHeaderAndFooter && !this.isPrinting) {
            this.renderHeaderSeparator(page, this.pageLeft, this.pageTop, page.headerWidgetIn);
        }
        this.pageLeft = 0;
        this.pageTop = 0;
        this.pageContext.restore();
    }
    setPageSize(page) {
        this.pageContext.clearRect(0, 0, this.pageCanvas.width, this.pageCanvas.height);
        this.selectionContext.clearRect(0, 0, this.selectionCanvas.width, this.selectionCanvas.height);
        this.pageContext.restore();
        this.selectionContext.restore();
        const width = page.boundingRectangle.width;
        const height = page.boundingRectangle.height;
        const dpr = Math.max(window.devicePixelRatio, this.documentHelper.owner.documentEditorSettings.printDevicePixelRatio);
        if (this.pageCanvas.width !== width * dpr || this.pageCanvas.height !== height * dpr) {
            this.pageCanvas.height = height * dpr;
            this.pageCanvas.width = width * dpr;
            this.pageCanvas.style.height = height + 'px';
            this.pageCanvas.style.width = width + 'px';
            this.pageContext.globalAlpha = 1;
            this.pageContext.scale(dpr, dpr);
        }
        this.pageContext.fillStyle = '#FFFFFF';
        this.pageContext.fillRect(0, 0, this.pageCanvas.width, this.pageCanvas.height);
        this.pageContext.fillStyle = '#000000';
    }
    renderHFWidgets(page, widget, width, isHeader) {
        if (!this.isPrinting) {
            this.pageContext.globalAlpha = this.documentHelper.owner.enableHeaderAndFooter ? 1 : 0.65;
        }
        let cliped = false;
        let height = 0;
        let pageHt = 0;
        const headerFooterHeight = page.boundingRectangle.height / 100 * 40;
        if (isHeader) {
            const topMargin = HelperMethods.convertPointToPixel(page.bodyWidgets[0].sectionFormat.topMargin);
            const widgetHeight = Math.max((widget.y + widget.height), topMargin);
            if (widgetHeight > headerFooterHeight) {
                cliped = true;
                this.pageContext.beginPath();
                this.pageContext.save();
                this.pageContext.rect(this.pageLeft, this.pageTop, width, this.getScaledValue(headerFooterHeight));
                this.pageContext.clip();
            }
        }
        else {
            const footerDistance = HelperMethods.convertPointToPixel(page.bodyWidgets[0].sectionFormat.footerDistance);
            const footerHeight = page.boundingRectangle.height -
                /* eslint-disable-next-line max-len */
                Math.max(page.footerWidget.height + footerDistance, HelperMethods.convertPointToPixel(page.footerWidget.sectionFormat.bottomMargin));
            height = Math.max(page.boundingRectangle.height - headerFooterHeight, footerHeight);
            pageHt = page.boundingRectangle.height - footerDistance;
        }
        this.renderFloatingItems(page, widget.floatingElements, 'Behind');
        for (let i = 0; i < widget.childWidgets.length; i++) {
            const block = widget.childWidgets[i];
            if (!isHeader) {
                height += block.height;
            }
            if (isHeader || !isHeader && this.getScaledValue(Math.round(height)) <= this.getScaledValue(Math.round(pageHt))) {
                this.renderWidget(page, block);
            }
        }
        this.renderFloatingItems(page, widget.floatingElements, 'InFrontOfText');
        if (cliped) {
            this.pageContext.restore();
        }
        if (!this.isPrinting) {
            this.pageContext.globalAlpha = this.documentHelper.owner.enableHeaderAndFooter ? 0.65 : 1;
        }
    }
    renderHeaderSeparator(page, left, top, widget) {
        //Header Widget
        const topMargin = HelperMethods.convertPointToPixel(page.bodyWidgets[0].sectionFormat.topMargin);
        let y = this.getScaledValue(Math.max((widget.y + widget.height), topMargin));
        const pageWidth = this.getScaledValue(page.boundingRectangle.width);
        const ctx = this.pageContext;
        ctx.save();
        ctx.globalAlpha = 0.65;
        const headerFooterHeight = (this.getScaledValue(page.boundingRectangle.height) / 100) * 40;
        //Maximum header height limit
        y = Math.min(y, headerFooterHeight);
        //Dash line Separator
        this.renderDashLine(ctx, left, top + y, pageWidth, '#000000', false);
        let type = this.getHeaderFooterType(page, true);
        ctx.font = '9pt Arial';
        let width = ctx.measureText(type).width;
        this.renderHeaderFooterMark(ctx, left + 5, top + y, width + 10, 20);
        this.renderHeaderFooterMarkText(ctx, type, left + 10, y + top + 15);
        if (page.footerWidget) {
            //Footer Widget
            const footerDistance = HelperMethods.convertPointToPixel(page.bodyWidgets[0].sectionFormat.footerDistance);
            let footerHeight = this.getScaledValue(page.boundingRectangle.height) -
                /* eslint-disable-next-line max-len */
                this.getScaledValue(Math.max(page.footerWidget.height + footerDistance, HelperMethods.convertPointToPixel(page.footerWidget.sectionFormat.bottomMargin)));
            //Maximum footer height limit
            footerHeight = Math.max((this.getScaledValue(page.boundingRectangle.height) - headerFooterHeight), footerHeight);
            this.renderDashLine(ctx, left, top + footerHeight, pageWidth, '#000000', false);
            type = this.getHeaderFooterType(page, false);
            width = ctx.measureText(type).width;
            this.renderHeaderFooterMark(ctx, left + 5, top + footerHeight - 20, width + 10, 20);
            this.renderHeaderFooterMarkText(ctx, type, left + 10, top + footerHeight - 5);
            ctx.restore();
        }
    }
    getHeaderFooterType(page, isHeader) {
        let type;
        let l10n = new L10n('documenteditor', this.documentHelper.owner.defaultLocale);
        l10n.setLocale(this.documentHelper.owner.locale);
        type = isHeader ? l10n.getConstant('Header') : l10n.getConstant('Footer');
        if (page.bodyWidgets[0].sectionFormat.differentFirstPage &&
            (isNullOrUndefined(page.previousPage) || page.sectionIndex !== page.previousPage.sectionIndex)) {
            type = isHeader ? l10n.getConstant('First Page Header') : l10n.getConstant('First Page Footer');
        }
        else if (page.bodyWidgets[0].sectionFormat.differentOddAndEvenPages) {
            if ((this.documentHelper.pages.indexOf(page) + 1) % 2 === 0) {
                type = isHeader ? l10n.getConstant('Even Page Header') : l10n.getConstant('Even Page Footer');
            }
            else {
                type = isHeader ? l10n.getConstant('Odd Page Header') : l10n.getConstant('Odd Page Footer');
            }
        }
        return type;
    }
    /* eslint-disable-next-line max-len */
    renderDashLine(context, x, y, width, fillStyle, isSmallDash) {
        context.beginPath();
        context.strokeStyle = fillStyle;
        context.lineWidth = 1;
        if (isSmallDash) {
            context.setLineDash([3, 2]);
        }
        else {
            context.setLineDash([6, 4]);
        }
        context.moveTo(x, y);
        context.lineTo(x + width, y);
        context.stroke();
        context.setLineDash([]);
        context.closePath();
    }
    renderSolidLine(context, x, y, width, fillStyle) {
        context.beginPath();
        context.strokeStyle = fillStyle;
        context.lineWidth = 0.5;
        context.moveTo(x, y);
        context.lineTo(x + width, y);
        context.stroke();
        context.closePath();
    }
    renderHeaderFooterMark(ctx, x, y, w, h) {
        ctx.beginPath();
        ctx.fillStyle = 'lightgray';
        ctx.fillRect(x, y, w, h);
        ctx.strokeStyle = 'black';
        ctx.strokeRect(x, y, w, h);
        ctx.closePath();
    }
    renderHeaderFooterMarkText(ctx, content, x, y) {
        ctx.beginPath();
        ctx.fillStyle = '#000000';
        ctx.textBaseline = 'alphabetic';
        ctx.fillText(content, x, y);
        ctx.closePath();
    }
    render(page, bodyWidget) {
        if (this.isFieldCode) {
            this.isFieldCode = false;
        }
        this.renderFloatingItems(page, page.bodyWidgets[0].floatingElements, 'Behind');
        for (let i = 0; i < bodyWidget.childWidgets.length; i++) {
            const widget = bodyWidget.childWidgets[i];
            if (i === 0 && bodyWidget.childWidgets[0] instanceof TableWidget &&
                (bodyWidget.childWidgets[0].childWidgets.length > 0) &&
                page.repeatHeaderRowTableWidget) {
                /* eslint-disable-next-line max-len */
                this.renderHeader(page, widget, this.documentHelper.layout.getHeader(bodyWidget.childWidgets[0]));
            }
            this.renderWidget(page, widget);
        }
        this.renderFloatingItems(page, page.bodyWidgets[0].floatingElements, 'InFrontOfText');
    }
    renderFloatingItems(page, floatingElements, wrappingType) {
        if (!isNullOrUndefined(floatingElements) && floatingElements.length > 0) {
            /* eslint-disable */
            floatingElements.sort(function (a, b) {
                if (a instanceof TableWidget || b instanceof TableWidget) {
                    return 0;
                }
                else {
                    return a.zOrderPosition - b.zOrderPosition;
                }
            });
            for (let i = 0; i < floatingElements.length; i++) {
                if (floatingElements[i] instanceof TableWidget) {
                    continue;
                }
                let shape = floatingElements[i];
                if ((wrappingType === "Behind" && shape.textWrappingStyle !== "Behind") ||
                    (wrappingType !== "Behind" && shape.textWrappingStyle === "Behind")) {
                    continue;
                }
                if (shape instanceof ImageElementBox) {
                    this.renderImageElementBox(shape, shape.x, shape.y, 0);
                }
                else if (shape instanceof ShapeElementBox) {
                    let shapeLeft = this.getScaledValue(shape.x, 1);
                    let shapeTop = this.getScaledValue(shape.y, 2);
                    this.renderShapeElementBox(shape, shapeLeft, shapeTop, page);
                }
            }
        }
    }
    renderShapeElementBox(shape, shapeLeft, shapeTop, page) {
        let isZeroShapeHeight = (shape.height === 0) ? true : false;
        let shapeType = shape.autoShapeType;
        let blocks = shape.textFrame.childWidgets;
        this.pageContext.beginPath();
        if (shape.fillFormat && shape.fillFormat.color && shape.fillFormat.fill) {
            this.pageContext.fillStyle = shape.fillFormat.color;
            this.pageContext.fillRect(shapeLeft, shapeTop, this.getScaledValue(shape.width), this.getScaledValue(shape.height));
        }
        if (!isNullOrUndefined(shapeType)) {
            if ((shape.lineFormat.line && shape.lineFormat.lineFormatType !== 'None') || (!isNullOrUndefined(shape.lineFormat.lineFormatType) && shape.lineFormat.lineFormatType !== 'None')) {
                this.pageContext.lineWidth = shape.lineFormat.weight;
                this.pageContext.strokeStyle = HelperMethods.getColor(shape.lineFormat.color);
                this.pageContext.strokeRect(shapeLeft, shapeTop, this.getScaledValue(shape.width), this.getScaledValue(shape.height));
            }
        }
        this.pageContext.closePath();
        let isClipped = false;
        if (shape.width != 0 && shape.height != 0) {
            isClipped = true;
            this.clipRect(shape.x, shape.y, this.getScaledValue(shape.width), this.getScaledValue(shape.height));
        }
        for (let i = 0; i < blocks.length; i++) {
            this.renderWidget(page, blocks[i]);
            if (isZeroShapeHeight && shapeType !== 'StraightConnector') {
                shape.height += blocks[i].height;
            }
        }
        if (isZeroShapeHeight) {
            isZeroShapeHeight = false;
        }
        if (isClipped) {
            this.pageContext.restore();
        }
    }
    renderWidget(page, widget) {
        if (this.documentHelper.owner.enableLockAndEdit) {
            this.renderLockRegionBorder(page, widget);
        }
        if (widget instanceof ParagraphWidget) {
            this.renderParagraphWidget(page, widget);
        }
        else {
            this.renderTableWidget(page, widget);
        }
    }
    renderLockRegionBorder(page, widget) {
        if (!widget.isInsideTable && widget instanceof BlockWidget && widget.locked) {
            let settinsModel = this.documentHelper.owner.documentEditorSettings.collaborativeEditingSettings;
            let sectionFormat = page.bodyWidgets[0].sectionFormat;
            let leftPosition = HelperMethods.convertPointToPixel(sectionFormat.leftMargin) - 5;
            let pageWidth = sectionFormat.pageWidth - sectionFormat.leftMargin - sectionFormat.rightMargin;
            pageWidth = HelperMethods.convertPointToPixel(pageWidth) + 10;
            if (this.viewer instanceof WebLayoutViewer) {
                leftPosition = widget.x - 5;
                pageWidth = (this.documentHelper.visibleBounds.width - (this.viewer.padding.right * 5)) / this.documentHelper.zoomFactor;
            }
            let previousWidget = widget.previousRenderedWidget;
            let nextWidget = widget.nextRenderedWidget;
            let color = widget.lockedBy === this.documentHelper.owner.currentUser ? settinsModel.editableRegionColor : settinsModel.lockedRegionColor;
            let topPosition = widget.y;
            let height = widget.y + widget.height;
            //Left border
            this.renderSingleBorder(color, leftPosition, topPosition, leftPosition, height, 1);
            //Top border
            if (isNullOrUndefined(previousWidget) || !previousWidget.locked || widget.lockedBy !== previousWidget.lockedBy) {
                this.renderSingleBorder(color, leftPosition, topPosition, leftPosition + pageWidth, topPosition, 1);
            }
            //Right border
            this.renderSingleBorder(color, leftPosition + pageWidth, topPosition, leftPosition + pageWidth, height, 1);
            if (isNullOrUndefined(nextWidget) || !nextWidget.locked || widget.lockedBy !== nextWidget.lockedBy) {
                // Bottom border
                this.renderSingleBorder(color, leftPosition, height, leftPosition + pageWidth, height, 1);
            }
        }
    }
    renderHeader(page, widget, header) {
        if (isNullOrUndefined(header)) {
            return;
        }
        //Updated client area for current page
        page.viewer.updateClientArea(page.bodyWidgets[0].sectionFormat, page);
        let top = page.viewer.clientArea.y;
        let parentTable = header.ownerTable.getSplitWidgets()[0];
        for (let i = 0; i <= header.rowIndex; i++) {
            if (parentTable.childWidgets.length === 0) {
                return;
            }
            let row = parentTable.childWidgets[i];
            if (widget.childWidgets.indexOf(row) !== -1) {
                continue;
            }
            let headerWidget = row.clone();
            headerWidget.containerWidget = row.containerWidget;
            page.viewer.updateClientAreaLocation(headerWidget, new Rect(page.viewer.clientArea.x, top, headerWidget.width, headerWidget.height));
            page.documentHelper.layout.updateChildLocationForRow(top, headerWidget);
            let cell = undefined;
            //Renders table cell outline rectangle - Border and background color.
            for (let j = 0; j < headerWidget.childWidgets.length; j++) {
                cell = headerWidget.childWidgets[j];
                this.renderTableCellWidget(page, cell);
            }
            top += headerWidget.height;
        }
        if (widget.y !== top) {
            //this.Location.Y = top;
            page.documentHelper.layout.updateChildLocationForTable(top, widget);
        }
    }
    renderParagraphWidget(page, paraWidget) {
        let top = paraWidget.y;
        let left = paraWidget.x;
        for (let i = 0; i < paraWidget.childWidgets.length; i++) {
            let widget = paraWidget.childWidgets[i];
            top += widget.marginTop;
            this.renderLine(widget, page, left, top);
            top += widget.height;
        }
    }
    renderfootNoteWidget(page, footnote) {
        let isEmptyPage = footnote.page.bodyWidgets.length === 1 && ((footnote.page.bodyWidgets[0].childWidgets.length === 1
            && footnote.page.bodyWidgets[0].childWidgets[0].isEmpty()) || footnote.page.bodyWidgets[0].childWidgets.length === 0);
        for (let i = 0; i < footnote.bodyWidgets.length; i++) {
            let bodyWidget = footnote.bodyWidgets[i];
            let footNoteReference = bodyWidget.footNoteReference;
            for (let j = 0; j < bodyWidget.childWidgets.length; j++) {
                let widget = bodyWidget.childWidgets[j];
                if (i === 0 && j === 0) {
                    let ctx = this.pageContext;
                    this.renderSolidLine(ctx, this.getScaledValue(96, 1), this.getScaledValue(footnote.y + (footnote.margin.top / 2) + 1, 2), (isEmptyPage ? 624 : 210) * this.documentHelper.zoomFactor, '#000000');
                }
                if (j === 0 && !isNullOrUndefined(footNoteReference) && widget.index === 0 && widget.childWidgets[0].children[0] instanceof TextElementBox && !this.documentHelper.owner.editor.isFootNoteInsert) {
                    //if (j < 1 || (j > 0 && widget.footNoteReference !== (bodyWidget.childWidgets[j - 1] as BlockWidget).footNoteReference)) {
                    widget.childWidgets[0].children[0].text = widget.childWidgets[0].children[0].text.replace(widget.childWidgets[0].children[0].text, footNoteReference.text);
                    //}
                }
                this.renderWidget(page, widget);
            }
        }
    }
    renderTableWidget(page, tableWidget) {
        if (this.isFieldCode) {
            return;
        }
        for (let i = 0; i < tableWidget.childWidgets.length; i++) {
            let widget = tableWidget.childWidgets[i];
            this.renderTableRowWidget(page, widget);
            if (tableWidget.tableFormat.cellSpacing > 0) {
                this.renderTableOutline(tableWidget);
            }
        }
    }
    renderTableRowWidget(page, rowWidget) {
        for (let i = 0; i < rowWidget.childWidgets.length; i++) {
            let widget = rowWidget.childWidgets[i];
            this.renderTableCellWidget(page, widget);
        }
    }
    renderTableCellWidget(page, cellWidget) {
        if (!this.isPrinting) {
            if (this.getScaledValue(cellWidget.y, 2) + cellWidget.height * this.documentHelper.zoomFactor < 0 ||
                this.getScaledValue(cellWidget.y, 2) > this.documentHelper.visibleBounds.height) {
                return;
            }
        }
        this.renderSelectionHighlightOnTable(page, cellWidget);
        this.renderTableCellOutline(page.documentHelper, cellWidget);
        for (let i = 0; i < cellWidget.childWidgets.length; i++) {
            let widget = cellWidget.childWidgets[i];
            // MS word render the content in right margin also.
            // So, we need to add right margin value while cliping the content
            let width = (cellWidget.width + cellWidget.margin.left + cellWidget.margin.right) - cellWidget.leftBorderWidth;
            if (!this.isPrinting) {
                this.clipRect(cellWidget.x - cellWidget.margin.left, cellWidget.y, this.getScaledValue(width), this.getScaledValue(this.height));
            }
            this.renderWidget(page, widget);
            this.pageContext.restore();
        }
    }
    checkHeaderFooterLineWidget(widget, keys) {
        let headerFooter;
        if (widget instanceof LineWidget) {
            headerFooter = widget.paragraph.bodyWidget;
        }
        else if (widget instanceof TableCellWidget) {
            headerFooter = widget.bodyWidget;
        }
        if (!isNullOrUndefined(headerFooter.parentHeaderFooter)) {
            headerFooter = headerFooter.parentHeaderFooter;
            for (let j = 0; j < keys.length; j++) {
                let selectedWidget = keys[j];
                if (selectedWidget instanceof LineWidget && widget instanceof LineWidget) {
                    let parentIndex = selectedWidget.getHierarchicalIndex('');
                    let currentLineIndex = widget.getHierarchicalIndex('');
                    if (selectedWidget.paragraph.isInHeaderFooter && headerFooter === selectedWidget.paragraph.bodyWidget
                        && parentIndex.substring(parentIndex.indexOf(';')) === currentLineIndex.substring(currentLineIndex.indexOf(';'))) {
                        return selectedWidget;
                    }
                }
                else if (selectedWidget instanceof TableCellWidget && widget instanceof TableCellWidget) {
                    let parentIndex = selectedWidget.getHierarchicalIndex('');
                    let currentLineIndex = widget.getHierarchicalIndex('');
                    if (selectedWidget.ownerTable.isInHeaderFooter && headerFooter === selectedWidget.ownerTable.bodyWidget
                        && parentIndex.substring(parentIndex.indexOf(';')) === currentLineIndex.substring(currentLineIndex.indexOf(';'))) {
                        return selectedWidget;
                    }
                }
            }
        }
        return undefined;
    }
    renderEditRegionHighlight(page, lineWidget, top) {
        if (page.documentHelper.selection && !isNullOrUndefined(page.documentHelper.selection.editRegionHighlighters)) {
            let renderHighlight = page.documentHelper.selection.editRegionHighlighters.containsKey(lineWidget);
            if (!renderHighlight && lineWidget.paragraph.isInHeaderFooter) {
                let keys = page.documentHelper.selection.editRegionHighlighters.keys;
                lineWidget = this.checkHeaderFooterLineWidget(lineWidget, keys);
                if (!isNullOrUndefined(lineWidget)) {
                    renderHighlight = true;
                }
            }
            if (renderHighlight) {
                let widgetInfo = page.documentHelper.selection.editRegionHighlighters.get(lineWidget);
                for (let i = 0; i < widgetInfo.length; i++) {
                    this.pageContext.fillStyle = widgetInfo[i].color !== '' ? widgetInfo[i].color : '#add8e6';
                    this.pageContext.fillRect(this.getScaledValue(widgetInfo[i].left, 1), this.getScaledValue(top, 2), this.getScaledValue(widgetInfo[i].width), this.getScaledValue(lineWidget.height));
                }
            }
        }
    }
    renderSearchHighlight(page, lineWidget, top) {
        if (this.documentHelper.owner.searchModule && !isNullOrUndefined(page.documentHelper.owner.searchModule.searchHighlighters)) {
            let renderHighlight = page.documentHelper.owner.searchModule.searchHighlighters.containsKey(lineWidget);
            if (!renderHighlight && lineWidget.paragraph.isInHeaderFooter) {
                let keys = page.documentHelper.owner.searchModule.searchHighlighters.keys;
                lineWidget = this.checkHeaderFooterLineWidget(lineWidget, keys);
                if (!isNullOrUndefined(lineWidget)) {
                    renderHighlight = true;
                }
            }
            if (renderHighlight) {
                let widgetInfo = page.documentHelper.owner.searchModule.searchHighlighters.get(lineWidget);
                for (let i = 0; i < widgetInfo.length; i++) {
                    this.pageContext.fillStyle = this.viewer.owner.documentEditorSettings.searchHighlightColor;
                    this.pageContext.fillRect(this.getScaledValue(widgetInfo[i].left, 1), this.getScaledValue(top, 2), this.getScaledValue(widgetInfo[i].width), this.getScaledValue(lineWidget.height));
                }
            }
        }
    }
    renderSelectionHighlight(page, lineWidget, top) {
        if (!this.isPrinting && page.documentHelper.owner.selection && !this.documentHelper.isScrollToSpellCheck && page.documentHelper.owner.selection.selectedWidgets.length > 0) {
            let renderHighlight = page.documentHelper.owner.selection.selectedWidgets.containsKey(lineWidget);
            if (!renderHighlight && lineWidget.paragraph.isInHeaderFooter) {
                let keys = page.documentHelper.owner.selection.selectedWidgets.keys;
                lineWidget = this.checkHeaderFooterLineWidget(lineWidget, keys);
                if (!isNullOrUndefined(lineWidget)) {
                    renderHighlight = true;
                }
            }
            if (renderHighlight) {
                page.documentHelper.owner.selection.addSelectionHighlight(this.selectionContext, lineWidget, top, page);
            }
        }
    }
    renderSelectionHighlightOnTable(page, cellWidget) {
        if (!this.isPrinting && page.documentHelper.owner.selection && page.documentHelper.owner.selection.selectedWidgets.length > 0) {
            let renderHighlight = page.documentHelper.owner.selection.selectedWidgets.containsKey(cellWidget);
            if (!renderHighlight && cellWidget.ownerTable.isInHeaderFooter) {
                let keys = page.documentHelper.owner.selection.selectedWidgets.keys;
                cellWidget = this.checkHeaderFooterLineWidget(cellWidget, keys);
                if (!isNullOrUndefined(cellWidget)) {
                    renderHighlight = true;
                }
            }
            if (renderHighlight) {
                page.documentHelper.owner.selection.addSelectionHighlightTable(this.selectionContext, cellWidget, page);
            }
        }
    }
    isTOC(para) {
        for (let i = 0; i < para.childWidgets[0].children.length; i++) {
            let element = para.childWidgets[0].children[i];
            if (element instanceof FieldElementBox && !isNullOrUndefined(element.fieldSeparator) && !isNullOrUndefined(element.fieldSeparator.previousElement) && element.fieldSeparator.previousElement instanceof TextElementBox) {
                let textElementBox = element.fieldSeparator.previousElement;
                let fieldCode = textElementBox.text;
                if (fieldCode.match('TOC ') || fieldCode.match('Toc')) {
                    return true;
                }
            }
            else {
                continue;
            }
        }
        return false;
    }
    renderLine(lineWidget, page, left, top) {
        let isTOCHeading = false;
        this.renderSelectionHighlight(page, lineWidget, top);
        let paraFormat = lineWidget.paragraph.paragraphFormat;
        if (!isNullOrUndefined(lineWidget.paragraph.nextRenderedWidget)) {
            let para = lineWidget.paragraph.nextRenderedWidget;
            if (para.childWidgets[0] instanceof LineWidget && para.childWidgets[0].children.length != 0) {
                isTOCHeading = this.isTOC(para);
            }
        }
        if (lineWidget.isFirstLine() && !paraFormat.bidi && !isTOCHeading) {
            left += HelperMethods.convertPointToPixel(paraFormat.firstLineIndent);
        }
        if (this.documentHelper && this.documentHelper.selection && !isNullOrUndefined(this.documentHelper.selection.formFieldHighlighters)
            && this.documentHelper.selection.formFieldHighlighters.containsKey(lineWidget)) {
            if (this.documentHelper.owner.documentEditorSettings
                && this.documentHelper.owner.documentEditorSettings.formFieldSettings.applyShading) {
                let widgetInfo = page.documentHelper.selection.formFieldHighlighters.get(lineWidget);
                for (let i = 0; i < widgetInfo.length; i++) {
                    this.pageContext.fillStyle = this.documentHelper.owner.documentEditorSettings.formFieldSettings.shadingColor;
                    let height = lineWidget.height;
                    let isAltered = false;
                    let isLastLine = lineWidget.isLastLine();
                    if (isLastLine) {
                        height = height - HelperMethods.convertPointToPixel(this.documentHelper.layout.getAfterSpacing(lineWidget.paragraph));
                        if (lineWidget.paragraph.paragraphFormat.lineSpacing > 1) {
                            let formField = this.getFormfieldInLine(lineWidget);
                            if (!isNullOrUndefined(formField)) {
                                const sizeInfo = this.documentHelper.textHelper.getHeight(formField.characterFormat);
                                let maxHeight = sizeInfo.Height;
                                if (lineWidget.paragraph.paragraphFormat.lineSpacingType === 'Multiple') {
                                    height = height - HelperMethods.convertPointToPixel(this.documentHelper.layout.getLineSpacing(lineWidget.paragraph, maxHeight, true));
                                }
                                else {
                                    top = top + HelperMethods.convertPointToPixel(lineWidget.paragraph.paragraphFormat.beforeSpacing);
                                    height = sizeInfo.Height;
                                    isAltered = true;
                                }
                            }
                        }
                    }
                    this.pageContext.fillRect(this.getScaledValue(widgetInfo[i].left, 1), this.getScaledValue(top, 2), this.getScaledValue(widgetInfo[i].width), this.getScaledValue(height));
                    if (isAltered) {
                        isAltered = false;
                        top = top - HelperMethods.convertPointToPixel(lineWidget.paragraph.paragraphFormat.beforeSpacing);
                    }
                }
            }
        }
        // Render search highlight
        this.renderSearchHighlight(page, lineWidget, top);
        // EditRegion highlight 
        this.renderEditRegionHighlight(page, lineWidget, top);
        let isCommentMark = false;
        for (let i = 0; i < lineWidget.children.length; i++) {
            let elementBox = lineWidget.children[i];
            if (elementBox instanceof ShapeBase && elementBox.textWrappingStyle !== 'Inline') {
                continue;
            }
            if (elementBox instanceof CommentCharacterElementBox || elementBox instanceof EditRangeStartElementBox) {
                let pageGap = 0;
                if (this.viewer instanceof PageLayoutViewer) {
                    pageGap = this.viewer.pageGap;
                }
                let style = 'display:block;position:absolute;';
                let topPosition = this.getScaledValue((top - 10) + (page.boundingRectangle.y -
                    (pageGap * (page.index + 1)))) + (pageGap * (page.index + 1)) + 'px;';
                if (elementBox instanceof EditRangeStartElementBox) {
                    if (this.documentHelper.owner.enableLockAndEdit) {
                        let l10n = new L10n('documenteditor', this.documentHelper.owner.defaultLocale);
                        l10n.setLocale(this.documentHelper.owner.locale);
                        elementBox.renderLockMark(this.documentHelper.owner.currentUser, l10n);
                        let settings = this.documentHelper.owner.documentEditorSettings.collaborativeEditingSettings;
                        let color = elementBox.user === this.documentHelper.owner.currentUser ? settings.editableRegionColor : settings.lockedRegionColor;
                        style += `color:${color};`;
                        let leftMargin = HelperMethods.convertPointToPixel(page.bodyWidgets[0].sectionFormat.leftMargin);
                        let leftPosition = page.boundingRectangle.x + this.getScaledValue(leftMargin - 20) + 'px;';
                        if (this.viewer instanceof WebLayoutViewer) {
                            leftPosition = lineWidget.paragraph.x - 5 + 'px;';
                        }
                        style = style + 'left:' + leftPosition + 'top:' + topPosition;
                        elementBox.editRangeMark.setAttribute('style', style);
                    }
                    else {
                        if (elementBox.editRangeMark) {
                            elementBox.editRangeMark.setAttribute('style', 'display:none');
                        }
                    }
                }
                else if (elementBox instanceof CommentCharacterElementBox &&
                    elementBox.commentType === 0 && this.documentHelper.owner.selectionModule) {
                    if (this.documentHelper.owner.enableComment && !isCommentMark) {
                        isCommentMark = true;
                        elementBox.renderCommentMark();
                        let rightMargin = HelperMethods.convertPointToPixel(page.bodyWidgets[0].sectionFormat.rightMargin);
                        let pageWidth = HelperMethods.convertPointToPixel(page.bodyWidgets[0].sectionFormat.pageWidth);
                        let leftPosition = page.boundingRectangle.x + this.getScaledValue((pageWidth - rightMargin) + (rightMargin / 4)) + 'px;';
                        if (this.viewer instanceof WebLayoutViewer) {
                            leftPosition = (page.boundingRectangle.width - (this.viewer.padding.right * 2) - (this.viewer.padding.left * 2)) + 'px;';
                        }
                        style = style + 'left:' + leftPosition + 'top:' + topPosition;
                        elementBox.commentMark.setAttribute('style', style);
                    }
                    else {
                        if (elementBox.commentMark) {
                            elementBox.commentMark.setAttribute('style', 'display:none');
                        }
                    }
                }
            }
            if (elementBox instanceof FieldElementBox || this.isFieldCode ||
                (elementBox.width === 0 && elementBox.height === 0)) {
                if (this.isFieldCode) {
                    elementBox.width = 0;
                }
                left += elementBox.width + elementBox.margin.left;
                this.toSkipFieldCode(elementBox);
                continue;
            }
            let underlineY = this.getUnderlineYPosition(lineWidget);
            if (!this.isPrinting) {
                if (this.getScaledValue(top + elementBox.margin.top, 2) + elementBox.height * this.documentHelper.zoomFactor < 0 ||
                    this.getScaledValue(top + elementBox.margin.top, 2) > this.documentHelper.visibleBounds.height) {
                    left += elementBox.width + elementBox.margin.left;
                    if (elementBox instanceof TextElementBox) {
                        elementBox.canTrigger = true;
                        elementBox.isVisible = false;
                        if (!elementBox.isSpellChecked || elementBox.line.paragraph.isChangeDetected) {
                            elementBox.ischangeDetected = true;
                        }
                    }
                    continue;
                }
            }
            if (elementBox instanceof ListTextElementBox) {
                this.renderListTextElementBox(elementBox, left, top, underlineY);
            }
            else if (elementBox instanceof ImageElementBox) {
                this.renderImageElementBox(elementBox, left, top, underlineY);
            }
            else if (elementBox instanceof ShapeElementBox) {
                let shapeLeft = this.getScaledValue(left, 1);
                let shapeTop = this.getScaledValue(top, 2);
                this.renderShapeElementBox(elementBox, shapeLeft, shapeTop, page);
            }
            else {
                elementBox.isVisible = true;
                left += elementBox.padding.left;
                this.renderTextElementBox(elementBox, left, top, underlineY);
            }
            left += elementBox.width + elementBox.margin.left;
        }
    }
    toSkipFieldCode(element) {
        if (element instanceof FieldElementBox) {
            if (element.fieldType === 0) {
                if ((!isNullOrUndefined(element.fieldEnd) || element.hasFieldEnd)) {
                    this.isFieldCode = true;
                }
            }
            else if (element.fieldType === 2 || element.fieldType === 1) {
                this.isFieldCode = false;
            }
        }
    }
    getUnderlineYPosition(lineWidget) {
        let height = 0;
        let lineHeight = 0;
        for (let i = 0; i < lineWidget.children.length; i++) {
            if (lineWidget.children[i] instanceof FieldElementBox ||
                (lineWidget.children[i].width === 0 && lineWidget.children[i].height === 0)) {
                continue;
            }
            if (lineWidget.children[i] instanceof ShapeElementBox) {
                continue;
            }
            else {
                if (height < lineWidget.children[i].height + lineWidget.children[i].margin.top) {
                    height = lineWidget.children[i].margin.top + lineWidget.children[i].height;
                    lineHeight = (lineWidget.children[i] instanceof ImageElementBox) ? 0.9 : lineWidget.children[i].height / 20;
                }
            }
        }
        return height - 2 * lineHeight;
    }
    renderListTextElementBox(elementBox, left, top, underlineY) {
        let topMargin = elementBox.margin.top;
        let leftMargin = elementBox.margin.left;
        let format = elementBox.listLevel.characterFormat;
        let breakCharacterFormat = elementBox.line.paragraph.characterFormat;
        let color = format.hasValue('fontColor') ? format.fontColor : breakCharacterFormat.fontColor;
        this.pageContext.textBaseline = 'alphabetic';
        let bold = '';
        let italic = '';
        let fontFamily = format.hasValue('fontFamily') ? format.fontFamily : breakCharacterFormat.fontFamily;
        if (this.documentHelper.isIosDevice && (elementBox.text === String.fromCharCode(9679) || elementBox.text === String.fromCharCode(9675))) {
            fontFamily = '';
        }
        let fontSize = format.hasValue('fontSize') ? format.fontSize : breakCharacterFormat.fontSize;
        let baselineAlignment = format.hasValue('baselineAlignment') ? format.baselineAlignment : breakCharacterFormat.baselineAlignment;
        bold = format.hasValue('bold') ? format.bold ? 'bold' : '' : breakCharacterFormat.bold ? 'bold' : '';
        italic = format.hasValue('italic') ? format.italic ? 'italic' : '' : breakCharacterFormat.italic ? 'italic' : '';
        fontSize = fontSize === 0 ? 0.5 : fontSize / (baselineAlignment === 'Normal' ? 1 : 1.5);
        fontSize = this.isPrinting ? fontSize : fontSize * this.documentHelper.zoomFactor;
        let strikethrough = format.hasValue('strikethrough') ? format.strikethrough : breakCharacterFormat.strikethrough;
        let highlightColor = format.hasValue('highlightColor') ? format.highlightColor : breakCharacterFormat.highlightColor;
        if (highlightColor !== 'NoColor') {
            if (highlightColor.substring(0, 1) !== '#') {
                this.pageContext.fillStyle = HelperMethods.getHighlightColorCode(highlightColor);
            }
            else {
                this.pageContext.fillStyle = HelperMethods.getColor(highlightColor);
            }
            this.pageContext.fillRect(this.getScaledValue(left + leftMargin, 1), this.getScaledValue(top + topMargin, 2), this.getScaledValue(elementBox.width), this.getScaledValue(elementBox.height));
        }
        this.pageContext.font = bold + ' ' + italic + ' ' + fontSize + 'pt' + ' ' + '"' + fontFamily + '"';
        if (baselineAlignment === 'Subscript') {
            topMargin += elementBox.height - elementBox.height / 1.5;
        }
        let baselineOffset = elementBox.baselineOffset;
        topMargin = (format.baselineAlignment === 'Normal') ? topMargin + baselineOffset : (topMargin + (baselineOffset / 1.5));
        let text = elementBox.text;
        let followCharacter = text === '\t' || text === ' ';
        if (!followCharacter && (format.bidi || elementBox.line.paragraph.paragraphFormat.bidi)) {
            let index = text.indexOf('.');
            text = text.substr(index) + text.substring(0, index);
        }
        // "empty" is old value used for auto color till v19.2.49. It is maintained for backward compatibility.
        if (color === "empty" || color === '#00000000') {
            let bgColor = this.getBackgroundColorHeirachy(elementBox);
            this.pageContext.fillStyle = this.getDefaultFontColor(bgColor);
        }
        else {
            this.pageContext.fillStyle = HelperMethods.getColor(color);
        }
        this.pageContext.fillText(text, this.getScaledValue(left + leftMargin, 1), this.getScaledValue(top + topMargin, 2), this.getScaledValue(elementBox.width));
        if (format.underline !== 'None' && !isNullOrUndefined(format.underline)) {
            this.renderUnderline(elementBox, left, top, underlineY, color, format.underline, baselineAlignment);
        }
        if (strikethrough !== 'None') {
            this.renderStrikeThrough(elementBox, left, top, format.strikethrough, color, baselineAlignment);
        }
    }
    getDefaultFontColor(backColor) {
        if (HelperMethods.isVeryDark(backColor)) {
            return "#FFFFFF";
        }
        else {
            return "#000000";
        }
    }
    renderTextElementBox(elementBox, left, top, underlineY) {
        let isHeightType = false;
        let containerWidget = elementBox.line.paragraph.containerWidget;
        if (containerWidget instanceof TableCellWidget) {
            isHeightType = (containerWidget.ownerRow.rowFormat.heightType === 'Exactly');
        }
        let topMargin = elementBox.margin.top;
        let leftMargin = elementBox.margin.left;
        if (isHeightType && containerWidget instanceof TableCellWidget) {
            let width = (containerWidget.width + containerWidget.margin.left + containerWidget.margin.right) - containerWidget.leftBorderWidth;
            this.clipRect(containerWidget.x - containerWidget.margin.left, containerWidget.y, this.getScaledValue(width), this.getScaledValue(containerWidget.height));
        }
        let format = elementBox.characterFormat;
        if (format.highlightColor !== 'NoColor') {
            if (format.highlightColor.substring(0, 1) !== '#') {
                this.pageContext.fillStyle = HelperMethods.getHighlightColorCode(format.highlightColor);
            }
            else {
                this.pageContext.fillStyle = HelperMethods.getColor(format.highlightColor);
            }
            this.pageContext.fillRect(this.getScaledValue(left + leftMargin, 1), this.getScaledValue(top + topMargin, 2), this.getScaledValue(elementBox.width), this.getScaledValue(elementBox.height));
        }
        let revisionInfo = this.checkRevisionType(elementBox);
        let color = revisionInfo.length > 0 ? this.getRevisionColor(revisionInfo) : format.fontColor;
        this.pageContext.textBaseline = 'alphabetic';
        let bold = '';
        let italic = '';
        let fontSize = 11;
        bold = format.bold ? 'bold' : '';
        italic = format.italic ? 'italic' : '';
        fontSize = format.fontSize === 0 ? 0.5 : format.fontSize / (format.baselineAlignment === 'Normal' ? 1 : 1.5);
        fontSize = this.isPrinting ? fontSize : fontSize * this.documentHelper.zoomFactor;
        this.pageContext.font = bold + ' ' + italic + ' ' + fontSize + 'pt' + ' ' + '"' + format.fontFamily + '"';
        if (format.baselineAlignment === 'Subscript') {
            topMargin += elementBox.height - elementBox.height / 1.5;
        }
        let baselineOffset = elementBox.baselineOffset;
        topMargin = (format.baselineAlignment === 'Normal') ? topMargin + baselineOffset : (topMargin + (baselineOffset / 1.5));
        // "empty" is old value used for auto color till v19.2.49. It is maintained for backward compatibility.
        if (color === "empty" || color === '#00000000') {
            let bgColor = this.getBackgroundColorHeirachy(elementBox);
            this.pageContext.fillStyle = this.getDefaultFontColor(bgColor);
        }
        else {
            this.pageContext.fillStyle = HelperMethods.getColor(color);
        }
        let scaledWidth = this.getScaledValue(elementBox.width);
        let text = elementBox.text;
        if (elementBox instanceof TabElementBox) {
            let tabElement = elementBox;
            if (tabElement.tabText === '' && !isNullOrUndefined(tabElement.tabLeader) && tabElement.tabLeader !== 'None') {
                text = this.getTabLeader(elementBox);
                tabElement.tabText = text;
            }
            else if (tabElement.tabText !== '') {
                text = tabElement.tabText;
            }
        }
        let isRTL = format.bidi || this.documentHelper.textHelper.isRTLText(elementBox.text);
        text = this.documentHelper.textHelper.setText(text, isRTL, format.bdo, true);
        if (format.allCaps) {
            text = text.toUpperCase();
        }
        this.pageContext.fillText(text, this.getScaledValue(left + leftMargin, 1), this.getScaledValue(top + topMargin, 2), scaledWidth);
        if (((this.documentHelper.owner.isSpellCheck && !this.spellChecker.removeUnderline) && (this.documentHelper.triggerSpellCheck || elementBox.canTrigger) && elementBox.text !== ' ' && !this.documentHelper.isScrollHandler && (isNullOrUndefined(elementBox.previousNode) || !(elementBox.previousNode instanceof FieldElementBox))
            && (!this.documentHelper.selection.isSelectionInsideElement(elementBox) || this.documentHelper.triggerElementsOnLoading || this.documentHelper.owner.editor.triggerPageSpellCheck))) {
            elementBox.canTrigger = true;
            this.leftPosition = this.pageLeft;
            this.topPosition = this.pageTop;
            let errorDetails = this.spellChecker.checktextElementHasErrors(elementBox.text, elementBox, left);
            if (errorDetails.errorFound) {
                color = '#FF0000';
                let backgroundColor = (containerWidget instanceof TableCellWidget) ? containerWidget.cellFormat.shading.backgroundColor : this.documentHelper.backgroundColor;
                for (let i = 0; i < errorDetails.elements.length; i++) {
                    let currentElement = errorDetails.elements[i];
                    if (elementBox.ignoreOnceItems.indexOf(this.spellChecker.manageSpecialCharacters(currentElement.text, undefined, true)) === -1) {
                        this.renderWavyLine(currentElement, (isNullOrUndefined(currentElement.start)) ? left : currentElement.start.location.x, (isNullOrUndefined(currentElement.start)) ? top : currentElement.start.location.y - elementBox.margin.top, underlineY, color, 'Single', format.baselineAlignment, backgroundColor);
                    }
                }
            }
            else if (elementBox.ischangeDetected || this.documentHelper.triggerElementsOnLoading) {
                elementBox.ischangeDetected = false;
                this.handleChangeDetectedElements(elementBox, underlineY, left, top, format.baselineAlignment);
            }
        }
        let currentInfo = this.getRevisionType(revisionInfo, true);
        if (format.underline !== 'None' && !isNullOrUndefined(format.underline) || (!isNullOrUndefined(currentInfo) && (currentInfo.type === 'Insertion' || currentInfo.type === 'MoveTo'))) {
            this.renderUnderline(elementBox, left, top, underlineY, color, format.underline, format.baselineAlignment, currentInfo);
        }
        currentInfo = this.getRevisionType(revisionInfo, false);
        if (format.strikethrough !== 'None' && !isNullOrUndefined(format.strikethrough) || (!isNullOrUndefined(currentInfo) && (currentInfo.type === 'Deletion' || currentInfo.type === 'MoveFrom'))) {
            this.renderStrikeThrough(elementBox, left, top, format.strikethrough, color, format.baselineAlignment, currentInfo);
        }
        if (isHeightType) {
            this.pageContext.restore();
        }
    }
    getBackgroundColorHeirachy(element) {
        let bgColor;
        // "empty" is old value used for auto color till v19.2.49. It is maintained for backward compatibility.
        if (element.paragraph.isInsideTable) {
            let cell = element.paragraph.containerWidget;
            bgColor = cell.cellFormat.shading.backgroundColor;
            if (bgColor !== "empty" && bgColor !== '#00000000') {
                return bgColor;
            }
            else {
                bgColor = cell.ownerTable.tableFormat.shading.backgroundColor;
                if (bgColor !== "empty" && bgColor !== '#00000000') {
                    return bgColor;
                }
            }
        }
        return this.documentHelper.backgroundColor;
    }
    handleChangeDetectedElements(elementBox, underlineY, left, top, baselineAlignment) {
        let checkText = elementBox.text.trim();
        let beforeIndex = this.pageIndex;
        if (elementBox.text === '\v') {
            return;
        }
        if (!this.spellChecker.checkElementCanBeCombined(elementBox, underlineY, beforeIndex, true)) {
            /* eslint-disable @typescript-eslint/no-explicit-any */
            let splittedText = checkText.split(/[\s]+/);
            let markindex = elementBox.line.getOffset(elementBox, 0);
            let spaceValue = 1;
            if (splittedText.length > 1) {
                for (let i = 0; i < splittedText.length; i++) {
                    let currentText = splittedText[i];
                    let retrievedText = this.spellChecker.manageSpecialCharacters(currentText, undefined, true);
                    if (this.spellChecker.ignoreAllItems.indexOf(retrievedText) === -1 && elementBox.ignoreOnceItems.indexOf(retrievedText) === -1) {
                        this.handleUnorderedElements(retrievedText, elementBox, underlineY, i, markindex, i === splittedText.length - 1, beforeIndex);
                        markindex += currentText.length + spaceValue;
                    }
                }
            }
            else {
                let retrievedText = this.spellChecker.manageSpecialCharacters(checkText, undefined, true);
                if (checkText.length > 0) {
                    if (this.spellChecker.ignoreAllItems.indexOf(retrievedText) === -1 && elementBox.ignoreOnceItems.indexOf(retrievedText) === -1) {
                        let indexInLine = elementBox.indexInOwner;
                        let indexinParagraph = elementBox.line.paragraph.indexInOwner;
                        let spellInfo = this.spellChecker.checkSpellingInPageInfo(retrievedText);
                        if (spellInfo.isElementPresent && this.spellChecker.enableOptimizedSpellCheck) {
                            let jsonObject = JSON.parse('{\"HasSpellingError\":' + spellInfo.hasSpellError + '}');
                            this.spellChecker.handleWordByWordSpellCheck(jsonObject, elementBox, left, top, underlineY, baselineAlignment, true);
                        }
                        else {
                            if (this.spellChecker.isInUniqueWords(retrievedText)) {
                                let hasSpellingError = this.spellChecker.isErrorWord(retrievedText) ? true : false;
                                let jsonObject = JSON.parse('{\"HasSpellingError\":' + hasSpellingError + '}');
                                this.spellChecker.handleWordByWordSpellCheck(jsonObject, elementBox, left, top, underlineY, baselineAlignment, true);
                            }
                            else if (!this.documentHelper.owner.editor.triggerPageSpellCheck || this.documentHelper.triggerElementsOnLoading) {
                                /* eslint-disable @typescript-eslint/no-explicit-any */
                                this.spellChecker.callSpellChecker(this.spellChecker.languageID, checkText, true, this.spellChecker.allowSpellCheckAndSuggestion).then((data) => {
                                    /* eslint-disable @typescript-eslint/no-explicit-any */
                                    let jsonObject = JSON.parse(data);
                                    let canUpdate = (beforeIndex === this.pageIndex || elementBox.isVisible) && (indexInLine === elementBox.indexInOwner) && (indexinParagraph === elementBox.line.paragraph.indexInOwner);
                                    this.spellChecker.handleWordByWordSpellCheck(jsonObject, elementBox, left, top, underlineY, baselineAlignment, canUpdate);
                                });
                            }
                        }
                    }
                }
            }
        }
    }
    handleUnorderedElements(currentText, elementBox, underlineY, iteration, markIndex, isLastItem, beforeIndex) {
        let indexInLine = elementBox.indexInOwner;
        let indexinParagraph = elementBox.line.paragraph.indexInOwner;
        if (currentText.length > 0) {
            let spellInfo = this.spellChecker.checkSpellingInPageInfo(currentText);
            if (spellInfo.isElementPresent && this.spellChecker.enableOptimizedSpellCheck) {
                let jsonObject = JSON.parse('{\"HasSpellingError\":' + spellInfo.hasSpellError + '}');
                this.spellChecker.handleSplitWordSpellCheck(jsonObject, currentText, elementBox, true, underlineY, iteration, markIndex, isLastItem);
            }
            else {
                let canUpdate = (elementBox.isVisible) && (indexInLine === elementBox.indexInOwner) && (indexinParagraph === elementBox.line.paragraph.indexInOwner);
                if (this.spellChecker.isInUniqueWords(currentText)) {
                    let hasSpellingError = this.spellChecker.isErrorWord(currentText) ? true : false;
                    let jsonObject = JSON.parse('{\"HasSpellingError\":' + hasSpellingError + '}');
                    this.spellChecker.handleSplitWordSpellCheck(jsonObject, currentText, elementBox, canUpdate, underlineY, iteration, markIndex, isLastItem);
                }
                else if (!this.documentHelper.owner.editor.triggerPageSpellCheck || this.documentHelper.triggerElementsOnLoading) {
                    /* eslint-disable @typescript-eslint/no-explicit-any */
                    this.spellChecker.callSpellChecker(this.spellChecker.languageID, currentText, true, this.spellChecker.allowSpellCheckAndSuggestion).then((data) => {
                        /* eslint-disable @typescript-eslint/no-explicit-any */
                        let jsonObject = JSON.parse(data);
                        this.spellChecker.handleSplitWordSpellCheck(jsonObject, currentText, elementBox, canUpdate, underlineY, iteration, markIndex, isLastItem);
                    });
                }
            }
        }
    }
    renderWavyLine(elementBox, left, top, underlineY, color, underline, baselineAlignment, backgroundColor) {
        if (elementBox.text.length > 1) {
            let renderedHeight = elementBox.height / (baselineAlignment === 'Normal' ? 1 : 1.5);
            let topMargin = elementBox.margin.top;
            let underlineHeight = renderedHeight / 20;
            const frequencyRange = 0.5;
            const amplitudeRange = 1.0;
            const stepToCover = .7;
            let y = 0;
            if (baselineAlignment === 'Subscript' || elementBox instanceof ListTextElementBox) {
                y = (renderedHeight - 2 * underlineHeight) + top;
                topMargin += elementBox.height - renderedHeight;
                y += topMargin > 0 ? topMargin : 0;
            }
            else {
                y = underlineY + top;
            }
            let specialCharacter = this.spellChecker.getSpecialCharactersInfo(elementBox.text, elementBox.characterFormat);
            let whiteSpaceData = this.spellChecker.getWhiteSpaceCharacterInfo(elementBox.text, elementBox.characterFormat);
            let x = left + specialCharacter.beginningWidth + ((whiteSpaceData.isBeginning) ? whiteSpaceData.width : 0) + elementBox.margin.left;
            let x1 = x * this.documentHelper.zoomFactor + this.leftPosition;
            let y1 = y * this.documentHelper.zoomFactor + this.topPosition;
            let x2 = x1 + this.getScaledValue(elementBox.width - (specialCharacter.beginningWidth + specialCharacter.endWidth) - whiteSpaceData.width);
            let startingPoint = new Point(x1, y1);
            let endingPoint = new Point(x2, y1);
            this.drawWavy(startingPoint, endingPoint, (x2 - x1) * frequencyRange, amplitudeRange, stepToCover, color, elementBox.height, backgroundColor);
        }
    }
    drawWavy(from, to, frequency, amplitude, step, color, height, backColor, negative) {
        this.pageContext.save();
        this.pageContext.fillStyle = (!isNullOrUndefined(backColor) ? backColor : this.documentHelper.backgroundColor);
        this.pageContext.fillRect(from.x, from.y - amplitude, (to.x - from.x), amplitude * 3);
        this.pageContext.restore();
        this.pageContext.lineWidth = 1;
        this.pageContext.lineCap = 'round';
        this.pageContext.strokeStyle = color;
        this.pageContext.beginPath();
        //this.pageContext.save();
        let cx = 0;
        let cy = 0;
        let fx = from.x;
        let fy = from.y;
        let tx = to.x;
        let ty = to.y;
        let i = 0;
        let waveOffsetLength = 0;
        let ang = Math.atan2(ty - fy, tx - fx);
        let distance = Math.sqrt((fx - tx) * (fx - tx) + (fy - ty) * (fy - ty));
        let a = amplitude * 1;
        let f = Math.PI * frequency;
        for (i; i <= distance; i += step) {
            waveOffsetLength = Math.sin((i / distance) * f) * a;
            cx = from.x + Math.cos(ang) * i + Math.cos(ang - Math.PI / 2) * waveOffsetLength;
            cy = from.y + Math.sin(ang) * i + Math.sin(ang - Math.PI / 2) * waveOffsetLength;
            i > 0 ? this.pageContext.lineTo(cx, cy) : this.pageContext.moveTo(cx, cy);
        }
        this.pageContext.stroke();
        this.pageContext.restore();
    }
    /**
     * @private
     */
    getTabLeader(elementBox) {
        let textWidth = 0;
        let tabString = this.getTabLeaderString(elementBox.tabLeader);
        let tabText = tabString;
        textWidth = this.documentHelper.textHelper.getWidth(tabText, elementBox.characterFormat);
        let count = Math.floor(elementBox.width / textWidth);
        if (textWidth == 0) {
            count = 0;
        }
        for (let i = 0; i <= count; i++) {
            tabText += tabString;
        }
        return tabText.slice(0, -1);
    }
    getTabLeaderString(tabLeader) {
        let tabString = '';
        switch (tabLeader) {
            case 'Dot':
                tabString = '.';
                break;
            case 'Hyphen':
                tabString = '-';
                break;
            case 'Underscore':
                tabString = '_';
                break;
        }
        return tabString;
    }
    clipRect(xPos, yPos, width, height) {
        this.pageContext.beginPath();
        this.pageContext.save();
        this.pageContext.rect(this.getScaledValue(xPos, 1), this.getScaledValue(yPos, 2), width, height);
        this.pageContext.clip();
    }
    renderUnderline(elementBox, left, top, underlineY, color, underline, baselineAlignment, revisionInfo) {
        let renderedHeight = elementBox.height / (baselineAlignment === 'Normal' ? 1 : 1.5);
        let topMargin = elementBox.margin.top;
        let underlineHeight = renderedHeight / 20;
        let y = 0;
        let lineHeight = renderedHeight / 20;
        if (baselineAlignment === 'Subscript' || elementBox instanceof ListTextElementBox) {
            y = (renderedHeight - 2 * underlineHeight) + top;
            topMargin += elementBox.height - renderedHeight;
            y += topMargin > 0 ? topMargin : 0;
        }
        else {
            y = underlineY + top;
        }
        let lineCount = 0;
        if (!isNullOrUndefined(revisionInfo)) {
            underline = (revisionInfo.type === 'MoveTo') ? 'Double' : 'Single';
        }
        if (underline === 'Double') {
            y -= lineHeight;
        }
        if (elementBox instanceof ImageElementBox) {
            underlineHeight = 0.9;
        }
        while (lineCount < (underline === 'Double' ? 2 : 1)) {
            lineCount++;
            let width = elementBox.width;
            if (elementBox instanceof TextElementBox && !(elementBox instanceof TabElementBox) && isNullOrUndefined(elementBox.nextNode)) {
                width = this.documentHelper.textHelper.getWidth(HelperMethods.trimEnd(elementBox.text), elementBox.characterFormat);
            }
            this.pageContext.fillRect(this.getScaledValue(left + elementBox.margin.left, 1), this.getScaledValue(y, 2), this.getScaledValue(width), this.getScaledValue(underlineHeight));
            y += 2 * lineHeight;
        }
    }
    renderStrikeThrough(elementBox, left, top, strikethrough, color, baselineAlignment, revisionInfo) {
        let renderedHeight = elementBox.height / (baselineAlignment === 'Normal' ? 1 : 1.5);
        let topMargin = elementBox.margin.top;
        if (baselineAlignment === 'Subscript') {
            topMargin += elementBox.height - renderedHeight;
        }
        top += topMargin > 0 ? topMargin : 0;
        let lineHeight = renderedHeight / 20;
        let y = (renderedHeight / 2) + (0.5 * lineHeight);
        let lineCount = 0;
        if (!isNullOrUndefined(revisionInfo)) {
            strikethrough = (revisionInfo.type === 'Deletion') ? 'SingleStrike' : 'DoubleStrike';
        }
        if (elementBox instanceof ImageElementBox) {
            lineHeight = 0.9;
        }
        if (strikethrough === 'DoubleStrike') {
            y -= lineHeight;
        }
        while (lineCount < (strikethrough === 'DoubleStrike' ? 2 : 1)) {
            lineCount++;
            this.pageContext.fillRect(this.getScaledValue(left + elementBox.margin.left, 1), this.getScaledValue(y + top, 2), this.getScaledValue(elementBox.width), this.getScaledValue(lineHeight));
            y += 2 * lineHeight;
        }
    }
    renderImageElementBox(elementBox, left, top, underlineY) {
        let topMargin = elementBox.margin.top;
        let leftMargin = elementBox.margin.left;
        let revisionInfo = this.checkRevisionType(elementBox);
        let color = revisionInfo.length > 0 ? this.getRevisionColor(revisionInfo) : 'black';
        this.pageContext.textBaseline = 'top';
        let widgetWidth = 0;
        let isClipped = false;
        let containerWid = elementBox.line.paragraph.containerWidget;
        let isHeightType = false;
        if (containerWid instanceof TableCellWidget) {
            isHeightType = (containerWid.ownerRow.rowFormat.heightType === 'Exactly');
        }
        if (elementBox.textWrappingStyle === 'Inline') {
            if (topMargin < 0 || elementBox.line.paragraph.width < elementBox.width) {
                // if (containerWid instanceof BodyWidget) {
                //     widgetWidth = containerWid.width + containerWid.x;
                // } else 
                if (containerWid instanceof TableCellWidget) {
                    let leftIndent = 0;
                    if (containerWid.childWidgets[0] instanceof ParagraphWidget) {
                        let paraAdv = containerWid.childWidgets[0];
                        leftIndent = paraAdv.paragraphFormat.leftIndent;
                    }
                    widgetWidth = containerWid.width + containerWid.margin.left - containerWid.leftBorderWidth - leftIndent;
                    isClipped = true;
                    this.clipRect(left + leftMargin, top + topMargin, this.getScaledValue(widgetWidth), this.getScaledValue(containerWid.height));
                }
            }
            else if (isHeightType) {
                let width = containerWid.width + containerWid.margin.left - containerWid.leftBorderWidth;
                isClipped = true;
                this.clipRect(containerWid.x, containerWid.y, this.getScaledValue(width), this.getScaledValue(containerWid.height));
            }
        }
        if (elementBox.isMetaFile && !isNullOrUndefined(elementBox.metaFileImageString)) {
            this.pageContext.drawImage(elementBox.element, this.getScaledValue(left + leftMargin, 1), this.getScaledValue(top + topMargin, 2), this.getScaledValue(elementBox.width), this.getScaledValue(elementBox.height));
        }
        else {
            try {
                if (!elementBox.isCrop) {
                    this.pageContext.drawImage(elementBox.element, this.getScaledValue(left + leftMargin, 1), //dx
                    this.getScaledValue(top + topMargin, 2), //dy
                    this.getScaledValue(elementBox.width), //dw
                    this.getScaledValue(elementBox.height)); //dh
                }
                else {
                    this.pageContext.drawImage(elementBox.element, elementBox.cropX, //sx
                    elementBox.cropY, //sy
                    elementBox.cropWidth, //sw
                    elementBox.cropHeight, //sh
                    this.getScaledValue(left + leftMargin, 1), //dx
                    this.getScaledValue(top + topMargin, 2), //dy
                    this.getScaledValue(elementBox.width), //dw
                    this.getScaledValue(elementBox.height)); //dh
                }
            }
            catch (e) {
                elementBox.imageString = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOEAAADhCAMAAAAJbSJIAAAAgVBMVEX///8AAADgAADY2Njl5eVcXFxjY2NZWVl/f3+wsLCmpqb4+PiioqKpqam7u7vV1dX2uLj2wsLhFRXzpKT3vb30sbHhCwv74+P40dH+9vbkIyO2trbBwcHLy8tsbGycnJz529v4zMzrbGzlLS3qZmblNzfrdXXoRkbvi4vvgYHlHh7CZsBOAAADpUlEQVR4nO3da1faQBSF4ekAUQlUEFs14AXxVv7/D6yaQiZx5mSEYXF2ut+PNKzyyK5diYDmR9czx34AB49C/CjE759w3jvvWr15Tdgz3atXE54f++EcIArxoxA/CvGjED8K8aMQPwrxoxA/CvGLEeZ9jPJdhfk4GyCUjb3ECGE/Q6m/q3DwfudjP0ERZYN9hKdn2hvd3+0jHJz5/kBVuTk96bbQUEjhYR9ckiikUH8UUqg/CinUH4UU6o9CCvVHIYX6o5BC/VFIof4opFB/FFKoPwop1B+FFOqPQgrjyxfjVC38Lxk9tnAxGqZqdKtSOE4GHA5/fuNJpDCtcNHbv4VqYYqPLjgfUViPQgrjozA2CptRSGF8/59w+Wrt+rr1btNna1cPzg0wwuXavncxabnX7PfHYYXzlYARvlobQZyUR9mXm+1NMEK7SSLONgcVV9vb8IQXv4J3KSeKKlxXxNCzONkeYp8AV3p9UT1+P3FWHVAsq5thhGZSEb1DrSZq7dS5HUdoLiuBZ6jORG3tCwAkNJfCUJ2Jrqe1P0ESCkMNTdSACYNDDU7UoAkDQw1P1MAJvUMVJmrwhJ6hShM1gMIvQxUnahCFjaHKEzWQQneoxR95ogZTWBuqPFEDKnSHKk/UoArdoYoTNbDC5lBDEzW4QjMpYiZqgIXG/S76JhwHK5zVVipcnkIVuv/RW/HyFKhwYhuFr6NiCmdNoDBUSGFjovJQEYXuRN9ahwoorJ8uSZenPsMTNk+X2q6jwgm/ntHL11HhhL4zenmoYEL/Gb04VCxh6KKTNFQoYfiikzBUJKF00Sk8VCChfF00OFQcYdt10dBQYYRT5xn0n9G7Q0X8GfCzNNEyZ6iPgD/HlydaVg11DfhajJaJlm2HugIUrlomWrYZKuJKHz6vHhbSM/hROdRnxNe1meuXYvW0DB6+aflYrB7dlzDiCM3N1dVN6GDhMCDhjlHYjEIK46MwNgqbUUhhfJ/vA07wO8N1vw94ONo/3e/lTpVOYfc/UyG//ZmqW52fi/FuTNW3/lZ+eguF+qOQQv1RSKH+KKRQfxRSqD8KKdQfhRTqj0IK9UchhfqjkEL9UUih/iikUH8UUqg/CmXh6Hsv3jlK+wnvD/vgkrSHMMuyu1P9ZdmuwnycDQYn+svG3n9KEUKT9zHyf6+IEWJHIX4U4kchfhTiRyF+FOJHIX4U4kchfnVhijeZa6sunCf4ZdPamteEHY5C/CjEr/vCv0ec0g+AtS1QAAAAAElFTkSuQmCC';
                this.pageContext.drawImage(elementBox.element, this.getScaledValue(left + leftMargin, 1), this.getScaledValue(top + topMargin, 2), this.getScaledValue(elementBox.width), this.getScaledValue(elementBox.height));
            }
        }
        this.pageContext.fillStyle = HelperMethods.getColor(color);
        let currentRevision = this.getRevisionType(revisionInfo, false);
        if (!isNullOrUndefined(currentRevision) && (currentRevision.type === 'Deletion' || currentRevision.type === 'MoveFrom')) {
            this.renderStrikeThrough(elementBox, left, top, 'SingleStrike', color, 'Normal', currentRevision);
        }
        currentRevision = this.getRevisionType(revisionInfo, true);
        if (!isNullOrUndefined(currentRevision) && (currentRevision.type === 'Insertion' || currentRevision.type === 'MoveTo')) {
            let y = this.getUnderlineYPosition(elementBox.line);
            this.renderUnderline(elementBox, left, top, y, color, 'Single', 'Normal');
        }
        if (isClipped) {
            this.pageContext.restore();
        }
    }
    renderTableOutline(tableWidget) {
        let layout = new Layout(this.documentHelper);
        let table = tableWidget;
        tableWidget.width = this.documentHelper.layout.getTableWidth(table);
        let border = !table.isBidiTable ? layout.getTableLeftBorder(table.tableFormat.borders)
            : layout.getTableRightBorder(table.tableFormat.borders);
        let lineWidth = 0;
        //ToDo: Need to draw the borders based on the line style.
        // if (!isNullOrUndefined(border )) {
        lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
        this.renderSingleBorder(border.color, tableWidget.x - tableWidget.margin.left - lineWidth / 2, tableWidget.y, tableWidget.x - tableWidget.margin.left - lineWidth / 2, tableWidget.y + tableWidget.height, lineWidth);
        // }
        border = layout.getTableTopBorder(table.tableFormat.borders);
        lineWidth = 0;
        // if (!isNullOrUndefined(border )) {
        lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
        this.renderSingleBorder(border.color, tableWidget.x - tableWidget.margin.left - lineWidth, tableWidget.y - lineWidth / 2, tableWidget.x + tableWidget.width + lineWidth + tableWidget.margin.right, tableWidget.y - lineWidth / 2, lineWidth);
        // }
        border = !table.isBidiTable ? layout.getTableRightBorder(table.tableFormat.borders)
            : layout.getTableLeftBorder(table.tableFormat.borders);
        lineWidth = 0;
        // if (!isNullOrUndefined(border )) {
        lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
        this.renderSingleBorder(border.color, tableWidget.x + tableWidget.width + tableWidget.margin.right + lineWidth / 2, tableWidget.y, tableWidget.x + tableWidget.width + tableWidget.margin.right + lineWidth / 2, tableWidget.y + tableWidget.height, lineWidth);
        // }
        border = layout.getTableBottomBorder(table.tableFormat.borders);
        lineWidth = 0;
        // if (!isNullOrUndefined(border )) {
        lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
        this.renderSingleBorder(border.color, tableWidget.x - tableWidget.margin.left - lineWidth, tableWidget.y + tableWidget.height - lineWidth / 2, tableWidget.x + tableWidget.width + lineWidth + tableWidget.margin.right, tableWidget.y + tableWidget.height - lineWidth / 2, lineWidth);
        // }
    }
    /* eslint-disable  */
    renderTableCellOutline(documentHelper, cellWidget) {
        let layout = documentHelper.layout;
        let borders = undefined;
        let tableCell = cellWidget;
        let cellTopMargin = 0;
        let cellBottomMargin = 0;
        let cellLeftMargin = 0;
        let cellRightMargin = 0;
        let height = 0;
        let isBidiTable = cellWidget.ownerTable.isBidiTable;
        borders = tableCell.cellFormat.borders;
        if (cellWidget.containerWidget instanceof TableRowWidget) {
            cellBottomMargin = cellWidget.margin.bottom - cellWidget.containerWidget.bottomBorderWidth;
            cellTopMargin = cellWidget.margin.top - cellWidget.containerWidget.topBorderWidth;
        }
        cellLeftMargin = cellWidget.margin.left - cellWidget.leftBorderWidth;
        cellRightMargin = cellWidget.margin.right - cellWidget.rightBorderWidth;
        if (!isNullOrUndefined(tableCell.ownerRow) && tableCell.ownerRow.rowFormat.heightType === 'Exactly') {
            height = HelperMethods.convertPointToPixel(tableCell.ownerRow.rowFormat.height) + cellTopMargin + cellBottomMargin;
        }
        else {
            if (!isNullOrUndefined(tableCell.ownerRow) && [tableCell.ownerRow].length <= 1) {
                height = Math.max(HelperMethods.convertPointToPixel(tableCell.ownerRow.rowFormat.height), cellWidget.height) + cellTopMargin + cellBottomMargin;
            }
            else {
                height = cellWidget.height + cellTopMargin + cellBottomMargin;
            }
        }
        let border = !isBidiTable ? TableCellWidget.getCellLeftBorder(tableCell) : TableCellWidget.getCellRightBorder(tableCell);
        let lineWidth = 0;
        // if (!isNullOrUndefined(border )) {
        lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth()); //Renders the cell left border.
        this.renderCellBackground(height, cellWidget, cellLeftMargin, lineWidth);
        let leftBorderWidth = lineWidth;
        if (tableCell.index === 0 || tableCell.cellFormat.rowSpan === 1 || (tableCell.cellFormat.rowSpan > 1 && tableCell.columnIndex === 0)) {
            this.renderSingleBorder(border.color, cellWidget.x - cellLeftMargin - lineWidth, cellWidget.y - cellTopMargin, cellWidget.x - cellLeftMargin - lineWidth, cellWidget.y + cellWidget.height + cellBottomMargin, lineWidth);
        }
        else {
            for (let i = 0; i < tableCell.ownerTable.childWidgets.length; i++) {
                let row = tableCell.ownerTable.childWidgets[i];
                let cell;
                for (let j = 0; j < row.childWidgets.length; j++) {
                    let currentCell = row.childWidgets[j];
                    if ((currentCell.columnIndex + currentCell.cellFormat.columnSpan - 1) === tableCell.columnIndex - 1) {
                        cell = currentCell;
                        break;
                    }
                    else if (row.childWidgets[j].columnIndex >= tableCell.columnIndex && row.childWidgets[j].previousWidget) {
                        cell = row.childWidgets[j].previousWidget;
                        break;
                    }
                }
                if (cell && cell.columnIndex + cell.cellFormat.columnSpan - 1 === tableCell.columnIndex - 1) {
                    let border = !isBidiTable ? TableCellWidget.getCellRightBorder(cell) : TableCellWidget.getCellLeftBorder(cell);
                    let lineWidthInt = border.lineWidth;
                    if (cell.y + cell.height < tableCell.y) {
                        continue;
                    }
                    else if (cell.y < tableCell.y && cell.y + cell.height > tableCell.y) {
                        this.renderSingleBorder(border.color, tableCell.x - cellLeftMargin - lineWidthInt, tableCell.y - cellTopMargin, tableCell.x - cellLeftMargin - lineWidthInt, cell.y + cell.height + cell.margin.bottom, lineWidthInt);
                    }
                    else if ((cell.y === tableCell.y) || (cell.y > tableCell.y && cell.y + cell.height < tableCell.y + tableCell.height)) {
                        this.renderSingleBorder(border.color, tableCell.x - cellLeftMargin - lineWidthInt, cell.y - cell.margin.top, tableCell.x - cellLeftMargin - lineWidthInt, cell.y + cell.height + cell.margin.bottom, lineWidthInt);
                    }
                    else if (cell.y < tableCell.y + tableCell.height && cell.y + cell.height >= tableCell.y + tableCell.height) {
                        this.renderSingleBorder(border.color, tableCell.x - cellLeftMargin - lineWidthInt, cell.y - cell.margin.top, tableCell.x - cellLeftMargin - lineWidthInt, cell.y + cell.height + cellBottomMargin, lineWidthInt);
                    }
                    else if (cell.y > tableCell.y + tableCell.height) {
                        break;
                    }
                }
            }
        }
        // }
        if (tableCell.updatedTopBorders && tableCell.updatedTopBorders.length > 1) {
            let cellX = cellWidget.x - cellWidget.margin.left - leftBorderWidth / 2;
            let cellY = cellWidget.y - cellWidget.margin.top;
            for (let a = 0; a < tableCell.updatedTopBorders.length; a++) {
                let borderInfo = tableCell.updatedTopBorders[a];
                border = borderInfo.border;
                if (border.lineStyle !== 'None' && border.lineWidth < TableCellWidget.getCellTopBorder(tableCell).lineWidth) {
                    border.lineWidth = TableCellWidget.getCellTopBorder(tableCell).lineWidth;
                }
                if (!isNullOrUndefined(border)) {
                    lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
                    this.renderSingleBorder(border.color, cellX, cellY + lineWidth / 2, cellX + borderInfo.width, cellY + lineWidth / 2, lineWidth);
                    cellX = cellX + borderInfo.width;
                }
            }
        }
        else {
            border = TableCellWidget.getCellTopBorder(tableCell);
            // if (!isNullOrUndefined(border )) { //Renders the cell top border.        
            lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
            let width = 0;
            this.renderSingleBorder(border.color, cellWidget.x - cellWidget.margin.left - leftBorderWidth / 2, cellWidget.y - cellWidget.margin.top + lineWidth / 2, cellWidget.x + cellWidget.width + cellWidget.margin.right + width, cellWidget.y - cellWidget.margin.top + lineWidth / 2, lineWidth);
            // }
        }
        let isLastCell = false;
        if (!isBidiTable) {
            isLastCell = tableCell.cellIndex === tableCell.ownerRow.childWidgets.length - 1;
        }
        else {
            isLastCell = tableCell.cellIndex === 0;
        }
        let prevRowSpannedCells = tableCell.containerWidget.getPreviousRowSpannedCells();
        let isAffectedByRowSpan = false;
        for (let k = 0; k < prevRowSpannedCells.length; k++) {
            let spannedCell = prevRowSpannedCells[k];
            if (tableCell.rowIndex < spannedCell.rowIndex + spannedCell.cellFormat.rowSpan && tableCell.columnIndex < spannedCell.columnIndex) {
                isAffectedByRowSpan = true;
                break;
            }
        }
        if ((tableCell.ownerTable.tableFormat.cellSpacing > 0 || isLastCell) && (isBidiTable || tableCell.columnIndex + tableCell.cellFormat.columnSpan === tableCell.ownerTable.tableHolder.columns.length || !isAffectedByRowSpan)) {
            border = isBidiTable ? TableCellWidget.getCellLeftBorder(tableCell) : TableCellWidget.getCellRightBorder(tableCell);
            // if (!isNullOrUndefined(border )) { //Renders the cell right border.           
            lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
            this.renderSingleBorder(border.color, cellWidget.x + cellWidget.width + cellWidget.margin.right - lineWidth / 2, cellWidget.y - cellTopMargin, cellWidget.x + cellWidget.width + cellWidget.margin.right - lineWidth / 2, cellWidget.y + cellWidget.height + cellBottomMargin, lineWidth);
            // }
        }
        let nextRow = tableCell.ownerRow.nextWidget;
        //Specifies the next row is within the current table widget.
        //True means current row is not rendered at page end; Otherwise False.
        let nextRowIsInCurrentTableWidget = false;
        let previousCellIndex = undefined;
        if (!isNullOrUndefined(nextRow)) {
            if (nextRow.lastChild) {
                let lastCellWidget = nextRow.lastChild;
                previousCellIndex = lastCellWidget.columnIndex + lastCellWidget.cellFormat.columnSpan;
            }
            let nextRowWidget = undefined;
            // if (viewer.renderedElements.containsKey(nextRow) && viewer.renderedElements.get(nextRow).length > 0) {
            nextRowWidget = nextRow;
            // }
            if (nextRowWidget instanceof TableRowWidget) {
                if (cellWidget.containerWidget instanceof TableRowWidget && cellWidget.containerWidget.containerWidget instanceof TableWidget) {
                    nextRowIsInCurrentTableWidget = cellWidget.containerWidget.containerWidget.childWidgets.indexOf(nextRowWidget) !== -1;
                }
            }
        }
        if (tableCell.ownerTable.tableFormat.cellSpacing > 0 || tableCell.ownerRow.rowIndex === tableCell.ownerTable.childWidgets.length - 1
            || (tableCell.cellFormat.rowSpan > 1
                && tableCell.ownerRow.rowIndex + tableCell.cellFormat.rowSpan >= tableCell.ownerTable.childWidgets.length) ||
            !nextRowIsInCurrentTableWidget || previousCellIndex && nextRow.childWidgets.length < tableCell.ownerRow.childWidgets.length
            && previousCellIndex < tableCell.columnIndex + tableCell.cellFormat.columnSpan) {
            let bottomBorder = tableCell.cellFormat.borders.bottom;
            if (!isNullOrUndefined(bottomBorder) && bottomBorder.lineStyle === 'Cleared') {
                border = TableCellWidget.getCellBottomBorder(tableCell);
            }
            else {
                border = (tableCell.cellFormat.rowSpan > 1 && tableCell.ownerRow.rowIndex + tableCell.cellFormat.rowSpan === tableCell.ownerTable.childWidgets.length) ?
                    //true part for vertically merged cells specifically.
                    tableCell.getBorderBasedOnPriority(tableCell.getBorderBasedOnPriority(tableCell.cellFormat.borders.bottom, tableCell.ownerRow.rowFormat.borders.bottom), tableCell.ownerTable.tableFormat.borders.bottom)
                    //false part for remaining cases that has been handled inside method. 
                    : TableCellWidget.getCellBottomBorder(tableCell);
            }
            // if (!isNullOrUndefined(border )) {
            //Renders the cell bottom border.
            lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
            this.renderSingleBorder(border.color, cellWidget.x - cellWidget.margin.left - leftBorderWidth / 2, cellWidget.y + cellWidget.height + cellBottomMargin + lineWidth / 2, cellWidget.x + cellWidget.width + cellWidget.margin.right, cellWidget.y + cellWidget.height + cellBottomMargin + lineWidth / 2, lineWidth);
            // }
        }
        border = layout.getCellDiagonalUpBorder(tableCell);
        // if (!isNullOrUndefined(border )) {
        //Renders the cell diagonal up border.
        lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
        if (lineWidth > 0) {
            this.renderSingleBorder(border.color, cellWidget.x - cellLeftMargin, cellWidget.y + cellWidget.height + cellBottomMargin, cellWidget.x + cellWidget.width + cellRightMargin, cellWidget.y - cellTopMargin, lineWidth);
            // }
        }
        border = layout.getCellDiagonalDownBorder(tableCell);
        // if (!isNullOrUndefined(border )) {
        //Renders the cell diagonal down border.
        lineWidth = HelperMethods.convertPointToPixel(border.getLineWidth());
        if (lineWidth > 0) {
            this.renderSingleBorder(border.color, cellWidget.x - cellLeftMargin, cellWidget.y - cellTopMargin, cellWidget.x + cellWidget.width + cellRightMargin, cellWidget.y + cellWidget.height + cellBottomMargin, lineWidth);
        }
        // }
    }
    renderCellBackground(height, cellWidget, leftMargin, lineWidth) {
        let cellFormat = cellWidget.cellFormat;
        let bgColor = cellFormat.shading.backgroundColor === '#ffffff' ?
            cellWidget.ownerTable.tableFormat.shading.backgroundColor : cellFormat.shading.backgroundColor;
        let left = cellWidget.x - leftMargin - lineWidth;
        let topMargin = cellWidget.topMargin ? HelperMethods.convertPointToPixel(cellWidget.topMargin) : 0;
        let top = cellWidget.y - topMargin;
        let width = cellWidget.width + leftMargin + cellWidget.margin.right - lineWidth;
        if (cellWidget.ownerRow.rowFormat.revisions.length > 0) {
            let revision = cellWidget.ownerRow.rowFormat.revisions[cellWidget.ownerRow.rowFormat.revisions.length - 1];
            bgColor = (revision.revisionType === 'Insertion') ? '#e1f2fa' : '#fce6f4';
        }
        this.pageContext.beginPath();
        if (bgColor !== 'empty') {
            this.pageContext.fillStyle = HelperMethods.getColor(bgColor);
            this.pageContext.fillRect(this.getScaledValue(left, 1), this.getScaledValue(top, 2), this.getScaledValue(width), this.getScaledValue(height));
            this.pageContext.closePath();
        }
        //Render foreground color
        if (cellFormat.shading.hasValue('foregroundColor') && cellFormat.shading.textureStyle !== 'TextureNone') {
            this.pageContext.beginPath();
            if (cellFormat.shading.foregroundColor !== 'empty') {
                this.pageContext.fillStyle = this.drawTextureStyle(cellFormat.shading.textureStyle, HelperMethods.getColor(cellFormat.shading.foregroundColor), HelperMethods.getColor(cellFormat.shading.backgroundColor));
                //Width is increased twice since left and right line width is reduced in cell rendering which is required for background rendering.
                this.pageContext.fillRect(this.getScaledValue(left, 1), this.getScaledValue(top, 2), this.getScaledValue(width + (lineWidth * 2)), this.getScaledValue(height));
                this.pageContext.closePath();
            }
        }
    }
    drawTextureStyle(textureStyle, foreColor, backColor) {
        if (textureStyle.indexOf('Percent') > -1) {
            let text = textureStyle.replace("Texture", "").replace("Percent", "").replace("Pt", ".");
            let percent = parseInt(text);
            return this.getForeColor(foreColor, backColor, percent);
        }
        if (textureStyle === 'TextureSolid') {
            return foreColor;
        }
        return '#FFFFFF';
    }
    getForeColor(foreColor, backColor, percent) {
        let r = 0;
        let g = 0;
        let b = 0;
        let foreColorRgb = HelperMethods.convertHexToRgb(foreColor);
        let backColorRgb = HelperMethods.convertHexToRgb(backColor);
        r = this.getColorValue(foreColorRgb.r, backColorRgb.r, percent);
        g = this.getColorValue(foreColorRgb.g, backColorRgb.g, percent);
        b = this.getColorValue(foreColorRgb.b, backColorRgb.b, percent);
        return ('#' + HelperMethods.convertRgbToHex(r) + HelperMethods.convertRgbToHex(g) + HelperMethods.convertRgbToHex(b));
    }
    getColorValue(foreColorValue, backColorValue, percent) {
        let colorValue = 0;
        if (percent == 100) {
            colorValue = foreColorValue;
        }
        else {
            colorValue = backColorValue + Math.round(foreColorValue * (percent / 100)) - Math.round(backColorValue * (percent / 100));
        }
        return colorValue;
    }
    renderSingleBorder(color, startX, startY, endX, endY, lineWidth) {
        this.pageContext.beginPath();
        this.pageContext.moveTo(this.getScaledValue(startX, 1), this.getScaledValue(startY, 2));
        this.pageContext.lineTo(this.getScaledValue(endX, 1), this.getScaledValue(endY, 2));
        this.pageContext.lineWidth = this.getScaledValue(lineWidth);
        // set line color
        this.pageContext.strokeStyle = HelperMethods.getColor(color);
        if (lineWidth > 0) {
            this.pageContext.stroke();
        }
        this.pageContext.closePath();
    }
    getScaledValue(value, type) {
        if (this.isPrinting) {
            return value;
        }
        if (isNullOrUndefined(type)) {
            type = 0;
        }
        let x = value * this.documentHelper.zoomFactor;
        return x + (type === 1 ? this.pageLeft : (type === 2 ? this.pageTop : 0));
    }
    checkRevisionType(elementBox) {
        let revisions = [];
        let count = elementBox.revisions.length;
        for (let i = 0; i < count; i++) {
            let currentRevision = elementBox.revisions[i];
            let color = this.documentHelper.authors.get(currentRevision.author);
            revisions.push({ 'type': currentRevision.revisionType, 'color': color });
        }
        return revisions;
    }
    getRevisionColor(revisionInfo) {
        if (revisionInfo.length === 1) {
            return revisionInfo[0].color;
        }
        for (let i = 0; i < revisionInfo.length; i++) {
            if (revisionInfo[i].type === 'Deletion' || revisionInfo[i].type === 'MoveFrom') {
                return revisionInfo[i].color;
            }
        }
        return undefined;
    }
    getRevisionType(revisionInfo, checkInsert) {
        if (revisionInfo.length === 0) {
            return undefined;
        }
        for (let i = 0; i < revisionInfo.length; i++) {
            let type = undefined;
            if (checkInsert && (revisionInfo[i].type === 'Insertion' || revisionInfo[i].type === 'MoveTo')) {
                type = revisionInfo[i];
                this.pageContext.fillStyle = HelperMethods.getColor(type.color);
                revisionInfo.splice(i, 1);
                return type;
            }
            if (!checkInsert && (revisionInfo[i].type === 'Deletion' || revisionInfo[i].type === 'MoveFrom')) {
                type = revisionInfo[i];
                this.pageContext.fillStyle = HelperMethods.getColor(type.color);
                revisionInfo.splice(i, 1);
                return type;
            }
        }
        return undefined;
    }
    getFormfieldInLine(line) {
        for (let i = 0; i < line.children.length; i++) {
            if (line.children[i] instanceof FieldElementBox && !isNullOrUndefined(line.children[i].formFieldData)) {
                return line.children[i];
            }
        }
        return undefined;
    }
    /**
     * Destroys the internal objects which is maintained.
     *
     * @returns {void}
     */
    destroy() {
        this.documentHelper = undefined;
        if (!isNullOrUndefined(this.pageCanvasIn)) {
            this.pageCanvasIn.innerHTML = '';
        }
        this.pageCanvasIn = undefined;
    }
}

/**
 * @private
 */
class TextHelper {
    constructor(documentHelper) {
        this.paragraphMarkInfo = {};
        this.documentHelper = documentHelper;
        if (!isNullOrUndefined(documentHelper)) {
            this.context = documentHelper.containerContext;
        }
    }
    get paragraphMark() {
        return '¶';
    }
    get lineBreakMark() {
        return '↲';
    }
    getEnSpaceCharacter() {
        return String.fromCharCode(8194);
    }
    repeatChar(char, count) {
        let text = '';
        for (let i = 0; i < count; i++) {
            text += char;
        }
        return text;
    }
    getParagraphMarkWidth(characterFormat) {
        return this.getParagraphMarkSize(characterFormat).Width;
    }
    getParagraphMarkSize(characterFormat) {
        const format = this.getFormatText(characterFormat);
        if (this.paragraphMarkInfo[format]) {
            return this.paragraphMarkInfo[format];
        }
        // Gets the text element's width;
        const width = this.getWidth(this.paragraphMark, characterFormat);
        // Calculate the text element's height and baseline offset.
        const textHelper = this.getHeight(characterFormat);
        const textSizeInfo = {
            'Width': width, 'Height': textHelper.Height, 'BaselineOffset': textHelper.BaselineOffset
        };
        return this.paragraphMarkInfo[format] = textSizeInfo;
    }
    getTextSize(elementBox, characterFormat) {
        // Gets the text element's width;
        let textTrimEndWidth = 0;
        const isRTL = characterFormat.bidi || this.isRTLText(elementBox.text);
        const text = this.setText(elementBox.text, isRTL, characterFormat.bdo);
        textTrimEndWidth = this.getWidth(text, characterFormat);
        elementBox.width = textTrimEndWidth;
        // Calculate the text element's height and baseline offset.
        const textHelper = this.getHeight(characterFormat);
        elementBox.height = textHelper.Height;
        elementBox.baselineOffset = textHelper.BaselineOffset;
        if (elementBox.text[elementBox.text.length - 1] === ' ') {
            textTrimEndWidth = this.getWidth(HelperMethods.trimEnd(elementBox.text), characterFormat);
        }
        elementBox.trimEndWidth = textTrimEndWidth;
        return textTrimEndWidth;
    }
    getHeight(characterFormat) {
        // Get character format property as  below predefined structure to make it easy to check and retrieve
        // Predefined static structure `[FontName];[FontSize];bold;italic` to maintain as key in the collection
        const key = this.getFormatText(characterFormat);
        if (!isNullOrUndefined(this.documentHelper.heightInfoCollection[key])) {
            return this.documentHelper.heightInfoCollection[key];
        }
        const sizeInfo = this.documentHelper.owner.textMeasureHelper.getHeightInternal(characterFormat);
        this.documentHelper.heightInfoCollection[key] = sizeInfo;
        return sizeInfo;
    }
    getFormatText(characterFormat) {
        let formatText = characterFormat.fontFamily.toLocaleLowerCase();
        formatText += ';' + characterFormat.fontSize;
        if (characterFormat.bold) {
            formatText += ';' + 'bold';
        }
        if (characterFormat.italic) {
            formatText += ';' + 'italic';
        }
        return formatText;
    }
    measureTextExcludingSpaceAtEnd(text, characterFormat) {
        return this.getWidth(HelperMethods.trimEnd(text), characterFormat);
    }
    getWidth(text, characterFormat) {                
        if (typeof text === 'string' && text.match('\v')) {
            text.replace('\v', this.lineBreakMark);
        }           
        let bold = '';
        let italic = '';
        let fontFamily = '';
        let fontSize = characterFormat.fontSize;
        bold = characterFormat.bold ? 'bold' : '';
        italic = characterFormat.italic ? 'italic' : '';
        fontFamily = characterFormat.fontFamily;
        fontSize = fontSize === 0 ? 0.5 : fontSize / (characterFormat.baselineAlignment === 'Normal' ? 1 : 1.5);
        this.context.font = bold + ' ' + italic + ' ' + fontSize + 'pt' + ' ' + fontFamily;
        if (characterFormat.allCaps) {
            text = text.toUpperCase();
        }
        return this.context.measureText(text).width;
    }
    setText(textToRender, isBidi, bdo, isRender) {
        if (isNullOrUndefined(isRender)) {
            isRender = false;
        }
        if (textToRender.length === 0) {
            return '';
        }
        const isRtlText = isBidi;
        if ((!isRtlText && (bdo === 'RTL')) || (isRtlText && (bdo === 'LTR'))) {
            textToRender = HelperMethods.reverseString(textToRender);
        }
        else if (isRender && isRtlText && HelperMethods.endsWith(textToRender)) {
            const spaceCount = textToRender.length - HelperMethods.trimEnd(textToRender).length;
            textToRender = HelperMethods.addSpace(spaceCount) + HelperMethods.trimEnd(textToRender);
        }
        return textToRender;
    }
    measureText(text, characterFormat) {
        // Gets the text element's width;
        const width = this.getWidth(text, characterFormat);
        // Calculate the text element's height and baseline offset.
        const textHelper = this.getHeight(characterFormat);
        return {
            'Width': width, 'Height': textHelper.Height, 'BaselineOffset': textHelper.BaselineOffset
        };
    }
    updateTextSize(elementBox, paragraph) {
        const format = new WCharacterFormat(undefined);
        const listCharacterFormat = elementBox.listLevel.characterFormat;
        const breakCharacterFormat = paragraph.characterFormat;
        format.fontSize = listCharacterFormat.hasValue('fontSize') ? listCharacterFormat.fontSize : breakCharacterFormat.fontSize;
        format.fontFamily = listCharacterFormat.hasValue('fontFamily') ? listCharacterFormat.fontFamily : breakCharacterFormat.fontFamily;
        let bold = '';
        let italic = '';
        const baselineAlignment = listCharacterFormat.baselineAlignment === 'Normal' ?
            breakCharacterFormat.baselineAlignment : listCharacterFormat.baselineAlignment;
        bold = listCharacterFormat.hasValue('bold') ? listCharacterFormat.bold ? 'bold' : '' : breakCharacterFormat.bold ? 'bold' : '';
        italic = listCharacterFormat.hasValue('italic') ? listCharacterFormat.italic ? 'italic' : ''
            : breakCharacterFormat.italic ? 'italic' : '';
        format.baselineAlignment = baselineAlignment;
        if (bold) {
            format.bold = true;
        }
        if (italic) {
            format.italic = true;
        }
        const isRTL = format.bidi || this.isRTLText(elementBox.text);
        const text = this.setText(elementBox.text, isRTL, format.bdo);
        elementBox.width = this.getWidth(text, format);
        // Calculate the text element's height and baseline offset.
        const textHelper = this.getHeight(format);
        elementBox.height = textHelper.Height;
        elementBox.baselineOffset = textHelper.BaselineOffset;
    }
    containsSpecialCharAlone(text) {
        /* eslint-disable */
        let specialChars = '*|.\:[]{}-`\;()@&$#%!~?,' + ' ' + "'";
        for (let i = 0; i < text.length; i++) {
            if (specialChars.indexOf(text.charAt(i)) === -1) {
                return false;
            }
        }
        return true;
    }
    containsNumberAlone(text) {
        /* eslint-disable */
        let number = '0123456789';
        if (text === '') {
            return false;
        }
        for (let i = 0; i < text.length; i++) {
            if (number.indexOf(text.charAt(i)) === -1) {
                return false;
            }
        }
        return true;
    }
    containsCombinationText(element) {
        /* eslint-disable */
        if (element.text.match(/^[0-9]+$/) && element.paragraph.bidi) {
            return true;
        }
        else {
            return false;
        }
    }
    inverseCharacter(ch) {
        switch (ch) {
            //Specify the '('
            case '(':
                //Specify the ')'
                return ')';
            //Specify the ')'
            case ')':
                //Specify the '('
                return '(';
            //Specify the '<'
            case '<':
                //Specify the '>'
                return '>';
            //Specify the '>'
            case '>':
                //Specify the '<'
                return '<';
            //Specify the '{'
            case '{':
                //Specify the '}'
                return '}';
            //Specify the '}'
            case '}':
                //Specify the '{'
                return '{';
            //Specify the '['
            case '[':
                //Specify the ']'
                return ']';
            //Specify the ']'
            case ']':
                //Specify the '['
                return '[';
            default:
                return ch;
        }
    }
    containsSpecialChar(text) {
        let specialChars = '*|.\:[]{}-`\;()@&$#%!~?' + ' ';
        for (let i = 0; i < text.length; i++) {
            if (specialChars.indexOf(text.charAt(i)) !== -1) {
                return true;
            }
        }
        return false;
    }
    /**
     * @private
     * @param {string} text - Specifies the text
     * @returns {boolean} - Returns true if given text it right to left.
     */
    isRTLText(text) {
        let isRTL = false;
        if (!isNullOrUndefined(text)) {
            for (let i = 0; i < text.length; i++) {
                let temp = text[i];
                if ((temp >= String.fromCharCode(1424) && temp <= String.fromCharCode(1535)) //Hebrew characters
                    || (temp >= String.fromCharCode(1536) && temp <= String.fromCharCode(1791)) //Arabic - Urdu characters
                    || (temp >= String.fromCharCode(1872) && temp <= String.fromCharCode(1919)) //Arabic - Urdu characters
                    || (temp >= String.fromCharCode(2208) && temp <= String.fromCharCode(2303)) //Arabic characters
                    || (temp >= String.fromCharCode(64336) && temp <= String.fromCharCode(65023)) //Arabic - Urdu characters
                    || (temp >= String.fromCharCode(65136) && temp <= String.fromCharCode(65279)) //Arabic - Urdu characters
                    || (temp >= String.fromCharCode(43392) && temp <= String.fromCharCode(43487)) //Javanese characters
                    || (temp >= String.fromCharCode(1792) && temp <= String.fromCharCode(1871)) //Syriac characters
                    || (temp >= String.fromCharCode(1920) && temp <= String.fromCharCode(1983)) //Thaana characters
                    || (temp >= String.fromCharCode(2112) && temp <= String.fromCharCode(2143)) //Mandiac characters
                    || (temp >= String.fromCharCode(1984) && temp <= String.fromCharCode(2047)) //N'Ko characters
                    || (temp >= String.fromCharCode(2048) && temp <= String.fromCharCode(2111)) //Samaritan characters
                    //Tifinag characters 
                    || (temp >= String.fromCharCode(11568) && temp <= String.fromCharCode(11647))) {
                    isRTL = true;
                    break;
                }
            }
        }
        return isRTL;
    }
    /**
     * @private
     * @param {string} text - Specifies the text
     * @returns {RtlInfo} - Returns the text info.
     */
    getRtlLanguage(text) {
        if (isNullOrUndefined(text) || text === '') {
            return { isRtl: false, id: 0 };
        }
        if (text >= String.fromCharCode(1424) && text <= String.fromCharCode(1535)) {
            return { isRtl: true, id: 1 };
            //Arabic - Urdu characters
        }
        else if ((text >= String.fromCharCode(1536) && text <= String.fromCharCode(1791))
            || (text >= String.fromCharCode(1872) && text <= String.fromCharCode(1919))
            || (text >= String.fromCharCode(2208) && text <= String.fromCharCode(2303))
            || (text >= String.fromCharCode(64336) && text <= String.fromCharCode(65023))
            || (text >= String.fromCharCode(65136) && text <= String.fromCharCode(65279))) {
            return { isRtl: true, id: 2 };
        }
        else if (text >= String.fromCharCode(43392) && text <= String.fromCharCode(43487)) {
            return { isRtl: true, id: 3 };
        }
        else if (text >= String.fromCharCode(1792) && text <= String.fromCharCode(1871)) {
            return { isRtl: true, id: 4 };
        }
        else if (text >= String.fromCharCode(1920) && text <= String.fromCharCode(1983)) {
            return { isRtl: true, id: 5 };
        }
        else if (text >= String.fromCharCode(2112) && text <= String.fromCharCode(2143)) {
            return { isRtl: true, id: 6 };
        }
        else if (text >= String.fromCharCode(1984) && text <= String.fromCharCode(2047)) {
            return { isRtl: true, id: 7 };
        }
        else if (text >= String.fromCharCode(2048) && text <= String.fromCharCode(2111)) {
            return { isRtl: true, id: 8 };
        }
        else if (text >= String.fromCharCode(11568) && text <= String.fromCharCode(11647)) {
            return { isRtl: true, id: 9 };
        }
        return { isRtl: false, id: 0 };
    }
    destroy() {
        this.documentHelper = undefined;
        this.context = undefined;
        this.paragraphMarkInfo = {};
        this.paragraphMarkInfo = undefined;
    }
}

/**
 * @private
 */
class Zoom {
    constructor(documentHelper) {
        /**
         * @private
         * @param {WheelEvent} event Specifies the mouse wheen event
         * @returns {void}
         */
        this.onMouseWheelInternal = (event) => {
            if (event.ctrlKey === true) {
                event.preventDefault();
                const pageX = event.pageX - this.documentHelper.viewerContainer.offsetLeft;
                if (pageX < this.documentHelper.pageContainer.offsetWidth) {
                    const isFirefFox = navigator.userAgent.match('Firefox');
                    /* eslint-disable */
                    const wheel = isFirefFox ? event.detail < 0 : (Browser.isIE ? event.wheelDelta > 0 : event.deltaY < 0);
                    /* eslint-enable */
                    let zoomFactor = this.documentHelper.zoomFactor;
                    if (wheel) {
                        if (zoomFactor <= 4.90) {
                            zoomFactor += .10;
                        }
                        else {
                            zoomFactor = 5.00;
                        }
                    }
                    else {
                        if (zoomFactor >= .20) {
                            zoomFactor -= .10;
                        }
                        else {
                            zoomFactor = 0.10;
                        }
                    }
                    this.documentHelper.zoomFactor = zoomFactor;
                }
            }
        };
        this.documentHelper = documentHelper;
    }
    setZoomFactor() {
        this.onZoomFactorChanged();
        if (!isNullOrUndefined(this.documentHelper.selection)) {
            this.documentHelper.selection.updateCaretPosition();
        }
        this.documentHelper.updateTouchMarkPosition();
        if (!isNullOrUndefined(this.documentHelper.owner.imageResizerModule)) {
            this.documentHelper.owner.imageResizerModule.updateImageResizerPosition();
        }
        this.documentHelper.owner.fireZoomFactorChange();
    }
    get viewer() {
        return this.documentHelper.owner.viewer;
    }
    //Zoom Implementation Starts
    onZoomFactorChanged() {
        if (this.documentHelper.zoomFactor > 5) {
            this.documentHelper.zoomFactor = 5;
        }
        else if (this.documentHelper.zoomFactor < 0.1) {
            this.documentHelper.zoomFactor = 0.1;
        }
        this.zoom();
    }
    zoom() {
        const viewer = this.viewer;
        this.documentHelper.clearContent();
        viewer.handleZoom();
        this.documentHelper.updateFocus();
    }
}

/**
 * @private
 */
class AddUserDialog {
    constructor(documentHelper) {
        /**
         * @private
         * @returns {void}
         */
        this.show = () => {
            const localObj = new L10n('documenteditor', this.documentHelper.owner.defaultLocale);
            localObj.setLocale(this.documentHelper.owner.locale);
            if (!this.target) {
                this.initUserDialog(localObj, this.documentHelper.owner.enableRtl);
            }
            this.documentHelper.dialog.header = localObj.getConstant('Add Users');
            this.documentHelper.dialog.height = 'auto';
            this.documentHelper.dialog.width = 'auto';
            this.documentHelper.dialog.content = this.target;
            this.documentHelper.dialog.beforeOpen = this.loadUserDetails;
            this.documentHelper.dialog.close = this.documentHelper.updateFocus;
            this.documentHelper.dialog.buttons = [
                {
                    click: this.okButtonClick,
                    buttonModel: {
                        content: localObj.getConstant('Ok'), cssClass: 'e-flat', isPrimary: true
                    }
                },
                {
                    click: this.hideDialog,
                    buttonModel: { content: localObj.getConstant('Cancel'), cssClass: 'e-flat' }
                }, {
                    click: this.deleteButtonClick,
                    buttonModel: { content: localObj.getConstant('Delete'), cssClass: 'e-flat e-user-delete' }
                }
            ];
            this.documentHelper.dialog.dataBind();
            this.documentHelper.dialog.show();
        };
        /**
         * @private
         * @returns {void}
         */
        this.loadUserDetails = () => {
            this.userList.dataSource = this.documentHelper.userCollection.slice();
            this.userList.dataBind();
            this.documentHelper.restrictEditingPane.addedUser.dataSource = this.documentHelper.userCollection.slice();
            this.documentHelper.restrictEditingPane.addedUser.dataBind();
        };
        /**
         * @private
         * @returns {void}
         */
        this.okButtonClick = () => {
            this.documentHelper.restrictEditingPane.isAddUser = true;
            this.documentHelper.restrictEditingPane.showStopProtectionPane(false);
            this.documentHelper.restrictEditingPane.addUserCollection();
            this.documentHelper.restrictEditingPane.isAddUser = false;
            this.documentHelper.dialog.hide();
        };
        /**
         * @private
         * @returns {void}
         */
        this.hideDialog = () => {
            this.textBoxInput.value = '';
            this.documentHelper.dialog.hide();
        };
        /**
         * @private
         * @returns {void}
         */
        this.onKeyUpOnDisplayBox = () => {
            this.addButton.disabled = this.textBoxInput.value === '';
        };
        /**
         * @returns {void}
         */
        this.addButtonClick = () => {
            if (this.validateUserName(this.textBoxInput.value)) {
                if (this.documentHelper.userCollection.indexOf(this.textBoxInput.value) === -1) {
                    this.documentHelper.userCollection.push(this.textBoxInput.value);
                }
                this.userList.dataSource = this.documentHelper.userCollection.slice();
                this.userList.dataBind();
                this.textBoxInput.value = '';
            }
            else {
                DialogUtility.alert('Invalid user name');
            }
        };
        /**
         * @returns {void}
         */
        this.deleteButtonClick = () => {
            const index = this.documentHelper.userCollection.indexOf(this.userList.getSelectedItems().text);
            if (index > -1) {
                this.documentHelper.userCollection.splice(index, 1);
                this.userList.dataSource = this.documentHelper.userCollection.slice();
                this.userList.dataBind();
            }
        };
        this.documentHelper = documentHelper;
    }
    initUserDialog(localValue, isRtl) {
        //const id: string = this.documentHelper.owner.containerId + '_addUser';
        this.target = createElement('div', { className: 'e-de-user-dlg' });
        const headerValue = localValue.getConstant('Enter User');
        const dlgFields = createElement('div', { innerHTML: headerValue, className: 'e-bookmark-dlgfields' });
        this.target.appendChild(dlgFields);
        const commonDiv = createElement('div', { className: 'e-de-user-dlg-common' });
        this.target.appendChild(commonDiv);
        const adduserDiv = createElement('div', { className: 'e-de-user-dlg-list' });
        commonDiv.appendChild(adduserDiv);
        if (isRtl) {
            adduserDiv.classList.add('e-de-rtl');
        }
        // const textBoxDiv: HTMLElement = createElement('div', { className: 'e-de-dlg-container' });
        // adduserDiv.appendChild(textBoxDiv);
        this.textBoxInput = createElement('input', { className: 'e-input e-de-user-dlg-textbox-input', attrs: { autofocus: 'true' } });
        this.textBoxInput.setAttribute('type', 'text');
        adduserDiv.appendChild(this.textBoxInput);
        this.textBoxInput.addEventListener('keyup', this.onKeyUpOnDisplayBox);
        const addButtonElement = createElement('button', {
            innerHTML: localValue.getConstant('Add'),
            attrs: { type: 'button' }
        });
        adduserDiv.appendChild(addButtonElement);
        addButtonElement.addEventListener('click', this.addButtonClick);
        this.addButton = new Button({ cssClass: 'e-de-user-add-btn' });
        this.addButton.disabled = true;
        this.addButton.appendTo(addButtonElement);
        this.addButton.addEventListener('click', this.addButtonClick);
        const userCollectionDiv = createElement('div');
        commonDiv.appendChild(userCollectionDiv);
        const userDiv = createElement('div', { innerHTML: localValue.getConstant('Users'), className: 'e-de-user-dlg-user' });
        userCollectionDiv.appendChild(userDiv);
        const listviewDiv = createElement('div');
        userCollectionDiv.appendChild(listviewDiv);
        this.userList = new ListView({
            cssClass: 'e-de-user-listview'
        });
        this.userList.appendTo(listviewDiv);
    }
    validateUserName(value) {
        if (value.indexOf('@') === -1) {
            return false;
        }
        else {
            const parts = value.split('@');
            const domain = parts[1];
            if (domain.indexOf('.') === -1) {
                return false;
            }
            else {
                const domainParts = domain.split('.');
                const ext = domainParts[1];
                if (domainParts.length > 2) {
                    return false;
                }
                if (ext.length > 4 || ext.length < 2) {
                    return false;
                }
            }
        }
        return true;
    }
}

/**
 * @private
 */
class EnforceProtectionDialog {
    constructor(documentHelper, owner) {
        /**
         * @private
         * @returns {void}
         */
        this.show = () => {
            this.localeValue = new L10n('documenteditor', this.viewer.owner.defaultLocale);
            this.localeValue.setLocale(this.viewer.owner.locale);
            if (!this.target) {
                this.initDialog(this.localeValue);
            }
            this.documentHelper.dialog.header = this.localeValue.getConstant('Start Enforcing Protection');
            this.documentHelper.dialog.height = 'auto';
            this.documentHelper.dialog.content = this.target;
            this.documentHelper.dialog.width = 'auto';
            this.documentHelper.dialog.buttons = [{
                    click: this.okButtonClick,
                    buttonModel: { content: this.localeValue.getConstant('Ok'), cssClass: 'e-flat', isPrimary: true }
                },
                {
                    click: this.hideDialog,
                    buttonModel: { content: this.localeValue.getConstant('Cancel'), cssClass: 'e-flat' }
                }];
            this.passwordTextBox.value = '';
            this.confirmPasswordTextBox.value = '';
            this.documentHelper.dialog.show();
        };
        /**
         * @returns {void}
         */
        this.hideDialog = () => {
            this.passwordTextBox.value = '';
            this.confirmPasswordTextBox.value = '';
            this.documentHelper.dialog.hide();
        };
        /**
         * @private
         * @returns {void}
         */
        this.okButtonClick = () => {
            if (this.passwordTextBox.value !== this.confirmPasswordTextBox.value) {
                DialogUtility.alert(this.localeValue.getConstant('Password Mismatch'));
            }
            else {
                this.password = this.passwordTextBox.value;
                this.viewer.owner.editor.addProtection(this.password, this.owner.protectionType);
            }
        };
        this.documentHelper = documentHelper;
        this.owner = owner;
    }
    get viewer() {
        return this.owner.viewer;
    }
    initDialog(localValue) {
        //const instance: EnforceProtectionDialog = this;
        //const id: string = this.viewer.owner.containerId + '_enforce_protection';
        this.target = createElement('div', { className: 'e-de-enforce' });
        const passwordContainer = createElement('div', { className: 'e-de-container-row' });
        //const newPassWord: HTMLElement = createElement('div', { className: 'e-de-enforce-dlg-title', innerHTML: localValue.getConstant('Enter new password') });
        this.passwordTextBox = createElement('input', { attrs: { type: 'password', autofocus: 'true' }, className: 'e-input' });
        // this.passwordTextBox.addEventListener('keyup', instance.onKeyUpOnDisplayBox);
        //container.appendChild(newPassWord);
        passwordContainer.appendChild(this.passwordTextBox);
        const confirmPasswordcontainer = createElement('div');
        //const confirmPassword: HTMLElement = createElement('div', { className: 'e-de-enforce-dlg-title', innerHTML: localValue.getConstant('Reenter new password to confirm') }) as HTMLDivElement;
        this.confirmPasswordTextBox = createElement('input', { attrs: { type: 'password' }, className: 'e-input' });
        //container.appendChild(confirmPassword);
        confirmPasswordcontainer.appendChild(this.confirmPasswordTextBox);
        this.target.appendChild(passwordContainer);
        this.target.appendChild(confirmPasswordcontainer);
        new TextBox({ placeholder: localValue.getConstant('Enter new password'), floatLabelType: 'Always', cssClass: 'e-de-enforce-dlg-input' }, this.passwordTextBox);
        new TextBox({ placeholder: localValue.getConstant('Reenter new password to confirm'), floatLabelType: 'Always' }, this.confirmPasswordTextBox);
    }
}
/**
 * @private
 */
class UnProtectDocumentDialog {
    constructor(documentHelper, owner) {
        /**
         * @private
         * @returns {void}
         */
        this.show = () => {
            this.localObj = new L10n('documenteditor', this.viewer.owner.defaultLocale);
            this.localObj.setLocale(this.viewer.owner.locale);
            if (!this.target) {
                this.initDialog(this.localObj);
            }
            this.documentHelper.dialog.header = 'Unprotect Document';
            this.documentHelper.dialog.height = 'auto';
            this.documentHelper.dialog.width = 'auto';
            this.documentHelper.dialog.content = this.target;
            this.documentHelper.dialog.buttons = [{
                    click: this.okButtonClick,
                    buttonModel: { content: this.localObj.getConstant('Ok'), cssClass: 'e-flat', isPrimary: true }
                },
                {
                    click: this.hideDialog,
                    buttonModel: { content: this.localObj.getConstant('Cancel'), cssClass: 'e-flat' }
                }];
            this.documentHelper.dialog.dataBind();
            this.passwordTextBox.value = '';
            this.documentHelper.dialog.show();
        };
        /**
         * @private
         * @returns {void}
         */
        this.okButtonClick = () => {
            const password = this.passwordTextBox.value;
            if (password === '') {
                DialogUtility.alert(this.localObj.getConstant('The password is incorrect'));
                return;
            }
            this.viewer.owner.editor.stopProtection(password);
        };
        /**
         * @private
         * @returns {void}
         */
        this.hideDialog = () => {
            this.passwordTextBox.value = '';
            this.documentHelper.dialog.hide();
        };
        this.documentHelper = documentHelper;
        this.owner = owner;
    }
    get viewer() {
        return this.owner.viewer;
    }
    initDialog(localValue) {
        //const instance: UnProtectDocumentDialog = this;
        const id = this.viewer.owner.containerId + '_enforce_protection';
        this.target = createElement('div', { id: id, className: 'e-de-enforce' });
        const container = createElement('div');
        const newPassWord = createElement('div', {
            className: 'e-de-unprotect-dlg-title',
            innerHTML: localValue.getConstant('Password')
        });
        this.passwordTextBox = createElement('input', {
            attrs: { type: 'password' },
            id: this.viewer.owner.containerId + '_display_text', className: 'e-input e-de-enforce-dlg-input'
        });
        // this.passwordTextBox.addEventListener('keyup', instance.onKeyUpOnDisplayBox);
        container.appendChild(newPassWord);
        container.appendChild(this.passwordTextBox);
        this.target.appendChild(container);
    }
}

/**
 * @private
 */
class RestrictEditing {
    constructor(documentHelper) {
        this.addRemove = true;
        this.protectionType = 'ReadOnly';
        this.isShowRestrictPane = false;
        this.isAddUser = false;
        this.usersCollection = ['Everyone'];
        /**
         * @returns {void}
         */
        this.closePane = () => {
            this.restrictPane.style.display = 'none';
            this.documentHelper.updateViewerSize();
        };
        /**
         * @returns {void}
         */
        this.showAllRegion = () => {
            this.documentHelper.selection.showAllEditingRegion();
        };
        this.documentHelper = documentHelper;
        this.addUserDialog = new AddUserDialog(documentHelper);
        this.enforceProtectionDialog = new EnforceProtectionDialog(documentHelper, this);
        this.unProtectDialog = new UnProtectDocumentDialog(documentHelper, this);
        this.base64 = new Base64();
    }
    get viewer() {
        return this.documentHelper.owner.viewer;
    }
    showHideRestrictPane(isShow) {
        if (!this.restrictPane) {
            this.localObj = new L10n('documenteditor', this.viewer.owner.defaultLocale);
            this.localObj.setLocale(this.viewer.owner.locale);
            this.initPane(this.localObj, this.documentHelper.owner.enableRtl);
        }
        if (isShow) {
            this.restrictPane.style.display = 'block';
            this.isShowRestrictPane = true;
            this.documentHelper.selection.isHighlightEditRegion = true;
            this.wireEvents();
            this.documentHelper.updateViewerSize();
            this.loadPaneValue();
        }
        else {
            this.closePane();
            this.documentHelper.updateFocus();
        }
    }
    initPane(localValue, isRtl) {
        this.restrictPane = createElement('div', { className: 'e-de-restrict-pane' });
        if (isRtl) {
            this.restrictPane.classList.add('e-rtl');
        }
        const headerWholeDiv = createElement('div', { className: 'e-de-rp-whole-header' });
        const headerDiv1 = createElement('div', {
            innerHTML: localValue.getConstant('Restrict Editing'), className: 'e-de-rp-header'
        });
        this.closeButton = createElement('button', {
            className: 'e-de-rp-close-icon e-de-close-icon e-btn e-flat e-icon-btn',
            attrs: { type: 'button' }
        });
        headerWholeDiv.appendChild(this.closeButton);
        headerWholeDiv.appendChild(headerDiv1);
        const closeSpan = createElement('span', { className: 'e-de-op-close-icon e-de-close-icon e-btn-icon e-icons' });
        this.closeButton.appendChild(closeSpan);
        this.restrictPane.appendChild(headerWholeDiv);
        this.initRestrictEditingPane(localValue);
        this.documentHelper.optionsPaneContainer.setAttribute('style', 'display:inline-flex;');
        this.documentHelper.optionsPaneContainer.insertBefore(this.restrictPane, this.documentHelper.viewerContainer);
    }
    /* eslint-disable  */
    initRestrictEditingPane(localObj) {
        this.restrictPaneWholeDiv = createElement('div');
        let formatWholeDiv = createElement('div', { className: 'e-de-rp-sub-div' });
        let formatDiv = createElement('div', {
            innerHTML: localObj.getConstant('Formatting restrictions'),
            className: 'e-de-rp-format'
        });
        formatWholeDiv.appendChild(formatDiv);
        let allowFormatting = createElement('input', {
            attrs: { type: 'checkbox' },
        });
        formatWholeDiv.appendChild(allowFormatting);
        this.allowFormat = this.createCheckBox(localObj.getConstant('Allow formatting'), allowFormatting);
        this.restrictPaneWholeDiv.appendChild(formatWholeDiv);
        // Editing restrictions
        let editRestrictWholeDiv = createElement('div', { className: 'e-de-rp-sub-div' });
        // let editRestrict: HTMLElement = createElement('div', {
        //     innerHTML: localObj.getConstant('Editing restrictions'),
        //     className: 'e-de-rp-format'
        // });
        // editRestrictWholeDiv.appendChild(editRestrict);
        let readOnly = createElement('input', {
            attrs: { type: 'checkbox' },
        });
        let protectionTypeInput = createElement('input', {
            className: 'e-prop-font-style'
        });
        editRestrictWholeDiv.appendChild(protectionTypeInput);
        let protectionTypeValue = [
            { Value: 'Read only', Name: localObj.getConstant('Read only') },
            { Value: 'Filling in forms', Name: localObj.getConstant('Filling in forms') },
            { Value: 'Comments', Name: localObj.getConstant('Comments') }
        ];
        this.protectionTypeDrop = new DropDownList({
            dataSource: protectionTypeValue,
            cssClass: 'e-de-prop-dropdown',
            floatLabelType: 'Always',
            placeholder: localObj.getConstant('Editing restrictions'),
            fields: { text: 'Name', value: 'Value' },
            enableRtl: this.documentHelper.owner.enableRtl
        });
        this.protectionTypeDrop.value = 'Read only';
        this.protectionTypeDrop.appendTo(protectionTypeInput);
        // let allowPrint: HTMLInputElement = createElement('input', {
        //     attrs: { type: 'checkbox' },
        //     id: this.viewer.owner.containerId + '_allowPrint'
        // }) as HTMLInputElement;
        // editRestrictWholeDiv.appendChild(allowPrint);
        // this.allowPrint = this.createCheckBox('Allow Printing', allowPrint);
        // let allowCopy: HTMLInputElement = createElement('input', {
        //     attrs: { type: 'checkbox' },
        //     id: this.viewer.owner.containerId + '_allowCopy'
        // }) as HTMLInputElement;
        // editRestrictWholeDiv.appendChild(allowCopy);
        // this.allowCopy = this.createCheckBox('Allow Copy', allowCopy);
        this.restrictPaneWholeDiv.appendChild(editRestrictWholeDiv);
        // User Permissions
        this.userWholeDiv = createElement('div', { className: 'e-de-rp-sub-div' });
        let userDiv = createElement('div', {
            innerHTML: localObj.getConstant('Exceptions Optional'),
            className: 'e-de-rp-format'
        });
        this.userWholeDiv.appendChild(userDiv);
        let subContentDiv = createElement('div', {
            innerHTML: localObj.getConstant('Select Part Of Document And User'),
            className: 'e-de-rp-sub-content-div'
        });
        this.userWholeDiv.appendChild(subContentDiv);
        let emptyuserDiv = createElement('div', { className: 'e-de-rp-user' });
        this.userWholeDiv.appendChild(emptyuserDiv);
        this.addedUser = new ListView({
            cssClass: 'e-de-user-listView',
            dataSource: [{ text: 'Everyone' }],
            showCheckBox: true,
            select: this.selectHandler.bind(this),
            enableRtl: this.documentHelper.owner.enableRtl
        });
        this.addedUser.appendTo(emptyuserDiv);
        this.addUser = createElement('button', {
            className: 'e-btn e-primary e-flat e-de-rp-mu-btn',
            innerHTML: localObj.getConstant('More users') + '...',
            //styles: 'margin-top: 3px',
            attrs: { type: 'button' }
        });
        this.userWholeDiv.appendChild(this.addUser);
        this.restrictPaneWholeDiv.appendChild(this.userWholeDiv);
        let lastDiv = createElement('div', { className: 'e-de-rp-enforce' });
        this.restrictPaneWholeDiv.appendChild(lastDiv);
        this.enforceProtection = createElement('button', {
            innerHTML: localObj.getConstant('Enforcing Protection'),
            className: 'e-btn e-de-rp-btn-enforce',
            attrs: { type: 'button' }
        });
        lastDiv.appendChild(this.enforceProtection);
        this.restrictPane.appendChild(this.restrictPaneWholeDiv);
        this.stopProtectionDiv = createElement('div', { styles: 'display:none' });
        let headerDiv = createElement('div', { innerHTML: localObj.getConstant('Your permissions'), className: 'e-de-rp-stop-div1' });
        this.stopProtectionDiv.appendChild(headerDiv);
        let contentWholeDiv = createElement('div', { className: 'e-de-rp-stop-div2' });
        this.stopProtectionDiv.appendChild(contentWholeDiv);
        let content1 = localObj.getConstant('Protected Document');
        this.contentDiv1 = createElement('div', { innerHTML: content1 });
        contentWholeDiv.appendChild(this.contentDiv1);
        let content2 = localObj.getConstant('ReadOnlyProtection');
        this.contentDiv2 = createElement('div', { innerHTML: content2 });
        contentWholeDiv.appendChild(this.contentDiv2);
        this.stopReadOnlyOptions = createElement('div');
        this.stopProtectionDiv.appendChild(this.stopReadOnlyOptions);
        let navigateNext = createElement('div', { className: 'e-de-rp-enforce-nav' });
        let navigateNextButton = createElement('button', {
            innerHTML: localObj.getConstant('Find Next Region I Can Edit'), className: 'e-btn e-de-rp-nav-btn',
            attrs: { type: 'button' }
        });
        navigateNext.appendChild(navigateNextButton);
        navigateNextButton.addEventListener('click', this.navigateNextRegion.bind(this));
        this.stopReadOnlyOptions.appendChild(navigateNext);
        let showAllRegion = createElement('div', { className: 'e-de-rp-enforce-nav' });
        let showAllRegionButton = createElement('button', {
            innerHTML: localObj.getConstant('Show All Regions I Can Edit'), className: 'e-btn e-de-rp-nav-btn',
            attrs: { type: 'button' }
        });
        showAllRegion.appendChild(showAllRegionButton);
        showAllRegionButton.addEventListener('click', this.showAllRegion);
        this.stopReadOnlyOptions.appendChild(showAllRegion);
        let highlightRegion = createElement('div', { className: 'e-de-rp-nav-lbl e-de-rp-more-less' });
        let highlightRegionInput = createElement('input', { attrs: { type: 'checkbox' }, className: 'e-btn e-de-rp-nav-btn' });
        highlightRegion.appendChild(highlightRegionInput);
        this.stopReadOnlyOptions.appendChild(highlightRegion);
        this.highlightCheckBox = new CheckBox({ label: localObj.getConstant('Highlight the regions I can edit'), enableRtl: this.documentHelper.owner.enableRtl }, highlightRegionInput);
        let lastButtonDiv = createElement('div', { className: 'e-de-rp-enforce' });
        this.stopProtection = createElement('button', {
            innerHTML: localObj.getConstant('Stop Protection'),
            className: 'e-btn e-de-rp-btn-stop-enforce',
            attrs: { type: 'button' }
        });
        lastButtonDiv.appendChild(this.stopProtection);
        this.stopProtectionDiv.appendChild(lastButtonDiv);
        this.restrictPane.appendChild(this.stopProtectionDiv);
    }
    showStopProtectionPane(show) {
        if (show) {
            this.stopProtectionDiv.style.display = 'block';
            this.restrictPaneWholeDiv.style.display = 'none';
        }
        else {
            this.stopProtectionDiv.style.display = 'none';
            this.restrictPaneWholeDiv.style.display = 'block';
        }
        switch (this.documentHelper.protectionType) {
            case 'ReadOnly':
                this.stopReadOnlyOptions.style.display = 'block';
                break;
            case 'CommentsOnly':
                this.stopReadOnlyOptions.style.display = 'block';
                break;
            default:
                this.stopReadOnlyOptions.style.display = 'none';
                break;
        }
    }
    wireEvents() {
        this.addUser.addEventListener('click', this.addUserDialog.show);
        this.enforceProtection.addEventListener('click', this.protectDocument.bind(this));
        this.stopProtection.addEventListener('click', this.stopProtectionTriggered.bind(this));
        this.closeButton.addEventListener('click', this.closePane);
        this.allowFormat.addEventListener('change', this.enableFormatting.bind(this));
        this.protectionTypeDrop.addEventListener('change', this.protectionTypeDropChanges.bind(this));
        this.highlightCheckBox.addEventListener('change', this.highlightClicked.bind(this));
    }
    /* eslint-disable @typescript-eslint/no-explicit-any */
    enableFormatting(args) {
        this.documentHelper.restrictFormatting = !args.checked;
    }
    stopProtectionTriggered(args) {
        if ((isNullOrUndefined(this.documentHelper.saltValue) || this.documentHelper.saltValue === '')
            && (isNullOrUndefined(this.documentHelper.hashValue) || this.documentHelper.hashValue === '')) {
            this.documentHelper.owner.editor.unProtectDocument();
            return;
        }
        this.unProtectDialog.show();
    }
    protectionTypeDropChanges(args) {
        switch (args.value) {
            case 'Read only':
                this.protectionType = 'ReadOnly';
                this.userWholeDiv.style.display = 'block';
                //this.enforceProtection.style.marginLeft = '0px';
                this.contentDiv1.innerHTML = this.localObj.getConstant('Protected Document');
                this.contentDiv2.innerHTML = this.localObj.getConstant('ReadOnlyProtection');
                //this.contentDiv2.style.display = 'block';
                break;
            case 'Filling in forms':
                this.protectionType = 'FormFieldsOnly';
                this.userWholeDiv.style.display = 'none';
                //this.enforceProtection.style.marginLeft = '8px';
                this.contentDiv1.innerHTML = this.localObj.getConstant('Protected Document');
                this.contentDiv2.innerHTML = this.localObj.getConstant('FormFieldsOnly');
                //this.contentDiv2.style.display = 'block';
                break;
            case 'Comments':
                this.protectionType = 'CommentsOnly';
                this.userWholeDiv.style.display = 'block';
                //this.enforceProtection.style.marginLeft = '0px';
                this.contentDiv1.innerHTML = this.localObj.getConstant('Protected Document');
                this.contentDiv2.innerHTML = this.localObj.getConstant('CommentsOnly');
                //this.contentDiv2.style.display = 'none';
                break;
            default:
                this.protectionType = 'NoProtection';
                this.addedUser.uncheckAllItems();
                this.viewer.owner.editor.removeAllEditRestrictions();
                break;
        }
    }
    selectHandler(args) {
        if (args.isChecked) {
            this.viewer.owner.editor.insertEditRangeElement(args.text);
            args.event.target.classList.add('e-check');
        }
        else {
            this.viewer.owner.editor.removeUserRestrictions(args.text);
        }
    }
    highlightClicked(args) {
        this.documentHelper.selection.isHighlightEditRegion = args.checked;
    }
    /* eslint-enable @typescript-eslint/no-explicit-any */
    protectDocument() {
        this.enforceProtectionDialog.show();
    }
    createCheckBox(label, element) {
        let checkBox = new CheckBox({ label: label, enableRtl: this.documentHelper.owner.enableRtl });
        checkBox.appendTo(element);
        return checkBox;
    }
    loadPaneValue() {
        // if (!this.isAddUser) {
        //     this.protectionType = this.documentHelper.protectionType;
        // }
        this.allowFormat.checked = !this.documentHelper.restrictFormatting;
        switch (this.documentHelper.protectionType) {
            case 'ReadOnly':
                this.protectionTypeDrop.value = 'Read only';
                break;
            case 'FormFieldsOnly':
                this.protectionTypeDrop.value = 'Filling in forms';
                break;
            case 'CommentsOnly':
                this.protectionTypeDrop.value = 'Comments';
                break;
        }
        this.highlightCheckBox.checked = true;
        this.addedUser.enablePersistence = true;
        this.addedUser.dataSource = this.usersCollection.slice();
        this.addedUser.dataBind();
        this.showStopProtectionPane(this.documentHelper.isDocumentProtected);
    }
    navigateNextRegion() {
        this.documentHelper.selection.navigateToNextEditingRegion();
    }
    addUserCollection() {
        if (this.documentHelper.selection && this.documentHelper.selection.editRangeCollection.length > 0) {
            for (let i = 0; i < this.documentHelper.selection.editRangeCollection.length; i++) {
                let editStart = this.documentHelper.selection.editRangeCollection[i];
                if (editStart.user !== '' && this.usersCollection.indexOf(editStart.user) === -1) {
                    this.usersCollection.push(editStart.user);
                }
                if (editStart.group !== '' && this.usersCollection.indexOf(editStart.group) === -1) {
                    this.usersCollection.push(editStart.group);
                }
            }
        }
        this.addedUser.dataSource = this.documentHelper.userCollection.slice();
        this.addedUser.dataBind();
    }
    updateUserInformation() {
        this.addedUser.uncheckAllItems();
        if (this.documentHelper.selection.checkSelectionIsAtEditRegion) {
            let editRange = this.documentHelper.selection.getEditRangeStartElement();
            if (editRange) {
                let index = this.addedUser.dataSource.indexOf(editRange.user);
                if (index > -1) {
                    let listElement = this.addedUser.element.querySelectorAll('li')[index];
                    listElement.querySelector('.e-icons').classList.add('e-check');
                }
                index = this.addedUser.dataSource.indexOf(editRange.group);
                if (index > -1) {
                    let listElement = this.addedUser.element.querySelectorAll('li')[index];
                    listElement.querySelector('.e-icons').classList.add('e-check');
                }
            }
        }
    }
}

/**
 * @private
 */
class FormFieldPopUp {
    /**
     * @param {DocumentEditor} owner - Specifies the document editor.
     * @private
     */
    constructor(owner) {
        /**
         * @returns {void}
         */
        this.applyTextFormFieldValue = () => {
            this.owner.editor.updateFormField(this.formField, this.textBoxInstance.value);
            this.owner.trigger(afterFormFieldFillEvent, { 'fieldName': this.formField.formFieldData.name, value: this.formField.resultText, isCanceled: false });
            this.hidePopup();
        };
        /**
         * @returns {void}
         */
        this.applyNumberFormFieldValue = () => {
            this.owner.editor.updateFormField(this.formField, this.numberInput.value.toString());
            this.owner.trigger(afterFormFieldFillEvent, { 'fieldName': this.formField.formFieldData.name, value: this.formField.resultText, isCanceled: false });
            this.hidePopup();
        };
        /**
         * @returns {void}
         */
        this.applyDateFormFieldValue = () => {
            if (!isNullOrUndefined(this.datePickerInstance.value)) {
                this.owner.editor.updateFormField(this.formField, this.dateInput.value);
                this.owner.trigger(afterFormFieldFillEvent, { 'fieldName': this.formField.formFieldData.name, value: this.formField.resultText, isCanceled: false });
                this.hidePopup();
            }
        };
        /**
         * @returns {void}
         */
        this.applyDropDownFormFieldValue = () => {
            this.owner.editor.updateFormField(this.formField, this.ddlInstance.index);
            this.owner.trigger(afterFormFieldFillEvent, { 'fieldName': this.formField.formFieldData.name, value: this.formField.formFieldData.selectedIndex, isCanceled: false });
            this.hidePopup();
        };
        /**
         * @param {ChangedEventArgs} args - Specifies the event args.
         * @returns {void}
         */
        this.enableDisableDatePickerOkButton = (args) => {
            if (args.isInteracted) {
                this.dataPickerOkButton.disabled = false;
            }
        };
        /**
         * @private
         * @returns {void}
         */
        this.closeButton = () => {
            const field = this.formField;
            this.hidePopup();
            const eventArgs = { 'fieldName': field.formFieldData.name };
            if (field.formFieldData instanceof TextFormField) {
                eventArgs.value = field.resultText;
            }
            else if (field.formFieldData instanceof CheckBoxFormField) {
                eventArgs.value = field.formFieldData.checked;
            }
            else {
                eventArgs.value = field.formFieldData.selectedIndex;
            }
            eventArgs.isCanceled = true;
            this.owner.trigger(afterFormFieldFillEvent, eventArgs);
        };
        /**
         * @private
         * @returns {void}
         */
        this.hidePopup = () => {
            this.owner.documentHelper.isFormFilling = false;
            this.formField = undefined;
            if (this.target) {
                this.target.style.display = 'none';
            }
            if (this.popupObject) {
                this.popupObject.hide();
                this.popupObject.destroy();
                this.popupObject = undefined;
            }
        };
        this.owner = owner;
    }
    initPopup() {
        const popupElement = createElement('div', { className: 'e-de-form-popup' });
        this.textBoxContainer = this.initTextBoxInput();
        popupElement.appendChild(this.textBoxContainer);
        popupElement.appendChild(this.initNumericTextBox());
        popupElement.appendChild(this.initDatePicker());
        popupElement.appendChild(this.initDropDownList());
        this.target = popupElement;
        this.owner.documentHelper.viewerContainer.appendChild(popupElement);
    }
    initTextBoxInput() {
        const textBoxDiv = createElement('div', { className: 'e-de-txt-field' });
        const textBoxInput = createElement('input', { className: 'e-de-txt-form' });
        const textBox = new TextBox();
        this.textBoxInput = textBoxInput;
        const textBoxButtonDiv = createElement('div', { className: 'e-de-cmt-action-button' });
        const textBoxOkButton = createElement('button');
        const textBoxCancelButton = createElement('button');
        textBoxOkButton.addEventListener('click', this.applyTextFormFieldValue);
        textBoxCancelButton.addEventListener('click', this.closeButton);
        textBoxDiv.appendChild(textBoxInput);
        textBoxButtonDiv.appendChild(textBoxOkButton);
        textBoxButtonDiv.appendChild(textBoxCancelButton);
        textBoxDiv.appendChild(textBoxButtonDiv);
        textBox.appendTo(textBoxInput);
        new Button({ cssClass: 'e-de-save e-primary', iconCss: 'e-de-save-icon' }, textBoxOkButton);
        new Button({ cssClass: 'e-de-cancel', iconCss: 'e-de-cancel-icon' }, textBoxCancelButton);
        this.textBoxInstance = textBox;
        return textBoxDiv;
    }
    initNumericTextBox() {
        const numericDiv = createElement('div', { className: 'e-de-num-field' });
        const numberInput = createElement('input', { className: 'e-de-txt-form' });
        const numericTextBox = new NumericTextBox();
        this.numberInput = numberInput;
        const textBoxButtonDiv = createElement('div', { className: 'e-de-cmt-action-button' });
        const textBoxOkButton = createElement('button');
        const textBoxCancelButton = createElement('button');
        textBoxOkButton.addEventListener('click', this.applyNumberFormFieldValue);
        textBoxCancelButton.addEventListener('click', this.closeButton);
        numericDiv.appendChild(numberInput);
        textBoxButtonDiv.appendChild(textBoxOkButton);
        textBoxButtonDiv.appendChild(textBoxCancelButton);
        numericDiv.appendChild(textBoxButtonDiv);
        numericTextBox.appendTo(numberInput);
        new Button({ cssClass: 'e-de-save e-primary', iconCss: 'e-de-save-icon' }, textBoxOkButton);
        new Button({ cssClass: 'e-de-cancel', iconCss: 'e-de-cancel-icon' }, textBoxCancelButton);
        this.numericTextBoxInstance = numericTextBox;
        return numericDiv;
    }
    initDatePicker() {
        const dateDiv = createElement('div', { className: 'e-de-date-field' });
        const dateInput = createElement('input', { className: 'e-de-txt-form' });
        /* eslint-disable-next-line max-len */
        const datePicker = new DateTimePicker({ strictMode: true, change: this.enableDisableDatePickerOkButton });
        this.dateInput = dateInput;
        const textBoxButtonDiv = createElement('div', { className: 'e-de-cmt-action-button' });
        const textBoxOkButton = createElement('button');
        const textBoxCancelButton = createElement('button');
        textBoxOkButton.addEventListener('click', this.applyDateFormFieldValue);
        textBoxCancelButton.addEventListener('click', this.closeButton);
        dateDiv.appendChild(dateInput);
        textBoxButtonDiv.appendChild(textBoxOkButton);
        textBoxButtonDiv.appendChild(textBoxCancelButton);
        dateDiv.appendChild(textBoxButtonDiv);
        datePicker.appendTo(dateInput);
        this.dataPickerOkButton = new Button({ cssClass: 'e-de-save e-primary', iconCss: 'e-de-save-icon' }, textBoxOkButton);
        new Button({ cssClass: 'e-de-cancel', iconCss: 'e-de-cancel-icon' }, textBoxCancelButton);
        this.datePickerInstance = datePicker;
        return dateDiv;
    }
    initDropDownList() {
        const dropDownDiv = createElement('div', { className: 'e-de-ddl-field' });
        const dropDownInput = createElement('input', { className: 'e-de-txt-form' });
        const ddl = new DropDownList();
        this.dropDownInput = dropDownInput;
        const textBoxButtonDiv = createElement('div', { className: 'e-de-cmt-action-button' });
        const textBoxOkButton = createElement('button');
        const textBoxCancelButton = createElement('button');
        textBoxOkButton.addEventListener('click', this.applyDropDownFormFieldValue);
        textBoxCancelButton.addEventListener('click', this.closeButton);
        dropDownDiv.appendChild(dropDownInput);
        textBoxButtonDiv.appendChild(textBoxOkButton);
        textBoxButtonDiv.appendChild(textBoxCancelButton);
        dropDownDiv.appendChild(textBoxButtonDiv);
        ddl.appendTo(dropDownInput);
        new Button({ cssClass: 'e-de-save e-primary', iconCss: 'e-de-save-icon' }, textBoxOkButton);
        new Button({ cssClass: 'e-de-cancel', iconCss: 'e-de-cancel-icon' }, textBoxCancelButton);
        this.ddlInstance = ddl;
        return dropDownDiv;
    }
    /**
     * @private
     * @param {FieldElementBox} formField - Specifies the field element.
     * @returns {void}
     */
    showPopUp(formField) {
        if (formField) {
            this.formField = formField;
            this.owner.selection.selectField();
            if (isNullOrUndefined(this.target)) {
                this.initPopup();
            }
            classList(this.target, [], ['e-de-txt-form', 'e-de-num-form', 'e-de-date-form', 'e-de-ddl-form']);
            const formFieldData = formField.formFieldData;
            if (formFieldData) {
                if (formFieldData instanceof TextFormField) {
                    let resultText = formField.resultText;
                    const rex = new RegExp(this.owner.documentHelper.textHelper.getEnSpaceCharacter(), 'gi');
                    if (resultText.replace(rex, '') === '') {
                        resultText = '';
                    }
                    const maxLength = formFieldData.maxLength;
                    const formFieldType = formFieldData.type;
                    let inputElement;
                    resultText = resultText ? resultText : '';
                    if (formFieldType === 'Text') {
                        classList(this.target, ['e-de-txt-form'], []);
                        inputElement = this.textBoxInput;
                        this.textBoxInstance.value = resultText;
                    }
                    else if (formFieldData.type === 'Number') {
                        classList(this.target, ['e-de-num-form'], []);
                        inputElement = this.numberInput;
                        this.numericTextBoxInstance.format = formFieldData.format;
                        this.numericTextBoxInstance.value = parseFloat(resultText.replace(/,/gi, ''));
                    }
                    else if (formFieldType === 'Date') {
                        classList(this.target, ['e-de-date-form'], []);
                        inputElement = this.dateInput;
                        let format = formFieldData.format;
                        if (format.indexOf('am/pm') !== -1) {
                            format = format.replace(/am\/pm/gi, 'a');
                        }
                        this.datePickerInstance.format = format;
                        this.datePickerInstance.value = new Date(resultText);
                        this.dataPickerOkButton.disabled = true;
                    }
                    if (inputElement) {
                        if (maxLength > 0) {
                            inputElement.maxLength = maxLength;
                        }
                        else {
                            inputElement.removeAttribute('maxlength');
                        }
                        setTimeout(() => {
                            inputElement.focus();
                        });
                    }
                }
                else if (formFieldData instanceof DropDownFormField) {
                    classList(this.target, ['e-de-ddl-form'], []);
                    this.ddlInstance.dataSource = formFieldData.dropdownItems;
                    this.ddlInstance.index = formFieldData.selectedIndex;
                    setTimeout(() => {
                        this.ddlInstance.showPopup();
                    });
                }
                const left = this.owner.selection.getLeftInternal(formField.line, formField, 0);
                const lineHeight = formField.line.height * this.owner.documentHelper.zoomFactor;
                const position = this.owner.selection.getTooltipPosition(formField.line, left, this.target, true);
                if (!this.popupObject) {
                    this.popupObject = new Popup(this.target, {
                        height: 'auto',
                        width: 'auto',
                        relateTo: this.owner.documentHelper.viewerContainer.parentElement,
                        position: { X: position.x, Y: position.y + lineHeight }
                    });
                }
                this.target.style.display = 'block';
                this.popupObject.show();
            }
            this.owner.documentHelper.isFormFilling = true;
        }
    }
}

/**
 * Track changes pane
 */
class TrackChangesPane {
    constructor(owner, commentReviewPane) {
        this.users = [];
        this.enableButtons = true;
        this.viewTypeitems = [];
        this.sortedRevisions = [];
        this.noChangesVisibleInternal = true;
        this.isTrackingPageBreak = false;
        this.owner = owner;
        this.commentReviewPane = commentReviewPane;
        this.locale = new L10n('documenteditor', this.owner.defaultLocale);
        this.locale.setLocale(this.owner.locale);
        this.selectedUser = this.locale.getConstant('All');
        this.selectedType = this.locale.getConstant('All');
        this.initTrackChangePane();
        this.commentReviewPane.reviewTab.items[1].content = this.trackChangeDiv;
    }
    get setNoChangesVisibility() {
        return this.noChangesVisibleInternal;
    }
    set setNoChangesVisibility(visible) {
        this.isChangesTabVisible = !visible;
        this.noChangeDivElement.style.display = visible ? 'block' : 'none';
        this.noChangesVisibleInternal = visible;
        this.enableDisableToolbarItem(!visible);
        this.commentReviewPane.reviewTab.hideTab(1, visible);
        this.owner.notify('reviewPane', { changes: !visible, comment: this.commentReviewPane.isCommentTabVisible });
    }
    get currentSelectedRevision() {
        return this.currentSelectedRevisionInternal;
    }
    set currentSelectedRevision(value) {
        let selectedElement = select('.e-de-trckchanges-inner-select', this.changesInfoDiv);
        if (isNullOrUndefined(value)) {
            if (!isNullOrUndefined(selectedElement)) {
                selectedElement.classList.remove('e-de-trckchanges-inner-select');
            }
        }
        else if (value !== this.currentSelectedRevisionInternal || isNullOrUndefined(selectedElement)) {
            if (selectedElement) {
                selectedElement.classList.remove('e-de-trckchanges-inner-select');
            }
            if (this.changes.length > 0 && this.changes.containsKey(value)) {
                const currentChangeView = this.changes.get(value);
                currentChangeView.singleInnerDiv.classList.add('e-de-trckchanges-inner-select');
            }
        }
        this.currentSelectedRevisionInternal = value;
        selectedElement = select('.e-de-trckchanges-inner-select', this.changesInfoDiv);
        if (!isNullOrUndefined(selectedElement)) {
            selectedElement.parentElement.scrollIntoView({ block: 'nearest' });
        }
    }
    initTrackChangePane() {
        this.changes = new Dictionary();
        this.trackChangeDiv = createElement('div', { className: 'e-de-tc-pane' });
        this.trackChangeDiv.appendChild(this.initPaneHeader());
        this.changesInfoDiv = createElement('div', { id: 'e-de-tc-pane-revision', styles: 'overflow:auto' });
        this.trackChangeDiv.appendChild(this.changesInfoDiv);
        this.noChangeDivElement = createElement('div', { styles: 'display:none;', className: 'e-de-tc-no-chng' });
        this.noChangeDivElement.textContent = this.locale.getConstant('No changes');
        this.changesInfoDiv.appendChild(this.noChangeDivElement);
        this.updateTrackChanges();
    }
    initPaneHeader() {
        this.toolbarElement = createElement('div', { className: 'e-de-track-toolbar' });
        this.toolbar = new Toolbar({
            enableRtl: this.owner.enableRtl,
            items: [
                {
                    template: this.locale.getConstant('User') + ':', cssClass: 'e-de-track-toolbar-overlay', disabled: true
                },
                {
                    template: createElement('div', { id: 'e-de-user-list' })
                },
                {
                    type: 'Separator'
                },
                {
                    template: this.locale.getConstant('View') + ':', cssClass: 'e-de-track-toolbar-overlay', disabled: true
                },
                {
                    template: createElement('div', { id: 'e-de-revision-list' })
                },
                {
                    prefixIcon: 'e-de-nav-left-arrow e-de-tc-tbr', align: 'Right', cssClass: 'e-de-nvgte-left',
                    tooltipText: this.locale.getConstant('Previous Changes'), click: this.navigatePreviousChanges.bind(this)
                },
                {
                    prefixIcon: 'e-de-nav-right-arrow e-de-tc-tbr', align: 'Right', cssClass: 'e-de-nvgte-right',
                    tooltipText: this.locale.getConstant('Next Changes'), click: this.navigateNextChanges.bind(this)
                },
                {
                    template: createElement('div', { id: 'e-de-menu-option' }), align: 'Right', cssClass: 'e-de-tc-tbr',
                    tooltipText: this.locale.getConstant('More Options') + '...'
                }
            ]
        });
        this.toolbar.appendTo(this.toolbarElement);
        const navigateLeftButton = select('.e-de-nvgte-left', this.toolbarElement);
        navigateLeftButton.firstChild.classList.add('e-tc-nvgte');
        const navigateRightButton = select('.e-de-nvgte-right', this.toolbarElement);
        navigateRightButton.firstChild.classList.add('e-tc-nvgte');
        //User list drop down button
        const userButtonEle = select('#e-de-user-list', this.toolbarElement);
        this.userDropDownitems = [{ text: this.locale.getConstant('All') }];
        this.userDropDown = {
            items: this.userDropDownitems,
            cssClass: 'e-de-track-pane-drop-btn e-tc-btn-bg-clr',
            select: this.onUserSelect.bind(this),
            beforeOpen: this.onUserOpen.bind(this),
            beforeItemRender: (args) => {
                this.beforeDropDownItemRender(args, this.selectedUser);
            }
        };
        this.userDropDownButton = new DropDownButton(this.userDropDown);
        this.userDropDownButton.appendTo(userButtonEle);
        this.userDropDownButton.content = this.getSpanView(this.userDropDown.items[0].text, 0);
        //Revision view type drop down button
        const viewTypeEle = select('#e-de-revision-list', this.toolbarElement);
        this.viewTypeitems = [{ text: this.locale.getConstant('All') }, { text: this.locale.getConstant('Inserted') }, { text: this.locale.getConstant('Deleted') }];
        this.viewTypeDropDownButton = new DropDownButton({
            items: this.viewTypeitems,
            cssClass: 'e-de-track-pane-drop-btn e-tc-btn-bg-clr',
            select: this.onTypeSelect.bind(this),
            beforeItemRender: (args) => {
                this.beforeDropDownItemRender(args, this.selectedType);
            }
        });
        this.viewTypeDropDownButton.content = this.getSpanView(this.viewTypeitems[0].text, 1);
        this.viewTypeDropDownButton.appendTo(viewTypeEle);
        //More menu option drop down button
        this.menuoptionEle = select('#e-de-menu-option', this.toolbarElement);
        const menuOptions = [{ text: this.locale.getConstant('Accept all') }, { text: this.locale.getConstant('Reject all') }];
        const menuDropDown = {
            items: menuOptions,
            select: this.onMenuSelect.bind(this),
            iconCss: 'e-de-menu-icon',
            cssClass: 'e-caret-hide e-tc-btn-bg-clr'
        };
        this.menuDropDownButton = new DropDownButton(menuDropDown);
        this.menuDropDownButton.appendTo(this.menuoptionEle);
        return this.toolbarElement;
    }
    beforeDropDownItemRender(args, content) {
        args.element.innerHTML = '<span></span>' + args.item.text;
        const span = args.element.children[0];
        if (args.item.text === content) {
            span.style.marginRight = '10px';
            span.style.alignSelf = 'center';
            span.setAttribute('class', 'e-de-selected-item e-icons');
        }
        else {
            args.element.children[0].style.marginRight = '25px';
            args.element.children[0].classList.remove('e-de-selected-item');
        }
    }
    onUserOpen(arg) {
        const ele = arg.element;
        ele.style.maxHeight = '200px';
        ele.style.overflowY = 'auto';
    }
    enableDisableToolbarItem(enable) {
        const elements = this.toolbar.element.querySelectorAll('.e-de-tc-tbr');
        if (this.owner && this.owner.viewer) {
            this.toolbar.enableItems(elements[0].parentElement.parentElement, enable);
            this.toolbar.enableItems(elements[1].parentElement.parentElement, enable);
            this.toolbar.enableItems(elements[2], enable);
        }
    }
    getSpanView(value, type) {
        return (type === 0 ? '<span class="e-de-track-span-user">' : '<span class="e-de-track-span-view">') + value + '</span>';
    }
    onMenuSelect(arg) {
        const selectedText = arg.item.text;
        if (selectedText.match(this.locale.getConstant('Accept all'))) {
            setTimeout(() => {
                this.owner.revisionsInternal.handleRevisionCollection(true, this.sortedRevisions);
            }, 0);
        }
        else if (selectedText.match(this.locale.getConstant('Reject all'))) {
            setTimeout(() => {
                this.owner.revisionsInternal.handleRevisionCollection(false, this.sortedRevisions);
                /* eslint-disable */
            }, 0);
        }
        this.updateUsers();
    }
    onSelection(revision) {
        this.currentSelectedRevision = revision;
    }
    onUserSelect(arg) {
        let selectedText = arg.item.text;
        this.selectedUser = selectedText;
        this.userDropDownButton.content = this.getSpanView(selectedText, 0);
        this.sortCollectionToDisplay();
    }
    onTypeSelect(arg) {
        let selectedText = arg.item.text;
        this.selectedType = selectedText;
        this.viewTypeDropDownButton.content = this.getSpanView(selectedText, 1);
        this.sortCollectionToDisplay();
    }
    updateMenuOptions() {
        let revisionType;
        if (this.selectedType !== this.locale.getConstant('All')) {
            revisionType = this.selectedType === this.locale.getConstant('Inserted') ? this.locale.getConstant('Insertion')
                : this.locale.getConstant('Deletion');
        }
        if (this.selectedUser === this.locale.getConstant('All') && this.selectedType === this.locale.getConstant('All')) {
            this.menuDropDownButton.items[0].text = this.locale.getConstant('Accept all') + ' ' + this.locale.getConstant('Changes');
            this.menuDropDownButton.items[1].text = this.locale.getConstant('Reject all') + ' ' + this.locale.getConstant('Changes');
        }
        else if (this.selectedUser === this.locale.getConstant('All') && this.selectedType !== this.locale.getConstant('All')) {
            this.menuDropDownButton.items[0].text = this.locale.getConstant('Accept all') + ' ' + revisionType;
            this.menuDropDownButton.items[1].text = this.locale.getConstant('Reject all') + ' ' + revisionType;
        }
        else if (this.selectedUser !== this.locale.getConstant('All') && this.selectedType === this.locale.getConstant('All')) {
            this.menuDropDownButton.items[0].text = this.locale.getConstant('Accept all') + ' ' + this.locale.getConstant('Changes') +
                ' ' + this.locale.getConstant('By').toLowerCase() + ' ' + this.selectedUser;
            this.menuDropDownButton.items[1].text = this.locale.getConstant('Reject all') + ' ' + this.locale.getConstant('Changes') +
                ' ' + this.locale.getConstant('By').toLowerCase() + ' ' + this.selectedUser;
        }
        else {
            this.menuDropDownButton.items[0].text = this.locale.getConstant('Accept all') + ' ' + revisionType +
                ' ' + this.locale.getConstant('By').toLowerCase() + ' ' + this.selectedUser;
            this.menuDropDownButton.items[1].text = this.locale.getConstant('Reject all') + ' ' + revisionType +
                ' ' + this.locale.getConstant('By').toLowerCase() + ' ' + this.selectedUser;
        }
    }
    sortCollectionToDisplay() {
        let isRevisionVisible = false;
        this.sortedRevisions = [];
        this.updateMenuOptions();
        for (let i = 0; i < this.changes.length; i++) {
            let changes = this.changes.get(this.revisions[i]);
            let singleChangesDiv = changes.outerSingleDiv;
            if (this.selectedUser === this.locale.getConstant('All') && this.selectedType === this.locale.getConstant('All')) {
                singleChangesDiv.style.display = 'block';
                isRevisionVisible = true;
            }
            else if (this.selectedUser === this.locale.getConstant('All') && this.selectedType !== this.locale.getConstant('All')) {
                if (changes.revisionType === this.selectedType) {
                    singleChangesDiv.style.display = 'block';
                    isRevisionVisible = true;
                }
                else {
                    singleChangesDiv.style.display = 'none';
                }
            }
            else if (this.selectedUser !== this.locale.getConstant('All') && this.selectedType === this.locale.getConstant('All')) {
                if (changes.user === this.selectedUser) {
                    singleChangesDiv.style.display = 'block';
                    isRevisionVisible = true;
                }
                else {
                    singleChangesDiv.style.display = 'none';
                }
            }
            else {
                if (changes.user === this.selectedUser && changes.revisionType === this.selectedType) {
                    singleChangesDiv.style.display = 'block';
                    isRevisionVisible = true;
                }
                else {
                    singleChangesDiv.style.display = 'none';
                }
            }
            if (singleChangesDiv.style.display === 'block') {
                this.sortedRevisions.push(this.revisions[i]);
            }
        }
        this.setNoChangesVisibility = !isRevisionVisible;
    }
    enableDisableButton(enableButton) {
        this.enableButtons = enableButton;
        this.updateTrackChanges();
    }
    updateTrackChanges(show) {
        if (show || isNullOrUndefined(show)) {
            this.removeAllChanges();
            if (!this.enableButtons && !this.menuoptionEle.classList.contains('e-de-overlay')) {
                this.menuoptionEle.classList.add('e-de-overlay');
            }
            else if (this.menuoptionEle.classList.contains('e-de-overlay')) {
                this.menuoptionEle.classList.remove('e-de-overlay');
            }
            this.isChangesTabVisible = true;
            this.owner.notify('reviewPane', { comment: this.commentReviewPane.isCommentTabVisible, changes: this.isChangesTabVisible });
            for (let i = 0; i < this.owner.revisions.changes.length; i++) {
                let revision = this.owner.revisions.changes[i];
                this.addChanges(revision);
            }
            this.sortCollectionToDisplay();
            this.updateUsers();
            if (show) {
                this.currentSelectedRevision = this.currentSelectedRevisionInternal;
                this.updateHeight();
                this.owner.resize();
            }
        }
        else {
            this.currentSelectedRevision = undefined;
        }
    }
    updateUsers() {
        if (this.users.length > 0) {
            this.userDropDownButton.removeItems(this.users);
            this.users = [];
        }
        for (let i = 0; i < this.revisions.length; i++) {
            if (this.users.indexOf(this.revisions[i].author) === -1) {
                this.users.push(this.revisions[i].author);
                this.userDropDownButton.items.push({ text: this.revisions[i].author });
            }
        }
    }
    updateHeight() {
        let tabHeaderHeight = this.commentReviewPane.reviewTab.getRootElement().getElementsByClassName('e-tab-header')[0].getBoundingClientRect().height;
        this.changesInfoDiv.style.height = this.commentReviewPane.parentPaneElement.clientHeight - this.toolbarElement.clientHeight
            - tabHeaderHeight - 2 + 'px';
    }
    removeAllChanges() {
        while (this.changesInfoDiv.childNodes.length > 1) {
            this.changesInfoDiv.removeChild(this.changesInfoDiv.lastChild);
        }
        this.revisions = [];
        this.changes.clear();
    }
    /**
     * @private
     */
    clear() {
        this.removeAllChanges();
        this.selectedUser = this.locale.getConstant('All');
        this.userDropDownButton.content = this.getSpanView(this.selectedUser, 0);
        this.selectedType = this.locale.getConstant('All');
        this.viewTypeDropDownButton.content = this.getSpanView(this.selectedType, 1);
        this.currentSelectedRevision = undefined;
    }
    /**
     * @private
     * @returns {void}
     */
    destroy() {
        this.removeAllChanges();
        if (this.toolbar) {
            this.toolbar.destroy();
        }
        if (this.userDropDownButton) {
            this.userDropDownButton.destroy();
        }
        if (this.menuDropDownButton) {
            this.menuDropDownButton.destroy();
            this.menuDropDownButton = undefined;
        }
        if (this.viewTypeDropDownButton) {
            this.viewTypeDropDownButton.destroy();
        }
        if (this.menuDropDownButton) {
            this.menuDropDownButton.destroy();
            this.menuDropDownButton = undefined;
        }
        if (this.userDropDown) {
            this.userDropDown = undefined;
        }
        if (this.users.length > 0) {
            this.users = [];
        }
        if (this.trackChangeDiv) {
            this.trackChangeDiv = undefined;
        }
    }
    addChanges(revision) {
        let currentChangeView = new ChangesSingleView(this.owner, this);
        this.changesInfoDiv.appendChild(currentChangeView.createSingleChangesDiv(revision));
        if (!this.enableButtons) {
            if (!(currentChangeView.acceptButtonElement.classList.contains('e-de-overlay'))) {
                currentChangeView.acceptButtonElement.classList.add('e-de-overlay');
                currentChangeView.rejectButtonElement.classList.add('e-de-overlay');
            }
        }
        else if (currentChangeView.acceptButtonElement.classList.contains('e-de-overlay')) {
            currentChangeView.acceptButtonElement.classList.remove('e-de-overlay');
            currentChangeView.rejectButtonElement.classList.remove('e-de-overlay');
        }
        this.revisions.push(revision);
        this.changes.add(revision, currentChangeView);
    }
    navigatePreviousChanges() {
        this.owner.selection.navigatePreviousRevision();
    }
    navigateNextChanges() {
        this.owner.selection.navigateNextRevision();
    }
}
class ChangesSingleView {
    constructor(owner, trackChangesPane) {
        this.owner = owner;
        this.locale = new L10n('documenteditor', this.owner.defaultLocale);
        this.locale.setLocale(this.owner.locale);
        this.trackChangesPane = trackChangesPane;
    }
    createSingleChangesDiv(revision) {
        this.revision = revision;
        this.user = revision.author;
        this.outerSingleDiv = createElement('div', { className: 'e-de-tc-outer' });
        this.singleInnerDiv = createElement('div', { className: 'e-de-trckchanges-inner' });
        this.singleInnerDiv.addEventListener('click', this.selectRevision.bind(this));
        this.outerSingleDiv.appendChild(this.singleInnerDiv);
        let userNameTotalDiv = createElement('div', { className: 'e-de-track-usernme-div' });
        let userNameLabel = createElement('div', { innerHTML: revision.author, className: 'e-de-track-user-nme' });
        if (!isNullOrUndefined(revision.author)) {
            userNameTotalDiv.style.display = 'flex';
            this.owner.documentHelper.getAvatar(userNameTotalDiv, userNameLabel, undefined, revision);
        }
        let revisionTypeLabel = createElement('div');
        if (revision.revisionType === 'Insertion') {
            this.revisionType = 'Inserted';
            revisionTypeLabel.innerHTML = this.locale.getConstant('Inserted').toUpperCase();
            revisionTypeLabel.classList.add('e-de-track-insert');
        }
        else if (revision.revisionType === 'Deletion') {
            this.revisionType = 'Deleted';
            revisionTypeLabel.innerHTML = this.locale.getConstant('Deleted').toUpperCase();
            revisionTypeLabel.classList.add('e-de-track-delete');
        }
        else if (revision.revisionType === 'MoveFrom') {
            this.revisionType = 'MoveFrom';
            revisionTypeLabel.innerHTML = this.locale.getConstant('Move From').toUpperCase();
            revisionTypeLabel.classList.add('e-de-track-delete');
            revisionTypeLabel.style.whiteSpace = 'nowrap';
        }
        else if (revision.revisionType === 'MoveTo') {
            this.revisionType = 'MoveTo';
            revisionTypeLabel.innerHTML = this.locale.getConstant('Move To').toUpperCase();
            revisionTypeLabel.classList.add('e-de-track-insert');
            revisionTypeLabel.style.whiteSpace = 'nowrap';
        }
        userNameTotalDiv.appendChild(revisionTypeLabel);
        this.singleInnerDiv.appendChild(userNameTotalDiv);
        let dateView = createElement('div', {
            className: 'e-de-track-date',
            innerHTML: HelperMethods.getModifiedDate(revision.date)
        });
        this.singleInnerDiv.appendChild(dateView);
        let changesTextDiv = createElement('div', {
            className: 'e-de-track-chngs-text'
        });
        this.layoutElementText(revision.range, changesTextDiv);
        this.singleInnerDiv.appendChild(changesTextDiv);
        let buttonTotalDiv = createElement('div', {
            styles: 'display:inline-block;width:100%'
        });
        this.singleInnerDiv.appendChild(buttonTotalDiv);
        let buttonDiv = createElement('div', {
            styles: 'float:left;'
        });
        this.acceptButtonElement = createElement('button', { className: 'e-de-track-accept-button' });
        let acceptButton = new Button({ cssClass: 'e-outline', content: this.locale.getConstant('Accept') });
        buttonDiv.appendChild(this.acceptButtonElement);
        buttonTotalDiv.appendChild(buttonDiv);
        acceptButton.appendTo(this.acceptButtonElement);
        this.acceptButtonElement.addEventListener('click', this.acceptButtonClick.bind(this));
        buttonDiv = createElement('div', {
            styles: 'float:left;'
        });
        this.rejectButtonElement = createElement('button', { className: 'e-de-track-reject-button' });
        let rejectButton = new Button({ cssClass: 'e-outline', content: this.locale.getConstant('Reject') });
        buttonDiv.appendChild(this.rejectButtonElement);
        buttonTotalDiv.appendChild(buttonDiv);
        rejectButton.appendTo(this.rejectButtonElement);
        this.rejectButtonElement.addEventListener('click', this.rejectButtonClick.bind(this));
        let changesCount = createElement('div', { className: 'e-de-track-chngs-count', styles: 'float:right;' });
        let currentCount = this.owner.revisions.changes.indexOf(revision) + 1;
        let totalCount = this.owner.revisions.changes.length;
        changesCount.innerHTML = this.locale.getConstant('Changes') + ' ' + currentCount.toString() +
            ' ' + this.locale.getConstant('of') + ' ' + totalCount.toString();
        buttonTotalDiv.appendChild(changesCount);
        return this.outerSingleDiv;
    }
    selectRevision() {
        this.owner.selection.selectRevision(this.revision);
        this.trackChangesPane.onSelection(this.revision);
    }
    layoutElementText(range, changesText) {
        changesText.style.width = '100%';
        let text = '';
        let toSkip = false;
        for (let i = 0; i < range.length; i++) {
            let element = range[i];
            if (element instanceof FieldElementBox && element.fieldType === 1) {
                toSkip = false;
                continue;
            }
            if (toSkip) {
                continue;
            }
            if (element instanceof FieldElementBox && element.fieldType === 0) {
                toSkip = true;
            }
            if (element instanceof TextElementBox) {
                text += element.text;
            }
            else if (element instanceof FieldElementBox && element.fieldType === 0) {
                let fieldCode = this.owner.selection.getFieldCode(element);
                if (fieldCode.match('TOC ') || fieldCode.match('Toc')) {
                    text += '<Table of Content>';
                    changesText.appendChild(this.addSpan(text));
                    return;
                }
                else if (fieldCode.match('HYPERLINK ') || fieldCode.match('MERGEFIELD') || fieldCode.match('FORMTEXT') || fieldCode.match('PAGE ')) {
                    text += this.owner.editor.retrieveFieldResultantText(element.fieldEnd);
                }
                else if (element.formFieldData) {
                    let emptyChar = this.owner.documentHelper.textHelper.repeatChar(this.owner.documentHelper.textHelper.getEnSpaceCharacter(), 5);
                    if (text !== '') {
                        changesText.appendChild(this.addSpan(text));
                        text = '';
                    }
                    if (element.formFieldData instanceof TextFormField) {
                        changesText.appendChild(this.addSpan(element.formFieldData.defaultValue === '' ? emptyChar : element.formFieldData.defaultValue, 'e-de-tc-field'));
                    }
                    else if (element.formFieldData instanceof DropDownFormField) {
                        changesText.appendChild(this.addSpan(element.formFieldData.dropdownItems.length > 0 ? element.formFieldData.dropdownItems[0] : emptyChar, 'e-de-tc-field'));
                    }
                    else {
                        changesText.appendChild(this.addSpan(element.formFieldData.checked ? String.fromCharCode(9745) : String.fromCharCode(9744), 'e-de-tc-field'));
                    }
                }
            }
            else if (element instanceof ImageElementBox) {
                if (text !== '') {
                    changesText.appendChild(this.addSpan(text));
                    text = '';
                }
                let imageEle = createElement('img');
                imageEle.setAttribute('src', element.imageString);
                imageEle.classList.add('e-de-tc-shrink-img');
                changesText.appendChild(imageEle);
            }
            else if (element instanceof WRowFormat) {
                let tableEle = createElement('table');
                tableEle.classList.add('e-de-track-chng-table');
                tableEle.insertRow();
                for (let i = 0; i < element.ownerBase.childWidgets.length; i++) {
                    tableEle.rows[0].insertCell();
                    tableEle.rows[0].cells[i].classList.add('e-de-tc-tble-cell');
                }
                changesText.appendChild(tableEle);
                return;
            }
            else if (element instanceof WCharacterFormat) {
                if (text !== '') {
                    changesText.appendChild(this.addSpan(text));
                    text = '';
                }
                let paraMark = '¶';
                if (element.ownerBase instanceof ParagraphWidget && element.ownerBase.isEndsWithPageBreak) {
                    paraMark = '............Page Break............' + paraMark;
                }
                changesText.appendChild(this.addSpan(paraMark, 'e-de-tc-pmark'));
                changesText.appendChild(createElement('br'));
            }
        }
        changesText.appendChild(this.addSpan(text));
    }
    addSpan(text, cssClass) {
        let span = createElement('span');
        span.textContent = text;
        if (cssClass) {
            span.classList.add(cssClass);
        }
        return span;
    }
    acceptButtonClick() {
        this.trackChangesPane.changesInfoDiv.removeChild(this.outerSingleDiv);
        this.removeFromParentCollec();
        this.revision.accept();
        if (this.owner.enableHeaderAndFooter) {
            this.owner.editor.updateHeaderFooterWidget();
        }
    }
    rejectButtonClick() {
        this.trackChangesPane.changesInfoDiv.removeChild(this.outerSingleDiv);
        this.removeFromParentCollec();
        this.revision.reject();
        if (this.owner.enableHeaderAndFooter) {
            this.owner.editor.updateHeaderFooterWidget();
        }
    }
    removeFromParentCollec() {
        this.trackChangesPane.changes.remove(this.revision);
        this.trackChangesPane.revisions.splice(this.trackChangesPane.revisions.indexOf(this.revision), 1);
        if (this.trackChangesPane.changes.length === 0) {
            this.trackChangesPane.setNoChangesVisibility = true;
        }
        this.trackChangesPane.updateUsers();
    }
}

/* eslint-disable */
/**
 * @private
 */
class DocumentHelper {
    //#endregion
    constructor(owner) {
        /**
         * @private
         */
        this.scrollbarWidth = 0;
        /**
         * @private
         */
        this.isWebPrinting = false;
        /**
         * @private
         */
        this.isHeaderFooter = false;
        /**
         * @private
         */
        this.currentPage = undefined;
        this.selectionStartPageIn = undefined;
        this.selectionEndPageIn = undefined;
        /**
         * @private
         */
        this.fieldStacks = [];
        /**
         * @private
         */
        this.showRevision = false;
        /**
         * @private
         */
        this.splittedCellWidgets = [];
        /**
         * @private
         */
        this.tableLefts = [];
        /**
         * @private
         */
        this.tapCount = 0;
        this.timer = -1;
        this.isTimerStarted = false;
        /**
         * @private
         */
        this.isFirstLineFitInShiftWidgets = false;
        /**
         * @private
         */
        this.preZoomFactor = 0;
        /**
         * @private
         */
        this.preDifference = -1;
        /**
         * @private
         */
        this.fieldEndParagraph = undefined;
        /**
         * @private
         */
        this.fieldToLayout = undefined;
        /**
         * @private
         */
        this.backgroundColor = '#FFFFFF';
        // Event
        /**
         * @private
         */
        this.isMouseDown = false;
        this.isMouseEntered = false;
        this.scrollMoveTimer = 0;
        /**
         * @private
         */
        this.isSelectionChangedOnMouseMoved = false;
        /**
         * @private
         */
        this.isControlPressed = false;
        /**
         * @private
         */
        this.isTouchInput = false;
        /**
         * @private
         */
        this.isTouchMoved = false;
        /**
         * @private
         */
        this.useTouchSelectionMark = false;
        /**
         * @private
         */
        this.touchDownOnSelectionMark = 0;
        /**
         * @private
         */
        this.isComposingIME = false;
        /**
         * @private
         */
        this.lastComposedText = '';
        /**
         * @private
         */
        this.isCompositionStart = false;
        /**
         * @private
         */
        this.isCompositionUpdated = false;
        /**
         * @private
         */
        this.isCompositionCanceled = false;
        /**
         * @private
         */
        this.isCompositionEnd = false;
        /**
         * @private
         */
        this.prefix = '';
        /**
         * @private
         */
        this.suffix = '';
        /**
         * @private
         */
        this.fields = [];
        /**
         * @private
         */
        this.heightInfoCollection = {};
        /**
         * @private
         */
        this.defaultTabWidth = 36;
        /**
         * @private
         */
        this.dontUseHtmlParagraphAutoSpacing = false;
        /**
         * @private
         */
        this.alignTablesRowByRow = false;
        /**
         * @private
         */
        this.compatibilityMode = 'Word2013';
        /**
         * @private
         */
        this.lists = [];
        /**
         * @private
         */
        this.comments = [];
        /**
         * @private
         */
        this.authors = new Dictionary();
        /**
         * @private
         */
        this.revisionsInternal = new Dictionary();
        /**
         * @private
         */
        this.commentUserOptionId = 1;
        /**
         * @private
         */
        this.abstractLists = [];
        /**
         * @private
         */
        this.styles = new WStyles();
        /**
         * @private
         */
        this.preDefinedStyles = undefined;
        /**
         * @private
         */
        this.isRowOrCellResizing = false;
        /**
         * @private
         */
        this.formFields = [];
        this.isMouseDownInFooterRegion = false;
        this.pageFitTypeIn = 'None';
        /**
         * @private
         */
        this.fieldCollection = [];
        /**
         * @private
         */
        this.isPageField = false;
        /**
         * @private
         */
        this.mouseDownOffset = new Point(0, 0);
        this.zoomFactorInternal = 1;
        /**
         * If movecaretposition is 1, Home key is pressed
         * If moveCaretPosition is 2, End key is pressed
         *
         * @private
         */
        this.moveCaretPosition = 0;
        /**
         * @private
         */
        this.isTextInput = false;
        /**
         * @private
         */
        this.isScrollHandler = false;
        /**
         * @private
         */
        this.triggerElementsOnLoading = false;
        /**
         * @private
         */
        this.triggerSpellCheck = false;
        //Document Protection Properties Starts
        /**
         * preserve the format
         *
         * @private
         */
        this.restrictFormatting = false;
        /**
         * preserve the document protection type either readonly or no protection
         *
         * @private
         */
        this.protectionType = 'NoProtection';
        /**
         * Preserve the password protection is enforced or not
         *
         * @private
         */
        this.isDocumentProtected = false;
        /**
         * preserve the hash value of password
         *
         * @private
         */
        this.hashValue = '';
        /**
         * @private
         */
        this.saltValue = '';
        /**
         * @private
         */
        this.userCollection = [];
        /**
         * @private
         */
        this.cachedPages = [];
        /**
         * @private
         */
        this.skipScrollToPosition = false;
        /**
         * @private
         */
        this.isIosDevice = false;
        /**
         * @private
         */
        this.isMobileDevice = false;
        /**
         * @private
         */
        this.isFormFilling = false;
        /**
         * @private
         */
        this.footnotes = new Footnote();
        /**
         * @private
         */
        this.endnotes = new Footnote();
        /**
         * @private
         */
        this.isFootnoteWidget = false;
        /**
         * @private
         * @param {TextEvent} event - Specifies text event.
         * @returns {void}
         */
        this.onTextInput = (event) => {
            if (!this.isComposingIME) {
                event.preventDefault();
                const text = event.data;
                this.owner.editor.handleTextInput(text);
            }
        };
        //#region Composition Event
        /**
         * Fires when composition starts.
         *
         * @private
         * @returns {void}
         */
        this.compositionStart = () => {
            if (!Browser.isDevice && !this.owner.isReadOnlyMode) {
                this.isComposingIME = true;
                this.positionEditableTarget();
                if (this.owner.editorHistory) {
                    this.owner.editor.initComplexHistory('IMEInput');
                }
            }
            this.isCompositionStart = true;
        };
        /**
         * Fires on every input during composition.
         *
         * @private
         * @returns {void}
         */
        this.compositionUpdated = () => {
            if (this.isComposingIME && !this.owner.isReadOnlyMode) {
                setTimeout(() => {
                    this.owner.editor.insertIMEText(this.getEditableDivTextContent(), true);
                }, 0);
            }
            this.isCompositionUpdated = true;
        };
        /**
         * Fires when user selects a character/word and finalizes the input.
         *
         * @private
         * @param {CompositionEvent} event - Specifies text compisition event.
         * @returns {void}
         */
        this.compositionEnd = (event) => {
            if (this.isComposingIME && !this.owner.isReadOnlyMode) {
                const text = this.getEditableDivTextContent();
                if (text !== '') {
                    this.owner.editor.insertIMEText(text, false);
                }
                this.isComposingIME = false;
                this.lastComposedText = '';
                this.iframe.setAttribute('style', 'pointer-events:none;position:absolute;left:' + this.owner.viewer.containerLeft + 'px;top:' + this.owner.viewer.containerTop + 'px;outline:none;background-color:transparent;width:0px;height:0px;overflow:hidden');
                this.editableDiv.innerHTML = '';
                if (this.owner.editorHistory) {
                    this.owner.editorHistory.updateComplexHistory();
                    if (text === '') {
                        //When the composition in live. The Undo operation will terminate the composition and empty text will be return from text box.
                        //At that time the the history should be updated. Undo the operation and clear the redo stack. This undo operation will not be saved for redo operation.
                        this.owner.editorHistory.undo();
                        this.owner.editorHistory.redoStack.pop();
                    }
                }
            }
            event.preventDefault();
            this.isCompositionUpdated = false;
            this.isCompositionEnd = true;
        };
        /* eslint-enable @typescript-eslint/no-explicit-any */
        /**
         * @private
         * @param {KeyboardEvent} event - Specifies keyboard event
         * @returns {void}
         */
        this.onKeyPressInternal = (event) => {
            const key = event.which || event.keyCode;
            this.triggerElementsOnLoading = false;
            let ctrl = (event.ctrlKey || event.metaKey) ? true : ((key === 17) ? true : false); // ctrl detection
            const alt = event.altKey ? event.altKey : ((key === 18) ? true : false); // alt key detection
            if (Browser.isIE && alt && ctrl) {
                ctrl = false;
            }
            // tslint:disable-next-line:max-line-length
            if (ctrl && event.key === 'v' || ctrl && event.key === 'a' || (ctrl || (this.isControlPressed && Browser.isIE)) && event.key === 'p') {
                if (Browser.isIE) {
                    this.isControlPressed = false;
                }
                return;
            }
            if (!this.owner.isReadOnlyMode || (this.selection && this.selection.isInlineFormFillMode())) {
                const key = event.keyCode || event.charCode;
                let char = '';
                if (key) {
                    char = String.fromCharCode(key);
                }
                else if (event.key) {
                    char = event.key;
                }
                if (char !== ' ' && char !== '\r' && char !== '\b' && char !== String.fromCharCode(27) && !ctrl) {
                    this.owner.editorModule.handleTextInput(char);
                }
                else if (char === ' ') {
                    this.triggerSpellCheck = true;
                    this.owner.editorModule.handleTextInput(' ');
                    this.triggerSpellCheck = false;
                }
                event.preventDefault();
            }
        };
        /**
         * @private
         * @param {KeyboardEvent} event - Specifies keyboard event
         * @returns {void}
         */
        this.onTextInputInternal = (event) => {
            if (!this.owner.isReadOnlyMode) {
                this.owner.editorModule.onTextInputInternal();
            }
            else {
                this.editableDiv.innerText = '';
            }
        };
        /**
         * Fired on paste.
         *
         * @private
         * @param {ClipboardEvent} event - Specifies clipboard event.
         * @returns {void}
         */
        this.onPaste = (event) => {
            if ((!this.owner.isReadOnlyMode && this.owner.editor.canEditContentControl) || this.selection.isInlineFormFillMode()) {
                this.owner.editorModule.pasteInternal(event);
            }
            this.editableDiv.innerText = '';
            event.preventDefault();
        };
        /**
         * Fires when editable div loses focus.
         *
         * @private
         * @returns {void}
         */
        this.onFocusOut = () => {
            if (!isNullOrUndefined(this.selection)) {
                if (this.owner.contextMenuModule && this.owner.contextMenuModule.contextMenuInstance &&
                    this.owner.contextMenuModule.contextMenuInstance.element.style.display === 'block') {
                    return;
                }
                this.selection.hideCaret();
            }
        };
        /**
         * Updates focus to editor area.
         *
         * @private
         * @returns {void}
         */
        this.updateFocus = () => {
            if (this.selection && !(this.isMobileDevice && this.owner.isReadOnly)) {
                if (!Browser.isDevice && !Browser.isIE && !navigator.userAgent.match('Edge')
                    && !isNullOrUndefined(this.iframe)) {
                    this.iframe.focus();
                }
                if (!isNullOrUndefined(this.editableDiv)) {
                    this.editableDiv.focus();
                }
                this.selection.showCaret();
            }
        };
        /**
         * Fires on scrolling.
         *
         * @returns {void}
         */
        this.scrollHandler = () => {
            if (this.scrollTimer) {
                clearTimeout(this.scrollTimer);
            }
            this.clearContent();
            this.isScrollHandler = true;
            if (!Browser.isDevice && !this.isComposingIME) {
                this.iframe.style.top = this.owner.viewer.containerTop + 'px';
                this.iframe.style.left = this.owner.viewer.containerLeft + 'px';
            }
            this.owner.viewer.updateScrollBars();
            const vtHeight = this.owner.viewer.containerTop + this.visibleBounds.height - (this.owner.viewer.padding.top + this.owner.viewer.padding.bottom);
            if (vtHeight > this.pageContainer.offsetHeight) {
                this.viewerContainer.scrollTop = this.owner.viewer.containerTop - (vtHeight - this.pageContainer.offsetHeight);
            }
            if (this.owner.viewer instanceof PageLayoutViewer && !isNullOrUndefined(this.owner)) {
                this.owner.fireViewChange();
            }
            this.isScrollHandler = false;
            this.scrollTimer = setTimeout(() => {
                if (!this.isScrollHandler && !isNullOrUndefined(this.owner) && this.owner.isSpellCheck) {
                    this.isScrollToSpellCheck = true;
                    this.owner.viewer.updateScrollBars();
                }
            }, 200);
        };
        /**
         * Fires when the window gets resized.
         *
         * @private
         * @returns {void}
         */
        this.onWindowResize = () => {
            if (this.resizeTimer) {
                clearTimeout(this.resizeTimer);
            }
            this.resizeTimer = setTimeout(() => {
                if (!isNullOrUndefined(this.owner) && !isNullOrUndefined(this.owner.element)) {
                    this.updateViewerSize();
                    this.clearContent();
                    this.owner.viewer.updateScrollBars();
                    if (!isNullOrUndefined(this.selection)) {
                        this.selection.updateCaretPosition();
                    }
                    this.updateTouchMarkPosition();
                    if (this.owner.contextMenuModule && this.owner.contextMenuModule.contextMenuInstance) {
                        this.owner.contextMenuModule.contextMenuInstance.close();
                    }
                    if (this.resizeTimer) {
                        clearTimeout(this.resizeTimer);
                    }
                }
            }, 200);
        };
        /**
         * @private
         * @param {MouseEvent} event - Specified mouse event.
         * @returns {void}
         */
        this.onContextMenu = (event) => {
            if (this.owner.contextMenuModule) {
                if (this.isMouseDown) {
                    this.isMouseDown = false;
                }
                this.owner.contextMenuModule.onContextMenuInternal(event);
            }
        };
        /**
         * Called on mouse down.
         *
         * @private
         * @param {MouseEvent} event - Specifies mouse event.
         * @returns {void}
         */
        this.onMouseDownInternal = (event) => {
            const target = event.target;
            if ((!isNullOrUndefined(target) && target !== this.viewerContainer) || this.isTouchInput ||
                event.offsetX > (this.visibleBounds.width - (this.visibleBounds.width - this.viewerContainer.clientWidth))
                || event.offsetY > (this.visibleBounds.height - (this.visibleBounds.height - this.viewerContainer.clientHeight))) {
                return;
            }
            this.isFootnoteWidget = false;
            if (!isNullOrUndefined(this.selection)) {
                this.updateCursor(event);
                if (this.formFillPopup) {
                    this.formFillPopup.hidePopup();
                }
                if (this.isLeftButtonPressed(event) && !this.owner.isReadOnlyMode && this.owner.enableImageResizerMode && !isNullOrUndefined(this.owner.imageResizerModule.selectedResizeElement)) {
                    if (this.selection.isInShape) {
                        const textFram = this.owner.selection.getCurrentTextFrame();
                        const shape = textFram.containerShape;
                        this.selection.selectShape(shape);
                    }
                    this.owner.imageResizerModule.isImageResizing = true;
                }
                event.preventDefault();
                if (!this.isTouchInput) {
                    this.selection.hideCaret();
                }
                const cursorPoint = new Point(event.offsetX, event.offsetY);
                const touchPoint = this.owner.viewer.findFocusedPage(cursorPoint, true, true);
                this.mouseDownOffset.x = touchPoint.x;
                this.mouseDownOffset.y = touchPoint.y;
                this.isMouseDownInFooterRegion = this.selection.isCursorInsidePageRect(cursorPoint, this.currentPage) && this.selection.isCursorInFooterRegion(cursorPoint, this.currentPage);
                this.isSelectionChangedOnMouseMoved = false;
                if (!this.owner.isReadOnlyMode && (this.owner.editorModule.tableResize.isInCellResizerArea(touchPoint) ||
                    this.owner.editorModule.tableResize.isInRowResizerArea(touchPoint))) {
                    this.selection.hideCaret();
                    this.isMouseDown = true;
                    this.isSelectionChangedOnMouseMoved = false;
                    if (this.isLeftButtonPressed(event)) {
                        this.owner.editorModule.tableResize.startingPoint.x = touchPoint.x;
                        this.owner.editorModule.tableResize.startingPoint.y = touchPoint.y;
                        this.owner.editorModule.tableResize.handleResize(touchPoint);
                    }
                    return;
                }
                if (event.ctrlKey) {
                    this.isControlPressed = true;
                }
                if (this.owner.selection.isEmpty) {
                    this.useTouchSelectionMark = false;
                }
                if (event.which === 3 && !this.owner.selection.isEmpty
                    && this.selection.checkCursorIsInSelection(this.getLineWidget(touchPoint), touchPoint)) {
                    event.preventDefault();
                    return;
                }
                this.isTouchInput = false;
                this.isMouseDown = true;
                this.updateFocus();
                /* eslint-disable @typescript-eslint/indent */
                this.timer = setTimeout(() => {
                    this.tapCount++;
                    if (this.tapCount > 1) {
                        this.tapCount = 1;
                    }
                }, 100);
            }
        };
        /**
         * Called on mouse move.
         *
         * @private
         * @param {MouseEvent} event - Specified mouse event.
         * @returns {void}
         */
        this.onMouseMoveInternal = (event) => {
            if (!isNullOrUndefined(event.target) && event.target !== this.viewerContainer) {
                return;
            }
            event.preventDefault();
            if (!isNullOrUndefined(this.selection)) {
                //For image Resizing
                if (!this.owner.isReadOnlyMode && this.owner.enableImageResizerMode
                    && this.owner.imageResizerModule.isImageResizing) {
                    if (!this.owner.imageResizerModule.isImageMoveToNextPage) {
                        this.owner.imageResizerModule.handleImageResizingOnMouse(event);
                    }
                    return;
                }
                const cursorPoint = new Point(event.offsetX, event.offsetY);
                const touchPoint = this.owner.viewer.findFocusedPage(cursorPoint, !this.owner.enableHeaderAndFooter);
                if (this.isMouseDown) {
                    if (!isNullOrUndefined(this.currentPage)) {
                        const xPosition = touchPoint.x;
                        const yPosition = touchPoint.y;
                        if (!this.owner.isReadOnlyMode && this.isRowOrCellResizing) {
                            const table = this.owner.editorModule.tableResize.currentResizingTable;
                            const startPosition = this.selection.setPositionForBlock(table, true);
                            const endPosition = this.selection.setPositionForBlock(table, false);
                            if (!(this.owner.documentHelper.isDocumentProtected) || this.selection.checkSelectionIsAtEditRegion(startPosition, endPosition)) {
                                this.owner.editorModule.tableResize.handleResizing(touchPoint);
                            }
                        }
                        else {
                            if (!(this.isTouchInput || this.isSelectionChangedOnMouseMoved || this.touchDownOnSelectionMark > 0)) {
                                this.updateTextPositionForSelection(touchPoint, 1);
                            }
                            if (this.isLeftButtonPressed(event)) {
                                event.preventDefault();
                                const touchY = yPosition;
                                const textPosition = this.owner.selection.end;
                                const touchPoint = new Point(xPosition, touchY);
                                if (!this.owner.enableImageResizerMode || !this.owner.imageResizerModule.isImageResizerVisible
                                    || this.owner.imageResizerModule.isShapeResize) {
                                    this.owner.selection.moveTextPosition(touchPoint, textPosition);
                                }
                                this.isSelectionChangedOnMouseMoved = true;
                            }
                        }
                    }
                    this.selection.checkForCursorVisibility();
                }
                if (!this.isRowOrCellResizing && !this.isSelectionChangedOnMouseMoved) {
                    this.updateCursor(event);
                }
                if (this.isRowOrCellResizing) {
                    this.selection.hideCaret();
                }
            }
        };
        /**
         * @private
         * @param {MouseEvent} event - Specifies mouse event
         * @returns {void}
         */
        this.onMouseLeaveInternal = (event) => {
            event.preventDefault();
            const cursorPoint = new Point(event.offsetX, event.offsetY);
            if (this.isMouseDown) {
                const viewerTop = this.viewerContainer.scrollTop;
                if (event.offsetY + viewerTop > viewerTop) {
                    this.scrollMoveTimer = setInterval(() => {
                        this.scrollForwardOnSelection(cursorPoint);
                    }, 100);
                }
                else {
                    this.scrollMoveTimer = setInterval(() => {
                        this.scrollBackwardOnSelection(cursorPoint);
                    }, 100);
                }
                if (this.isMouseEntered) {
                    this.isMouseEntered = false;
                }
            }
        };
        /**
         * @private
         * @returns {void}
         */
        this.onMouseEnterInternal = (event) => {
            if (!this.isMouseEntered) {
                this.owner.viewer.updateScrollBars();
            }
            this.isMouseEntered = true;
            if (this.scrollMoveTimer) {
                clearInterval(this.scrollMoveTimer);
            }
            if (!this.isLeftButtonPressed(event)) {
                this.onMouseUpInternal(event);
            }
        };
        /**
         * Fired on double tap.
         *
         * @private
         * @param {MouseEvent} event - Specifies mouse event.
         * @returns {void}
         */
        this.onDoubleTap = (event) => {
            if (!isNullOrUndefined(event.target) && event.target !== this.viewerContainer) {
                return;
            }
            if (!isNullOrUndefined(this.selection)) {
                this.isTouchInput = false;
                const cursorPoint = new Point(event.offsetX, event.offsetY);
                const touchPoint = this.owner.viewer.findFocusedPage(cursorPoint, true);
                if (this.selection.checkAndEnableHeaderFooter(cursorPoint, this.owner.viewer.findFocusedPage(cursorPoint, true))) {
                    return;
                }
                const widget = this.getLineWidget(touchPoint);
                let formField = this.selection.getHyperLinkFieldInCurrentSelection(widget, touchPoint, true);
                if (isNullOrUndefined(formField)) {
                    formField = this.selection.getCurrentFormField();
                }
                if (!this.isDocumentProtected && this.owner.enableFormField) {
                    const formatType = this.selection.getFormFieldType(formField);
                    if (formatType) {
                        if (formatType.toString() !== '') {
                            this.selection.selectField(formField);
                        }
                        switch (formatType) {
                            case 'Text':
                                this.owner.textFormFieldDialogModule.show();
                                break;
                            case 'CheckBox':
                                this.owner.checkBoxFormFieldDialogModule.show();
                                break;
                            case 'DropDown':
                                this.owner.dropDownFormFieldDialogModule.show();
                                break;
                        }
                    }
                }
                else if (this.isDocumentProtected && formField && formField.formFieldData instanceof TextFormField
                    && formField.formFieldData.type === 'Text') {
                    this.selection.selectField();
                }
                const startPosition = this.selection.start.clone();
                const endPosition = this.selection.end.clone();
                const inlineObj = startPosition.currentWidget.getInline(startPosition.offset, 0);
                const inline = inlineObj.element;
                if (this.owner.layoutType === 'Pages') {
                    if (inline instanceof FootnoteElementBox) {
                        if (inline.footnoteType === 'Footnote') {
                            const footnotes = this.currentPage.footnoteWidget;
                            let i;
                            for (i = 0; i <= footnotes.bodyWidgets.length; i++) {
                                const footnoteText = (footnotes.bodyWidgets[i]).footNoteReference;
                                if (inline.text === footnoteText.text) {
                                    break;
                                }
                            }
                            startPosition.setPositionParagraph(footnotes.bodyWidgets[i].childWidgets[0].childWidgets[0], 0);
                            endPosition.setPositionParagraph(footnotes.bodyWidgets[i].childWidgets[0].childWidgets[0], 0);
                            this.selection.selectRange(startPosition, endPosition);
                        }
                        else {
                            const endnotes = this.pages[this.pages.length - 1].endnoteWidget;
                            let i;
                            if (!isNullOrUndefined(endnotes)) {
                                for (i = 0; i <= endnotes.childWidgets.length; i++) {
                                    const endnoteText = (endnotes.bodyWidgets[i]).footNoteReference;
                                    if (inline.text === endnoteText.text) {
                                        break;
                                    }
                                }
                            }
                            startPosition.setPositionParagraph(endnotes.bodyWidgets[i].childWidgets[0].childWidgets[0], 0);
                            endPosition.setPositionParagraph(endnotes.bodyWidgets[i].childWidgets[0].childWidgets[0], 0);
                            this.selection.selectRange(startPosition, endPosition);
                        }
                    }
                    else {
                        if (inline instanceof TextElementBox && (this.selection.isinEndnote || this.selection.isinFootnote)) {
                            this.selection.footnoteReferenceElement(startPosition, endPosition, inline);
                        }
                    }
                }
                if (this.selection.isEmpty && !isNullOrUndefined(this.currentPage) && !isNullOrUndefined(this.owner.selection.start)) {
                    this.owner.selection.selectCurrentWord();
                    this.selection.checkForCursorVisibility();
                    this.tapCount = 2;
                }
            }
        };
        /**
         * Called on mouse up.
         *
         * @private
         * @param {MouseEvent} event - Specifies mouse event.
         * @return {void}
         */
        /* eslint-disable  */
        this.onMouseUpInternal = (event) => {
            if (!isNullOrUndefined(event.target) && event.target !== this.viewerContainer) {
                return;
            }
            event.preventDefault();
            this.isListTextSelected = false;
            let cursorPoint = new Point(event.offsetX, event.offsetY);
            let touchPoint = this.owner.viewer.findFocusedPage(cursorPoint, true);
            if (!isNullOrUndefined(this.selection)) {
                let tapCount = 1;
                if (!Browser.isIE) {
                    if (event.detail > 2) {
                        tapCount = event.detail;
                    }
                }
                else {
                    tapCount = this.tapCount;
                }
                if (this.isRowOrCellResizing) {
                    this.owner.editorModule.tableResize.updateResizingHistory(touchPoint);
                }
                if (this.isMouseDown && !this.isSelectionChangedOnMouseMoved
                    && !isNullOrUndefined(this.currentPage) && !isNullOrUndefined(this.owner.selection.start)
                    && (!this.owner.enableImageResizerMode || !this.owner.imageResizerModule.isImageResizing)) {
                    if (this.touchDownOnSelectionMark === 0 && !this.isRowOrCellResizing) {
                        this.updateTextPositionForSelection(touchPoint, tapCount);
                        if (Browser.isIE && tapCount === 2) {
                            this.selection.checkAndEnableHeaderFooter(cursorPoint, touchPoint);
                        }
                    }
                    this.selection.checkForCursorVisibility();
                    if (!isNullOrUndefined(this.currentSelectedComment) && this.owner.commentReviewPane
                        && !this.owner.commentReviewPane.commentPane.isEditMode) {
                        this.currentSelectedComment = undefined;
                    }
                }
                let isCtrlkeyPressed = this.isIosDevice ? event.metaKey : event.ctrlKey;
                if (!isNullOrUndefined(this.currentPage) && !isNullOrUndefined(this.owner.selection.start)
                    && (this.owner.selection.isEmpty || this.owner.selection.isImageSelected) &&
                    (((isCtrlkeyPressed && this.owner.useCtrlClickToFollowHyperlink ||
                        !this.owner.useCtrlClickToFollowHyperlink) && this.isLeftButtonPressed(event) === true))) {
                    this.selection.navigateHyperLinkOnEvent(touchPoint, false);
                }
                if (this.isMouseDown && this.isLeftButtonPressed(event) && this.isDocumentProtected
                    && this.protectionType === 'FormFieldsOnly' && this.selection) {
                    let widget = this.getLineWidget(touchPoint);
                    let formField = this.selection.getHyperLinkFieldInCurrentSelection(widget, touchPoint, true);
                    if (isNullOrUndefined(formField)) {
                        formField = this.selection.getCurrentFormField(true);
                    }
                    if (formField && formField.formFieldData && formField.formFieldData.enabled && !this.selection.isInlineFormFillMode(formField)) {
                        let data = { 'fieldName': formField.formFieldData.name };
                        if (formField.formFieldData instanceof TextFormField) {
                            data.value = formField.resultText;
                        }
                        else if (formField.formFieldData instanceof CheckBoxFormField) {
                            data.value = formField.formFieldData.checked;
                        }
                        else {
                            data.value = formField.formFieldData.selectedIndex;
                        }
                        this.owner.trigger(beforeFormFieldFillEvent, data);
                        if (this.owner.documentEditorSettings.formFieldSettings.formFillingMode === 'Popup' && !(formField.formFieldData instanceof CheckBoxFormField)
                            || (formField.formFieldData instanceof TextFormField && !(formField.formFieldData.type === 'Text'))
                            || formField.formFieldData instanceof DropDownFormField) {
                            this.formFillPopup.showPopUp(formField);
                        }
                        else {
                            this.owner.editor.toggleCheckBoxFormField(formField);
                            data.value = formField.formFieldData.checked;
                            data.isCanceled = false;
                            this.owner.trigger(afterFormFieldFillEvent, data);
                        }
                    }
                    if (!formField && this.isFormFillProtectedMode) {
                        this.selection.navigateToNextFormField();
                    }
                }
                else if (this.isMouseDown) {
                    if (this.formFields.length > 0) {
                        let formField = this.selection.getCurrentFormField(true);
                        if (formField && formField.formFieldData instanceof TextFormField) {
                            this.selection.selectField();
                        }
                        else if (this.isLeftButtonPressed(event) && formField && formField.formFieldData instanceof DropDownFormField) {
                            let offset = formField.line.getOffset(formField, 0);
                            let point = this.selection.getPhysicalPositionInternal(formField.line, offset, false);
                            this.selection.selectInternal(formField.line, formField, 0, point);
                        }
                    }
                }
                if (!this.owner.isReadOnlyMode && this.isSelectionInListText(touchPoint)) {
                    this.selection.selectListText();
                }
                if (!this.owner.isReadOnlyMode && this.owner.enableImageResizerMode && this.owner.imageResizerModule.isImageResizing) {
                    this.owner.imageResizerModule.mouseUpInternal();
                    this.scrollToPosition(this.owner.selection.start, this.owner.selection.end);
                    this.owner.imageResizerModule.isImageResizing = false;
                }
                if (this.owner.enableImageResizerMode && this.owner.imageResizerModule.isImageResizerVisible && !isNullOrUndefined(this.selection.caret)) {
                    this.selection.caret.style.display = 'none';
                }
                this.isMouseDown = false;
                this.isFootnoteWidget = false;
                this.isSelectionChangedOnMouseMoved = false;
                this.isTouchInput = false;
                this.useTouchSelectionMark = true;
                this.isControlPressed = false;
                this.updateFocus();
                if (this.isListTextSelected) {
                    this.selection.hideCaret();
                }
                if (this.owner.enableImageResizerMode) {
                    let imageResizer = this.owner.imageResizerModule;
                    imageResizer.isImageResizing = false;
                    imageResizer.isImageMoveToNextPage = false;
                    imageResizer.leftValue = undefined;
                    imageResizer.topValue = undefined;
                }
                this.isMouseDownInFooterRegion = false;
            }
        };
        /**
         * Fired on touch start.
         *
         * @private
         * @param {TouchEvent} event - Specifies touch event.
         * @returns {void}
         */
        this.onTouchStartInternal = (event) => {
            if (this.selection) {
                this.isTouchMoved = false;
                this.isCompositionStart = false;
                this.isCompositionEnd = false;
                this.isCompositionUpdated = false;
                this.isCompositionCanceled = true;
                this.isTouchInput = true;
                if (this.isTimerStarted) {
                    if (this.tapCount === 1) {
                        this.tapCount = 2;
                    }
                    else {
                        this.tapCount = 3;
                        this.isTimerStarted = false;
                    }
                }
                else {
                    this.isTimerStarted = true;
                    this.tapCount = 1;
                }
                if (event.touches.length === 1) {
                    this.zoomX = event.touches[0].clientX;
                    this.zoomY = event.touches[0].clientY;
                    if (this.owner.selection.isEmpty) {
                        this.useTouchSelectionMark = false;
                    }
                    this.isMouseDown = true;
                    this.isSelectionChangedOnMouseMoved = false;
                    let point;
                    if (this.isMouseDown) {
                        point = this.getTouchOffsetValue(event);
                    }
                    point = this.owner.viewer.findFocusedPage(point, true, true);
                    if (this.owner.enableImageResizerMode) {
                        let resizeObj = this.owner.imageResizerModule.getImagePointOnTouch(point);
                        this.owner.imageResizerModule.selectedResizeElement = resizeObj.selectedElement;
                    }
                    if (this.owner.enableImageResizerMode && !isNullOrUndefined(this.owner.imageResizerModule.selectedResizeElement)) {
                        this.owner.imageResizerModule.isImageResizing = true;
                    }
                    let x = this.owner.selection.end.location.x;
                    let y = this.selection.getCaretBottom(this.owner.selection.end, this.owner.selection.isEmpty) + 9;
                    //TouchDownOnSelectionMark will be 2 when touch end is pressed
                    this.touchDownOnSelectionMark = ((point.y <= y && point.y >= y - 20 || point.y >= y && point.y <= y + 20)
                        && (point.x <= x && point.x >= x - 20 || point.x >= x && point.x <= x + 20)) ? 1 : 0;
                    if (!this.owner.selection.isEmpty && this.touchDownOnSelectionMark === 0) {
                        x = this.owner.selection.start.location.x;
                        y = this.selection.getCaretBottom(this.owner.selection.start, false) + 9;
                        //TouchDownOnSelectionMark will be 1 when touch start is pressed
                        this.touchDownOnSelectionMark = ((point.y <= y && point.y >= y - 20 || point.y >= y && point.y <= y + 20)
                            && (point.x <= x && point.x >= x - 20 || point.x >= x && point.x <= x + 20)) ? 2 : 0;
                    }
                }
                if (!isNullOrUndefined(this.owner.contextMenuModule) && this.owner.contextMenuModule.contextMenuInstance) {
                    this.owner.contextMenuModule.contextMenuInstance.close();
                }
                if (this.touchDownOnSelectionMark || event.touches.length > 1) {
                    event.preventDefault();
                }
                this.longTouchTimer = setTimeout(this.onLongTouch, 500, event);
                this.timer = setTimeout(() => {
                    this.isTimerStarted = false;
                }, 200);
            }
        };
        /**
         * Fired on long touch
         *
         * @private
         * @param {TouchEvent} event - Specifies touch event.
         * @returns {void}
         */
        this.onLongTouch = (event) => {
            if (isNullOrUndefined(this.owner) || isNullOrUndefined(this.viewerContainer) || this.isTouchMoved || event.touches.length !== 1) {
                return;
            }
            let point = this.getTouchOffsetValue(event);
            let pointRelToPage = this.owner.viewer.findFocusedPage(point, true);
            let selStart = this.selection.start;
            let selEnd = this.selection.end;
            let updateSel = false;
            if (!this.selection.isForward) {
                selStart = this.selection.end;
                selEnd = this.selection.start;
            }
            let selStartPt = selStart.location;
            let selEndPt = selEnd.location;
            if (selStart.currentWidget !== selEnd.currentWidget) {
                updateSel = !(pointRelToPage.x >= selStartPt.x && pointRelToPage.x <= selEndPt.x)
                    && !(pointRelToPage.y >= selStartPt.y && pointRelToPage.y <= selEndPt.y);
            }
            else {
                updateSel = !(pointRelToPage.x >= selStartPt.x && pointRelToPage.x <= selEndPt.x)
                    || !(pointRelToPage.y >= selStartPt.y && pointRelToPage.y <= selEndPt.y);
            }
            if (event.changedTouches.length === 1 && updateSel) {
                this.updateSelectionOnTouch(point, pointRelToPage);
                this.isMouseDown = false;
                this.touchDownOnSelectionMark = 0;
                this.useTouchSelectionMark = true;
                this.isSelectionChangedOnMouseMoved = false;
            }
            if (this.selection.isEmpty) {
                this.selection.selectCurrentWord();
            }
            if (!isNullOrUndefined(this.owner.contextMenuModule) && this.owner.contextMenuModule.contextMenuInstance) {
                this.owner.contextMenuModule.onContextMenuInternal(event);
            }
        };
        /**
         *
         * @private
         * @param {TouchEvent} event - Specifies touch event.
         * @returns {void}
         */
        this.onTouchMoveInternal = (event) => {
            this.isTouchMoved = true;
            let touch = event.touches;
            let cursorPoint;
            if (!isNullOrUndefined(this.selection)) {
                if (this.owner.editorModule && this.owner.enableImageResizerMode && this.owner.imageResizerModule.isImageResizing) {
                    event.preventDefault();
                    if (!this.owner.imageResizerModule.isImageMoveToNextPage) {
                        this.owner.imageResizerModule.handleImageResizingOnTouch(event);
                        this.selection.caret.style.display = 'none';
                    }
                    return;
                }
                if (this.isMouseDown) {
                    cursorPoint = this.getTouchOffsetValue(event);
                    let touchPoint = this.owner.viewer.findFocusedPage(cursorPoint, true);
                    if (this.touchDownOnSelectionMark > 0 /*|| !this.useTouchSelectionMark*/) {
                        event.preventDefault();
                        let touchY = touchPoint.y;
                        let textPosition = this.owner.selection.end;
                        if (touchPoint.y <= 26) {
                            touchY -= touchPoint.y < 0 ? 0 : touchPoint.y + 0.5;
                        }
                        else {
                            touchY -= 36.5;
                        }
                        textPosition = this.touchDownOnSelectionMark === 2 ? this.selection.start : this.selection.end;
                        touchPoint = new Point(touchPoint.x, touchY);
                        this.owner.selection.moveTextPosition(touchPoint, textPosition);
                        this.isSelectionChangedOnMouseMoved = true;
                    }
                    this.selection.checkForCursorVisibility();
                    this.updateTouchMarkPosition();
                }
            }
            if (touch.length > 1) {
                event.preventDefault();
                this.isMouseDown = false;
                this.zoomX = (touch[0].clientX + touch[1].clientX) / 2;
                this.zoomY = (touch[0].clientY + touch[1].clientY) / 2;
                let currentDiff = Math.sqrt(Math.pow((touch[0].clientX - touch[1].clientX), 2) + Math.pow((touch[0].clientY - touch[1].clientY), 2));
                if (this.preDifference > -1) {
                    if (currentDiff > this.preDifference) {
                        this.onPinchOutInternal(event);
                    }
                    else if (currentDiff < this.preDifference) {
                        this.onPinchInInternal(event);
                    }
                }
                else if (this.zoomFactor < 2) {
                    if (this.preDifference !== -1) {
                        if (currentDiff > this.preDifference) {
                            this.onPinchInInternal(event);
                        }
                    }
                }
                else if (this.preDifference === -1) {
                    if (this.zoomFactor > 2) {
                        if (currentDiff > this.preDifference) {
                            this.onPinchInInternal(event);
                        }
                    }
                }
                this.preDifference = currentDiff;
            }
            if (this.longTouchTimer) {
                clearTimeout(this.longTouchTimer);
                this.longTouchTimer = undefined;
            }
        };
        /**
         * Fired on touch up.
         *
         * @private
         * @param {TouchEvent} event - Specifies touch event.
         * @returns {void}
         */
        this.onTouchUpInternal = (event) => {
            if (!isNullOrUndefined(this.selection)) {
                let point = this.getTouchOffsetValue(event);
                let touchPoint = this.owner.viewer.findFocusedPage(point, true);
                if (event.changedTouches.length === 1) {
                    if (!this.isTouchMoved || (this.owner.enableImageResizerMode && this.owner.imageResizerModule.isImageResizing)) {
                        this.updateSelectionOnTouch(point, touchPoint);
                        if (!isNullOrUndefined(this.currentPage) && !isNullOrUndefined(this.selection.start)
                            && !this.isSelectionChangedOnMouseMoved && (this.selection.isEmpty ||
                            this.selection.isImageField() && (!this.owner.enableImageResizerMode ||
                                this.owner.enableImageResizerMode && !this.owner.imageResizerModule.isImageResizing))) {
                            this.selection.navigateHyperLinkOnEvent(touchPoint, true);
                        }
                    }
                    this.isMouseDown = false;
                    this.touchDownOnSelectionMark = 0;
                    this.useTouchSelectionMark = true;
                    this.isSelectionChangedOnMouseMoved = false;
                }
                if (this.owner.enableImageResizerMode && this.owner.imageResizerModule.isImageResizing) {
                    this.owner.imageResizerModule.mouseUpInternal();
                    this.owner.imageResizerModule.isImageResizing = false;
                    this.owner.imageResizerModule.isImageMoveToNextPage = false;
                    this.scrollToPosition(this.owner.selection.start, this.owner.selection.end);
                }
                if (this.owner.enableImageResizerMode && this.owner.imageResizerModule.isImageResizerVisible && this.isTouchInput) {
                    this.touchStart.style.display = 'none';
                    this.touchEnd.style.display = 'none';
                }
                // if (!this.owner.isReadOnlyMode && this.isSelectionInListText(touchPoint)) {
                //     this.selection.selectListText();
                // }
                event.preventDefault();
            }
            this.preDifference = -1;
            this.isTouchInput = false;
            if (this.longTouchTimer) {
                clearTimeout(this.longTouchTimer);
                this.longTouchTimer = undefined;
            }
            if (!this.isTimerStarted) {
                this.tapCount = 1;
            }
            if (this.isListTextSelected) {
                this.selection.hideCaret();
            }
        };
        /**
         * Fired on keyup event.
         *
         * @private
         * @param {KeyboardEvent} event - Specifies keyboard event.
         * @returns {void}
         */
        this.onKeyUpInternal = (event) => {
            if (Browser.isDevice && event.target === this.editableDiv) {
                if (window.getSelection().anchorOffset !== this.prefix.length) {
                    this.selection.setEditableDivCaretPosition(this.editableDiv.innerText.length);
                }
            }
            if (event.ctrlKey || (event.keyCode === 17 || event.which === 17)) {
                this.isControlPressed = false;
            }
        };
        /**
         * Fired on keydown.
         *
         * @private
         * @param {KeyboardEvent} event - Specifies keyboard event.
         * @returns {void}
         */
        this.onKeyDownInternal = (event) => {
            if (!isNullOrUndefined(event.target) && event.target !== this.editableDiv) {
                return;
            }
            let isHandled = false;
            let keyEventArgs = { 'event': event, 'isHandled': false, source: this.owner };
            this.owner.trigger(keyDownEvent, keyEventArgs);
            if (keyEventArgs.isHandled) {
                return;
            }
            let key = event.which || event.keyCode;
            let ctrl = (event.ctrlKey || event.metaKey) ? true : ((key === 17) ? true : false); // ctrl detection       
            let shift = event.shiftKey ? event.shiftKey : ((key === 16) ? true : false); // Shift Key detection        
            let alt = event.altKey ? event.altKey : ((key === 18) ? true : false); // alt key detection
            if (ctrl && !shift && !alt) {
                switch (key) {
                    case 80:
                        event.preventDefault();
                        this.owner.print();
                        isHandled = true;
                        break;
                    case 83:
                        event.preventDefault();
                        this.owner.save(this.owner.documentName === '' ? 'sample' : this.owner.documentName, 'Sfdt');
                        isHandled = true;
                        break;
                }
            }
            if (!isHandled && !isNullOrUndefined(this.selection)) {
                this.selection.onKeyDownInternal(event, ctrl, shift, alt);
            }
            if (isHandled) {
                event.preventDefault();
            }
        };
        this.owner = owner;
        this.pages = [];
        this.lists = [];
        this.abstractLists = [];
        this.render = new Renderer(this);
        this.characterFormat = new WCharacterFormat(this);
        this.paragraphFormat = new WParagraphFormat(this);
        this.renderedLists = new Dictionary();
        this.renderedLevelOverrides = [];
        this.headersFooters = [];
        this.styles = new WStyles();
        this.preDefinedStyles = new Dictionary();
        this.initalizeStyles();
        this.bookmarks = new Dictionary();
        this.editRanges = new Dictionary();
        this.isIosDevice = /Mac|iPad|iPod/i.test(navigator.userAgent);
        this.isMobileDevice = /Android|Windows Phone|webOS/i.test(navigator.userAgent);
        this.formFillPopup = new FormFieldPopUp(this.owner);
        this.customXmlData = new Dictionary();
        this.contentControlCollection = [];
        this.footnoteCollection = [];
        this.endnoteCollection = [];
    }
    /**
     * Gets visible bounds.
     *
     * @private
     * @returns {Rect} - Returns visible bounds.
     */
    get visibleBounds() {
        return this.visibleBoundsIn;
    }
    /**
     * @private
     */
    get viewer() {
        return this.owner.viewer;
    }
    //Document Protection Properties Ends
    //#region Properties
    /**
     * Gets container canvas.
     *
     * @private
     * @returns {HTMLCanvasElement} - Returns page canvas.
     */
    get containerCanvas() {
        if (isNullOrUndefined(this.containerCanvasIn)) {
            this.containerCanvasIn = document.createElement('canvas');
            this.containerCanvasIn.getContext('2d').save();
        }
        if (!isNullOrUndefined(this.pageContainer)
            && this.containerCanvasIn.parentElement !== this.pageContainer) {
            this.pageContainer.appendChild(this.containerCanvasIn);
        }
        return this.containerCanvasIn;
    }
    /**
     * Gets selection canvas.
     *
     * @private
     * @returns {HTMLCanvasElement} - Returns selection canvas.
     */
    get selectionCanvas() {
        if (isNullOrUndefined(this.selectionCanvasIn)) {
            this.selectionCanvasIn = document.createElement('canvas');
            this.selectionCanvas.getContext('2d').save();
        }
        if (!isNullOrUndefined(this.pageContainer)
            && this.selectionCanvasIn.parentElement !== this.pageContainer) {
            this.pageContainer.appendChild(this.selectionCanvasIn);
        }
        return this.selectionCanvasIn;
    }
    /**
     * Gets container context.
     *
     * @private
     * @returns {CanvasRenderingContext2D} - Returns page canvas context.
     */
    get containerContext() {
        return this.containerCanvas.getContext('2d');
    }
    /**
     * Gets selection context.
     *
     * @private
     * @returns {CanvasRenderingContext2D} - Returns selection canvas context.
     */
    get selectionContext() {
        return this.selectionCanvas.getContext('2d');
    }
    /**
     * Gets the current rendering page.
     *
     * @returns {Page} - Returns current rendering page.
     */
    get currentRenderingPage() {
        if (this.pages.length === 0) {
            return undefined;
        }
        return this.pages[this.pages.length - 1];
    }
    /**
     * Gets or sets zoom factor.
     *
     * @private
     * @returns {number} - Returns zoom factor value.
     */
    get zoomFactor() {
        return this.zoomFactorInternal;
    }
    set zoomFactor(value) {
        if (this.zoomFactorInternal !== value) {
            this.preZoomFactor = this.zoomFactor;
            this.zoomFactorInternal = value;
            this.zoomModule.setZoomFactor();
            this.owner.zoomFactor = value;
        }
    }
    /**
     * Gets the selection.
     *
     * @private
     * @returns {Selection} - Returns selection module.
     */
    get selection() {
        return this.owner.selection;
    }
    /**
     * Gets or sets selection start page.
     *
     * @private
     * @returns {Page} - Return selection start page.
     */
    get selectionStartPage() {
        return this.selectionStartPageIn;
    }
    set selectionStartPage(value) {
        this.selectionStartPageIn = value;
    }
    /**
     * Gets or sets selection end page.
     *
     * @private
     * @returns {Page} - Return selection end page.
     */
    get selectionEndPage() {
        return this.selectionEndPageIn;
    }
    set selectionEndPage(value) {
        this.selectionEndPageIn = value;
    }
    /**
     * Gets the initialized default dialog.
     *
     * @private
     * @returns {Dialog} - Returns dialog instance.
     */
    get dialog() {
        if (!this.dialogInternal) {
            this.initDialog(this.owner.enableRtl);
        }
        return this.dialogInternal;
    }
    /**
     * Gets the initialized default dialog.
     *
     * @private
     * @returns {Dialog} - Returns dialog instance.
     */
    get dialog2() {
        if (!this.dialogInternal2) {
            this.initDialog2(this.owner.enableRtl);
        }
        return this.dialogInternal2;
    }
    /**
     * Gets the initialized default dialog.
     *
     * @private
     * @returns {Dialog} - Returns dialog instance.
     */
    get dialog3() {
        if (!this.dialogInternal3) {
            this.initDialog3(this.owner.enableRtl);
        }
        return this.dialogInternal3;
    }
    /**
     * @private
     * @returns {void}
     */
    get currentSelectedComment() {
        return this.currentSelectedCommentInternal;
    }
    set currentSelectedComment(value) {
        if (this.owner && this.owner.commentReviewPane) {
            this.owner.commentReviewPane.previousSelectedComment = this.currentSelectedCommentInternal;
        }
        this.currentSelectedCommentInternal = value;
    }
    /**
     * @private
     * @returns {void}
     */
    get currentSelectedRevision() {
        return this.currentSelectedRevisionInternal;
    }
    set currentSelectedRevision(value) {
        // if (this.owner && this.owner.commentReviewPane) {
        //     this.owner.commentReviewPane.previousSelectedComment = this.currentSelectedCommentInternal;
        // }
        this.currentSelectedRevisionInternal = value;
    }
    /**
     * @private
     * @returns {void}
     */
    get isInlineFormFillProtectedMode() {
        return this.isFormFillProtectedMode && this.owner.documentEditorSettings.formFieldSettings.formFillingMode === 'Inline';
    }
    /**
     * @private
     * @returns {void}
     */
    get isFormFillProtectedMode() {
        return this.isDocumentProtected && this.protectionType === 'FormFieldsOnly';
    }
    /**
     * @private
     * @returns {Boolean}
     */
    get isCommentOnlyMode() {
        return this.isDocumentProtected && this.protectionType === 'CommentsOnly';
    }
    initalizeStyles() {
        this.preDefinedStyles.add('Normal', '{"type":"Paragraph","name":"Normal","next":"Normal"}');
        this.preDefinedStyles.add('Heading 1', '{"type":"Paragraph","name":"Heading 1","basedOn":"Normal","next":"Normal","link":"Heading 1 Char","characterFormat":{"fontSize":16.0,"fontFamily":"Calibri Light","fontColor":"#2F5496"},"paragraphFormat":{"leftIndent":0.0,"rightIndent":0.0,"firstLineIndent":0.0,"beforeSpacing":12.0,"afterSpacing":0.0,"lineSpacing":1.0791666507720947,"lineSpacingType":"Multiple","textAlignment":"Left","outlineLevel":"Level1"}}');
        this.preDefinedStyles.add('Heading 2', '{"type":"Paragraph","name":"Heading 2","basedOn":"Normal","next":"Normal","link":"Heading 2 Char","characterFormat":{"fontSize":13.0,"fontFamily":"Calibri Light","fontColor":"#2F5496"},"paragraphFormat":{"leftIndent":0.0,"rightIndent":0.0,"firstLineIndent":0.0,"beforeSpacing":2.0,"afterSpacing":0.0,"lineSpacing":1.0791666507720947,"lineSpacingType":"Multiple","textAlignment":"Left","outlineLevel":"Level2"}}');
        this.preDefinedStyles.add('Heading 3', '{"type":"Paragraph","name":"Heading 3","basedOn":"Normal","next":"Normal","link":"Heading 3 Char","characterFormat":{"fontSize":12.0,"fontFamily":"Calibri Light","fontColor":"#1F3763"},"paragraphFormat":{"leftIndent":0.0,"rightIndent":0.0,"firstLineIndent":0.0,"beforeSpacing":2.0,"afterSpacing":0.0,"lineSpacing":1.0791666507720947,"lineSpacingType":"Multiple","textAlignment":"Left","outlineLevel":"Level3"}}');
        this.preDefinedStyles.add('Heading 4', '{"type":"Paragraph","name":"Heading 4","basedOn":"Normal","next":"Normal","link":"Heading 4 Char","characterFormat":{"italic":true,"fontFamily":"Calibri Light","fontColor":"#2F5496"},"paragraphFormat":{"leftIndent":0.0,"rightIndent":0.0,"firstLineIndent":0.0,"beforeSpacing":2.0,"afterSpacing":0.0,"lineSpacing":1.0791666507720947,"lineSpacingType":"Multiple","textAlignment":"Left","outlineLevel":"Level4"}}');
        this.preDefinedStyles.add('Heading 5', '{"type":"Paragraph","name":"Heading 5","basedOn":"Normal","next":"Normal","link":"Heading 5 Char","characterFormat":{"fontFamily":"Calibri Light","fontColor":"#2F5496"},"paragraphFormat":{"leftIndent":0.0,"rightIndent":0.0,"firstLineIndent":0.0,"beforeSpacing":2.0,"afterSpacing":0.0,"lineSpacing":1.0791666507720947,"lineSpacingType":"Multiple","textAlignment":"Left","outlineLevel":"Level5"}}');
        this.preDefinedStyles.add('Heading 6', '{"type":"Paragraph","name":"Heading 6","basedOn":"Normal","next":"Normal","link":"Heading 6 Char","characterFormat":{"fontFamily":"Calibri Light","fontColor":"#1F3763"},"paragraphFormat":{"leftIndent":0.0,"rightIndent":0.0,"firstLineIndent":0.0,"beforeSpacing":2.0,"afterSpacing":0.0,"lineSpacing":1.0791666507720947,"lineSpacingType":"Multiple","textAlignment":"Left","outlineLevel":"Level6"}}');
        this.preDefinedStyles.add('Default Paragraph Font', '{"type":"Character","name":"Default Paragraph Font"}');
        this.preDefinedStyles.add('Heading 1 Char', '{"type":"Character","name":"Heading 1 Char","basedOn":"Default Paragraph Font","characterFormat":{"fontSize":16.0,"fontFamily":"Calibri Light","fontColor":"#2F5496"}}');
        this.preDefinedStyles.add('Heading 2 Char', '{"type":"Character","name":"Heading 2 Char","basedOn":"Default Paragraph Font","characterFormat":{"fontSize":13.0,"fontFamily":"Calibri Light","fontColor":"#2F5496"}}');
        this.preDefinedStyles.add('Heading 3 Char', '{"type":"Character","name":"Heading 3 Char","basedOn":"Default Paragraph Font","characterFormat":{"fontSize":12.0,"fontFamily":"Calibri Light","fontColor": "#1F3763"}}');
        this.preDefinedStyles.add('Heading 4 Char', '{"type":"Character","name":"Heading 4 Char","basedOn":"Default Paragraph Font","characterFormat":{"italic":true,"fontFamily":"Calibri Light","fontColor":"#2F5496"}}');
        this.preDefinedStyles.add('Heading 5 Char', '{"type":"Character","name":"Heading 5 Char","basedOn":"Default Paragraph Font","characterFormat":{"fontFamily":"Calibri Light","fontColor":"#2F5496"}}');
        this.preDefinedStyles.add('Heading 6 Char', '{"type":"Character","name":"Heading 6 Char","basedOn":"Default Paragraph Font","characterFormat":{"fontFamily":"Calibri Light","fontColor":"#1F3763"}}');
        this.preDefinedStyles.add('Hyperlink', '{"type":"Character","name":"Hyperlink","basedOn":"Default Paragraph Font","next":"Normal","characterFormat":{"fontColor":"#0563C1","underline": "Single"}}');
        this.preDefinedStyles.add('Toc1', '{"type":"Paragraph","name":"Toc1","basedOn":"Normal","next":"Normal","paragraphFormat":{"afterSpacing":5.0}}');
        this.preDefinedStyles.add('Toc2', '{"type":"Paragraph","name":"Toc2","basedOn":"Normal","next":"Normal","paragraphFormat":{"leftIndent" :11.0,"afterSpacing":5.0}}');
        this.preDefinedStyles.add('Toc3', '{"type":"Paragraph","name":"Toc3","basedOn":"Normal","next":"Normal","paragraphFormat":{"leftIndent" :22.0,"afterSpacing":5.0}}');
        this.preDefinedStyles.add('Toc4', '{"type":"Paragraph","name":"Toc4","basedOn":"Normal","next":"Normal","paragraphFormat":{"leftIndent" :33.0,"afterSpacing":5.0}}');
        this.preDefinedStyles.add('Toc5', '{"type":"Paragraph","name":"Toc5","basedOn":"Normal","next":"Normal","paragraphFormat":{"leftIndent" :44.0,"afterSpacing":5.0}}');
        this.preDefinedStyles.add('Toc6', '{"type":"Paragraph","name":"Toc6","basedOn":"Normal","next":"Normal","paragraphFormat":{"leftIndent" :55.0,"afterSpacing":5.0}}');
        this.preDefinedStyles.add('Toc7', '{"type":"Paragraph","name":"Toc7","basedOn":"Normal","next":"Normal","paragraphFormat":{"leftIndent" :66.0,"afterSpacing":5.0}}');
        this.preDefinedStyles.add('Toc8', '{"type":"Paragraph","name":"Toc8","basedOn":"Normal","next":"Normal","paragraphFormat":{"leftIndent" :77.0,"afterSpacing":5.0}}');
        this.preDefinedStyles.add('Toc9', '{"type":"Paragraph","name":"Toc9","basedOn":"Normal","next":"Normal","paragraphFormat":{"leftIndent" :88.0,"afterSpacing":5.0}}');
    }
    /**
     * @private
     * @returns {void}
     */
    clearDocumentItems() {
        this.editRanges.clear();
        this.headersFooters = [];
        this.fields = [];
        this.formFields = [];
        this.currentSelectedComment = undefined;
        this.currentSelectedRevision = undefined;
        for (let i = 0; i < this.comments.length; i++) {
            const commentStart = this.comments[i].commentStart;
            if (commentStart) {
                commentStart.destroy();
            }
        }
        this.comments = [];
        this.bookmarks.clear();
        this.styles.clear();
        this.authors.clear();
        this.revisionsInternal.clear();
        this.owner.revisions.destroy();
        this.characterFormat.clearFormat();
        this.paragraphFormat.clearFormat();
        if (this.owner.trackChangesPane) {
            this.owner.trackChangesPane.clear();
        }
        this.setDefaultCharacterValue(this.characterFormat);
        this.setDefaultParagraphValue(this.paragraphFormat);
        if (this.owner.commentReviewPane) {
            this.owner.commentReviewPane.clear();
        }
        this.isHeaderFooter = false;
        this.defaultTabWidth = 36;
        this.isDocumentProtected = false;
        this.protectionType = 'NoProtection';
        this.restrictFormatting = false;
        this.hashValue = '';
        this.saltValue = '';
        this.userCollection = [];
        if (this.formFillPopup) {
            this.formFillPopup.hidePopup();
        }
        this.customXmlData.clear();
        this.contentControlCollection = [];
        this.endnotes.clear();
        this.footnotes.clear();
        this.footnoteCollection = [];
        this.endnoteCollection = [];
        this.abstractLists = [];
        this.lists = [];
    }
    /**
     * @private
     * @returns {void}
     */
    setDefaultDocumentFormat() {
        this.owner.parser.parseCharacterFormat(this.owner.characterFormat, this.characterFormat);
        this.owner.parser.parseParagraphFormat(this.owner.paragraphFormat, this.paragraphFormat);
    }
    setDefaultCharacterValue(characterFormat) {
        characterFormat.bold = false;
        characterFormat.italic = false;
        characterFormat.fontFamily = 'Calibri';
        characterFormat.fontSize = 11;
        characterFormat.underline = 'None';
        characterFormat.strikethrough = 'None';
        characterFormat.fontSizeBidi = 11;
        characterFormat.fontFamilyBidi = 'Calibri';
        characterFormat.baselineAlignment = 'Normal';
        characterFormat.highlightColor = 'NoColor';
        characterFormat.fontColor = '#00000000';
        characterFormat.allCaps = false;
    }
    setDefaultParagraphValue(paragraphFormat) {
        paragraphFormat.leftIndent = 0;
        paragraphFormat.rightIndent = 0;
        paragraphFormat.firstLineIndent = 0;
        paragraphFormat.textAlignment = 'Left';
        paragraphFormat.beforeSpacing = 0;
        paragraphFormat.afterSpacing = 0;
        paragraphFormat.lineSpacing = 1;
        paragraphFormat.lineSpacingType = 'Multiple';
        paragraphFormat.bidi = false;
        paragraphFormat.keepWithNext = false;
        paragraphFormat.keepLinesTogether = false;
        paragraphFormat.widowControl = true;
    }
    /**
     * @private
     * @param {number} id - Specfies abstract list id.
     * @returns {WAbstractList} - Returns abstract list.
     */
    getAbstractListById(id) {
        if (isNullOrUndefined(this.abstractLists)) {
            return undefined;
        }
        for (let i = 0; i < this.abstractLists.length; i++) {
            const abstractList = this.abstractLists[i];
            if (abstractList instanceof WAbstractList && abstractList.abstractListId === id) {
                return abstractList;
            }
        }
        return undefined;
    }
    /**
     * @private
     * @param {number} id - Specfies list id.
     * @returns {WAbstractList} - Returns list.
     */
    getListById(id) {
        if (isNullOrUndefined(this.lists)) {
            return undefined;
        }
        for (let i = 0; i < this.lists.length; i++) {
            if (!isNullOrUndefined(this.lists[i]) && this.lists[i].listId === id) {
                return this.lists[i];
            }
        }
        return undefined;
    }
    /**
     * @private
     * @param {WListLevel} listLevel - Specfies list level.
     * @returns {number} - Returns list level number.
     */
    static getListLevelNumber(listLevel) {
        if (listLevel.ownerBase instanceof WLevelOverride) {
            return listLevel.ownerBase.levelNumber;
        }
        else if (listLevel.ownerBase instanceof WAbstractList && !isNullOrUndefined(listLevel.ownerBase.levels)) {
            return listLevel.ownerBase.levels.indexOf(listLevel);
        }
        else {
            return -1;
        }
    }
    /**
     * Gets the bookmarks.
     *
     * @private
     * @param {boolean} includeHidden - Include hidden bookmark.
     * @returns {string[]} - Returns bookmars present in current document.
     */
    getBookmarks(includeHidden) {
        const bookmarks = [];
        for (let i = 0; i < this.bookmarks.keys.length; i++) {
            const bookmark = this.bookmarks.keys[i];
            if (includeHidden || bookmark.indexOf('_') !== 0) {
                bookmarks.push(bookmark);
            }
        }
        return bookmarks;
    }
    selectComment(comment) {
        if (this.owner.selection && this.owner.commentReviewPane) {
            this.owner.showComments = true;
            setTimeout(() => {
                if (this.owner && this.owner.selection) {
                    this.owner.selection.selectComment(comment);
                }
            });
        }
    }
    showComments(show) {
        if (this.owner && show && this.owner.enableComment) {
            const eventArgs = { type: 'Comment' };
            this.owner.trigger(beforePaneSwitchEvent, eventArgs);
        }
        this.owner.commentReviewPane.reviewTab.hideTab(0, false);
        this.owner.commentReviewPane.reviewTab.hideTab(1, false);
        this.owner.commentReviewPane.showHidePane(show && this.owner.enableComment, 'Comments');
    }
    showRevisions(show) {
        this.showRevision = show;
        if (this.owner && show) {
            const eventArgs = { type: 'comment' };
            this.owner.trigger(beforePaneSwitchEvent, eventArgs);
        }
        if (!show && this.owner.showComments) {
            this.owner.commentReviewPane.reviewTab.hideTab(0, false);
            this.owner.commentReviewPane.showHidePane(true, 'Comments');
        }
        else {
            this.owner.commentReviewPane.showHidePane(show, 'Changes');
            if (!this.owner.enableComment) {
                
            }
            // this.owner.commentReviewPane.reviewTab.hideTab(0, isCommentTabVisible);
            this.showRevision = false;
        }
        if (show) {
            this.owner.trackChangesPane.enableDisableButton(!this.owner.isReadOnly);
        }
    }
    /**
     * Initializes components.
     *
     * @private
     * @returns {void}
     */
    initializeComponents() {
        let element = this.owner.element;
        if (isNullOrUndefined(element)) {
            return;
        }
        //let viewer: LayoutViewer = this;
        this.optionsPaneContainer = createElement('div', {
            className: 'e-documenteditor-optionspane'
        });
        this.optionsPaneContainer.contentEditable = 'false';
        element.appendChild(this.optionsPaneContainer);
        const isRtl = this.owner.enableRtl;
        let viewerContainerStyle;
        if (isRtl) {
            viewerContainerStyle = 'direction:ltr;';
        }
        this.viewerContainer = createElement('div', { id: this.owner.containerId + '_viewerContainer' });
        this.viewerContainer.style.cssText = 'position:relative;backgroundColor:#FBFBFB;overflow:auto;' + viewerContainerStyle;
        this.optionsPaneContainer.appendChild(this.viewerContainer);
        this.viewerContainer.tabIndex = 0;
        this.viewerContainer.style.outline = 'none';
        this.pageContainer = createElement('div', { id: this.owner.containerId + '_pageContainer', className: 'e-de-background' });
        this.viewerContainer.appendChild(this.pageContainer);
        this.pageContainer.style.top = '0px';
        this.pageContainer.style.left = '0px';
        this.pageContainer.style.position = 'relative';
        this.pageContainer.style.pointerEvents = 'none';
        if (Browser.isDevice) {
            this.createEditableDiv(element);
        }
        else {
            this.createEditableIFrame();
        }
        if (this.owner.enableImageResizerMode) {
            this.owner.imageResizerModule.initializeImageResizer();
        }
        this.updateViewerSizeInternal(element);
        this.layout = new Layout(this);
        this.textHelper = new TextHelper(this);
        this.zoomModule = new Zoom(this);
        this.initTouchEllipse();
        this.wireEvent();
        this.restrictEditingPane = new RestrictEditing(this);
        this.owner.commentReviewPane = new CommentReviewPane(this.owner);
        this.owner.trackChangesPane = new TrackChangesPane(this.owner, this.owner.commentReviewPane);
        createSpinner({ target: this.owner.element, cssClass: 'e-spin-overlay' });
    }
    measureScrollbarWidth(element) {
        const parentDiv = document.createElement('div');
        parentDiv.setAttribute('style', 'visibility:hidden;overflow:scroll');
        element.appendChild(parentDiv);
        const childDiv = document.createElement('div');
        parentDiv.appendChild(childDiv);
        this.scrollbarWidth = (parentDiv.getBoundingClientRect().width - childDiv.getBoundingClientRect().width);
        parentDiv.parentNode.removeChild(parentDiv);
    }
    createEditableDiv(element) {
        this.editableDiv = document.createElement('div');
        this.editableDiv.contentEditable = 'true';
        this.editableDiv.style.position = 'fixed';
        this.editableDiv.style.left = '-150em';
        this.editableDiv.style.width = '100%';
        this.editableDiv.style.height = '100%';
        this.editableDiv.id = element.id + '_editableDiv';
        document.body.appendChild(this.editableDiv);
    }
    createEditableIFrame() {
        this.iframe = createElement('iframe', {
            attrs: {
                'scrolling': 'no',
                'style': 'pointer-events:none;position:absolute;left:0px;top:0px;outline:none;background-color:transparent;width:0px;height:0px;overflow:hidden'
            },
            className: 'e-de-text-target'
        });
        this.viewerContainer.appendChild(this.iframe);
        this.initIframeContent();
    }
    initIframeContent() {
        const style = 'background-color:transparent;width:100%;height:100%;padding: 0px; margin: 0px;';
        const innerHtml = '<!DOCTYPE html>'
            + '<html><head></head>'
            + '<body spellcheck="false" style=' + style + ' >'
            + '<div contenteditable="true" style=' + style + '></div>'
            + '</body>'
            + '</html>';
        if (!isNullOrUndefined(this.iframe.contentDocument)) {
            this.iframe.contentDocument.open();
            this.iframe.contentDocument.write(innerHtml);
            this.iframe.contentDocument.close();
            this.editableDiv = this.iframe.contentDocument.body.children[0];
        }
    }
    /**
     * Wires events and methods.
     *
     * @returns {void}
     */
    wireEvent() {
        if (!isNullOrUndefined(this.selection)) {
            this.selection.initCaret();
        }
        this.wireInputEvents();
        if (!isNullOrUndefined(this.iframe)) {
            this.iframe.addEventListener('load', this.onIframeLoad.bind(this));
        }
        this.viewerContainer.addEventListener('scroll', this.scrollHandler);
        this.viewerContainer.addEventListener('mousedown', this.onMouseDownInternal);
        this.viewerContainer.addEventListener('keydown', this.onKeyDownInternal);
        this.viewerContainer.addEventListener('mousemove', this.onMouseMoveInternal);
        this.viewerContainer.addEventListener('mouseleave', this.onMouseLeaveInternal);
        this.viewerContainer.addEventListener('mouseenter', this.onMouseEnterInternal);
        this.viewerContainer.addEventListener('contextmenu', this.onContextMenu);
        this.viewerContainer.addEventListener('dblclick', this.onDoubleTap);
        this.viewerContainer.addEventListener('mouseup', this.onMouseUpInternal);
        window.addEventListener('resize', this.onWindowResize);
        window.addEventListener('keyup', this.onKeyUpInternal);
        window.addEventListener('mouseup', this.onImageResizer.bind(this));
        window.addEventListener('touchend', this.onImageResizer.bind(this));
        this.viewerContainer.addEventListener('touchstart', this.onTouchStartInternal);
        this.viewerContainer.addEventListener('touchmove', this.onTouchMoveInternal);
        this.viewerContainer.addEventListener('touchend', this.onTouchUpInternal);
        if (navigator.userAgent.match('Firefox')) {
            this.viewerContainer.addEventListener('DOMMouseScroll', this.zoomModule.onMouseWheelInternal.bind(this));
        }
        this.viewerContainer.addEventListener('mousewheel', this.zoomModule.onMouseWheelInternal.bind(this));
    }
    wireInputEvents() {
        if (isNullOrUndefined(this.editableDiv)) {
            return;
        }
        this.editableDiv.addEventListener('paste', this.onPaste);
        if (!Browser.isDevice) {
            this.editableDiv.addEventListener('keypress', this.onKeyPressInternal);
            if (Browser.info.name === 'chrome') {
                this.editableDiv.addEventListener('textInput', this.onTextInput);
            }
        }
        else {
            this.editableDiv.addEventListener('input', this.onTextInputInternal);
        }
        this.editableDiv.addEventListener('blur', this.onFocusOut);
        this.editableDiv.addEventListener('keydown', this.onKeyDownInternal);
        this.editableDiv.addEventListener('compositionstart', this.compositionStart);
        this.editableDiv.addEventListener('compositionupdate', this.compositionUpdated);
        this.editableDiv.addEventListener('compositionend', this.compositionEnd);
    }
    onIframeLoad() {
        if (!isNullOrUndefined(this.iframe) && this.iframe.contentDocument.body.children.length === 0) {
            this.initIframeContent();
            this.wireInputEvents();
        }
    }
    getEditableDivTextContent() {
        return this.editableDiv.textContent;
    }
    updateAuthorIdentity() {
        const revisions = this.owner.revisions.changes;
        for (let i = 0; i < revisions.length; i++) {
            this.getAuthorColor(revisions[i].author);
        }
    }
    getAvatar(userInfo, userName, comment, revision) {
        let author;
        let userinitial;
        if (!isNullOrUndefined(comment)) {
            author = comment.author;
            userinitial = comment.initial;
        }
        else {
            author = revision.author;
        }
        if (!isNullOrUndefined(author)) {
            const avatarDiv = createElement('div', { className: 'e-de-cmt-avatar' });
            const avatar = createElement('div', { className: 'e-de-ff-cmt-avatar' });
            avatar.style.backgroundColor = this.owner.documentHelper.getAuthorColor(author);
            if (userinitial === '' || isNullOrUndefined(userinitial)) {
                const authorName = author.split(' ');
                let initial = authorName[0].charAt(0);
                if (authorName.length > 1) {
                    initial += authorName[authorName.length - 1][0];
                }
                avatar.innerText = initial.toUpperCase();
            }
            else {
                if (userinitial.length > 2) {
                    avatar.innerText = userinitial.substring(0, 2);
                }
                else {
                    avatar.innerText = userinitial;
                }
            }
            avatarDiv.appendChild(avatar);
            avatarDiv.appendChild(userName);
            userInfo.appendChild(avatarDiv);
        }
    }
    /**
     * @private
     * @param {string} author - Specifies author name.
     * @returns {string} - Return autor color.
     */
    getAuthorColor(author) {
        if (this.authors.containsKey(author)) {
            return this.authors.get(author);
        }
        let color;
        if (this.authors.length === 0) {
            color = '#b5082e'; //dark red
        }
        else {
            color = this.generateRandomColor();
        }
        this.authors.add(author, color);
        return color;
    }
    generateRandomColor() {
        const userColors = ['#b5082e',
            '#2e97d3',
            '#bb00ff',
            '#f37e43',
            '#03a60b',
            '#881824',
            '#e09a2b',
            '#50565e']; //dark grey
        return userColors[(this.authors.length % 8)];
    }
    /**
     * @private
     * @returns {void}
     */
    positionEditableTarget() {
        const point = this.selection.getRect(this.selection.start);
        const page = this.selection.getSelectionPage(this.selection.start);
        // const caretInfo: CaretHeightInfo = this.selection.updateCaretSize(this.owner.selection.start);
        const sectionFormat = page.bodyWidgets[0].sectionFormat;
        const left = page.boundingRectangle.x + (HelperMethods.convertPointToPixel(sectionFormat.leftMargin) * this.zoomFactor);
        const top = point.y;
        const pageWidth = sectionFormat.pageWidth - sectionFormat.leftMargin - sectionFormat.rightMargin;
        let iframeStyle = 'left:' + left + 'px;';
        iframeStyle += 'top:' + top + 'px;';
        iframeStyle += 'width:' + (HelperMethods.convertPointToPixel(pageWidth) * this.zoomFactor) + 'px;';
        iframeStyle += 'height:250px;outline-style:none;position:absolute';
        this.iframe.setAttribute('style', iframeStyle);
        let style = 'background-color:transparent;width:100%;height:250px;padding: 0px; margin: 0px;';
        style += 'text-indent:' + (point.x - left) + 'px;';
        style += 'color:transparent;pointer-events:none;outline-style:none;';
        style += 'font-size:' + (HelperMethods.convertPointToPixel(this.selection.characterFormat.fontSize) * this.zoomFactor) + 'px;';
        style += 'font-family' + this.selection.characterFormat.fontFamily + ';';
        style += 'overflow:hidden;text-decoration:none;white-space:normal;';
        this.editableDiv.setAttribute('style', style);
    }
    /* eslint-disable @typescript-eslint/no-explicit-any */
    onImageResizer(args) {
        if (!isNullOrUndefined(this.owner) && !isNullOrUndefined(this.owner.imageResizerModule) &&
            this.owner.imageResizerModule.isImageResizerVisible && this.owner.imageResizerModule.isImageResizing) {
            if (args instanceof MouseEvent) {
                this.onMouseUpInternal(args);
            }
            else if (args instanceof TouchEvent) {
                this.onTouchUpInternal(args);
            }
        }
        if (this.scrollMoveTimer) {
            this.isMouseEntered = true;
            clearInterval(this.scrollMoveTimer);
        }
    }
    initDialog(isRtl) {
        if (!this.dialogInternal) {
            this.dialogTarget1 = createElement('div', { className: 'e-de-dlg-target' });
            this.dialogTarget1.contentEditable = 'false';
            document.body.appendChild(this.dialogTarget1);
            if (isRtl) {
                this.dialogTarget1.classList.add('e-de-rtl');
            }
            this.dialogInternal = new Dialog({
                target: document.body, showCloseIcon: true,
                allowDragging: true, enableRtl: isRtl, visible: false,
                width: '1px', isModal: true, position: { X: 'center', Y: 'center' }, zIndex: this.owner.zIndex + 20,
                animationSettings: { effect: 'None' }
            });
            this.dialogInternal.isStringTemplate = true;
            this.dialogInternal.open = this.selection.hideCaret;
            this.dialogInternal.beforeClose = this.updateFocus;
            this.dialogInternal.appendTo(this.dialogTarget1);
        }
    }
    initDialog3(isRtl) {
        if (!this.dialogInternal3) {
            this.dialogTarget3 = createElement('div', { className: 'e-de-dlg-target' });
            this.dialogTarget3.contentEditable = 'false';
            document.body.appendChild(this.dialogTarget3);
            if (isRtl) {
                this.dialogTarget3.classList.add('e-de-rtl');
            }
            this.dialogInternal3 = new Dialog({
                target: document.body, showCloseIcon: true,
                allowDragging: true, enableRtl: isRtl, visible: false,
                width: '1px', isModal: true, position: { X: 'center', Y: 'center' }, zIndex: this.owner.zIndex,
                animationSettings: { effect: 'None' }
            });
            this.dialogInternal3.isStringTemplate = true;
            this.dialogInternal3.open = this.selection.hideCaret;
            this.dialogInternal3.beforeClose = this.updateFocus;
            this.dialogInternal3.appendTo(this.dialogTarget3);
        }
    }
    hideDialog() {
        this.dialog.hide();
        this.updateFocus();
    }
    initDialog2(isRtl) {
        if (!this.dialogInternal2) {
            this.dialogTarget2 = createElement('div', { className: 'e-de-dlg-target' });
            this.dialogTarget2.contentEditable = 'false';
            document.body.appendChild(this.dialogTarget2);
            if (isRtl) {
                this.dialogTarget2.classList.add('e-de-rtl');
            }
            this.dialogInternal2 = new Dialog({
                target: document.body, showCloseIcon: true,
                allowDragging: true, enableRtl: isRtl, visible: false,
                width: '1px', isModal: true, position: { X: 'center', Y: 'Top' }, zIndex: this.owner.zIndex + 10
            });
            this.dialogInternal2.isStringTemplate = true;
            this.dialogInternal2.appendTo(this.dialogTarget2);
        }
    }
    /**
     * Clears the context.
     *
     * @private
     * @returns {void}
     */
    clearContent() {
        this.containerContext.clearRect(0, 0, this.containerCanvas.width, this.containerCanvas.height);
        this.selectionContext.clearRect(0, 0, this.selectionCanvas.width, this.selectionCanvas.height);
        // Hide comment mark
        if (this.pageContainer) {
            const commentMarkElement = this.pageContainer.getElementsByClassName('e-de-cmt-mark');
            for (let i = 0; i < commentMarkElement.length; i++) {
                commentMarkElement[i].style.display = 'none';
            }
        }
        if (this.pageContainer) {
            co