﻿using System;
using System.Collections.ObjectModel;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;

namespace CarouselBugTest
{
    public class MainWindowViewModel : BaseViewModel
    {
        public ObservableCollection<ItemViewModel> MenuOptions { get; private set; } = new();

        public int CollectionSize
        {
            get { return (int)GetValue(CollectionSizeProperty); }
            set { SetValue(CollectionSizeProperty, value); }
        }
        public static readonly DependencyProperty CollectionSizeProperty =
            DependencyProperty.Register(nameof(CollectionSize), typeof(int), typeof(MainWindowViewModel),  new PropertyMetadata(7, new PropertyChangedCallback(OnCollectionSizeChanged)));
        
        public int SelectedIndex
        {
            get { return (int)GetValue(SelectedIndexProperty); }
            set { SetValue(SelectedIndexProperty, value); }
        }
        public static readonly DependencyProperty SelectedIndexProperty =
            DependencyProperty.Register(nameof(SelectedIndex), typeof(int), typeof(MainWindowViewModel), new PropertyMetadata(0));

        public int ItemsPerPage
        {
            get { return (int)GetValue(ItemsPerPageProperty); }
            set { SetValue(ItemsPerPageProperty, value); }
        }
        public static readonly DependencyProperty ItemsPerPageProperty =
            DependencyProperty.Register(nameof(ItemsPerPage), typeof(int), typeof(MainWindowViewModel), new PropertyMetadata(5));

        public ICommand SelectItemCommand { get; private set; }

        private static readonly Random _rnd = new Random();

        public MainWindowViewModel()
        {
            SelectItemCommand = new RelayParameterizedCommand((index) => SelectedIndex = int.Parse(index?.ToString() ?? "0"));

            MenuOptions = new ObservableCollection<ItemViewModel>()
            {
                new ItemViewModel(Colors.Red, "0", 0),
                new ItemViewModel(Colors.Blue, "1", 1),
                new ItemViewModel(Colors.Aqua, "2", 2),
                new ItemViewModel(Colors.Orange, "3", 3),
                new ItemViewModel(Colors.Purple, "4", 4),
                new ItemViewModel(Colors.SlateBlue, "5", 5),
                new ItemViewModel(Colors.Tomato, "6", 6)
            };
        }

        private static void OnCollectionSizeChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            if (d is MainWindowViewModel vm)
            {
                int newVal = (int)e.NewValue;
                int oldVal = (int)e.OldValue;
                if (newVal < oldVal)
                {
                    while (vm.MenuOptions.Count > newVal)
                    {
                        vm.MenuOptions.RemoveAt(vm.MenuOptions.Count - 1);
                    }
                } else if (newVal > oldVal)
                {
                    while (vm.MenuOptions.Count < newVal)
                    {
                        vm.MenuOptions.Add(new ItemViewModel(Color.FromRgb((byte)_rnd.Next(256), (byte)_rnd.Next(256), (byte)_rnd.Next(256)), vm.MenuOptions.Count.ToString(), vm.MenuOptions.Count));
                    }
                }
            }
        }
    }
}
