﻿using System.Windows;
using System.Windows.Media;

namespace CarouselBugTest
{
    public class ItemViewModel : BaseViewModel
    {
        public SolidColorBrush FillColor
        {
            get { return (SolidColorBrush)GetValue(ColorProperty); }
            set { SetValue(ColorProperty, value); }
        }
        public static readonly DependencyProperty ColorProperty =
            DependencyProperty.Register(nameof(FillColor), typeof(SolidColorBrush), typeof(ItemViewModel), new PropertyMetadata(null));

        public string Id
        {
            get { return (string)GetValue(IdProperty); }
            set { SetValue(IdProperty, value); }
        }
        public static readonly DependencyProperty IdProperty =
            DependencyProperty.Register(nameof(Id), typeof(string), typeof(ItemViewModel), new PropertyMetadata(string.Empty));



        public int Index
        {
            get { return (int)GetValue(IndexProperty); }
            set { SetValue(IndexProperty, value); }
        }

        // Using a DependencyProperty as the backing store for Index.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty IndexProperty =
            DependencyProperty.Register(nameof(Index), typeof(int), typeof(ItemViewModel), new PropertyMetadata(0));



        public ItemViewModel(Color color, string id, int index)
        {
            FillColor = new SolidColorBrush(color);
            Id = id;
            Index = index;
        }

        public override string? ToString()
        {
            return Id;
        }
    }
}
