import { render } from 'react-dom';
import './index.css';
import * as React from 'react';
import {
  TabComponent,
  TabItemDirective,
  TabItemsDirective,
  TabItemModel
} from "@syncfusion/ej2-react-navigations";
import { ButtonComponent } from "@syncfusion/ej2-react-buttons";

export const Default = () => {
  const tabHeaderCounter = React.useRef(1);
  const tabContentCounter = React.useRef(1);
  const addTabCounter = React.useRef(0);
  const tabComponentRef = React.createRef();

  const componentContent = () => {
      return (
        <h1>{"Content " + tabContentCounter.current++}</h1>
      );
  };

  const headerContent = () => {    
    return (
      <React.Fragment>
        <span>{"Header " + tabHeaderCounter.current++}</span>
      </React.Fragment>
    );
  }

  const addComponentTab = () => {
    const newTabItem = {
      //header: { text: '' },
      headerTemplate: headerContent,
      content: componentContent
    }

    tabComponentRef.current.addTab([newTabItem], addTabCounter.current++);
  };

  return(
    <div>
        <div>
<ButtonComponent onClick={addComponentTab}>Add tab with component header and content</ButtonComponent>&nbsp;
    </div>
      <div>
<TabComponent ref={tabComponentRef} heightAdjustMode='Auto'>
    <TabItemsDirective />
  </TabComponent>
  </div>

  </div>
  );
};

render(<Default />, document.getElementById('sample'));
