﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;

namespace CarouselBugTest
{
    public class MainVindowViewModel : BaseViewModel
    {
        private enum Collection { A, B }
        
        private Collection _selectedCollection = Collection.A;

        private readonly List<ItemViewModel> _itemsA = new();
        private readonly List<ItemViewModel> _itemsB = new();

        public ObservableCollection<ItemViewModel> MenuOptions { get; private set; } = new();

        public ItemViewModel? SelectedMenuOption
        {
            get { return (ItemViewModel?)GetValue(SelectedMenuOptionProperty); }
            set { SetValue(SelectedMenuOptionProperty, value); }
        }
        public static readonly DependencyProperty SelectedMenuOptionProperty =
            DependencyProperty.Register(nameof(SelectedMenuOption), typeof(ItemViewModel), typeof(MainVindowViewModel), new PropertyMetadata(defaultValue: null));

        public ICommand SelectItemCommand { get; private set; }
        public ICommand SwitchCollectionCommand { get; private set; }

        public MainVindowViewModel()
        {
            _itemsA.Add(new ItemViewModel(Colors.Red, "0A"));
            _itemsA.Add(new ItemViewModel(Colors.Blue, "1A"));
            _itemsA.Add(new ItemViewModel(Colors.Aqua, "2A"));
            _itemsA.Add(new ItemViewModel(Colors.Orange, "3A"));
            _itemsA.Add(new ItemViewModel(Colors.Purple, "4A"));
            _itemsA.Add(new ItemViewModel(Colors.SlateBlue, "5A"));
            _itemsA.Add(new ItemViewModel(Colors.Tomato, "6A"));

            _itemsB.Add(new ItemViewModel(Colors.Red, "0B"));
            _itemsB.Add(new ItemViewModel(Colors.Blue, "1B"));
            _itemsB.Add(new ItemViewModel(Colors.Aqua, "2B"));
            _itemsB.Add(new ItemViewModel(Colors.Orange, "3B"));
            _itemsB.Add(new ItemViewModel(Colors.Purple, "4B"));
            _itemsB.Add(new ItemViewModel(Colors.SlateBlue, "5B"));
            _itemsB.Add(new ItemViewModel(Colors.Tomato, "6B"));

            SelectItemCommand = new RelayParameterizedCommand((index) => SelectedMenuOption = MenuOptions[int.Parse(index.ToString())]);
            SwitchCollectionCommand = new RelayCommand(() => {
                int indexToSelect = MenuOptions.IndexOf(SelectedMenuOption);
                LoadMenu(_selectedCollection == Collection.A ? Collection.B : Collection.A, indexToSelect);
            });

            LoadMenu(Collection.A);
        }

        private void LoadMenu(Collection collection, int? selectAfterLoad = null)
        {
            MenuOptions = new ObservableCollection<ItemViewModel>(collection == Collection.A ? _itemsA : _itemsB);
            OnPropertyChanged(nameof(MenuOptions));
            _selectedCollection = collection;

            if (selectAfterLoad.HasValue)
            {
                SelectedMenuOption = MenuOptions[selectAfterLoad.Value];
            }
            else
            {
                if (MenuOptions.Count > 0)
                    SelectedMenuOption = MenuOptions[0];
            }
        }
    }
}
