﻿using System.Windows;
using System.Windows.Media;

namespace CarouselBugTest
{
    public class ItemViewModel : BaseViewModel
    {
        public SolidColorBrush FillColor
        {
            get { return (SolidColorBrush)GetValue(ColorProperty); }
            set { SetValue(ColorProperty, value); }
        }
        public static readonly DependencyProperty ColorProperty =
            DependencyProperty.Register(nameof(FillColor), typeof(SolidColorBrush), typeof(ItemViewModel), new PropertyMetadata(null));

        public string Id
        {
            get { return (string)GetValue(IdProperty); }
            set { SetValue(IdProperty, value); }
        }
        public static readonly DependencyProperty IdProperty =
            DependencyProperty.Register(nameof(Id), typeof(string), typeof(ItemViewModel), new PropertyMetadata(string.Empty));

        public ItemViewModel(Color color, string id)
        {
            FillColor = new SolidColorBrush(color);
            Id = id;
        }
    }
}
