﻿
using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Input;
using Syncfusion.Pdf.Parsing;
using Syncfusion.Windows.PdfViewer;

namespace SyncfusionBugTestBed
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private int DaIndex = 0;
        private PdfLoadedDocument pdf1;
        private PdfLoadedDocument pdf2;
        public MainWindow()
        {
            InitializeComponent();

            pdf1 = new PdfLoadedDocument("test.pdf");
            pdf2 = new PdfLoadedDocument("test.pdf");

            PDFView.CurrentPageChanged += PdfDocumentViewOnCurrentPageChanged;

            PDFView.Load(pdf1);

            PageDownButton.Click += (sender, args) =>
            {
                if (PDFView.CurrentPageIndex > 0)
                {
                    PDFView.GoToPreviousPage();
                }
            };

            PageUpButton.Click += (sender, args) =>
            {
                if (PDFView.CurrentPageIndex < PDFView.PageCount)
                {
                    PDFView.GoToNextPage();
                }
            };

        }

        private void PdfDocumentViewOnCurrentPageChanged(object sender, EventArgs args)
        {
            PdfDocumentView view = (PdfDocumentView)sender;
            PageDisplayLabel.Content = $"Page {view.CurrentPageIndex} / {view.PageCount}";
        }

        private void LoadButton_OnClick(object sender, RoutedEventArgs e)
        {
            PDFView.Load(pdf2);
        }
    }
}