using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace DropDownDataSource.Data
{
    public class WeatherForecastService
    {
        private static readonly string[] Summaries = new[]
        {
            "Freezing", "Bracing", "Chilly", "Cool", "Mild", "Warm", "Balmy", "Hot", "Sweltering", "Scorching"
        };

        public Task<WeatherForecast[]> GetForecastAsync(DateTime startDate)
        {
            var rng = new Random();
            return Task.FromResult(Enumerable.Range(1, 5).Select(index => new WeatherForecast
            {
                Date = startDate.AddDays(index),
                TemperatureC = rng.Next(-20, 55),
                Summary = Summaries[rng.Next(Summaries.Length)]
            }).ToArray());
        }

        public Task<Result> GetSpareNamesAsync()
        {
            var name = new Result() { Data = new SpareNameViewModel().getData(), IsSuccess = true };
            return Task.FromResult(name);
        }
    }

    public class SpareNameViewModel
    {
        public object Id { get; set; }

        public string Name { get; set; }

        public Boolean IsSuccess { get; set; } = true;

        public IEnumerable<SpareNameViewModel> getData() {
            List<SpareNameViewModel> list = new List<SpareNameViewModel>();
            list.Add(new SpareNameViewModel() { Name = "Australia", Id = 1 });
            list.Add(new SpareNameViewModel() { Name = "Bermuda", Id = 2 });
            list.Add(new SpareNameViewModel() { Name = "Canada", Id = 3 });
            list.Add(new SpareNameViewModel() { Name = "Cameroon", Id = 4 });
            return list;
        }
    }

    public class Result 
    {
        public IEnumerable<SpareNameViewModel> Data { get; set; }
        public bool IsSuccess { get; set; }
    }
}
