﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace TestBlazor.Data
{
    public static class TestClass
    {
        private const int BatchDeleteMaxRetriesNumber = 3;
        private const int ResorceNotFoundFailedItemErrorIndex = -1;
        private const int ResorceNotFoundMessageFailedItemIndexKey = 0;
        private const int ResorceNotFoundMessagePartsCount = 2;
        private const char ResorceNotFoundMessageSplitter = ':';
        private const string ResorceNotFoundMessage = "The specified resource does not exist";

        public static async Task BatchDeleteEntities()
        {
            int currentRetry = 0;
            int deletionStartIndex = 0;

            while (currentRetry < BatchDeleteMaxRetriesNumber)
            {
                try
                {
                    int d = 0;

                    throw new OutOfMemoryException("The specified resource does not exist.");

                    return;
                }
                catch (ArgumentNullException storageEx)
                {
                    // sometimes the whole batch operation could fail because of 1 item
                    // retry batch operation execution starting with the next item after failed one
                    if (storageEx.Message.Contains(ResorceNotFoundMessage, StringComparison.OrdinalIgnoreCase))
                    {
                        int failedIndex = GetFailedItemIndex(storageEx.Message);

                        if (failedIndex == ResorceNotFoundFailedItemErrorIndex)
                        {
                            throw;
                        }

                        deletionStartIndex = failedIndex + 1;
                        currentRetry++;

                        if (currentRetry >= BatchDeleteMaxRetriesNumber)
                        {
                            throw;
                        }
                        else
                        {
                            System.Diagnostics.Debug.WriteLine($"AzureDBStorageService.BatchDeleteEntities, batch operation failed with message {storageEx.Message}, retrying {currentRetry}");

                            continue;
                        }
                    }

                    throw;
                }
                catch (Exception)
                {
                    throw;
                }
            }

            int g = 0;
        }

        private static int GetFailedItemIndex(string exceptionMessage)
        {
            if (string.IsNullOrEmpty(exceptionMessage))
            {
                return ResorceNotFoundFailedItemErrorIndex;
            }

            string[] messageParts = exceptionMessage.Split(ResorceNotFoundMessageSplitter);

            if (messageParts?.Length != ResorceNotFoundMessagePartsCount)
            {
                return ResorceNotFoundFailedItemErrorIndex;
            }

            if (int.TryParse(messageParts[ResorceNotFoundMessageFailedItemIndexKey], out int failedItemIndex))
            {
                return failedItemIndex;
            }

            return ResorceNotFoundFailedItemErrorIndex;
        }

    }
}
