﻿using System;
using System.IO;
using Syncfusion.Drawing;
using Syncfusion.Pdf.Graphics;
using Syncfusion.Pdf.Parsing;
using Syncfusion.Pdf.Security;

namespace CertTest
{
    class Program
    {
        private const string LicenseKey = "INSERT LICENSE KEY HERE";
        
        static void Main(string[] args)
        {
            var certs = new[] { "ananta", "setiawan.yudi" };
            var filename = "GIBTHA";
            
            var pdfIn = @$"..\..\..\doc\{filename}.pdf";
            
            var i = 1;
            var x = 10;
            var y = 80;
            foreach (var cert in certs)
            {
                var pdfOut = @$"..\..\..\doc\{filename}-signed{i}.pdf";
                var pfx = @$"..\..\..\client\{cert}.pfx";
                DoSign(i, pdfIn, pdfOut, pfx, "test", x, y);
                pdfIn = pdfOut; // for next signer
                
                y += 30;
                i++;
            }
        }
        
        static void DoSign(int seq, string pdfIn, string pdfOut, string pfx, string pfxPass, int x, int y)
        {
            Syncfusion.Licensing.SyncfusionLicenseProvider.RegisterLicense(LicenseKey);
            
            using var inStream = File.OpenRead(pdfIn);
            using var outStream = File.Create(pdfOut);
            using var pfxStream = File.OpenRead(pfx);

            //Load existing PDF document.
            PdfLoadedDocument document = new PdfLoadedDocument(inStream);
 
            //Load digital ID with password.
            PdfCertificate certificate = new PdfCertificate(pfxStream, pfxPass);
 
            //Create a signature with loaded digital ID.
            PdfSignature signature = new PdfSignature(document, document.Pages[0], certificate, "DS_" + seq);
            
            //Set bounds to the signature.
            signature.Bounds = new RectangleF(x, y, 180, 60);
            signature.Certificated = false;

            signature.Appearance.Normal.Graphics.DrawString("Digitally Signed by " + certificate.SubjectName, new PdfStandardFont(PdfFontFamily.Helvetica, 10), PdfBrushes.Red, 0, 0);
            
            //Save the PDF document.
            document.Save(outStream);
        }
    }
}